# News - 15 series

(release-15-1-4)=

## Release 15.1.4 - 2025-07-29

In this release, we fixed a bug in the interval calculation between phrases in `*ONPP` operator.

### Improvements

#### [Ordered near phrase product search] Fixed a bug in the interval calculation between phrases

This problem may occur when we use `*ONPP` with `MAX_ELEMENT_INTERVAL` such as `*ONPP-1,0,10"(abc bcd) (defg)"`.
If you don't use `MAX_ELEMENT_INTERVAL`, this problem doesn't occur.

Please refer to the following links for usage and syntax of `*ONPP`.

- [`*ONPP` in query syntax] {ref}`query-syntax-ordered-near-phrase-product-search-condition`
- [`*ONPP` in script syntax] {ref}`script-syntax-ordered-near-phrase-product-search-operator`

If this problem occurs, the following things may happen.

- Groonga may return records that shouldn't be matched.
- Groonga may not return records that should be matched.

(release-15-1-3)=

## Release 15.1.3 - 2025-07-18

### Improvements

#### [Apache Arrow] Added support for Apache Arrow C++ 21.0.0

(release-15-1-2)=

## Release 15.1.2 - 2025-07-07

### Improvements

#### [Windows] Drop support for Groonga package that is built with Visual Studio 2019

We don't provide the following packages since this release.

- groonga-xx.x.x-x64-vs2019.zip
- groonga-xx.x.x-x64-vs2019-with-vcruntime.zip

### Fixes

#### [Near phrase search] Fixed a bug that interval between phrases calculation

This problem may occur when we use `*NP`, `*NPP`, or `*ONP` with `MAX_ELEMENT_INTERVAL` as below.

- `*NP-1,0,12"abc ef"`
- `*NPP-1,0,10"(abc bcd) (ef)"`
- `*ONP-1,0,5|6 "abc defghi jklmnop"`

If you don't use `MAX_ELEMENT_INTERVAL`, this problem doesn't occur.

Please refer to the following links about usage and syntax of `*NP`, `*NPP`, or `*ONP`.

- [`*NP` in query syntax] {ref}`query-syntax-near-phrase-search-condition`
- [`*NP` in script syntax] {ref}`script-syntax-near-phrase-search-operator`
- [`*NPP` in query syntax] {ref}`query-syntax-near-phrase-product-search-condition`
- [`*NPP` in script syntax] {ref}`script-syntax-near-phrase-product-search-operator`
- [`*ONP` in query syntax] {ref}`query-syntax-ordered-near-phrase-search-condition`
- [`*ONP` in script syntax] {ref}`script-syntax-ordered-near-phrase-search-operator`

If this problem occurs, the following things may happen.

- Groonga may return records shouldn't be a hit.
- Groonga may not return records that should be returned as hits.

(release-15-1-1)=

## Release 15.1.1 - 2025-06-02

This release updates TokenMecab to preserve user-defined entries with spaces as
single tokens.

### Improvements

#### {doc}`/reference/tokenizers/token_mecab`: Fix unintended splitting of user-defined entries with spaces

Previously, {ref}`token-mecab` split user-defined entries containing spaces
(e.g., "search engine") into separate tokens ("search" and "engine"). This
release fixes this issue, so entries with embedded spaces are now preserved and
handled as single tokens like "search engine" as follows.

```
tokenize TokenMecab "search engine" --output_pretty yes
[
  [
    0,
    1748413131.972704,
    0.0003032684326171875
  ],
  [
    {
      "value": "search engine",
      "position": 0,
      "force_prefix": false,
      "force_prefix_search": false
    }
  ]
]
```

### Fixes

#### Fixed many typos in documentation

[GH-2332](https://github.com/groonga/groonga/pull/2332),
[GH-2333](https://github.com/groonga/groonga/pull/2333),
[GH-2334](https://github.com/groonga/groonga/pull/2334),
[GH-2335](https://github.com/groonga/groonga/pull/2335),
[GH-2336](https://github.com/groonga/groonga/pull/2336),
[GH-2337](https://github.com/groonga/groonga/pull/2337),
[GH-2338](https://github.com/groonga/groonga/pull/2338)

Patched by Vasilii Lakhin.

### Thanks

- Vasilii Lakhin

(release-15-0-9)=

## Release 15.0.9 - 2025-05-08

This release adds the tokenizer's option to make token inspection simpler and
improves negative-division semantics for unsigned integer.

### Improvements

#### {doc}`/reference/commands/tokenize`/{doc}`/reference/commands/table_tokenize`: Added {ref}`tokenize-output-style` option

This {ref}`tokenize-output-style` option to the
{doc}`/reference/commands/tokenize`/{doc}`/reference/commands/table_tokenize`
command makes it easier to focus on the tokens when you don’t need the full
attribute set.

Here is example of using {ref}`tokenize-output-style` option.

```
tokenize TokenNgram "Fulltext Search" --output_style simple
[
  [
    0,
    1746573056.540744,
    0.0007045269012451172
  ],
  [
    "Fu",
    "ul",
    "ll",
    "lt",
    "te",
    "ex",
    "xt",
    "t ",
    " S",
    "Se",
    "ea",
    "ar",
    "rc",
    "ch",
    "h"
  ]
]
```

#### Clarified `X / negative value` semantics

Previously, only dividing `X` by `-1`/`1.0` returns `-X` for unsigned integers.
From this release, dividing by any negative value will yield the mathematically
expected negative result as follows.

- Before: `X / -2` might not return `-(X / 2)`.
- After: `X / -2` always returns `-(X / 2)`.

This is a backward incompatible change but we assume that no user depends on
this behavior.

(release-15-0-4)=

## Release 15.0.4 - 2025-03-29

### Improvements

#### Clarified `X / -1` and `X / -1.0` semantics

In many languages, `X / -1` and `X / -1.0` return `-X`. But Groonga
may not return `-X` when `X` is unsigned integer.

`X / -1` and `X / -1.0` always return `-X` from this release.

This is a backward incompatible change but we assume that no user
depends on this behavior.

(release-15-0-3)=

## Release 15.0.3 - 2025-03-10

### Improvements

#### {ref}`offline-index-construction`: Added support for parallel construction with {ref}`table-hash-key` lexicon

Parallel offline index construction iterates sorted terms
internally. {ref}`table-pat-key` and {ref}`table-pat-key` can do it
effectively because they are based on tree. But {ref}`table-hash-key`
can't do it effectively because it's not based on tree. So we didn't
support parallel offline index construction with
{ref}`table-hash-key` lexicon.

This release adds support for parallel offline index construction with
{ref}`table-hash-key` lexicon. It sort terms in a normal way. So it's
not so effective. Parallel offline index construction with
{ref}`table-hash-key` lexicon will be slower than
{ref}`table-pat-key`/{ref}`table-dat-key`. But it may be faster than
sequential offline index construction with {ref}`table-hash-key`
lexicon.

(release-15-0-2)=

## Release 15.0.2 - 2025-02-21

### Fixes

#### {ref}`offline-index-construction`: Fixed a bug that options may be ignored in parallel construction

Groonga may ignore options of {doc}`/reference/normalizers`,
{doc}`/reference/tokenizers` and/or {doc}`/reference/token_filters` in
the target index when offline index construction is executed in
parallel.

This issue may occur when:

- Offline index construction is executed in parallel.
- {doc}`/reference/normalizers`, {doc}`/reference/tokenizers`, and/or
  {doc}`/reference/token_filters` options are used.

If {doc}`/reference/normalizers/normalizer_table` is used and this
happens, the offline index construction is failed. Because
{doc}`/reference/normalizers/normalizer_table` has a required
parameter. If options are ignored, the required parameter is missing.

(release-15-0-1)=

## Release 15.0.1 - 2025-02-20

### Improvements

#### [{doc}`/install/ubuntu`] Dropped support for Ubuntu 20.04 (Focal Fossa)

Ubuntu 20.04 will reach EOL in May 2025, so support for it has been dropped
starting with this release.

(release-15-0-0)=

## Release 15.0.0 - 2025-02-09

This is our annual major release! This release doesn't have any
backward incompatible changes! So you can upgrade Groonga without
migrating your existing databases. You can still use your existing
databases as-is.

### Improvements

#### {ref}`table-pat-key`: Added support for {ref}`builtin-type-float32` as key type

[GH-2211](https://github.com/groonga/groonga/issues/2211)

{ref}`table-pat-key` encodes/decodes numeric keys for fast search
internally. So {ref}`table-pat-key` must know how to encode/decode
keys. {ref}`table-pat-key` didn't know how to encode/decode
{ref}`builtin-type-float32` before this release. Now,
{ref}`table-pat-key` can encode/decode {ref}`builtin-type-float32`. So
you can use {ref}`builtin-type-float32` as a {ref}`table-pat-key` key
type like other numeric types such as {ref}`builtin-type-int32` and
{ref}`builtin-type-float` now.
