---
title: External learning resources
linkTitle: External resources
description: Use these third-party resources to learn Hugo.
categories: []
keywords: []
weight: 40
---

## Books

### Hugo in Action

Hugo in Action is a step-by-step guide to using Hugo to create static websites. Working with a complete example website and source code samples, you'll learn how to build and host a low-maintenance, high-performance site that will wow your users and stay stable without relying on a third-party server.

[{{< img src="hugo-in-action.png" alt="Book cover: Hugo in Action" filter="process" filterArgs="resize x350 webp">}}](https://www.manning.com/books/hugo-in-action/)

Author: Atishay Jain\
Publisher: [Manning Publications](https://www.manning.com/books/hugo-in-action/)\
Publication date: March 2022\
Length: 488 pages\
ISBN: 9781617297007

### Build Websites with Hugo

In this book, you'll use Hugo to build a personal portfolio site that you can use to showcase your skills and thoughts to the world. You'll build the basic skeleton, develop a custom theme, and use content templates to generate new pages quickly. You'll use internal and external data sources to embed content into your site and render some of your content in JSON and RSS. You'll add a blog section with posts and integrate Disqus with your site, and then make your site searchable.

[{{< img src="build-websites-with-hugo.png" alt="Book cover: Build Websites with Hugo" filter="process" filterArgs="resize x350 webp">}}](https://pragprog.com/titles/bhhugo/build-websites-with-hugo/)

Author: Brian P. Hogan\
Publisher: [Pragmatic Bookshelf](https://pragprog.com/titles/bhhugo/build-websites-with-hugo/)\
Publication date: May 2020\
Length: 154 pages\
ISBN: 9781680507263

## Videos

### Hugo Beginner Tutorial Series

Welcome to this introduction to Hugo tutorial. This series aims to take you from a lion cub with basic web design knowledge to creating your first Hugo website. In this series, you'll learn how to set up a Hugo site, the basics of using Hugo layouts, partials, and templating, set up a blog, and finally, use data files. By the end of this series, you'll have the foundational knowledge to build your own Hugo sites.

1. [Getting set up in Hugo](https://cloudcannon.com/tutorials/hugo-beginner-tutorial/)
1. [Layouts in Hugo](https://cloudcannon.com/tutorials/hugo-beginner-tutorial/layouts-in-hugo/)
1. [Hugo Partials](https://cloudcannon.com/tutorials/hugo-beginner-tutorial/hugo-partials/)
1. [Hugo templating basics](https://cloudcannon.com/tutorials/hugo-beginner-tutorial/hugo-templating-basics/)
1. [Blogging in Hugo](https://cloudcannon.com/tutorials/hugo-beginner-tutorial/blogging-in-hugo/)
1. [Using Data in Hugo](https://cloudcannon.com/tutorials/hugo-beginner-tutorial/using-data-in-hugo/)

Creator: Mike Neumegen\
Affiliation: [CloudCannon](https://cloudcannon.com/)\
Creation date: April 2022

### Hugo Static Site Generator

This course covers the basics of using the Hugo static site generator. Work your way through the articles, and we'll teach you everything you need to know to create a professional and scalable website or blog!

1. [Introduction](https://www.giraffeacademy.com/static-site-generators/hugo/)
1. [Windows Installation](https://www.giraffeacademy.com/static-site-generators/hugo/installing-hugo-on-windows/)
1. [Mac Installation](https://www.giraffeacademy.com/static-site-generators/hugo/installing-hugo-on-mac/)
1. [Creating A New Site](https://www.giraffeacademy.com/static-site-generators/hugo/hugo-directory-structure/)
1. [Installing & Using Themes](https://www.giraffeacademy.com/static-site-generators/hugo/installing-using-themes/)
1. [Content Organization](https://www.giraffeacademy.com/static-site-generators/hugo/content-organization/)
1. [Front Matter](https://www.giraffeacademy.com/static-site-generators/hugo/front-matter/)
1. [Archetypes](https://www.giraffeacademy.com/static-site-generators/hugo/archetypes/)
1. [Shortcodes](https://www.giraffeacademy.com/static-site-generators/hugo/archetypes/)
1. [Taxonomies](https://www.giraffeacademy.com/static-site-generators/hugo/taxonomies/)
1. [Template Basics](https://www.giraffeacademy.com/static-site-generators/hugo/introduction-to-templates/)
1. [List Page Templates](https://www.giraffeacademy.com/static-site-generators/hugo/list-page-templates/)
1. [Single Page Templates](https://www.giraffeacademy.com/static-site-generators/hugo/single-page-templates/)
1. [Home Page Templates](https://www.giraffeacademy.com/static-site-generators/hugo/home-page-templates/)
1. [Section Templates](https://www.giraffeacademy.com/static-site-generators/hugo/section-templates/)
1. [Block Templates](https://www.giraffeacademy.com/static-site-generators/hugo/block-templates/)
1. [Variables](https://www.giraffeacademy.com/static-site-generators/hugo/variables/)
1. [Functions](https://www.giraffeacademy.com/static-site-generators/hugo/functions/)
1. [Conditionals](https://www.giraffeacademy.com/static-site-generators/hugo/conditionals/)
1. [Data Templates](https://www.giraffeacademy.com/static-site-generators/hugo/data-templates/)
1. [Partial Templates](https://www.giraffeacademy.com/static-site-generators/hugo/partial-templates/)
1. [Shortcode Templates](https://www.giraffeacademy.com/static-site-generators/hugo/shortcode-templates/)
1. [Building & Hosting](https://www.giraffeacademy.com/static-site-generators/hugo/building-&-hosting/)

Creator: Mike Dane\
Affiliation: [Giraffe Academy](https://www.giraffeacademy.com/)\
Creation date: September 2017
