/* xsltproc entities-to-c.xsl unicode.xml */
/* gcc `pkg-config --libs --cflags glib-2.0` generate-entity-array.c -o generate */

#include <glib.h>
#include <string.h>
#include <stdio.h>

static const struct {
		const char *name;
		const char *unicode;
		const char *comment;
		} entities[] = {
	{"AElig",                    "U000C6", "[LATIN CAPITAL LETTER AE]"},
{"Aacute",                   "U000C1", "[LATIN CAPITAL LETTER A WITH ACUTE]"},
{"Abreve",                   "U00102", "[LATIN CAPITAL LETTER A WITH BREVE]"},
{"Acirc",                    "U000C2", "[LATIN CAPITAL LETTER A WITH CIRCUMFLEX]"},
{"Acy",                      "U00410", "[CYRILLIC CAPITAL LETTER A]"},
{"Afr",                      "U1D504", "[MATHEMATICAL FRAKTUR CAPITAL A]"},
{"Agrave",                   "U000C0", "[LATIN CAPITAL LETTER A WITH GRAVE]"},
{"Amacr",                    "U00100", "[LATIN CAPITAL LETTER A WITH MACRON]"},
{"And",                      "U02A53", "[DOUBLE LOGICAL AND]"},
{"Aogon",                    "U00104", "[LATIN CAPITAL LETTER A WITH OGONEK]"},
{"Aopf",                     "U1D538", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL A]"},
{"ApplyFunction",            "U02061", "[FUNCTION APPLICATION]"},
{"Aring",                    "U000C5", "[LATIN CAPITAL LETTER A WITH RING ABOVE]"},
{"Ascr",                     "U1D49C", "[MATHEMATICAL SCRIPT CAPITAL A]"},
{"Assign",                   "U02254", "[COLON EQUALS]"},
{"Atilde",                   "U000C3", "[LATIN CAPITAL LETTER A WITH TILDE]"},
{"Auml",                     "U000C4", "[LATIN CAPITAL LETTER A WITH DIAERESIS]"},
{"Backslash",                "U02216", "[SET MINUS]"},
{"Barv",                     "U02AE7", "[SHORT DOWN TACK WITH OVERBAR]"},
{"Barwed",                   "U02306", "[PERSPECTIVE]"},
{"Bcy",                      "U00411", "[CYRILLIC CAPITAL LETTER BE]"},
{"Because",                  "U02235", "[BECAUSE]"},
{"Bernoullis",               "U0212C", "[SCRIPT CAPITAL B]"},
{"Bfr",                      "U1D505", "[MATHEMATICAL FRAKTUR CAPITAL B]"},
{"Bopf",                     "U1D539", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL B]"},
{"Breve",                    "U002D8", "[BREVE]"},
{"Bscr",                     "U0212C", "[SCRIPT CAPITAL B]"},
{"Bumpeq",                   "U0224E", "[GEOMETRICALLY EQUIVALENT TO]"},
{"CHcy",                     "U00427", "[CYRILLIC CAPITAL LETTER CHE]"},
{"Cacute",                   "U00106", "[LATIN CAPITAL LETTER C WITH ACUTE]"},
{"Cap",                      "U022D2", "[DOUBLE INTERSECTION]"},
{"CapitalDifferentialD",     "U02145", "[DOUBLE-STRUCK ITALIC CAPITAL D]"},
{"Cayleys",                  "U0212D", "[BLACK-LETTER CAPITAL C]"},
{"Ccaron",                   "U0010C", "[LATIN CAPITAL LETTER C WITH CARON]"},
{"Ccedil",                   "U000C7", "[LATIN CAPITAL LETTER C WITH CEDILLA]"},
{"Ccirc",                    "U00108", "[LATIN CAPITAL LETTER C WITH CIRCUMFLEX]"},
{"Cconint",                  "U02230", "[VOLUME INTEGRAL]"},
{"Cdot",                     "U0010A", "[LATIN CAPITAL LETTER C WITH DOT ABOVE]"},
{"Cedilla",                  "U000B8", "[CEDILLA]"},
{"CenterDot",                "U000B7", "[MIDDLE DOT]"},
{"Cfr",                      "U0212D", "[BLACK-LETTER CAPITAL C]"},
{"CircleDot",                "U02299", "[CIRCLED DOT OPERATOR]"},
{"CircleMinus",              "U02296", "[CIRCLED MINUS]"},
{"CirclePlus",               "U02295", "[CIRCLED PLUS]"},
{"CircleTimes",              "U02297", "[CIRCLED TIMES]"},
{"ClockwiseContourIntegral", "U02232", "[CLOCKWISE CONTOUR INTEGRAL]"},
{"CloseCurlyDoubleQuote",    "U0201D", "[RIGHT DOUBLE QUOTATION MARK]"},
{"CloseCurlyQuote",          "U02019", "[RIGHT SINGLE QUOTATION MARK]"},
{"Colon",                    "U02237", "[PROPORTION]"},
{"Colone",                   "U02A74", "[DOUBLE COLON EQUAL]"},
{"Congruent",                "U02261", "[IDENTICAL TO]"},
{"Conint",                   "U0222F", "[SURFACE INTEGRAL]"},
{"ContourIntegral",          "U0222E", "[CONTOUR INTEGRAL]"},
{"Copf",                     "U02102", "[DOUBLE-STRUCK CAPITAL C]"},
{"Coproduct",                "U02210", "[N-ARY COPRODUCT]"},
{"CounterClockwiseContourIntegral","U02233", "[ANTICLOCKWISE CONTOUR INTEGRAL]"},
{"Cross",                    "U02A2F", "[VECTOR OR CROSS PRODUCT]"},
{"Cscr",                     "U1D49E", "[MATHEMATICAL SCRIPT CAPITAL C]"},
{"Cup",                      "U022D3", "[DOUBLE UNION]"},
{"CupCap",                   "U0224D", "[EQUIVALENT TO]"},
{"DD",                       "U02145", "[DOUBLE-STRUCK ITALIC CAPITAL D]"},
{"DDotrahd",                 "U02911", "[RIGHTWARDS ARROW WITH DOTTED STEM]"},
{"DJcy",                     "U00402", "[CYRILLIC CAPITAL LETTER DJE]"},
{"DScy",                     "U00405", "[CYRILLIC CAPITAL LETTER DZE]"},
{"DZcy",                     "U0040F", "[CYRILLIC CAPITAL LETTER DZHE]"},
{"Dagger",                   "U02021", "[DOUBLE DAGGER]"},
{"Dagger",                   "U02021", "[DOUBLE DAGGER]"},
{"Darr",                     "U021A1", "[DOWNWARDS TWO HEADED ARROW]"},
{"Dashv",                    "U02AE4", "[VERTICAL BAR DOUBLE LEFT TURNSTILE]"},
{"Dcaron",                   "U0010E", "[LATIN CAPITAL LETTER D WITH CARON]"},
{"Dcy",                      "U00414", "[CYRILLIC CAPITAL LETTER DE]"},
{"Del",                      "U02207", "[NABLA]"},
{"Delta",                    "U00394", "[GREEK CAPITAL LETTER DELTA]"},
{"Dfr",                      "U1D507", "[MATHEMATICAL FRAKTUR CAPITAL D]"},
{"DiacriticalAcute",         "U000B4", "[ACUTE ACCENT]"},
{"DiacriticalDot",           "U002D9", "[DOT ABOVE]"},
{"DiacriticalDoubleAcute",   "U002DD", "[DOUBLE ACUTE ACCENT]"},
{"DiacriticalGrave",         "U00060", "[GRAVE ACCENT]"},
{"DiacriticalTilde",         "U002DC", "[SMALL TILDE]"},
{"Diamond",                  "U022C4", "[DIAMOND OPERATOR]"},
{"DifferentialD",            "U02146", "[DOUBLE-STRUCK ITALIC SMALL D]"},
{"Dopf",                     "U1D53B", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL D]"},
{"Dot",                      "U000A8", "[DIAERESIS]"},
{"DotDot",                   "U020DC", "[COMBINING FOUR DOTS ABOVE]"},
{"DotEqual",                 "U02250", "[APPROACHES THE LIMIT]"},
{"DoubleContourIntegral",    "U0222F", "[SURFACE INTEGRAL]"},
{"DoubleDot",                "U000A8", "[DIAERESIS]"},
{"DoubleDownArrow",          "U021D3", "[DOWNWARDS DOUBLE ARROW]"},
{"DoubleLeftArrow",          "U021D0", "[LEFTWARDS DOUBLE ARROW]"},
{"DoubleLeftRightArrow",     "U021D4", "[LEFT RIGHT DOUBLE ARROW]"},
{"DoubleLeftTee",            "U02AE4", "[VERTICAL BAR DOUBLE LEFT TURNSTILE]"},
{"DoubleLongLeftArrow",      "U027F8", "[LONG LEFTWARDS DOUBLE ARROW]"},
{"DoubleLongLeftRightArrow", "U027FA", "[LONG LEFT RIGHT DOUBLE ARROW]"},
{"DoubleLongRightArrow",     "U027F9", "[LONG RIGHTWARDS DOUBLE ARROW]"},
{"DoubleRightArrow",         "U021D2", "[RIGHTWARDS DOUBLE ARROW]"},
{"DoubleRightTee",           "U022A8", "[TRUE]"},
{"DoubleUpArrow",            "U021D1", "[UPWARDS DOUBLE ARROW]"},
{"DoubleUpDownArrow",        "U021D5", "[UP DOWN DOUBLE ARROW]"},
{"DoubleVerticalBar",        "U02225", "[PARALLEL TO]"},
{"DownArrow",                "U02193", "[DOWNWARDS ARROW]"},
{"DownArrowBar",             "U02913", "[DOWNWARDS ARROW TO BAR]"},
{"DownArrowUpArrow",         "U021F5", "[DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW]"},
{"DownBreve",                "U00311", "[COMBINING INVERTED BREVE]"},
{"DownLeftRightVector",      "U02950", "[LEFT BARB DOWN RIGHT BARB DOWN HARPOON]"},
{"DownLeftTeeVector",        "U0295E", "[LEFTWARDS HARPOON WITH BARB DOWN FROM BAR]"},
{"DownLeftVector",           "U021BD", "[LEFTWARDS HARPOON WITH BARB DOWNWARDS]"},
{"DownLeftVectorBar",        "U02956", "[LEFTWARDS HARPOON WITH BARB DOWN TO BAR]"},
{"DownRightTeeVector",       "U0295F", "[RIGHTWARDS HARPOON WITH BARB DOWN FROM BAR]"},
{"DownRightVector",          "U021C1", "[RIGHTWARDS HARPOON WITH BARB DOWNWARDS]"},
{"DownRightVectorBar",       "U02957", "[RIGHTWARDS HARPOON WITH BARB DOWN TO BAR]"},
{"DownTee",                  "U022A4", "[DOWN TACK]"},
{"DownTeeArrow",             "U021A7", "[DOWNWARDS ARROW FROM BAR]"},
{"Downarrow",                "U021D3", "[DOWNWARDS DOUBLE ARROW]"},
{"Dscr",                     "U1D49F", "[MATHEMATICAL SCRIPT CAPITAL D]"},
{"Dstrok",                   "U00110", "[LATIN CAPITAL LETTER D WITH STROKE]"},
{"ENG",                      "U0014A", "[LATIN CAPITAL LETTER ENG]"},
{"ETH",                      "U000D0", "[LATIN CAPITAL LETTER ETH]"},
{"Eacute",                   "U000C9", "[LATIN CAPITAL LETTER E WITH ACUTE]"},
{"Ecaron",                   "U0011A", "[LATIN CAPITAL LETTER E WITH CARON]"},
{"Ecirc",                    "U000CA", "[LATIN CAPITAL LETTER E WITH CIRCUMFLEX]"},
{"Ecy",                      "U0042D", "[CYRILLIC CAPITAL LETTER E]"},
{"Edot",                     "U00116", "[LATIN CAPITAL LETTER E WITH DOT ABOVE]"},
{"Efr",                      "U1D508", "[MATHEMATICAL FRAKTUR CAPITAL E]"},
{"Egrave",                   "U000C8", "[LATIN CAPITAL LETTER E WITH GRAVE]"},
{"Element",                  "U02208", "[ELEMENT OF]"},
{"Emacr",                    "U00112", "[LATIN CAPITAL LETTER E WITH MACRON]"},
{"EmptySmallSquare",         "U025FB", "[WHITE MEDIUM SQUARE]"},
{"EmptyVerySmallSquare",     "U025AB", "[WHITE SMALL SQUARE]"},
{"Eogon",                    "U00118", "[LATIN CAPITAL LETTER E WITH OGONEK]"},
{"Eopf",                     "U1D53C", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL E]"},
{"Equal",                    "U02A75", "[TWO CONSECUTIVE EQUALS SIGNS]"},
{"EqualTilde",               "U02242", "[MINUS TILDE]"},
{"Equilibrium",              "U021CC", "[RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON]"},
{"Escr",                     "U02130", "[SCRIPT CAPITAL E]"},
{"Esim",                     "U02A73", "[EQUALS SIGN ABOVE TILDE OPERATOR]"},
{"Euml",                     "U000CB", "[LATIN CAPITAL LETTER E WITH DIAERESIS]"},
{"Exists",                   "U02203", "[THERE EXISTS]"},
{"ExponentialE",             "U02147", "[DOUBLE-STRUCK ITALIC SMALL E]"},
{"Fcy",                      "U00424", "[CYRILLIC CAPITAL LETTER EF]"},
{"Ffr",                      "U1D509", "[MATHEMATICAL FRAKTUR CAPITAL F]"},
{"FilledSmallSquare",        "U025FC", "[BLACK MEDIUM SQUARE]"},
{"FilledVerySmallSquare",    "U025AA", "[BLACK SMALL SQUARE]"},
{"Fopf",                     "U1D53D", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL F]"},
{"ForAll",                   "U02200", "[FOR ALL]"},
{"Fouriertrf",               "U02131", "[SCRIPT CAPITAL F]"},
{"Fscr",                     "U02131", "[SCRIPT CAPITAL F]"},
{"GJcy",                     "U00403", "[CYRILLIC CAPITAL LETTER GJE]"},
{"Gamma",                    "U00393", "[GREEK CAPITAL LETTER GAMMA]"},
{"Gammad",                   "U003DC", "[GREEK LETTER DIGAMMA]"},
{"Gbreve",                   "U0011E", "[LATIN CAPITAL LETTER G WITH BREVE]"},
{"Gcedil",                   "U00122", "[LATIN CAPITAL LETTER G WITH CEDILLA]"},
{"Gcirc",                    "U0011C", "[LATIN CAPITAL LETTER G WITH CIRCUMFLEX]"},
{"Gcy",                      "U00413", "[CYRILLIC CAPITAL LETTER GHE]"},
{"Gdot",                     "U00120", "[LATIN CAPITAL LETTER G WITH DOT ABOVE]"},
{"Gfr",                      "U1D50A", "[MATHEMATICAL FRAKTUR CAPITAL G]"},
{"Gg",                       "U022D9", "[VERY MUCH GREATER-THAN]"},
{"Gopf",                     "U1D53E", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL G]"},
{"GreaterEqual",             "U02265", "[GREATER-THAN OR EQUAL TO]"},
{"GreaterEqualLess",         "U022DB", "[GREATER-THAN EQUAL TO OR LESS-THAN]"},
{"GreaterFullEqual",         "U02267", "[GREATER-THAN OVER EQUAL TO]"},
{"GreaterGreater",           "U02AA2", "[DOUBLE NESTED GREATER-THAN]"},
{"GreaterLess",              "U02277", "[GREATER-THAN OR LESS-THAN]"},
{"GreaterSlantEqual",        "U02A7E", "[GREATER-THAN OR SLANTED EQUAL TO]"},
{"GreaterTilde",             "U02273", "[GREATER-THAN OR EQUIVALENT TO]"},
{"Gscr",                     "U1D4A2", "[MATHEMATICAL SCRIPT CAPITAL G]"},
{"Gt",                       "U0226B", "[MUCH GREATER-THAN]"},
{"HARDcy",                   "U0042A", "[CYRILLIC CAPITAL LETTER HARD SIGN]"},
{"Hacek",                    "U002C7", "[CARON]"},
{"Hat",                      "U0005E", "[CIRCUMFLEX ACCENT]"},
{"Hcirc",                    "U00124", "[LATIN CAPITAL LETTER H WITH CIRCUMFLEX]"},
{"Hfr",                      "U0210C", "[BLACK-LETTER CAPITAL H]"},
{"HilbertSpace",             "U0210B", "[SCRIPT CAPITAL H]"},
{"Hopf",                     "U0210D", "[DOUBLE-STRUCK CAPITAL H]"},
{"HorizontalLine",           "U02500", "[BOX DRAWINGS LIGHT HORIZONTAL]"},
{"Hscr",                     "U0210B", "[SCRIPT CAPITAL H]"},
{"Hstrok",                   "U00126", "[LATIN CAPITAL LETTER H WITH STROKE]"},
{"HumpDownHump",             "U0224E", "[GEOMETRICALLY EQUIVALENT TO]"},
{"HumpEqual",                "U0224F", "[DIFFERENCE BETWEEN]"},
{"IEcy",                     "U00415", "[CYRILLIC CAPITAL LETTER IE]"},
{"IJlig",                    "U00132", "[LATIN CAPITAL LIGATURE IJ]"},
{"IOcy",                     "U00401", "[CYRILLIC CAPITAL LETTER IO]"},
{"Iacute",                   "U000CD", "[LATIN CAPITAL LETTER I WITH ACUTE]"},
{"Icirc",                    "U000CE", "[LATIN CAPITAL LETTER I WITH CIRCUMFLEX]"},
{"Icy",                      "U00418", "[CYRILLIC CAPITAL LETTER I]"},
{"Idot",                     "U00130", "[LATIN CAPITAL LETTER I WITH DOT ABOVE]"},
{"Ifr",                      "U02111", "[BLACK-LETTER CAPITAL I]"},
{"Igrave",                   "U000CC", "[LATIN CAPITAL LETTER I WITH GRAVE]"},
{"Im",                       "U02111", "[BLACK-LETTER CAPITAL I]"},
{"Imacr",                    "U0012A", "[LATIN CAPITAL LETTER I WITH MACRON]"},
{"ImaginaryI",               "U02148", "[DOUBLE-STRUCK ITALIC SMALL I]"},
{"Implies",                  "U021D2", "[RIGHTWARDS DOUBLE ARROW]"},
{"Int",                      "U0222C", "[DOUBLE INTEGRAL]"},
{"Integral",                 "U0222B", "[INTEGRAL]"},
{"Intersection",             "U022C2", "[N-ARY INTERSECTION]"},
{"InvisibleComma",           "U02063", "[INVISIBLE SEPARATOR]"},
{"InvisibleTimes",           "U02062", "[INVISIBLE TIMES]"},
{"Iogon",                    "U0012E", "[LATIN CAPITAL LETTER I WITH OGONEK]"},
{"Iopf",                     "U1D540", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL I]"},
{"Iscr",                     "U02110", "[SCRIPT CAPITAL I]"},
{"Itilde",                   "U00128", "[LATIN CAPITAL LETTER I WITH TILDE]"},
{"Iukcy",                    "U00406", "[CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I]"},
{"Iuml",                     "U000CF", "[LATIN CAPITAL LETTER I WITH DIAERESIS]"},
{"Jcirc",                    "U00134", "[LATIN CAPITAL LETTER J WITH CIRCUMFLEX]"},
{"Jcy",                      "U00419", "[CYRILLIC CAPITAL LETTER SHORT I]"},
{"Jfr",                      "U1D50D", "[MATHEMATICAL FRAKTUR CAPITAL J]"},
{"Jopf",                     "U1D541", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL J]"},
{"Jscr",                     "U1D4A5", "[MATHEMATICAL SCRIPT CAPITAL J]"},
{"Jsercy",                   "U00408", "[CYRILLIC CAPITAL LETTER JE]"},
{"Jukcy",                    "U00404", "[CYRILLIC CAPITAL LETTER UKRAINIAN IE]"},
{"KHcy",                     "U00425", "[CYRILLIC CAPITAL LETTER HA]"},
{"KJcy",                     "U0040C", "[CYRILLIC CAPITAL LETTER KJE]"},
{"Kcedil",                   "U00136", "[LATIN CAPITAL LETTER K WITH CEDILLA]"},
{"Kcy",                      "U0041A", "[CYRILLIC CAPITAL LETTER KA]"},
{"Kfr",                      "U1D50E", "[MATHEMATICAL FRAKTUR CAPITAL K]"},
{"Kopf",                     "U1D542", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL K]"},
{"Kscr",                     "U1D4A6", "[MATHEMATICAL SCRIPT CAPITAL K]"},
{"LJcy",                     "U00409", "[CYRILLIC CAPITAL LETTER LJE]"},
{"Lacute",                   "U00139", "[LATIN CAPITAL LETTER L WITH ACUTE]"},
{"Lambda",                   "U0039B", "[GREEK CAPITAL LETTER LAMDA]"},
{"Lang",                     "U0300A", "[LEFT DOUBLE ANGLE BRACKET]"},
{"Laplacetrf",               "U02112", "[SCRIPT CAPITAL L]"},
{"Larr",                     "U0219E", "[LEFTWARDS TWO HEADED ARROW]"},
{"Lcaron",                   "U0013D", "[LATIN CAPITAL LETTER L WITH CARON]"},
{"Lcedil",                   "U0013B", "[LATIN CAPITAL LETTER L WITH CEDILLA]"},
{"Lcy",                      "U0041B", "[CYRILLIC CAPITAL LETTER EL]"},
{"LeftAngleBracket",         "U02329", "[LEFT-POINTING ANGLE BRACKET]"},
{"LeftArrow",                "U02190", "[LEFTWARDS ARROW]"},
{"LeftArrowBar",             "U021E4", "[LEFTWARDS ARROW TO BAR]"},
{"LeftArrowRightArrow",      "U021C6", "[LEFTWARDS ARROW OVER RIGHTWARDS ARROW]"},
{"LeftCeiling",              "U02308", "[LEFT CEILING]"},
{"LeftDoubleBracket",        "U0301A", "[LEFT WHITE SQUARE BRACKET]"},
{"LeftDownTeeVector",        "U02961", "[DOWNWARDS HARPOON WITH BARB LEFT FROM BAR]"},
{"LeftDownVector",           "U021C3", "[DOWNWARDS HARPOON WITH BARB LEFTWARDS]"},
{"LeftDownVectorBar",        "U02959", "[DOWNWARDS HARPOON WITH BARB LEFT TO BAR]"},
{"LeftFloor",                "U0230A", "[LEFT FLOOR]"},
{"LeftRightArrow",           "U02194", "[LEFT RIGHT ARROW]"},
{"LeftRightVector",          "U0294E", "[LEFT BARB UP RIGHT BARB UP HARPOON]"},
{"LeftTee",                  "U022A3", "[LEFT TACK]"},
{"LeftTeeArrow",             "U021A4", "[LEFTWARDS ARROW FROM BAR]"},
{"LeftTeeVector",            "U0295A", "[LEFTWARDS HARPOON WITH BARB UP FROM BAR]"},
{"LeftTriangle",             "U022B2", "[NORMAL SUBGROUP OF]"},
{"LeftTriangleBar",          "U029CF", "[LEFT TRIANGLE BESIDE VERTICAL BAR]"},
{"LeftTriangleEqual",        "U022B4", "[NORMAL SUBGROUP OF OR EQUAL TO]"},
{"LeftUpDownVector",         "U02951", "[UP BARB LEFT DOWN BARB LEFT HARPOON]"},
{"LeftUpTeeVector",          "U02960", "[UPWARDS HARPOON WITH BARB LEFT FROM BAR]"},
{"LeftUpVector",             "U021BF", "[UPWARDS HARPOON WITH BARB LEFTWARDS]"},
{"LeftUpVectorBar",          "U02958", "[UPWARDS HARPOON WITH BARB LEFT TO BAR]"},
{"LeftVector",               "U021BC", "[LEFTWARDS HARPOON WITH BARB UPWARDS]"},
{"LeftVectorBar",            "U02952", "[LEFTWARDS HARPOON WITH BARB UP TO BAR]"},
{"Leftarrow",                "U021D0", "[LEFTWARDS DOUBLE ARROW]"},
{"Leftrightarrow",           "U021D4", "[LEFT RIGHT DOUBLE ARROW]"},
{"LessEqualGreater",         "U022DA", "[LESS-THAN EQUAL TO OR GREATER-THAN]"},
{"LessFullEqual",            "U02266", "[LESS-THAN OVER EQUAL TO]"},
{"LessGreater",              "U02276", "[LESS-THAN OR GREATER-THAN]"},
{"LessLess",                 "U02AA1", "[DOUBLE NESTED LESS-THAN]"},
{"LessSlantEqual",           "U02A7D", "[LESS-THAN OR SLANTED EQUAL TO]"},
{"LessTilde",                "U02272", "[LESS-THAN OR EQUIVALENT TO]"},
{"Lfr",                      "U1D50F", "[MATHEMATICAL FRAKTUR CAPITAL L]"},
{"Ll",                       "U022D8", "[VERY MUCH LESS-THAN]"},
{"Lleftarrow",               "U021DA", "[LEFTWARDS TRIPLE ARROW]"},
{"Lmidot",                   "U0013F", "[LATIN CAPITAL LETTER L WITH MIDDLE DOT]"},
{"LongLeftArrow",            "U027F5", "[LONG LEFTWARDS ARROW]"},
{"LongLeftRightArrow",       "U027F7", "[LONG LEFT RIGHT ARROW]"},
{"LongRightArrow",           "U027F6", "[LONG RIGHTWARDS ARROW]"},
{"Longleftarrow",            "U027F8", "[LONG LEFTWARDS DOUBLE ARROW]"},
{"Longleftrightarrow",       "U027FA", "[LONG LEFT RIGHT DOUBLE ARROW]"},
{"Longrightarrow",           "U027F9", "[LONG RIGHTWARDS DOUBLE ARROW]"},
{"Lopf",                     "U1D543", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL L]"},
{"LowerLeftArrow",           "U02199", "[SOUTH WEST ARROW]"},
{"LowerRightArrow",          "U02198", "[SOUTH EAST ARROW]"},
{"Lscr",                     "U02112", "[SCRIPT CAPITAL L]"},
{"Lsh",                      "U021B0", "[UPWARDS ARROW WITH TIP LEFTWARDS]"},
{"Lstrok",                   "U00141", "[LATIN CAPITAL LETTER L WITH STROKE]"},
{"Lt",                       "U0226A", "[MUCH LESS-THAN]"},
{"Map",                      "U02905", "[RIGHTWARDS TWO-HEADED ARROW FROM BAR]"},
{"Mcy",                      "U0041C", "[CYRILLIC CAPITAL LETTER EM]"},
{"MediumSpace",              "U0205F", "[MEDIUM MATHEMATICAL SPACE]"},
{"Mellintrf",                "U02133", "[SCRIPT CAPITAL M]"},
{"Mfr",                      "U1D510", "[MATHEMATICAL FRAKTUR CAPITAL M]"},
{"MinusPlus",                "U02213", "[MINUS-OR-PLUS SIGN]"},
{"Mopf",                     "U1D544", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL M]"},
{"Mscr",                     "U02133", "[SCRIPT CAPITAL M]"},
{"NJcy",                     "U0040A", "[CYRILLIC CAPITAL LETTER NJE]"},
{"Nacute",                   "U00143", "[LATIN CAPITAL LETTER N WITH ACUTE]"},
{"Ncaron",                   "U00147", "[LATIN CAPITAL LETTER N WITH CARON]"},
{"Ncedil",                   "U00145", "[LATIN CAPITAL LETTER N WITH CEDILLA]"},
{"Ncy",                      "U0041D", "[CYRILLIC CAPITAL LETTER EN]"},
{"NegativeMediumSpace",      "U0200B", "[ZERO WIDTH SPACE]"},
{"NegativeThickSpace",       "U0200B", "[ZERO WIDTH SPACE]"},
{"NegativeThinSpace",        "U0200B", "[ZERO WIDTH SPACE]"},
{"NegativeVeryThinSpace",    "U0200B", "[ZERO WIDTH SPACE]"},
{"NestedGreaterGreater",     "U0226B", "[MUCH GREATER-THAN]"},
{"NestedLessLess",           "U0226A", "[MUCH LESS-THAN]"},
{"NewLine",                  "U0000A", "[LINE FEED (LF)]"},
{"Nfr",                      "U1D511", "[MATHEMATICAL FRAKTUR CAPITAL N]"},
{"NoBreak",                  "U02060", "[WORD JOINER]"},
{"NonBreakingSpace",         "U000A0", "[NO-BREAK SPACE]"},
{"Nopf",                     "U02115", "[DOUBLE-STRUCK CAPITAL N]"},
{"Not",                      "U02AEC", "[DOUBLE STROKE NOT SIGN]"},
{"NotCongruent",             "U02262", "[NOT IDENTICAL TO]"},
{"NotCupCap",                "U0226D", "[NOT EQUIVALENT TO]"},
{"NotDoubleVerticalBar",     "U02226", "[NOT PARALLEL TO]"},
{"NotElement",               "U02209", "[NOT AN ELEMENT OF]"},
{"NotEqual",                 "U02260", "[NOT EQUAL TO]"},
{"NotEqualTilde",            "U02242-00338", "[MINUS TILDE with slash]"},
{"NotExists",                "U02204", "[THERE DOES NOT EXIST]"},
{"NotGreater",               "U0226F", "[NOT GREATER-THAN]"},
{"NotGreaterEqual",          "U02271", "[NEITHER GREATER-THAN NOR EQUAL TO]"},
{"NotGreaterFullEqual",      "U02266-00338", "[LESS-THAN OVER EQUAL TO with slash]"},
{"NotGreaterGreater",        "U0226B-00338", "[MUCH GREATER THAN with slash]"},
{"NotGreaterLess",           "U02279", "[NEITHER GREATER-THAN NOR LESS-THAN]"},
{"NotGreaterSlantEqual",     "U02A7E-00338", "[GREATER-THAN OR SLANTED EQUAL TO with slash]"},
{"NotGreaterTilde",          "U02275", "[NEITHER GREATER-THAN NOR EQUIVALENT TO]"},
{"NotHumpDownHump",          "U0224E-00338", "[GEOMETRICALLY EQUIVALENT TO with slash]"},
{"NotHumpEqual",             "U0224F-00338", "[DIFFERENCE BETWEEN with slash]"},
{"NotLeftTriangle",          "U022EA", "[NOT NORMAL SUBGROUP OF]"},
{"NotLeftTriangleBar",       "U029CF-00338", "[LEFT TRIANGLE BESIDE VERTICAL BAR with slash]"},
{"NotLeftTriangleEqual",     "U022EC", "[NOT NORMAL SUBGROUP OF OR EQUAL TO]"},
{"NotLess",                  "U0226E", "[NOT LESS-THAN]"},
{"NotLessEqual",             "U02270", "[NEITHER LESS-THAN NOR EQUAL TO]"},
{"NotLessGreater",           "U02278", "[NEITHER LESS-THAN NOR GREATER-THAN]"},
{"NotLessLess",              "U0226A-00338", "[MUCH LESS THAN with slash]"},
{"NotLessSlantEqual",        "U02A7D-00338", "[LESS-THAN OR SLANTED EQUAL TO with slash]"},
{"NotLessTilde",             "U02274", "[NEITHER LESS-THAN NOR EQUIVALENT TO]"},
{"NotNestedGreaterGreater",  "U02AA2-00338", "[DOUBLE NESTED GREATER-THAN with slash]"},
{"NotNestedLessLess",        "U02AA1-00338", "[DOUBLE NESTED LESS-THAN with slash]"},
{"NotPrecedes",              "U02280", "[DOES NOT PRECEDE]"},
{"NotPrecedesEqual",         "U02AAF-00338", "[PRECEDES ABOVE SINGLE-LINE EQUALS SIGN with slash]"},
{"NotPrecedesSlantEqual",    "U022E0", "[DOES NOT PRECEDE OR EQUAL]"},
{"NotReverseElement",        "U0220C", "[DOES NOT CONTAIN AS MEMBER]"},
{"NotRightTriangle",         "U022EB", "[DOES NOT CONTAIN AS NORMAL SUBGROUP]"},
{"NotRightTriangleBar",      "U029D0-00338", "[VERTICAL BAR BESIDE RIGHT TRIANGLE with slash]"},
{"NotRightTriangleEqual",    "U022ED", "[DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL]"},
{"NotSquareSubset",          "U0228F-00338", "[SQUARE IMAGE OF with slash]"},
{"NotSquareSubsetEqual",     "U022E2", "[NOT SQUARE IMAGE OF OR EQUAL TO]"},
{"NotSquareSuperset",        "U02290-00338", "[SQUARE ORIGINAL OF with slash]"},
{"NotSquareSupersetEqual",   "U022E3", "[NOT SQUARE ORIGINAL OF OR EQUAL TO]"},
{"NotSubset",                "U02282-020D2", "[SUBSET OF with vertical line]"},
{"NotSubsetEqual",           "U02288", "[NEITHER A SUBSET OF NOR EQUAL TO]"},
{"NotSucceeds",              "U02281", "[DOES NOT SUCCEED]"},
{"NotSucceedsEqual",         "U02AB0-00338", "[SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN with slash]"},
{"NotSucceedsSlantEqual",    "U022E1", "[DOES NOT SUCCEED OR EQUAL]"},
{"NotSucceedsTilde",         "U0227F-00338", "[SUCCEEDS OR EQUIVALENT TO with slash]"},
{"NotSuperset",              "U02283-020D2", "[SUPERSET OF with vertical line]"},
{"NotSupersetEqual",         "U02289", "[NEITHER A SUPERSET OF NOR EQUAL TO]"},
{"NotTilde",                 "U02241", "[NOT TILDE]"},
{"NotTildeEqual",            "U02244", "[NOT ASYMPTOTICALLY EQUAL TO]"},
{"NotTildeFullEqual",        "U02247", "[NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO]"},
{"NotTildeTilde",            "U02249", "[NOT ALMOST EQUAL TO]"},
{"NotVerticalBar",           "U02224", "[DOES NOT DIVIDE]"},
{"Nscr",                     "U1D4A9", "[MATHEMATICAL SCRIPT CAPITAL N]"},
{"Ntilde",                   "U000D1", "[LATIN CAPITAL LETTER N WITH TILDE]"},
{"OElig",                    "U00152", "[LATIN CAPITAL LIGATURE OE]"},
{"Oacute",                   "U000D3", "[LATIN CAPITAL LETTER O WITH ACUTE]"},
{"Ocirc",                    "U000D4", "[LATIN CAPITAL LETTER O WITH CIRCUMFLEX]"},
{"Ocy",                      "U0041E", "[CYRILLIC CAPITAL LETTER O]"},
{"Odblac",                   "U00150", "[LATIN CAPITAL LETTER O WITH DOUBLE ACUTE]"},
{"Ofr",                      "U1D512", "[MATHEMATICAL FRAKTUR CAPITAL O]"},
{"Ograve",                   "U000D2", "[LATIN CAPITAL LETTER O WITH GRAVE]"},
{"Omacr",                    "U0014C", "[LATIN CAPITAL LETTER O WITH MACRON]"},
{"Omega",                    "U003A9", "[GREEK CAPITAL LETTER OMEGA]"},
{"Oopf",                     "U1D546", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL O]"},
{"OpenCurlyDoubleQuote",     "U0201C", "[LEFT DOUBLE QUOTATION MARK]"},
{"OpenCurlyQuote",           "U02018", "[LEFT SINGLE QUOTATION MARK]"},
{"Or",                       "U02A54", "[DOUBLE LOGICAL OR]"},
{"Oscr",                     "U1D4AA", "[MATHEMATICAL SCRIPT CAPITAL O]"},
{"Oslash",                   "U000D8", "[LATIN CAPITAL LETTER O WITH STROKE]"},
{"Otilde",                   "U000D5", "[LATIN CAPITAL LETTER O WITH TILDE]"},
{"Otimes",                   "U02A37", "[MULTIPLICATION SIGN IN DOUBLE CIRCLE]"},
{"Ouml",                     "U000D6", "[LATIN CAPITAL LETTER O WITH DIAERESIS]"},
{"OverBar",                  "U000AF", "[MACRON]"},
{"OverBrace",                "U0FE37", "[PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET]"},
{"OverBracket",              "U023B4", "[TOP SQUARE BRACKET]"},
{"OverParenthesis",          "U0FE35", "[PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS]"},
{"PartialD",                 "U02202", "[PARTIAL DIFFERENTIAL]"},
{"Pcy",                      "U0041F", "[CYRILLIC CAPITAL LETTER PE]"},
{"Pfr",                      "U1D513", "[MATHEMATICAL FRAKTUR CAPITAL P]"},
{"Phi",                      "U003A6", "[GREEK CAPITAL LETTER PHI]"},
{"Pi",                       "U003A0", "[GREEK CAPITAL LETTER PI]"},
{"PlusMinus",                "U000B1", "[PLUS-MINUS SIGN]"},
{"Poincareplane",            "U0210C", "[BLACK-LETTER CAPITAL H]"},
{"Popf",                     "U02119", "[DOUBLE-STRUCK CAPITAL P]"},
{"Pr",                       "U02ABB", "[DOUBLE PRECEDES]"},
{"Precedes",                 "U0227A", "[PRECEDES]"},
{"PrecedesEqual",            "U02AAF", "[PRECEDES ABOVE SINGLE-LINE EQUALS SIGN]"},
{"PrecedesSlantEqual",       "U0227C", "[PRECEDES OR EQUAL TO]"},
{"PrecedesTilde",            "U0227E", "[PRECEDES OR EQUIVALENT TO]"},
{"Prime",                    "U02033", "[DOUBLE PRIME]"},
{"Product",                  "U0220F", "[N-ARY PRODUCT]"},
{"Proportion",               "U02237", "[PROPORTION]"},
{"Proportional",             "U0221D", "[PROPORTIONAL TO]"},
{"Pscr",                     "U1D4AB", "[MATHEMATICAL SCRIPT CAPITAL P]"},
{"Psi",                      "U003A8", "[GREEK CAPITAL LETTER PSI]"},
{"Qfr",                      "U1D514", "[MATHEMATICAL FRAKTUR CAPITAL Q]"},
{"Qopf",                     "U0211A", "[DOUBLE-STRUCK CAPITAL Q]"},
{"Qscr",                     "U1D4AC", "[MATHEMATICAL SCRIPT CAPITAL Q]"},
{"RBarr",                    "U02910", "[RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW]"},
{"Racute",                   "U00154", "[LATIN CAPITAL LETTER R WITH ACUTE]"},
{"Rang",                     "U0300B", "[RIGHT DOUBLE ANGLE BRACKET]"},
{"Rarr",                     "U021A0", "[RIGHTWARDS TWO HEADED ARROW]"},
{"Rarrtl",                   "U02916", "[RIGHTWARDS TWO-HEADED ARROW WITH TAIL]"},
{"Rcaron",                   "U00158", "[LATIN CAPITAL LETTER R WITH CARON]"},
{"Rcedil",                   "U00156", "[LATIN CAPITAL LETTER R WITH CEDILLA]"},
{"Rcy",                      "U00420", "[CYRILLIC CAPITAL LETTER ER]"},
{"Re",                       "U0211C", "[BLACK-LETTER CAPITAL R]"},
{"ReverseElement",           "U0220B", "[CONTAINS AS MEMBER]"},
{"ReverseEquilibrium",       "U021CB", "[LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON]"},
{"ReverseUpEquilibrium",     "U0296F", "[DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT]"},
{"Rfr",                      "U0211C", "[BLACK-LETTER CAPITAL R]"},
{"RightAngleBracket",        "U0232A", "[RIGHT-POINTING ANGLE BRACKET]"},
{"RightArrow",               "U02192", "[RIGHTWARDS ARROW]"},
{"RightArrowBar",            "U021E5", "[RIGHTWARDS ARROW TO BAR]"},
{"RightArrowLeftArrow",      "U021C4", "[RIGHTWARDS ARROW OVER LEFTWARDS ARROW]"},
{"RightCeiling",             "U02309", "[RIGHT CEILING]"},
{"RightDoubleBracket",       "U0301B", "[RIGHT WHITE SQUARE BRACKET]"},
{"RightDownTeeVector",       "U0295D", "[DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR]"},
{"RightDownVector",          "U021C2", "[DOWNWARDS HARPOON WITH BARB RIGHTWARDS]"},
{"RightDownVectorBar",       "U02955", "[DOWNWARDS HARPOON WITH BARB RIGHT TO BAR]"},
{"RightFloor",               "U0230B", "[RIGHT FLOOR]"},
{"RightTee",                 "U022A2", "[RIGHT TACK]"},
{"RightTeeArrow",            "U021A6", "[RIGHTWARDS ARROW FROM BAR]"},
{"RightTeeVector",           "U0295B", "[RIGHTWARDS HARPOON WITH BARB UP FROM BAR]"},
{"RightTriangle",            "U022B3", "[CONTAINS AS NORMAL SUBGROUP]"},
{"RightTriangleBar",         "U029D0", "[VERTICAL BAR BESIDE RIGHT TRIANGLE]"},
{"RightTriangleEqual",       "U022B5", "[CONTAINS AS NORMAL SUBGROUP OR EQUAL TO]"},
{"RightUpDownVector",        "U0294F", "[UP BARB RIGHT DOWN BARB RIGHT HARPOON]"},
{"RightUpTeeVector",         "U0295C", "[UPWARDS HARPOON WITH BARB RIGHT FROM BAR]"},
{"RightUpVector",            "U021BE", "[UPWARDS HARPOON WITH BARB RIGHTWARDS]"},
{"RightUpVectorBar",         "U02954", "[UPWARDS HARPOON WITH BARB RIGHT TO BAR]"},
{"RightVector",              "U021C0", "[RIGHTWARDS HARPOON WITH BARB UPWARDS]"},
{"RightVectorBar",           "U02953", "[RIGHTWARDS HARPOON WITH BARB UP TO BAR]"},
{"Rightarrow",               "U021D2", "[RIGHTWARDS DOUBLE ARROW]"},
{"Ropf",                     "U0211D", "[DOUBLE-STRUCK CAPITAL R]"},
{"RoundImplies",             "U02970", "[RIGHT DOUBLE ARROW WITH ROUNDED HEAD]"},
{"Rrightarrow",              "U021DB", "[RIGHTWARDS TRIPLE ARROW]"},
{"Rscr",                     "U0211B", "[SCRIPT CAPITAL R]"},
{"Rsh",                      "U021B1", "[UPWARDS ARROW WITH TIP RIGHTWARDS]"},
{"RuleDelayed",              "U029F4", "[RULE-DELAYED]"},
{"SHCHcy",                   "U00429", "[CYRILLIC CAPITAL LETTER SHCHA]"},
{"SHcy",                     "U00428", "[CYRILLIC CAPITAL LETTER SHA]"},
{"SOFTcy",                   "U0042C", "[CYRILLIC CAPITAL LETTER SOFT SIGN]"},
{"Sacute",                   "U0015A", "[LATIN CAPITAL LETTER S WITH ACUTE]"},
{"Sc",                       "U02ABC", "[DOUBLE SUCCEEDS]"},
{"Scaron",                   "U00160", "[LATIN CAPITAL LETTER S WITH CARON]"},
{"Scedil",                   "U0015E", "[LATIN CAPITAL LETTER S WITH CEDILLA]"},
{"Scirc",                    "U0015C", "[LATIN CAPITAL LETTER S WITH CIRCUMFLEX]"},
{"Scy",                      "U00421", "[CYRILLIC CAPITAL LETTER ES]"},
{"Sfr",                      "U1D516", "[MATHEMATICAL FRAKTUR CAPITAL S]"},
{"ShortDownArrow",           "U02193", "[DOWNWARDS ARROW]"},
{"ShortLeftArrow",           "U02190", "[LEFTWARDS ARROW]"},
{"ShortRightArrow",          "U02192", "[RIGHTWARDS ARROW]"},
{"ShortUpArrow",             "U02191", "[UPWARDS ARROW]"},
{"Sigma",                    "U003A3", "[GREEK CAPITAL LETTER SIGMA]"},
{"SmallCircle",              "U02218", "[RING OPERATOR]"},
{"Sopf",                     "U1D54A", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL S]"},
{"Sqrt",                     "U0221A", "[SQUARE ROOT]"},
{"Square",                   "U025A1", "[WHITE SQUARE]"},
{"SquareIntersection",       "U02293", "[SQUARE CAP]"},
{"SquareSubset",             "U0228F", "[SQUARE IMAGE OF]"},
{"SquareSubsetEqual",        "U02291", "[SQUARE IMAGE OF OR EQUAL TO]"},
{"SquareSuperset",           "U02290", "[SQUARE ORIGINAL OF]"},
{"SquareSupersetEqual",      "U02292", "[SQUARE ORIGINAL OF OR EQUAL TO]"},
{"SquareUnion",              "U02294", "[SQUARE CUP]"},
{"Sscr",                     "U1D4AE", "[MATHEMATICAL SCRIPT CAPITAL S]"},
{"Star",                     "U022C6", "[STAR OPERATOR]"},
{"Sub",                      "U022D0", "[DOUBLE SUBSET]"},
{"Subset",                   "U022D0", "[DOUBLE SUBSET]"},
{"SubsetEqual",              "U02286", "[SUBSET OF OR EQUAL TO]"},
{"Succeeds",                 "U0227B", "[SUCCEEDS]"},
{"SucceedsEqual",            "U02AB0", "[SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN]"},
{"SucceedsSlantEqual",       "U0227D", "[SUCCEEDS OR EQUAL TO]"},
{"SucceedsTilde",            "U0227F", "[SUCCEEDS OR EQUIVALENT TO]"},
{"SuchThat",                 "U0220B", "[CONTAINS AS MEMBER]"},
{"Sum",                      "U02211", "[N-ARY SUMMATION]"},
{"Sup",                      "U022D1", "[DOUBLE SUPERSET]"},
{"Superset",                 "U02283", "[SUPERSET OF]"},
{"SupersetEqual",            "U02287", "[SUPERSET OF OR EQUAL TO]"},
{"Supset",                   "U022D1", "[DOUBLE SUPERSET]"},
{"THORN",                    "U000DE", "[LATIN CAPITAL LETTER THORN]"},
{"TSHcy",                    "U0040B", "[CYRILLIC CAPITAL LETTER TSHE]"},
{"TScy",                     "U00426", "[CYRILLIC CAPITAL LETTER TSE]"},
{"Tab",                      "U00009", "[CHARACTER TABULATION]"},
{"Tcaron",                   "U00164", "[LATIN CAPITAL LETTER T WITH CARON]"},
{"Tcedil",                   "U00162", "[LATIN CAPITAL LETTER T WITH CEDILLA]"},
{"Tcy",                      "U00422", "[CYRILLIC CAPITAL LETTER TE]"},
{"Tfr",                      "U1D517", "[MATHEMATICAL FRAKTUR CAPITAL T]"},
{"Therefore",                "U02234", "[THEREFORE]"},
{"Theta",                    "U00398", "[GREEK CAPITAL LETTER THETA]"},
{"ThickSpace",               "U02009-0200A-0200A", "[space of width 5/18 em]"},
{"ThinSpace",                "U02009", "[THIN SPACE]"},
{"Tilde",                    "U0223C", "[TILDE OPERATOR]"},
{"TildeEqual",               "U02243", "[ASYMPTOTICALLY EQUAL TO]"},
{"TildeFullEqual",           "U02245", "[APPROXIMATELY EQUAL TO]"},
{"TildeTilde",               "U02248", "[ALMOST EQUAL TO]"},
{"Topf",                     "U1D54B", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL T]"},
{"TripleDot",                "U020DB", "[COMBINING THREE DOTS ABOVE]"},
{"Tscr",                     "U1D4AF", "[MATHEMATICAL SCRIPT CAPITAL T]"},
{"Tstrok",                   "U00166", "[LATIN CAPITAL LETTER T WITH STROKE]"},
{"Uacute",                   "U000DA", "[LATIN CAPITAL LETTER U WITH ACUTE]"},
{"Uarr",                     "U0219F", "[UPWARDS TWO HEADED ARROW]"},
{"Uarrocir",                 "U02949", "[UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE]"},
{"Ubrcy",                    "U0040E", "[CYRILLIC CAPITAL LETTER SHORT U]"},
{"Ubreve",                   "U0016C", "[LATIN CAPITAL LETTER U WITH BREVE]"},
{"Ucirc",                    "U000DB", "[LATIN CAPITAL LETTER U WITH CIRCUMFLEX]"},
{"Ucy",                      "U00423", "[CYRILLIC CAPITAL LETTER U]"},
{"Udblac",                   "U00170", "[LATIN CAPITAL LETTER U WITH DOUBLE ACUTE]"},
{"Ufr",                      "U1D518", "[MATHEMATICAL FRAKTUR CAPITAL U]"},
{"Ugrave",                   "U000D9", "[LATIN CAPITAL LETTER U WITH GRAVE]"},
{"Umacr",                    "U0016A", "[LATIN CAPITAL LETTER U WITH MACRON]"},
{"UnderBar",                 "U00332", "[COMBINING LOW LINE]"},
{"UnderBrace",               "U0FE38", "[PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET]"},
{"UnderBracket",             "U023B5", "[BOTTOM SQUARE BRACKET]"},
{"UnderParenthesis",         "U0FE36", "[PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS]"},
{"Union",                    "U022C3", "[N-ARY UNION]"},
{"UnionPlus",                "U0228E", "[MULTISET UNION]"},
{"Uogon",                    "U00172", "[LATIN CAPITAL LETTER U WITH OGONEK]"},
{"Uopf",                     "U1D54C", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL U]"},
{"UpArrow",                  "U02191", "[UPWARDS ARROW]"},
{"UpArrowBar",               "U02912", "[UPWARDS ARROW TO BAR]"},
{"UpArrowDownArrow",         "U021C5", "[UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW]"},
{"UpDownArrow",              "U02195", "[UP DOWN ARROW]"},
{"UpEquilibrium",            "U0296E", "[UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT]"},
{"UpTee",                    "U022A5", "[UP TACK]"},
{"UpTeeArrow",               "U021A5", "[UPWARDS ARROW FROM BAR]"},
{"Uparrow",                  "U021D1", "[UPWARDS DOUBLE ARROW]"},
{"Updownarrow",              "U021D5", "[UP DOWN DOUBLE ARROW]"},
{"UpperLeftArrow",           "U02196", "[NORTH WEST ARROW]"},
{"UpperRightArrow",          "U02197", "[NORTH EAST ARROW]"},
{"Upsi",                     "U003D2", "[GREEK UPSILON WITH HOOK SYMBOL]"},
{"Upsilon",                  "U003A5", "[GREEK CAPITAL LETTER UPSILON]"},
{"Uring",                    "U0016E", "[LATIN CAPITAL LETTER U WITH RING ABOVE]"},
{"Uscr",                     "U1D4B0", "[MATHEMATICAL SCRIPT CAPITAL U]"},
{"Utilde",                   "U00168", "[LATIN CAPITAL LETTER U WITH TILDE]"},
{"Uuml",                     "U000DC", "[LATIN CAPITAL LETTER U WITH DIAERESIS]"},
{"VDash",                    "U022AB", "[DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE]"},
{"Vbar",                     "U02AEB", "[DOUBLE UP TACK]"},
{"Vcy",                      "U00412", "[CYRILLIC CAPITAL LETTER VE]"},
{"Vdash",                    "U022A9", "[FORCES]"},
{"Vdashl",                   "U02AE6", "[LONG DASH FROM LEFT MEMBER OF DOUBLE VERTICAL]"},
{"Vee",                      "U022C1", "[N-ARY LOGICAL OR]"},
{"Verbar",                   "U02016", "[DOUBLE VERTICAL LINE]"},
{"Vert",                     "U02016", "[DOUBLE VERTICAL LINE]"},
{"VerticalBar",              "U02223", "[DIVIDES]"},
{"VerticalLine",             "U0007C", "[VERTICAL LINE]"},
{"VerticalSeparator",        "U02758", "[LIGHT VERTICAL BAR]"},
{"VerticalTilde",            "U02240", "[WREATH PRODUCT]"},
{"VeryThinSpace",            "U0200A", "[HAIR SPACE]"},
{"Vfr",                      "U1D519", "[MATHEMATICAL FRAKTUR CAPITAL V]"},
{"Vopf",                     "U1D54D", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL V]"},
{"Vscr",                     "U1D4B1", "[MATHEMATICAL SCRIPT CAPITAL V]"},
{"Vvdash",                   "U022AA", "[TRIPLE VERTICAL BAR RIGHT TURNSTILE]"},
{"Wcirc",                    "U00174", "[LATIN CAPITAL LETTER W WITH CIRCUMFLEX]"},
{"Wedge",                    "U022C0", "[N-ARY LOGICAL AND]"},
{"Wfr",                      "U1D51A", "[MATHEMATICAL FRAKTUR CAPITAL W]"},
{"Wopf",                     "U1D54E", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL W]"},
{"Wscr",                     "U1D4B2", "[MATHEMATICAL SCRIPT CAPITAL W]"},
{"Xfr",                      "U1D51B", "[MATHEMATICAL FRAKTUR CAPITAL X]"},
{"Xi",                       "U0039E", "[GREEK CAPITAL LETTER XI]"},
{"Xopf",                     "U1D54F", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL X]"},
{"Xscr",                     "U1D4B3", "[MATHEMATICAL SCRIPT CAPITAL X]"},
{"YAcy",                     "U0042F", "[CYRILLIC CAPITAL LETTER YA]"},
{"YIcy",                     "U00407", "[CYRILLIC CAPITAL LETTER YI]"},
{"YUcy",                     "U0042E", "[CYRILLIC CAPITAL LETTER YU]"},
{"Yacute",                   "U000DD", "[LATIN CAPITAL LETTER Y WITH ACUTE]"},
{"Ycirc",                    "U00176", "[LATIN CAPITAL LETTER Y WITH CIRCUMFLEX]"},
{"Ycy",                      "U0042B", "[CYRILLIC CAPITAL LETTER YERU]"},
{"Yfr",                      "U1D51C", "[MATHEMATICAL FRAKTUR CAPITAL Y]"},
{"Yopf",                     "U1D550", "[MATHEMATICAL DOUBLE-STRUCK CAPITAL Y]"},
{"Yscr",                     "U1D4B4", "[MATHEMATICAL SCRIPT CAPITAL Y]"},
{"Yuml",                     "U00178", "[LATIN CAPITAL LETTER Y WITH DIAERESIS]"},
{"ZHcy",                     "U00416", "[CYRILLIC CAPITAL LETTER ZHE]"},
{"Zacute",                   "U00179", "[LATIN CAPITAL LETTER Z WITH ACUTE]"},
{"Zcaron",                   "U0017D", "[LATIN CAPITAL LETTER Z WITH CARON]"},
{"Zcy",                      "U00417", "[CYRILLIC CAPITAL LETTER ZE]"},
{"Zdot",                     "U0017B", "[LATIN CAPITAL LETTER Z WITH DOT ABOVE]"},
{"ZeroWidthSpace",           "U0200B", "[ZERO WIDTH SPACE]"},
{"Zfr",                      "U02128", "[BLACK-LETTER CAPITAL Z]"},
{"Zopf",                     "U02124", "[DOUBLE-STRUCK CAPITAL Z]"},
{"Zscr",                     "U1D4B5", "[MATHEMATICAL SCRIPT CAPITAL Z]"},
{"aacute",                   "U000E1", "[LATIN SMALL LETTER A WITH ACUTE]"},
{"abreve",                   "U00103", "[LATIN SMALL LETTER A WITH BREVE]"},
{"ac",                       "U0223E", "[INVERTED LAZY S]"},
{"acE",                      "U0223E-00333", "[INVERTED LAZY S with double underline]"},
{"acd",                      "U0223F", "[SINE WAVE]"},
{"acirc",                    "U000E2", "[LATIN SMALL LETTER A WITH CIRCUMFLEX]"},
{"acute",                    "U000B4", "[ACUTE ACCENT]"},
{"acy",                      "U00430", "[CYRILLIC SMALL LETTER A]"},
{"aelig",                    "U000E6", "[LATIN SMALL LETTER AE]"},
{"af",                       "U02061", "[FUNCTION APPLICATION]"},
{"afr",                      "U1D51E", "[MATHEMATICAL FRAKTUR SMALL A]"},
{"agrave",                   "U000E0", "[LATIN SMALL LETTER A WITH GRAVE]"},
{"aleph",                    "U02135", "[ALEF SYMBOL]"},
{"alpha",                    "U003B1", "[GREEK SMALL LETTER ALPHA]"},
{"amacr",                    "U00101", "[LATIN SMALL LETTER A WITH MACRON]"},
{"amalg",                    "U02A3F", "[AMALGAMATION OR COPRODUCT]"},
{"amp",                      "U00026", "[AMPERSAND]"},
{"and",                      "U02227", "[LOGICAL AND]"},
{"andand",                   "U02A55", "[TWO INTERSECTING LOGICAL AND]"},
{"andd",                     "U02A5C", "[LOGICAL AND WITH HORIZONTAL DASH]"},
{"andslope",                 "U02A58", "[SLOPING LARGE AND]"},
{"andv",                     "U02A5A", "[LOGICAL AND WITH MIDDLE STEM]"},
{"ang",                      "U02220", "[ANGLE]"},
{"ange",                     "U029A4", "[ANGLE WITH UNDERBAR]"},
{"angle",                    "U02220", "[ANGLE]"},
{"angmsd",                   "U02221", "[MEASURED ANGLE]"},
{"angmsdaa",                 "U029A8", "[MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHT]"},
{"angmsdab",                 "U029A9", "[MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFT]"},
{"angmsdac",                 "U029AA", "[MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHT]"},
{"angmsdad",                 "U029AB", "[MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFT]"},
{"angmsdae",                 "U029AC", "[MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP]"},
{"angmsdaf",                 "U029AD", "[MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UP]"},
{"angmsdag",                 "U029AE", "[MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWN]"},
{"angmsdah",                 "U029AF", "[MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWN]"},
{"angrt",                    "U0221F", "[RIGHT ANGLE]"},
{"angrtvb",                  "U022BE", "[RIGHT ANGLE WITH ARC]"},
{"angrtvbd",                 "U0299D", "[MEASURED RIGHT ANGLE WITH DOT]"},
{"angsph",                   "U02222", "[SPHERICAL ANGLE]"},
{"angst",                    "U0212B", "[ANGSTROM SIGN]"},
{"angzarr",                  "U0237C", "[RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW]"},
{"aogon",                    "U00105", "[LATIN SMALL LETTER A WITH OGONEK]"},
{"aopf",                     "U1D552", "[MATHEMATICAL DOUBLE-STRUCK SMALL A]"},
{"ap",                       "U02248", "[ALMOST EQUAL TO]"},
{"apE",                      "U02A70", "[APPROXIMATELY EQUAL OR EQUAL TO]"},
{"apacir",                   "U02A6F", "[ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT]"},
{"ape",                      "U0224A", "[ALMOST EQUAL OR EQUAL TO]"},
{"apid",                     "U0224B", "[TRIPLE TILDE]"},
{"apos",                     "U00027", "[APOSTROPHE]"},
{"approx",                   "U02248", "[ALMOST EQUAL TO]"},
{"approxeq",                 "U0224A", "[ALMOST EQUAL OR EQUAL TO]"},
{"aring",                    "U000E5", "[LATIN SMALL LETTER A WITH RING ABOVE]"},
{"ascr",                     "U1D4B6", "[MATHEMATICAL SCRIPT SMALL A]"},
{"ast",                      "U0002A", "[ASTERISK]"},
{"asymp",                    "U02248", "[ALMOST EQUAL TO]"},
{"asympeq",                  "U0224D", "[EQUIVALENT TO]"},
{"atilde",                   "U000E3", "[LATIN SMALL LETTER A WITH TILDE]"},
{"auml",                     "U000E4", "[LATIN SMALL LETTER A WITH DIAERESIS]"},
{"awconint",                 "U02233", "[ANTICLOCKWISE CONTOUR INTEGRAL]"},
{"awint",                    "U02A11", "[ANTICLOCKWISE INTEGRATION]"},
{"bNot",                     "U02AED", "[REVERSED DOUBLE STROKE NOT SIGN]"},
{"backcong",                 "U0224C", "[ALL EQUAL TO]"},
{"backepsilon",              "U003F6", "[GREEK REVERSED LUNATE EPSILON SYMBOL]"},
{"backprime",                "U02035", "[REVERSED PRIME]"},
{"backsim",                  "U0223D", "[REVERSED TILDE]"},
{"backsimeq",                "U022CD", "[REVERSED TILDE EQUALS]"},
{"barvee",                   "U022BD", "[NOR]"},
{"barwed",                   "U02305", "[PROJECTIVE]"},
{"barwedge",                 "U02305", "[PROJECTIVE]"},
{"bbrk",                     "U023B5", "[BOTTOM SQUARE BRACKET]"},
{"bbrktbrk",                 "U023B6", "[BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET]"},
{"bcong",                    "U0224C", "[ALL EQUAL TO]"},
{"bcy",                      "U00431", "[CYRILLIC SMALL LETTER BE]"},
{"becaus",                   "U02235", "[BECAUSE]"},
{"because",                  "U02235", "[BECAUSE]"},
{"bemptyv",                  "U029B0", "[REVERSED EMPTY SET]"},
{"bepsi",                    "U003F6", "[GREEK REVERSED LUNATE EPSILON SYMBOL]"},
{"bernou",                   "U0212C", "[SCRIPT CAPITAL B]"},
{"beta",                     "U003B2", "[GREEK SMALL LETTER BETA]"},
{"beth",                     "U02136", "[BET SYMBOL]"},
{"between",                  "U0226C", "[BETWEEN]"},
{"bfr",                      "U1D51F", "[MATHEMATICAL FRAKTUR SMALL B]"},
{"bigcap",                   "U022C2", "[N-ARY INTERSECTION]"},
{"bigcirc",                  "U025EF", "[LARGE CIRCLE]"},
{"bigcup",                   "U022C3", "[N-ARY UNION]"},
{"bigodot",                  "U02A00", "[N-ARY CIRCLED DOT OPERATOR]"},
{"bigoplus",                 "U02A01", "[N-ARY CIRCLED PLUS OPERATOR]"},
{"bigotimes",                "U02A02", "[N-ARY CIRCLED TIMES OPERATOR]"},
{"bigsqcup",                 "U02A06", "[N-ARY SQUARE UNION OPERATOR]"},
{"bigstar",                  "U02605", "[BLACK STAR]"},
{"bigtriangledown",          "U025BD", "[WHITE DOWN-POINTING TRIANGLE]"},
{"bigtriangleup",            "U025B3", "[WHITE UP-POINTING TRIANGLE]"},
{"biguplus",                 "U02A04", "[N-ARY UNION OPERATOR WITH PLUS]"},
{"bigvee",                   "U022C1", "[N-ARY LOGICAL OR]"},
{"bigwedge",                 "U022C0", "[N-ARY LOGICAL AND]"},
{"bkarow",                   "U0290D", "[RIGHTWARDS DOUBLE DASH ARROW]"},
{"blacklozenge",             "U029EB", "[BLACK LOZENGE]"},
{"blacksquare",              "U025AA", "[BLACK SMALL SQUARE]"},
{"blacktriangle",            "U025B4", "[BLACK UP-POINTING SMALL TRIANGLE]"},
{"blacktriangledown",        "U025BE", "[BLACK DOWN-POINTING SMALL TRIANGLE]"},
{"blacktriangleleft",        "U025C2", "[BLACK LEFT-POINTING SMALL TRIANGLE]"},
{"blacktriangleright",       "U025B8", "[BLACK RIGHT-POINTING SMALL TRIANGLE]"},
{"blank",                    "U02423", "[OPEN BOX]"},
{"blk12",                    "U02592", "[MEDIUM SHADE]"},
{"blk14",                    "U02591", "[LIGHT SHADE]"},
{"blk34",                    "U02593", "[DARK SHADE]"},
{"block",                    "U02588", "[FULL BLOCK]"},
{"bne",                      "U0003D-020E5", "[EQUALS SIGN with reverse slash]"},
{"bnequiv",                  "U02261-020E5", "[IDENTICAL TO with reverse slash]"},
{"bnot",                     "U02310", "[REVERSED NOT SIGN]"},
{"bopf",                     "U1D553", "[MATHEMATICAL DOUBLE-STRUCK SMALL B]"},
{"bot",                      "U022A5", "[UP TACK]"},
{"bottom",                   "U022A5", "[UP TACK]"},
{"bowtie",                   "U022C8", "[BOWTIE]"},
{"boxDL",                    "U02557", "[BOX DRAWINGS DOUBLE DOWN AND LEFT]"},
{"boxDR",                    "U02554", "[BOX DRAWINGS DOUBLE DOWN AND RIGHT]"},
{"boxDl",                    "U02556", "[BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE]"},
{"boxDr",                    "U02553", "[BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE]"},
{"boxH",                     "U02550", "[BOX DRAWINGS DOUBLE HORIZONTAL]"},
{"boxHD",                    "U02566", "[BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL]"},
{"boxHU",                    "U02569", "[BOX DRAWINGS DOUBLE UP AND HORIZONTAL]"},
{"boxHd",                    "U02564", "[BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE]"},
{"boxHu",                    "U02567", "[BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE]"},
{"boxUL",                    "U0255D", "[BOX DRAWINGS DOUBLE UP AND LEFT]"},
{"boxUR",                    "U0255A", "[BOX DRAWINGS DOUBLE UP AND RIGHT]"},
{"boxUl",                    "U0255C", "[BOX DRAWINGS UP DOUBLE AND LEFT SINGLE]"},
{"boxUr",                    "U02559", "[BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE]"},
{"boxV",                     "U02551", "[BOX DRAWINGS DOUBLE VERTICAL]"},
{"boxVH",                    "U0256C", "[BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL]"},
{"boxVL",                    "U02563", "[BOX DRAWINGS DOUBLE VERTICAL AND LEFT]"},
{"boxVR",                    "U02560", "[BOX DRAWINGS DOUBLE VERTICAL AND RIGHT]"},
{"boxVh",                    "U0256B", "[BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE]"},
{"boxVl",                    "U02562", "[BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE]"},
{"boxVr",                    "U0255F", "[BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE]"},
{"boxbox",                   "U029C9", "[TWO JOINED SQUARES]"},
{"boxdL",                    "U02555", "[BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE]"},
{"boxdR",                    "U02552", "[BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE]"},
{"boxdl",                    "U02510", "[BOX DRAWINGS LIGHT DOWN AND LEFT]"},
{"boxdr",                    "U0250C", "[BOX DRAWINGS LIGHT DOWN AND RIGHT]"},
{"boxh",                     "U02500", "[BOX DRAWINGS LIGHT HORIZONTAL]"},
{"boxhD",                    "U02565", "[BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE]"},
{"boxhU",                    "U02568", "[BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE]"},
{"boxhd",                    "U0252C", "[BOX DRAWINGS LIGHT DOWN AND HORIZONTAL]"},
{"boxhu",                    "U02534", "[BOX DRAWINGS LIGHT UP AND HORIZONTAL]"},
{"boxminus",                 "U0229F", "[SQUARED MINUS]"},
{"boxplus",                  "U0229E", "[SQUARED PLUS]"},
{"boxtimes",                 "U022A0", "[SQUARED TIMES]"},
{"boxuL",                    "U0255B", "[BOX DRAWINGS UP SINGLE AND LEFT DOUBLE]"},
{"boxuR",                    "U02558", "[BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE]"},
{"boxul",                    "U02518", "[BOX DRAWINGS LIGHT UP AND LEFT]"},
{"boxur",                    "U02514", "[BOX DRAWINGS LIGHT UP AND RIGHT]"},
{"boxv",                     "U02502", "[BOX DRAWINGS LIGHT VERTICAL]"},
{"boxvH",                    "U0256A", "[BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE]"},
{"boxvL",                    "U02561", "[BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE]"},
{"boxvR",                    "U0255E", "[BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE]"},
{"boxvh",                    "U0253C", "[BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL]"},
{"boxvl",                    "U02524", "[BOX DRAWINGS LIGHT VERTICAL AND LEFT]"},
{"boxvr",                    "U0251C", "[BOX DRAWINGS LIGHT VERTICAL AND RIGHT]"},
{"bprime",                   "U02035", "[REVERSED PRIME]"},
{"breve",                    "U002D8", "[BREVE]"},
{"brvbar",                   "U000A6", "[BROKEN BAR]"},
{"bscr",                     "U1D4B7", "[MATHEMATICAL SCRIPT SMALL B]"},
{"bsemi",                    "U0204F", "[REVERSED SEMICOLON]"},
{"bsim",                     "U0223D", "[REVERSED TILDE]"},
{"bsime",                    "U022CD", "[REVERSED TILDE EQUALS]"},
{"bsol",                     "U0005C", "[REVERSE SOLIDUS]"},
{"bsolb",                    "U029C5", "[SQUARED FALLING DIAGONAL SLASH]"},
{"bsolhsub",                 "U0005C-02282", "[REVERSE SOLIDUS, SUBSET OF]"},
{"bull",                     "U02022", "[BULLET]"},
{"bullet",                   "U02022", "[BULLET]"},
{"bump",                     "U0224E", "[GEOMETRICALLY EQUIVALENT TO]"},
{"bumpE",                    "U02AAE", "[EQUALS SIGN WITH BUMPY ABOVE]"},
{"bumpe",                    "U0224F", "[DIFFERENCE BETWEEN]"},
{"bumpeq",                   "U0224F", "[DIFFERENCE BETWEEN]"},
{"cacute",                   "U00107", "[LATIN SMALL LETTER C WITH ACUTE]"},
{"cap",                      "U02229", "[INTERSECTION]"},
{"capand",                   "U02A44", "[INTERSECTION WITH LOGICAL AND]"},
{"capbrcup",                 "U02A49", "[INTERSECTION ABOVE BAR ABOVE UNION]"},
{"capcap",                   "U02A4B", "[INTERSECTION BESIDE AND JOINED WITH INTERSECTION]"},
{"capcup",                   "U02A47", "[INTERSECTION ABOVE UNION]"},
{"capdot",                   "U02A40", "[INTERSECTION WITH DOT]"},
{"caps",                     "U02229-0FE00", "[INTERSECTION with serifs]"},
{"caret",                    "U02041", "[CARET INSERTION POINT]"},
{"caron",                    "U002C7", "[CARON]"},
{"ccaps",                    "U02A4D", "[CLOSED INTERSECTION WITH SERIFS]"},
{"ccaron",                   "U0010D", "[LATIN SMALL LETTER C WITH CARON]"},
{"ccedil",                   "U000E7", "[LATIN SMALL LETTER C WITH CEDILLA]"},
{"ccirc",                    "U00109", "[LATIN SMALL LETTER C WITH CIRCUMFLEX]"},
{"ccups",                    "U02A4C", "[CLOSED UNION WITH SERIFS]"},
{"ccupssm",                  "U02A50", "[CLOSED UNION WITH SERIFS AND SMASH PRODUCT]"},
{"cdot",                     "U0010B", "[LATIN SMALL LETTER C WITH DOT ABOVE]"},
{"cedil",                    "U000B8", "[CEDILLA]"},
{"cemptyv",                  "U029B2", "[EMPTY SET WITH SMALL CIRCLE ABOVE]"},
{"cent",                     "U000A2", "[CENT SIGN]"},
{"centerdot",                "U000B7", "[MIDDLE DOT]"},
{"cfr",                      "U1D520", "[MATHEMATICAL FRAKTUR SMALL C]"},
{"chcy",                     "U00447", "[CYRILLIC SMALL LETTER CHE]"},
{"check",                    "U02713", "[CHECK MARK]"},
{"checkmark",                "U02713", "[CHECK MARK]"},
{"chi",                      "U003C7", "[GREEK SMALL LETTER CHI]"},
{"cir",                      "U025CB", "[WHITE CIRCLE]"},
{"cirE",                     "U029C3", "[CIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHT]"},
{"circ",                     "U002C6", "[MODIFIER LETTER CIRCUMFLEX ACCENT]"},
{"circeq",                   "U02257", "[RING EQUAL TO]"},
{"circlearrowleft",          "U021BA", "[ANTICLOCKWISE OPEN CIRCLE ARROW]"},
{"circlearrowright",         "U021BB", "[CLOCKWISE OPEN CIRCLE ARROW]"},
{"circledR",                 "U000AE", "[REGISTERED SIGN]"},
{"circledS",                 "U024C8", "[CIRCLED LATIN CAPITAL LETTER S]"},
{"circledast",               "U0229B", "[CIRCLED ASTERISK OPERATOR]"},
{"circledcirc",              "U0229A", "[CIRCLED RING OPERATOR]"},
{"circleddash",              "U0229D", "[CIRCLED DASH]"},
{"cire",                     "U02257", "[RING EQUAL TO]"},
{"cirfnint",                 "U02A10", "[CIRCULATION FUNCTION]"},
{"cirmid",                   "U02AEF", "[VERTICAL LINE WITH CIRCLE ABOVE]"},
{"cirscir",                  "U029C2", "[CIRCLE WITH SMALL CIRCLE TO THE RIGHT]"},
{"clubs",                    "U02663", "[BLACK CLUB SUIT]"},
{"clubsuit",                 "U02663", "[BLACK CLUB SUIT]"},
{"colon",                    "U0003A", "[COLON]"},
{"colone",                   "U02254", "[COLON EQUALS]"},
{"coloneq",                  "U02254", "[COLON EQUALS]"},
{"comma",                    "U0002C", "[COMMA]"},
{"commat",                   "U00040", "[COMMERCIAL AT]"},
{"comp",                     "U02201", "[COMPLEMENT]"},
{"compfn",                   "U02218", "[RING OPERATOR]"},
{"complement",               "U02201", "[COMPLEMENT]"},
{"complexes",                "U02102", "[DOUBLE-STRUCK CAPITAL C]"},
{"cong",                     "U02245", "[APPROXIMATELY EQUAL TO]"},
{"congdot",                  "U02A6D", "[CONGRUENT WITH DOT ABOVE]"},
{"conint",                   "U0222E", "[CONTOUR INTEGRAL]"},
{"copf",                     "U1D554", "[MATHEMATICAL DOUBLE-STRUCK SMALL C]"},
{"coprod",                   "U02210", "[N-ARY COPRODUCT]"},
{"copy",                     "U000A9", "[COPYRIGHT SIGN]"},
{"copysr",                   "U02117", "[SOUND RECORDING COPYRIGHT]"},
{"cross",                    "U02717", "[BALLOT X]"},
{"cscr",                     "U1D4B8", "[MATHEMATICAL SCRIPT SMALL C]"},
{"csub",                     "U02ACF", "[CLOSED SUBSET]"},
{"csube",                    "U02AD1", "[CLOSED SUBSET OR EQUAL TO]"},
{"csup",                     "U02AD0", "[CLOSED SUPERSET]"},
{"csupe",                    "U02AD2", "[CLOSED SUPERSET OR EQUAL TO]"},
{"ctdot",                    "U022EF", "[MIDLINE HORIZONTAL ELLIPSIS]"},
{"cudarrl",                  "U02938", "[RIGHT-SIDE ARC CLOCKWISE ARROW]"},
{"cudarrr",                  "U02935", "[ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS]"},
{"cuepr",                    "U022DE", "[EQUAL TO OR PRECEDES]"},
{"cuesc",                    "U022DF", "[EQUAL TO OR SUCCEEDS]"},
{"cularr",                   "U021B6", "[ANTICLOCKWISE TOP SEMICIRCLE ARROW]"},
{"cularrp",                  "U0293D", "[TOP ARC ANTICLOCKWISE ARROW WITH PLUS]"},
{"cup",                      "U0222A", "[UNION]"},
{"cupbrcap",                 "U02A48", "[UNION ABOVE BAR ABOVE INTERSECTION]"},
{"cupcap",                   "U02A46", "[UNION ABOVE INTERSECTION]"},
{"cupcup",                   "U02A4A", "[UNION BESIDE AND JOINED WITH UNION]"},
{"cupdot",                   "U0228D", "[MULTISET MULTIPLICATION]"},
{"cupor",                    "U02A45", "[UNION WITH LOGICAL OR]"},
{"cups",                     "U0222A-0FE00", "[UNION with serifs]"},
{"curarr",                   "U021B7", "[CLOCKWISE TOP SEMICIRCLE ARROW]"},
{"curarrm",                  "U0293C", "[TOP ARC CLOCKWISE ARROW WITH MINUS]"},
{"curlyeqprec",              "U022DE", "[EQUAL TO OR PRECEDES]"},
{"curlyeqsucc",              "U022DF", "[EQUAL TO OR SUCCEEDS]"},
{"curlyvee",                 "U022CE", "[CURLY LOGICAL OR]"},
{"curlywedge",               "U022CF", "[CURLY LOGICAL AND]"},
{"curren",                   "U000A4", "[CURRENCY SIGN]"},
{"curvearrowleft",           "U021B6", "[ANTICLOCKWISE TOP SEMICIRCLE ARROW]"},
{"curvearrowright",          "U021B7", "[CLOCKWISE TOP SEMICIRCLE ARROW]"},
{"cuvee",                    "U022CE", "[CURLY LOGICAL OR]"},
{"cuwed",                    "U022CF", "[CURLY LOGICAL AND]"},
{"cwconint",                 "U02232", "[CLOCKWISE CONTOUR INTEGRAL]"},
{"cwint",                    "U02231", "[CLOCKWISE INTEGRAL]"},
{"cylcty",                   "U0232D", "[CYLINDRICITY]"},
{"dArr",                     "U021D3", "[DOWNWARDS DOUBLE ARROW]"},
{"dHar",                     "U02965", "[DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT]"},
{"dagger",                   "U02020", "[DAGGER]"},
{"dagger",                   "U02020", "[DAGGER]"},
{"daleth",                   "U02138", "[DALET SYMBOL]"},
{"darr",                     "U02193", "[DOWNWARDS ARROW]"},
{"dash",                     "U02010", "[HYPHEN]"},
{"dashv",                    "U022A3", "[LEFT TACK]"},
{"dbkarow",                  "U0290F", "[RIGHTWARDS TRIPLE DASH ARROW]"},
{"dblac",                    "U002DD", "[DOUBLE ACUTE ACCENT]"},
{"dcaron",                   "U0010F", "[LATIN SMALL LETTER D WITH CARON]"},
{"dcy",                      "U00434", "[CYRILLIC SMALL LETTER DE]"},
{"dd",                       "U02146", "[DOUBLE-STRUCK ITALIC SMALL D]"},
{"ddagger",                  "U02021", "[DOUBLE DAGGER]"},
{"ddarr",                    "U021CA", "[DOWNWARDS PAIRED ARROWS]"},
{"ddotseq",                  "U02A77", "[EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW]"},
{"deg",                      "U000B0", "[DEGREE SIGN]"},
{"delta",                    "U003B4", "[GREEK SMALL LETTER DELTA]"},
{"demptyv",                  "U029B1", "[EMPTY SET WITH OVERBAR]"},
{"dfisht",                   "U0297F", "[DOWN FISH TAIL]"},
{"dfr",                      "U1D521", "[MATHEMATICAL FRAKTUR SMALL D]"},
{"dharl",                    "U021C3", "[DOWNWARDS HARPOON WITH BARB LEFTWARDS]"},
{"dharr",                    "U021C2", "[DOWNWARDS HARPOON WITH BARB RIGHTWARDS]"},
{"diam",                     "U022C4", "[DIAMOND OPERATOR]"},
{"diamond",                  "U022C4", "[DIAMOND OPERATOR]"},
{"diamondsuit",              "U02666", "[BLACK DIAMOND SUIT]"},
{"diams",                    "U02666", "[BLACK DIAMOND SUIT]"},
{"die",                      "U000A8", "[DIAERESIS]"},
{"digamma",                  "U003DD", "[GREEK SMALL LETTER DIGAMMA]"},
{"disin",                    "U022F2", "[ELEMENT OF WITH LONG HORIZONTAL STROKE]"},
{"div",                      "U000F7", "[DIVISION SIGN]"},
{"divide",                   "U000F7", "[DIVISION SIGN]"},
{"divideontimes",            "U022C7", "[DIVISION TIMES]"},
{"divonx",                   "U022C7", "[DIVISION TIMES]"},
{"djcy",                     "U00452", "[CYRILLIC SMALL LETTER DJE]"},
{"dlcorn",                   "U0231E", "[BOTTOM LEFT CORNER]"},
{"dlcrop",                   "U0230D", "[BOTTOM LEFT CROP]"},
{"dollar",                   "U00024", "[DOLLAR SIGN]"},
{"dopf",                     "U1D555", "[MATHEMATICAL DOUBLE-STRUCK SMALL D]"},
{"dot",                      "U002D9", "[DOT ABOVE]"},
{"doteq",                    "U02250", "[APPROACHES THE LIMIT]"},
{"doteqdot",                 "U02251", "[GEOMETRICALLY EQUAL TO]"},
{"dotminus",                 "U02238", "[DOT MINUS]"},
{"dotplus",                  "U02214", "[DOT PLUS]"},
{"dotsquare",                "U022A1", "[SQUARED DOT OPERATOR]"},
{"doublebarwedge",           "U02306", "[PERSPECTIVE]"},
{"downarrow",                "U02193", "[DOWNWARDS ARROW]"},
{"downdownarrows",           "U021CA", "[DOWNWARDS PAIRED ARROWS]"},
{"downharpoonleft",          "U021C3", "[DOWNWARDS HARPOON WITH BARB LEFTWARDS]"},
{"downharpoonright",         "U021C2", "[DOWNWARDS HARPOON WITH BARB RIGHTWARDS]"},
{"drbkarow",                 "U02910", "[RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW]"},
{"drcorn",                   "U0231F", "[BOTTOM RIGHT CORNER]"},
{"drcrop",                   "U0230C", "[BOTTOM RIGHT CROP]"},
{"dscr",                     "U1D4B9", "[MATHEMATICAL SCRIPT SMALL D]"},
{"dscy",                     "U00455", "[CYRILLIC SMALL LETTER DZE]"},
{"dsol",                     "U029F6", "[SOLIDUS WITH OVERBAR]"},
{"dstrok",                   "U00111", "[LATIN SMALL LETTER D WITH STROKE]"},
{"dtdot",                    "U022F1", "[DOWN RIGHT DIAGONAL ELLIPSIS]"},
{"dtri",                     "U025BF", "[WHITE DOWN-POINTING SMALL TRIANGLE]"},
{"dtrif",                    "U025BE", "[BLACK DOWN-POINTING SMALL TRIANGLE]"},
{"duarr",                    "U021F5", "[DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW]"},
{"duhar",                    "U0296F", "[DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT]"},
{"dwangle",                  "U029A6", "[OBLIQUE ANGLE OPENING UP]"},
{"dzcy",                     "U0045F", "[CYRILLIC SMALL LETTER DZHE]"},
{"dzigrarr",                 "U027FF", "[LONG RIGHTWARDS SQUIGGLE ARROW]"},
{"eDDot",                    "U02A77", "[EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW]"},
{"eDot",                     "U02251", "[GEOMETRICALLY EQUAL TO]"},
{"eacute",                   "U000E9", "[LATIN SMALL LETTER E WITH ACUTE]"},
{"easter",                   "U02A6E", "[EQUALS WITH ASTERISK]"},
{"ecaron",                   "U0011B", "[LATIN SMALL LETTER E WITH CARON]"},
{"ecir",                     "U02256", "[RING IN EQUAL TO]"},
{"ecirc",                    "U000EA", "[LATIN SMALL LETTER E WITH CIRCUMFLEX]"},
{"ecolon",                   "U02255", "[EQUALS COLON]"},
{"ecy",                      "U0044D", "[CYRILLIC SMALL LETTER E]"},
{"edot",                     "U00117", "[LATIN SMALL LETTER E WITH DOT ABOVE]"},
{"ee",                       "U02147", "[DOUBLE-STRUCK ITALIC SMALL E]"},
{"efDot",                    "U02252", "[APPROXIMATELY EQUAL TO OR THE IMAGE OF]"},
{"efr",                      "U1D522", "[MATHEMATICAL FRAKTUR SMALL E]"},
{"eg",                       "U02A9A", "[DOUBLE-LINE EQUAL TO OR GREATER-THAN]"},
{"egrave",                   "U000E8", "[LATIN SMALL LETTER E WITH GRAVE]"},
{"egs",                      "U02A96", "[SLANTED EQUAL TO OR GREATER-THAN]"},
{"egsdot",                   "U02A98", "[SLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDE]"},
{"el",                       "U02A99", "[DOUBLE-LINE EQUAL TO OR LESS-THAN]"},
{"elinters",                 "U0FFFD", "[REPLACEMENT CHARACTER]"},
{"ell",                      "U02113", "[SCRIPT SMALL L]"},
{"els",                      "U02A95", "[SLANTED EQUAL TO OR LESS-THAN]"},
{"elsdot",                   "U02A97", "[SLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDE]"},
{"emacr",                    "U00113", "[LATIN SMALL LETTER E WITH MACRON]"},
{"empty",                    "U02205", "[EMPTY SET]"},
{"emptyset",                 "U02205", "[EMPTY SET]"},
{"emptyv",                   "U02205", "[EMPTY SET]"},
{"emsp",                     "U02003", "[EM SPACE]"},
{"emsp13",                   "U02004", "[THREE-PER-EM SPACE]"},
{"emsp14",                   "U02005", "[FOUR-PER-EM SPACE]"},
{"eng",                      "U0014B", "[LATIN SMALL LETTER ENG]"},
{"ensp",                     "U02002", "[EN SPACE]"},
{"eogon",                    "U00119", "[LATIN SMALL LETTER E WITH OGONEK]"},
{"eopf",                     "U1D556", "[MATHEMATICAL DOUBLE-STRUCK SMALL E]"},
{"epar",                     "U022D5", "[EQUAL AND PARALLEL TO]"},
{"eparsl",                   "U029E3", "[EQUALS SIGN AND SLANTED PARALLEL]"},
{"eplus",                    "U02A71", "[EQUALS SIGN ABOVE PLUS SIGN]"},
{"epsi",                     "U003F5", "[GREEK LUNATE EPSILON SYMBOL]"},
{"epsiv",                    "U003B5", "[GREEK SMALL LETTER EPSILON]"},
{"eqcirc",                   "U02256", "[RING IN EQUAL TO]"},
{"eqcolon",                  "U02255", "[EQUALS COLON]"},
{"eqsim",                    "U02242", "[MINUS TILDE]"},
{"eqslantgtr",               "U02A96", "[SLANTED EQUAL TO OR GREATER-THAN]"},
{"eqslantless",              "U02A95", "[SLANTED EQUAL TO OR LESS-THAN]"},
{"equals",                   "U0003D", "[EQUALS SIGN]"},
{"equest",                   "U0225F", "[QUESTIONED EQUAL TO]"},
{"equiv",                    "U02261", "[IDENTICAL TO]"},
{"equivDD",                  "U02A78", "[EQUIVALENT WITH FOUR DOTS ABOVE]"},
{"eqvparsl",                 "U029E5", "[IDENTICAL TO AND SLANTED PARALLEL]"},
{"erDot",                    "U02253", "[IMAGE OF OR APPROXIMATELY EQUAL TO]"},
{"erarr",                    "U02971", "[EQUALS SIGN ABOVE RIGHTWARDS ARROW]"},
{"escr",                     "U0212F", "[SCRIPT SMALL E]"},
{"esdot",                    "U02250", "[APPROACHES THE LIMIT]"},
{"esim",                     "U02242", "[MINUS TILDE]"},
{"eta",                      "U003B7", "[GREEK SMALL LETTER ETA]"},
{"eth",                      "U000F0", "[LATIN SMALL LETTER ETH]"},
{"euml",                     "U000EB", "[LATIN SMALL LETTER E WITH DIAERESIS]"},
{"excl",                     "U00021", "[EXCLAMATION MARK]"},
{"exist",                    "U02203", "[THERE EXISTS]"},
{"expectation",              "U02130", "[SCRIPT CAPITAL E]"},
{"exponentiale",             "U02147", "[DOUBLE-STRUCK ITALIC SMALL E]"},
{"fallingdotseq",            "U02252", "[APPROXIMATELY EQUAL TO OR THE IMAGE OF]"},
{"fcy",                      "U00444", "[CYRILLIC SMALL LETTER EF]"},
{"female",                   "U02640", "[FEMALE SIGN]"},
{"ffilig",                   "U0FB03", "[LATIN SMALL LIGATURE FFI]"},
{"fflig",                    "U0FB00", "[LATIN SMALL LIGATURE FF]"},
{"ffllig",                   "U0FB04", "[LATIN SMALL LIGATURE FFL]"},
{"ffr",                      "U1D523", "[MATHEMATICAL FRAKTUR SMALL F]"},
{"filig",                    "U0FB01", "[LATIN SMALL LIGATURE FI]"},
{"flat",                     "U0266D", "[MUSIC FLAT SIGN]"},
{"fllig",                    "U0FB02", "[LATIN SMALL LIGATURE FL]"},
{"fltns",                    "U025B1", "[WHITE PARALLELOGRAM]"},
{"fnof",                     "U00192", "[LATIN SMALL LETTER F WITH HOOK]"},
{"fopf",                     "U1D557", "[MATHEMATICAL DOUBLE-STRUCK SMALL F]"},
{"forall",                   "U02200", "[FOR ALL]"},
{"fork",                     "U022D4", "[PITCHFORK]"},
{"forkv",                    "U02AD9", "[ELEMENT OF OPENING DOWNWARDS]"},
{"fpartint",                 "U02A0D", "[FINITE PART INTEGRAL]"},
{"frac12",                   "U000BD", "[VULGAR FRACTION ONE HALF]"},
{"frac13",                   "U02153", "[VULGAR FRACTION ONE THIRD]"},
{"frac14",                   "U000BC", "[VULGAR FRACTION ONE QUARTER]"},
{"frac15",                   "U02155", "[VULGAR FRACTION ONE FIFTH]"},
{"frac16",                   "U02159", "[VULGAR FRACTION ONE SIXTH]"},
{"frac18",                   "U0215B", "[VULGAR FRACTION ONE EIGHTH]"},
{"frac23",                   "U02154", "[VULGAR FRACTION TWO THIRDS]"},
{"frac25",                   "U02156", "[VULGAR FRACTION TWO FIFTHS]"},
{"frac34",                   "U000BE", "[VULGAR FRACTION THREE QUARTERS]"},
{"frac35",                   "U02157", "[VULGAR FRACTION THREE FIFTHS]"},
{"frac38",                   "U0215C", "[VULGAR FRACTION THREE EIGHTHS]"},
{"frac45",                   "U02158", "[VULGAR FRACTION FOUR FIFTHS]"},
{"frac56",                   "U0215A", "[VULGAR FRACTION FIVE SIXTHS]"},
{"frac58",                   "U0215D", "[VULGAR FRACTION FIVE EIGHTHS]"},
{"frac78",                   "U0215E", "[VULGAR FRACTION SEVEN EIGHTHS]"},
{"frown",                    "U02322", "[FROWN]"},
{"fscr",                     "U1D4BB", "[MATHEMATICAL SCRIPT SMALL F]"},
{"gE",                       "U02267", "[GREATER-THAN OVER EQUAL TO]"},
{"gEl",                      "U02A8C", "[GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN]"},
{"gacute",                   "U001F5", "[LATIN SMALL LETTER G WITH ACUTE]"},
{"gamma",                    "U003B3", "[GREEK SMALL LETTER GAMMA]"},
{"gammad",                   "U003DD", "[GREEK SMALL LETTER DIGAMMA]"},
{"gap",                      "U02A86", "[GREATER-THAN OR APPROXIMATE]"},
{"gbreve",                   "U0011F", "[LATIN SMALL LETTER G WITH BREVE]"},
{"gcirc",                    "U0011D", "[LATIN SMALL LETTER G WITH CIRCUMFLEX]"},
{"gcy",                      "U00433", "[CYRILLIC SMALL LETTER GHE]"},
{"gdot",                     "U00121", "[LATIN SMALL LETTER G WITH DOT ABOVE]"},
{"ge",                       "U02265", "[GREATER-THAN OR EQUAL TO]"},
{"gel",                      "U022DB", "[GREATER-THAN EQUAL TO OR LESS-THAN]"},
{"geq",                      "U02265", "[GREATER-THAN OR EQUAL TO]"},
{"geqq",                     "U02267", "[GREATER-THAN OVER EQUAL TO]"},
{"geqslant",                 "U02A7E", "[GREATER-THAN OR SLANTED EQUAL TO]"},
{"ges",                      "U02A7E", "[GREATER-THAN OR SLANTED EQUAL TO]"},
{"gescc",                    "U02AA9", "[GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL]"},
{"gesdot",                   "U02A80", "[GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE]"},
{"gesdoto",                  "U02A82", "[GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE]"},
{"gesdotol",                 "U02A84", "[GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT]"},
{"gesl",                     "U022DB-0FE00", "[GREATER-THAN slanted EQUAL TO OR LESS-THAN]"},
{"gesles",                   "U02A94", "[GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL]"},
{"gfr",                      "U1D524", "[MATHEMATICAL FRAKTUR SMALL G]"},
{"gg",                       "U0226B", "[MUCH GREATER-THAN]"},
{"ggg",                      "U022D9", "[VERY MUCH GREATER-THAN]"},
{"gimel",                    "U02137", "[GIMEL SYMBOL]"},
{"gjcy",                     "U00453", "[CYRILLIC SMALL LETTER GJE]"},
{"gl",                       "U02277", "[GREATER-THAN OR LESS-THAN]"},
{"glE",                      "U02A92", "[GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL]"},
{"gla",                      "U02AA5", "[GREATER-THAN BESIDE LESS-THAN]"},
{"glj",                      "U02AA4", "[GREATER-THAN OVERLAPPING LESS-THAN]"},
{"gnE",                      "U02269", "[GREATER-THAN BUT NOT EQUAL TO]"},
{"gnap",                     "U02A8A", "[GREATER-THAN AND NOT APPROXIMATE]"},
{"gnapprox",                 "U02A8A", "[GREATER-THAN AND NOT APPROXIMATE]"},
{"gne",                      "U02A88", "[GREATER-THAN AND SINGLE-LINE NOT EQUAL TO]"},
{"gneq",                     "U02A88", "[GREATER-THAN AND SINGLE-LINE NOT EQUAL TO]"},
{"gneqq",                    "U02269", "[GREATER-THAN BUT NOT EQUAL TO]"},
{"gnsim",                    "U022E7", "[GREATER-THAN BUT NOT EQUIVALENT TO]"},
{"gopf",                     "U1D558", "[MATHEMATICAL DOUBLE-STRUCK SMALL G]"},
{"grave",                    "U00060", "[GRAVE ACCENT]"},
{"gscr",                     "U0210A", "[SCRIPT SMALL G]"},
{"gsim",                     "U02273", "[GREATER-THAN OR EQUIVALENT TO]"},
{"gsime",                    "U02A8E", "[GREATER-THAN ABOVE SIMILAR OR EQUAL]"},
{"gsiml",                    "U02A90", "[GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN]"},
{"gt",                       "U0003E", "[GREATER-THAN SIGN]"},
{"gtcc",                     "U02AA7", "[GREATER-THAN CLOSED BY CURVE]"},
{"gtcir",                    "U02A7A", "[GREATER-THAN WITH CIRCLE INSIDE]"},
{"gtdot",                    "U022D7", "[GREATER-THAN WITH DOT]"},
{"gtlPar",                   "U02995", "[DOUBLE LEFT ARC GREATER-THAN BRACKET]"},
{"gtquest",                  "U02A7C", "[GREATER-THAN WITH QUESTION MARK ABOVE]"},
{"gtrapprox",                "U02A86", "[GREATER-THAN OR APPROXIMATE]"},
{"gtrarr",                   "U02978", "[GREATER-THAN ABOVE RIGHTWARDS ARROW]"},
{"gtrdot",                   "U022D7", "[GREATER-THAN WITH DOT]"},
{"gtreqless",                "U022DB", "[GREATER-THAN EQUAL TO OR LESS-THAN]"},
{"gtreqqless",               "U02A8C", "[GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN]"},
{"gtrless",                  "U02277", "[GREATER-THAN OR LESS-THAN]"},
{"gtrsim",                   "U02273", "[GREATER-THAN OR EQUIVALENT TO]"},
{"gvertneqq",                "U02269-0FE00", "[GREATER-THAN BUT NOT EQUAL TO - with vertical stroke]"},
{"gvnE",                     "U02269-0FE00", "[GREATER-THAN BUT NOT EQUAL TO - with vertical stroke]"},
{"hArr",                     "U021D4", "[LEFT RIGHT DOUBLE ARROW]"},
{"hairsp",                   "U0200A", "[HAIR SPACE]"},
{"half",                     "U000BD", "[VULGAR FRACTION ONE HALF]"},
{"hamilt",                   "U0210B", "[SCRIPT CAPITAL H]"},
{"hardcy",                   "U0044A", "[CYRILLIC SMALL LETTER HARD SIGN]"},
{"harr",                     "U02194", "[LEFT RIGHT ARROW]"},
{"harrcir",                  "U02948", "[LEFT RIGHT ARROW THROUGH SMALL CIRCLE]"},
{"harrw",                    "U021AD", "[LEFT RIGHT WAVE ARROW]"},
{"hbar",                     "U0210F", "[PLANCK CONSTANT OVER TWO PI]"},
{"hcirc",                    "U00125", "[LATIN SMALL LETTER H WITH CIRCUMFLEX]"},
{"hearts",                   "U02665", "[BLACK HEART SUIT]"},
{"heartsuit",                "U02665", "[BLACK HEART SUIT]"},
{"hellip",                   "U02026", "[HORIZONTAL ELLIPSIS]"},
{"hercon",                   "U022B9", "[HERMITIAN CONJUGATE MATRIX]"},
{"hfr",                      "U1D525", "[MATHEMATICAL FRAKTUR SMALL H]"},
{"hksearow",                 "U02925", "[SOUTH EAST ARROW WITH HOOK]"},
{"hkswarow",                 "U02926", "[SOUTH WEST ARROW WITH HOOK]"},
{"hoarr",                    "U021FF", "[LEFT RIGHT OPEN-HEADED ARROW]"},
{"homtht",                   "U0223B", "[HOMOTHETIC]"},
{"hookleftarrow",            "U021A9", "[LEFTWARDS ARROW WITH HOOK]"},
{"hookrightarrow",           "U021AA", "[RIGHTWARDS ARROW WITH HOOK]"},
{"hopf",                     "U1D559", "[MATHEMATICAL DOUBLE-STRUCK SMALL H]"},
{"horbar",                   "U02015", "[HORIZONTAL BAR]"},
{"hscr",                     "U1D4BD", "[MATHEMATICAL SCRIPT SMALL H]"},
{"hslash",                   "U0210F", "[PLANCK CONSTANT OVER TWO PI]"},
{"hstrok",                   "U00127", "[LATIN SMALL LETTER H WITH STROKE]"},
{"hybull",                   "U02043", "[HYPHEN BULLET]"},
{"hyphen",                   "U02010", "[HYPHEN]"},
{"iacute",                   "U000ED", "[LATIN SMALL LETTER I WITH ACUTE]"},
{"ic",                       "U02063", "[INVISIBLE SEPARATOR]"},
{"icirc",                    "U000EE", "[LATIN SMALL LETTER I WITH CIRCUMFLEX]"},
{"icy",                      "U00438", "[CYRILLIC SMALL LETTER I]"},
{"iecy",                     "U00435", "[CYRILLIC SMALL LETTER IE]"},
{"iexcl",                    "U000A1", "[INVERTED EXCLAMATION MARK]"},
{"iff",                      "U021D4", "[LEFT RIGHT DOUBLE ARROW]"},
{"ifr",                      "U1D526", "[MATHEMATICAL FRAKTUR SMALL I]"},
{"igrave",                   "U000EC", "[LATIN SMALL LETTER I WITH GRAVE]"},
{"ii",                       "U02148", "[DOUBLE-STRUCK ITALIC SMALL I]"},
{"iiiint",                   "U02A0C", "[QUADRUPLE INTEGRAL OPERATOR]"},
{"iiint",                    "U0222D", "[TRIPLE INTEGRAL]"},
{"iinfin",                   "U029DC", "[INCOMPLETE INFINITY]"},
{"iiota",                    "U02129", "[TURNED GREEK SMALL LETTER IOTA]"},
{"ijlig",                    "U00133", "[LATIN SMALL LIGATURE IJ]"},
{"imacr",                    "U0012B", "[LATIN SMALL LETTER I WITH MACRON]"},
{"image",                    "U02111", "[BLACK-LETTER CAPITAL I]"},
{"imagline",                 "U02110", "[SCRIPT CAPITAL I]"},
{"imagpart",                 "U02111", "[BLACK-LETTER CAPITAL I]"},
{"imath",                    "U00131", "[LATIN SMALL LETTER DOTLESS I]"},
{"imof",                     "U022B7", "[IMAGE OF]"},
{"imped",                    "U001B5", "[LATIN CAPITAL LETTER Z WITH STROKE]"},
{"in",                       "U02208", "[ELEMENT OF]"},
{"incare",                   "U02105", "[CARE OF]"},
{"infin",                    "U0221E", "[INFINITY]"},
{"infintie",                 "U029DD", "[TIE OVER INFINITY]"},
{"inodot",                   "U00131", "[LATIN SMALL LETTER DOTLESS I]"},
{"int",                      "U0222B", "[INTEGRAL]"},
{"intcal",                   "U022BA", "[INTERCALATE]"},
{"integers",                 "U02124", "[DOUBLE-STRUCK CAPITAL Z]"},
{"intercal",                 "U022BA", "[INTERCALATE]"},
{"intlarhk",                 "U02A17", "[INTEGRAL WITH LEFTWARDS ARROW WITH HOOK]"},
{"intprod",                  "U02A3C", "[INTERIOR PRODUCT]"},
{"iocy",                     "U00451", "[CYRILLIC SMALL LETTER IO]"},
{"iogon",                    "U0012F", "[LATIN SMALL LETTER I WITH OGONEK]"},
{"iopf",                     "U1D55A", "[MATHEMATICAL DOUBLE-STRUCK SMALL I]"},
{"iota",                     "U003B9", "[GREEK SMALL LETTER IOTA]"},
{"iprod",                    "U02A3C", "[INTERIOR PRODUCT]"},
{"iquest",                   "U000BF", "[INVERTED QUESTION MARK]"},
{"iscr",                     "U1D4BE", "[MATHEMATICAL SCRIPT SMALL I]"},
{"isin",                     "U02208", "[ELEMENT OF]"},
{"isinE",                    "U022F9", "[ELEMENT OF WITH TWO HORIZONTAL STROKES]"},
{"isindot",                  "U022F5", "[ELEMENT OF WITH DOT ABOVE]"},
{"isins",                    "U022F4", "[SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE]"},
{"isinsv",                   "U022F3", "[ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE]"},
{"isinv",                    "U02208", "[ELEMENT OF]"},
{"it",                       "U02062", "[INVISIBLE TIMES]"},
{"itilde",                   "U00129", "[LATIN SMALL LETTER I WITH TILDE]"},
{"iukcy",                    "U00456", "[CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I]"},
{"iuml",                     "U000EF", "[LATIN SMALL LETTER I WITH DIAERESIS]"},
{"jcirc",                    "U00135", "[LATIN SMALL LETTER J WITH CIRCUMFLEX]"},
{"jcy",                      "U00439", "[CYRILLIC SMALL LETTER SHORT I]"},
{"jfr",                      "U1D527", "[MATHEMATICAL FRAKTUR SMALL J]"},
{"jmath",                    "U0006A", "[LATIN SMALL LETTER J]"},
{"jopf",                     "U1D55B", "[MATHEMATICAL DOUBLE-STRUCK SMALL J]"},
{"jscr",                     "U1D4BF", "[MATHEMATICAL SCRIPT SMALL J]"},
{"jsercy",                   "U00458", "[CYRILLIC SMALL LETTER JE]"},
{"jukcy",                    "U00454", "[CYRILLIC SMALL LETTER UKRAINIAN IE]"},
{"kappa",                    "U003BA", "[GREEK SMALL LETTER KAPPA]"},
{"kappav",                   "U003F0", "[GREEK KAPPA SYMBOL]"},
{"kcedil",                   "U00137", "[LATIN SMALL LETTER K WITH CEDILLA]"},
{"kcy",                      "U0043A", "[CYRILLIC SMALL LETTER KA]"},
{"kfr",                      "U1D528", "[MATHEMATICAL FRAKTUR SMALL K]"},
{"kgreen",                   "U00138", "[LATIN SMALL LETTER KRA]"},
{"khcy",                     "U00445", "[CYRILLIC SMALL LETTER HA]"},
{"kjcy",                     "U0045C", "[CYRILLIC SMALL LETTER KJE]"},
{"kopf",                     "U1D55C", "[MATHEMATICAL DOUBLE-STRUCK SMALL K]"},
{"kscr",                     "U1D4C0", "[MATHEMATICAL SCRIPT SMALL K]"},
{"lAarr",                    "U021DA", "[LEFTWARDS TRIPLE ARROW]"},
{"lArr",                     "U021D0", "[LEFTWARDS DOUBLE ARROW]"},
{"lAtail",                   "U0291B", "[LEFTWARDS DOUBLE ARROW-TAIL]"},
{"lBarr",                    "U0290E", "[LEFTWARDS TRIPLE DASH ARROW]"},
{"lE",                       "U02266", "[LESS-THAN OVER EQUAL TO]"},
{"lEg",                      "U02A8B", "[LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN]"},
{"lHar",                     "U02962", "[LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN]"},
{"lacute",                   "U0013A", "[LATIN SMALL LETTER L WITH ACUTE]"},
{"laemptyv",                 "U029B4", "[EMPTY SET WITH LEFT ARROW ABOVE]"},
{"lagran",                   "U02112", "[SCRIPT CAPITAL L]"},
{"lambda",                   "U003BB", "[GREEK SMALL LETTER LAMDA]"},
{"lang",                     "U02329", "[LEFT-POINTING ANGLE BRACKET]"},
{"langd",                    "U02991", "[LEFT ANGLE BRACKET WITH DOT]"},
{"langle",                   "U02329", "[LEFT-POINTING ANGLE BRACKET]"},
{"lap",                      "U02A85", "[LESS-THAN OR APPROXIMATE]"},
{"laquo",                    "U000AB", "[LEFT-POINTING DOUBLE ANGLE QUOTATION MARK]"},
{"larr",                     "U02190", "[LEFTWARDS ARROW]"},
{"larrb",                    "U021E4", "[LEFTWARDS ARROW TO BAR]"},
{"larrbfs",                  "U0291F", "[LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND]"},
{"larrfs",                   "U0291D", "[LEFTWARDS ARROW TO BLACK DIAMOND]"},
{"larrhk",                   "U021A9", "[LEFTWARDS ARROW WITH HOOK]"},
{"larrlp",                   "U021AB", "[LEFTWARDS ARROW WITH LOOP]"},
{"larrpl",                   "U02939", "[LEFT-SIDE ARC ANTICLOCKWISE ARROW]"},
{"larrsim",                  "U02973", "[LEFTWARDS ARROW ABOVE TILDE OPERATOR]"},
{"larrtl",                   "U021A2", "[LEFTWARDS ARROW WITH TAIL]"},
{"lat",                      "U02AAB", "[LARGER THAN]"},
{"latail",                   "U02919", "[LEFTWARDS ARROW-TAIL]"},
{"late",                     "U02AAD", "[LARGER THAN OR EQUAL TO]"},
{"lates",                    "U02AAD-0FE00", "[LARGER THAN OR slanted EQUAL]"},
{"lbarr",                    "U0290C", "[LEFTWARDS DOUBLE DASH ARROW]"},
{"lbbrk",                    "U03014", "[LEFT TORTOISE SHELL BRACKET]"},
{"lbrace",                   "U0007B", "[LEFT CURLY BRACKET]"},
{"lbrack",                   "U0005B", "[LEFT SQUARE BRACKET]"},
{"lbrke",                    "U0298B", "[LEFT SQUARE BRACKET WITH UNDERBAR]"},
{"lbrksld",                  "U0298F", "[LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER]"},
{"lbrkslu",                  "U0298D", "[LEFT SQUARE BRACKET WITH TICK IN TOP CORNER]"},
{"lcaron",                   "U0013E", "[LATIN SMALL LETTER L WITH CARON]"},
{"lcedil",                   "U0013C", "[LATIN SMALL LETTER L WITH CEDILLA]"},
{"lceil",                    "U02308", "[LEFT CEILING]"},
{"lcub",                     "U0007B", "[LEFT CURLY BRACKET]"},
{"lcy",                      "U0043B", "[CYRILLIC SMALL LETTER EL]"},
{"ldca",                     "U02936", "[ARROW POINTING DOWNWARDS THEN CURVING LEFTWARDS]"},
{"ldquo",                    "U0201C", "[LEFT DOUBLE QUOTATION MARK]"},
{"ldquor",                   "U0201E", "[DOUBLE LOW-9 QUOTATION MARK]"},
{"ldrdhar",                  "U02967", "[LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN]"},
{"ldrushar",                 "U0294B", "[LEFT BARB DOWN RIGHT BARB UP HARPOON]"},
{"ldsh",                     "U021B2", "[DOWNWARDS ARROW WITH TIP LEFTWARDS]"},
{"le",                       "U02264", "[LESS-THAN OR EQUAL TO]"},
{"leftarrow",                "U02190", "[LEFTWARDS ARROW]"},
{"leftarrowtail",            "U021A2", "[LEFTWARDS ARROW WITH TAIL]"},
{"leftharpoondown",          "U021BD", "[LEFTWARDS HARPOON WITH BARB DOWNWARDS]"},
{"leftharpoonup",            "U021BC", "[LEFTWARDS HARPOON WITH BARB UPWARDS]"},
{"leftleftarrows",           "U021C7", "[LEFTWARDS PAIRED ARROWS]"},
{"leftrightarrow",           "U02194", "[LEFT RIGHT ARROW]"},
{"leftrightarrows",          "U021C6", "[LEFTWARDS ARROW OVER RIGHTWARDS ARROW]"},
{"leftrightharpoons",        "U021CB", "[LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON]"},
{"leftrightsquigarrow",      "U021AD", "[LEFT RIGHT WAVE ARROW]"},
{"leftthreetimes",           "U022CB", "[LEFT SEMIDIRECT PRODUCT]"},
{"leg",                      "U022DA", "[LESS-THAN EQUAL TO OR GREATER-THAN]"},
{"leq",                      "U02264", "[LESS-THAN OR EQUAL TO]"},
{"leqq",                     "U02266", "[LESS-THAN OVER EQUAL TO]"},
{"leqslant",                 "U02A7D", "[LESS-THAN OR SLANTED EQUAL TO]"},
{"les",                      "U02A7D", "[LESS-THAN OR SLANTED EQUAL TO]"},
{"lescc",                    "U02AA8", "[LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL]"},
{"lesdot",                   "U02A7F", "[LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE]"},
{"lesdoto",                  "U02A81", "[LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE]"},
{"lesdotor",                 "U02A83", "[LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT]"},
{"lesg",                     "U022DA-0FE00", "[LESS-THAN slanted EQUAL TO OR GREATER-THAN]"},
{"lesges",                   "U02A93", "[LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL]"},
{"lessapprox",               "U02A85", "[LESS-THAN OR APPROXIMATE]"},
{"lessdot",                  "U022D6", "[LESS-THAN WITH DOT]"},
{"lesseqgtr",                "U022DA", "[LESS-THAN EQUAL TO OR GREATER-THAN]"},
{"lesseqqgtr",               "U02A8B", "[LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN]"},
{"lessgtr",                  "U02276", "[LESS-THAN OR GREATER-THAN]"},
{"lesssim",                  "U02272", "[LESS-THAN OR EQUIVALENT TO]"},
{"lfisht",                   "U0297C", "[LEFT FISH TAIL]"},
{"lfloor",                   "U0230A", "[LEFT FLOOR]"},
{"lfr",                      "U1D529", "[MATHEMATICAL FRAKTUR SMALL L]"},
{"lg",                       "U02276", "[LESS-THAN OR GREATER-THAN]"},
{"lgE",                      "U02A91", "[LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL]"},
{"lhard",                    "U021BD", "[LEFTWARDS HARPOON WITH BARB DOWNWARDS]"},
{"lharu",                    "U021BC", "[LEFTWARDS HARPOON WITH BARB UPWARDS]"},
{"lharul",                   "U0296A", "[LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH]"},
{"lhblk",                    "U02584", "[LOWER HALF BLOCK]"},
{"ljcy",                     "U00459", "[CYRILLIC SMALL LETTER LJE]"},
{"ll",                       "U0226A", "[MUCH LESS-THAN]"},
{"llarr",                    "U021C7", "[LEFTWARDS PAIRED ARROWS]"},
{"llcorner",                 "U0231E", "[BOTTOM LEFT CORNER]"},
{"llhard",                   "U0296B", "[LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH]"},
{"lltri",                    "U025FA", "[LOWER LEFT TRIANGLE]"},
{"lmidot",                   "U00140", "[LATIN SMALL LETTER L WITH MIDDLE DOT]"},
{"lmoust",                   "U023B0", "[UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION]"},
{"lmoustache",               "U023B0", "[UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION]"},
{"lnE",                      "U02268", "[LESS-THAN BUT NOT EQUAL TO]"},
{"lnap",                     "U02A89", "[LESS-THAN AND NOT APPROXIMATE]"},
{"lnapprox",                 "U02A89", "[LESS-THAN AND NOT APPROXIMATE]"},
{"lne",                      "U02A87", "[LESS-THAN AND SINGLE-LINE NOT EQUAL TO]"},
{"lneq",                     "U02A87", "[LESS-THAN AND SINGLE-LINE NOT EQUAL TO]"},
{"lneqq",                    "U02268", "[LESS-THAN BUT NOT EQUAL TO]"},
{"lnsim",                    "U022E6", "[LESS-THAN BUT NOT EQUIVALENT TO]"},
{"loang",                    "U03018", "[LEFT WHITE TORTOISE SHELL BRACKET]"},
{"loarr",                    "U021FD", "[LEFTWARDS OPEN-HEADED ARROW]"},
{"lobrk",                    "U0301A", "[LEFT WHITE SQUARE BRACKET]"},
{"longleftarrow",            "U027F5", "[LONG LEFTWARDS ARROW]"},
{"longleftrightarrow",       "U027F7", "[LONG LEFT RIGHT ARROW]"},
{"longmapsto",               "U027FC", "[LONG RIGHTWARDS ARROW FROM BAR]"},
{"longrightarrow",           "U027F6", "[LONG RIGHTWARDS ARROW]"},
{"looparrowleft",            "U021AB", "[LEFTWARDS ARROW WITH LOOP]"},
{"looparrowright",           "U021AC", "[RIGHTWARDS ARROW WITH LOOP]"},
{"lopar",                    "U02985", "[LEFT WHITE PARENTHESIS]"},
{"lopf",                     "U1D55D", "[MATHEMATICAL DOUBLE-STRUCK SMALL L]"},
{"loplus",                   "U02A2D", "[PLUS SIGN IN LEFT HALF CIRCLE]"},
{"lotimes",                  "U02A34", "[MULTIPLICATION SIGN IN LEFT HALF CIRCLE]"},
{"lowast",                   "U02217", "[ASTERISK OPERATOR]"},
{"lowbar",                   "U0005F", "[LOW LINE]"},
{"loz",                      "U025CA", "[LOZENGE]"},
{"lozenge",                  "U025CA", "[LOZENGE]"},
{"lozf",                     "U029EB", "[BLACK LOZENGE]"},
{"lpar",                     "U00028", "[LEFT PARENTHESIS]"},
{"lparlt",                   "U02993", "[LEFT ARC LESS-THAN BRACKET]"},
{"lrarr",                    "U021C6", "[LEFTWARDS ARROW OVER RIGHTWARDS ARROW]"},
{"lrcorner",                 "U0231F", "[BOTTOM RIGHT CORNER]"},
{"lrhar",                    "U021CB", "[LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON]"},
{"lrhard",                   "U0296D", "[RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH]"},
{"lrtri",                    "U022BF", "[RIGHT TRIANGLE]"},
{"lscr",                     "U1D4C1", "[MATHEMATICAL SCRIPT SMALL L]"},
{"lsh",                      "U021B0", "[UPWARDS ARROW WITH TIP LEFTWARDS]"},
{"lsim",                     "U02272", "[LESS-THAN OR EQUIVALENT TO]"},
{"lsime",                    "U02A8D", "[LESS-THAN ABOVE SIMILAR OR EQUAL]"},
{"lsimg",                    "U02A8F", "[LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN]"},
{"lsqb",                     "U0005B", "[LEFT SQUARE BRACKET]"},
{"lsquo",                    "U02018", "[LEFT SINGLE QUOTATION MARK]"},
{"lsquor",                   "U0201A", "[SINGLE LOW-9 QUOTATION MARK]"},
{"lstrok",                   "U00142", "[LATIN SMALL LETTER L WITH STROKE]"},
{"lt",                       "U0003C", "[LESS-THAN SIGN]"},
{"ltcc",                     "U02AA6", "[LESS-THAN CLOSED BY CURVE]"},
{"ltcir",                    "U02A79", "[LESS-THAN WITH CIRCLE INSIDE]"},
{"ltdot",                    "U022D6", "[LESS-THAN WITH DOT]"},
{"lthree",                   "U022CB", "[LEFT SEMIDIRECT PRODUCT]"},
{"ltimes",                   "U022C9", "[LEFT NORMAL FACTOR SEMIDIRECT PRODUCT]"},
{"ltlarr",                   "U02976", "[LESS-THAN ABOVE LEFTWARDS ARROW]"},
{"ltquest",                  "U02A7B", "[LESS-THAN WITH QUESTION MARK ABOVE]"},
{"ltrPar",                   "U02996", "[DOUBLE RIGHT ARC LESS-THAN BRACKET]"},
{"ltri",                     "U025C3", "[WHITE LEFT-POINTING SMALL TRIANGLE]"},
{"ltrie",                    "U022B4", "[NORMAL SUBGROUP OF OR EQUAL TO]"},
{"ltrif",                    "U025C2", "[BLACK LEFT-POINTING SMALL TRIANGLE]"},
{"lurdshar",                 "U0294A", "[LEFT BARB UP RIGHT BARB DOWN HARPOON]"},
{"luruhar",                  "U02966", "[LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP]"},
{"lvertneqq",                "U02268-0FE00", "[LESS-THAN BUT NOT EQUAL TO - with vertical stroke]"},
{"lvnE",                     "U02268-0FE00", "[LESS-THAN BUT NOT EQUAL TO - with vertical stroke]"},
{"mDDot",                    "U0223A", "[GEOMETRIC PROPORTION]"},
{"macr",                     "U000AF", "[MACRON]"},
{"male",                     "U02642", "[MALE SIGN]"},
{"malt",                     "U02720", "[MALTESE CROSS]"},
{"maltese",                  "U02720", "[MALTESE CROSS]"},
{"map",                      "U021A6", "[RIGHTWARDS ARROW FROM BAR]"},
{"mapsto",                   "U021A6", "[RIGHTWARDS ARROW FROM BAR]"},
{"mapstodown",               "U021A7", "[DOWNWARDS ARROW FROM BAR]"},
{"mapstoleft",               "U021A4", "[LEFTWARDS ARROW FROM BAR]"},
{"mapstoup",                 "U021A5", "[UPWARDS ARROW FROM BAR]"},
{"marker",                   "U025AE", "[BLACK VERTICAL RECTANGLE]"},
{"mcomma",                   "U02A29", "[MINUS SIGN WITH COMMA ABOVE]"},
{"mcy",                      "U0043C", "[CYRILLIC SMALL LETTER EM]"},
{"mdash",                    "U02014", "[EM DASH]"},
{"measuredangle",            "U02221", "[MEASURED ANGLE]"},
{"mfr",                      "U1D52A", "[MATHEMATICAL FRAKTUR SMALL M]"},
{"mho",                      "U02127", "[INVERTED OHM SIGN]"},
{"micro",                    "U000B5", "[MICRO SIGN]"},
{"mid",                      "U02223", "[DIVIDES]"},
{"midast",                   "U0002A", "[ASTERISK]"},
{"midcir",                   "U02AF0", "[VERTICAL LINE WITH CIRCLE BELOW]"},
{"middot",                   "U000B7", "[MIDDLE DOT]"},
{"minus",                    "U02212", "[MINUS SIGN]"},
{"minusb",                   "U0229F", "[SQUARED MINUS]"},
{"minusd",                   "U02238", "[DOT MINUS]"},
{"minusdu",                  "U02A2A", "[MINUS SIGN WITH DOT BELOW]"},
{"mlcp",                     "U02ADB", "[TRANSVERSAL INTERSECTION]"},
{"mldr",                     "U02026", "[HORIZONTAL ELLIPSIS]"},
{"mnplus",                   "U02213", "[MINUS-OR-PLUS SIGN]"},
{"models",                   "U022A7", "[MODELS]"},
{"mopf",                     "U1D55E", "[MATHEMATICAL DOUBLE-STRUCK SMALL M]"},
{"mp",                       "U02213", "[MINUS-OR-PLUS SIGN]"},
{"mscr",                     "U1D4C2", "[MATHEMATICAL SCRIPT SMALL M]"},
{"mstpos",                   "U0223E", "[INVERTED LAZY S]"},
{"mu",                       "U003BC", "[GREEK SMALL LETTER MU]"},
{"multimap",                 "U022B8", "[MULTIMAP]"},
{"mumap",                    "U022B8", "[MULTIMAP]"},
{"nGg",                      "U022D9-00338", "[VERY MUCH GREATER-THAN with slash]"},
{"nGt",                      "U0226B-020D2", "[MUCH GREATER THAN with vertical line]"},
{"nGtv",                     "U0226B-00338", "[MUCH GREATER THAN with slash]"},
{"nLeftarrow",               "U021CD", "[LEFTWARDS DOUBLE ARROW WITH STROKE]"},
{"nLeftrightarrow",          "U021CE", "[LEFT RIGHT DOUBLE ARROW WITH STROKE]"},
{"nLl",                      "U022D8-00338", "[VERY MUCH LESS-THAN with slash]"},
{"nLt",                      "U0226A-020D2", "[MUCH LESS THAN with vertical line]"},
{"nLtv",                     "U0226A-00338", "[MUCH LESS THAN with slash]"},
{"nRightarrow",              "U021CF", "[RIGHTWARDS DOUBLE ARROW WITH STROKE]"},
{"nVDash",                   "U022AF", "[NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE]"},
{"nVdash",                   "U022AE", "[DOES NOT FORCE]"},
{"nabla",                    "U02207", "[NABLA]"},
{"nacute",                   "U00144", "[LATIN SMALL LETTER N WITH ACUTE]"},
{"nang",                     "U02220-020D2", "[ANGLE with vertical line]"},
{"nap",                      "U02249", "[NOT ALMOST EQUAL TO]"},
{"napE",                     "U02A70-00338", "[APPROXIMATELY EQUAL OR EQUAL TO with slash]"},
{"napid",                    "U0224B-00338", "[TRIPLE TILDE with slash]"},
{"napos",                    "U00149", "[LATIN SMALL LETTER N PRECEDED BY APOSTROPHE]"},
{"napprox",                  "U02249", "[NOT ALMOST EQUAL TO]"},
{"natur",                    "U0266E", "[MUSIC NATURAL SIGN]"},
{"natural",                  "U0266E", "[MUSIC NATURAL SIGN]"},
{"naturals",                 "U02115", "[DOUBLE-STRUCK CAPITAL N]"},
{"nbsp",                     "U000A0", "[NO-BREAK SPACE]"},
{"nbump",                    "U0224E-00338", "[GEOMETRICALLY EQUIVALENT TO with slash]"},
{"nbumpe",                   "U0224F-00338", "[DIFFERENCE BETWEEN with slash]"},
{"ncap",                     "U02A43", "[INTERSECTION WITH OVERBAR]"},
{"ncaron",                   "U00148", "[LATIN SMALL LETTER N WITH CARON]"},
{"ncedil",                   "U00146", "[LATIN SMALL LETTER N WITH CEDILLA]"},
{"ncong",                    "U02247", "[NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO]"},
{"ncongdot",                 "U02A6D-00338", "[CONGRUENT WITH DOT ABOVE with slash]"},
{"ncup",                     "U02A42", "[UNION WITH OVERBAR]"},
{"ncy",                      "U0043D", "[CYRILLIC SMALL LETTER EN]"},
{"ndash",                    "U02013", "[EN DASH]"},
{"ne",                       "U02260", "[NOT EQUAL TO]"},
{"neArr",                    "U021D7", "[NORTH EAST DOUBLE ARROW]"},
{"nearhk",                   "U02924", "[NORTH EAST ARROW WITH HOOK]"},
{"nearr",                    "U02197", "[NORTH EAST ARROW]"},
{"nearrow",                  "U02197", "[NORTH EAST ARROW]"},
{"nedot",                    "U02250-00338", "[APPROACHES THE LIMIT with slash]"},
{"nequiv",                   "U02262", "[NOT IDENTICAL TO]"},
{"nesear",                   "U02928", "[NORTH EAST ARROW AND SOUTH EAST ARROW]"},
{"nesim",                    "U02242-00338", "[MINUS TILDE with slash]"},
{"nexist",                   "U02204", "[THERE DOES NOT EXIST]"},
{"nexists",                  "U02204", "[THERE DOES NOT EXIST]"},
{"nfr",                      "U1D52B", "[MATHEMATICAL FRAKTUR SMALL N]"},
{"ngE",                      "U02267-00338", "[GREATER-THAN OVER EQUAL TO with slash]"},
{"nge",                      "U02271", "[NEITHER GREATER-THAN NOR EQUAL TO]"},
{"ngeq",                     "U02271", "[NEITHER GREATER-THAN NOR EQUAL TO]"},
{"ngeqq",                    "U02267-00338", "[GREATER-THAN OVER EQUAL TO with slash]"},
{"ngeqslant",                "U02A7E-00338", "[GREATER-THAN OR SLANTED EQUAL TO with slash]"},
{"nges",                     "U02A7E-00338", "[GREATER-THAN OR SLANTED EQUAL TO with slash]"},
{"ngsim",                    "U02275", "[NEITHER GREATER-THAN NOR EQUIVALENT TO]"},
{"ngt",                      "U0226F", "[NOT GREATER-THAN]"},
{"ngtr",                     "U0226F", "[NOT GREATER-THAN]"},
{"nhArr",                    "U021CE", "[LEFT RIGHT DOUBLE ARROW WITH STROKE]"},
{"nharr",                    "U021AE", "[LEFT RIGHT ARROW WITH STROKE]"},
{"nhpar",                    "U02AF2", "[PARALLEL WITH HORIZONTAL STROKE]"},
{"ni",                       "U0220B", "[CONTAINS AS MEMBER]"},
{"nis",                      "U022FC", "[SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE]"},
{"nisd",                     "U022FA", "[CONTAINS WITH LONG HORIZONTAL STROKE]"},
{"niv",                      "U0220B", "[CONTAINS AS MEMBER]"},
{"njcy",                     "U0045A", "[CYRILLIC SMALL LETTER NJE]"},
{"nlArr",                    "U021CD", "[LEFTWARDS DOUBLE ARROW WITH STROKE]"},
{"nlE",                      "U02266-00338", "[LESS-THAN OVER EQUAL TO with slash]"},
{"nlarr",                    "U0219A", "[LEFTWARDS ARROW WITH STROKE]"},
{"nldr",                     "U02025", "[TWO DOT LEADER]"},
{"nle",                      "U02270", "[NEITHER LESS-THAN NOR EQUAL TO]"},
{"nleftarrow",               "U0219A", "[LEFTWARDS ARROW WITH STROKE]"},
{"nleftrightarrow",          "U021AE", "[LEFT RIGHT ARROW WITH STROKE]"},
{"nleq",                     "U02270", "[NEITHER LESS-THAN NOR EQUAL TO]"},
{"nleqq",                    "U02266-00338", "[LESS-THAN OVER EQUAL TO with slash]"},
{"nleqslant",                "U02A7D-00338", "[LESS-THAN OR SLANTED EQUAL TO with slash]"},
{"nles",                     "U02A7D-00338", "[LESS-THAN OR SLANTED EQUAL TO with slash]"},
{"nless",                    "U0226E", "[NOT LESS-THAN]"},
{"nlsim",                    "U02274", "[NEITHER LESS-THAN NOR EQUIVALENT TO]"},
{"nlt",                      "U0226E", "[NOT LESS-THAN]"},
{"nltri",                    "U022EA", "[NOT NORMAL SUBGROUP OF]"},
{"nltrie",                   "U022EC", "[NOT NORMAL SUBGROUP OF OR EQUAL TO]"},
{"nmid",                     "U02224", "[DOES NOT DIVIDE]"},
{"nopf",                     "U1D55F", "[MATHEMATICAL DOUBLE-STRUCK SMALL N]"},
{"not",                      "U000AC", "[NOT SIGN]"},
{"notin",                    "U02209", "[NOT AN ELEMENT OF]"},
{"notinE",                   "U022F9-00338", "[ELEMENT OF WITH TWO HORIZONTAL STROKES with slash]"},
{"notindot",                 "U022F5-00338", "[ELEMENT OF WITH DOT ABOVE with slash]"},
{"notinva",                  "U02209", "[NOT AN ELEMENT OF]"},
{"notinvb",                  "U022F7", "[SMALL ELEMENT OF WITH OVERBAR]"},
{"notinvc",                  "U022F6", "[ELEMENT OF WITH OVERBAR]"},
{"notni",                    "U0220C", "[DOES NOT CONTAIN AS MEMBER]"},
{"notniva",                  "U0220C", "[DOES NOT CONTAIN AS MEMBER]"},
{"notnivb",                  "U022FE", "[SMALL CONTAINS WITH OVERBAR]"},
{"notnivc",                  "U022FD", "[CONTAINS WITH OVERBAR]"},
{"npar",                     "U02226", "[NOT PARALLEL TO]"},
{"nparallel",                "U02226", "[NOT PARALLEL TO]"},
{"nparsl",                   "U02AFD-020E5", "[DOUBLE SOLIDUS OPERATOR with reverse slash]"},
{"npart",                    "U02202-00338", "[PARTIAL DIFFERENTIAL with slash]"},
{"npolint",                  "U02A14", "[LINE INTEGRATION NOT INCLUDING THE POLE]"},
{"npr",                      "U02280", "[DOES NOT PRECEDE]"},
{"nprcue",                   "U022E0", "[DOES NOT PRECEDE OR EQUAL]"},
{"npre",                     "U02AAF-00338", "[PRECEDES ABOVE SINGLE-LINE EQUALS SIGN with slash]"},
{"nprec",                    "U02280", "[DOES NOT PRECEDE]"},
{"npreceq",                  "U02AAF-00338", "[PRECEDES ABOVE SINGLE-LINE EQUALS SIGN with slash]"},
{"nrArr",                    "U021CF", "[RIGHTWARDS DOUBLE ARROW WITH STROKE]"},
{"nrarr",                    "U0219B", "[RIGHTWARDS ARROW WITH STROKE]"},
{"nrarrc",                   "U02933-00338", "[WAVE ARROW POINTING DIRECTLY RIGHT with slash]"},
{"nrarrw",                   "U0219D-00338", "[RIGHTWARDS WAVE ARROW with slash]"},
{"nrightarrow",              "U0219B", "[RIGHTWARDS ARROW WITH STROKE]"},
{"nrtri",                    "U022EB", "[DOES NOT CONTAIN AS NORMAL SUBGROUP]"},
{"nrtrie",                   "U022ED", "[DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL]"},
{"nsc",                      "U02281", "[DOES NOT SUCCEED]"},
{"nsccue",                   "U022E1", "[DOES NOT SUCCEED OR EQUAL]"},
{"nsce",                     "U02AB0-00338", "[SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN with slash]"},
{"nscr",                     "U1D4C3", "[MATHEMATICAL SCRIPT SMALL N]"},
{"nshortmid",                "U02224", "[DOES NOT DIVIDE]"},
{"nshortparallel",           "U02226", "[NOT PARALLEL TO]"},
{"nsim",                     "U02241", "[NOT TILDE]"},
{"nsime",                    "U02244", "[NOT ASYMPTOTICALLY EQUAL TO]"},
{"nsimeq",                   "U02244", "[NOT ASYMPTOTICALLY EQUAL TO]"},
{"nsmid",                    "U02224", "[DOES NOT DIVIDE]"},
{"nspar",                    "U02226", "[NOT PARALLEL TO]"},
{"nsqsube",                  "U022E2", "[NOT SQUARE IMAGE OF OR EQUAL TO]"},
{"nsqsupe",                  "U022E3", "[NOT SQUARE ORIGINAL OF OR EQUAL TO]"},
{"nsub",                     "U02284", "[NOT A SUBSET OF]"},
{"nsubE",                    "U02AC5-00338", "[SUBSET OF ABOVE EQUALS SIGN with slash]"},
{"nsube",                    "U02288", "[NEITHER A SUBSET OF NOR EQUAL TO]"},
{"nsubset",                  "U02282-020D2", "[SUBSET OF with vertical line]"},
{"nsubseteq",                "U02288", "[NEITHER A SUBSET OF NOR EQUAL TO]"},
{"nsubseteqq",               "U02AC5-00338", "[SUBSET OF ABOVE EQUALS SIGN with slash]"},
{"nsucc",                    "U02281", "[DOES NOT SUCCEED]"},
{"nsucceq",                  "U02AB0-00338", "[SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN with slash]"},
{"nsup",                     "U02285", "[NOT A SUPERSET OF]"},
{"nsupE",                    "U02AC6-00338", "[SUPERSET OF ABOVE EQUALS SIGN with slash]"},
{"nsupe",                    "U02289", "[NEITHER A SUPERSET OF NOR EQUAL TO]"},
{"nsupset",                  "U02283-020D2", "[SUPERSET OF with vertical line]"},
{"nsupseteq",                "U02289", "[NEITHER A SUPERSET OF NOR EQUAL TO]"},
{"nsupseteqq",               "U02AC6-00338", "[SUPERSET OF ABOVE EQUALS SIGN with slash]"},
{"ntgl",                     "U02279", "[NEITHER GREATER-THAN NOR LESS-THAN]"},
{"ntilde",                   "U000F1", "[LATIN SMALL LETTER N WITH TILDE]"},
{"ntlg",                     "U02278", "[NEITHER LESS-THAN NOR GREATER-THAN]"},
{"ntriangleleft",            "U022EA", "[NOT NORMAL SUBGROUP OF]"},
{"ntrianglelefteq",          "U022EC", "[NOT NORMAL SUBGROUP OF OR EQUAL TO]"},
{"ntriangleright",           "U022EB", "[DOES NOT CONTAIN AS NORMAL SUBGROUP]"},
{"ntrianglerighteq",         "U022ED", "[DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL]"},
{"nu",                       "U003BD", "[GREEK SMALL LETTER NU]"},
{"num",                      "U00023", "[NUMBER SIGN]"},
{"numero",                   "U02116", "[NUMERO SIGN]"},
{"numsp",                    "U02007", "[FIGURE SPACE]"},
{"nvDash",                   "U022AD", "[NOT TRUE]"},
{"nvHarr",                   "U02904", "[LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE]"},
{"nvap",                     "U0224D-020D2", "[EQUIVALENT TO with vertical line]"},
{"nvdash",                   "U022AC", "[DOES NOT PROVE]"},
{"nvge",                     "U02265-020D2", "[GREATER-THAN OR EQUAL TO with vertical line]"},
{"nvgt",                     "U0003E-020D2", "[GREATER-THAN SIGN with vertical line]"},
{"nvinfin",                  "U029DE", "[INFINITY NEGATED WITH VERTICAL BAR]"},
{"nvlArr",                   "U02902", "[LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE]"},
{"nvle",                     "U02264-020D2", "[LESS-THAN OR EQUAL TO with vertical line]"},
{"nvlt",                     "U0003C-020D2", "[LESS-THAN SIGN with vertical line]"},
{"nvltrie",                  "U022B4-020D2", "[NORMAL SUBGROUP OF OR EQUAL TO with vertical line]"},
{"nvrArr",                   "U02903", "[RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE]"},
{"nvrtrie",                  "U022B5-020D2", "[CONTAINS AS NORMAL SUBGROUP OR EQUAL TO with vertical line]"},
{"nvsim",                    "U0223C-020D2", "[TILDE OPERATOR with vertical line]"},
{"nwArr",                    "U021D6", "[NORTH WEST DOUBLE ARROW]"},
{"nwarhk",                   "U02923", "[NORTH WEST ARROW WITH HOOK]"},
{"nwarr",                    "U02196", "[NORTH WEST ARROW]"},
{"nwarrow",                  "U02196", "[NORTH WEST ARROW]"},
{"nwnear",                   "U02927", "[NORTH WEST ARROW AND NORTH EAST ARROW]"},
{"oS",                       "U024C8", "[CIRCLED LATIN CAPITAL LETTER S]"},
{"oacute",                   "U000F3", "[LATIN SMALL LETTER O WITH ACUTE]"},
{"oast",                     "U0229B", "[CIRCLED ASTERISK OPERATOR]"},
{"ocir",                     "U0229A", "[CIRCLED RING OPERATOR]"},
{"ocirc",                    "U000F4", "[LATIN SMALL LETTER O WITH CIRCUMFLEX]"},
{"ocy",                      "U0043E", "[CYRILLIC SMALL LETTER O]"},
{"odash",                    "U0229D", "[CIRCLED DASH]"},
{"odblac",                   "U00151", "[LATIN SMALL LETTER O WITH DOUBLE ACUTE]"},
{"odiv",                     "U02A38", "[CIRCLED DIVISION SIGN]"},
{"odot",                     "U02299", "[CIRCLED DOT OPERATOR]"},
{"odsold",                   "U029BC", "[CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN]"},
{"oelig",                    "U00153", "[LATIN SMALL LIGATURE OE]"},
{"ofcir",                    "U029BF", "[CIRCLED BULLET]"},
{"ofr",                      "U1D52C", "[MATHEMATICAL FRAKTUR SMALL O]"},
{"ogon",                     "U002DB", "[OGONEK]"},
{"ograve",                   "U000F2", "[LATIN SMALL LETTER O WITH GRAVE]"},
{"ogt",                      "U029C1", "[CIRCLED GREATER-THAN]"},
{"ohbar",                    "U029B5", "[CIRCLE WITH HORIZONTAL BAR]"},
{"ohm",                      "U02126", "[OHM SIGN]"},
{"oint",                     "U0222E", "[CONTOUR INTEGRAL]"},
{"olarr",                    "U021BA", "[ANTICLOCKWISE OPEN CIRCLE ARROW]"},
{"olcir",                    "U029BE", "[CIRCLED WHITE BULLET]"},
{"olcross",                  "U029BB", "[CIRCLE WITH SUPERIMPOSED X]"},
{"olt",                      "U029C0", "[CIRCLED LESS-THAN]"},
{"omacr",                    "U0014D", "[LATIN SMALL LETTER O WITH MACRON]"},
{"omega",                    "U003C9", "[GREEK SMALL LETTER OMEGA]"},
{"omid",                     "U029B6", "[CIRCLED VERTICAL BAR]"},
{"ominus",                   "U02296", "[CIRCLED MINUS]"},
{"oopf",                     "U1D560", "[MATHEMATICAL DOUBLE-STRUCK SMALL O]"},
{"opar",                     "U029B7", "[CIRCLED PARALLEL]"},
{"operp",                    "U029B9", "[CIRCLED PERPENDICULAR]"},
{"oplus",                    "U02295", "[CIRCLED PLUS]"},
{"or",                       "U02228", "[LOGICAL OR]"},
{"orarr",                    "U021BB", "[CLOCKWISE OPEN CIRCLE ARROW]"},
{"ord",                      "U02A5D", "[LOGICAL OR WITH HORIZONTAL DASH]"},
{"order",                    "U02134", "[SCRIPT SMALL O]"},
{"orderof",                  "U02134", "[SCRIPT SMALL O]"},
{"ordf",                     "U000AA", "[FEMININE ORDINAL INDICATOR]"},
{"ordm",                     "U000BA", "[MASCULINE ORDINAL INDICATOR]"},
{"origof",                   "U022B6", "[ORIGINAL OF]"},
{"oror",                     "U02A56", "[TWO INTERSECTING LOGICAL OR]"},
{"orslope",                  "U02A57", "[SLOPING LARGE OR]"},
{"orv",                      "U02A5B", "[LOGICAL OR WITH MIDDLE STEM]"},
{"oscr",                     "U02134", "[SCRIPT SMALL O]"},
{"oslash",                   "U000F8", "[LATIN SMALL LETTER O WITH STROKE]"},
{"osol",                     "U02298", "[CIRCLED DIVISION SLASH]"},
{"otilde",                   "U000F5", "[LATIN SMALL LETTER O WITH TILDE]"},
{"otimes",                   "U02297", "[CIRCLED TIMES]"},
{"otimesas",                 "U02A36", "[CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT]"},
{"ouml",                     "U000F6", "[LATIN SMALL LETTER O WITH DIAERESIS]"},
{"ovbar",                    "U0233D", "[APL FUNCTIONAL SYMBOL CIRCLE STILE]"},
{"par",                      "U02225", "[PARALLEL TO]"},
{"para",                     "U000B6", "[PILCROW SIGN]"},
{"parallel",                 "U02225", "[PARALLEL TO]"},
{"parsim",                   "U02AF3", "[PARALLEL WITH TILDE OPERATOR]"},
{"parsl",                    "U02AFD", "[DOUBLE SOLIDUS OPERATOR]"},
{"part",                     "U02202", "[PARTIAL DIFFERENTIAL]"},
{"pcy",                      "U0043F", "[CYRILLIC SMALL LETTER PE]"},
{"percnt",                   "U00025", "[PERCENT SIGN]"},
{"period",                   "U0002E", "[FULL STOP]"},
{"permil",                   "U02030", "[PER MILLE SIGN]"},
{"perp",                     "U022A5", "[UP TACK]"},
{"pertenk",                  "U02031", "[PER TEN THOUSAND SIGN]"},
{"pfr",                      "U1D52D", "[MATHEMATICAL FRAKTUR SMALL P]"},
{"phi",                      "U003D5", "[GREEK PHI SYMBOL]"},
{"phiv",                     "U003C6", "[GREEK SMALL LETTER PHI]"},
{"phmmat",                   "U02133", "[SCRIPT CAPITAL M]"},
{"phone",                    "U0260E", "[BLACK TELEPHONE]"},
{"pi",                       "U003C0", "[GREEK SMALL LETTER PI]"},
{"pitchfork",                "U022D4", "[PITCHFORK]"},
{"piv",                      "U003D6", "[GREEK PI SYMBOL]"},
{"planck",                   "U0210F", "[PLANCK CONSTANT OVER TWO PI]"},
{"planckh",                  "U0210E", "[PLANCK CONSTANT]"},
{"plankv",                   "U0210F", "[PLANCK CONSTANT OVER TWO PI]"},
{"plus",                     "U0002B", "[PLUS SIGN]"},
{"plusacir",                 "U02A23", "[PLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE]"},
{"plusb",                    "U0229E", "[SQUARED PLUS]"},
{"pluscir",                  "U02A22", "[PLUS SIGN WITH SMALL CIRCLE ABOVE]"},
{"plusdo",                   "U02214", "[DOT PLUS]"},
{"plusdu",                   "U02A25", "[PLUS SIGN WITH DOT BELOW]"},
{"pluse",                    "U02A72", "[PLUS SIGN ABOVE EQUALS SIGN]"},
{"plusmn",                   "U000B1", "[PLUS-MINUS SIGN]"},
{"plussim",                  "U02A26", "[PLUS SIGN WITH TILDE BELOW]"},
{"plustwo",                  "U02A27", "[PLUS SIGN WITH SUBSCRIPT TWO]"},
{"pm",                       "U000B1", "[PLUS-MINUS SIGN]"},
{"pointint",                 "U02A15", "[INTEGRAL AROUND A POINT OPERATOR]"},
{"popf",                     "U1D561", "[MATHEMATICAL DOUBLE-STRUCK SMALL P]"},
{"pound",                    "U000A3", "[POUND SIGN]"},
{"pr",                       "U0227A", "[PRECEDES]"},
{"prE",                      "U02AB3", "[PRECEDES ABOVE EQUALS SIGN]"},
{"prap",                     "U02AB7", "[PRECEDES ABOVE ALMOST EQUAL TO]"},
{"prcue",                    "U0227C", "[PRECEDES OR EQUAL TO]"},
{"pre",                      "U02AAF", "[PRECEDES ABOVE SINGLE-LINE EQUALS SIGN]"},
{"prec",                     "U0227A", "[PRECEDES]"},
{"precapprox",               "U02AB7", "[PRECEDES ABOVE ALMOST EQUAL TO]"},
{"preccurlyeq",              "U0227C", "[PRECEDES OR EQUAL TO]"},
{"preceq",                   "U02AAF", "[PRECEDES ABOVE SINGLE-LINE EQUALS SIGN]"},
{"precnapprox",              "U02AB9", "[PRECEDES ABOVE NOT ALMOST EQUAL TO]"},
{"precneqq",                 "U02AB5", "[PRECEDES ABOVE NOT EQUAL TO]"},
{"precnsim",                 "U022E8", "[PRECEDES BUT NOT EQUIVALENT TO]"},
{"precsim",                  "U0227E", "[PRECEDES OR EQUIVALENT TO]"},
{"prime",                    "U02032", "[PRIME]"},
{"primes",                   "U02119", "[DOUBLE-STRUCK CAPITAL P]"},
{"prnE",                     "U02AB5", "[PRECEDES ABOVE NOT EQUAL TO]"},
{"prnap",                    "U02AB9", "[PRECEDES ABOVE NOT ALMOST EQUAL TO]"},
{"prnsim",                   "U022E8", "[PRECEDES BUT NOT EQUIVALENT TO]"},
{"prod",                     "U0220F", "[N-ARY PRODUCT]"},
{"profalar",                 "U0232E", "[ALL AROUND-PROFILE]"},
{"profline",                 "U02312", "[ARC]"},
{"profsurf",                 "U02313", "[SEGMENT]"},
{"prop",                     "U0221D", "[PROPORTIONAL TO]"},
{"propto",                   "U0221D", "[PROPORTIONAL TO]"},
{"prsim",                    "U0227E", "[PRECEDES OR EQUIVALENT TO]"},
{"prurel",                   "U022B0", "[PRECEDES UNDER RELATION]"},
{"pscr",                     "U1D4C5", "[MATHEMATICAL SCRIPT SMALL P]"},
{"psi",                      "U003C8", "[GREEK SMALL LETTER PSI]"},
{"puncsp",                   "U02008", "[PUNCTUATION SPACE]"},
{"qfr",                      "U1D52E", "[MATHEMATICAL FRAKTUR SMALL Q]"},
{"qint",                     "U02A0C", "[QUADRUPLE INTEGRAL OPERATOR]"},
{"qopf",                     "U1D562", "[MATHEMATICAL DOUBLE-STRUCK SMALL Q]"},
{"qprime",                   "U02057", "[QUADRUPLE PRIME]"},
{"qscr",                     "U1D4C6", "[MATHEMATICAL SCRIPT SMALL Q]"},
{"quaternions",              "U0210D", "[DOUBLE-STRUCK CAPITAL H]"},
{"quatint",                  "U02A16", "[QUATERNION INTEGRAL OPERATOR]"},
{"quest",                    "U0003F", "[QUESTION MARK]"},
{"questeq",                  "U0225F", "[QUESTIONED EQUAL TO]"},
{"quot",                     "U00022", "[QUOTATION MARK]"},
{"rAarr",                    "U021DB", "[RIGHTWARDS TRIPLE ARROW]"},
{"rArr",                     "U021D2", "[RIGHTWARDS DOUBLE ARROW]"},
{"rAtail",                   "U0291C", "[RIGHTWARDS DOUBLE ARROW-TAIL]"},
{"rBarr",                    "U0290F", "[RIGHTWARDS TRIPLE DASH ARROW]"},
{"rHar",                     "U02964", "[RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN]"},
{"race",                     "U029DA", "[LEFT DOUBLE WIGGLY FENCE]"},
{"racute",                   "U00155", "[LATIN SMALL LETTER R WITH ACUTE]"},
{"radic",                    "U0221A", "[SQUARE ROOT]"},
{"raemptyv",                 "U029B3", "[EMPTY SET WITH RIGHT ARROW ABOVE]"},
{"rang",                     "U0232A", "[RIGHT-POINTING ANGLE BRACKET]"},
{"rangd",                    "U02992", "[RIGHT ANGLE BRACKET WITH DOT]"},
{"range",                    "U029A5", "[REVERSED ANGLE WITH UNDERBAR]"},
{"rangle",                   "U0232A", "[RIGHT-POINTING ANGLE BRACKET]"},
{"raquo",                    "U000BB", "[RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK]"},
{"rarr",                     "U02192", "[RIGHTWARDS ARROW]"},
{"rarrap",                   "U02975", "[RIGHTWARDS ARROW ABOVE ALMOST EQUAL TO]"},
{"rarrb",                    "U021E5", "[RIGHTWARDS ARROW TO BAR]"},
{"rarrbfs",                  "U02920", "[RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND]"},
{"rarrc",                    "U02933", "[WAVE ARROW POINTING DIRECTLY RIGHT]"},
{"rarrfs",                   "U0291E", "[RIGHTWARDS ARROW TO BLACK DIAMOND]"},
{"rarrhk",                   "U021AA", "[RIGHTWARDS ARROW WITH HOOK]"},
{"rarrlp",                   "U021AC", "[RIGHTWARDS ARROW WITH LOOP]"},
{"rarrpl",                   "U02945", "[RIGHTWARDS ARROW WITH PLUS BELOW]"},
{"rarrsim",                  "U02974", "[RIGHTWARDS ARROW ABOVE TILDE OPERATOR]"},
{"rarrtl",                   "U021A3", "[RIGHTWARDS ARROW WITH TAIL]"},
{"rarrw",                    "U0219D", "[RIGHTWARDS WAVE ARROW]"},
{"ratail",                   "U0291A", "[RIGHTWARDS ARROW-TAIL]"},
{"ratio",                    "U02236", "[RATIO]"},
{"rationals",                "U0211A", "[DOUBLE-STRUCK CAPITAL Q]"},
{"rbarr",                    "U0290D", "[RIGHTWARDS DOUBLE DASH ARROW]"},
{"rbbrk",                    "U03015", "[RIGHT TORTOISE SHELL BRACKET]"},
{"rbrace",                   "U0007D", "[RIGHT CURLY BRACKET]"},
{"rbrack",                   "U0005D", "[RIGHT SQUARE BRACKET]"},
{"rbrke",                    "U0298C", "[RIGHT SQUARE BRACKET WITH UNDERBAR]"},
{"rbrksld",                  "U0298E", "[RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER]"},
{"rbrkslu",                  "U02990", "[RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER]"},
{"rcaron",                   "U00159", "[LATIN SMALL LETTER R WITH CARON]"},
{"rcedil",                   "U00157", "[LATIN SMALL LETTER R WITH CEDILLA]"},
{"rceil",                    "U02309", "[RIGHT CEILING]"},
{"rcub",                     "U0007D", "[RIGHT CURLY BRACKET]"},
{"rcy",                      "U00440", "[CYRILLIC SMALL LETTER ER]"},
{"rdca",                     "U02937", "[ARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDS]"},
{"rdldhar",                  "U02969", "[RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN]"},
{"rdquo",                    "U0201D", "[RIGHT DOUBLE QUOTATION MARK]"},
{"rdquor",                   "U0201D", "[RIGHT DOUBLE QUOTATION MARK]"},
{"rdsh",                     "U021B3", "[DOWNWARDS ARROW WITH TIP RIGHTWARDS]"},
{"real",                     "U0211C", "[BLACK-LETTER CAPITAL R]"},
{"realine",                  "U0211B", "[SCRIPT CAPITAL R]"},
{"realpart",                 "U0211C", "[BLACK-LETTER CAPITAL R]"},
{"reals",                    "U0211D", "[DOUBLE-STRUCK CAPITAL R]"},
{"rect",                     "U025AD", "[WHITE RECTANGLE]"},
{"reg",                      "U000AE", "[REGISTERED SIGN]"},
{"rfisht",                   "U0297D", "[RIGHT FISH TAIL]"},
{"rfloor",                   "U0230B", "[RIGHT FLOOR]"},
{"rfr",                      "U1D52F", "[MATHEMATICAL FRAKTUR SMALL R]"},
{"rhard",                    "U021C1", "[RIGHTWARDS HARPOON WITH BARB DOWNWARDS]"},
{"rharu",                    "U021C0", "[RIGHTWARDS HARPOON WITH BARB UPWARDS]"},
{"rharul",                   "U0296C", "[RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH]"},
{"rho",                      "U003C1", "[GREEK SMALL LETTER RHO]"},
{"rhov",                     "U003F1", "[GREEK RHO SYMBOL]"},
{"rightarrow",               "U02192", "[RIGHTWARDS ARROW]"},
{"rightarrowtail",           "U021A3", "[RIGHTWARDS ARROW WITH TAIL]"},
{"rightharpoondown",         "U021C1", "[RIGHTWARDS HARPOON WITH BARB DOWNWARDS]"},
{"rightharpoonup",           "U021C0", "[RIGHTWARDS HARPOON WITH BARB UPWARDS]"},
{"rightleftarrows",          "U021C4", "[RIGHTWARDS ARROW OVER LEFTWARDS ARROW]"},
{"rightleftharpoons",        "U021CC", "[RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON]"},
{"rightrightarrows",         "U021C9", "[RIGHTWARDS PAIRED ARROWS]"},
{"rightsquigarrow",          "U0219D", "[RIGHTWARDS WAVE ARROW]"},
{"rightthreetimes",          "U022CC", "[RIGHT SEMIDIRECT PRODUCT]"},
{"ring",                     "U002DA", "[RING ABOVE]"},
{"risingdotseq",             "U02253", "[IMAGE OF OR APPROXIMATELY EQUAL TO]"},
{"rlarr",                    "U021C4", "[RIGHTWARDS ARROW OVER LEFTWARDS ARROW]"},
{"rlhar",                    "U021CC", "[RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON]"},
{"rmoust",                   "U023B1", "[UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION]"},
{"rmoustache",               "U023B1", "[UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION]"},
{"rnmid",                    "U02AEE", "[DOES NOT DIVIDE WITH REVERSED NEGATION SLASH]"},
{"roang",                    "U03019", "[RIGHT WHITE TORTOISE SHELL BRACKET]"},
{"roarr",                    "U021FE", "[RIGHTWARDS OPEN-HEADED ARROW]"},
{"robrk",                    "U0301B", "[RIGHT WHITE SQUARE BRACKET]"},
{"ropar",                    "U02986", "[RIGHT WHITE PARENTHESIS]"},
{"ropf",                     "U1D563", "[MATHEMATICAL DOUBLE-STRUCK SMALL R]"},
{"roplus",                   "U02A2E", "[PLUS SIGN IN RIGHT HALF CIRCLE]"},
{"rotimes",                  "U02A35", "[MULTIPLICATION SIGN IN RIGHT HALF CIRCLE]"},
{"rpar",                     "U00029", "[RIGHT PARENTHESIS]"},
{"rpargt",                   "U02994", "[RIGHT ARC GREATER-THAN BRACKET]"},
{"rppolint",                 "U02A12", "[LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE]"},
{"rrarr",                    "U021C9", "[RIGHTWARDS PAIRED ARROWS]"},
{"rscr",                     "U1D4C7", "[MATHEMATICAL SCRIPT SMALL R]"},
{"rsh",                      "U021B1", "[UPWARDS ARROW WITH TIP RIGHTWARDS]"},
{"rsqb",                     "U0005D", "[RIGHT SQUARE BRACKET]"},
{"rsquo",                    "U02019", "[RIGHT SINGLE QUOTATION MARK]"},
{"rsquor",                   "U02019", "[RIGHT SINGLE QUOTATION MARK]"},
{"rthree",                   "U022CC", "[RIGHT SEMIDIRECT PRODUCT]"},
{"rtimes",                   "U022CA", "[RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT]"},
{"rtri",                     "U025B9", "[WHITE RIGHT-POINTING SMALL TRIANGLE]"},
{"rtrie",                    "U022B5", "[CONTAINS AS NORMAL SUBGROUP OR EQUAL TO]"},
{"rtrif",                    "U025B8", "[BLACK RIGHT-POINTING SMALL TRIANGLE]"},
{"rtriltri",                 "U029CE", "[RIGHT TRIANGLE ABOVE LEFT TRIANGLE]"},
{"ruluhar",                  "U02968", "[RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP]"},
{"rx",                       "U0211E", "[PRESCRIPTION TAKE]"},
{"sacute",                   "U0015B", "[LATIN SMALL LETTER S WITH ACUTE]"},
{"sc",                       "U0227B", "[SUCCEEDS]"},
{"scE",                      "U02AB4", "[SUCCEEDS ABOVE EQUALS SIGN]"},
{"scap",                     "U02AB8", "[SUCCEEDS ABOVE ALMOST EQUAL TO]"},
{"scaron",                   "U00161", "[LATIN SMALL LETTER S WITH CARON]"},
{"sccue",                    "U0227D", "[SUCCEEDS OR EQUAL TO]"},
{"sce",                      "U02AB0", "[SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN]"},
{"scedil",                   "U0015F", "[LATIN SMALL LETTER S WITH CEDILLA]"},
{"scirc",                    "U0015D", "[LATIN SMALL LETTER S WITH CIRCUMFLEX]"},
{"scnE",                     "U02AB6", "[SUCCEEDS ABOVE NOT EQUAL TO]"},
{"scnap",                    "U02ABA", "[SUCCEEDS ABOVE NOT ALMOST EQUAL TO]"},
{"scnsim",                   "U022E9", "[SUCCEEDS BUT NOT EQUIVALENT TO]"},
{"scpolint",                 "U02A13", "[LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE]"},
{"scsim",                    "U0227F", "[SUCCEEDS OR EQUIVALENT TO]"},
{"scy",                      "U00441", "[CYRILLIC SMALL LETTER ES]"},
{"sdot",                     "U022C5", "[DOT OPERATOR]"},
{"sdotb",                    "U022A1", "[SQUARED DOT OPERATOR]"},
{"sdote",                    "U02A66", "[EQUALS SIGN WITH DOT BELOW]"},
{"seArr",                    "U021D8", "[SOUTH EAST DOUBLE ARROW]"},
{"searhk",                   "U02925", "[SOUTH EAST ARROW WITH HOOK]"},
{"searr",                    "U02198", "[SOUTH EAST ARROW]"},
{"searrow",                  "U02198", "[SOUTH EAST ARROW]"},
{"sect",                     "U000A7", "[SECTION SIGN]"},
{"semi",                     "U0003B", "[SEMICOLON]"},
{"seswar",                   "U02929", "[SOUTH EAST ARROW AND SOUTH WEST ARROW]"},
{"setminus",                 "U02216", "[SET MINUS]"},
{"setmn",                    "U02216", "[SET MINUS]"},
{"sext",                     "U02736", "[SIX POINTED BLACK STAR]"},
{"sfr",                      "U1D530", "[MATHEMATICAL FRAKTUR SMALL S]"},
{"sfrown",                   "U02322", "[FROWN]"},
{"sharp",                    "U0266F", "[MUSIC SHARP SIGN]"},
{"shchcy",                   "U00449", "[CYRILLIC SMALL LETTER SHCHA]"},
{"shcy",                     "U00448", "[CYRILLIC SMALL LETTER SHA]"},
{"shortmid",                 "U02223", "[DIVIDES]"},
{"shortparallel",            "U02225", "[PARALLEL TO]"},
{"shy",                      "U000AD", "[SOFT HYPHEN]"},
{"sigma",                    "U003C3", "[GREEK SMALL LETTER SIGMA]"},
{"sigmav",                   "U003C2", "[GREEK SMALL LETTER FINAL SIGMA]"},
{"sim",                      "U0223C", "[TILDE OPERATOR]"},
{"simdot",                   "U02A6A", "[TILDE OPERATOR WITH DOT ABOVE]"},
{"sime",                     "U02243", "[ASYMPTOTICALLY EQUAL TO]"},
{"simeq",                    "U02243", "[ASYMPTOTICALLY EQUAL TO]"},
{"simg",                     "U02A9E", "[SIMILAR OR GREATER-THAN]"},
{"simgE",                    "U02AA0", "[SIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGN]"},
{"siml",                     "U02A9D", "[SIMILAR OR LESS-THAN]"},
{"simlE",                    "U02A9F", "[SIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGN]"},
{"simne",                    "U02246", "[APPROXIMATELY BUT NOT ACTUALLY EQUAL TO]"},
{"simplus",                  "U02A24", "[PLUS SIGN WITH TILDE ABOVE]"},
{"simrarr",                  "U02972", "[TILDE OPERATOR ABOVE RIGHTWARDS ARROW]"},
{"slarr",                    "U02190", "[LEFTWARDS ARROW]"},
{"smallsetminus",            "U02216", "[SET MINUS]"},
{"smashp",                   "U02A33", "[SMASH PRODUCT]"},
{"smeparsl",                 "U029E4", "[EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE]"},
{"smid",                     "U02223", "[DIVIDES]"},
{"smile",                    "U02323", "[SMILE]"},
{"smt",                      "U02AAA", "[SMALLER THAN]"},
{"smte",                     "U02AAC", "[SMALLER THAN OR EQUAL TO]"},
{"smtes",                    "U02AAC-0FE00", "[SMALLER THAN OR slanted EQUAL]"},
{"softcy",                   "U0044C", "[CYRILLIC SMALL LETTER SOFT SIGN]"},
{"sol",                      "U0002F", "[SOLIDUS]"},
{"solb",                     "U029C4", "[SQUARED RISING DIAGONAL SLASH]"},
{"solbar",                   "U0233F", "[APL FUNCTIONAL SYMBOL SLASH BAR]"},
{"sopf",                     "U1D564", "[MATHEMATICAL DOUBLE-STRUCK SMALL S]"},
{"spades",                   "U02660", "[BLACK SPADE SUIT]"},
{"spadesuit",                "U02660", "[BLACK SPADE SUIT]"},
{"spar",                     "U02225", "[PARALLEL TO]"},
{"sqcap",                    "U02293", "[SQUARE CAP]"},
{"sqcaps",                   "U02293-0FE00", "[SQUARE CAP with serifs]"},
{"sqcup",                    "U02294", "[SQUARE CUP]"},
{"sqcups",                   "U02294-0FE00", "[SQUARE CUP with serifs]"},
{"sqsub",                    "U0228F", "[SQUARE IMAGE OF]"},
{"sqsube",                   "U02291", "[SQUARE IMAGE OF OR EQUAL TO]"},
{"sqsubset",                 "U0228F", "[SQUARE IMAGE OF]"},
{"sqsubseteq",               "U02291", "[SQUARE IMAGE OF OR EQUAL TO]"},
{"sqsup",                    "U02290", "[SQUARE ORIGINAL OF]"},
{"sqsupe",                   "U02292", "[SQUARE ORIGINAL OF OR EQUAL TO]"},
{"sqsupset",                 "U02290", "[SQUARE ORIGINAL OF]"},
{"sqsupseteq",               "U02292", "[SQUARE ORIGINAL OF OR EQUAL TO]"},
{"squ",                      "U025A1", "[WHITE SQUARE]"},
{"square",                   "U025A1", "[WHITE SQUARE]"},
{"squarf",                   "U025AA", "[BLACK SMALL SQUARE]"},
{"squf",                     "U025AA", "[BLACK SMALL SQUARE]"},
{"srarr",                    "U02192", "[RIGHTWARDS ARROW]"},
{"sscr",                     "U1D4C8", "[MATHEMATICAL SCRIPT SMALL S]"},
{"ssetmn",                   "U02216", "[SET MINUS]"},
{"ssmile",                   "U02323", "[SMILE]"},
{"sstarf",                   "U022C6", "[STAR OPERATOR]"},
{"star",                     "U02606", "[WHITE STAR]"},
{"starf",                    "U02605", "[BLACK STAR]"},
{"straightepsilon",          "U003F5", "[GREEK LUNATE EPSILON SYMBOL]"},
{"straightphi",              "U003D5", "[GREEK PHI SYMBOL]"},
{"strns",                    "U000AF", "[MACRON]"},
{"sub",                      "U02282", "[SUBSET OF]"},
{"subE",                     "U02AC5", "[SUBSET OF ABOVE EQUALS SIGN]"},
{"subdot",                   "U02ABD", "[SUBSET WITH DOT]"},
{"sube",                     "U02286", "[SUBSET OF OR EQUAL TO]"},
{"subedot",                  "U02AC3", "[SUBSET OF OR EQUAL TO WITH DOT ABOVE]"},
{"submult",                  "U02AC1", "[SUBSET WITH MULTIPLICATION SIGN BELOW]"},
{"subnE",                    "U02ACB", "[SUBSET OF ABOVE NOT EQUAL TO]"},
{"subne",                    "U0228A", "[SUBSET OF WITH NOT EQUAL TO]"},
{"subplus",                  "U02ABF", "[SUBSET WITH PLUS SIGN BELOW]"},
{"subrarr",                  "U02979", "[SUBSET ABOVE RIGHTWARDS ARROW]"},
{"subset",                   "U02282", "[SUBSET OF]"},
{"subseteq",                 "U02286", "[SUBSET OF OR EQUAL TO]"},
{"subseteqq",                "U02AC5", "[SUBSET OF ABOVE EQUALS SIGN]"},
{"subsetneq",                "U0228A", "[SUBSET OF WITH NOT EQUAL TO]"},
{"subsetneqq",               "U02ACB", "[SUBSET OF ABOVE NOT EQUAL TO]"},
{"subsim",                   "U02AC7", "[SUBSET OF ABOVE TILDE OPERATOR]"},
{"subsub",                   "U02AD5", "[SUBSET ABOVE SUBSET]"},
{"subsup",                   "U02AD3", "[SUBSET ABOVE SUPERSET]"},
{"succ",                     "U0227B", "[SUCCEEDS]"},
{"succapprox",               "U02AB8", "[SUCCEEDS ABOVE ALMOST EQUAL TO]"},
{"succcurlyeq",              "U0227D", "[SUCCEEDS OR EQUAL TO]"},
{"succeq",                   "U02AB0", "[SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN]"},
{"succnapprox",              "U02ABA", "[SUCCEEDS ABOVE NOT ALMOST EQUAL TO]"},
{"succneqq",                 "U02AB6", "[SUCCEEDS ABOVE NOT EQUAL TO]"},
{"succnsim",                 "U022E9", "[SUCCEEDS BUT NOT EQUIVALENT TO]"},
{"succsim",                  "U0227F", "[SUCCEEDS OR EQUIVALENT TO]"},
{"sum",                      "U02211", "[N-ARY SUMMATION]"},
{"sung",                     "U0266A", "[EIGHTH NOTE]"},
{"sup",                      "U02283", "[SUPERSET OF]"},
{"sup1",                     "U000B9", "[SUPERSCRIPT ONE]"},
{"sup2",                     "U000B2", "[SUPERSCRIPT TWO]"},
{"sup3",                     "U000B3", "[SUPERSCRIPT THREE]"},
{"supE",                     "U02AC6", "[SUPERSET OF ABOVE EQUALS SIGN]"},
{"supdot",                   "U02ABE", "[SUPERSET WITH DOT]"},
{"supdsub",                  "U02AD8", "[SUPERSET BESIDE AND JOINED BY DASH WITH SUBSET]"},
{"supe",                     "U02287", "[SUPERSET OF OR EQUAL TO]"},
{"supedot",                  "U02AC4", "[SUPERSET OF OR EQUAL TO WITH DOT ABOVE]"},
{"suphsol",                  "U02283-0002F", "[SUPERSET OF, SOLIDUS]"},
{"suphsub",                  "U02AD7", "[SUPERSET BESIDE SUBSET]"},
{"suplarr",                  "U0297B", "[SUPERSET ABOVE LEFTWARDS ARROW]"},
{"supmult",                  "U02AC2", "[SUPERSET WITH MULTIPLICATION SIGN BELOW]"},
{"supnE",                    "U02ACC", "[SUPERSET OF ABOVE NOT EQUAL TO]"},
{"supne",                    "U0228B", "[SUPERSET OF WITH NOT EQUAL TO]"},
{"supplus",                  "U02AC0", "[SUPERSET WITH PLUS SIGN BELOW]"},
{"supset",                   "U02283", "[SUPERSET OF]"},
{"supseteq",                 "U02287", "[SUPERSET OF OR EQUAL TO]"},
{"supseteqq",                "U02AC6", "[SUPERSET OF ABOVE EQUALS SIGN]"},
{"supsetneq",                "U0228B", "[SUPERSET OF WITH NOT EQUAL TO]"},
{"supsetneqq",               "U02ACC", "[SUPERSET OF ABOVE NOT EQUAL TO]"},
{"supsim",                   "U02AC8", "[SUPERSET OF ABOVE TILDE OPERATOR]"},
{"supsub",                   "U02AD4", "[SUPERSET ABOVE SUBSET]"},
{"supsup",                   "U02AD6", "[SUPERSET ABOVE SUPERSET]"},
{"swArr",                    "U021D9", "[SOUTH WEST DOUBLE ARROW]"},
{"swarhk",                   "U02926", "[SOUTH WEST ARROW WITH HOOK]"},
{"swarr",                    "U02199", "[SOUTH WEST ARROW]"},
{"swarrow",                  "U02199", "[SOUTH WEST ARROW]"},
{"swnwar",                   "U0292A", "[SOUTH WEST ARROW AND NORTH WEST ARROW]"},
{"szlig",                    "U000DF", "[LATIN SMALL LETTER SHARP S]"},
{"target",                   "U02316", "[POSITION INDICATOR]"},
{"tau",                      "U003C4", "[GREEK SMALL LETTER TAU]"},
{"tbrk",                     "U023B4", "[TOP SQUARE BRACKET]"},
{"tcaron",                   "U00165", "[LATIN SMALL LETTER T WITH CARON]"},
{"tcedil",                   "U00163", "[LATIN SMALL LETTER T WITH CEDILLA]"},
{"tcy",                      "U00442", "[CYRILLIC SMALL LETTER TE]"},
{"tdot",                     "U020DB", "[COMBINING THREE DOTS ABOVE]"},
{"telrec",                   "U02315", "[TELEPHONE RECORDER]"},
{"tfr",                      "U1D531", "[MATHEMATICAL FRAKTUR SMALL T]"},
{"there4",                   "U02234", "[THEREFORE]"},
{"therefore",                "U02234", "[THEREFORE]"},
{"theta",                    "U003B8", "[GREEK SMALL LETTER THETA]"},
{"thetav",                   "U003D1", "[GREEK THETA SYMBOL]"},
{"thickapprox",              "U02248", "[ALMOST EQUAL TO]"},
{"thicksim",                 "U0223C", "[TILDE OPERATOR]"},
{"thinsp",                   "U02009", "[THIN SPACE]"},
{"thkap",                    "U02248", "[ALMOST EQUAL TO]"},
{"thksim",                   "U0223C", "[TILDE OPERATOR]"},
{"thorn",                    "U000FE", "[LATIN SMALL LETTER THORN]"},
{"tilde",                    "U002DC", "[SMALL TILDE]"},
{"times",                    "U000D7", "[MULTIPLICATION SIGN]"},
{"timesb",                   "U022A0", "[SQUARED TIMES]"},
{"timesbar",                 "U02A31", "[MULTIPLICATION SIGN WITH UNDERBAR]"},
{"timesd",                   "U02A30", "[MULTIPLICATION SIGN WITH DOT ABOVE]"},
{"tint",                     "U0222D", "[TRIPLE INTEGRAL]"},
{"toea",                     "U02928", "[NORTH EAST ARROW AND SOUTH EAST ARROW]"},
{"top",                      "U022A4", "[DOWN TACK]"},
{"topbot",                   "U02336", "[APL FUNCTIONAL SYMBOL I-BEAM]"},
{"topcir",                   "U02AF1", "[DOWN TACK WITH CIRCLE BELOW]"},
{"topf",                     "U1D565", "[MATHEMATICAL DOUBLE-STRUCK SMALL T]"},
{"topfork",                  "U02ADA", "[PITCHFORK WITH TEE TOP]"},
{"tosa",                     "U02929", "[SOUTH EAST ARROW AND SOUTH WEST ARROW]"},
{"tprime",                   "U02034", "[TRIPLE PRIME]"},
{"trade",                    "U02122", "[TRADE MARK SIGN]"},
{"triangle",                 "U025B5", "[WHITE UP-POINTING SMALL TRIANGLE]"},
{"triangledown",             "U025BF", "[WHITE DOWN-POINTING SMALL TRIANGLE]"},
{"triangleleft",             "U025C3", "[WHITE LEFT-POINTING SMALL TRIANGLE]"},
{"trianglelefteq",           "U022B4", "[NORMAL SUBGROUP OF OR EQUAL TO]"},
{"triangleq",                "U0225C", "[DELTA EQUAL TO]"},
{"triangleright",            "U025B9", "[WHITE RIGHT-POINTING SMALL TRIANGLE]"},
{"trianglerighteq",          "U022B5", "[CONTAINS AS NORMAL SUBGROUP OR EQUAL TO]"},
{"tridot",                   "U025EC", "[WHITE UP-POINTING TRIANGLE WITH DOT]"},
{"trie",                     "U0225C", "[DELTA EQUAL TO]"},
{"triminus",                 "U02A3A", "[MINUS SIGN IN TRIANGLE]"},
{"triplus",                  "U02A39", "[PLUS SIGN IN TRIANGLE]"},
{"trisb",                    "U029CD", "[TRIANGLE WITH SERIFS AT BOTTOM]"},
{"tritime",                  "U02A3B", "[MULTIPLICATION SIGN IN TRIANGLE]"},
{"trpezium",                 "U0FFFD", "[REPLACEMENT CHARACTER]"},
{"tscr",                     "U1D4C9", "[MATHEMATICAL SCRIPT SMALL T]"},
{"tscy",                     "U00446", "[CYRILLIC SMALL LETTER TSE]"},
{"tshcy",                    "U0045B", "[CYRILLIC SMALL LETTER TSHE]"},
{"tstrok",                   "U00167", "[LATIN SMALL LETTER T WITH STROKE]"},
{"twixt",                    "U0226C", "[BETWEEN]"},
{"twoheadleftarrow",         "U0219E", "[LEFTWARDS TWO HEADED ARROW]"},
{"twoheadrightarrow",        "U021A0", "[RIGHTWARDS TWO HEADED ARROW]"},
{"uArr",                     "U021D1", "[UPWARDS DOUBLE ARROW]"},
{"uHar",                     "U02963", "[UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT]"},
{"uacute",                   "U000FA", "[LATIN SMALL LETTER U WITH ACUTE]"},
{"uarr",                     "U02191", "[UPWARDS ARROW]"},
{"ubrcy",                    "U0045E", "[CYRILLIC SMALL LETTER SHORT U]"},
{"ubreve",                   "U0016D", "[LATIN SMALL LETTER U WITH BREVE]"},
{"ucirc",                    "U000FB", "[LATIN SMALL LETTER U WITH CIRCUMFLEX]"},
{"ucy",                      "U00443", "[CYRILLIC SMALL LETTER U]"},
{"udarr",                    "U021C5", "[UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW]"},
{"udblac",                   "U00171", "[LATIN SMALL LETTER U WITH DOUBLE ACUTE]"},
{"udhar",                    "U0296E", "[UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT]"},
{"ufisht",                   "U0297E", "[UP FISH TAIL]"},
{"ufr",                      "U1D532", "[MATHEMATICAL FRAKTUR SMALL U]"},
{"ugrave",                   "U000F9", "[LATIN SMALL LETTER U WITH GRAVE]"},
{"uharl",                    "U021BF", "[UPWARDS HARPOON WITH BARB LEFTWARDS]"},
{"uharr",                    "U021BE", "[UPWARDS HARPOON WITH BARB RIGHTWARDS]"},
{"uhblk",                    "U02580", "[UPPER HALF BLOCK]"},
{"ulcorn",                   "U0231C", "[TOP LEFT CORNER]"},
{"ulcorner",                 "U0231C", "[TOP LEFT CORNER]"},
{"ulcrop",                   "U0230F", "[TOP LEFT CROP]"},
{"ultri",                    "U025F8", "[UPPER LEFT TRIANGLE]"},
{"umacr",                    "U0016B", "[LATIN SMALL LETTER U WITH MACRON]"},
{"uml",                      "U000A8", "[DIAERESIS]"},
{"uogon",                    "U00173", "[LATIN SMALL LETTER U WITH OGONEK]"},
{"uopf",                     "U1D566", "[MATHEMATICAL DOUBLE-STRUCK SMALL U]"},
{"uparrow",                  "U02191", "[UPWARDS ARROW]"},
{"updownarrow",              "U02195", "[UP DOWN ARROW]"},
{"upharpoonleft",            "U021BF", "[UPWARDS HARPOON WITH BARB LEFTWARDS]"},
{"upharpoonright",           "U021BE", "[UPWARDS HARPOON WITH BARB RIGHTWARDS]"},
{"uplus",                    "U0228E", "[MULTISET UNION]"},
{"upsi",                     "U003C5", "[GREEK SMALL LETTER UPSILON]"},
{"upsilon",                  "U003C5", "[GREEK SMALL LETTER UPSILON]"},
{"upuparrows",               "U021C8", "[UPWARDS PAIRED ARROWS]"},
{"urcorn",                   "U0231D", "[TOP RIGHT CORNER]"},
{"urcorner",                 "U0231D", "[TOP RIGHT CORNER]"},
{"urcrop",                   "U0230E", "[TOP RIGHT CROP]"},
{"uring",                    "U0016F", "[LATIN SMALL LETTER U WITH RING ABOVE]"},
{"urtri",                    "U025F9", "[UPPER RIGHT TRIANGLE]"},
{"uscr",                     "U1D4CA", "[MATHEMATICAL SCRIPT SMALL U]"},
{"utdot",                    "U022F0", "[UP RIGHT DIAGONAL ELLIPSIS]"},
{"utilde",                   "U00169", "[LATIN SMALL LETTER U WITH TILDE]"},
{"utri",                     "U025B5", "[WHITE UP-POINTING SMALL TRIANGLE]"},
{"utrif",                    "U025B4", "[BLACK UP-POINTING SMALL TRIANGLE]"},
{"uuarr",                    "U021C8", "[UPWARDS PAIRED ARROWS]"},
{"uuml",                     "U000FC", "[LATIN SMALL LETTER U WITH DIAERESIS]"},
{"uwangle",                  "U029A7", "[OBLIQUE ANGLE OPENING DOWN]"},
{"vArr",                     "U021D5", "[UP DOWN DOUBLE ARROW]"},
{"vBar",                     "U02AE8", "[SHORT UP TACK WITH UNDERBAR]"},
{"vBarv",                    "U02AE9", "[SHORT UP TACK ABOVE SHORT DOWN TACK]"},
{"vDash",                    "U022A8", "[TRUE]"},
{"vangrt",                   "U0299C", "[RIGHT ANGLE VARIANT WITH SQUARE]"},
{"varepsilon",               "U003B5", "[GREEK SMALL LETTER EPSILON]"},
{"varkappa",                 "U003F0", "[GREEK KAPPA SYMBOL]"},
{"varnothing",               "U02205", "[EMPTY SET]"},
{"varphi",                   "U003C6", "[GREEK SMALL LETTER PHI]"},
{"varpi",                    "U003D6", "[GREEK PI SYMBOL]"},
{"varpropto",                "U0221D", "[PROPORTIONAL TO]"},
{"varr",                     "U02195", "[UP DOWN ARROW]"},
{"varrho",                   "U003F1", "[GREEK RHO SYMBOL]"},
{"varsigma",                 "U003C2", "[GREEK SMALL LETTER FINAL SIGMA]"},
{"varsubsetneq",             "U0228A-0FE00", "[SUBSET OF WITH NOT EQUAL TO - variant with stroke through bottom members]"},
{"varsubsetneqq",            "U02ACB-0FE00", "[SUBSET OF ABOVE NOT EQUAL TO - variant with stroke through bottom members]"},
{"varsupsetneq",             "U0228B-0FE00", "[SUPERSET OF WITH NOT EQUAL TO - variant with stroke through bottom members]"},
{"varsupsetneqq",            "U02ACC-0FE00", "[SUPERSET OF ABOVE NOT EQUAL TO - variant with stroke through bottom members]"},
{"vartheta",                 "U003D1", "[GREEK THETA SYMBOL]"},
{"vartriangleleft",          "U022B2", "[NORMAL SUBGROUP OF]"},
{"vartriangleright",         "U022B3", "[CONTAINS AS NORMAL SUBGROUP]"},
{"vcy",                      "U00432", "[CYRILLIC SMALL LETTER VE]"},
{"vdash",                    "U022A2", "[RIGHT TACK]"},
{"vee",                      "U02228", "[LOGICAL OR]"},
{"veebar",                   "U022BB", "[XOR]"},
{"veeeq",                    "U0225A", "[EQUIANGULAR TO]"},
{"vellip",                   "U022EE", "[VERTICAL ELLIPSIS]"},
{"verbar",                   "U0007C", "[VERTICAL LINE]"},
{"vert",                     "U0007C", "[VERTICAL LINE]"},
{"vfr",                      "U1D533", "[MATHEMATICAL FRAKTUR SMALL V]"},
{"vltri",                    "U022B2", "[NORMAL SUBGROUP OF]"},
{"vnsub",                    "U02282-020D2", "[SUBSET OF with vertical line]"},
{"vnsup",                    "U02283-020D2", "[SUPERSET OF with vertical line]"},
{"vopf",                     "U1D567", "[MATHEMATICAL DOUBLE-STRUCK SMALL V]"},
{"vprop",                    "U0221D", "[PROPORTIONAL TO]"},
{"vrtri",                    "U022B3", "[CONTAINS AS NORMAL SUBGROUP]"},
{"vscr",                     "U1D4CB", "[MATHEMATICAL SCRIPT SMALL V]"},
{"vsubnE",                   "U02ACB-0FE00", "[SUBSET OF ABOVE NOT EQUAL TO - variant with stroke through bottom members]"},
{"vsubne",                   "U0228A-0FE00", "[SUBSET OF WITH NOT EQUAL TO - variant with stroke through bottom members]"},
{"vsupnE",                   "U02ACC-0FE00", "[SUPERSET OF ABOVE NOT EQUAL TO - variant with stroke through bottom members]"},
{"vsupne",                   "U0228B-0FE00", "[SUPERSET OF WITH NOT EQUAL TO - variant with stroke through bottom members]"},
{"vzigzag",                  "U0299A", "[VERTICAL ZIGZAG LINE]"},
{"wcirc",                    "U00175", "[LATIN SMALL LETTER W WITH CIRCUMFLEX]"},
{"wedbar",                   "U02A5F", "[LOGICAL AND WITH UNDERBAR]"},
{"wedge",                    "U02227", "[LOGICAL AND]"},
{"wedgeq",                   "U02259", "[ESTIMATES]"},
{"weierp",                   "U02118", "[SCRIPT CAPITAL P]"},
{"wfr",                      "U1D534", "[MATHEMATICAL FRAKTUR SMALL W]"},
{"wopf",                     "U1D568", "[MATHEMATICAL DOUBLE-STRUCK SMALL W]"},
{"wp",                       "U02118", "[SCRIPT CAPITAL P]"},
{"wr",                       "U02240", "[WREATH PRODUCT]"},
{"wreath",                   "U02240", "[WREATH PRODUCT]"},
{"wscr",                     "U1D4CC", "[MATHEMATICAL SCRIPT SMALL W]"},
{"xcap",                     "U022C2", "[N-ARY INTERSECTION]"},
{"xcirc",                    "U025EF", "[LARGE CIRCLE]"},
{"xcup",                     "U022C3", "[N-ARY UNION]"},
{"xdtri",                    "U025BD", "[WHITE DOWN-POINTING TRIANGLE]"},
{"xfr",                      "U1D535", "[MATHEMATICAL FRAKTUR SMALL X]"},
{"xhArr",                    "U027FA", "[LONG LEFT RIGHT DOUBLE ARROW]"},
{"xharr",                    "U027F7", "[LONG LEFT RIGHT ARROW]"},
{"xi",                       "U003BE", "[GREEK SMALL LETTER XI]"},
{"xlArr",                    "U027F8", "[LONG LEFTWARDS DOUBLE ARROW]"},
{"xlarr",                    "U027F5", "[LONG LEFTWARDS ARROW]"},
{"xmap",                     "U027FC", "[LONG RIGHTWARDS ARROW FROM BAR]"},
{"xnis",                     "U022FB", "[CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE]"},
{"xodot",                    "U02A00", "[N-ARY CIRCLED DOT OPERATOR]"},
{"xopf",                     "U1D569", "[MATHEMATICAL DOUBLE-STRUCK SMALL X]"},
{"xoplus",                   "U02A01", "[N-ARY CIRCLED PLUS OPERATOR]"},
{"xotime",                   "U02A02", "[N-ARY CIRCLED TIMES OPERATOR]"},
{"xrArr",                    "U027F9", "[LONG RIGHTWARDS DOUBLE ARROW]"},
{"xrarr",                    "U027F6", "[LONG RIGHTWARDS ARROW]"},
{"xscr",                     "U1D4CD", "[MATHEMATICAL SCRIPT SMALL X]"},
{"xsqcup",                   "U02A06", "[N-ARY SQUARE UNION OPERATOR]"},
{"xuplus",                   "U02A04", "[N-ARY UNION OPERATOR WITH PLUS]"},
{"xutri",                    "U025B3", "[WHITE UP-POINTING TRIANGLE]"},
{"xvee",                     "U022C1", "[N-ARY LOGICAL OR]"},
{"xwedge",                   "U022C0", "[N-ARY LOGICAL AND]"},
{"yacute",                   "U000FD", "[LATIN SMALL LETTER Y WITH ACUTE]"},
{"yacy",                     "U0044F", "[CYRILLIC SMALL LETTER YA]"},
{"ycirc",                    "U00177", "[LATIN SMALL LETTER Y WITH CIRCUMFLEX]"},
{"ycy",                      "U0044B", "[CYRILLIC SMALL LETTER YERU]"},
{"yen",                      "U000A5", "[YEN SIGN]"},
{"yfr",                      "U1D536", "[MATHEMATICAL FRAKTUR SMALL Y]"},
{"yicy",                     "U00457", "[CYRILLIC SMALL LETTER YI]"},
{"yopf",                     "U1D56A", "[MATHEMATICAL DOUBLE-STRUCK SMALL Y]"},
{"yscr",                     "U1D4CE", "[MATHEMATICAL SCRIPT SMALL Y]"},
{"yucy",                     "U0044E", "[CYRILLIC SMALL LETTER YU]"},
{"yuml",                     "U000FF", "[LATIN SMALL LETTER Y WITH DIAERESIS]"},
{"zacute",                   "U0017A", "[LATIN SMALL LETTER Z WITH ACUTE]"},
{"zcaron",                   "U0017E", "[LATIN SMALL LETTER Z WITH CARON]"},
{"zcy",                      "U00437", "[CYRILLIC SMALL LETTER ZE]"},
{"zdot",                     "U0017C", "[LATIN SMALL LETTER Z WITH DOT ABOVE]"},
{"zeetrf",                   "U02128", "[BLACK-LETTER CAPITAL Z]"},
{"zeta",                     "U003B6", "[GREEK SMALL LETTER ZETA]"},
{"zfr",                      "U1D537", "[MATHEMATICAL FRAKTUR SMALL Z]"},
{"zhcy",                     "U00436", "[CYRILLIC SMALL LETTER ZHE]"},
{"zigrarr",                  "U021DD", "[RIGHTWARDS SQUIGGLE ARROW]"},
{"zopf",                     "U1D56B", "[MATHEMATICAL DOUBLE-STRUCK SMALL Z]"},
{"zscr",                     "U1D4CF", "[MATHEMATICAL SCRIPT SMALL Z]"}
};

int
main (int argc, char **argv)
{
	GString *utf8 = g_string_new ("");
	GString *string = g_string_new ("");
	char const *unicode;
	int i, j;
	gunichar value;

	for (i = 0; i < G_N_ELEMENTS (entities); i++) {
		g_string_assign (string, "");
		g_string_append_printf (string, "\"%s\",", entities[i].name);

		printf ("\t{%-25s", string->str);
		unicode = entities[i].unicode;

		g_string_assign (string, "");
		g_string_append_unichar (string, strtol (unicode + 1, NULL, 16));
		if (strlen (unicode) > 7)
			g_string_append_unichar (string, strtol (unicode + 7, NULL, 16));
		if (strlen (unicode) > 13)
			g_string_append_unichar (string, strtol (unicode + 13, NULL, 16));

		g_string_assign (utf8, "\"");
		for (j = 0; j < strlen (string->str); j++) {
			guint8 character = string->str[j];
			g_string_append_printf (utf8, "\\x%x", character);
		}
		g_string_append (utf8, "\"");

		printf ("%-26s},", utf8->str);
		printf (" /* %s %s*/\n", string->str, entities[i].comment);
	}
}
