///////////////////////////////////////////////////////////////////////////////
//                                                         
// BigDecTest.cc
// -------------
// BigDecimal class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 1996 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////


#include "../src/Exception.h"
#include "../src/BigDecimal.h"

int main(int argc, char **argv)
{

    
    int numCheck = 12;
    int checkCount = 1;
    
    try {
	
	
	cout << "1.." << numCheck << endl;

	

	BigDecimal d01(".97");
	if ( d01.toChain() == Chain("0.97") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;
	
       
	BigDecimal d02("0.0");	
	if ( d02.toChain() == Chain("0.0") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;


	BigDecimal d03("00004.45");	
	if ( d03.toChain() == Chain("4.45") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;

	BigDecimal d04("00004.450000");	
	if ( d04.toChain() == Chain("4.45") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;

	BigDecimal d05("00000.06780000");	
	if ( d05.toChain() == Chain("0.0678") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;

	
	BigDecimal d1("179.97");
	BigDecimal d2("120.11");
	BigDecimal d3("13.0");
	BigDecimal d4("4.987");      
	BigDecimal d5("16.987");
	
	if ( d2 < d1 )
	    cout << "ok " << checkCount << " - operator <" << endl;
	else
	    cout << "not ok " << checkCount << " - operator <" << endl;
	checkCount++;


	if ( d4 < d3 )
	    cout << "ok " << checkCount << " - operator <" << endl;
	else
	    cout << "not ok " << checkCount << " - operator <" << endl;
	checkCount++;

	if ( d3 < d2 )
	    cout << "ok " << checkCount << " - operator <" << endl;
	else
	    cout << "not ok " << checkCount << " - operator <" << endl;
	checkCount++;

	if ( d3 < d5 )
	    cout << "ok " << checkCount << " - operator <" << endl;
	else
	    cout << "not ok " << checkCount << " - operator <" << endl;
	checkCount++;

	

	BigDecimal f1("5.0000");
	BigDecimal f2("0.0");
	BigDecimal ddiv = f2.div(f1);

	if (  ddiv.toChain() == Chain("0.0") )
	    cout << "ok " << checkCount << " - div" << endl;
	else
	    cout << "not ok " << checkCount << " - div <" << endl;
	checkCount++;


	// eval term div (fixed)
	// eval facor div (fixed)-26.061528
	    
	BigDecimal f1n("-26.362528");
	BigDecimal f2n("-2606.152800");
	BigDecimal ddivn = f2n.div(f1n);

	// cout << ddivn << endl;
	
	if (  ddivn.toChain() == Chain("98.858227") )
	    cout << "ok " << checkCount << " - div" << endl;
	else
	    cout << "not ok " << checkCount << " - div <" << endl;
	checkCount++;

	

	
	BigDecimal dsub = d1.sub(d2);
	
	if (  dsub.toChain() == Chain("59.86") )
	    cout << "ok " << checkCount << " - sub" << endl;
	else
	    cout << "not ok " << checkCount << " - sub <" << endl;
	checkCount++;
	    
	
	// d2 = d1.mulDigit(7);
	
	// cout << d3 <<  endl;
    }
    catch (Exception e)
    {

	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }

    return 0;

}

