; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc < %s -mtriple=riscv32 -mattr=+v,+zfh,+zvfh -verify-machineinstrs | FileCheck %s -check-prefixes=CHECK,RV32
; RUN: llc < %s -mtriple=riscv64 -mattr=+v,+zfh,+zvfh -verify-machineinstrs | FileCheck %s -check-prefixes=CHECK,RV64

define <1 x i1> @v1i1(i1 %x, i1 %y) {
; CHECK-LABEL: v1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.s.x v8, a0
; CHECK-NEXT:    vmsne.vi v8, v8, 0
; CHECK-NEXT:    andi a1, a1, 1
; CHECK-NEXT:    vmv.s.x v9, a1
; CHECK-NEXT:    vmsne.vi v9, v9, 0
; CHECK-NEXT:    vmxor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head.x = insertelement <1 x i1> poison, i1 %x, i32 0
  %splat.x = shufflevector <1 x i1> %head.x, <1 x i1> poison, <1 x i32> zeroinitializer
  %head.y = insertelement <1 x i1> poison, i1 %y, i32 0
  %splat.y = shufflevector <1 x i1> %head.y, <1 x i1> poison, <1 x i32> zeroinitializer
  %v = add <1 x i1> %splat.x, %splat.y
  ret <1 x i1> %v
}

define <2 x i1> @v2i1(i1 %x, i1 %y) {
; CHECK-LABEL: v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vmsne.vi v8, v8, 0
; CHECK-NEXT:    andi a1, a1, 1
; CHECK-NEXT:    vmv.v.x v9, a1
; CHECK-NEXT:    vmsne.vi v9, v9, 0
; CHECK-NEXT:    vmxor.mm v0, v8, v9
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vrgather.vi v9, v8, 0
; CHECK-NEXT:    vmsne.vi v0, v9, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <2 x i1> poison, i1 %x, i32 0
  %splat.x = shufflevector <2 x i1> %head.x, <2 x i1> poison, <2 x i32> zeroinitializer
  %head.y = insertelement <2 x i1> poison, i1 %y, i32 0
  %splat.y = shufflevector <2 x i1> %head.y, <2 x i1> poison, <2 x i32> zeroinitializer
  %v = add <2 x i1> %splat.x, %splat.y
  ret <2 x i1> %v
}

define <4 x i1> @v4i1(i1 %x, i1 %y) {
; CHECK-LABEL: v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vmsne.vi v8, v8, 0
; CHECK-NEXT:    andi a1, a1, 1
; CHECK-NEXT:    vmv.v.x v9, a1
; CHECK-NEXT:    vmsne.vi v9, v9, 0
; CHECK-NEXT:    vmxor.mm v0, v8, v9
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vrgather.vi v9, v8, 0
; CHECK-NEXT:    vmsne.vi v0, v9, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <4 x i1> poison, i1 %x, i32 0
  %splat.x = shufflevector <4 x i1> %head.x, <4 x i1> poison, <4 x i32> zeroinitializer
  %head.y = insertelement <4 x i1> poison, i1 %y, i32 0
  %splat.y = shufflevector <4 x i1> %head.y, <4 x i1> poison, <4 x i32> zeroinitializer
  %v = add <4 x i1> %splat.x, %splat.y
  ret <4 x i1> %v
}

define <8 x i1> @v8i1(i1 %x, i1 %y) {
; CHECK-LABEL: v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vmsne.vi v8, v8, 0
; CHECK-NEXT:    andi a1, a1, 1
; CHECK-NEXT:    vmv.v.x v9, a1
; CHECK-NEXT:    vmsne.vi v9, v9, 0
; CHECK-NEXT:    vmxor.mm v0, v8, v9
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vrgather.vi v9, v8, 0
; CHECK-NEXT:    vmsne.vi v0, v9, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <8 x i1> poison, i1 %x, i32 0
  %splat.x = shufflevector <8 x i1> %head.x, <8 x i1> poison, <8 x i32> zeroinitializer
  %head.y = insertelement <8 x i1> poison, i1 %y, i32 0
  %splat.y = shufflevector <8 x i1> %head.y, <8 x i1> poison, <8 x i32> zeroinitializer
  %v = add <8 x i1> %splat.x, %splat.y
  ret <8 x i1> %v
}

define <16 x i1> @v16i1(i1 %x, i1 %y) {
; CHECK-LABEL: v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vmsne.vi v8, v8, 0
; CHECK-NEXT:    andi a1, a1, 1
; CHECK-NEXT:    vmv.v.x v9, a1
; CHECK-NEXT:    vmsne.vi v9, v9, 0
; CHECK-NEXT:    vmxor.mm v0, v8, v9
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vrgather.vi v9, v8, 0
; CHECK-NEXT:    vmsne.vi v0, v9, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <16 x i1> poison, i1 %x, i32 0
  %splat.x = shufflevector <16 x i1> %head.x, <16 x i1> poison, <16 x i32> zeroinitializer
  %head.y = insertelement <16 x i1> poison, i1 %y, i32 0
  %splat.y = shufflevector <16 x i1> %head.y, <16 x i1> poison, <16 x i32> zeroinitializer
  %v = add <16 x i1> %splat.x, %splat.y
  ret <16 x i1> %v
}

define <32 x i1> @v32i1(i1 %x, i1 %y) {
; CHECK-LABEL: v32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vmsne.vi v10, v8, 0
; CHECK-NEXT:    andi a1, a1, 1
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vmsne.vi v11, v8, 0
; CHECK-NEXT:    vmxor.mm v0, v10, v11
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vrgather.vi v10, v8, 0
; CHECK-NEXT:    vmsne.vi v0, v10, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <32 x i1> poison, i1 %x, i32 0
  %splat.x = shufflevector <32 x i1> %head.x, <32 x i1> poison, <32 x i32> zeroinitializer
  %head.y = insertelement <32 x i1> poison, i1 %y, i32 0
  %splat.y = shufflevector <32 x i1> %head.y, <32 x i1> poison, <32 x i32> zeroinitializer
  %v = add <32 x i1> %splat.x, %splat.y
  ret <32 x i1> %v
}

define <64 x i1> @v64i1(i1 %x, i1 %y) {
; CHECK-LABEL: v64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    li a2, 64
; CHECK-NEXT:    vsetvli zero, a2, e8, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vmsne.vi v12, v8, 0
; CHECK-NEXT:    andi a1, a1, 1
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vmsne.vi v13, v8, 0
; CHECK-NEXT:    vmxor.mm v0, v12, v13
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vrgather.vi v12, v8, 0
; CHECK-NEXT:    vmsne.vi v0, v12, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <64 x i1> poison, i1 %x, i32 0
  %splat.x = shufflevector <64 x i1> %head.x, <64 x i1> poison, <64 x i32> zeroinitializer
  %head.y = insertelement <64 x i1> poison, i1 %y, i32 0
  %splat.y = shufflevector <64 x i1> %head.y, <64 x i1> poison, <64 x i32> zeroinitializer
  %v = add <64 x i1> %splat.x, %splat.y
  ret <64 x i1> %v
}

define <1 x i8> @v1i8(i8 %x, i8 %y) {
; CHECK-LABEL: v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.s.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <1 x i8> poison, i8 %x, i32 0
  %splat.x = shufflevector <1 x i8> %head.x, <1 x i8> poison, <1 x i32> zeroinitializer
  %head.y = insertelement <1 x i8> poison, i8 %y, i32 0
  %splat.y = shufflevector <1 x i8> %head.y, <1 x i8> poison, <1 x i32> zeroinitializer
  %v = add <1 x i8> %splat.x, %splat.y
  ret <1 x i8> %v
}

define <2 x i8> @v2i8(i8 %x, i8 %y) {
; CHECK-LABEL: v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v9, v8, a1
; CHECK-NEXT:    vrgather.vi v8, v9, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <2 x i8> poison, i8 %x, i32 0
  %splat.x = shufflevector <2 x i8> %head.x, <2 x i8> poison, <2 x i32> zeroinitializer
  %head.y = insertelement <2 x i8> poison, i8 %y, i32 0
  %splat.y = shufflevector <2 x i8> %head.y, <2 x i8> poison, <2 x i32> zeroinitializer
  %v = add <2 x i8> %splat.x, %splat.y
  ret <2 x i8> %v
}

define <4 x i8> @v4i8(i8 %x, i8 %y) {
; CHECK-LABEL: v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v9, v8, a1
; CHECK-NEXT:    vrgather.vi v8, v9, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <4 x i8> poison, i8 %x, i32 0
  %splat.x = shufflevector <4 x i8> %head.x, <4 x i8> poison, <4 x i32> zeroinitializer
  %head.y = insertelement <4 x i8> poison, i8 %y, i32 0
  %splat.y = shufflevector <4 x i8> %head.y, <4 x i8> poison, <4 x i32> zeroinitializer
  %v = add <4 x i8> %splat.x, %splat.y
  ret <4 x i8> %v
}

define <8 x i8> @v8i8(i8 %x, i8 %y) {
; CHECK-LABEL: v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v9, v8, a1
; CHECK-NEXT:    vrgather.vi v8, v9, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <8 x i8> poison, i8 %x, i32 0
  %splat.x = shufflevector <8 x i8> %head.x, <8 x i8> poison, <8 x i32> zeroinitializer
  %head.y = insertelement <8 x i8> poison, i8 %y, i32 0
  %splat.y = shufflevector <8 x i8> %head.y, <8 x i8> poison, <8 x i32> zeroinitializer
  %v = add <8 x i8> %splat.x, %splat.y
  ret <8 x i8> %v
}

define <16 x i8> @v16i8(i8 %x, i8 %y) {
; CHECK-LABEL: v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v9, v8, a1
; CHECK-NEXT:    vrgather.vi v8, v9, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <16 x i8> poison, i8 %x, i32 0
  %splat.x = shufflevector <16 x i8> %head.x, <16 x i8> poison, <16 x i32> zeroinitializer
  %head.y = insertelement <16 x i8> poison, i8 %y, i32 0
  %splat.y = shufflevector <16 x i8> %head.y, <16 x i8> poison, <16 x i32> zeroinitializer
  %v = add <16 x i8> %splat.x, %splat.y
  ret <16 x i8> %v
}

define <32 x i8> @v32i8(i8 %x, i8 %y) {
; CHECK-LABEL: v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v10, v8, a1
; CHECK-NEXT:    vrgather.vi v8, v10, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <32 x i8> poison, i8 %x, i32 0
  %splat.x = shufflevector <32 x i8> %head.x, <32 x i8> poison, <32 x i32> zeroinitializer
  %head.y = insertelement <32 x i8> poison, i8 %y, i32 0
  %splat.y = shufflevector <32 x i8> %head.y, <32 x i8> poison, <32 x i32> zeroinitializer
  %v = add <32 x i8> %splat.x, %splat.y
  ret <32 x i8> %v
}

define <64 x i8> @v64i8(i8 %x, i8 %y) {
; CHECK-LABEL: v64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 64
; CHECK-NEXT:    vsetvli zero, a2, e8, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v12, v8, a1
; CHECK-NEXT:    vrgather.vi v8, v12, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <64 x i8> poison, i8 %x, i32 0
  %splat.x = shufflevector <64 x i8> %head.x, <64 x i8> poison, <64 x i32> zeroinitializer
  %head.y = insertelement <64 x i8> poison, i8 %y, i32 0
  %splat.y = shufflevector <64 x i8> %head.y, <64 x i8> poison, <64 x i32> zeroinitializer
  %v = add <64 x i8> %splat.x, %splat.y
  ret <64 x i8> %v
}

define <1 x i16> @v1i16(i16 %x, i16 %y) {
; CHECK-LABEL: v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.s.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <1 x i16> poison, i16 %x, i32 0
  %splat.x = shufflevector <1 x i16> %head.x, <1 x i16> poison, <1 x i32> zeroinitializer
  %head.y = insertelement <1 x i16> poison, i16 %y, i32 0
  %splat.y = shufflevector <1 x i16> %head.y, <1 x i16> poison, <1 x i32> zeroinitializer
  %v = add <1 x i16> %splat.x, %splat.y
  ret <1 x i16> %v
}

define <2 x i16> @v2i16(i16 %x, i16 %y) {
; CHECK-LABEL: v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v9, v8, a1
; CHECK-NEXT:    vrgather.vi v8, v9, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <2 x i16> poison, i16 %x, i32 0
  %splat.x = shufflevector <2 x i16> %head.x, <2 x i16> poison, <2 x i32> zeroinitializer
  %head.y = insertelement <2 x i16> poison, i16 %y, i32 0
  %splat.y = shufflevector <2 x i16> %head.y, <2 x i16> poison, <2 x i32> zeroinitializer
  %v = add <2 x i16> %splat.x, %splat.y
  ret <2 x i16> %v
}

define <4 x i16> @v4i16(i16 %x, i16 %y) {
; CHECK-LABEL: v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v9, v8, a1
; CHECK-NEXT:    vrgather.vi v8, v9, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <4 x i16> poison, i16 %x, i32 0
  %splat.x = shufflevector <4 x i16> %head.x, <4 x i16> poison, <4 x i32> zeroinitializer
  %head.y = insertelement <4 x i16> poison, i16 %y, i32 0
  %splat.y = shufflevector <4 x i16> %head.y, <4 x i16> poison, <4 x i32> zeroinitializer
  %v = add <4 x i16> %splat.x, %splat.y
  ret <4 x i16> %v
}

define <8 x i16> @v8i16(i16 %x, i16 %y) {
; CHECK-LABEL: v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v9, v8, a1
; CHECK-NEXT:    vrgather.vi v8, v9, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <8 x i16> poison, i16 %x, i32 0
  %splat.x = shufflevector <8 x i16> %head.x, <8 x i16> poison, <8 x i32> zeroinitializer
  %head.y = insertelement <8 x i16> poison, i16 %y, i32 0
  %splat.y = shufflevector <8 x i16> %head.y, <8 x i16> poison, <8 x i32> zeroinitializer
  %v = add <8 x i16> %splat.x, %splat.y
  ret <8 x i16> %v
}

define <16 x i16> @v16i16(i16 %x, i16 %y) {
; CHECK-LABEL: v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v10, v8, a1
; CHECK-NEXT:    vrgather.vi v8, v10, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <16 x i16> poison, i16 %x, i32 0
  %splat.x = shufflevector <16 x i16> %head.x, <16 x i16> poison, <16 x i32> zeroinitializer
  %head.y = insertelement <16 x i16> poison, i16 %y, i32 0
  %splat.y = shufflevector <16 x i16> %head.y, <16 x i16> poison, <16 x i32> zeroinitializer
  %v = add <16 x i16> %splat.x, %splat.y
  ret <16 x i16> %v
}

define <32 x i16> @v32i16(i16 %x, i16 %y) {
; CHECK-LABEL: v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v12, v8, a1
; CHECK-NEXT:    vrgather.vi v8, v12, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <32 x i16> poison, i16 %x, i32 0
  %splat.x = shufflevector <32 x i16> %head.x, <32 x i16> poison, <32 x i32> zeroinitializer
  %head.y = insertelement <32 x i16> poison, i16 %y, i32 0
  %splat.y = shufflevector <32 x i16> %head.y, <32 x i16> poison, <32 x i32> zeroinitializer
  %v = add <32 x i16> %splat.x, %splat.y
  ret <32 x i16> %v
}

define <1 x i32> @v1i32(i32 %x, i32 %y) {
; CHECK-LABEL: v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.s.x v8, a0
; CHECK-NEXT:    vadd.vx v8, v8, a1
; CHECK-NEXT:    ret
  %head.x = insertelement <1 x i32> poison, i32 %x, i32 0
  %splat.x = shufflevector <1 x i32> %head.x, <1 x i32> poison, <1 x i32> zeroinitializer
  %head.y = insertelement <1 x i32> poison, i32 %y, i32 0
  %splat.y = shufflevector <1 x i32> %head.y, <1 x i32> poison, <1 x i32> zeroinitializer
  %v = add <1 x i32> %splat.x, %splat.y
  ret <1 x i32> %v
}

define <2 x i32> @v2i32(i32 %x, i32 %y) {
; CHECK-LABEL: v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v9, v8, a1
; CHECK-NEXT:    vrgather.vi v8, v9, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <2 x i32> poison, i32 %x, i32 0
  %splat.x = shufflevector <2 x i32> %head.x, <2 x i32> poison, <2 x i32> zeroinitializer
  %head.y = insertelement <2 x i32> poison, i32 %y, i32 0
  %splat.y = shufflevector <2 x i32> %head.y, <2 x i32> poison, <2 x i32> zeroinitializer
  %v = add <2 x i32> %splat.x, %splat.y
  ret <2 x i32> %v
}

define <4 x i32> @v4i32(i32 %x, i32 %y) {
; CHECK-LABEL: v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v9, v8, a1
; CHECK-NEXT:    vrgather.vi v8, v9, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <4 x i32> poison, i32 %x, i32 0
  %splat.x = shufflevector <4 x i32> %head.x, <4 x i32> poison, <4 x i32> zeroinitializer
  %head.y = insertelement <4 x i32> poison, i32 %y, i32 0
  %splat.y = shufflevector <4 x i32> %head.y, <4 x i32> poison, <4 x i32> zeroinitializer
  %v = add <4 x i32> %splat.x, %splat.y
  ret <4 x i32> %v
}

define <8 x i32> @v8i32(i32 %x, i32 %y) {
; CHECK-LABEL: v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v10, v8, a1
; CHECK-NEXT:    vrgather.vi v8, v10, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <8 x i32> poison, i32 %x, i32 0
  %splat.x = shufflevector <8 x i32> %head.x, <8 x i32> poison, <8 x i32> zeroinitializer
  %head.y = insertelement <8 x i32> poison, i32 %y, i32 0
  %splat.y = shufflevector <8 x i32> %head.y, <8 x i32> poison, <8 x i32> zeroinitializer
  %v = add <8 x i32> %splat.x, %splat.y
  ret <8 x i32> %v
}

define <16 x i32> @v16i32(i32 %x, i32 %y) {
; CHECK-LABEL: v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a0
; CHECK-NEXT:    vadd.vx v12, v8, a1
; CHECK-NEXT:    vrgather.vi v8, v12, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <16 x i32> poison, i32 %x, i32 0
  %splat.x = shufflevector <16 x i32> %head.x, <16 x i32> poison, <16 x i32> zeroinitializer
  %head.y = insertelement <16 x i32> poison, i32 %y, i32 0
  %splat.y = shufflevector <16 x i32> %head.y, <16 x i32> poison, <16 x i32> zeroinitializer
  %v = add <16 x i32> %splat.x, %splat.y
  ret <16 x i32> %v
}

define <1 x i64> @v1i64(i64 %x, i64 %y) {
; RV32-LABEL: v1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v8, (a0), zero
; RV32-NEXT:    sw a3, 4(sp)
; RV32-NEXT:    sw a2, 0(sp)
; RV32-NEXT:    mv a0, sp
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vadd.vv v8, v8, v9
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: v1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; RV64-NEXT:    vmv.s.x v8, a0
; RV64-NEXT:    vadd.vx v8, v8, a1
; RV64-NEXT:    ret
  %head.x = insertelement <1 x i64> poison, i64 %x, i32 0
  %splat.x = shufflevector <1 x i64> %head.x, <1 x i64> poison, <1 x i32> zeroinitializer
  %head.y = insertelement <1 x i64> poison, i64 %y, i32 0
  %splat.y = shufflevector <1 x i64> %head.y, <1 x i64> poison, <1 x i32> zeroinitializer
  %v = add <1 x i64> %splat.x, %splat.y
  ret <1 x i64> %v
}

define <2 x i64> @v2i64(i64 %x, i64 %y) {
; RV32-LABEL: v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v8, (a0), zero
; RV32-NEXT:    sw a3, 4(sp)
; RV32-NEXT:    sw a2, 0(sp)
; RV32-NEXT:    mv a0, sp
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vadd.vv v9, v8, v9
; RV32-NEXT:    vrgather.vi v8, v9, 0
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV64-NEXT:    vmv.v.x v8, a0
; RV64-NEXT:    vadd.vx v9, v8, a1
; RV64-NEXT:    vrgather.vi v8, v9, 0
; RV64-NEXT:    ret
  %head.x = insertelement <2 x i64> poison, i64 %x, i32 0
  %splat.x = shufflevector <2 x i64> %head.x, <2 x i64> poison, <2 x i32> zeroinitializer
  %head.y = insertelement <2 x i64> poison, i64 %y, i32 0
  %splat.y = shufflevector <2 x i64> %head.y, <2 x i64> poison, <2 x i32> zeroinitializer
  %v = add <2 x i64> %splat.x, %splat.y
  ret <2 x i64> %v
}

define <4 x i64> @v4i64(i64 %x, i64 %y) {
; RV32-LABEL: v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; RV32-NEXT:    vlse64.v v8, (a0), zero
; RV32-NEXT:    sw a3, 4(sp)
; RV32-NEXT:    sw a2, 0(sp)
; RV32-NEXT:    mv a0, sp
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    vadd.vv v10, v8, v10
; RV32-NEXT:    vrgather.vi v8, v10, 0
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; RV64-NEXT:    vmv.v.x v8, a0
; RV64-NEXT:    vadd.vx v10, v8, a1
; RV64-NEXT:    vrgather.vi v8, v10, 0
; RV64-NEXT:    ret
  %head.x = insertelement <4 x i64> poison, i64 %x, i32 0
  %splat.x = shufflevector <4 x i64> %head.x, <4 x i64> poison, <4 x i32> zeroinitializer
  %head.y = insertelement <4 x i64> poison, i64 %y, i32 0
  %splat.y = shufflevector <4 x i64> %head.y, <4 x i64> poison, <4 x i32> zeroinitializer
  %v = add <4 x i64> %splat.x, %splat.y
  ret <4 x i64> %v
}

define <8 x i64> @v8i64(i64 %x, i64 %y) {
; RV32-LABEL: v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV32-NEXT:    vlse64.v v8, (a0), zero
; RV32-NEXT:    sw a3, 4(sp)
; RV32-NEXT:    sw a2, 0(sp)
; RV32-NEXT:    mv a0, sp
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    vadd.vv v12, v8, v12
; RV32-NEXT:    vrgather.vi v8, v12, 0
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV64-NEXT:    vmv.v.x v8, a0
; RV64-NEXT:    vadd.vx v12, v8, a1
; RV64-NEXT:    vrgather.vi v8, v12, 0
; RV64-NEXT:    ret
  %head.x = insertelement <8 x i64> poison, i64 %x, i32 0
  %splat.x = shufflevector <8 x i64> %head.x, <8 x i64> poison, <8 x i32> zeroinitializer
  %head.y = insertelement <8 x i64> poison, i64 %y, i32 0
  %splat.y = shufflevector <8 x i64> %head.y, <8 x i64> poison, <8 x i32> zeroinitializer
  %v = add <8 x i64> %splat.x, %splat.y
  ret <8 x i64> %v
}

define <4 x half> @v4f16(half %x, half %y) {
; CHECK-LABEL: v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v8, fa0
; CHECK-NEXT:    vfadd.vf v9, v8, fa1
; CHECK-NEXT:    vrgather.vi v8, v9, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <4 x half> poison, half %x, i32 0
  %splat.x = shufflevector <4 x half> %head.x, <4 x half> poison, <4 x i32> zeroinitializer
  %head.y = insertelement <4 x half> poison, half %y, i32 0
  %splat.y = shufflevector <4 x half> %head.y, <4 x half> poison, <4 x i32> zeroinitializer
  %v = fadd <4 x half> %splat.x, %splat.y
  ret <4 x half> %v
}

define <2 x float> @v2f32(float %x, float %y) {
; CHECK-LABEL: v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v8, fa0
; CHECK-NEXT:    vfadd.vf v9, v8, fa1
; CHECK-NEXT:    vrgather.vi v8, v9, 0
; CHECK-NEXT:    ret
  %head.x = insertelement <2 x float> poison, float %x, i32 0
  %splat.x = shufflevector <2 x float> %head.x, <2 x float> poison, <2 x i32> zeroinitializer
  %head.y = insertelement <2 x float> poison, float %y, i32 0
  %splat.y = shufflevector <2 x float> %head.y, <2 x float> poison, <2 x i32> zeroinitializer
  %v = fadd <2 x float> %splat.x, %splat.y
  ret <2 x float> %v
}

define <1 x double> @v2f64(double %x, double %y) {
; CHECK-LABEL: v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.s.f v8, fa0
; CHECK-NEXT:    vfadd.vf v8, v8, fa1
; CHECK-NEXT:    ret
  %head.x = insertelement <1 x double> poison, double %x, i32 0
  %splat.x = shufflevector <1 x double> %head.x, <1 x double> poison, <1 x i32> zeroinitializer
  %head.y = insertelement <1 x double> poison, double %y, i32 0
  %splat.y = shufflevector <1 x double> %head.y, <1 x double> poison, <1 x i32> zeroinitializer
  %v = fadd <1 x double> %splat.x, %splat.y
  ret <1 x double> %v
}
