; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT

define float @ret_fdiv_ieee(float %arg0, float %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_ieee
; CHECK-SAME: (float [[ARG0:%.*]], float [[ARG1:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_daz(float %arg0, float %arg1) #1 {
; CHECK-LABEL: define float @ret_fdiv_daz
; CHECK-SAME: (float [[ARG0:%.*]], float [[ARG1:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_noinf_nozero__all(float nofpclass(inf zero) %arg0, float %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_ieee_noinf_nozero__all
; CHECK-SAME: (float nofpclass(inf zero) [[ARG0:%.*]], float [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_nonan_noinf_nozero__all(float nofpclass(nan inf zero) %arg0, float %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_ieee_nonan_noinf_nozero__all
; CHECK-SAME: (float nofpclass(nan inf zero) [[ARG0:%.*]], float [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_all__nonan_noinf_nozero(float %arg0, float nofpclass(nan inf zero) %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_ieee_all__nonan_noinf_nozero
; CHECK-SAME: (float [[ARG0:%.*]], float nofpclass(nan inf zero) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_nonan_noinf_nozero__nonan(float nofpclass(nan inf zero) %arg0, float nofpclass(nan) %arg1) #0 {
; CHECK-LABEL: define nofpclass(nan) float @ret_fdiv_ieee_nonan_noinf_nozero__nonan
; CHECK-SAME: (float nofpclass(nan inf zero) [[ARG0:%.*]], float nofpclass(nan) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_nonan__nonan_noinf_nozero(float nofpclass(nan) %arg0, float nofpclass(nan inf zero) %arg1) #0 {
; CHECK-LABEL: define nofpclass(nan) float @ret_fdiv_ieee_nonan__nonan_noinf_nozero
; CHECK-SAME: (float nofpclass(nan) [[ARG0:%.*]], float nofpclass(nan inf zero) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_nonan_nozero__nonan_noinf(float nofpclass(nan zero) %arg0, float nofpclass(nan inf) %arg1) #0 {
; CHECK-LABEL: define nofpclass(nan) float @ret_fdiv_ieee_nonan_nozero__nonan_noinf
; CHECK-SAME: (float nofpclass(nan zero) [[ARG0:%.*]], float nofpclass(nan inf) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_nonan_noinf__nonan_nozero(float nofpclass(nan inf) %arg0, float nofpclass(nan zero) %arg1) #0 {
; CHECK-LABEL: define nofpclass(nan) float @ret_fdiv_ieee_nonan_noinf__nonan_nozero
; CHECK-SAME: (float nofpclass(nan inf) [[ARG0:%.*]], float nofpclass(nan zero) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_daz_nonan_nozero__nonan_noinf(float nofpclass(nan zero) %arg0, float nofpclass(nan inf) %arg1) #1 {
; CHECK-LABEL: define float @ret_fdiv_daz_nonan_nozero__nonan_noinf
; CHECK-SAME: (float nofpclass(nan zero) [[ARG0:%.*]], float nofpclass(nan inf) [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_daz_nonan_noinf__nonan_nozero(float nofpclass(nan inf) %arg0, float nofpclass(nan zero) %arg1) #1 {
; CHECK-LABEL: define float @ret_fdiv_daz_nonan_noinf__nonan_nozero
; CHECK-SAME: (float nofpclass(nan inf) [[ARG0:%.*]], float nofpclass(nan zero) [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_daz_nonan_nozero_nosub__nonan_noinf(float nofpclass(nan zero sub) %arg0, float nofpclass(nan inf) %arg1) #1 {
; CHECK-LABEL: define nofpclass(nan) float @ret_fdiv_daz_nonan_nozero_nosub__nonan_noinf
; CHECK-SAME: (float nofpclass(nan zero sub) [[ARG0:%.*]], float nofpclass(nan inf) [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_daz_nonan_noinf__nonan_nozero_nosub(float nofpclass(nan inf) %arg0, float nofpclass(nan zero sub) %arg1) #1 {
; CHECK-LABEL: define nofpclass(nan) float @ret_fdiv_daz_nonan_noinf__nonan_nozero_nosub
; CHECK-SAME: (float nofpclass(nan inf) [[ARG0:%.*]], float nofpclass(nan zero sub) [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_nonan_noinf__nonan_noinf(float nofpclass(nan) %arg0, float nofpclass(nan) %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_ieee_nonan_noinf__nonan_noinf
; CHECK-SAME: (float nofpclass(nan) [[ARG0:%.*]], float nofpclass(nan) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_nonan_noinf_nozero__nonan_noinf_nozero(float nofpclass(nan inf zero) %arg0, float nofpclass(nan inf zero) %arg1) #0 {
; CHECK-LABEL: define nofpclass(nan) float @ret_fdiv_ieee_nonan_noinf_nozero__nonan_noinf_nozero
; CHECK-SAME: (float nofpclass(nan inf zero) [[ARG0:%.*]], float nofpclass(nan inf zero) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_daz_nonan_noinf_nozero__nonan_noinf_nozero(float nofpclass(nan inf zero) %arg0, float nofpclass(nan inf zero) %arg1) #1 {
; CHECK-LABEL: define float @ret_fdiv_daz_nonan_noinf_nozero__nonan_noinf_nozero
; CHECK-SAME: (float nofpclass(nan inf zero) [[ARG0:%.*]], float nofpclass(nan inf zero) [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_dapz_nonan_noinf_nozero__nonan_noinf_nozero(float nofpclass(nan inf zero) %arg0, float nofpclass(nan inf zero) %arg1) #2 {
; CHECK-LABEL: define float @ret_fdiv_dapz_nonan_noinf_nozero__nonan_noinf_nozero
; CHECK-SAME: (float nofpclass(nan inf zero) [[ARG0:%.*]], float nofpclass(nan inf zero) [[ARG1:%.*]]) #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_dynamic_nonan_noinf_nozero__nonan_noinf_nozero(float nofpclass(nan inf zero) %arg0, float nofpclass(nan inf zero) %arg1) #3 {
; CHECK-LABEL: define float @ret_fdiv_dynamic_nonan_noinf_nozero__nonan_noinf_nozero
; CHECK-SAME: (float nofpclass(nan inf zero) [[ARG0:%.*]], float nofpclass(nan inf zero) [[ARG1:%.*]]) #[[ATTR3:[0-9]+]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_nonan_noinf_noinf__nonan_noinf_noinf(float nofpclass(nan inf) %arg0, float nofpclass(nan inf) %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_ieee_nonan_noinf_noinf__nonan_noinf_noinf
; CHECK-SAME: (float nofpclass(nan inf) [[ARG0:%.*]], float nofpclass(nan inf) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_nonan_noinf_nozero__nonan_noinf_noinf(float nofpclass(nan inf zero) %arg0, float nofpclass(nan inf) %arg1) #0 {
; CHECK-LABEL: define nofpclass(nan) float @ret_fdiv_ieee_nonan_noinf_nozero__nonan_noinf_noinf
; CHECK-SAME: (float nofpclass(nan inf zero) [[ARG0:%.*]], float nofpclass(nan inf) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_nonan_noinf_noinf__nonan_noinf_nozero(float nofpclass(nan inf) %arg0, float nofpclass(nan inf zero) %arg1) #0 {
; CHECK-LABEL: define nofpclass(nan) float @ret_fdiv_ieee_nonan_noinf_noinf__nonan_noinf_nozero
; CHECK-SAME: (float nofpclass(nan inf) [[ARG0:%.*]], float nofpclass(nan inf zero) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_nonan_noinf_noinf__nonan_noinf_noposzero(float nofpclass(nan inf) %arg0, float nofpclass(nan pzero) %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_ieee_nonan_noinf_noinf__nonan_noinf_noposzero
; CHECK-SAME: (float nofpclass(nan inf) [[ARG0:%.*]], float nofpclass(nan pzero) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_nonan_noinf_noposzero__nonan_noinf_noinf(float nofpclass(nan pzero) %arg0, float nofpclass(nan inf) %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_ieee_nonan_noinf_noposzero__nonan_noinf_noinf
; CHECK-SAME: (float nofpclass(nan pzero) [[ARG0:%.*]], float nofpclass(nan inf) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_nonan_noinf_nozero_nosub__nonan_noinf_nozero_nosub(float nofpclass(nan inf zero sub) %arg0, float nofpclass(nan inf zero sub) %arg1) #0 {
; CHECK-LABEL: define nofpclass(nan) float @ret_fdiv_ieee_nonan_noinf_nozero_nosub__nonan_noinf_nozero_nosub
; CHECK-SAME: (float nofpclass(nan inf zero sub) [[ARG0:%.*]], float nofpclass(nan inf zero sub) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

; Denormal mode doesn't matter because sources are nofpclass(sub)
define float @ret_fdiv_daz_nonan_noinf_nozero_nosub__nonan_noinf_nozero_nosub(float nofpclass(nan inf zero sub) %arg0, float nofpclass(nan inf zero sub) %arg1) #1 {
; CHECK-LABEL: define nofpclass(nan) float @ret_fdiv_daz_nonan_noinf_nozero_nosub__nonan_noinf_nozero_nosub
; CHECK-SAME: (float nofpclass(nan inf zero sub) [[ARG0:%.*]], float nofpclass(nan inf zero sub) [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_dapz_nonan_noinf_nozero_nosub__nonan_noinf_nozero_nosub(float nofpclass(nan inf zero sub) %arg0, float nofpclass(nan inf zero sub) %arg1) #2 {
; CHECK-LABEL: define nofpclass(nan) float @ret_fdiv_dapz_nonan_noinf_nozero_nosub__nonan_noinf_nozero_nosub
; CHECK-SAME: (float nofpclass(nan inf zero sub) [[ARG0:%.*]], float nofpclass(nan inf zero sub) [[ARG1:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_dynamic_nonan_noinf_nozero_nosub__nonan_noinf_nozero_nosub(float nofpclass(nan inf zero sub) %arg0, float nofpclass(nan inf zero sub) %arg1) #3 {
; CHECK-LABEL: define nofpclass(nan) float @ret_fdiv_dynamic_nonan_noinf_nozero_nosub__nonan_noinf_nozero_nosub
; CHECK-SAME: (float nofpclass(nan inf zero sub) [[ARG0:%.*]], float nofpclass(nan inf zero sub) [[ARG1:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

; Missing no-subnormal on lhs
define float @ret_fdiv_daz_nonan_noinf_nozero__nonan_noinf_nozero_nosub(float nofpclass(nan inf zero) %arg0, float nofpclass(nan inf zero sub) %arg1) #1 {
; CHECK-LABEL: define nofpclass(nan) float @ret_fdiv_daz_nonan_noinf_nozero__nonan_noinf_nozero_nosub
; CHECK-SAME: (float nofpclass(nan inf zero) [[ARG0:%.*]], float nofpclass(nan inf zero sub) [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

; Missing no-subnormal on lhs
define float @ret_fdiv_daz_nonan_noinf_nozero_nosub__nonan_noinf_nozero(float nofpclass(nan inf zero sub) %arg0, float nofpclass(nan inf zero) %arg1) #1 {
; CHECK-LABEL: define nofpclass(nan) float @ret_fdiv_daz_nonan_noinf_nozero_nosub__nonan_noinf_nozero
; CHECK-SAME: (float nofpclass(nan inf zero sub) [[ARG0:%.*]], float nofpclass(nan inf zero) [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

; should be able to infer noinf
define float @ret_fdiv_ieee_noinf__nozero(float nofpclass(inf) %arg0, float nofpclass(zero) %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_ieee_noinf__nozero
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]], float nofpclass(zero) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_all__nozero(float %arg0, float nofpclass(zero) %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_ieee_all__nozero
; CHECK-SAME: (float [[ARG0:%.*]], float nofpclass(zero) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_noinf__all(float nofpclass(inf) %arg0, float %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_ieee_noinf__all
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]], float [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_ieee_nozero__noinf(float nofpclass(zero) %arg0, float nofpclass(inf) %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_ieee_nozero__noinf
; CHECK-SAME: (float nofpclass(zero) [[ARG0:%.*]], float nofpclass(inf) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_daz_noinf__nozero(float nofpclass(inf) %arg0, float nofpclass(zero) %arg1) #1 {
; CHECK-LABEL: define float @ret_fdiv_daz_noinf__nozero
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]], float nofpclass(zero) [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_daz_noinf__nozero_nosub(float nofpclass(inf) %arg0, float nofpclass(zero sub) %arg1) #1 {
; CHECK-LABEL: define float @ret_fdiv_daz_noinf__nozero_nosub
; CHECK-SAME: (float nofpclass(inf) [[ARG0:%.*]], float nofpclass(zero sub) [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_same_operands(float %arg) #0 {
; CHECK-LABEL: define nofpclass(inf zero sub nnorm) float @ret_fdiv_same_operands
; CHECK-SAME: (float nofpclass(inf zero sub nnorm) [[ARG:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG]], [[ARG]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg, %arg
  ret float %fdiv
}

define float @ret_fdiv_same_operands_nosnan(float nofpclass(snan) %arg) #0 {
; CHECK-LABEL: define nofpclass(inf zero sub nnorm) float @ret_fdiv_same_operands_nosnan
; CHECK-SAME: (float nofpclass(snan inf zero sub nnorm) [[ARG:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG]], [[ARG]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg, %arg
  ret float %fdiv
}

define float @ret_fdiv_same_operands_noqnan(float nofpclass(qnan) %arg) #0 {
; CHECK-LABEL: define nofpclass(inf zero sub nnorm) float @ret_fdiv_same_operands_noqnan
; CHECK-SAME: (float nofpclass(qnan inf zero sub nnorm) [[ARG:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG]], [[ARG]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg, %arg
  ret float %fdiv
}

define float @ret_fdiv_same_operands_nonan(float nofpclass(nan) %arg) #0 {
; CHECK-LABEL: define nofpclass(inf zero sub nnorm) float @ret_fdiv_same_operands_nonan
; CHECK-SAME: (float nofpclass(nan inf zero sub nnorm) [[ARG:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG]], [[ARG]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg, %arg
  ret float %fdiv
}

define float @ret_fdiv_no_neg_lhs(float nofpclass(ninf nsub nnorm) %arg0, float %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_no_neg_lhs
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[ARG0:%.*]], float [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_no_neg_rhs(float %arg0, float nofpclass(ninf nsub nnorm) %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_no_neg_rhs
; CHECK-SAME: (float [[ARG0:%.*]], float nofpclass(ninf nsub nnorm) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_no_neg_nzero_rhs(float %arg0, float nofpclass(ninf nsub nnorm nzero) %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_no_neg_nzero_rhs
; CHECK-SAME: (float [[ARG0:%.*]], float nofpclass(ninf nzero nsub nnorm) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_no_neg(float nofpclass(ninf nsub nnorm) %arg0, float nofpclass(ninf nsub nnorm) %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_no_neg
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[ARG0:%.*]], float nofpclass(ninf nsub nnorm) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_no_neg_nzero(float nofpclass(ninf nsub nnorm nzero) %arg0, float nofpclass(ninf nsub nnorm nzero) %arg1) #0 {
; CHECK-LABEL: define nofpclass(ninf nzero nsub nnorm) float @ret_fdiv_no_neg_nzero
; CHECK-SAME: (float nofpclass(ninf nzero nsub nnorm) [[ARG0:%.*]], float nofpclass(ninf nzero nsub nnorm) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_no_neg_rhs_no_nzero(float nofpclass(ninf nsub nnorm) %arg0, float nofpclass(ninf nsub nnorm nzero) %arg1) #0 {
; CHECK-LABEL: define float @ret_fdiv_no_neg_rhs_no_nzero
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[ARG0:%.*]], float nofpclass(ninf nzero nsub nnorm) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

define float @ret_fdiv_no_neg_no_zero_rhs(float nofpclass(ninf nsub nnorm nzero) %arg0, float nofpclass(ninf nsub nnorm zero) %arg1) #0 {
; CHECK-LABEL: define nofpclass(ninf nzero nsub nnorm) float @ret_fdiv_no_neg_no_zero_rhs
; CHECK-SAME: (float nofpclass(ninf nzero nsub nnorm) [[ARG0:%.*]], float nofpclass(ninf zero nsub nnorm) [[ARG1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[FDIV:%.*]] = fdiv float [[ARG0]], [[ARG1]]
; CHECK-NEXT:    ret float [[FDIV]]
;
  %fdiv = fdiv float %arg0, %arg1
  ret float %fdiv
}

attributes #0 = { "denormal-fp-math"="ieee,ieee" }
attributes #1 = { "denormal-fp-math"="ieee,preserve-sign" }
attributes #2 = { "denormal-fp-math"="ieee,positive-zero" }
attributes #3 = { "denormal-fp-math"="ieee,dynamic" }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; TUNIT: {{.*}}
