//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// Test that the exception object is passed correctly from the personality
// to the landing pad even when there are wrappers around runtime function
// __xlc_exception_handle. This test is only for the legacy AIX xlclang
// compiler generated code. The test source consists of two C++ source files
// t1.cpp and t2.cpp which are compiled into assembly code by the legacy AIX
// xlclang++ compiler included in this file. This file tests for the 64-bit
// mode.

# REQUIRES: target=powerpc64-ibm-aix
# UNSUPPORTED: no-exceptions

// RUN: %{cxx} -c %s -o %t1_64.o -DT1_CPP_CODE %{flags} %{compile_flags}
// RUN: %{cxx} -c %s -o %t2_64.o -DT2_CPP_CODE %{flags} %{compile_flags}
// RUN: %{cxx} -o %t_64.exe %t1_64.o %t2_64.o %{flags} %{link_flags}
// RUN: %{exec} %t_64.exe

#if defined(T1_CPP_CODE)
#
# This portion of assembly code is generated by IBM legacy xlclang++ compiler
# from the following C++ source file for 64-bit mode.
#
# t.cpp:
#
#extern "C" int printf(const char *, ...);
#
#extern "C" unsigned int * __xlc_exception_handle() __attribute__((weak, alias("wrap__xlc_exception_handle")));
#
#void barf() __attribute__((noinline));
#
#int main(void) {
#   try {
#      barf();
#   } catch(int) {
#      printf("caught int\n");
#   }
#   return 0;
#}
#
#void barf() { throw 42; }

.set r0,0; .set SP,1; .set RTOC,2; .set r3,3; .set r4,4
.set r5,5; .set r6,6; .set r7,7; .set r8,8; .set r9,9
.set r10,10; .set r11,11; .set r12,12; .set r13,13; .set r14,14
.set r15,15; .set r16,16; .set r17,17; .set r18,18; .set r19,19
.set r20,20; .set r21,21; .set r22,22; .set r23,23; .set r24,24
.set r25,25; .set r26,26; .set r27,27; .set r28,28; .set r29,29
.set r30,30; .set r31,31
.set fp0,0; .set fp1,1; .set fp2,2; .set fp3,3; .set fp4,4
.set fp5,5; .set fp6,6; .set fp7,7; .set fp8,8; .set fp9,9
.set fp10,10; .set fp11,11; .set fp12,12; .set fp13,13; .set fp14,14
.set fp15,15; .set fp16,16; .set fp17,17; .set fp18,18; .set fp19,19
.set fp20,20; .set fp21,21; .set fp22,22; .set fp23,23; .set fp24,24
.set fp25,25; .set fp26,26; .set fp27,27; .set fp28,28; .set fp29,29
.set fp30,30; .set fp31,31
.set v0,0; .set v1,1; .set v2,2; .set v3,3; .set v4,4
.set v5,5; .set v6,6; .set v7,7; .set v8,8; .set v9,9
.set v10,10; .set v11,11; .set v12,12; .set v13,13; .set v14,14
.set v15,15; .set v16,16; .set v17,17; .set v18,18; .set v19,19
.set v20,20; .set v21,21; .set v22,22; .set v23,23; .set v24,24
.set v25,25; .set v26,26; .set v27,27; .set v28,28; .set v29,29
.set v30,30; .set v31,31
.set x0,0; .set x1,1; .set x2,2; .set x3,3; .set x4,4
.set x5,5; .set x6,6; .set x7,7; .set x8,8; .set x9,9
.set x10,10; .set x11,11; .set x12,12; .set x13,13; .set x14,14
.set x15,15; .set x16,16; .set x17,17; .set x18,18; .set x19,19
.set x20,20; .set x21,21; .set x22,22; .set x23,23; .set x24,24
.set x25,25; .set x26,26; .set x27,27; .set x28,28; .set x29,29
.set x30,30; .set x31,31; .set x32,32; .set x33,33; .set x34,34
.set x35,35; .set x36,36; .set x37,37; .set x38,38; .set x39,39
.set x40,40; .set x41,41; .set x42,42; .set x43,43; .set x44,44
.set x45,45; .set x46,46; .set x47,47; .set x48,48; .set x49,49
.set x50,50; .set x51,51; .set x52,52; .set x53,53; .set x54,54
.set x55,55; .set x56,56; .set x57,57; .set x58,58; .set x59,59
.set x60,60; .set x61,61; .set x62,62; .set x63,63
.set q0,0; .set q1,1; .set q2,2; .set q3,3; .set q4,4
.set q5,5; .set q6,6; .set q7,7; .set q8,8; .set q9,9
.set q10,10; .set q11,11; .set q12,12; .set q13,13; .set q14,14
.set q15,15; .set q16,16; .set q17,17; .set q18,18; .set q19,19
.set q20,20; .set q21,21; .set q22,22; .set q23,23; .set q24,24
.set q25,25; .set q26,26; .set q27,27; .set q28,28; .set q29,29
.set q30,30; .set q31,31
.set MQ,0; .set XER,1; .set DSCR,3; .set FROM_RTCU,4; .set FROM_RTCL,5
.set FROM_DEC,6; .set LR,8; .set CTR,9; .set AMR,13; .set TID,17; .set DSISR,18
.set DAR,19; .set TO_RTCU,20; .set TO_RTCL,21; .set TO_DEC,22; .set SDR_0,24
.set SDR_1,25; .set SRR_0,26; .set SRR_1,27
.set BO_dCTR_NZERO_AND_NOT,0; .set BO_dCTR_NZERO_AND_NOT_1,1
.set BO_dCTR_ZERO_AND_NOT,2; .set BO_dCTR_ZERO_AND_NOT_1,3
.set BO_IF_NOT,4; .set BO_IF_NOT_1,5; .set BO_IF_NOT_2,6
.set BO_IF_NOT_3,7; .set BO_dCTR_NZERO_AND,8; .set BO_dCTR_NZERO_AND_1,9
.set BO_dCTR_ZERO_AND,10; .set BO_dCTR_ZERO_AND_1,11; .set BO_IF,12
.set BO_IF_1,13; .set BO_IF_2,14; .set BO_IF_3,15; .set BO_dCTR_NZERO,16
.set BO_dCTR_NZERO_1,17; .set BO_dCTR_ZERO,18; .set BO_dCTR_ZERO_1,19
.set BO_ALWAYS,20; .set BO_ALWAYS_1,21; .set BO_ALWAYS_2,22
.set BO_ALWAYS_3,23; .set BO_dCTR_NZERO_8,24; .set BO_dCTR_NZERO_9,25
.set BO_dCTR_ZERO_8,26; .set BO_dCTR_ZERO_9,27; .set BO_ALWAYS_8,28
.set BO_ALWAYS_9,29; .set BO_ALWAYS_10,30; .set BO_ALWAYS_11,31
.set CR0_LT,0; .set CR0_GT,1; .set CR0_EQ,2; .set CR0_SO,3
.set CR1_FX,4; .set CR1_FEX,5; .set CR1_VX,6; .set CR1_OX,7
.set CR2_LT,8; .set CR2_GT,9; .set CR2_EQ,10; .set CR2_SO,11
.set CR3_LT,12; .set CR3_GT,13; .set CR3_EQ,14; .set CR3_SO,15
.set CR4_LT,16; .set CR4_GT,17; .set CR4_EQ,18; .set CR4_SO,19
.set CR5_LT,20; .set CR5_GT,21; .set CR5_EQ,22; .set CR5_SO,23
.set CR6_LT,24; .set CR6_GT,25; .set CR6_EQ,26; .set CR6_SO,27
.set CR7_LT,28; .set CR7_GT,29; .set CR7_EQ,30; .set CR7_SO,31
.set TO_LT,16; .set TO_GT,8; .set TO_EQ,4; .set TO_LLT,2; .set TO_LGT,1

	.rename	H.4.NO_SYMBOL{PR},""
	.rename	H.10..__4,".__4"
	.rename	H.12..__8,".__8"
	.rename	H.14..__3,".__3"
	.rename	H.18.NO_SYMBOL{TC},""
	.rename	H.20.NO_SYMBOL{RO},""
	.rename	E.22.__STATIC{RW},"_$STATIC"
	.rename	H.24.__STATIC{TC},"_$STATIC"
	.rename	H.28.__4{TC},"__4"
	.rename	H.32.__8{TC},"__8"
	.rename	H.36.__3{TC},"__3"
	.rename	H.40._Z4barfv{TC},"_Z4barfv"
	.rename	H.44._ZTIi{TC},"_ZTIi"
	.rename	H.48.main{TC},"main"

	.lglobl	H.4.NO_SYMBOL{PR}
	.globl	._Z4barfv
	.globl	.main
	.lglobl	H.10..__4
	.lglobl	H.12..__8
	.lglobl	H.14..__3
	.lglobl	H.20.NO_SYMBOL{RO}
	.lglobl	E.22.__STATIC{RW}
	.lglobl	__4{DS}
	.lglobl	__8{DS}
	.lglobl	__3{DS}
	.globl	_Z4barfv{DS}
	.extern	_ZTIi{UA}
	.globl	main{DS}
	.extern	.__cxa_allocate_exception{PR}
	.extern	.__cxa_throw{PR}
	.extern	.wrap__xlc_exception_handle{PR}
	.extern	.__xlc_catch_matchv2{PR}
	.extern	.__cxa_begin_catch{PR}
	.extern	.printf{PR}
	.extern	.__cxa_end_catch{PR}
	.extern	._Unwind_Resume{PR}
	.extern	.__cxa_rethrow{PR}
	.extern	._ZSt9terminatev{PR}


# .text section
	.file	"t.cpp","Mon Jan 30 13:42:03 2023 ","IBM XL C/C++ for AIX, Version 16.1.0.13"
	.machine	"ppc64"


	.csect	H.4.NO_SYMBOL{PR}, 7
._Z4barfv:                              # 0x0000000000000000 (H.4.NO_SYMBOL)
	mfspr      r0,LR
	stdu       SP,-128(SP)
	std        r0,144(SP)
	addi       r3,r0,4
	bl         .__cxa_allocate_exception{PR}
	ori        r0,r0,0x0000
	ori        r4,r3,0x0000
	std        r4,112(SP)
	addi       r3,r0,42
	stw        r3,0(r4)
	ld         r3,112(SP)
	ld         r4,T.44._ZTIi(RTOC)
	addi       r5,r0,0
	bl         .__cxa_throw{PR}
	ori        r0,r0,0x0000
	ld         r0,144(SP)
	mtspr      LR,r0
	addi       SP,SP,128
	bclr       BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x20			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=0,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x41			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=0,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=1
	.byte	0x80			# STORES_BC=1,FPR_SAVED=0
	.byte	0x00			# GPR_SAVED=0
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x0000004c		# TB_OFFSET
	.short	8			# NAME_LEN
	.byte	"_Z4barfv"              # NAME

	.byte	0			# padding
	.byte	0			# padding
# End of traceback table
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
.main:                                  # 0x0000000000000080 (H.4.NO_SYMBOL+0x080)
	mfspr      r0,LR
	std        r31,-8(SP)
	std        r30,-16(SP)
	std        r29,-24(SP)
	std        r0,16(SP)
	stdu       SP,-208(SP)
	ori        r30,SP,0x0000
	ld         r31,T.24.__STATIC(RTOC)
	ld         r29,T.18.NO_SYMBOL(RTOC)
	addi       r3,r0,0
	stw        r3,112(r30)
	ori        r4,r31,0x0000
	std        r4,120(r30)
	std        r3,128(r30)
	stw        r3,136(r30)
	addi       r3,r0,1
	stb        r3,115(r30)
	bl         ._Z4barfv
	addi       r3,r0,0
	stb        r3,115(r30)
	b          __L188
__Ld4:                                  # 0x00000000000000d4 (H.4.NO_SYMBOL+0x0d4)
	ld         r31,T.24.__STATIC(RTOC)
	ld         r29,T.18.NO_SYMBOL(RTOC)
	addi       r3,r0,2
	stb        r3,115(r30)
	bl         .wrap__xlc_exception_handle{PR}
	ori        r0,r0,0x0000
	std        r3,144(r30)
	ld         r4,T.44._ZTIi(RTOC)
	addi       r5,r30,152
	bl         .__xlc_catch_matchv2{PR}
	ori        r0,r0,0x0000
	cmpli      0,0,r3,0x0000
	bc         BO_IF_NOT,CR0_EQ,__L10c
	b          __L164
__L10c:                                 # 0x000000000000010c (H.4.NO_SYMBOL+0x010c)
	ld         r3,144(r30)
	bl         .__cxa_begin_catch{PR}
	ori        r0,r0,0x0000
	ori        r3,r29,0x0000
	bl         .printf{PR}
	ori        r0,r0,0x0000
	bl         .__cxa_end_catch{PR}
	ori        r0,r0,0x0000
	addi       r3,r0,0
	stb        r3,115(r30)
	b          __L188
__L138:                                 # 0x0000000000000138 (H.4.NO_SYMBOL+0x0138)
	ld         r31,T.24.__STATIC(RTOC)
	ld         r29,T.18.NO_SYMBOL(RTOC)
	bl         .__cxa_end_catch{PR}
	ori        r0,r0,0x0000
	addi       r3,r0,0
	stb        r3,115(r30)
	bl         .wrap__xlc_exception_handle{PR}
	ori        r0,r0,0x0000
	std        r3,160(r30)
	bl         ._Unwind_Resume{PR}
	ori        r0,r0,0x0000
__L164:                                 # 0x0000000000000164 (H.4.NO_SYMBOL+0x0164)
	addi       r3,r0,2
	stb        r3,115(r30)
	bl         .wrap__xlc_exception_handle{PR}
	ori        r0,r0,0x0000
	std        r3,168(r30)
	bl         .__cxa_begin_catch{PR}
	ori        r0,r0,0x0000
	bl         .__cxa_rethrow{PR}
	ori        r0,r0,0x0000
__L188:                                 # 0x0000000000000188 (H.4.NO_SYMBOL+0x0188)
	addi       r3,r0,0
	b          __L1b8
__L190:                                 # 0x0000000000000190 (H.4.NO_SYMBOL+0x0190)
	bl         .wrap__xlc_exception_handle{PR}
	ori        r0,r0,0x0000
	std        r3,176(r30)
	bl         ._Unwind_Resume{PR}
	ori        r0,r0,0x0000
__L1a4:                                 # 0x00000000000001a4 (H.4.NO_SYMBOL+0x01a4)
	ld         r31,T.24.__STATIC(RTOC)
	ld         r29,T.18.NO_SYMBOL(RTOC)
	bl         ._ZSt9terminatev{PR}
	ori        r0,r0,0x0000
	b          __L190
__L1b8:                                 # 0x00000000000001b8 (H.4.NO_SYMBOL+0x01b8)
	ld         SP,0(SP)
	ld         r29,-24(SP)
	ld         r30,-16(SP)
	ld         r31,-8(SP)
	ld         r0,16(SP)
	mtspr      LR,r0
	bclr       BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x28			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=1,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x61			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=1,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=1
	.byte	0x80			# STORES_BC=1,FPR_SAVED=0
	.byte	0x03			# GPR_SAVED=3
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x00000154		# TB_OFFSET
	.long	0x00000001		# NUM_CTL_INFO
	.long	0x00000070		# ctl_info_disp[0]
	.short	4			# NAME_LEN
	.byte	"main"                  # NAME

	.byte	30			# ALLOCA_REG
	.byte	0			# padding
# End of traceback table
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
H.10..__4:                              # 0x0000000000000200 (H.4.NO_SYMBOL+0x0200)
	b          __L1a4
	bclr       BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x20			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=0,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x40			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=0,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=0
	.byte	0x00			# STORES_BC=0,FPR_SAVED=0
	.byte	0x00			# GPR_SAVED=0
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x00000008		# TB_OFFSET
	.short	3			# NAME_LEN
	.byte	"__4"                   # NAME

	.byte	0			# padding
	.byte	0			# padding
	.byte	0			# padding
# End of traceback table
H.12..__8:                              # 0x0000000000000220 (H.4.NO_SYMBOL+0x0220)
	b          __L138
	bclr       BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x20			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=0,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x40			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=0,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=0
	.byte	0x00			# STORES_BC=0,FPR_SAVED=0
	.byte	0x00			# GPR_SAVED=0
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x00000008		# TB_OFFSET
	.short	3			# NAME_LEN
	.byte	"__8"                   # NAME

	.byte	0			# padding
	.byte	0			# padding
	.byte	0			# padding
# End of traceback table
H.14..__3:                              # 0x0000000000000240 (H.4.NO_SYMBOL+0x0240)
	b          __Ld4
	bclr       BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x20			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=0,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x40			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=0,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=0
	.byte	0x00			# STORES_BC=0,FPR_SAVED=0
	.byte	0x00			# GPR_SAVED=0
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x00000008		# TB_OFFSET
	.short	3			# NAME_LEN
	.byte	"__3"                   # NAME

	.byte	0			# padding
	.byte	0			# padding
	.byte	0			# padding
# End of traceback table
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	H.4.NO_SYMBOL{PR}

# .data section


	.toc	                        # 0x0000000000000280
T.40._Z4barfv:
	.tc	H.40._Z4barfv{TC},_Z4barfv{DS}
T.44._ZTIi:
	.tc	H.44._ZTIi{TC},_ZTIi{UA}
T.48.main:
	.tc	H.48.main{TC},main{DS}
T.24.__STATIC:
	.tc	H.24.__STATIC{TC},E.22.__STATIC{RW}
T.18.NO_SYMBOL:
	.tc	H.18.NO_SYMBOL{TC},H.20.NO_SYMBOL{RO}
T.28.__4:
	.tc	H.28.__4{TC},__4{DS}
T.32.__8:
	.tc	H.32.__8{TC},__8{DS}
T.36.__3:
	.tc	H.36.__3{TC},__3{DS}


	.csect	_Z4barfv{DS}, 3
	.llong	._Z4barfv               # "\0\0\0\0\0\0\0\0"
	.llong	TOC{TC0}                # "\0\0\0\0\0\0\002\200"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	_Z4barfv{DS}


	.csect	main{DS}, 3
	.llong	.main                   # "\0\0\0\0\0\0\0\200"
	.llong	TOC{TC0}                # "\0\0\0\0\0\0\002\200"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	main{DS}


	.csect	__4{DS}, 3
	.llong	H.10..__4               # "\0\0\0\0\0\0\002\0"
	.llong	TOC{TC0}                # "\0\0\0\0\0\0\002\200"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	__4{DS}


	.csect	__8{DS}, 3
	.llong	H.12..__8               # "\0\0\0\0\0\0\002 "
	.llong	TOC{TC0}                # "\0\0\0\0\0\0\002\200"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	__8{DS}


	.csect	__3{DS}, 3
	.llong	H.14..__3               # "\0\0\0\0\0\0\002@"
	.llong	TOC{TC0}                # "\0\0\0\0\0\0\002\200"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	__3{DS}


	.csect	E.22.__STATIC{RW}, 3
	.long	0x1cedbeef              # "\034\355\276\357"
	.long	0x00000003              # "\0\0\0\003"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.llong	__3{DS}                 # "\0\0\0\0\0\0\003 "
	.long	0xffffffff              # "\377\377\377\377"
	.long	0xffffffff              # "\377\377\377\377"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.llong	__8{DS}                 # "\0\0\0\0\0\0\003\b"
	.long	0xffffffff              # "\377\377\377\377"
	.long	0xfffffffe              # "\377\377\377\376"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.llong	__4{DS}                 # "\0\0\0\0\0\0\002\360"
	.long	0xffffffff              # "\377\377\377\377"
	.long	0xfffffffc              # "\377\377\377\374"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	E.22.__STATIC{RW}


	.csect	H.20.NO_SYMBOL{RO}, 3
	.long	0x63617567              # "caug"
	.long	0x68742069              # "ht i"
	.long	0x6e740a00              # "nt\n\0"
# End	csect	H.20.NO_SYMBOL{RO}
	.long	0x00000000              # "\0\0\0\0"



# .bss section


# dwarf sections

# end dwarf sections
#endif // defined(T1_CPP_CODE)

#if defined(T2_CPP_CODE)
#
# This portion of assembly code is generated by IBM legacy xlclang++ compiler
# from the following C++ source file for 64-bit mode.
#
# t2.cpp
#
#extern "C" int printf(const char *, ...);
#
#extern "C" unsigned int * __xlc_exception_handle();
#
#extern "C" unsigned int * wrap__xlc_exception_handle() {
#  printf("wrap__xlc_exception_handle called\n");
#  return __xlc_exception_handle();
#}
#
.set r0,0; .set SP,1; .set RTOC,2; .set r3,3; .set r4,4
.set r5,5; .set r6,6; .set r7,7; .set r8,8; .set r9,9
.set r10,10; .set r11,11; .set r12,12; .set r13,13; .set r14,14
.set r15,15; .set r16,16; .set r17,17; .set r18,18; .set r19,19
.set r20,20; .set r21,21; .set r22,22; .set r23,23; .set r24,24
.set r25,25; .set r26,26; .set r27,27; .set r28,28; .set r29,29
.set r30,30; .set r31,31
.set fp0,0; .set fp1,1; .set fp2,2; .set fp3,3; .set fp4,4
.set fp5,5; .set fp6,6; .set fp7,7; .set fp8,8; .set fp9,9
.set fp10,10; .set fp11,11; .set fp12,12; .set fp13,13; .set fp14,14
.set fp15,15; .set fp16,16; .set fp17,17; .set fp18,18; .set fp19,19
.set fp20,20; .set fp21,21; .set fp22,22; .set fp23,23; .set fp24,24
.set fp25,25; .set fp26,26; .set fp27,27; .set fp28,28; .set fp29,29
.set fp30,30; .set fp31,31
.set v0,0; .set v1,1; .set v2,2; .set v3,3; .set v4,4
.set v5,5; .set v6,6; .set v7,7; .set v8,8; .set v9,9
.set v10,10; .set v11,11; .set v12,12; .set v13,13; .set v14,14
.set v15,15; .set v16,16; .set v17,17; .set v18,18; .set v19,19
.set v20,20; .set v21,21; .set v22,22; .set v23,23; .set v24,24
.set v25,25; .set v26,26; .set v27,27; .set v28,28; .set v29,29
.set v30,30; .set v31,31
.set x0,0; .set x1,1; .set x2,2; .set x3,3; .set x4,4
.set x5,5; .set x6,6; .set x7,7; .set x8,8; .set x9,9
.set x10,10; .set x11,11; .set x12,12; .set x13,13; .set x14,14
.set x15,15; .set x16,16; .set x17,17; .set x18,18; .set x19,19
.set x20,20; .set x21,21; .set x22,22; .set x23,23; .set x24,24
.set x25,25; .set x26,26; .set x27,27; .set x28,28; .set x29,29
.set x30,30; .set x31,31; .set x32,32; .set x33,33; .set x34,34
.set x35,35; .set x36,36; .set x37,37; .set x38,38; .set x39,39
.set x40,40; .set x41,41; .set x42,42; .set x43,43; .set x44,44
.set x45,45; .set x46,46; .set x47,47; .set x48,48; .set x49,49
.set x50,50; .set x51,51; .set x52,52; .set x53,53; .set x54,54
.set x55,55; .set x56,56; .set x57,57; .set x58,58; .set x59,59
.set x60,60; .set x61,61; .set x62,62; .set x63,63
.set q0,0; .set q1,1; .set q2,2; .set q3,3; .set q4,4
.set q5,5; .set q6,6; .set q7,7; .set q8,8; .set q9,9
.set q10,10; .set q11,11; .set q12,12; .set q13,13; .set q14,14
.set q15,15; .set q16,16; .set q17,17; .set q18,18; .set q19,19
.set q20,20; .set q21,21; .set q22,22; .set q23,23; .set q24,24
.set q25,25; .set q26,26; .set q27,27; .set q28,28; .set q29,29
.set q30,30; .set q31,31
.set MQ,0; .set XER,1; .set DSCR,3; .set FROM_RTCU,4; .set FROM_RTCL,5
.set FROM_DEC,6; .set LR,8; .set CTR,9; .set AMR,13; .set TID,17; .set DSISR,18
.set DAR,19; .set TO_RTCU,20; .set TO_RTCL,21; .set TO_DEC,22; .set SDR_0,24
.set SDR_1,25; .set SRR_0,26; .set SRR_1,27
.set BO_dCTR_NZERO_AND_NOT,0; .set BO_dCTR_NZERO_AND_NOT_1,1
.set BO_dCTR_ZERO_AND_NOT,2; .set BO_dCTR_ZERO_AND_NOT_1,3
.set BO_IF_NOT,4; .set BO_IF_NOT_1,5; .set BO_IF_NOT_2,6
.set BO_IF_NOT_3,7; .set BO_dCTR_NZERO_AND,8; .set BO_dCTR_NZERO_AND_1,9
.set BO_dCTR_ZERO_AND,10; .set BO_dCTR_ZERO_AND_1,11; .set BO_IF,12
.set BO_IF_1,13; .set BO_IF_2,14; .set BO_IF_3,15; .set BO_dCTR_NZERO,16
.set BO_dCTR_NZERO_1,17; .set BO_dCTR_ZERO,18; .set BO_dCTR_ZERO_1,19
.set BO_ALWAYS,20; .set BO_ALWAYS_1,21; .set BO_ALWAYS_2,22
.set BO_ALWAYS_3,23; .set BO_dCTR_NZERO_8,24; .set BO_dCTR_NZERO_9,25
.set BO_dCTR_ZERO_8,26; .set BO_dCTR_ZERO_9,27; .set BO_ALWAYS_8,28
.set BO_ALWAYS_9,29; .set BO_ALWAYS_10,30; .set BO_ALWAYS_11,31
.set CR0_LT,0; .set CR0_GT,1; .set CR0_EQ,2; .set CR0_SO,3
.set CR1_FX,4; .set CR1_FEX,5; .set CR1_VX,6; .set CR1_OX,7
.set CR2_LT,8; .set CR2_GT,9; .set CR2_EQ,10; .set CR2_SO,11
.set CR3_LT,12; .set CR3_GT,13; .set CR3_EQ,14; .set CR3_SO,15
.set CR4_LT,16; .set CR4_GT,17; .set CR4_EQ,18; .set CR4_SO,19
.set CR5_LT,20; .set CR5_GT,21; .set CR5_EQ,22; .set CR5_SO,23
.set CR6_LT,24; .set CR6_GT,25; .set CR6_EQ,26; .set CR6_SO,27
.set CR7_LT,28; .set CR7_GT,29; .set CR7_EQ,30; .set CR7_SO,31
.set TO_LT,16; .set TO_GT,8; .set TO_EQ,4; .set TO_LLT,2; .set TO_LGT,1

	.rename	H.4.NO_SYMBOL{PR},""
	.rename	H.10.NO_SYMBOL{TC},""
	.rename	H.12.NO_SYMBOL{RO},""
	.rename	H.16.wrap__xlc_exception_handle{TC},"wrap__xlc_exception_handle"

	.lglobl	H.4.NO_SYMBOL{PR}
	.globl	.wrap__xlc_exception_handle
	.lglobl	H.12.NO_SYMBOL{RO}
	.globl	wrap__xlc_exception_handle{DS}
	.extern	.printf{PR}
	.extern	.__xlc_exception_handle{PR}


# .text section
	.file	"t2.cpp","Mon Jan 30 13:41:54 2023 ","IBM XL C/C++ for AIX, Version 16.1.0.13"
	.machine	"ppc64"


	.csect	H.4.NO_SYMBOL{PR}, 7
.wrap__xlc_exception_handle:            # 0x0000000000000000 (H.4.NO_SYMBOL)
	mfspr      r0,LR
	std        r31,-8(SP)
	std        r0,16(SP)
	stdu       SP,-128(SP)
	ld         r31,T.10.NO_SYMBOL(RTOC)
	ori        r3,r31,0x0000
	bl         .printf{PR}
	ori        r0,r0,0x0000
	bl         .__xlc_exception_handle{PR}
	ori        r0,r0,0x0000
	ld         r0,144(SP)
	mtspr      LR,r0
	addi       SP,SP,128
	ld         r31,-8(SP)
	bclr       BO_ALWAYS,CR0_LT
	.long	0x00000000
# traceback table
	.byte	0x00			# VERSION=0
	.byte	0x09			# LANG=TB_CPLUSPLUS
	.byte	0x20			# IS_GL=0,IS_EPROL=0,HAS_TBOFF=1
					# INT_PROC=0,HAS_CTL=0,TOCLESS=0
					# FP_PRESENT=0,LOG_ABORT=0
	.byte	0x41			# INT_HNDL=0,NAME_PRESENT=1
					# USES_ALLOCA=0,CL_DIS_INV=WALK_ONCOND
					# SAVES_CR=0,SAVES_LR=1
	.byte	0x80			# STORES_BC=1,FPR_SAVED=0
	.byte	0x01			# GPR_SAVED=1
	.byte	0x00			# FIXEDPARMS=0
	.byte	0x01			# FLOATPARMS=0,PARMSONSTK=1
	.long	0x0000003c		# TB_OFFSET
	.short	26			# NAME_LEN
	.byte	"wrap__xlc_exception_handle" # NAME

# End of traceback table
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	H.4.NO_SYMBOL{PR}

# .data section


	.toc	                        # 0x0000000000000080
T.16.wrap__xlc_exception_handle:
	.tc	H.16.wrap__xlc_exception_handle{TC},wrap__xlc_exception_handle{DS}
T.10.NO_SYMBOL:
	.tc	H.10.NO_SYMBOL{TC},H.12.NO_SYMBOL{RO}


	.csect	wrap__xlc_exception_handle{DS}, 3
	.llong	.wrap__xlc_exception_handle# "\0\0\0\0\0\0\0\0"
	.llong	TOC{TC0}                # "\0\0\0\0\0\0\0\200"
	.long	0x00000000              # "\0\0\0\0"
	.long	0x00000000              # "\0\0\0\0"
# End	csect	wrap__xlc_exception_handle{DS}


	.csect	H.12.NO_SYMBOL{RO}, 3
	.long	0x77726170              # "wrap"
	.long	0x5f5f786c              # "__xl"
	.long	0x635f6578              # "c_ex"
	.long	0x63657074              # "cept"
	.long	0x696f6e5f              # "ion_"
	.long	0x68616e64              # "hand"
	.long	0x6c652063              # "le c"
	.long	0x616c6c65              # "alle"
# End	csect	H.12.NO_SYMBOL{RO}
	.long	0x640a0000              # "d\n\0\0"
	.long	0x00000000              # "\0\0\0\0"



# .bss section


# dwarf sections

# end dwarf sections

#endif // defined(T2_CPP_CODE)
