; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sme-fa64 -force-streaming-compatible-sve < %s | FileCheck %s -check-prefix=FA64
; RUN: llc -mattr=+sve -force-streaming-compatible-sve < %s | FileCheck %s -check-prefix=NO-FA64

target triple = "aarch64-unknown-linux-gnu"

define <8 x i8> @mla8xi8(<8 x i8> %A, <8 x i8> %B, <8 x i8> %C) {
; FA64-LABEL: mla8xi8:
; FA64:       // %bb.0:
; FA64-NEXT:    mla v2.8b, v0.8b, v1.8b
; FA64-NEXT:    fmov d0, d2
; FA64-NEXT:    ret
;
; NO-FA64-LABEL: mla8xi8:
; NO-FA64:       // %bb.0:
; NO-FA64-NEXT:    ptrue p0.b, vl8
; NO-FA64-NEXT:    // kill: def $d0 killed $d0 def $z0
; NO-FA64-NEXT:    // kill: def $d2 killed $d2 def $z2
; NO-FA64-NEXT:    // kill: def $d1 killed $d1 def $z1
; NO-FA64-NEXT:    mad z0.b, p0/m, z1.b, z2.b
; NO-FA64-NEXT:    // kill: def $d0 killed $d0 killed $z0
; NO-FA64-NEXT:    ret
  %tmp1 = mul <8 x i8> %A, %B;
  %tmp2 = add <8 x i8> %C, %tmp1;
  ret <8 x i8> %tmp2
}
