; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; Test kernel hwasan instrumentation for alloca.
;
; RUN: opt < %s -passes=hwasan -hwasan-kernel=1 -S | FileCheck %s

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"
target triple = "aarch64--linux-android"

declare void @use32(ptr)

define void @test_alloca() sanitize_hwaddress {
; CHECK-LABEL: define void @test_alloca
; CHECK-SAME: () #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DOTHWASAN_SHADOW:%.*]] = call ptr asm "", "=r,0"(ptr null)
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @llvm.frameaddress.p0(i32 0)
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[TMP0]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = lshr i64 [[TMP1]], 20
; CHECK-NEXT:    [[HWASAN_STACK_BASE_TAG:%.*]] = xor i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[HWASAN_UAR_TAG:%.*]] = lshr i64 [[TMP1]], 56
; CHECK-NEXT:    [[X:%.*]] = alloca { i32, [12 x i8] }, align 16
; CHECK-NEXT:    [[TMP3:%.*]] = xor i64 [[HWASAN_STACK_BASE_TAG]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[X]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = or i64 [[TMP4]], -72057594037927936
; CHECK-NEXT:    [[TMP6:%.*]] = shl i64 [[TMP3]], 56
; CHECK-NEXT:    [[TMP7:%.*]] = or i64 [[TMP6]], 72057594037927935
; CHECK-NEXT:    [[TMP8:%.*]] = and i64 [[TMP5]], [[TMP7]]
; CHECK-NEXT:    [[X_HWASAN:%.*]] = inttoptr i64 [[TMP8]] to ptr
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i64 [[TMP3]] to i8
; CHECK-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[X]] to i64
; CHECK-NEXT:    [[TMP11:%.*]] = or i64 [[TMP10]], -72057594037927936
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i64 [[TMP11]], 4
; CHECK-NEXT:    [[TMP13:%.*]] = inttoptr i64 [[TMP12]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP13]], i8 [[TMP9]], i64 1, i1 false)
; CHECK-NEXT:    call void @use32(ptr nonnull [[X_HWASAN]])
; CHECK-NEXT:    [[TMP14:%.*]] = trunc i64 [[HWASAN_UAR_TAG]] to i8
; CHECK-NEXT:    [[TMP15:%.*]] = ptrtoint ptr [[X]] to i64
; CHECK-NEXT:    [[TMP16:%.*]] = or i64 [[TMP15]], -72057594037927936
; CHECK-NEXT:    [[TMP17:%.*]] = lshr i64 [[TMP16]], 4
; CHECK-NEXT:    [[TMP18:%.*]] = inttoptr i64 [[TMP17]] to ptr
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP18]], i8 [[TMP14]], i64 1, i1 false)
; CHECK-NEXT:    ret void
;


entry:
  %x = alloca i32, align 4
  call void @use32(ptr nonnull %x)
  ret void
}
