; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=amdgcn-- -verify-machineinstrs < %s | FileCheck -check-prefixes=SI %s
; RUN: llc -mtriple=amdgcn-- -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefixes=VI %s
; RUN: llc -mtriple=amdgcn-- -mcpu=gfx1100 -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11 %s

define amdgpu_kernel void @extract_vector_elt_v2f16(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr) #0 {
; SI-LABEL: extract_vector_elt_v2f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s4, s[2:3], 0x0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshr_b32 s5, s4, 16
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_short v1, off, s[0:3], 0
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0 offset:20
; SI-NEXT:    s_endpgm
;
; VI-LABEL: extract_vector_elt_v2f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s4, s[2:3], 0x0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s5, s4, 16
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_short v1, off, s[0:3], 0
; VI-NEXT:    buffer_store_short v0, off, s[0:3], 0 offset:20
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: extract_vector_elt_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-NEXT:    s_mov_b32 s2, -1
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_d16_hi_b16 v0, v1, s[0:1]
; GFX11-NEXT:    buffer_store_b16 v1, off, s[0:3], 0 offset:20
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x half>, ptr addrspace(4) %vec.ptr
  %p0 = extractelement <2 x half> %vec, i32 0
  %p1 = extractelement <2 x half> %vec, i32 1
  %out1 = getelementptr half, ptr addrspace(1) %out, i32 10
  store half %p1, ptr addrspace(1) %out, align 2
  store half %p0, ptr addrspace(1) %out1, align 2
  ret void
}

define amdgpu_kernel void @extract_vector_elt_v2f16_dynamic_sgpr(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr, i32 %idx) #0 {
; SI-LABEL: extract_vector_elt_v2f16_dynamic_sgpr:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s0, s[0:1], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s1, s[6:7], 0x0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_lshl_b32 s0, s0, 4
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshr_b32 s0, s1, s0
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: extract_vector_elt_v2f16_dynamic_sgpr:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s8, s[0:1], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s6, s[6:7], 0x0
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_lshl_b32 s4, s8, 4
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s4, s6, s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: extract_vector_elt_v2f16_dynamic_sgpr:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s1, s[6:7], 0x0
; GFX11-NEXT:    s_lshl_b32 s0, s0, 4
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s0, s1, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x half>, ptr addrspace(4) %vec.ptr
  %elt = extractelement <2 x half> %vec, i32 %idx
  store half %elt, ptr addrspace(1) %out, align 2
  ret void
}

define amdgpu_kernel void @extract_vector_elt_v2f16_dynamic_vgpr(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr, ptr addrspace(1) %idx.ptr) #0 {
; SI-LABEL: extract_vector_elt_v2f16_dynamic_vgpr:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, 0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; SI-NEXT:    v_mov_b32_e32 v2, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    buffer_load_dword v3, v[1:2], s[0:3], 0 addr64
; SI-NEXT:    s_load_dword s6, s[6:7], 0x0
; SI-NEXT:    s_mov_b64 s[0:1], s[4:5]
; SI-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 4, v3
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_lshr_b32_e32 v0, s6, v0
; SI-NEXT:    buffer_store_short v0, v[1:2], s[0:3], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: extract_vector_elt_v2f16_dynamic_vgpr:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; VI-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; VI-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s3
; VI-NEXT:    v_add_u32_e32 v1, vcc, s2, v1
; VI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; VI-NEXT:    flat_load_dword v2, v[1:2]
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_load_dword s1, s[2:3], 0x0
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v2, 4, v2
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e64 v2, v2, s1
; VI-NEXT:    flat_store_short v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: extract_vector_elt_v2f16_dynamic_vgpr:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[2:3], s[0:1], 0x34
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v1, s[2:3]
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e64 v1, v1, s2
; GFX11-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds i32, ptr addrspace(1) %idx.ptr, i64 %tid.ext
  %out.gep = getelementptr inbounds half, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <2 x half>, ptr addrspace(4) %vec.ptr
  %idx = load i32, ptr addrspace(1) %gep
  %elt = extractelement <2 x half> %vec, i32 %idx
  store half %elt, ptr addrspace(1) %out.gep, align 2
  ret void
}

define amdgpu_kernel void @extract_vector_elt_v3f16(ptr addrspace(1) %out, <3 x half> %foo) #0 {
; SI-LABEL: extract_vector_elt_v3f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    v_mov_b32_e32 v0, s3
; SI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s2
; SI-NEXT:    buffer_store_short v0, off, s[4:7], 0 offset:2
; SI-NEXT:    s_endpgm
;
; VI-LABEL: extract_vector_elt_v3f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    buffer_store_short v0, off, s[4:7], 0 offset:2
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: extract_vector_elt_v3f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s3 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-NEXT:    buffer_store_b16 v1, off, s[4:7], 0 offset:2
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %p0 = extractelement <3 x half> %foo, i32 0
  %p1 = extractelement <3 x half> %foo, i32 2
  %out1 = getelementptr half, ptr addrspace(1) %out, i32 1
  store half %p1, ptr addrspace(1) %out, align 2
  store half %p0, ptr addrspace(1) %out1, align 2
  ret void
}

; FIXME: Why sometimes vector shift?
define amdgpu_kernel void @dynamic_extract_vector_elt_v3f16(ptr addrspace(1) %out, <3 x half> %foo, i32 %idx) #0 {
; SI-LABEL: dynamic_extract_vector_elt_v3f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s4, s[0:1], 0xd
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshl_b32 s4, s4, 4
; SI-NEXT:    s_lshr_b64 s[2:3], s[2:3], s4
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    v_mov_b32_e32 v0, s2
; SI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: dynamic_extract_vector_elt_v3f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s8, s[0:1], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_lshl_b32 s4, s8, 4
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    s_lshr_b64 s[4:5], s[6:7], s4
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: dynamic_extract_vector_elt_v3f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s4, s[0:1], 0x34
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshl_b32 s4, s4, 4
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_lshr_b64 s[2:3], s[2:3], s4
; GFX11-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    s_mov_b32 s2, -1
; GFX11-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %p0 = extractelement <3 x half> %foo, i32 %idx
  %out1 = getelementptr half, ptr addrspace(1) %out, i32 1
  store half %p0, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_extractelement_v4f16_2(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-LABEL: v_extractelement_v4f16_2:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    v_mov_b32_e32 v2, 0
; SI-NEXT:    s_mov_b64 s[10:11], s[6:7]
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[8:9], s[2:3]
; SI-NEXT:    buffer_load_dword v3, v[1:2], s[8:11], 0 addr64 offset:4
; SI-NEXT:    s_mov_b64 s[4:5], s[0:1]
; SI-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_short v3, v[1:2], s[4:7], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_extractelement_v4f16_2:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; VI-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s3
; VI-NEXT:    v_add_u32_e32 v1, vcc, s2, v1
; VI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; VI-NEXT:    v_add_u32_e32 v1, vcc, 4, v1
; VI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; VI-NEXT:    flat_load_dword v2, v[1:2]
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    flat_store_short v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_extractelement_v4f16_2:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v1, s[2:3] offset:4
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds half, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <4 x half>, ptr addrspace(1) %in.gep
  %vec.extract = extractelement <4 x half> %vec, i32 2
  store half %vec.extract, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v4f16_dynamic_vgpr(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-LABEL: v_insertelement_v4f16_dynamic_vgpr:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; SI-NEXT:    v_mov_b32_e32 v2, 0
; SI-NEXT:    s_mov_b32 s10, -1
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    buffer_load_dword v5, off, s[8:11], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-NEXT:    buffer_load_dwordx2 v[3:4], v[1:2], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 4, v5
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshr_b64 v[3:4], v[3:4], v0
; SI-NEXT:    buffer_store_short v3, v[1:2], s[0:3], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v4f16_dynamic_vgpr:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; VI-NEXT:    v_lshlrev_b32_e32 v4, 1, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s3
; VI-NEXT:    v_add_u32_e32 v1, vcc, s2, v1
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; VI-NEXT:    buffer_load_dword v3, off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    flat_load_dwordx2 v[1:2], v[1:2]
; VI-NEXT:    v_mov_b32_e32 v5, s1
; VI-NEXT:    v_lshlrev_b32_e32 v0, 4, v3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshrrev_b64 v[0:1], v0, v[1:2]
; VI-NEXT:    v_add_u32_e32 v1, vcc, s0, v4
; VI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v5, vcc
; VI-NEXT:    flat_store_short v[1:2], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v4f16_dynamic_vgpr:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; GFX11-NEXT:    buffer_load_b32 v3, off, s[4:7], 0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[1:2], v1, s[2:3]
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 4, v3
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b64 v[1:2], v3, v[1:2]
; GFX11-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds half, ptr addrspace(1) %out, i64 %tid.ext
  %idx.val = load volatile i32, ptr addrspace(1) undef
  %vec = load <4 x half>, ptr addrspace(1) %in.gep
  %vec.extract = extractelement <4 x half> %vec, i32 %idx.val
  store half %vec.extract, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @reduce_load_vector_v8f16_extract_01(ptr addrspace(4) %ptr) #0 {
; SI-LABEL: reduce_load_vector_v8f16_extract_01:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s0, s[0:1], 0x0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshr_b32 s1, s0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s1
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_endpgm
;
; VI-LABEL: reduce_load_vector_v8f16_extract_01:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s0, s[0:1], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s1, s0, 16
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s1
; VI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: reduce_load_vector_v8f16_extract_01:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-NEXT:    s_mov_b32 s2, -1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s0, s[0:1], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s1, s0, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    buffer_store_b16 v0, off, s[0:3], 0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_store_b16 v1, off, s[0:3], 0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %load = load <16 x half>, ptr addrspace(4) %ptr
  %elt0 = extractelement <16 x half> %load, i32 0
  %elt1 = extractelement <16 x half> %load, i32 1
  store volatile half %elt0, ptr addrspace(1) undef, align 2
  store volatile half %elt1, ptr addrspace(1) undef, align 2
  ret void
}

define amdgpu_kernel void @reduce_load_vector_v8f16_extract_23(ptr addrspace(4) %ptr) #0 {
; SI-LABEL: reduce_load_vector_v8f16_extract_23:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dword s0, s[0:1], 0x1
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_lshr_b32 s1, s0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s1
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_endpgm
;
; VI-LABEL: reduce_load_vector_v8f16_extract_23:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s0, s[0:1], 0x4
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s1, s0, 16
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s1
; VI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: reduce_load_vector_v8f16_extract_23:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-NEXT:    s_mov_b32 s2, -1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s0, s[0:1], 0x4
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s1, s0, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    buffer_store_b16 v0, off, s[0:3], 0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_store_b16 v1, off, s[0:3], 0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %load = load <16 x half>, ptr addrspace(4) %ptr
  %elt2 = extractelement <16 x half> %load, i32 2
  %elt3 = extractelement <16 x half> %load, i32 3
  store volatile half %elt2, ptr addrspace(1) undef, align 2
  store volatile half %elt3, ptr addrspace(1) undef, align 2
  ret void
}

define amdgpu_kernel void @v_extractelement_v8f16_dynamic_sgpr(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %n) #0 {
; SI-LABEL: v_extractelement_v8f16_dynamic_sgpr:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s8, s[0:1], 0xd
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, 0
; SI-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; SI-NEXT:    v_mov_b32_e32 v5, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[0:1], s[6:7]
; SI-NEXT:    buffer_load_dwordx4 v[1:4], v[4:5], s[0:3], 0 addr64
; SI-NEXT:    v_lshlrev_b32_e32 v6, 1, v0
; SI-NEXT:    v_mov_b32_e32 v7, v5
; SI-NEXT:    s_mov_b64 s[6:7], s[2:3]
; SI-NEXT:    s_cmp_eq_u32 s8, 1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v1
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v2
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v3
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v4
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 3
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v5, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 4
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 5
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 6
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 7
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v9, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    buffer_store_short v0, v[6:7], s[4:7], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_extractelement_v8f16_dynamic_sgpr:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s0, s[0:1], 0x34
; VI-NEXT:    v_lshlrev_b32_e32 v1, 4, v0
; VI-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    v_add_u32_e32 v1, vcc, s6, v1
; VI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; VI-NEXT:    flat_load_dwordx4 v[1:4], v[1:2]
; VI-NEXT:    v_mov_b32_e32 v6, s5
; VI-NEXT:    v_add_u32_e32 v5, vcc, s4, v0
; VI-NEXT:    s_cmp_eq_u32 s0, 1
; VI-NEXT:    v_addc_u32_e32 v6, vcc, 0, v6, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 3
; VI-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 4
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v7, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 5
; VI-NEXT:    v_lshrrev_b32_e32 v8, 16, v3
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 6
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 7
; VI-NEXT:    v_lshrrev_b32_e32 v9, 16, v4
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v9, vcc
; VI-NEXT:    flat_store_short v[5:6], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_extractelement_v8f16_dynamic_sgpr:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 4, v0
; GFX11-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b128 v[1:4], v1, s[6:7]
; GFX11-NEXT:    s_cmp_eq_u32 s0, 1
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s0, 2
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-NEXT:    s_cmp_eq_u32 s0, 3
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s0, 4
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s0, 5
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s0, 6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v4
; GFX11-NEXT:    s_cmp_eq_u32 s0, 7
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-NEXT:    global_store_b16 v0, v1, s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <8 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds half, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <8 x half>, ptr addrspace(1) %in.gep
  %vec.extract = extractelement <8 x half> %vec, i32 %n
  store half %vec.extract, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_extractelement_v16f16_dynamic_sgpr(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %n) #0 {
; SI-LABEL: v_extractelement_v16f16_dynamic_sgpr:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; SI-NEXT:    s_load_dword s8, s[0:1], 0xd
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, 0
; SI-NEXT:    v_lshlrev_b32_e32 v5, 5, v0
; SI-NEXT:    v_mov_b32_e32 v6, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[0:1], s[6:7]
; SI-NEXT:    buffer_load_dwordx4 v[1:4], v[5:6], s[0:3], 0 addr64
; SI-NEXT:    v_lshlrev_b32_e32 v9, 1, v0
; SI-NEXT:    v_mov_b32_e32 v10, v6
; SI-NEXT:    s_mov_b64 s[6:7], s[2:3]
; SI-NEXT:    buffer_load_dwordx4 v[5:8], v[5:6], s[0:3], 0 addr64 offset:16
; SI-NEXT:    s_cmp_eq_u32 s8, 1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v1
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v2
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v3
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v4
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v5
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v6
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v8
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 3
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v11, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 4
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 5
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v12, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 6
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 7
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v13, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 8
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 9
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v14, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 10
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v5, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 11
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v15, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 12
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 13
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v16, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 14
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v7, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    s_cmp_eq_u32 s8, 15
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v17, vcc
; SI-NEXT:    s_cselect_b64 vcc, -1, 0
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    buffer_store_short v0, v[9:10], s[4:7], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_extractelement_v16f16_dynamic_sgpr:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; VI-NEXT:    s_load_dword s0, s[0:1], 0x34
; VI-NEXT:    v_lshlrev_b32_e32 v1, 5, v0
; VI-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, s7
; VI-NEXT:    v_add_u32_e32 v5, vcc, s6, v1
; VI-NEXT:    v_addc_u32_e32 v6, vcc, 0, v2, vcc
; VI-NEXT:    flat_load_dwordx4 v[1:4], v[5:6]
; VI-NEXT:    v_add_u32_e32 v5, vcc, 16, v5
; VI-NEXT:    v_addc_u32_e32 v6, vcc, 0, v6, vcc
; VI-NEXT:    flat_load_dwordx4 v[5:8], v[5:6]
; VI-NEXT:    v_mov_b32_e32 v10, s5
; VI-NEXT:    v_add_u32_e32 v9, vcc, s4, v0
; VI-NEXT:    s_cmp_eq_u32 s0, 1
; VI-NEXT:    v_addc_u32_e32 v10, vcc, 0, v10, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 2
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 3
; VI-NEXT:    v_lshrrev_b32_e32 v11, 16, v2
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 4
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v11, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 5
; VI-NEXT:    v_lshrrev_b32_e32 v12, 16, v3
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 6
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v12, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 7
; VI-NEXT:    v_lshrrev_b32_e32 v13, 16, v4
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 8
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v13, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 9
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v5
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v5, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 10
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 11
; VI-NEXT:    v_lshrrev_b32_e32 v14, 16, v6
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 12
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v14, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 13
; VI-NEXT:    v_lshrrev_b32_e32 v15, 16, v7
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v7, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 14
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v15, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s0, 15
; VI-NEXT:    v_lshrrev_b32_e32 v16, 16, v8
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v16, vcc
; VI-NEXT:    flat_store_short v[9:10], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_extractelement_v16f16_dynamic_sgpr:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[4:7], s[0:1], 0x24
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 5, v0
; GFX11-NEXT:    s_load_b32 s0, s[0:1], 0x34
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_load_b128 v[1:4], v5, s[6:7]
; GFX11-NEXT:    global_load_b128 v[5:8], v5, s[6:7] offset:16
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-NEXT:    s_cmp_eq_u32 s0, 1
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s0, 2
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v9, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    v_lshrrev_b32_e32 v9, 16, v2
; GFX11-NEXT:    s_cmp_eq_u32 s0, 3
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s0, 4
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s0, 5
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s0, 6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v4
; GFX11-NEXT:    s_cmp_eq_u32 s0, 7
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s0, 8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v5
; GFX11-NEXT:    s_cmp_eq_u32 s0, 9
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s0, 10
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v6
; GFX11-NEXT:    s_cmp_eq_u32 s0, 11
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s0, 12
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v7
; GFX11-NEXT:    s_cmp_eq_u32 s0, 13
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v7, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s0, 14
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v8
; GFX11-NEXT:    s_cmp_eq_u32 s0, 15
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v8, vcc_lo
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-NEXT:    global_store_b16 v0, v1, s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <16 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds half, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <16 x half>, ptr addrspace(1) %in.gep
  %vec.extract = extractelement <16 x half> %vec, i32 %n
  store half %vec.extract, ptr addrspace(1) %out.gep
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x() #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }
