; RUN: opt %s -S -passes=licm -o - | FileCheck %s
; RUN: opt --try-experimental-debuginfo-iterators %s -S -passes=licm -o - | FileCheck %s

;; $ cat test.c
;; int b, c, d;
;; void e();
;; void f(int *g) { *g = b; }
;; void i() {
;;   int h, a;
;;   for (;;) {
;;     e();
;;     a = 1;
;;     if (h) {
;;       if (d)
;;         continue;
;;       h = c;
;;     }
;;     f(&a);
;;   }
;; }
;; Generated by getting the IR before LICM in:
;; $ clang  -c  -O2 -g  test.c -fno-unroll-loops -fno-vectorize -fno-inline -Xclang -fexperimental-assignment-tracking -o -

;;       entry
;;         |
;;         v
;; *---->for.cond.outer
;; |       |
;; |       v
;; |  +->for.cond-----+
;; |  |    |          |
;; |  |    v          |
;; |  +--if.then      |
;; |       |          |
;; |       v          v
;; |     if.end     if.end3.loopexit
;; |       |          |
;; |       v          |
;; +-----if.end3 <----+
;;
;; The store in for.cond is sunk into the inner-loop exits if.end and if.end3.loopexit.
;;
;; Check that a store sunk into multiple exits retains its (their) dbg.assign,
;; and that the new stores share the same DIAssignID.

; CHECK-LABEL: for.cond:
; CHECK: call void @llvm.dbg.assign(metadata i32 1, metadata ![[var:[0-9]+]], metadata !DIExpression(), metadata ![[id:[0-9]+]], metadata ptr %a, metadata !DIExpression()), !dbg

; CHECK-LABEL: if.end:
; CHECK-NEXT: store i32 1, ptr %a, align 1,{{.*}}!DIAssignID ![[id]]

; CHECK-LABEL: if.end3.loopexit:
; CHECK-NEXT: store i32 1, ptr %a, align 1,{{.*}}!DIAssignID ![[id]]

; CHECK-DAG: ![[var]] = !DILocalVariable(name: "a",

@b = dso_local local_unnamed_addr global i32 0, align 4, !dbg !0
@d = dso_local local_unnamed_addr global i32 0, align 4, !dbg !9
@c = dso_local local_unnamed_addr global i32 0, align 4, !dbg !6

define dso_local void @f(ptr nocapture %g) local_unnamed_addr #0 !dbg !15 {
entry:
  call void @llvm.dbg.assign(metadata i1 undef, metadata !20, metadata !DIExpression(), metadata !21, metadata ptr undef, metadata !DIExpression()), !dbg !22
  call void @llvm.dbg.assign(metadata ptr %g, metadata !20, metadata !DIExpression(), metadata !23, metadata ptr undef, metadata !DIExpression()), !dbg !22
  %0 = load i32, ptr @b, align 4, !dbg !24
  store i32 %0, ptr %g, align 4, !dbg !29
  ret void, !dbg !30
}

define dso_local void @i() local_unnamed_addr #2 !dbg !31 {
entry:
  call void @llvm.dbg.assign(metadata i1 undef, metadata !35, metadata !DIExpression(), metadata !37, metadata ptr undef, metadata !DIExpression()), !dbg !38
  %a = alloca i32, align 4, !DIAssignID !39
  call void @llvm.dbg.assign(metadata i1 undef, metadata !36, metadata !DIExpression(), metadata !39, metadata ptr %a, metadata !DIExpression()), !dbg !38
  call void @llvm.lifetime.start.p0i8(i64 4, ptr nonnull %a) #5, !dbg !40
  br label %for.cond.outer, !dbg !41

for.cond.outer:                                   ; preds = %if.end3, %entry
  %h.0.ph = phi i32 [ %h.1, %if.end3 ], [ undef, %entry ]
  br label %for.cond, !dbg !42

for.cond:                                         ; preds = %for.cond.outer, %if.then
  call void @llvm.dbg.value(metadata i32 %h.0.ph, metadata !35, metadata !DIExpression()), !dbg !38
  tail call void (...) @e() #5, !dbg !44
  store i32 1, ptr %a, align 4, !dbg !47, !DIAssignID !48
  call void @llvm.dbg.assign(metadata i32 1, metadata !36, metadata !DIExpression(), metadata !48, metadata ptr %a, metadata !DIExpression()), !dbg !38
  %tobool.not = icmp eq i32 %h.0.ph, 0, !dbg !49
  br i1 %tobool.not, label %if.end3.loopexit, label %if.then, !dbg !51

if.then:                                          ; preds = %for.cond
  %0 = load i32, ptr @d, align 4, !dbg !52
  %tobool1.not = icmp eq i32 %0, 0, !dbg !52
  br i1 %tobool1.not, label %if.end, label %for.cond, !dbg !55, !llvm.loop !56

if.end:                                           ; preds = %if.then
  %1 = load i32, ptr @c, align 4, !dbg !59
  call void @llvm.dbg.assign(metadata i32 %1, metadata !35, metadata !DIExpression(), metadata !60, metadata ptr undef, metadata !DIExpression()), !dbg !38
  br label %if.end3, !dbg !61

if.end3.loopexit:                                 ; preds = %for.cond
  br label %if.end3, !dbg !62

if.end3:                                          ; preds = %if.end3.loopexit, %if.end
  %h.1 = phi i32 [ %1, %if.end ], [ 0, %if.end3.loopexit ]
  call void @llvm.dbg.value(metadata i32 %h.1, metadata !35, metadata !DIExpression()), !dbg !38
  call void @f(ptr nonnull %a), !dbg !62
  br label %for.cond.outer, !dbg !63, !llvm.loop !56
}

declare void @llvm.dbg.assign(metadata, metadata, metadata, metadata, metadata, metadata) #1
declare void @llvm.lifetime.start.p0i8(i64 immarg, ptr nocapture) #3
declare !dbg !64 dso_local void @e(...) local_unnamed_addr #4
declare void @llvm.dbg.value(metadata, metadata, metadata) #1

!llvm.dbg.cu = !{!2}
!llvm.module.flags = !{!11, !12, !13, !1000}
!llvm.ident = !{!14}

!0 = !DIGlobalVariableExpression(var: !1, expr: !DIExpression())
!1 = distinct !DIGlobalVariable(name: "b", scope: !2, file: !3, line: 1, type: !8, isLocal: false, isDefinition: true)
!2 = distinct !DICompileUnit(language: DW_LANG_C99, file: !3, producer: "clang version 12.0.0", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !4, globals: !5, splitDebugInlining: false, nameTableKind: None)
!3 = !DIFile(filename: "test.c", directory: "/")
!4 = !{}
!5 = !{!0, !6, !9}
!6 = !DIGlobalVariableExpression(var: !7, expr: !DIExpression())
!7 = distinct !DIGlobalVariable(name: "c", scope: !2, file: !3, line: 1, type: !8, isLocal: false, isDefinition: true)
!8 = !DIBasicType(name: "int", size: 32, encoding: DW_ATE_signed)
!9 = !DIGlobalVariableExpression(var: !10, expr: !DIExpression())
!10 = distinct !DIGlobalVariable(name: "d", scope: !2, file: !3, line: 1, type: !8, isLocal: false, isDefinition: true)
!11 = !{i32 7, !"Dwarf Version", i32 4}
!12 = !{i32 2, !"Debug Info Version", i32 3}
!13 = !{i32 1, !"wchar_size", i32 4}
!14 = !{!"clang version 12.0.0"}
!15 = distinct !DISubprogram(name: "f", scope: !3, file: !3, line: 3, type: !16, scopeLine: 3, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !19)
!16 = !DISubroutineType(types: !17)
!17 = !{null, !18}
!18 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !8, size: 64)
!19 = !{!20}
!20 = !DILocalVariable(name: "g", arg: 1, scope: !15, file: !3, line: 3, type: !18)
!21 = distinct !DIAssignID()
!22 = !DILocation(line: 0, scope: !15)
!23 = distinct !DIAssignID()
!24 = !DILocation(line: 3, column: 23, scope: !15)
!29 = !DILocation(line: 3, column: 21, scope: !15)
!30 = !DILocation(line: 3, column: 26, scope: !15)
!31 = distinct !DISubprogram(name: "i", scope: !3, file: !3, line: 4, type: !32, scopeLine: 4, flags: DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !34)
!32 = !DISubroutineType(types: !33)
!33 = !{null}
!34 = !{!35, !36}
!35 = !DILocalVariable(name: "h", scope: !31, file: !3, line: 5, type: !8)
!36 = !DILocalVariable(name: "a", scope: !31, file: !3, line: 5, type: !8)
!37 = distinct !DIAssignID()
!38 = !DILocation(line: 0, scope: !31)
!39 = distinct !DIAssignID()
!40 = !DILocation(line: 5, column: 3, scope: !31)
!41 = !DILocation(line: 6, column: 3, scope: !31)
!42 = !DILocation(line: 6, column: 3, scope: !43)
!43 = distinct !DILexicalBlock(scope: !31, file: !3, line: 6, column: 3)
!44 = !DILocation(line: 7, column: 5, scope: !45)
!45 = distinct !DILexicalBlock(scope: !46, file: !3, line: 6, column: 12)
!46 = distinct !DILexicalBlock(scope: !43, file: !3, line: 6, column: 3)
!47 = !DILocation(line: 8, column: 7, scope: !45)
!48 = distinct !DIAssignID()
!49 = !DILocation(line: 9, column: 9, scope: !50)
!50 = distinct !DILexicalBlock(scope: !45, file: !3, line: 9, column: 9)
!51 = !DILocation(line: 9, column: 9, scope: !45)
!52 = !DILocation(line: 10, column: 11, scope: !53)
!53 = distinct !DILexicalBlock(scope: !54, file: !3, line: 10, column: 11)
!54 = distinct !DILexicalBlock(scope: !50, file: !3, line: 9, column: 12)
!55 = !DILocation(line: 10, column: 11, scope: !54)
!56 = distinct !{!56, !42, !57, !58}
!57 = !DILocation(line: 15, column: 3, scope: !43)
!58 = !{!"llvm.loop.unroll.disable"}
!59 = !DILocation(line: 12, column: 11, scope: !54)
!60 = distinct !DIAssignID()
!61 = !DILocation(line: 13, column: 5, scope: !54)
!62 = !DILocation(line: 14, column: 5, scope: !45)
!63 = !DILocation(line: 6, column: 3, scope: !46)
!64 = !DISubprogram(name: "e", scope: !3, file: !3, line: 2, type: !65, spFlags: DISPFlagOptimized, retainedNodes: !4)
!65 = !DISubroutineType(types: !66)
!66 = !{null, null}
!1000 = !{i32 7, !"debug-info-assignment-tracking", i1 true}
