; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=X86,X86-SSE
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=X86,X86-AVX,X86-AVX1
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=X86,X86-AVX,X86-AVX2
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512vl | FileCheck %s --check-prefixes=X86,X86-AVX512,X86-AVX512VL
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512fp16 | FileCheck %s --check-prefixes=X86,X86-AVX512,X86-AVX512FP16
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefixes=X86,X86-AVX512,X86-AVX512VLDQ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=X64,X64-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=X64,X64-AVX,X64-AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=X64,X64-AVX,X64-AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl | FileCheck %s --check-prefixes=X64,X64-AVX512,X64-AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512fp16 | FileCheck %s --check-prefixes=X64,X64-AVX512,X64-AVX512FP16
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefixes=X64,X64-AVX512,X64-AVX512VLDQ

;
; 128-bit Vectors
;

define <2 x double> @fneg_v2f64(<2 x double> %p) nounwind {
; X86-SSE-LABEL: fneg_v2f64:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    xorps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: fneg_v2f64:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0
; X86-AVX-NEXT:    retl
;
; X86-AVX512VL-LABEL: fneg_v2f64:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpxorq {{\.?LCPI[0-9]+_[0-9]+}}{1to2}, %xmm0, %xmm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512FP16-LABEL: fneg_v2f64:
; X86-AVX512FP16:       # %bb.0:
; X86-AVX512FP16-NEXT:    vxorpd {{\.?LCPI[0-9]+_[0-9]+}}{1to2}, %xmm0, %xmm0
; X86-AVX512FP16-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fneg_v2f64:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vxorpd {{\.?LCPI[0-9]+_[0-9]+}}{1to2}, %xmm0, %xmm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-SSE-LABEL: fneg_v2f64:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    xorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: fneg_v2f64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX-NEXT:    retq
;
; X64-AVX512VL-LABEL: fneg_v2f64:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpxorq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512FP16-LABEL: fneg_v2f64:
; X64-AVX512FP16:       # %bb.0:
; X64-AVX512FP16-NEXT:    vxorpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; X64-AVX512FP16-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fneg_v2f64:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vxorpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = fsub <2 x double> <double -0.0, double -0.0>, %p
  ret <2 x double> %t
}

define <4 x float> @fneg_v4f32(<4 x float> %p) nounwind {
; X86-SSE-LABEL: fneg_v4f32:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    xorps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: fneg_v4f32:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: fneg_v4f32:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vbroadcastss {{.*#+}} xmm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-AVX2-NEXT:    vxorps %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    retl
;
; X86-AVX512VL-LABEL: fneg_v4f32:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpxord {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %xmm0, %xmm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512FP16-LABEL: fneg_v4f32:
; X86-AVX512FP16:       # %bb.0:
; X86-AVX512FP16-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %xmm0, %xmm0
; X86-AVX512FP16-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fneg_v4f32:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %xmm0, %xmm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-SSE-LABEL: fneg_v4f32:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    xorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: fneg_v4f32:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: fneg_v4f32:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vbroadcastss {{.*#+}} xmm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-AVX2-NEXT:    vxorps %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512VL-LABEL: fneg_v4f32:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpxord {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512FP16-LABEL: fneg_v4f32:
; X64-AVX512FP16:       # %bb.0:
; X64-AVX512FP16-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; X64-AVX512FP16-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fneg_v4f32:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = fsub <4 x float> <float -0.0, float -0.0, float -0.0, float -0.0>, %p
  ret <4 x float> %t
}

define <8 x half> @fneg_v8f16(ptr %p) nounwind {
; X86-SSE-LABEL: fneg_v8f16:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movaps (%eax), %xmm0
; X86-SSE-NEXT:    xorps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: fneg_v8f16:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX1-NEXT:    vmovaps (%eax), %xmm0
; X86-AVX1-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: fneg_v8f16:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX2-NEXT:    vpbroadcastw {{.*#+}} xmm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-AVX2-NEXT:    vpxor (%eax), %xmm0, %xmm0
; X86-AVX2-NEXT:    retl
;
; X86-AVX512-LABEL: fneg_v8f16:
; X86-AVX512:       # %bb.0:
; X86-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512-NEXT:    vpbroadcastw {{.*#+}} xmm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-AVX512-NEXT:    vpxor (%eax), %xmm0, %xmm0
; X86-AVX512-NEXT:    retl
;
; X64-SSE-LABEL: fneg_v8f16:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps (%rdi), %xmm0
; X64-SSE-NEXT:    xorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: fneg_v8f16:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX1-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: fneg_v8f16:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpbroadcastw {{.*#+}} xmm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-AVX2-NEXT:    vpxor (%rdi), %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: fneg_v8f16:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vpbroadcastw {{.*#+}} xmm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-AVX512-NEXT:    vpxor (%rdi), %xmm0, %xmm0
; X64-AVX512-NEXT:    retq
  %v = load <8 x half>, ptr %p, align 16
  %nnv = fsub <8 x half> <half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0>, %v
  ret <8 x half> %nnv
}

;
; 256-bit Vectors
;

define <4 x double> @fneg_v4f64(<4 x double> %p) nounwind {
; X86-SSE-LABEL: fneg_v4f64:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movaps {{.*#+}} xmm2 = [-0.0E+0,-0.0E+0]
; X86-SSE-NEXT:    xorps %xmm2, %xmm0
; X86-SSE-NEXT:    xorps %xmm2, %xmm1
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: fneg_v4f64:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: fneg_v4f64:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-AVX2-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
;
; X86-AVX512VL-LABEL: fneg_v4f64:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpxorq {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %ymm0, %ymm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512FP16-LABEL: fneg_v4f64:
; X86-AVX512FP16:       # %bb.0:
; X86-AVX512FP16-NEXT:    vxorpd {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %ymm0, %ymm0
; X86-AVX512FP16-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fneg_v4f64:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vxorpd {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %ymm0, %ymm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-SSE-LABEL: fneg_v4f64:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps {{.*#+}} xmm2 = [-0.0E+0,-0.0E+0]
; X64-SSE-NEXT:    xorps %xmm2, %xmm0
; X64-SSE-NEXT:    xorps %xmm2, %xmm1
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: fneg_v4f64:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: fneg_v4f64:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-AVX2-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512VL-LABEL: fneg_v4f64:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpxorq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512FP16-LABEL: fneg_v4f64:
; X64-AVX512FP16:       # %bb.0:
; X64-AVX512FP16-NEXT:    vxorpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; X64-AVX512FP16-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fneg_v4f64:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vxorpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = fsub <4 x double> <double -0.0, double -0.0, double -0.0, double -0.0>, %p
  ret <4 x double> %t
}

define <8 x float> @fneg_v8f32(<8 x float> %p) nounwind {
; X86-SSE-LABEL: fneg_v8f32:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movaps {{.*#+}} xmm2 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-SSE-NEXT:    xorps %xmm2, %xmm0
; X86-SSE-NEXT:    xorps %xmm2, %xmm1
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: fneg_v8f32:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: fneg_v8f32:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    vbroadcastss {{.*#+}} ymm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-AVX2-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
;
; X86-AVX512VL-LABEL: fneg_v8f32:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpxord {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %ymm0, %ymm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512FP16-LABEL: fneg_v8f32:
; X86-AVX512FP16:       # %bb.0:
; X86-AVX512FP16-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %ymm0, %ymm0
; X86-AVX512FP16-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fneg_v8f32:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %ymm0, %ymm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-SSE-LABEL: fneg_v8f32:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps {{.*#+}} xmm2 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-SSE-NEXT:    xorps %xmm2, %xmm0
; X64-SSE-NEXT:    xorps %xmm2, %xmm1
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: fneg_v8f32:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: fneg_v8f32:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vbroadcastss {{.*#+}} ymm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-AVX2-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512VL-LABEL: fneg_v8f32:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpxord {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512FP16-LABEL: fneg_v8f32:
; X64-AVX512FP16:       # %bb.0:
; X64-AVX512FP16-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; X64-AVX512FP16-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fneg_v8f32:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = fsub <8 x float> <float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0>, %p
  ret <8 x float> %t
}

define <16 x half> @fneg_v16f16(ptr %p) nounwind {
; X86-SSE-LABEL: fneg_v16f16:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movaps {{.*#+}} xmm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-SSE-NEXT:    movaps (%eax), %xmm0
; X86-SSE-NEXT:    xorps %xmm1, %xmm0
; X86-SSE-NEXT:    xorps 16(%eax), %xmm1
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: fneg_v16f16:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX1-NEXT:    vmovups (%eax), %ymm0
; X86-AVX1-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: fneg_v16f16:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-AVX2-NEXT:    vpxor (%eax), %ymm0, %ymm0
; X86-AVX2-NEXT:    retl
;
; X86-AVX512-LABEL: fneg_v16f16:
; X86-AVX512:       # %bb.0:
; X86-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-AVX512-NEXT:    vpxor (%eax), %ymm0, %ymm0
; X86-AVX512-NEXT:    retl
;
; X64-SSE-LABEL: fneg_v16f16:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps {{.*#+}} xmm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-SSE-NEXT:    movaps (%rdi), %xmm0
; X64-SSE-NEXT:    xorps %xmm1, %xmm0
; X64-SSE-NEXT:    xorps 16(%rdi), %xmm1
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: fneg_v16f16:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vmovups (%rdi), %ymm0
; X64-AVX1-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: fneg_v16f16:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-AVX2-NEXT:    vpxor (%rdi), %ymm0, %ymm0
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: fneg_v16f16:
; X64-AVX512:       # %bb.0:
; X64-AVX512-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-AVX512-NEXT:    vpxor (%rdi), %ymm0, %ymm0
; X64-AVX512-NEXT:    retq
  %v = load <16 x half>, ptr %p, align 16
  %nnv = fsub <16 x half> <half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0>, %v
  ret <16 x half> %nnv
}

;
; 512-bit Vectors
;

define <8 x double> @fneg_v8f64(<8 x double> %p) nounwind {
; X86-SSE-LABEL: fneg_v8f64:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    pushl %ebp
; X86-SSE-NEXT:    movl %esp, %ebp
; X86-SSE-NEXT:    andl $-16, %esp
; X86-SSE-NEXT:    subl $16, %esp
; X86-SSE-NEXT:    movaps {{.*#+}} xmm3 = [-0.0E+0,-0.0E+0]
; X86-SSE-NEXT:    xorps %xmm3, %xmm0
; X86-SSE-NEXT:    xorps %xmm3, %xmm1
; X86-SSE-NEXT:    xorps %xmm3, %xmm2
; X86-SSE-NEXT:    xorps 8(%ebp), %xmm3
; X86-SSE-NEXT:    movl %ebp, %esp
; X86-SSE-NEXT:    popl %ebp
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: fneg_v8f64:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-AVX-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; X86-AVX-NEXT:    vxorps %ymm2, %ymm1, %ymm1
; X86-AVX-NEXT:    retl
;
; X86-AVX512VL-LABEL: fneg_v8f64:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpxorq {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %zmm0, %zmm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512FP16-LABEL: fneg_v8f64:
; X86-AVX512FP16:       # %bb.0:
; X86-AVX512FP16-NEXT:    vxorpd {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %zmm0, %zmm0
; X86-AVX512FP16-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fneg_v8f64:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vxorpd {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %zmm0, %zmm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-SSE-LABEL: fneg_v8f64:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps {{.*#+}} xmm4 = [-0.0E+0,-0.0E+0]
; X64-SSE-NEXT:    xorps %xmm4, %xmm0
; X64-SSE-NEXT:    xorps %xmm4, %xmm1
; X64-SSE-NEXT:    xorps %xmm4, %xmm2
; X64-SSE-NEXT:    xorps %xmm4, %xmm3
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: fneg_v8f64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-AVX-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; X64-AVX-NEXT:    vxorps %ymm2, %ymm1, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512VL-LABEL: fneg_v8f64:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpxorq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512FP16-LABEL: fneg_v8f64:
; X64-AVX512FP16:       # %bb.0:
; X64-AVX512FP16-NEXT:    vxorpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; X64-AVX512FP16-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fneg_v8f64:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vxorpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = fsub <8 x double> <double -0.0, double -0.0, double -0.0, double -0.0, double -0.0, double -0.0, double -0.0, double -0.0>, %p
  ret <8 x double> %t
}

define <16 x float> @fneg_v16f32(<16 x float> %p) nounwind {
; X86-SSE-LABEL: fneg_v16f32:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    pushl %ebp
; X86-SSE-NEXT:    movl %esp, %ebp
; X86-SSE-NEXT:    andl $-16, %esp
; X86-SSE-NEXT:    subl $16, %esp
; X86-SSE-NEXT:    movaps {{.*#+}} xmm3 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-SSE-NEXT:    xorps %xmm3, %xmm0
; X86-SSE-NEXT:    xorps %xmm3, %xmm1
; X86-SSE-NEXT:    xorps %xmm3, %xmm2
; X86-SSE-NEXT:    xorps 8(%ebp), %xmm3
; X86-SSE-NEXT:    movl %ebp, %esp
; X86-SSE-NEXT:    popl %ebp
; X86-SSE-NEXT:    retl
;
; X86-AVX-LABEL: fneg_v16f32:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vbroadcastss {{.*#+}} ymm2 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-AVX-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; X86-AVX-NEXT:    vxorps %ymm2, %ymm1, %ymm1
; X86-AVX-NEXT:    retl
;
; X86-AVX512VL-LABEL: fneg_v16f32:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpxord {{\.?LCPI[0-9]+_[0-9]+}}{1to16}, %zmm0, %zmm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512FP16-LABEL: fneg_v16f32:
; X86-AVX512FP16:       # %bb.0:
; X86-AVX512FP16-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}{1to16}, %zmm0, %zmm0
; X86-AVX512FP16-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fneg_v16f32:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}{1to16}, %zmm0, %zmm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-SSE-LABEL: fneg_v16f32:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps {{.*#+}} xmm4 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-SSE-NEXT:    xorps %xmm4, %xmm0
; X64-SSE-NEXT:    xorps %xmm4, %xmm1
; X64-SSE-NEXT:    xorps %xmm4, %xmm2
; X64-SSE-NEXT:    xorps %xmm4, %xmm3
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: fneg_v16f32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vbroadcastss {{.*#+}} ymm2 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-AVX-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; X64-AVX-NEXT:    vxorps %ymm2, %ymm1, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512VL-LABEL: fneg_v16f32:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpxord {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512FP16-LABEL: fneg_v16f32:
; X64-AVX512FP16:       # %bb.0:
; X64-AVX512FP16-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-AVX512FP16-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fneg_v16f32:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = fsub <16 x float> <float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0>, %p
  ret <16 x float> %t
}

define <32 x half> @fneg_v32f16(ptr %p) nounwind {
; X86-SSE-LABEL: fneg_v32f16:
; X86-SSE:       # %bb.0:
; X86-SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-SSE-NEXT:    movaps {{.*#+}} xmm3 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-SSE-NEXT:    movaps (%eax), %xmm0
; X86-SSE-NEXT:    xorps %xmm3, %xmm0
; X86-SSE-NEXT:    movaps 16(%eax), %xmm1
; X86-SSE-NEXT:    xorps %xmm3, %xmm1
; X86-SSE-NEXT:    movaps 32(%eax), %xmm2
; X86-SSE-NEXT:    xorps %xmm3, %xmm2
; X86-SSE-NEXT:    xorps 48(%eax), %xmm3
; X86-SSE-NEXT:    retl
;
; X86-AVX1-LABEL: fneg_v32f16:
; X86-AVX1:       # %bb.0:
; X86-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-AVX1-NEXT:    vxorps (%eax), %ymm1, %ymm0
; X86-AVX1-NEXT:    vxorps 32(%eax), %ymm1, %ymm1
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: fneg_v32f16:
; X86-AVX2:       # %bb.0:
; X86-AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-AVX2-NEXT:    vpxor (%eax), %ymm1, %ymm0
; X86-AVX2-NEXT:    vpxor 32(%eax), %ymm1, %ymm1
; X86-AVX2-NEXT:    retl
;
; X86-AVX512VL-LABEL: fneg_v32f16:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512VL-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-AVX512VL-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; X86-AVX512VL-NEXT:    vpxorq (%eax), %zmm0, %zmm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512FP16-LABEL: fneg_v32f16:
; X86-AVX512FP16:       # %bb.0:
; X86-AVX512FP16-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512FP16-NEXT:    vpbroadcastw {{.*#+}} zmm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-AVX512FP16-NEXT:    vpxorq (%eax), %zmm0, %zmm0
; X86-AVX512FP16-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fneg_v32f16:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-AVX512VLDQ-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X86-AVX512VLDQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; X86-AVX512VLDQ-NEXT:    vpxorq (%eax), %zmm0, %zmm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-SSE-LABEL: fneg_v32f16:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    movaps {{.*#+}} xmm3 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-SSE-NEXT:    movaps (%rdi), %xmm0
; X64-SSE-NEXT:    xorps %xmm3, %xmm0
; X64-SSE-NEXT:    movaps 16(%rdi), %xmm1
; X64-SSE-NEXT:    xorps %xmm3, %xmm1
; X64-SSE-NEXT:    movaps 32(%rdi), %xmm2
; X64-SSE-NEXT:    xorps %xmm3, %xmm2
; X64-SSE-NEXT:    xorps 48(%rdi), %xmm3
; X64-SSE-NEXT:    retq
;
; X64-AVX1-LABEL: fneg_v32f16:
; X64-AVX1:       # %bb.0:
; X64-AVX1-NEXT:    vbroadcastss {{.*#+}} ymm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-AVX1-NEXT:    vxorps (%rdi), %ymm1, %ymm0
; X64-AVX1-NEXT:    vxorps 32(%rdi), %ymm1, %ymm1
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: fneg_v32f16:
; X64-AVX2:       # %bb.0:
; X64-AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm1 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-AVX2-NEXT:    vpxor (%rdi), %ymm1, %ymm0
; X64-AVX2-NEXT:    vpxor 32(%rdi), %ymm1, %ymm1
; X64-AVX2-NEXT:    retq
;
; X64-AVX512VL-LABEL: fneg_v32f16:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-AVX512VL-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512VL-NEXT:    vpxorq (%rdi), %zmm0, %zmm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512FP16-LABEL: fneg_v32f16:
; X64-AVX512FP16:       # %bb.0:
; X64-AVX512FP16-NEXT:    vpbroadcastw {{.*#+}} zmm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-AVX512FP16-NEXT:    vpxorq (%rdi), %zmm0, %zmm0
; X64-AVX512FP16-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fneg_v32f16:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vpbroadcastw {{.*#+}} ymm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; X64-AVX512VLDQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512VLDQ-NEXT:    vpxorq (%rdi), %zmm0, %zmm0
; X64-AVX512VLDQ-NEXT:    retq
  %v = load <32 x half>, ptr %p, align 16
  %nnv = fsub <32 x half> <half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0, half -0.0>, %v
  ret <32 x half> %nnv
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; X64: {{.*}}
; X86: {{.*}}
