#ifndef PQCLEAN_NTRUHRSS1373_CLEAN_API_H
#define PQCLEAN_NTRUHRSS1373_CLEAN_API_H

#include <stdint.h>

#define PQCLEAN_NTRUHRSS1373_CLEAN_CRYPTO_SECRETKEYBYTES 2983
#define PQCLEAN_NTRUHRSS1373_CLEAN_CRYPTO_PUBLICKEYBYTES 2401
#define PQCLEAN_NTRUHRSS1373_CLEAN_CRYPTO_CIPHERTEXTBYTES 2401
#define PQCLEAN_NTRUHRSS1373_CLEAN_CRYPTO_BYTES 32

#define PQCLEAN_NTRUHRSS1373_CLEAN_CRYPTO_ALGNAME "ntruhrss1373"

int PQCLEAN_NTRUHRSS1373_CLEAN_crypto_kem_keypair(uint8_t *pk, uint8_t *sk);

int PQCLEAN_NTRUHRSS1373_CLEAN_crypto_kem_enc(uint8_t *c, uint8_t *k, const uint8_t *pk);

int PQCLEAN_NTRUHRSS1373_CLEAN_crypto_kem_dec(uint8_t *k, const uint8_t *c, const uint8_t *sk);

#endif
