; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=tonga -stop-after=legalizer -o - %s | FileCheck -check-prefix=UNPACKED %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx810 -stop-after=legalizer -o - %s | FileCheck -check-prefix=PACKED %s

define amdgpu_ps half @image_load_f16(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_f16
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(s16) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; UNPACKED-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](s16)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[ANYEXT]](s32)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ;
  ; PACKED-LABEL: name: image_load_f16
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(s16) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; PACKED-NEXT:   [[ANYEXT:%[0-9]+]]:_(s32) = G_ANYEXT [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](s16)
  ; PACKED-NEXT:   $vgpr0 = COPY [[ANYEXT]](s32)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %tex = call half @llvm.amdgcn.image.load.2d.f16.i32(i32 1, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret half %tex
}

define amdgpu_ps <2 x half> @image_load_v2f16(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_v2f16
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 3, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (<2 x s16>), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[AND1:%[0-9]+]]:_(s32) = G_AND [[UV1]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[AND1]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ;
  ; PACKED-LABEL: name: image_load_v2f16
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s16>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 3, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (<2 x s16>), addrspace 8)
  ; PACKED-NEXT:   $vgpr0 = COPY [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %tex = call <2 x half> @llvm.amdgcn.image.load.2d.v2f16.i32(i32 3, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret <2 x half> %tex
}

define amdgpu_ps <3 x half> @image_load_v3f16(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_v3f16
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<3 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 7, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (<3 x s16>), align 8, addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<3 x s32>)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[AND1:%[0-9]+]]:_(s32) = G_AND [[UV1]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[AND1]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[AND2:%[0-9]+]]:_(s32) = G_AND [[UV2]], [[C]]
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[SHL1:%[0-9]+]]:_(s32) = G_SHL [[C2]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[AND2]], [[SHL1]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_v3f16
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<4 x s16>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 7, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (<3 x s16>), align 8, addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(<2 x s16>), [[UV1:%[0-9]+]]:_(<2 x s16>) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<4 x s16>)
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(s32) = G_BITCAST [[UV1]](<2 x s16>)
  ; PACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; PACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; PACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[BITCAST]], [[C1]]
  ; PACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; PACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C2]], [[C]](s32)
  ; PACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; PACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; PACKED-NEXT:   $vgpr0 = COPY [[UV]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %tex = call <3 x half> @llvm.amdgcn.image.load.2d.v3f16.i32(i32 7, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret <3 x half> %tex
}

define amdgpu_ps <4 x half> @image_load_v4f16(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_v4f16
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 15, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (<4 x s16>), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<4 x s32>)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[AND1:%[0-9]+]]:_(s32) = G_AND [[UV1]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[AND1]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[AND2:%[0-9]+]]:_(s32) = G_AND [[UV2]], [[C]]
  ; UNPACKED-NEXT:   [[AND3:%[0-9]+]]:_(s32) = G_AND [[UV3]], [[C]]
  ; UNPACKED-NEXT:   [[SHL1:%[0-9]+]]:_(s32) = G_SHL [[AND3]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[AND2]], [[SHL1]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_v4f16
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<4 x s16>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 15, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (<4 x s16>), addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(<2 x s16>), [[UV1:%[0-9]+]]:_(<2 x s16>) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<4 x s16>)
  ; PACKED-NEXT:   $vgpr0 = COPY [[UV]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[UV1]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %tex = call <4 x half> @llvm.amdgcn.image.load.2d.v4f16.i32(i32 15, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x half> %tex
}

define amdgpu_ps half @image_load_tfe_f16(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_tfe_f16
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; UNPACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[UV]](s32)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ;
  ; PACKED-LABEL: name: image_load_tfe_f16
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; PACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; PACKED-NEXT:   $vgpr0 = COPY [[UV]](s32)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %res = call { half, i32 } @llvm.amdgcn.image.load.2d.sl_f16i32s.i32(i32 1, i32 %s, i32 %t, <8 x i32> %rsrc, i32 1, i32 0)
  %tex = extractvalue { half, i32 } %res, 0
  %tfe = extractvalue { half, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) undef
  ret half %tex
}

define amdgpu_ps <2 x half> @image_load_tfe_v2f16(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_tfe_v2f16
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<3 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 3, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (<2 x s16>), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<3 x s32>)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[AND1:%[0-9]+]]:_(s32) = G_AND [[UV1]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[AND1]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   G_STORE [[UV2]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ;
  ; PACKED-LABEL: name: image_load_tfe_v2f16
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 3, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (<2 x s16>), addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[UV]](s32)
  ; PACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; PACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %res = call { <2 x half>, i32 } @llvm.amdgcn.image.load.2d.sl_v2f16i32s.i32(i32 3, i32 %s, i32 %t, <8 x i32> %rsrc, i32 1, i32 0)
  %tex = extractvalue { <2 x half>, i32 } %res, 0
  %tfe = extractvalue { <2 x half>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) undef
  ret <2 x half> %tex
}

define amdgpu_ps <3 x half> @image_load_tfe_v3f16(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_tfe_v3f16
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 7, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (<3 x s16>), align 8, addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<4 x s32>)
  ; UNPACKED-NEXT:   G_STORE [[UV3]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[AND1:%[0-9]+]]:_(s32) = G_AND [[UV1]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[AND1]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[AND2:%[0-9]+]]:_(s32) = G_AND [[UV2]], [[C]]
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[SHL1:%[0-9]+]]:_(s32) = G_SHL [[C2]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[AND2]], [[SHL1]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_tfe_v3f16
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<3 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 7, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (<3 x s16>), align 8, addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<3 x s32>)
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[UV]](s32)
  ; PACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[UV1]](s32)
  ; PACKED-NEXT:   G_STORE [[UV2]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; PACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %res = call { <3 x half>, i32 } @llvm.amdgcn.image.load.2d.sl_v3f16i32s.i32(i32 7, i32 %s, i32 %t, <8 x i32> %rsrc, i32 1, i32 0)
  %tex = extractvalue { <3 x half>, i32 } %res, 0
  %tfe = extractvalue { <3 x half>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) undef
  ret <3 x half> %tex
}

define amdgpu_ps <4 x half> @image_load_tfe_v4f16(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_tfe_v4f16
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<5 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 15, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (<4 x s16>), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32), [[UV4:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<5 x s32>)
  ; UNPACKED-NEXT:   G_STORE [[UV4]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[AND1:%[0-9]+]]:_(s32) = G_AND [[UV1]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[AND1]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[AND2:%[0-9]+]]:_(s32) = G_AND [[UV2]], [[C]]
  ; UNPACKED-NEXT:   [[AND3:%[0-9]+]]:_(s32) = G_AND [[UV3]], [[C]]
  ; UNPACKED-NEXT:   [[SHL1:%[0-9]+]]:_(s32) = G_SHL [[AND3]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[AND2]], [[SHL1]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_tfe_v4f16
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<3 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 15, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (<4 x s16>), addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<3 x s32>)
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[UV]](s32)
  ; PACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[UV1]](s32)
  ; PACKED-NEXT:   G_STORE [[UV2]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; PACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %res = call { <4 x half>, i32 } @llvm.amdgcn.image.load.2d.sl_v4f16i32s.i32(i32 15, i32 %s, i32 %t, <8 x i32> %rsrc, i32 1, i32 0)
  %tex = extractvalue { <4 x half>, i32 } %res, 0
  %tfe = extractvalue { <4 x half>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) undef
  ret <4 x half> %tex
}

define amdgpu_ps half @image_load_f16_dmask_0000(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_f16_dmask_0000
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[DEF]](s32)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ;
  ; PACKED-LABEL: name: image_load_f16_dmask_0000
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(s32) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   $vgpr0 = COPY [[DEF]](s32)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %tex = call half @llvm.amdgcn.image.load.2d.f16.i32(i32 0, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret half %tex
}

define amdgpu_ps <2 x half> @image_load_v2f16_dmask_1000(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_v2f16_dmask_1000
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(s32) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C1]], [[C2]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ;
  ; PACKED-LABEL: name: image_load_v2f16_dmask_1000
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s16>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; PACKED-NEXT:   $vgpr0 = COPY [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %tex = call <2 x half> @llvm.amdgcn.image.load.2d.v2f16.i32(i32 1, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret <2 x half> %tex
}

define amdgpu_ps <2 x half> @image_load_v2f16_dmask_0000(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_v2f16_dmask_0000
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(<2 x s16>) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[DEF]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ;
  ; PACKED-LABEL: name: image_load_v2f16_dmask_0000
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(<2 x s16>) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   $vgpr0 = COPY [[DEF]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %tex = call <2 x half> @llvm.amdgcn.image.load.2d.v2f16.i32(i32 0, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret <2 x half> %tex
}

define amdgpu_ps <3 x half> @image_load_v3f16_dmask_1100(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_v3f16_dmask_1100
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 3, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (<2 x s16>), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[AND1:%[0-9]+]]:_(s32) = G_AND [[UV1]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[AND1]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[SHL1:%[0-9]+]]:_(s32) = G_SHL [[C2]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[C2]], [[SHL1]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_v3f16_dmask_1100
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s16>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 3, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (<2 x s16>), addrspace 8)
  ; PACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; PACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; PACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C]], [[C1]](s32)
  ; PACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[C]], [[SHL]]
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; PACKED-NEXT:   $vgpr0 = COPY [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[BITCAST]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %tex = call <3 x half> @llvm.amdgcn.image.load.2d.v3f16.i32(i32 3, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret <3 x half> %tex
}

define amdgpu_ps <3 x half> @image_load_v3f16_dmask_1000(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_v3f16_dmask_1000
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(s32) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C1]], [[C2]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[C1]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_v3f16_dmask_1000
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s16>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; PACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; PACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; PACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C]], [[C1]](s32)
  ; PACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[C]], [[SHL]]
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; PACKED-NEXT:   $vgpr0 = COPY [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[BITCAST]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %tex = call <3 x half> @llvm.amdgcn.image.load.2d.v3f16.i32(i32 1, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret <3 x half> %tex
}

define amdgpu_ps <3 x half> @image_load_v3f16_dmask_0000(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_v3f16_dmask_0000
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(<4 x s16>) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(<2 x s16>), [[UV1:%[0-9]+]]:_(<2 x s16>) = G_UNMERGE_VALUES [[DEF]](<4 x s16>)
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(s32) = G_BITCAST [[UV1]](<2 x s16>)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[BITCAST]], [[C1]]
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C2]], [[C]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[UV]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_v3f16_dmask_0000
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(<4 x s16>) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(<2 x s16>), [[UV1:%[0-9]+]]:_(<2 x s16>) = G_UNMERGE_VALUES [[DEF]](<4 x s16>)
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(s32) = G_BITCAST [[UV1]](<2 x s16>)
  ; PACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; PACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; PACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[BITCAST]], [[C1]]
  ; PACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; PACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C2]], [[C]](s32)
  ; PACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; PACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; PACKED-NEXT:   $vgpr0 = COPY [[UV]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %tex = call <3 x half> @llvm.amdgcn.image.load.2d.v3f16.i32(i32 0, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret <3 x half> %tex
}

define amdgpu_ps <4 x half> @image_load_v4f16_dmask_1110(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_v4f16_dmask_1110
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<3 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 7, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (<3 x s16>), align 8, addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<3 x s32>)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[AND1:%[0-9]+]]:_(s32) = G_AND [[UV1]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[AND1]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[AND2:%[0-9]+]]:_(s32) = G_AND [[UV2]], [[C]]
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[SHL1:%[0-9]+]]:_(s32) = G_SHL [[C2]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[AND2]], [[SHL1]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_v4f16_dmask_1110
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<4 x s16>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 7, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (<3 x s16>), align 8, addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(<2 x s16>), [[UV1:%[0-9]+]]:_(<2 x s16>) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<4 x s16>)
  ; PACKED-NEXT:   $vgpr0 = COPY [[UV]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[UV1]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %tex = call <4 x half> @llvm.amdgcn.image.load.2d.v4f16.i32(i32 7, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x half> %tex
}

define amdgpu_ps <4 x half> @image_load_v4f16_dmask_1100(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_v4f16_dmask_1100
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 3, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (<2 x s16>), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[AND1:%[0-9]+]]:_(s32) = G_AND [[UV1]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[AND1]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[SHL1:%[0-9]+]]:_(s32) = G_SHL [[C2]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[C2]], [[SHL1]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_v4f16_dmask_1100
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s16>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 3, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (<2 x s16>), addrspace 8)
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(<2 x s16>) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   $vgpr0 = COPY [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[DEF]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %tex = call <4 x half> @llvm.amdgcn.image.load.2d.v4f16.i32(i32 3, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x half> %tex
}

define amdgpu_ps <4 x half> @image_load_v4f16_dmask_1000(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_v4f16_dmask_1000
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(s32) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C1]], [[C2]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[C1]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_v4f16_dmask_1000
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s16>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 0, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(<2 x s16>) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   $vgpr0 = COPY [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[DEF]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %tex = call <4 x half> @llvm.amdgcn.image.load.2d.v4f16.i32(i32 1, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x half> %tex
}

define amdgpu_ps <4 x half> @image_load_v4f16_dmask_0000(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_v4f16_dmask_0000
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(<4 x s16>) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(<2 x s16>), [[UV1:%[0-9]+]]:_(<2 x s16>) = G_UNMERGE_VALUES [[DEF]](<4 x s16>)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[UV]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[UV1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_v4f16_dmask_0000
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(<4 x s16>) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(<2 x s16>), [[UV1:%[0-9]+]]:_(<2 x s16>) = G_UNMERGE_VALUES [[DEF]](<4 x s16>)
  ; PACKED-NEXT:   $vgpr0 = COPY [[UV]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[UV1]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %tex = call <4 x half> @llvm.amdgcn.image.load.2d.v4f16.i32(i32 0, i32 %s, i32 %t, <8 x i32> %rsrc, i32 0, i32 0)
  ret <4 x half> %tex
}

define amdgpu_ps half @image_load_tfe_f16_dmask_0000(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_tfe_f16_dmask_0000
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; UNPACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[UV]](s32)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ;
  ; PACKED-LABEL: name: image_load_tfe_f16_dmask_0000
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; PACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; PACKED-NEXT:   $vgpr0 = COPY [[UV]](s32)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %res = call { half, i32 } @llvm.amdgcn.image.load.2d.sl_f16i32s.i32(i32 0, i32 %s, i32 %t, <8 x i32> %rsrc, i32 1, i32 0)
  %tex = extractvalue { half, i32 } %res, 0
  %tfe = extractvalue { half, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) undef
  ret half %tex
}

define amdgpu_ps <2 x half> @image_load_tfe_v2f16_dmask_1000(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_tfe_v2f16_dmask_1000
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C1]], [[C2]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ;
  ; PACKED-LABEL: name: image_load_tfe_v2f16_dmask_1000
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[UV]](s32)
  ; PACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; PACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %res = call { <2 x half>, i32 } @llvm.amdgcn.image.load.2d.sl_v2f16i32s.i32(i32 1, i32 %s, i32 %t, <8 x i32> %rsrc, i32 1, i32 0)
  %tex = extractvalue { <2 x half>, i32 } %res, 0
  %tfe = extractvalue { <2 x half>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) undef
  ret <2 x half> %tex
}

define amdgpu_ps <2 x half> @image_load_tfe_v2f16_dmask_0000(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_tfe_v2f16_dmask_0000
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C1]], [[C2]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ;
  ; PACKED-LABEL: name: image_load_tfe_v2f16_dmask_0000
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[UV]](s32)
  ; PACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; PACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %res = call { <2 x half>, i32 } @llvm.amdgcn.image.load.2d.sl_v2f16i32s.i32(i32 0, i32 %s, i32 %t, <8 x i32> %rsrc, i32 1, i32 0)
  %tex = extractvalue { <2 x half>, i32 } %res, 0
  %tfe = extractvalue { <2 x half>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) undef
  ret <2 x half> %tex
}

define amdgpu_ps <3 x half> @image_load_tfe_v3f16_dmask_1100(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_tfe_v3f16_dmask_1100
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<3 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 3, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (<2 x s16>), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<3 x s32>)
  ; UNPACKED-NEXT:   G_STORE [[UV2]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[AND1:%[0-9]+]]:_(s32) = G_AND [[UV1]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[AND1]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[SHL1:%[0-9]+]]:_(s32) = G_SHL [[C2]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[C2]], [[SHL1]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_tfe_v3f16_dmask_1100
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 3, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (<2 x s16>), addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[UV]](s32)
  ; PACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; PACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; PACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; PACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C]], [[C1]](s32)
  ; PACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[C]], [[SHL]]
  ; PACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; PACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %res = call { <3 x half>, i32 } @llvm.amdgcn.image.load.2d.sl_v3f16i32s.i32(i32 3, i32 %s, i32 %t, <8 x i32> %rsrc, i32 1, i32 0)
  %tex = extractvalue { <3 x half>, i32 } %res, 0
  %tfe = extractvalue { <3 x half>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) undef
  ret <3 x half> %tex
}

define amdgpu_ps <3 x half> @image_load_tfe_v3f16_dmask_1000(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_tfe_v3f16_dmask_1000
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; UNPACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C1]], [[C2]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[C1]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_tfe_v3f16_dmask_1000
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[UV]](s32)
  ; PACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; PACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; PACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; PACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C]], [[C1]](s32)
  ; PACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[C]], [[SHL]]
  ; PACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; PACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %res = call { <3 x half>, i32 } @llvm.amdgcn.image.load.2d.sl_v3f16i32s.i32(i32 1, i32 %s, i32 %t, <8 x i32> %rsrc, i32 1, i32 0)
  %tex = extractvalue { <3 x half>, i32 } %res, 0
  %tfe = extractvalue { <3 x half>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) undef
  ret <3 x half> %tex
}

define amdgpu_ps <3 x half> @image_load_tfe_v3f16_dmask_0000(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_tfe_v3f16_dmask_0000
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; UNPACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C1]], [[C2]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[C1]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_tfe_v3f16_dmask_0000
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[UV]](s32)
  ; PACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; PACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; PACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; PACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C]], [[C1]](s32)
  ; PACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[C]], [[SHL]]
  ; PACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; PACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %res = call { <3 x half>, i32 } @llvm.amdgcn.image.load.2d.sl_v3f16i32s.i32(i32 0, i32 %s, i32 %t, <8 x i32> %rsrc, i32 1, i32 0)
  %tex = extractvalue { <3 x half>, i32 } %res, 0
  %tfe = extractvalue { <3 x half>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) undef
  ret <3 x half> %tex
}

define amdgpu_ps <4 x half> @image_load_tfe_v4f16_dmask_1110(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_tfe_v4f16_dmask_1110
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<4 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 7, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (<3 x s16>), align 8, addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<4 x s32>)
  ; UNPACKED-NEXT:   G_STORE [[UV3]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[AND1:%[0-9]+]]:_(s32) = G_AND [[UV1]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[AND1]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[AND2:%[0-9]+]]:_(s32) = G_AND [[UV2]], [[C]]
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[SHL1:%[0-9]+]]:_(s32) = G_SHL [[C2]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[AND2]], [[SHL1]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_tfe_v4f16_dmask_1110
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<3 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 7, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (<3 x s16>), align 8, addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<3 x s32>)
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[UV]](s32)
  ; PACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[UV1]](s32)
  ; PACKED-NEXT:   G_STORE [[UV2]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; PACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %res = call { <4 x half>, i32 } @llvm.amdgcn.image.load.2d.sl_v4f16i32s.i32(i32 7, i32 %s, i32 %t, <8 x i32> %rsrc, i32 1, i32 0)
  %tex = extractvalue { <4 x half>, i32 } %res, 0
  %tfe = extractvalue { <4 x half>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) undef
  ret <4 x half> %tex
}

define amdgpu_ps <4 x half> @image_load_tfe_v4f16_dmask_1100(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_tfe_v4f16_dmask_1100
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<3 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 3, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (<2 x s16>), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32), [[UV2:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<3 x s32>)
  ; UNPACKED-NEXT:   G_STORE [[UV2]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[AND1:%[0-9]+]]:_(s32) = G_AND [[UV1]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[AND1]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[SHL1:%[0-9]+]]:_(s32) = G_SHL [[C2]], [[C1]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[C2]], [[SHL1]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_tfe_v4f16_dmask_1100
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 3, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (<2 x s16>), addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[UV]](s32)
  ; PACKED-NEXT:   [[DEF1:%[0-9]+]]:_(<2 x s16>) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; PACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[DEF1]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %res = call { <4 x half>, i32 } @llvm.amdgcn.image.load.2d.sl_v4f16i32s.i32(i32 3, i32 %s, i32 %t, <8 x i32> %rsrc, i32 1, i32 0)
  %tex = extractvalue { <4 x half>, i32 } %res, 0
  %tfe = extractvalue { <4 x half>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) undef
  ret <4 x half> %tex
}

define amdgpu_ps <4 x half> @image_load_tfe_v4f16_dmask_1000(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_tfe_v4f16_dmask_1000
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; UNPACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C1]], [[C2]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[C1]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_tfe_v4f16_dmask_1000
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[UV]](s32)
  ; PACKED-NEXT:   [[DEF1:%[0-9]+]]:_(<2 x s16>) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; PACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[DEF1]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %res = call { <4 x half>, i32 } @llvm.amdgcn.image.load.2d.sl_v4f16i32s.i32(i32 1, i32 %s, i32 %t, <8 x i32> %rsrc, i32 1, i32 0)
  %tex = extractvalue { <4 x half>, i32 } %res, 0
  %tfe = extractvalue { <4 x half>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) undef
  ret <4 x half> %tex
}

define amdgpu_ps <4 x half> @image_load_tfe_v4f16_dmask_0000(<8 x i32> inreg %rsrc, i32 %s, i32 %t) {
  ; UNPACKED-LABEL: name: image_load_tfe_v4f16_dmask_0000
  ; UNPACKED: bb.1 (%ir-block.0):
  ; UNPACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; UNPACKED-NEXT: {{  $}}
  ; UNPACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; UNPACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; UNPACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; UNPACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; UNPACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; UNPACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; UNPACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; UNPACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; UNPACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; UNPACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; UNPACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; UNPACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; UNPACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; UNPACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; UNPACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; UNPACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; UNPACKED-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 65535
  ; UNPACKED-NEXT:   [[AND:%[0-9]+]]:_(s32) = G_AND [[UV]], [[C]]
  ; UNPACKED-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; UNPACKED-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 16
  ; UNPACKED-NEXT:   [[SHL:%[0-9]+]]:_(s32) = G_SHL [[C1]], [[C2]](s32)
  ; UNPACKED-NEXT:   [[OR:%[0-9]+]]:_(s32) = G_OR [[AND]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR]](s32)
  ; UNPACKED-NEXT:   [[OR1:%[0-9]+]]:_(s32) = G_OR [[C1]], [[SHL]]
  ; UNPACKED-NEXT:   [[BITCAST1:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[OR1]](s32)
  ; UNPACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; UNPACKED-NEXT:   $vgpr1 = COPY [[BITCAST1]](<2 x s16>)
  ; UNPACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ;
  ; PACKED-LABEL: name: image_load_tfe_v4f16_dmask_0000
  ; PACKED: bb.1 (%ir-block.0):
  ; PACKED-NEXT:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr0, $vgpr1
  ; PACKED-NEXT: {{  $}}
  ; PACKED-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $sgpr2
  ; PACKED-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $sgpr3
  ; PACKED-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $sgpr4
  ; PACKED-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $sgpr5
  ; PACKED-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $sgpr6
  ; PACKED-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $sgpr7
  ; PACKED-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $sgpr8
  ; PACKED-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $sgpr9
  ; PACKED-NEXT:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; PACKED-NEXT:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; PACKED-NEXT:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; PACKED-NEXT:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY8]](s32), [[COPY9]](s32)
  ; PACKED-NEXT:   [[AMDGPU_INTRIN_IMAGE_LOAD_D16_:%[0-9]+]]:_(<2 x s32>) = G_AMDGPU_INTRIN_IMAGE_LOAD_D16 intrinsic(@llvm.amdgcn.image.load.2d), 1, [[BUILD_VECTOR1]](<2 x s32>), $noreg, [[BUILD_VECTOR]](<8 x s32>), 1, 0, 0 :: (dereferenceable load (s16), addrspace 8)
  ; PACKED-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[AMDGPU_INTRIN_IMAGE_LOAD_D16_]](<2 x s32>)
  ; PACKED-NEXT:   [[BITCAST:%[0-9]+]]:_(<2 x s16>) = G_BITCAST [[UV]](s32)
  ; PACKED-NEXT:   [[DEF1:%[0-9]+]]:_(<2 x s16>) = G_IMPLICIT_DEF
  ; PACKED-NEXT:   G_STORE [[UV1]](s32), [[DEF]](p1) :: (store (s32) into `ptr addrspace(1) undef`, addrspace 1)
  ; PACKED-NEXT:   $vgpr0 = COPY [[BITCAST]](<2 x s16>)
  ; PACKED-NEXT:   $vgpr1 = COPY [[DEF1]](<2 x s16>)
  ; PACKED-NEXT:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %res = call { <4 x half>, i32 } @llvm.amdgcn.image.load.2d.sl_v4f16i32s.i32(i32 0, i32 %s, i32 %t, <8 x i32> %rsrc, i32 1, i32 0)
  %tex = extractvalue { <4 x half>, i32 } %res, 0
  %tfe = extractvalue { <4 x half>, i32 } %res, 1
  store i32 %tfe, ptr addrspace(1) undef
  ret <4 x half> %tex
}

declare half @llvm.amdgcn.image.load.2d.f16.i32(i32 immarg, i32, i32, <8 x i32>, i32 immarg, i32 immarg) #0
declare <2 x half> @llvm.amdgcn.image.load.2d.v2f16.i32(i32 immarg, i32, i32, <8 x i32>, i32 immarg, i32 immarg) #0
declare <3 x half> @llvm.amdgcn.image.load.2d.v3f16.i32(i32 immarg, i32, i32, <8 x i32>, i32 immarg, i32 immarg) #0
declare <4 x half> @llvm.amdgcn.image.load.2d.v4f16.i32(i32 immarg, i32, i32, <8 x i32>, i32 immarg, i32 immarg) #0
declare { half, i32 } @llvm.amdgcn.image.load.2d.sl_f16i32s.i32(i32 immarg, i32, i32, <8 x i32>, i32 immarg, i32 immarg) #0
declare { <2 x half>, i32 } @llvm.amdgcn.image.load.2d.sl_v2f16i32s.i32(i32 immarg, i32, i32, <8 x i32>, i32 immarg, i32 immarg) #0
declare { <3 x half>, i32 } @llvm.amdgcn.image.load.2d.sl_v3f16i32s.i32(i32 immarg, i32, i32, <8 x i32>, i32 immarg, i32 immarg) #0
declare { <4 x half>, i32 } @llvm.amdgcn.image.load.2d.sl_v4f16i32s.i32(i32 immarg, i32, i32, <8 x i32>, i32 immarg, i32 immarg) #0

attributes #0 = { nounwind readonly }
