; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=sparc | FileCheck %s
; RUN: llc < %s -mtriple=sparcel | FileCheck %s --check-prefix=CHECK-LE

;; Bitcast should not do a runtime conversion, but rather emit a
;; constant into integer registers directly.

define <2 x i32> @bitcast() nounwind {
; CHECK-LABEL: bitcast:
; CHECK:       ! %bb.0:
; CHECK-NEXT:    sethi 1049856, %o0
; CHECK-NEXT:    retl
; CHECK-NEXT:    mov %g0, %o1
;
; CHECK-LE-LABEL: bitcast:
; CHECK-LE:       ! %bb.0:
; CHECK-LE-NEXT:    sethi 1049856, %o1
; CHECK-LE-NEXT:    retl
; CHECK-LE-NEXT:    mov %g0, %o0
  %1 = bitcast double 5.0 to <2 x i32>
  ret <2 x i32> %1
}

;; Same thing for a call using a double (which gets passed in integer
;; registers)

declare void @a(double)
define void @test_call() nounwind {
; CHECK-LABEL: test_call:
; CHECK:       ! %bb.0:
; CHECK-NEXT:    save %sp, -96, %sp
; CHECK-NEXT:    sethi 1049856, %o0
; CHECK-NEXT:    call a
; CHECK-NEXT:    mov %g0, %o1
; CHECK-NEXT:    ret
; CHECK-NEXT:    restore
;
; CHECK-LE-LABEL: test_call:
; CHECK-LE:       ! %bb.0:
; CHECK-LE-NEXT:    save %sp, -96, %sp
; CHECK-LE-NEXT:    sethi 1049856, %o1
; CHECK-LE-NEXT:    call a
; CHECK-LE-NEXT:    mov %g0, %o0
; CHECK-LE-NEXT:    ret
; CHECK-LE-NEXT:    restore
  call void @a(double 5.0)
  ret void
}

;; And for a libcall emitted from the pow intrinsic.  (libcall
;; emission happens after SelectionDAG type legalization, so is a bit
;; different than a normal function call. This was crashing before,
;; due to an earlier broken workaround for this issue.)

declare double @llvm.pow.f64(double, double)
define double @test_intrins_call() nounwind {
; CHECK-LABEL: test_intrins_call:
; CHECK:       ! %bb.0:
; CHECK-NEXT:    save %sp, -96, %sp
; CHECK-NEXT:    sethi 1048576, %o0
; CHECK-NEXT:    mov %g0, %o1
; CHECK-NEXT:    mov %o0, %o2
; CHECK-NEXT:    call pow
; CHECK-NEXT:    mov %g0, %o3
; CHECK-NEXT:    ret
; CHECK-NEXT:    restore
;
; CHECK-LE-LABEL: test_intrins_call:
; CHECK-LE:       ! %bb.0:
; CHECK-LE-NEXT:    save %sp, -96, %sp
; CHECK-LE-NEXT:    sethi 1048576, %o1
; CHECK-LE-NEXT:    mov %g0, %o0
; CHECK-LE-NEXT:    mov %g0, %o2
; CHECK-LE-NEXT:    call pow
; CHECK-LE-NEXT:    mov %o1, %o3
; CHECK-LE-NEXT:    ret
; CHECK-LE-NEXT:    restore
  %1 = call double @llvm.pow.f64(double 2.0, double 2.0)
  ret double %1
}
