; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I

; The stack size is 2048 and the SP adjustment will be split.
define i32 @SplitSP() nounwind {
; RV32I-LABEL: SplitSP:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    addi sp, sp, -2032
; RV32I-NEXT:    sw ra, 2028(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    addi a0, sp, 16
; RV32I-NEXT:    call foo
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    lw ra, 2028(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 2032
; RV32I-NEXT:    ret
entry:
  %xx = alloca [2028 x i8], align 1
  %call = call i32 @foo(ptr nonnull %xx)
  ret i32 0
}

; The stack size is 2032 and the SP adjustment will not be split.
define i32 @NoSplitSP() nounwind {
; RV32I-LABEL: NoSplitSP:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    addi sp, sp, -2032
; RV32I-NEXT:    sw ra, 2028(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a0, sp, 4
; RV32I-NEXT:    call foo
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    lw ra, 2028(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 2032
; RV32I-NEXT:    ret
entry:
  %xx = alloca [2024 x i8], align 1
  %call = call i32 @foo(ptr nonnull %xx)
  ret i32 0
}

declare i32 @foo(ptr)
