; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=loop-vectorize -force-vector-width=4 -force-vector-interleave=1 -S | FileCheck %s


; The vectorizer should refuse to fold the tail by masking because
; %conv is used outside of the loop. Test for this by checking that
; %n.vec, the vector trip count, is rounded down to the next multiple of
; 4. If folding the tail, it would have been rounded up instead.
; Test case for #76069(https://github.com/llvm/llvm-project/issues/76069).
define i32 @test(ptr %arr, i64 %n) {
; CHECK-LABEL: define i32 @test(
; CHECK-SAME: ptr [[ARR:%.*]], i64 [[N:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt i64 [[N]], 1
; CHECK-NEXT:    br i1 [[CMP1]], label [[PREHEADER:%.*]], label [[DONE:%.*]]
; CHECK:       preheader:
; CHECK-NEXT:    [[TMP0:%.*]] = add i64 [[N]], -1
; CHECK-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[TMP0]], 4
; CHECK-NEXT:    br i1 [[MIN_ITERS_CHECK]], label [[SCALAR_PH:%.*]], label [[VECTOR_SCEVCHECK:%.*]]
; CHECK:       vector.scevcheck:
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 [[N]], -2
; CHECK-NEXT:    [[TMP7:%.*]] = trunc i64 [[TMP1]] to i8
; CHECK-NEXT:    [[TMP8:%.*]] = add i8 2, [[TMP7]]
; CHECK-NEXT:    [[TMP9:%.*]] = icmp ult i8 [[TMP8]], 2
; CHECK-NEXT:    [[TMP10:%.*]] = icmp ugt i64 [[TMP1]], 255
; CHECK-NEXT:    [[TMP12:%.*]] = or i1 [[TMP9]], [[TMP10]]
; CHECK-NEXT:    br i1 [[TMP12]], label [[SCALAR_PH]], label [[VECTOR_PH:%.*]]
; CHECK:       vector.ph:
; CHECK-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[TMP0]], 4
; CHECK-NEXT:    [[N_VEC:%.*]] = sub i64 [[TMP0]], [[N_MOD_VF]]
; CHECK-NEXT:    [[IND_END:%.*]] = add i64 1, [[N_VEC]]
; CHECK-NEXT:    [[DOTCAST:%.*]] = trunc i64 [[N_VEC]] to i8
; CHECK-NEXT:    [[IND_END1:%.*]] = add i8 1, [[DOTCAST]]
; CHECK-NEXT:    br label [[VECTOR_BODY:%.*]]
; CHECK:       vector.body:
; CHECK-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[INDEX]]
; CHECK-NEXT:    [[TMP17:%.*]] = add nsw i64 [[OFFSET_IDX]], -1
; CHECK-NEXT:    [[TMP18:%.*]] = getelementptr inbounds i32, ptr [[ARR]], i64 [[TMP17]]
; CHECK-NEXT:    [[TMP19:%.*]] = getelementptr inbounds i32, ptr [[TMP18]], i32 0
; CHECK-NEXT:    store <4 x i32> splat (i32 65), ptr [[TMP19]], align 4
; CHECK-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; CHECK-NEXT:    [[TMP20:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; CHECK-NEXT:    br i1 [[TMP20]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; CHECK:       middle.block:
; CHECK-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[TMP0]], [[N_VEC]]
; CHECK-NEXT:    [[IND_ESCAPE:%.*]] = sub i64 [[IND_END]], 1
; CHECK-NEXT:    br i1 [[CMP_N]], label [[LOAD_VAL:%.*]], label [[SCALAR_PH]]
; CHECK:       scalar.ph:
; CHECK-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[IND_END]], [[MIDDLE_BLOCK]] ], [ 1, [[PREHEADER]] ], [ 1, [[VECTOR_SCEVCHECK]] ]
; CHECK-NEXT:    [[BC_RESUME_VAL2:%.*]] = phi i8 [ [[IND_END1]], [[MIDDLE_BLOCK]] ], [ 1, [[PREHEADER]] ], [ 1, [[VECTOR_SCEVCHECK]] ]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[CONV:%.*]] = phi i64 [ [[CONV2:%.*]], [[LOOP]] ], [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i8 [ [[INC:%.*]], [[LOOP]] ], [ [[BC_RESUME_VAL2]], [[SCALAR_PH]] ]
; CHECK-NEXT:    [[SUB:%.*]] = add nsw i64 [[CONV]], -1
; CHECK-NEXT:    [[PTR:%.*]] = getelementptr inbounds i32, ptr [[ARR]], i64 [[SUB]]
; CHECK-NEXT:    store i32 65, ptr [[PTR]], align 4
; CHECK-NEXT:    [[INC]] = add i8 [[I]], 1
; CHECK-NEXT:    [[CONV2]] = zext i8 [[INC]] to i64
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ult i64 [[CONV2]], [[N]]
; CHECK-NEXT:    br i1 [[CMP2]], label [[LOOP]], label [[LOAD_VAL]], !llvm.loop [[LOOP4:![0-9]+]]
; CHECK:       load_val:
; CHECK-NEXT:    [[FINAL:%.*]] = phi i64 [ [[CONV]], [[LOOP]] ], [ [[IND_ESCAPE]], [[MIDDLE_BLOCK]] ]
; CHECK-NEXT:    [[PTR2:%.*]] = getelementptr inbounds i32, ptr [[ARR]], i64 [[FINAL]]
; CHECK-NEXT:    [[VAL:%.*]] = load i32, ptr [[PTR2]], align 4
; CHECK-NEXT:    br label [[DONE]]
; CHECK:       done:
; CHECK-NEXT:    [[VALUE:%.*]] = phi i32 [ [[VAL]], [[LOAD_VAL]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[VALUE]]
;
entry:
  %cmp1 = icmp ugt i64 %n, 1
  br i1 %cmp1, label %preheader, label %done

preheader:
  br label %loop

loop:
  %conv = phi i64 [ %conv2, %loop ], [ 1, %preheader ]
  %i = phi i8 [ %inc, %loop ], [ 1, %preheader ]
  %sub = add nsw i64 %conv, -1
  %ptr = getelementptr inbounds i32, ptr %arr, i64 %sub
  store i32 65, ptr %ptr, align 4
  %inc = add i8 %i, 1
  %conv2 = zext i8 %inc to i64
  %cmp2 = icmp ult i64 %conv2, %n
  br i1 %cmp2, label %loop, label %load_val, !llvm.loop !0

load_val:
  %final = phi i64 [ %conv, %loop ]
  %ptr2 = getelementptr inbounds i32, ptr %arr, i64 %final
  %val = load i32, ptr %ptr2, align 4
  br label %done

done:
  %value = phi i32 [ %val, %load_val ], [ 0, %entry ]
  ret i32 %value

}

!0 = distinct !{!0, !1, !2, !3}
!1 = !{!"llvm.loop.unroll.disable"}
!2 = !{!"llvm.loop.vectorize.predicate.enable", i1 true}
!3 = !{!"llvm.loop.vectorize.enable", i1 true}
;.
; CHECK: [[LOOP0]] = distinct !{[[LOOP0]], [[META1:![0-9]+]], [[META2:![0-9]+]], [[META3:![0-9]+]]}
; CHECK: [[META1]] = !{!"llvm.loop.unroll.disable"}
; CHECK: [[META2]] = !{!"llvm.loop.isvectorized", i32 1}
; CHECK: [[META3]] = !{!"llvm.loop.unroll.runtime.disable"}
; CHECK: [[LOOP4]] = distinct !{[[LOOP4]], [[META1]], [[META2]]}
;.
