; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=vector-combine -S %s | FileCheck %s

; Negative test for extract + cmp + binop - don't try this with scalable vectors.
; Moved from X86/extract-cmp-binop.ll

define i1 @extract_cmp_binop(<vscale x 4 x i32> %a) {
; CHECK-LABEL: @extract_cmp_binop(
; CHECK-NEXT:    [[E1:%.*]] = extractelement <vscale x 4 x i32> [[A:%.*]], i32 3
; CHECK-NEXT:    [[E2:%.*]] = extractelement <vscale x 4 x i32> [[A]], i32 1
; CHECK-NEXT:    [[CMP1:%.*]] = icmp sgt i32 [[E1]], 42
; CHECK-NEXT:    [[CMP2:%.*]] = icmp sgt i32 [[E2]], -8
; CHECK-NEXT:    [[R:%.*]] = xor i1 [[CMP1]], [[CMP2]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %e1 = extractelement <vscale x 4 x i32> %a, i32 3
  %e2 = extractelement <vscale x 4 x i32> %a, i32 1
  %cmp1 = icmp sgt i32 %e1, 42
  %cmp2 = icmp sgt i32 %e2, -8
  %r = xor i1 %cmp1, %cmp2
  ret i1 %r
}

; Test that VectorCombine doesn't try to create a shufflevector for
; an extract-extract pattern on a scalable vector type.
define i32 @extract_extract(<vscale x 4 x i32> %vec) {
; CHECK-LABEL: @extract_extract(
; CHECK-NEXT:    [[ELT0:%.*]] = extractelement <vscale x 4 x i32> [[VEC:%.*]], i32 0
; CHECK-NEXT:    [[ELT1:%.*]] = extractelement <vscale x 4 x i32> [[VEC]], i32 1
; CHECK-NEXT:    [[IDX:%.*]] = add i32 [[ELT0]], [[ELT1]]
; CHECK-NEXT:    [[ELTIDX:%.*]] = extractelement <vscale x 4 x i32> [[VEC]], i32 [[IDX]]
; CHECK-NEXT:    ret i32 [[ELTIDX]]
;
  %elt0 = extractelement <vscale x 4 x i32> %vec, i32 0
  %elt1 = extractelement <vscale x 4 x i32> %vec, i32 1
  %idx = add i32 %elt0, %elt1
  %eltidx = extractelement <vscale x 4 x i32> %vec, i32 %idx
  ret i32 %eltidx;
}
