; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+zve64d,+f,+d,+zvfh,+zvfbfmin \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv1i8_2t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 2), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv1i8_2t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 2), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv1i8_2t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv1i8_2t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv1i8_2t.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 2), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv1i8_2t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 2), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv1i8_2t.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv1i8_2t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv1i8_2t.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 2), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv1i8_2t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 2), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv1i8_2t.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv1i8_2t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv1i8_2t.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 2), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv1i8_2t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 2), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg2_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv1i8_2t.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg2_mask_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i8_triscv.vector.tuple_nxv1i8_2t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv1i8_2t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_2t(target("riscv.vector.tuple", <vscale x 1 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg2_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg2_mask_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg2_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg2_mask_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg2_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg2_mask_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg2_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg2_mask_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i8_triscv.vector.tuple_nxv2i8_2t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg2_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg2_mask_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg2_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg2_mask_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg2_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg2_mask_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg2_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg2_mask_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i8_triscv.vector.tuple_nxv4i8_2t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 8 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv8i8.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg2_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 8 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg2_mask_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv8i1.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 8 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv8i16.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg2_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 8 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg2_mask_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv8i1.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 8 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv8i32.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg2_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 8 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg2_mask_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv8i1.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 8 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv8i64.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg2_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 8 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg2_mask_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8i8_triscv.vector.tuple_nxv8i8_2t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv8i1.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv16i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 16 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv16i8.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 16 x i8>, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_triscv.vector.tuple_nxv16i8_2t_nxv16i8(ptr %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_triscv.vector.tuple_nxv16i8_2t_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv16i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 16 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_triscv.vector.tuple_nxv16i8_2t_nxv16i8(ptr %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_triscv.vector.tuple_nxv16i8_2t_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv16i1.nxv16i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv16i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 16 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv16i16.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 16 x i16>, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_triscv.vector.tuple_nxv16i8_2t_nxv16i16(ptr %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_triscv.vector.tuple_nxv16i8_2t_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv16i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 16 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_triscv.vector.tuple_nxv16i8_2t_nxv16i16(ptr %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_triscv.vector.tuple_nxv16i8_2t_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv16i1.nxv16i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv16i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 16 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv16i32.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 16 x i32>, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i8> @test_vloxseg2_nxv16i8_triscv.vector.tuple_nxv16i8_2t_nxv16i32(ptr %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i8_triscv.vector.tuple_nxv16i8_2t_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv16i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 16 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg2_mask_nxv16i8_triscv.vector.tuple_nxv16i8_2t_nxv16i32(ptr %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i8_triscv.vector.tuple_nxv16i8_2t_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv16i1.nxv16i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv32i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 32 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv32i8.nxv32i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 32 x i8>, <vscale x 32 x i1>, i64, i64, i64)

define <vscale x 32 x i8> @test_vloxseg2_nxv32i8_triscv.vector.tuple_nxv32i8_2t_nxv32i8(ptr %base, <vscale x 32 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv32i8_triscv.vector.tuple_nxv32i8_2t_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv32i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 32 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 32 x i8> @llvm.riscv.tuple.extract.nxv32i8.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 32 x i8> %1
}

define <vscale x 32 x i8> @test_vloxseg2_mask_nxv32i8_triscv.vector.tuple_nxv32i8_2t_nxv32i8(ptr %base, <vscale x 32 x i8> %index, i64 %vl, <vscale x 32 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv32i8_triscv.vector.tuple_nxv32i8_2t_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv32i1.nxv32i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 32 x i8> %index, <vscale x 32 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 32 x i8> @llvm.riscv.tuple.extract.nxv32i8.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 32 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv32i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 32 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv32i16.nxv32i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 32 x i16>, <vscale x 32 x i1>, i64, i64, i64)

define <vscale x 32 x i8> @test_vloxseg2_nxv32i8_triscv.vector.tuple_nxv32i8_2t_nxv32i16(ptr %base, <vscale x 32 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv32i8_triscv.vector.tuple_nxv32i8_2t_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v16, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv32i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 32 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 32 x i8> @llvm.riscv.tuple.extract.nxv32i8.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 32 x i8> %1
}

define <vscale x 32 x i8> @test_vloxseg2_mask_nxv32i8_triscv.vector.tuple_nxv32i8_2t_nxv32i16(ptr %base, <vscale x 32 x i16> %index, i64 %vl, <vscale x 32 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv32i8_triscv.vector.tuple_nxv32i8_2t_nxv32i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv32i1.nxv32i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 32 x i16> %index, <vscale x 32 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 32 x i8> @llvm.riscv.tuple.extract.nxv32i8.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 32 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv1i8_3t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 3), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv1i8_3t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 3), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv1i8_3t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv1i8_3t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv1i8_3t.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 3), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv1i8_3t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 3), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv1i8_3t.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv1i8_3t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv1i8_3t.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 3), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv1i8_3t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 3), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv1i8_3t.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv1i8_3t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv1i8_3t.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 3), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv1i8_3t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 3), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg3_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv1i8_3t.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg3_mask_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i8_triscv.vector.tuple_nxv1i8_3t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv1i8_3t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_3t(target("riscv.vector.tuple", <vscale x 1 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg3_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg3_mask_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg3_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg3_mask_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg3_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg3_mask_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg3_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg3_mask_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i8_triscv.vector.tuple_nxv2i8_3t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg3_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg3_mask_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg3_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg3_mask_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg3_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg3_mask_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg3_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg3_mask_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i8_triscv.vector.tuple_nxv4i8_3t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 8 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv8i8.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg3_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 8 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg3_mask_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv8i1.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 8 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv8i16.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg3_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 8 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg3_mask_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv8i1.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 8 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv8i32.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg3_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 8 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg3_mask_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv8i1.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 8 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv8i64.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg3_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 8 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg3_mask_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv8i8_triscv.vector.tuple_nxv8i8_3t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv8i1.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv16i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 16 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv16i8.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 16 x i8>, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_triscv.vector.tuple_nxv16i8_3t_nxv16i8(ptr %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_triscv.vector.tuple_nxv16i8_3t_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv16i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 16 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_triscv.vector.tuple_nxv16i8_3t_nxv16i8(ptr %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_triscv.vector.tuple_nxv16i8_3t_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv16i1.nxv16i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv16i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 16 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv16i16.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 16 x i16>, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_triscv.vector.tuple_nxv16i8_3t_nxv16i16(ptr %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_triscv.vector.tuple_nxv16i8_3t_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv16i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 16 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_triscv.vector.tuple_nxv16i8_3t_nxv16i16(ptr %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_triscv.vector.tuple_nxv16i8_3t_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv16i1.nxv16i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv16i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 16 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv16i32.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 16 x i32>, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i8> @test_vloxseg3_nxv16i8_triscv.vector.tuple_nxv16i8_3t_nxv16i32(ptr %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv16i8_triscv.vector.tuple_nxv16i8_3t_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv16i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 16 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg3_mask_nxv16i8_triscv.vector.tuple_nxv16i8_3t_nxv16i32(ptr %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv16i8_triscv.vector.tuple_nxv16i8_3t_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv16i1.nxv16i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv1i8_4t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 4), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv1i8_4t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 4), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv1i8_4t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv1i8_4t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv1i8_4t.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 4), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv1i8_4t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 4), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv1i8_4t.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv1i8_4t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv1i8_4t.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 4), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv1i8_4t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 4), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv1i8_4t.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv1i8_4t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv1i8_4t.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 4), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv1i8_4t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 4), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg4_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv1i8_4t.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg4_mask_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i8_triscv.vector.tuple_nxv1i8_4t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv1i8_4t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_4t(target("riscv.vector.tuple", <vscale x 1 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg4_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg4_mask_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg4_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg4_mask_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg4_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg4_mask_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg4_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg4_mask_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i8_triscv.vector.tuple_nxv2i8_4t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg4_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg4_mask_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg4_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg4_mask_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg4_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg4_mask_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg4_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg4_mask_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i8_triscv.vector.tuple_nxv4i8_4t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 8 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv8i8.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg4_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 8 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg4_mask_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv8i1.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 8 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv8i16.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg4_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 8 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg4_mask_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv8i1.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 8 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv8i32.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg4_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 8 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg4_mask_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv8i1.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 8 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv8i64.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg4_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 8 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg4_mask_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv8i8_triscv.vector.tuple_nxv8i8_4t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv8i1.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv16i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 16 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv16i8.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 16 x i8>, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_triscv.vector.tuple_nxv16i8_4t_nxv16i8(ptr %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_triscv.vector.tuple_nxv16i8_4t_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv16i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 16 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_triscv.vector.tuple_nxv16i8_4t_nxv16i8(ptr %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_triscv.vector.tuple_nxv16i8_4t_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv16i1.nxv16i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv16i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 16 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv16i16.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 16 x i16>, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_triscv.vector.tuple_nxv16i8_4t_nxv16i16(ptr %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_triscv.vector.tuple_nxv16i8_4t_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv16i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 16 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_triscv.vector.tuple_nxv16i8_4t_nxv16i16(ptr %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_triscv.vector.tuple_nxv16i8_4t_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv16i1.nxv16i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv16i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 16 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv16i32.nxv16i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 16 x i32>, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i8> @test_vloxseg4_nxv16i8_triscv.vector.tuple_nxv16i8_4t_nxv16i32(ptr %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv16i8_triscv.vector.tuple_nxv16i8_4t_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv16i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 16 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

define <vscale x 16 x i8> @test_vloxseg4_mask_nxv16i8_triscv.vector.tuple_nxv16i8_4t_nxv16i32(ptr %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv16i8_triscv.vector.tuple_nxv16i8_4t_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv16i1.nxv16i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 16 x i8> @llvm.riscv.tuple.extract.nxv16i8.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 16 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv1i8_5t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 5), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv1i8_5t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 5), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv1i8_5t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv1i8_5t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv1i8_5t.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 5), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv1i8_5t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 5), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv1i8_5t.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv1i8_5t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv1i8_5t.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 5), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv1i8_5t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 5), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv1i8_5t.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv1i8_5t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv1i8_5t.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 5), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv1i8_5t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 5), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg5_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv1i8_5t.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg5_mask_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i8_triscv.vector.tuple_nxv1i8_5t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv1i8_5t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_5t(target("riscv.vector.tuple", <vscale x 1 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg5_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg5_mask_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg5_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg5_mask_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg5_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg5_mask_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg5_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg5_mask_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i8_triscv.vector.tuple_nxv2i8_5t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg5_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg5_mask_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg5_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg5_mask_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg5_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg5_mask_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg5_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg5_mask_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i8_triscv.vector.tuple_nxv4i8_5t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 8 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv8i8.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg5_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 8 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg5_mask_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv8i1.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 8 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv8i16.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg5_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 8 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg5_mask_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv8i1.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 8 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv8i32.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg5_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 8 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg5_mask_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv8i1.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 8 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv8i64.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg5_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 8 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg5_mask_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv8i8_triscv.vector.tuple_nxv8i8_5t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv8i1.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv1i8_6t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 6), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv1i8_6t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 6), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv1i8_6t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv1i8_6t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv1i8_6t.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 6), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv1i8_6t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 6), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv1i8_6t.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv1i8_6t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv1i8_6t.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 6), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv1i8_6t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 6), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv1i8_6t.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv1i8_6t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv1i8_6t.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 6), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv1i8_6t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 6), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg6_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv1i8_6t.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg6_mask_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i8_triscv.vector.tuple_nxv1i8_6t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv1i8_6t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_6t(target("riscv.vector.tuple", <vscale x 1 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg6_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg6_mask_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg6_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg6_mask_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg6_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg6_mask_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg6_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg6_mask_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i8_triscv.vector.tuple_nxv2i8_6t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg6_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg6_mask_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg6_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg6_mask_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg6_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg6_mask_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg6_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg6_mask_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i8_triscv.vector.tuple_nxv4i8_6t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 8 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv8i8.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg6_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 8 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg6_mask_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv8i1.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 8 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv8i16.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg6_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 8 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg6_mask_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv8i1.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 8 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv8i32.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg6_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 8 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg6_mask_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv8i1.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 8 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv8i64.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg6_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 8 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg6_mask_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv8i8_triscv.vector.tuple_nxv8i8_6t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv8i1.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv1i8_7t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 7), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv1i8_7t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 7), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv1i8_7t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv1i8_7t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv1i8_7t.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 7), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv1i8_7t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 7), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv1i8_7t.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv1i8_7t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv1i8_7t.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 7), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv1i8_7t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 7), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv1i8_7t.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv1i8_7t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv1i8_7t.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 7), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv1i8_7t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 7), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg7_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv1i8_7t.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg7_mask_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i8_triscv.vector.tuple_nxv1i8_7t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv1i8_7t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_7t(target("riscv.vector.tuple", <vscale x 1 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg7_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg7_mask_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg7_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg7_mask_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg7_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg7_mask_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg7_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg7_mask_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i8_triscv.vector.tuple_nxv2i8_7t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg7_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg7_mask_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg7_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg7_mask_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg7_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg7_mask_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg7_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg7_mask_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv4i8_triscv.vector.tuple_nxv4i8_7t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 8 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv8i8.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg7_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 8 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg7_mask_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv8i1.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 8 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv8i16.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg7_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 8 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg7_mask_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv8i1.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 8 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv8i32.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg7_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 8 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg7_mask_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv8i1.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 8 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv8i64.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg7_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 8 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg7_mask_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv8i8_triscv.vector.tuple_nxv8i8_7t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv8i1.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv1i8_8t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 8), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv1i8_8t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 8), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv1i8_8t.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv1i8_8t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv1i8_8t.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 8), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv1i8_8t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 8), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv1i8_8t.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv1i8_8t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv1i8_8t.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 8), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv1i8_8t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 8), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv1i8_8t.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv1i8_8t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv1i8_8t.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 8), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv1i8_8t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 1 x i8>, 8), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i8> @test_vloxseg8_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv1i8_8t.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

define <vscale x 1 x i8> @test_vloxseg8_mask_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i8_triscv.vector.tuple_nxv1i8_8t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 1 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv1i8_8t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 1 x i8> @llvm.riscv.tuple.extract.nxv1i8.triscv.vector.tuple_nxv1i8_8t(target("riscv.vector.tuple", <vscale x 1 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg8_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg8_mask_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg8_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg8_mask_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg8_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg8_mask_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i8> @test_vloxseg8_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

define <vscale x 2 x i8> @test_vloxseg8_mask_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i8_triscv.vector.tuple_nxv2i8_8t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 2 x i8> @llvm.riscv.tuple.extract.nxv2i8.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg8_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg8_mask_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg8_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg8_mask_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg8_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg8_mask_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i8> @test_vloxseg8_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

define <vscale x 4 x i8> @test_vloxseg8_mask_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv4i8_triscv.vector.tuple_nxv4i8_8t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 4 x i8> @llvm.riscv.tuple.extract.nxv4i8.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 8 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv8i8.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg8_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 8 x i8> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg8_mask_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv8i1.nxv8i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 8 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv8i16.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg8_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 8 x i16> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg8_mask_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv8i1.nxv8i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 8 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv8i32.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg8_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 8 x i32> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg8_mask_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv8i1.nxv8i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 8 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv8i64.nxv8i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i8> @test_vloxseg8_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 8 x i64> %index, i64 %vl, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

define <vscale x 8 x i8> @test_vloxseg8_mask_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv8i8_triscv.vector.tuple_nxv8i8_8t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v17
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv8i1.nxv8i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 3)
  %1 = call <vscale x 8 x i8> @llvm.riscv.tuple.extract.nxv8i8.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 8 x i8> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg2_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg2_mask_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg2_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg2_mask_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg2_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg2_mask_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 2), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg2_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg2_mask_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i16_triscv.vector.tuple_nxv2i8_2t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg2_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg2_mask_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg2_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg2_mask_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg2_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg2_mask_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg2_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg2_mask_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i16_triscv.vector.tuple_nxv4i8_2t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg2_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg2_mask_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i16_triscv.vector.tuple_nxv8i8_2t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv8i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 8 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i8.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i16> @test_vloxseg2_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei8.v v6, (a0), v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv8i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_vloxseg2_mask_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei8.v v6, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1.nxv8i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 8 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i16.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i16> @test_vloxseg2_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_vloxseg2_mask_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv8i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 8 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i32.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i16> @test_vloxseg2_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv8i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_vloxseg2_mask_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1.nxv8i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv8i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 8 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i64.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i16> @test_vloxseg2_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv8i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_vloxseg2_mask_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8i16_triscv.vector.tuple_nxv16i8_2t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1.nxv8i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv16i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 16 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i8.nxv16i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 16 x i8>, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_triscv.vector.tuple_nxv32i8_2t_nxv16i8(ptr %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_triscv.vector.tuple_nxv32i8_2t_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vloxseg2ei8.v v4, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv16i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 16 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 16 x i16> @llvm.riscv.tuple.extract.nxv16i16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_triscv.vector.tuple_nxv32i8_2t_nxv16i8(ptr %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_triscv.vector.tuple_nxv32i8_2t_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vloxseg2ei8.v v4, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i1.nxv16i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 16 x i16> @llvm.riscv.tuple.extract.nxv16i16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv16i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 16 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i16.nxv16i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 16 x i16>, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_triscv.vector.tuple_nxv32i8_2t_nxv16i16(ptr %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_triscv.vector.tuple_nxv32i8_2t_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv16i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 16 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 16 x i16> @llvm.riscv.tuple.extract.nxv16i16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_triscv.vector.tuple_nxv32i8_2t_nxv16i16(ptr %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_triscv.vector.tuple_nxv32i8_2t_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i1.nxv16i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 16 x i16> @llvm.riscv.tuple.extract.nxv16i16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv16i32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 16 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i32.nxv16i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 16 x i32>, <vscale x 16 x i1>, i64, i64, i64)

define <vscale x 16 x i16> @test_vloxseg2_nxv16i16_triscv.vector.tuple_nxv32i8_2t_nxv16i32(ptr %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16i16_triscv.vector.tuple_nxv32i8_2t_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v16, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv16i32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 16 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 16 x i16> @llvm.riscv.tuple.extract.nxv16i16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x i16> %1
}

define <vscale x 16 x i16> @test_vloxseg2_mask_nxv16i16_triscv.vector.tuple_nxv32i8_2t_nxv16i32(ptr %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16i16_triscv.vector.tuple_nxv32i8_2t_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i1.nxv16i32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 16 x i16> @llvm.riscv.tuple.extract.nxv16i16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg3_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg3_mask_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg3_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg3_mask_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg3_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg3_mask_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 3), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg3_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg3_mask_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i16_triscv.vector.tuple_nxv2i8_3t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg3_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg3_mask_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg3_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg3_mask_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg3_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg3_mask_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg3_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg3_mask_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i16_triscv.vector.tuple_nxv4i8_3t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg3_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg3_mask_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i16_triscv.vector.tuple_nxv8i8_3t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv8i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 8 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i8.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i16> @test_vloxseg3_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei8.v v6, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv8i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_vloxseg3_mask_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei8.v v6, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1.nxv8i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 8 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i16.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i16> @test_vloxseg3_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_vloxseg3_mask_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv8i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 8 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i32.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i16> @test_vloxseg3_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv8i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_vloxseg3_mask_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1.nxv8i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv8i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 8 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i64.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i16> @test_vloxseg3_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv8i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_vloxseg3_mask_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv8i16_triscv.vector.tuple_nxv16i8_3t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1.nxv8i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg4_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg4_mask_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg4_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg4_mask_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg4_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg4_mask_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 4), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg4_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg4_mask_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i16_triscv.vector.tuple_nxv2i8_4t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg4_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg4_mask_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg4_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg4_mask_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg4_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg4_mask_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg4_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg4_mask_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i16_triscv.vector.tuple_nxv4i8_4t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg4_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg4_mask_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i16_triscv.vector.tuple_nxv8i8_4t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv8i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 8 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i8.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i16> @test_vloxseg4_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei8.v v6, (a0), v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv8i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_vloxseg4_mask_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei8.v v6, (a0), v14, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1.nxv8i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 8 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i16.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i16> @test_vloxseg4_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_vloxseg4_mask_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv8i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 8 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i32.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i16> @test_vloxseg4_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv8i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_vloxseg4_mask_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1.nxv8i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv8i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 8 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i64.nxv8i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i16> @test_vloxseg4_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv8i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_vloxseg4_mask_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv8i16_triscv.vector.tuple_nxv16i8_4t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1.nxv8i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x i16> @llvm.riscv.tuple.extract.nxv8i16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg5_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg5_mask_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg5_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg5_mask_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg5_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg5_mask_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 5), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg5_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg5_mask_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i16_triscv.vector.tuple_nxv2i8_5t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg5_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg5_mask_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg5_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg5_mask_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg5_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg5_mask_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg5_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg5_mask_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i16_triscv.vector.tuple_nxv4i8_5t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg5_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg5_mask_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4i16_triscv.vector.tuple_nxv8i8_5t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg6_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg6_mask_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg6_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg6_mask_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg6_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg6_mask_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 6), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg6_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg6_mask_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i16_triscv.vector.tuple_nxv2i8_6t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg6_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg6_mask_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg6_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg6_mask_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg6_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg6_mask_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg6_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg6_mask_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i16_triscv.vector.tuple_nxv4i8_6t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg6_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg6_mask_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4i16_triscv.vector.tuple_nxv8i8_6t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg7_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg7_mask_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg7_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg7_mask_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg7_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg7_mask_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 7), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg7_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg7_mask_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i16_triscv.vector.tuple_nxv2i8_7t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg7_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg7_mask_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg7_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg7_mask_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg7_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg7_mask_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg7_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg7_mask_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i16_triscv.vector.tuple_nxv4i8_7t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg7_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg7_mask_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg7_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg7_mask_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg7_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg7_mask_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg7_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg7_mask_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv4i16_triscv.vector.tuple_nxv8i8_7t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg8_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg8_mask_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg8_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg8_mask_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg8_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg8_mask_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 2 x i8>, 8), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i16> @test_vloxseg8_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

define <vscale x 1 x i16> @test_vloxseg8_mask_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i16_triscv.vector.tuple_nxv2i8_8t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x i16> @llvm.riscv.tuple.extract.nxv1i16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg8_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg8_mask_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg8_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg8_mask_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg8_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg8_mask_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i16> @test_vloxseg8_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

define <vscale x 2 x i16> @test_vloxseg8_mask_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i16_triscv.vector.tuple_nxv4i8_8t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x i16> @llvm.riscv.tuple.extract.nxv2i16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg8_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg8_mask_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg8_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg8_mask_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg8_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg8_mask_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i16> @test_vloxseg8_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

define <vscale x 4 x i16> @test_vloxseg8_mask_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv4i16_triscv.vector.tuple_nxv8i8_8t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x i16> @llvm.riscv.tuple.extract.nxv4i16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x i16> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg2_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg2_mask_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg2_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg2_mask_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg2_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg2_mask_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 2), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg2_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg2_mask_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i32_triscv.vector.tuple_nxv4i8_2t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg2_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg2_mask_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i32_triscv.vector.tuple_nxv8i8_2t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv4i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i32> @test_vloxseg2_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei8.v v6, (a0), v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv4i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vloxseg2_mask_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei8.v v6, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv4i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i32> @test_vloxseg2_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei16.v v6, (a0), v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv4i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vloxseg2_mask_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei16.v v6, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i32> @test_vloxseg2_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vloxseg2_mask_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv4i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i32> @test_vloxseg2_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv4i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vloxseg2_mask_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i32_triscv.vector.tuple_nxv16i8_2t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv8i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 8 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i8.nxv8i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 8 x i8>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i32> @test_vloxseg2_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg2ei8.v v4, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv8i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 8 x i32> @llvm.riscv.tuple.extract.nxv8i32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i32> %1
}

define <vscale x 8 x i32> @test_vloxseg2_mask_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg2ei8.v v4, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i1.nxv8i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 8 x i32> @llvm.riscv.tuple.extract.nxv8i32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv8i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 8 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i16.nxv8i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 8 x i16>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i32> @test_vloxseg2_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vloxseg2ei16.v v4, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv8i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 8 x i32> @llvm.riscv.tuple.extract.nxv8i32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i32> %1
}

define <vscale x 8 x i32> @test_vloxseg2_mask_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vloxseg2ei16.v v4, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i1.nxv8i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 8 x i32> @llvm.riscv.tuple.extract.nxv8i32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv8i32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 8 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i32.nxv8i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 8 x i32>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i32> @test_vloxseg2_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv8i32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 8 x i32> @llvm.riscv.tuple.extract.nxv8i32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i32> %1
}

define <vscale x 8 x i32> @test_vloxseg2_mask_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i1.nxv8i32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 8 x i32> @llvm.riscv.tuple.extract.nxv8i32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv8i64(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 8 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i64.nxv8i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 8 x i64>, <vscale x 8 x i1>, i64, i64, i64)

define <vscale x 8 x i32> @test_vloxseg2_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv8i64(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 8 x i32> @llvm.riscv.tuple.extract.nxv8i32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i32> %1
}

define <vscale x 8 x i32> @test_vloxseg2_mask_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8i32_triscv.vector.tuple_nxv32i8_2t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i1.nxv8i64(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 8 x i32> @llvm.riscv.tuple.extract.nxv8i32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg3_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg3_mask_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg3_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg3_mask_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg3_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg3_mask_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 3), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg3_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg3_mask_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i32_triscv.vector.tuple_nxv4i8_3t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg3_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg3_mask_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i32_triscv.vector.tuple_nxv8i8_3t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv4i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i32> @test_vloxseg3_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei8.v v6, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv4i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vloxseg3_mask_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei8.v v6, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv4i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i32> @test_vloxseg3_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei16.v v6, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv4i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vloxseg3_mask_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei16.v v6, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i32> @test_vloxseg3_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vloxseg3_mask_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv4i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i32> @test_vloxseg3_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv4i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vloxseg3_mask_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4i32_triscv.vector.tuple_nxv16i8_3t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg4_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg4_mask_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg4_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg4_mask_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg4_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg4_mask_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 4), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg4_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg4_mask_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i32_triscv.vector.tuple_nxv4i8_4t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg4_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg4_mask_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i32_triscv.vector.tuple_nxv8i8_4t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv4i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i32> @test_vloxseg4_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei8.v v6, (a0), v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv4i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vloxseg4_mask_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei8.v v6, (a0), v14, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv4i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i32> @test_vloxseg4_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei16.v v6, (a0), v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv4i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vloxseg4_mask_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei16.v v6, (a0), v14, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i32> @test_vloxseg4_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vloxseg4_mask_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv4i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i32> @test_vloxseg4_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv4i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

define <vscale x 4 x i32> @test_vloxseg4_mask_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4i32_triscv.vector.tuple_nxv16i8_4t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x i32> @llvm.riscv.tuple.extract.nxv4i32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg5_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg5_mask_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg5_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg5_mask_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg5_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg5_mask_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 5), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg5_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg5_mask_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i32_triscv.vector.tuple_nxv4i8_5t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg5_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg5_mask_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2i32_triscv.vector.tuple_nxv8i8_5t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg6_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg6_mask_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg6_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg6_mask_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg6_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg6_mask_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 6), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg6_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg6_mask_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i32_triscv.vector.tuple_nxv4i8_6t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg6_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg6_mask_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2i32_triscv.vector.tuple_nxv8i8_6t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg7_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg7_mask_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg7_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg7_mask_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg7_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg7_mask_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 7), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg7_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg7_mask_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i32_triscv.vector.tuple_nxv4i8_7t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg7_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg7_mask_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2i32_triscv.vector.tuple_nxv8i8_7t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg8_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg8_mask_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg8_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg8_mask_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg8_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg8_mask_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 4 x i8>, 8), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i32> @test_vloxseg8_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

define <vscale x 1 x i32> @test_vloxseg8_mask_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i32_triscv.vector.tuple_nxv4i8_8t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x i32> @llvm.riscv.tuple.extract.nxv1i32.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i32> @test_vloxseg8_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

define <vscale x 2 x i32> @test_vloxseg8_mask_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2i32_triscv.vector.tuple_nxv8i8_8t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x i32> @llvm.riscv.tuple.extract.nxv2i32.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x i32> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg2_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg2_mask_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg2_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg2_mask_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg2_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg2_mask_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 2), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg2_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg2_mask_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1i64_triscv.vector.tuple_nxv8i8_2t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv2i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i64> @test_vloxseg2_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei8.v v6, (a0), v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv2i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

define <vscale x 2 x i64> @test_vloxseg2_mask_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei8.v v6, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv2i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i64> @test_vloxseg2_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei16.v v6, (a0), v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv2i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

define <vscale x 2 x i64> @test_vloxseg2_mask_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei16.v v6, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv2i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i64> @test_vloxseg2_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei32.v v6, (a0), v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv2i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

define <vscale x 2 x i64> @test_vloxseg2_mask_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei32.v v6, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv2i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 2), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i64> @test_vloxseg2_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv2i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

define <vscale x 2 x i64> @test_vloxseg2_mask_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2i64_triscv.vector.tuple_nxv16i8_2t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv4i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 4 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv4i8.nxv4i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 4 x i8>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i64> @test_vloxseg2_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg2ei8.v v4, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv4i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 6)
  %1 = call <vscale x 4 x i64> @llvm.riscv.tuple.extract.nxv4i64.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i64> %1
}

define <vscale x 4 x i64> @test_vloxseg2_mask_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg2ei8.v v4, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 4 x i64> @llvm.riscv.tuple.extract.nxv4i64.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv4i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 4 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv4i16.nxv4i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 4 x i16>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i64> @test_vloxseg2_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg2ei16.v v4, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv4i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 6)
  %1 = call <vscale x 4 x i64> @llvm.riscv.tuple.extract.nxv4i64.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i64> %1
}

define <vscale x 4 x i64> @test_vloxseg2_mask_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg2ei16.v v4, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 4 x i64> @llvm.riscv.tuple.extract.nxv4i64.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv4i32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 4 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv4i32.nxv4i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 4 x i32>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i64> @test_vloxseg2_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vloxseg2ei32.v v4, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv4i32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 6)
  %1 = call <vscale x 4 x i64> @llvm.riscv.tuple.extract.nxv4i64.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i64> %1
}

define <vscale x 4 x i64> @test_vloxseg2_mask_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vloxseg2ei32.v v4, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 4 x i64> @llvm.riscv.tuple.extract.nxv4i64.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv4i64(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 4 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv4i64.nxv4i1(target("riscv.vector.tuple", <vscale x 32 x i8>, 2), ptr, <vscale x 4 x i64>, <vscale x 4 x i1>, i64, i64, i64)

define <vscale x 4 x i64> @test_vloxseg2_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv4i64(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 6)
  %1 = call <vscale x 4 x i64> @llvm.riscv.tuple.extract.nxv4i64.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i64> %1
}

define <vscale x 4 x i64> @test_vloxseg2_mask_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4i64_triscv.vector.tuple_nxv32i8_2t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 4 x i64> @llvm.riscv.tuple.extract.nxv4i64.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg3_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg3_mask_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg3_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg3_mask_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg3_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg3_mask_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 3), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg3_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg3_mask_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1i64_triscv.vector.tuple_nxv8i8_3t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv2i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i64> @test_vloxseg3_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei8.v v6, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv2i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

define <vscale x 2 x i64> @test_vloxseg3_mask_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei8.v v6, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv2i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i64> @test_vloxseg3_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei16.v v6, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv2i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

define <vscale x 2 x i64> @test_vloxseg3_mask_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei16.v v6, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv2i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i64> @test_vloxseg3_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei32.v v6, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv2i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

define <vscale x 2 x i64> @test_vloxseg3_mask_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei32.v v6, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv2i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 3), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i64> @test_vloxseg3_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv2i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

define <vscale x 2 x i64> @test_vloxseg3_mask_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2i64_triscv.vector.tuple_nxv16i8_3t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg4_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg4_mask_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg4_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg4_mask_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg4_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg4_mask_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 4), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg4_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg4_mask_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1i64_triscv.vector.tuple_nxv8i8_4t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv2i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 2 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv2i8.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 2 x i8>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i64> @test_vloxseg4_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei8.v v6, (a0), v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv2i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

define <vscale x 2 x i64> @test_vloxseg4_mask_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei8.v v6, (a0), v14, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv2i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 2 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv2i16.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 2 x i16>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i64> @test_vloxseg4_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei16.v v6, (a0), v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv2i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

define <vscale x 2 x i64> @test_vloxseg4_mask_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei16.v v6, (a0), v14, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv2i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 2 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv2i32.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 2 x i32>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i64> @test_vloxseg4_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei32.v v6, (a0), v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv2i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

define <vscale x 2 x i64> @test_vloxseg4_mask_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei32.v v6, (a0), v14, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv2i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 2 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv2i64.nxv2i1(target("riscv.vector.tuple", <vscale x 16 x i8>, 4), ptr, <vscale x 2 x i64>, <vscale x 2 x i1>, i64, i64, i64)

define <vscale x 2 x i64> @test_vloxseg4_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv2i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

define <vscale x 2 x i64> @test_vloxseg4_mask_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2i64_triscv.vector.tuple_nxv16i8_4t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 2 x i64> @llvm.riscv.tuple.extract.nxv2i64.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg5_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg5_mask_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg5_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg5_mask_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg5_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg5_mask_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 5), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg5_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg5_mask_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1i64_triscv.vector.tuple_nxv8i8_5t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg6_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg6_mask_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg6_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg6_mask_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg6_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg6_mask_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 6), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg6_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg6_mask_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1i64_triscv.vector.tuple_nxv8i8_6t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg7_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg7_mask_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg7_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg7_mask_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg7_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg7_mask_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 7), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg7_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg7_mask_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1i64_triscv.vector.tuple_nxv8i8_7t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 1 x i8>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv1i8.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 1 x i8>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg8_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg8_mask_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 1 x i16>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv1i16.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 1 x i16>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg8_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg8_mask_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 1 x i32>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv1i32.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 1 x i32>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg8_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg8_mask_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 1 x i64>, i64, i64)
declare target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv1i64.nxv1i1(target("riscv.vector.tuple", <vscale x 8 x i8>, 8), ptr, <vscale x 1 x i64>, <vscale x 1 x i1>, i64, i64, i64)

define <vscale x 1 x i64> @test_vloxseg8_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i64> %1
}

define <vscale x 1 x i64> @test_vloxseg8_mask_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1i64_triscv.vector.tuple_nxv8i8_8t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 6)
  %1 = call <vscale x 1 x i64> @llvm.riscv.tuple.extract.nxv1i64.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x i64> %1
}


define <vscale x 1 x half> @test_vloxseg2_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg2_mask_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg2_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg2_mask_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg2_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg2_mask_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg2_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv2i8_2t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg2_mask_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1f16_triscv.vector.tuple_nxv2i8_2t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv2i8_2t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_2t(target("riscv.vector.tuple", <vscale x 2 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 2 x half> @test_vloxseg2_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg2_mask_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg2_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg2_mask_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg2_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg2_mask_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg2_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg2_mask_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2f16_triscv.vector.tuple_nxv4i8_2t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 4 x half> @test_vloxseg2_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg2_mask_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg2_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg2_mask_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg2_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg2_mask_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg2_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg2_mask_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4f16_triscv.vector.tuple_nxv8i8_2t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 8 x half> @test_vloxseg2_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei8.v v6, (a0), v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv8i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x half> %1
}

define <vscale x 8 x half> @test_vloxseg2_mask_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei8.v v6, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1.nxv8i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x half> %1
}


define <vscale x 8 x half> @test_vloxseg2_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x half> %1
}

define <vscale x 8 x half> @test_vloxseg2_mask_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x half> %1
}


define <vscale x 8 x half> @test_vloxseg2_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv8i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x half> %1
}

define <vscale x 8 x half> @test_vloxseg2_mask_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1.nxv8i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x half> %1
}


define <vscale x 8 x half> @test_vloxseg2_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv8i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x half> %1
}

define <vscale x 8 x half> @test_vloxseg2_mask_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8f16_triscv.vector.tuple_nxv16i8_2t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv8i1.nxv8i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x half> %1
}


define <vscale x 16 x half> @test_vloxseg2_nxv16f16_triscv.vector.tuple_nxv32i8_2t_nxv16i8(ptr %base, <vscale x 16 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16f16_triscv.vector.tuple_nxv32i8_2t_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vloxseg2ei8.v v4, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv16i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 16 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 16 x half> @llvm.riscv.tuple.extract.nxv16f16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x half> %1
}

define <vscale x 16 x half> @test_vloxseg2_mask_nxv16f16_triscv.vector.tuple_nxv32i8_2t_nxv16i8(ptr %base, <vscale x 16 x i8> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16f16_triscv.vector.tuple_nxv32i8_2t_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vloxseg2ei8.v v4, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i1.nxv16i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 16 x i8> %index, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 16 x half> @llvm.riscv.tuple.extract.nxv16f16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x half> %1
}


define <vscale x 16 x half> @test_vloxseg2_nxv16f16_triscv.vector.tuple_nxv32i8_2t_nxv16i16(ptr %base, <vscale x 16 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16f16_triscv.vector.tuple_nxv32i8_2t_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv16i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 16 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 16 x half> @llvm.riscv.tuple.extract.nxv16f16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x half> %1
}

define <vscale x 16 x half> @test_vloxseg2_mask_nxv16f16_triscv.vector.tuple_nxv32i8_2t_nxv16i16(ptr %base, <vscale x 16 x i16> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16f16_triscv.vector.tuple_nxv32i8_2t_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i1.nxv16i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 16 x i16> %index, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 16 x half> @llvm.riscv.tuple.extract.nxv16f16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x half> %1
}


define <vscale x 16 x half> @test_vloxseg2_nxv16f16_triscv.vector.tuple_nxv32i8_2t_nxv16i32(ptr %base, <vscale x 16 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv16f16_triscv.vector.tuple_nxv32i8_2t_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v16, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv16i32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 16 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 16 x half> @llvm.riscv.tuple.extract.nxv16f16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x half> %1
}

define <vscale x 16 x half> @test_vloxseg2_mask_nxv16f16_triscv.vector.tuple_nxv32i8_2t_nxv16i32(ptr %base, <vscale x 16 x i32> %index, i64 %vl, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv16f16_triscv.vector.tuple_nxv32i8_2t_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv16i1.nxv16i32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 16 x i32> %index, <vscale x 16 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 16 x half> @llvm.riscv.tuple.extract.nxv16f16.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 16 x half> %1
}


define <vscale x 1 x half> @test_vloxseg3_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg3_mask_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg3_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg3_mask_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg3_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg3_mask_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg3_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv2i8_3t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg3_mask_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1f16_triscv.vector.tuple_nxv2i8_3t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv2i8_3t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_3t(target("riscv.vector.tuple", <vscale x 2 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 2 x half> @test_vloxseg3_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg3_mask_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg3_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg3_mask_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg3_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg3_mask_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg3_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg3_mask_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2f16_triscv.vector.tuple_nxv4i8_3t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 4 x half> @test_vloxseg3_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg3_mask_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg3_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg3_mask_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg3_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg3_mask_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg3_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg3_mask_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4f16_triscv.vector.tuple_nxv8i8_3t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 8 x half> @test_vloxseg3_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei8.v v6, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv8i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x half> %1
}

define <vscale x 8 x half> @test_vloxseg3_mask_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei8.v v6, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1.nxv8i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x half> %1
}


define <vscale x 8 x half> @test_vloxseg3_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x half> %1
}

define <vscale x 8 x half> @test_vloxseg3_mask_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x half> %1
}


define <vscale x 8 x half> @test_vloxseg3_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv8i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x half> %1
}

define <vscale x 8 x half> @test_vloxseg3_mask_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1.nxv8i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x half> %1
}


define <vscale x 8 x half> @test_vloxseg3_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv8i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x half> %1
}

define <vscale x 8 x half> @test_vloxseg3_mask_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv8f16_triscv.vector.tuple_nxv16i8_3t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv8i1.nxv8i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 8 x half> %1
}


define <vscale x 1 x half> @test_vloxseg4_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg4_mask_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg4_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg4_mask_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg4_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg4_mask_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg4_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv2i8_4t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg4_mask_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1f16_triscv.vector.tuple_nxv2i8_4t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv2i8_4t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_4t(target("riscv.vector.tuple", <vscale x 2 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 2 x half> @test_vloxseg4_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg4_mask_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg4_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg4_mask_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg4_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg4_mask_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg4_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg4_mask_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2f16_triscv.vector.tuple_nxv4i8_4t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 4 x half> @test_vloxseg4_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg4_mask_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg4_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg4_mask_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg4_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg4_mask_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg4_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg4_mask_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4f16_triscv.vector.tuple_nxv8i8_4t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 8 x half> @test_vloxseg4_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei8.v v6, (a0), v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv8i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x half> %1
}

define <vscale x 8 x half> @test_vloxseg4_mask_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei8.v v6, (a0), v14, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1.nxv8i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x half> %1
}


define <vscale x 8 x half> @test_vloxseg4_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x half> %1
}

define <vscale x 8 x half> @test_vloxseg4_mask_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1.nxv8i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x half> %1
}


define <vscale x 8 x half> @test_vloxseg4_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv8i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x half> %1
}

define <vscale x 8 x half> @test_vloxseg4_mask_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1.nxv8i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x half> %1
}


define <vscale x 8 x half> @test_vloxseg4_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv8i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x half> %1
}

define <vscale x 8 x half> @test_vloxseg4_mask_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv8f16_triscv.vector.tuple_nxv16i8_4t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv8i1.nxv8i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 8 x half> @llvm.riscv.tuple.extract.nxv8f16.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 8 x half> %1
}


define <vscale x 1 x half> @test_vloxseg5_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg5_mask_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg5_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg5_mask_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg5_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg5_mask_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg5_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv2i8_5t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg5_mask_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1f16_triscv.vector.tuple_nxv2i8_5t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv2i8_5t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_5t(target("riscv.vector.tuple", <vscale x 2 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 2 x half> @test_vloxseg5_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg5_mask_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg5_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg5_mask_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg5_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg5_mask_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg5_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg5_mask_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2f16_triscv.vector.tuple_nxv4i8_5t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 4 x half> @test_vloxseg5_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg5_mask_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg5_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg5_mask_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg5_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg5_mask_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg5_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg5_mask_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv4f16_triscv.vector.tuple_nxv8i8_5t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 1 x half> @test_vloxseg6_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg6_mask_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg6_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg6_mask_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg6_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg6_mask_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg6_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv2i8_6t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg6_mask_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1f16_triscv.vector.tuple_nxv2i8_6t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv2i8_6t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_6t(target("riscv.vector.tuple", <vscale x 2 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 2 x half> @test_vloxseg6_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg6_mask_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg6_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg6_mask_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg6_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg6_mask_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg6_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg6_mask_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv2f16_triscv.vector.tuple_nxv4i8_6t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 4 x half> @test_vloxseg6_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg6_mask_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg6_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg6_mask_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg6_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg6_mask_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg6_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv8i8_6t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg6_mask_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv4f16_triscv.vector.tuple_nxv8i8_6t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg6ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv8i8_6t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_6t(target("riscv.vector.tuple", <vscale x 8 x i8>, 6) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 1 x half> @test_vloxseg7_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg7_mask_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg7_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg7_mask_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg7_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg7_mask_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg7_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv2i8_7t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg7_mask_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv1f16_triscv.vector.tuple_nxv2i8_7t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv2i8_7t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_7t(target("riscv.vector.tuple", <vscale x 2 x i8>, 7) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 2 x half> @test_vloxseg7_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg7_mask_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg7_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg7_mask_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg7_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg7_mask_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg7_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv4i8_7t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg7_mask_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv2f16_triscv.vector.tuple_nxv4i8_7t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv4i8_7t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_7t(target("riscv.vector.tuple", <vscale x 4 x i8>, 7) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 4 x half> @test_vloxseg7_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg7_mask_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg7_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg7_mask_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg7_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg7_mask_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg7_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg7_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.triscv.vector.tuple_nxv8i8_7t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg7_mask_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg7_mask_nxv4f16_triscv.vector.tuple_nxv8i8_7t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg7ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 7) @llvm.riscv.vloxseg7.mask.triscv.vector.tuple_nxv8i8_7t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_7t(target("riscv.vector.tuple", <vscale x 8 x i8>, 7) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 1 x half> @test_vloxseg8_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg8_mask_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg8_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg8_mask_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg8_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg8_mask_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 1 x half> @test_vloxseg8_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv2i8_8t.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x half> %1
}

define <vscale x 1 x half> @test_vloxseg8_mask_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv1f16_triscv.vector.tuple_nxv2i8_8t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 2 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv2i8_8t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 1 x half> @llvm.riscv.tuple.extract.nxv1f16.triscv.vector.tuple_nxv2i8_8t(target("riscv.vector.tuple", <vscale x 2 x i8>, 8) %0, i32 1)
  ret <vscale x 1 x half> %1
}


define <vscale x 2 x half> @test_vloxseg8_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg8_mask_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg8_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg8_mask_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg8_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg8_mask_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 2 x half> @test_vloxseg8_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv4i8_8t.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x half> %1
}

define <vscale x 2 x half> @test_vloxseg8_mask_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv2f16_triscv.vector.tuple_nxv4i8_8t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv4i8_8t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 2 x half> @llvm.riscv.tuple.extract.nxv2f16.triscv.vector.tuple_nxv4i8_8t(target("riscv.vector.tuple", <vscale x 4 x i8>, 8) %0, i32 1)
  ret <vscale x 2 x half> %1
}


define <vscale x 4 x half> @test_vloxseg8_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg8_mask_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg8_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg8_mask_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg8_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg8_mask_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 4 x half> @test_vloxseg8_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg8_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.triscv.vector.tuple_nxv8i8_8t.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x half> %1
}

define <vscale x 4 x half> @test_vloxseg8_mask_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg8_mask_nxv4f16_triscv.vector.tuple_nxv8i8_8t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vloxseg8ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v13
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 8) @llvm.riscv.vloxseg8.mask.triscv.vector.tuple_nxv8i8_8t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 4)
  %1 = call <vscale x 4 x half> @llvm.riscv.tuple.extract.nxv4f16.triscv.vector.tuple_nxv8i8_8t(target("riscv.vector.tuple", <vscale x 8 x i8>, 8) %0, i32 1)
  ret <vscale x 4 x half> %1
}


define <vscale x 1 x float> @test_vloxseg2_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg2_mask_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 1 x float> @test_vloxseg2_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg2_mask_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 1 x float> @test_vloxseg2_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg2_mask_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 1 x float> @test_vloxseg2_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv4i8_2t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg2_mask_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv1f32_triscv.vector.tuple_nxv4i8_2t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv4i8_2t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_2t(target("riscv.vector.tuple", <vscale x 4 x i8>, 2) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 2 x float> @test_vloxseg2_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg2_mask_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 2 x float> @test_vloxseg2_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg2_mask_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 2 x float> @test_vloxseg2_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg2_mask_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 2 x float> @test_vloxseg2_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv8i8_2t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg2_mask_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv2f32_triscv.vector.tuple_nxv8i8_2t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv8i8_2t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_2t(target("riscv.vector.tuple", <vscale x 8 x i8>, 2) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 4 x float> @test_vloxseg2_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei8.v v6, (a0), v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv4i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x float> %1
}

define <vscale x 4 x float> @test_vloxseg2_mask_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei8.v v6, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x float> %1
}


define <vscale x 4 x float> @test_vloxseg2_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei16.v v6, (a0), v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv4i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x float> %1
}

define <vscale x 4 x float> @test_vloxseg2_mask_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vloxseg2ei16.v v6, (a0), v10, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x float> %1
}


define <vscale x 4 x float> @test_vloxseg2_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x float> %1
}

define <vscale x 4 x float> @test_vloxseg2_mask_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x float> %1
}


define <vscale x 4 x float> @test_vloxseg2_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv16i8_2t.nxv4i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x float> %1
}

define <vscale x 4 x float> @test_vloxseg2_mask_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv4f32_triscv.vector.tuple_nxv16i8_2t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv16i8_2t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_2t(target("riscv.vector.tuple", <vscale x 16 x i8>, 2) %0, i32 1)
  ret <vscale x 4 x float> %1
}


define <vscale x 8 x float> @test_vloxseg2_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg2ei8.v v4, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv8i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 8 x float> @llvm.riscv.tuple.extract.nxv8f32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x float> %1
}

define <vscale x 8 x float> @test_vloxseg2_mask_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i8(ptr %base, <vscale x 8 x i8> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg2ei8.v v4, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i1.nxv8i8(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i8> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 8 x float> @llvm.riscv.tuple.extract.nxv8f32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x float> %1
}


define <vscale x 8 x float> @test_vloxseg2_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vloxseg2ei16.v v4, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv8i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 8 x float> @llvm.riscv.tuple.extract.nxv8f32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x float> %1
}

define <vscale x 8 x float> @test_vloxseg2_mask_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i16(ptr %base, <vscale x 8 x i16> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vloxseg2ei16.v v4, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i1.nxv8i16(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i16> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 8 x float> @llvm.riscv.tuple.extract.nxv8f32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x float> %1
}


define <vscale x 8 x float> @test_vloxseg2_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv8i32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 8 x float> @llvm.riscv.tuple.extract.nxv8f32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x float> %1
}

define <vscale x 8 x float> @test_vloxseg2_mask_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i32(ptr %base, <vscale x 8 x i32> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei32.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i1.nxv8i32(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i32> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 8 x float> @llvm.riscv.tuple.extract.nxv8f32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x float> %1
}


define <vscale x 8 x float> @test_vloxseg2_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg2_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v16, (a0), v8
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.triscv.vector.tuple_nxv32i8_2t.nxv8i64(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 8 x float> @llvm.riscv.tuple.extract.nxv8f32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x float> %1
}

define <vscale x 8 x float> @test_vloxseg2_mask_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i64(ptr %base, <vscale x 8 x i64> %index, i64 %vl, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: test_vloxseg2_mask_nxv8f32_triscv.vector.tuple_nxv32i8_2t_nxv8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vloxseg2ei64.v v16, (a0), v8, v0.t
; CHECK-NEXT:    vmv4r.v v8, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 32 x i8>, 2) @llvm.riscv.vloxseg2.mask.triscv.vector.tuple_nxv32i8_2t.nxv8i1.nxv8i64(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) undef, ptr %base, <vscale x 8 x i64> %index, <vscale x 8 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 8 x float> @llvm.riscv.tuple.extract.nxv8f32.triscv.vector.tuple_nxv32i8_2t(target("riscv.vector.tuple", <vscale x 32 x i8>, 2) %0, i32 1)
  ret <vscale x 8 x float> %1
}


define <vscale x 1 x float> @test_vloxseg3_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg3_mask_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 1 x float> @test_vloxseg3_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg3_mask_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 1 x float> @test_vloxseg3_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg3_mask_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 1 x float> @test_vloxseg3_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv4i8_3t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg3_mask_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv1f32_triscv.vector.tuple_nxv4i8_3t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv4i8_3t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_3t(target("riscv.vector.tuple", <vscale x 4 x i8>, 3) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 2 x float> @test_vloxseg3_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg3_mask_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 2 x float> @test_vloxseg3_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg3_mask_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 2 x float> @test_vloxseg3_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg3_mask_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 2 x float> @test_vloxseg3_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv8i8_3t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg3_mask_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv2f32_triscv.vector.tuple_nxv8i8_3t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv8i8_3t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_3t(target("riscv.vector.tuple", <vscale x 8 x i8>, 3) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 4 x float> @test_vloxseg3_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei8.v v6, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv4i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x float> %1
}

define <vscale x 4 x float> @test_vloxseg3_mask_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei8.v v6, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x float> %1
}


define <vscale x 4 x float> @test_vloxseg3_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei16.v v6, (a0), v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv4i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x float> %1
}

define <vscale x 4 x float> @test_vloxseg3_mask_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vloxseg3ei16.v v6, (a0), v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x float> %1
}


define <vscale x 4 x float> @test_vloxseg3_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x float> %1
}

define <vscale x 4 x float> @test_vloxseg3_mask_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x float> %1
}


define <vscale x 4 x float> @test_vloxseg3_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg3_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.triscv.vector.tuple_nxv16i8_3t.nxv4i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x float> %1
}

define <vscale x 4 x float> @test_vloxseg3_mask_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg3_mask_nxv4f32_triscv.vector.tuple_nxv16i8_3t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg3ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 3) @llvm.riscv.vloxseg3.mask.triscv.vector.tuple_nxv16i8_3t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_3t(target("riscv.vector.tuple", <vscale x 16 x i8>, 3) %0, i32 1)
  ret <vscale x 4 x float> %1
}


define <vscale x 1 x float> @test_vloxseg4_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg4_mask_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 1 x float> @test_vloxseg4_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg4_mask_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 1 x float> @test_vloxseg4_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg4_mask_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 1 x float> @test_vloxseg4_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv4i8_4t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg4_mask_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv1f32_triscv.vector.tuple_nxv4i8_4t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv4i8_4t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_4t(target("riscv.vector.tuple", <vscale x 4 x i8>, 4) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 2 x float> @test_vloxseg4_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg4_mask_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 2 x float> @test_vloxseg4_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg4_mask_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 2 x float> @test_vloxseg4_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg4_mask_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 2 x float> @test_vloxseg4_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv8i8_4t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg4_mask_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv2f32_triscv.vector.tuple_nxv8i8_4t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv8i8_4t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_4t(target("riscv.vector.tuple", <vscale x 8 x i8>, 4) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 4 x float> @test_vloxseg4_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei8.v v6, (a0), v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv4i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x float> %1
}

define <vscale x 4 x float> @test_vloxseg4_mask_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i8(ptr %base, <vscale x 4 x i8> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei8.v v6, (a0), v14, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i1.nxv4i8(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i8> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x float> %1
}


define <vscale x 4 x float> @test_vloxseg4_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei16.v v6, (a0), v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv4i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x float> %1
}

define <vscale x 4 x float> @test_vloxseg4_mask_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i16(ptr %base, <vscale x 4 x i16> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vloxseg4ei16.v v6, (a0), v14, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i1.nxv4i16(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i16> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x float> %1
}


define <vscale x 4 x float> @test_vloxseg4_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x float> %1
}

define <vscale x 4 x float> @test_vloxseg4_mask_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i32(ptr %base, <vscale x 4 x i32> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei32.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i1.nxv4i32(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i32> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x float> %1
}


define <vscale x 4 x float> @test_vloxseg4_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg4_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v12, (a0), v8
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.triscv.vector.tuple_nxv16i8_4t.nxv4i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x float> %1
}

define <vscale x 4 x float> @test_vloxseg4_mask_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i64(ptr %base, <vscale x 4 x i64> %index, i64 %vl, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: test_vloxseg4_mask_nxv4f32_triscv.vector.tuple_nxv16i8_4t_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vloxseg4ei64.v v12, (a0), v8, v0.t
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 16 x i8>, 4) @llvm.riscv.vloxseg4.mask.triscv.vector.tuple_nxv16i8_4t.nxv4i1.nxv4i64(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) undef, ptr %base, <vscale x 4 x i64> %index, <vscale x 4 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 4 x float> @llvm.riscv.tuple.extract.nxv4f32.triscv.vector.tuple_nxv16i8_4t(target("riscv.vector.tuple", <vscale x 16 x i8>, 4) %0, i32 1)
  ret <vscale x 4 x float> %1
}


define <vscale x 1 x float> @test_vloxseg5_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg5_mask_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 1 x float> @test_vloxseg5_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg5_mask_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i1.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i16> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 1 x float> @test_vloxseg5_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg5_mask_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i32(ptr %base, <vscale x 1 x i32> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i1.nxv1i32(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i32> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 1 x float> @test_vloxseg5_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv4i8_5t.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg5_mask_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i64(ptr %base, <vscale x 1 x i64> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv1f32_triscv.vector.tuple_nxv4i8_5t_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv4i8_5t.nxv1i1.nxv1i64(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) undef, ptr %base, <vscale x 1 x i64> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_5t(target("riscv.vector.tuple", <vscale x 4 x i8>, 5) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 2 x float> @test_vloxseg5_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg5_mask_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i8(ptr %base, <vscale x 2 x i8> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i1.nxv2i8(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i8> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 2 x float> @test_vloxseg5_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg5_mask_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i16(ptr %base, <vscale x 2 x i16> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei16.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i1.nxv2i16(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i16> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 2 x float> @test_vloxseg5_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i32> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg5_mask_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i32(ptr %base, <vscale x 2 x i32> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei32.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i1.nxv2i32(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i32> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 2 x float> @test_vloxseg5_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg5_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v10, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.triscv.vector.tuple_nxv8i8_5t.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i64> %index, i64 %vl, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x float> %1
}

define <vscale x 2 x float> @test_vloxseg5_mask_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i64(ptr %base, <vscale x 2 x i64> %index, i64 %vl, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: test_vloxseg5_mask_nxv2f32_triscv.vector.tuple_nxv8i8_5t_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vloxseg5ei64.v v10, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 8 x i8>, 5) @llvm.riscv.vloxseg5.mask.triscv.vector.tuple_nxv8i8_5t.nxv2i1.nxv2i64(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) undef, ptr %base, <vscale x 2 x i64> %index, <vscale x 2 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 2 x float> @llvm.riscv.tuple.extract.nxv2f32.triscv.vector.tuple_nxv8i8_5t(target("riscv.vector.tuple", <vscale x 8 x i8>, 5) %0, i32 1)
  ret <vscale x 2 x float> %1
}


define <vscale x 1 x float> @test_vloxseg6_nxv1f32_triscv.vector.tuple_nxv4i8_6t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1f32_triscv.vector.tuple_nxv4i8_6t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 1 x i8> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg6_mask_nxv1f32_triscv.vector.tuple_nxv4i8_6t_nxv1i8(ptr %base, <vscale x 1 x i8> %index, i64 %vl, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: test_vloxseg6_mask_nxv1f32_triscv.vector.tuple_nxv4i8_6t_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei8.v v9, (a0), v8, v0.t
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.mask.triscv.vector.tuple_nxv4i8_6t.nxv1i1.nxv1i8(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 1 x i8> %index, <vscale x 1 x i1> %mask, i64 %vl, i64 1, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x float> %1
}


define <vscale x 1 x float> @test_vloxseg6_nxv1f32_triscv.vector.tuple_nxv4i8_6t_nxv1i16(ptr %base, <vscale x 1 x i16> %index, i64 %vl) {
; CHECK-LABEL: test_vloxseg6_nxv1f32_triscv.vector.tuple_nxv4i8_6t_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vloxseg6ei16.v v9, (a0), v8
; CHECK-NEXT:    vmv1r.v v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call target("riscv.vector.tuple", <vscale x 4 x i8>, 6) @llvm.riscv.vloxseg6.triscv.vector.tuple_nxv4i8_6t.nxv1i16(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) undef, ptr %base, <vscale x 1 x i16> %index, i64 %vl, i64 5)
  %1 = call <vscale x 1 x float> @llvm.riscv.tuple.extract.nxv1f32.triscv.vector.tuple_nxv4i8_6t(target("riscv.vector.tuple", <vscale x 4 x i8>, 6) %0, i32 1)
  ret <vscale x 1 x float> %1
}

define <vscale x 1 x float> @test_vloxseg6_mask_nxv