; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare void @use64(i64)
declare void @llvm.assume(i1)

define i1 @mul_unkV_oddC_eq(i32 %v) {
; CHECK-LABEL: @mul_unkV_oddC_eq(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[V:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %mul = mul i32 %v, 3
  %cmp = icmp eq i32 %mul, 0
  ret i1 %cmp
}

define i1 @mul_unkV_oddC_eq_nonzero(i32 %v) {
; CHECK-LABEL: @mul_unkV_oddC_eq_nonzero(
; CHECK-NEXT:    [[MUL:%.*]] = mul i32 [[V:%.*]], 3
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[MUL]], 4
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %mul = mul i32 %v, 3
  %cmp = icmp eq i32 %mul, 4
  ret i1 %cmp
}

define <2 x i1> @mul_unkV_oddC_ne_vec(<2 x i64> %v) {
; CHECK-LABEL: @mul_unkV_oddC_ne_vec(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i64> [[V:%.*]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %mul = mul <2 x i64> %v, <i64 3, i64 3>
  %cmp = icmp ne <2 x i64> %mul, <i64 0, i64 0>
  ret <2 x i1> %cmp
}

define i1 @mul_assumeoddV_asumeoddV_eq(i16 %v, i16 %v2) {
; CHECK-LABEL: @mul_assumeoddV_asumeoddV_eq(
; CHECK-NEXT:    [[LB:%.*]] = and i16 [[V:%.*]], 1
; CHECK-NEXT:    [[ODD:%.*]] = icmp ne i16 [[LB]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[ODD]])
; CHECK-NEXT:    [[LB2:%.*]] = and i16 [[V2:%.*]], 1
; CHECK-NEXT:    [[ODD2:%.*]] = icmp ne i16 [[LB2]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[ODD2]])
; CHECK-NEXT:    ret i1 true
;
  %lb = and i16 %v, 1
  %odd = icmp ne i16 %lb, 0
  call void @llvm.assume(i1 %odd)
  %lb2 = and i16 %v2, 1
  %odd2 = icmp ne i16 %lb2, 0
  call void @llvm.assume(i1 %odd2)
  %mul = mul i16 %v, %v2
  %cmp = icmp ne i16 %mul, 0
  ret i1 %cmp
}

define i1 @mul_unkV_oddC_sge(i8 %v) {
; CHECK-LABEL: @mul_unkV_oddC_sge(
; CHECK-NEXT:    [[MUL:%.*]] = mul i8 [[V:%.*]], 3
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[MUL]], -1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %mul = mul i8 %v, 3
  %cmp = icmp sge i8 %mul, 0
  ret i1 %cmp
}

define i1 @mul_reused_unkV_oddC_ne(i64 %v) {
; CHECK-LABEL: @mul_reused_unkV_oddC_ne(
; CHECK-NEXT:    [[MUL:%.*]] = mul i64 [[V:%.*]], 3
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i64 [[V]], 0
; CHECK-NEXT:    call void @use64(i64 [[MUL]])
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %mul = mul i64 %v, 3
  %cmp = icmp ne i64 %mul, 0
  call void @use64(i64 %mul)
  ret i1 %cmp
}

define i1 @mul_assumeoddV_unkV_eq(i16 %v, i16 %v2) {
; CHECK-LABEL: @mul_assumeoddV_unkV_eq(
; CHECK-NEXT:    [[LB:%.*]] = and i16 [[V2:%.*]], 1
; CHECK-NEXT:    [[ODD:%.*]] = icmp ne i16 [[LB]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[ODD]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i16 [[V:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lb = and i16 %v2, 1
  %odd = icmp eq i16 %lb, 1
  call void @llvm.assume(i1 %odd)
  %mul = mul i16 %v, %v2
  %cmp = icmp eq i16 %mul, 0
  ret i1 %cmp
}

define i1 @mul_reusedassumeoddV_unkV_ne(i64 %v, i64 %v2) {
; CHECK-LABEL: @mul_reusedassumeoddV_unkV_ne(
; CHECK-NEXT:    [[LB:%.*]] = and i64 [[V:%.*]], 1
; CHECK-NEXT:    [[ODD:%.*]] = icmp ne i64 [[LB]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[ODD]])
; CHECK-NEXT:    [[MUL:%.*]] = mul i64 [[V]], [[V2:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i64 [[V2]], 0
; CHECK-NEXT:    call void @use64(i64 [[MUL]])
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %lb = and i64 %v, 1
  %odd = icmp ne i64 %lb, 0
  call void @llvm.assume(i1 %odd)
  %mul = mul i64 %v, %v2
  %cmp = icmp ne i64 %mul, 0
  call void @use64(i64 %mul)
  ret i1 %cmp
}

define <2 x i1> @mul_setoddV_unkV_ne(<2 x i32> %v1, <2 x i32> %v2) {
; CHECK-LABEL: @mul_setoddV_unkV_ne(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i32> [[V2:%.*]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %v = or <2 x i32> %v1, <i32 1, i32 1>
  %mul = mul <2 x i32> %v, %v2
  %cmp = icmp ne <2 x i32> %mul, <i32 0, i32 0>
  ret <2 x i1> %cmp
}

define i1 @mul_broddV_unkV_eq(i16 %v, i16 %v2) {
; CHECK-LABEL: @mul_broddV_unkV_eq(
; CHECK-NEXT:    [[LB:%.*]] = and i16 [[V2:%.*]], 1
; CHECK-NEXT:    [[ODD_NOT:%.*]] = icmp eq i16 [[LB]], 0
; CHECK-NEXT:    br i1 [[ODD_NOT]], label [[FALSE:%.*]], label [[TRUE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i16 [[V:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
; CHECK:       false:
; CHECK-NEXT:    call void @use64(i16 [[V]])
; CHECK-NEXT:    ret i1 false
;
  %lb = and i16 %v2, 1
  %odd = icmp eq i16 %lb, 1
  br i1 %odd, label %true, label %false
true:
  %mul = mul i16 %v, %v2
  %cmp = icmp eq i16 %mul, 0
  ret i1 %cmp
false:
  call void @use64(i16 %v)
  ret i1 false
}

define i1 @mul_unkV_evenC_ne(i64 %v) {
; CHECK-LABEL: @mul_unkV_evenC_ne(
; CHECK-NEXT:    [[MUL_MASK:%.*]] = and i64 [[V:%.*]], 4611686018427387903
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i64 [[MUL_MASK]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %mul = mul i64 %v, 4
  %cmp = icmp ne i64 %mul, 0
  ret i1 %cmp
}

define i1 @mul_assumenzV_asumenzV_eq(i64 %v, i64 %v2) {
; CHECK-LABEL: @mul_assumenzV_asumenzV_eq(
; CHECK-NEXT:    [[NZ:%.*]] = icmp ne i64 [[V:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[NZ]])
; CHECK-NEXT:    [[NZ2:%.*]] = icmp ne i64 [[V2:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[NZ2]])
; CHECK-NEXT:    [[MUL:%.*]] = mul i64 [[V]], [[V2]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[MUL]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %nz = icmp ne i64 %v, 0
  call void @llvm.assume(i1 %nz)
  %nz2 = icmp ne i64 %v2, 0
  call void @llvm.assume(i1 %nz2)
  %mul = mul i64 %v, %v2
  %cmp = icmp eq i64 %mul, 0
  ret i1 %cmp
}

define i1 @mul_assumenzV_unkV_nsw_ne(i32 %v, i32 %v2) {
; CHECK-LABEL: @mul_assumenzV_unkV_nsw_ne(
; CHECK-NEXT:    [[NZ:%.*]] = icmp ne i32 [[V:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[NZ]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[V2:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %nz = icmp ne i32 %v, 0
  call void @llvm.assume(i1 %nz)
  %mul = mul nsw i32 %v, %v2
  %cmp = icmp ne i32 %mul, 0
  ret i1 %cmp
}

define i1 @mul_selectnzV_unkV_nsw_ne(i8 %v, i8 %v2) {
; CHECK-LABEL: @mul_selectnzV_unkV_nsw_ne(
; CHECK-NEXT:    [[NZ:%.*]] = icmp ne i8 [[V:%.*]], 0
; CHECK-NEXT:    [[MUL:%.*]] = mul nsw i8 [[V]], [[V2:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i8 [[MUL]], 0
; CHECK-NEXT:    [[R:%.*]] = select i1 [[NZ]], i1 [[CMP]], i1 false
; CHECK-NEXT:    ret i1 [[R]]
;
  %nz = icmp ne i8 %v, 0
  %mul = mul nsw i8 %v, %v2
  %cmp = icmp ne i8 %mul, 0
  %r = select i1 %nz, i1 %cmp, i1 false
  ret i1 %r
}

define <2 x i1> @mul_unkV_unkV_nsw_nuw_ne(<2 x i16> %v, <2 x i16> %v2) {
; CHECK-LABEL: @mul_unkV_unkV_nsw_nuw_ne(
; CHECK-NEXT:    [[MUL:%.*]] = mul nuw nsw <2 x i16> [[V:%.*]], [[V2:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <2 x i16> [[MUL]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %mul = mul nuw nsw <2 x i16> %v, %v2
  %cmp = icmp ne <2 x i16> %mul, <i16 0, i16 0>
  ret <2 x i1> %cmp
}

define i1 @mul_setnzV_unkV_nuw_eq(i8 %v1, i8 %v2) {
; CHECK-LABEL: @mul_setnzV_unkV_nuw_eq(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[V2:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %v = or i8 %v1, 2
  %mul = mul nuw i8 %v, %v2
  %cmp = icmp eq i8 %mul, 0
  ret i1 %cmp
}

define i1 @mul_brnzV_unkV_nuw_eq(i64 %v, i64 %v2) {
; CHECK-LABEL: @mul_brnzV_unkV_nuw_eq(
; CHECK-NEXT:    [[NZ_NOT:%.*]] = icmp eq i64 [[V2:%.*]], 0
; CHECK-NEXT:    br i1 [[NZ_NOT]], label [[FALSE:%.*]], label [[TRUE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[V:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
; CHECK:       false:
; CHECK-NEXT:    call void @use64(i64 [[V]])
; CHECK-NEXT:    ret i1 false
;
  %nz = icmp ne i64 %v2, 0
  br i1 %nz, label %true, label %false
true:
  %mul = mul nuw i64 %v, %v2
  %cmp = icmp eq i64 %mul, 0
  ret i1 %cmp
false:
  call void @use64(i64 %v)
  ret i1 false
}

define i1 @test_icmp_sgt_and_negpow2_zero(i32 %add) {
; CHECK-LABEL: @test_icmp_sgt_and_negpow2_zero(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[ADD:%.*]], 7
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %and = and i32 %add, -8
  %cmp = icmp sgt i32 %and, 0
  ret i1 %cmp
}

define i1 @test_icmp_slt_and_negpow2_one(i32 %add) {
; CHECK-LABEL: @test_icmp_slt_and_negpow2_one(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[ADD:%.*]], 8
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %and = and i32 %add, -8
  %cmp = icmp slt i32 %and, 1
  ret i1 %cmp
}

define i1 @test_icmp_sgt_and_negpow2_nonzero(i32 %add) {
; CHECK-LABEL: @test_icmp_sgt_and_negpow2_nonzero(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[ADD:%.*]], -8
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[AND]], -2
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %and = and i32 %add, -8
  %cmp = icmp sgt i32 %and, -2
  ret i1 %cmp
}

define i1 @test_icmp_sgt_and_nonnegpow2_zero(i32 %add) {
; CHECK-LABEL: @test_icmp_sgt_and_nonnegpow2_zero(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[ADD:%.*]], 8
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[AND]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %and = and i32 %add, 8
  %cmp = icmp sgt i32 %and, 0
  ret i1 %cmp
}

define i1 @test_icmp_ult_and_negpow2_one(i32 %add) {
; CHECK-LABEL: @test_icmp_ult_and_negpow2_one(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[ADD:%.*]], 8
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %and = and i32 %add, -8
  %cmp = icmp ult i32 %and, 1
  ret i1 %cmp
}

define i1 @test_imply_dom_condition(i32 %add) {
; CHECK-LABEL: @test_imply_dom_condition(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[ADD:%.*]], 7
; CHECK-NEXT:    tail call void @llvm.assume(i1 [[CMP]])
; CHECK-NEXT:    ret i1 false
;
  %and = and i32 %add, -8
  %cmp = icmp sgt i32 %and, 0
  tail call void @llvm.assume(i1 %cmp)
  %min.iters.check = icmp ult i32 %and, 8
  ret i1 %min.iters.check
}

define i1 @test_icmp_slt_and_negpow2_c(i32 %add) {
; CHECK-LABEL: @test_icmp_slt_and_negpow2_c(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[ADD:%.*]], 32
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %and = and i32 %add, -32
  %cmp = icmp slt i32 %and, 16
  ret i1 %cmp
}

define i1 @test_icmp_slt_and_negpow2_invalid_c(i32 %add) {
; CHECK-LABEL: @test_icmp_slt_and_negpow2_invalid_c(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[ADD:%.*]], -32
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[AND]], 48
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %and = and i32 %add, -32
  %cmp = icmp slt i32 %and, 48
  ret i1 %cmp
}

define i1 @test_icmp_sgt_and_negpow2_c(i32 %add) {
; CHECK-LABEL: @test_icmp_sgt_and_negpow2_c(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[ADD:%.*]], 31
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %and = and i32 %add, -32
  %cmp = icmp sgt i32 %and, 16
  ret i1 %cmp
}

define i1 @test_icmp_sgt_and_negpow2_invalid_c(i32 %add) {
; CHECK-LABEL: @test_icmp_sgt_and_negpow2_invalid_c(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[ADD:%.*]], -32
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[AND]], 48
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %and = and i32 %add, -32
  %cmp = icmp sgt i32 %and, 48
  ret i1 %cmp
}

define i1 @icmp_eq_or_of_selects_with_constant(i1 %a, i1 %b) {
; CHECK-LABEL: @icmp_eq_or_of_selects_with_constant(
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %s1 = select i1 %a, i64 65536, i64 0
  %s2 = select i1 %b, i64 256, i64 0
  %or = or i64 %s1, %s2
  %cmp = icmp eq i64 %or, 65792
  ret i1 %cmp
}

define i1 @icmp_slt_and_of_selects_with_constant(i1 %a, i1 %b) {
; CHECK-LABEL: @icmp_slt_and_of_selects_with_constant(
; CHECK-NEXT:    [[TMP1:%.*]] = or i1 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = xor i1 [[TMP1]], true
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %s1 = select i1 %a, i8 1, i8 254
  %s2 = select i1 %b, i8 1, i8 253
  %and = and i8 %s1, %s2
  %cmp = icmp slt i8 %and, 254
  ret i1 %cmp
}

define i1 @icmp_sge_add_of_selects_with_constant(i1 %a, i1 %b) {
; CHECK-LABEL: @icmp_sge_add_of_selects_with_constant(
; CHECK-NEXT:    ret i1 true
;
  %s1 = select i1 %a, i8 248, i8 7
  %s2 = select i1 %b, i8 16, i8 0
  %add = add i8 %s1, %s2
  %cmp = icmp sge i8 %add, 247
  ret i1 %cmp
}

define i1 @icmp_eq_or_of_selects_with_constant_multiuse_foldable(i1 %a, i1 %b) {
; CHECK-LABEL: @icmp_eq_or_of_selects_with_constant_multiuse_foldable(
; CHECK-NEXT:    [[S1:%.*]] = select i1 [[A:%.*]], i64 65536, i64 0
; CHECK-NEXT:    [[S2:%.*]] = select i1 [[B:%.*]], i64 256, i64 0
; CHECK-NEXT:    [[OR:%.*]] = or disjoint i64 [[S1]], [[S2]]
; CHECK-NEXT:    call void @use64(i64 [[OR]])
; CHECK-NEXT:    [[CMP:%.*]] = and i1 [[A]], [[B]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %s1 = select i1 %a, i64 65536, i64 0
  %s2 = select i1 %b, i64 256, i64 0
  %or = or i64 %s1, %s2
  call void @use64(i64 %or)
  %cmp = icmp eq i64 %or, 65792
  ret i1 %cmp
}

define <2 x i1> @icmp_eq_or_of_selects_with_constant_vectorized(<2 x i1> %a, <2 x i1> %b) {
; CHECK-LABEL: @icmp_eq_or_of_selects_with_constant_vectorized(
; CHECK-NEXT:    [[CMP:%.*]] = and <2 x i1> [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %s1 = select <2 x i1> %a, <2 x i64> <i64 65536, i64 65536>, <2 x i64> zeroinitializer
  %s2 = select <2 x i1> %b, <2 x i64> <i64 256, i64 256>, <2 x i64> zeroinitializer
  %or = or <2 x i64> %s1, %s2
  %cmp = icmp eq <2 x i64> %or, <i64 65792, i64 65792>
  ret <2 x i1> %cmp
}

define <2 x i1> @icmp_eq_or_of_selects_with_scalar_cond_constant_vectorized(i1 %a, i1 %b) {
; CHECK-LABEL: @icmp_eq_or_of_selects_with_scalar_cond_constant_vectorized(
; CHECK-NEXT:    [[S1:%.*]] = select i1 [[A:%.*]], <2 x i64> splat (i64 65536), <2 x i64> zeroinitializer
; CHECK-NEXT:    [[S2:%.*]] = select i1 [[B:%.*]], <2 x i64> splat (i64 256), <2 x i64> zeroinitializer
; CHECK-NEXT:    [[OR:%.*]] = or disjoint <2 x i64> [[S1]], [[S2]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i64> [[OR]], splat (i64 65792)
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %s1 = select i1 %a, <2 x i64> <i64 65536, i64 65536>, <2 x i64> zeroinitializer
  %s2 = select i1 %b, <2 x i64> <i64 256, i64 256>, <2 x i64> zeroinitializer
  %or  = or <2 x i64> %s1, %s2
  %cmp = icmp eq <2 x i64> %or, <i64 65792, i64 65792>
  ret <2 x i1> %cmp
}

; Negative tests.
define i1 @icmp_eq_or_of_selects_with_constant_and_arg(i1 %a, i1 %b, i64 %arg) {
; CHECK-LABEL: @icmp_eq_or_of_selects_with_constant_and_arg(
; CHECK-NEXT:    [[S1:%.*]] = select i1 [[A:%.*]], i64 65536, i64 [[ARG:%.*]]
; CHECK-NEXT:    [[S2:%.*]] = select i1 [[B:%.*]], i64 256, i64 0
; CHECK-NEXT:    [[OR:%.*]] = or i64 [[S1]], [[S2]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[OR]], 65792
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %s1 = select i1 %a, i64 65536, i64 %arg
  %s2 = select i1 %b, i64 256, i64 0
  %or = or i64 %s1, %s2
  %cmp = icmp eq i64 %or, 65792
  ret i1 %cmp
}

define i1 @icmp_eq_or_of_selects_with_constant_multiuse(i1 %a, i1 %b) {
; CHECK-LABEL: @icmp_eq_or_of_selects_with_constant_multiuse(
; CHECK-NEXT:    [[S1:%.*]] = select i1 [[A:%.*]], i64 0, i64 65536
; CHECK-NEXT:    [[S2:%.*]] = select i1 [[B:%.*]], i64 0, i64 256
; CHECK-NEXT:    [[OR:%.*]] = or disjoint i64 [[S1]], [[S2]]
; CHECK-NEXT:    call void @use64(i64 [[OR]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[OR]], 65792
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %s1 = select i1 %a, i64 0, i64 65536
  %s2 = select i1 %b, i64 0, i64 256
  %or = or i64 %s1, %s2
  call void @use64(i64 %or)
  %cmp = icmp eq i64 %or, 65792
  ret i1 %cmp
}

define <2 x i1> @icmp_eq_or_of_selects_with_constant_vectorized_nonsplat(<2 x i1> %a, <2 x i1> %b) {
; CHECK-LABEL: @icmp_eq_or_of_selects_with_constant_vectorized_nonsplat(
; CHECK-NEXT:    [[S1:%.*]] = select <2 x i1> [[A:%.*]], <2 x i64> splat (i64 65536), <2 x i64> zeroinitializer
; CHECK-NEXT:    [[S2:%.*]] = select <2 x i1> [[B:%.*]], <2 x i64> <i64 256, i64 128>, <2 x i64> zeroinitializer
; CHECK-NEXT:    [[OR:%.*]] = or disjoint <2 x i64> [[S1]], [[S2]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq <2 x i64> [[OR]], <i64 65792, i64 65664>
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %s1 = select <2 x i1> %a, <2 x i64> <i64 65536, i64 65536>, <2 x i64> zeroinitializer
  %s2 = select <2 x i1> %b, <2 x i64> <i64 256, i64 128>, <2 x i64> zeroinitializer
  %or = or <2 x i64> %s1, %s2
  %cmp = icmp eq <2 x i64> %or, <i64 65792, i64 65664>
  ret <2 x i1> %cmp
}
