; Check the memd loads are generated by HexagonLoadStoreWidening pass
; Check that memw loads from adjacent memory location are replaced with memd,
; though the load/stores alias with instructions that occur later in the block.
; The order of memory operations remains unchanged.

; RUN: llc -mtriple=hexagon -verify-machineinstrs < %s | FileCheck %s

target triple = "hexagon"

; CHECK-LABEL: load_store_interleaved:
; CHECK: r{{[0-9]+}}:{{[0-9]+}} = memd(r{{[0-9]+}}+#0)
; CHECK: memd(r{{[0-9]+}}+#0) = r{{[0-9]+}}:{{[0-9]+}}
; Function Attrs: mustprogress nounwind
define linkonce_odr dso_local void @load_store_interleaved(ptr %p, float %a, float %b) local_unnamed_addr {
entry:
  %0 = load float, ptr %p, align 8
  %add0 = fadd float %0, %a
  store float %add0, ptr %p, align 8
  %q = getelementptr i8, ptr %p, i32 4
  %1 = load float, ptr %q, align 4
  %add1 = fadd float %1, %b
  store float %add1, ptr %q, align 4
  ret void
}

; Store can be widened here, but this order of instructions is not currently handled
; CHECK-LABEL: loads_between_stores:
; CHECK: r{{[0-9]+}}:{{[0-9]+}} = memd(r{{[0-9]+}}+#0)
; CHECK-NOT: memd(r{{[0-9]+}}+#4) = r{{[0-9]+}}:{{[0-9]+}}
; Function Attrs: mustprogress nounwind
define linkonce_odr dso_local void @loads_between_stores(ptr %p, float %a, float %b) local_unnamed_addr {
entry:
  %add0 = fadd float %b, %a
  %q = getelementptr i8, ptr %p, i32 4
  %r = getelementptr i8, ptr %p, i32 8
  store float %add0, ptr %r, align 4
  %0 = load float, ptr %p, align 8
  %1 = load float, ptr %q, align 4
  %add1 = fadd float %1, %0
  store float %add1, ptr %q, align 8
  ret void
}

; CHECK-LABEL: loads_before_stores:
; CHECK: r{{[0-9]+}}:{{[0-9]+}} = memd(r{{[0-9]+}}+#0)
; CHECK: memd(r{{[0-9]+}}+#0) = r{{[0-9]+}}:{{[0-9]+}}
; Function Attrs: mustprogress nounwind
define linkonce_odr dso_local void @loads_before_stores(ptr %p, float %a, float %b) local_unnamed_addr {
entry:
  %0 = load float, ptr %p, align 8
  %q = getelementptr i8, ptr %p, i32 4
  %1 = load float, ptr %q, align 4
  %add0 = fadd float %0, %a
  store float %add0, ptr %p, align 8
  %add1 = fadd float %1, %b
  store float %add1, ptr %q, align 4
  ret void
}

; Store can be widened here, but this order of instructions is not currently handled
; CHECK-LABEL: store_load_interleaved:
; CHECK: r{{[0-9]+}}:{{[0-9]+}} = memd(r{{[0-9]+}}+#0)
; CHECK-NOT: memd(r{{[0-9]+}}+#0) = r{{[0-9]+}}:{{[0-9]+}}
; Function Attrs: mustprogress nounwind
define linkonce_odr dso_local void @store_load_interleaved(ptr %p, float %a, float %b, float %f) local_unnamed_addr {
entry:
  %q = getelementptr i8, ptr %p, i32 4
  %r = getelementptr i8, ptr %p, i32 8
  store float %f, ptr %r, align 4
  %0 = load float, ptr %p, align 8
  %add0 = fadd float %0, %a
  store float %add0, ptr %p, align 8
  %1 = load float, ptr %q, align 4
  %add1 = fadd float %1, %b
  %add2 = fadd float %add1, %add0
  store float %add2, ptr %q, align 8
  ret void
}

; CHECK-LABEL: stores_between_loads:
; CHECK-NOT: r{{[0-9]+}}:{{[0-9]+}} = memd(r{{[0-9]+}}+#0)
; CHECK: memd(r{{[0-9]+}}+#0) = r{{[0-9]+}}:{{[0-9]+}}
; Function Attrs: mustprogress nounwind
define linkonce_odr dso_local void @stores_between_loads(ptr %p, float %a, float %b, float %f) local_unnamed_addr {
entry:
  %0 = load float, ptr %p, align 8
  %add0 = fadd float %f, %0
  store float %add0, ptr %p, align 8
  %q = getelementptr i8, ptr %p, i32 4
  %add1 = fadd float %f, %b
  store float %add1, ptr %q, align 8
  %r = getelementptr i8, ptr %p, i32 8
  %1 = load float, ptr %r, align 4
  %add2 = fadd float %add1, %1
  store float %add2, ptr %r, align 4
  ret void
}
