; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=mips -relocation-model=static | \
; RUN: FileCheck %s -check-prefix=STATIC-O32
; RUN: llc < %s -mtriple=mips -relocation-model=pic | \
; RUN: FileCheck %s -check-prefix=PIC-O32
; RUN: llc < %s -mtriple=mips64 -relocation-model=pic -mcpu=mips4 | \
; RUN:     FileCheck %s -check-prefix=PIC-N64
; RUN: llc < %s -mtriple=mips64 -relocation-model=static -mcpu=mips4 | \
; RUN:     FileCheck %s -check-prefix=STATIC-N64
; RUN: llc < %s -mtriple=mips64 -relocation-model=pic -mcpu=mips64 | \
; RUN:     FileCheck %s -check-prefix=PIC-N64
; RUN: llc < %s -mtriple=mips64 -relocation-model=static -mcpu=mips64 | \
; RUN:     FileCheck %s -check-prefix=STATIC-N64

define i32 @main() nounwind readnone {
; STATIC-O32-LABEL: main:
; STATIC-O32:       # %bb.0: # %entry
; STATIC-O32-NEXT:    addiu $sp, $sp, -8
; STATIC-O32-NEXT:    addiu $1, $zero, 2
; STATIC-O32-NEXT:    sw $1, 4($sp)
; STATIC-O32-NEXT:    lw $2, 4($sp)
; STATIC-O32-NEXT:    sltiu $1, $2, 4
; STATIC-O32-NEXT:    beqz $1, $BB0_6
; STATIC-O32-NEXT:    nop
; STATIC-O32-NEXT:  # %bb.1: # %entry
; STATIC-O32-NEXT:    sll $1, $2, 2
; STATIC-O32-NEXT:    lui $2, %hi($JTI0_0)
; STATIC-O32-NEXT:    addu $1, $1, $2
; STATIC-O32-NEXT:    lw $1, %lo($JTI0_0)($1)
; STATIC-O32-NEXT:    jr $1
; STATIC-O32-NEXT:    nop
; STATIC-O32-NEXT:  $BB0_2: # %bb5
; STATIC-O32-NEXT:    addiu $2, $zero, 1
; STATIC-O32-NEXT:    jr $ra
; STATIC-O32-NEXT:    addiu $sp, $sp, 8
; STATIC-O32-NEXT:  $BB0_3: # %bb2
; STATIC-O32-NEXT:    addiu $2, $zero, 0
; STATIC-O32-NEXT:    jr $ra
; STATIC-O32-NEXT:    addiu $sp, $sp, 8
; STATIC-O32-NEXT:  $BB0_4: # %bb3
; STATIC-O32-NEXT:    addiu $2, $zero, 3
; STATIC-O32-NEXT:    jr $ra
; STATIC-O32-NEXT:    addiu $sp, $sp, 8
; STATIC-O32-NEXT:  $BB0_5: # %bb1
; STATIC-O32-NEXT:    addiu $2, $zero, 2
; STATIC-O32-NEXT:    jr $ra
; STATIC-O32-NEXT:    addiu $sp, $sp, 8
; STATIC-O32-NEXT:  $BB0_6: # %bb4
; STATIC-O32-NEXT:    addiu $2, $zero, 4
; STATIC-O32-NEXT:    jr $ra
; STATIC-O32-NEXT:    addiu $sp, $sp, 8
;
; PIC-O32-LABEL: main:
; PIC-O32:       # %bb.0: # %entry
; PIC-O32-NEXT:    lui $2, %hi(_gp_disp)
; PIC-O32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; PIC-O32-NEXT:    addiu $sp, $sp, -8
; PIC-O32-NEXT:    addiu $1, $zero, 2
; PIC-O32-NEXT:    sw $1, 4($sp)
; PIC-O32-NEXT:    lw $3, 4($sp)
; PIC-O32-NEXT:    sltiu $1, $3, 4
; PIC-O32-NEXT:    beqz $1, $BB0_6
; PIC-O32-NEXT:    addu $2, $2, $25
; PIC-O32-NEXT:  # %bb.1: # %entry
; PIC-O32-NEXT:    sll $1, $3, 2
; PIC-O32-NEXT:    lw $3, %got($JTI0_0)($2)
; PIC-O32-NEXT:    addu $1, $1, $3
; PIC-O32-NEXT:    lw $1, %lo($JTI0_0)($1)
; PIC-O32-NEXT:    addu $1, $2, $1
; PIC-O32-NEXT:    jr $1
; PIC-O32-NEXT:    nop
; PIC-O32-NEXT:  $BB0_2: # %bb5
; PIC-O32-NEXT:    addiu $2, $zero, 1
; PIC-O32-NEXT:    jr $ra
; PIC-O32-NEXT:    addiu $sp, $sp, 8
; PIC-O32-NEXT:  $BB0_3: # %bb2
; PIC-O32-NEXT:    addiu $2, $zero, 0
; PIC-O32-NEXT:    jr $ra
; PIC-O32-NEXT:    addiu $sp, $sp, 8
; PIC-O32-NEXT:  $BB0_4: # %bb3
; PIC-O32-NEXT:    addiu $2, $zero, 3
; PIC-O32-NEXT:    jr $ra
; PIC-O32-NEXT:    addiu $sp, $sp, 8
; PIC-O32-NEXT:  $BB0_5: # %bb1
; PIC-O32-NEXT:    addiu $2, $zero, 2
; PIC-O32-NEXT:    jr $ra
; PIC-O32-NEXT:    addiu $sp, $sp, 8
; PIC-O32-NEXT:  $BB0_6: # %bb4
; PIC-O32-NEXT:    addiu $2, $zero, 4
; PIC-O32-NEXT:    jr $ra
; PIC-O32-NEXT:    addiu $sp, $sp, 8
;
; PIC-N64-LABEL: main:
; PIC-N64:       # %bb.0: # %entry
; PIC-N64-NEXT:    daddiu $sp, $sp, -16
; PIC-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(main)))
; PIC-N64-NEXT:    daddu $2, $1, $25
; PIC-N64-NEXT:    addiu $1, $zero, 2
; PIC-N64-NEXT:    sw $1, 12($sp)
; PIC-N64-NEXT:    lw $1, 12($sp)
; PIC-N64-NEXT:    sltiu $4, $1, 4
; PIC-N64-NEXT:    dsll $3, $1, 32
; PIC-N64-NEXT:    beqz $4, .LBB0_6
; PIC-N64-NEXT:    nop
; PIC-N64-NEXT:  # %bb.1: # %entry
; PIC-N64-NEXT:    daddiu $1, $2, %lo(%neg(%gp_rel(main)))
; PIC-N64-NEXT:    dsrl $2, $3, 32
; PIC-N64-NEXT:    dsll $2, $2, 3
; PIC-N64-NEXT:    ld $3, %got_page(.LJTI0_0)($1)
; PIC-N64-NEXT:    daddu $2, $2, $3
; PIC-N64-NEXT:    ld $2, %got_ofst(.LJTI0_0)($2)
; PIC-N64-NEXT:    daddu $1, $1, $2
; PIC-N64-NEXT:    jr $1
; PIC-N64-NEXT:    nop
; PIC-N64-NEXT:  .LBB0_2: # %bb5
; PIC-N64-NEXT:    addiu $2, $zero, 1
; PIC-N64-NEXT:    jr $ra
; PIC-N64-NEXT:    daddiu $sp, $sp, 16
; PIC-N64-NEXT:  .LBB0_3: # %bb2
; PIC-N64-NEXT:    addiu $2, $zero, 0
; PIC-N64-NEXT:    jr $ra
; PIC-N64-NEXT:    daddiu $sp, $sp, 16
; PIC-N64-NEXT:  .LBB0_4: # %bb3
; PIC-N64-NEXT:    addiu $2, $zero, 3
; PIC-N64-NEXT:    jr $ra
; PIC-N64-NEXT:    daddiu $sp, $sp, 16
; PIC-N64-NEXT:  .LBB0_5: # %bb1
; PIC-N64-NEXT:    addiu $2, $zero, 2
; PIC-N64-NEXT:    jr $ra
; PIC-N64-NEXT:    daddiu $sp, $sp, 16
; PIC-N64-NEXT:  .LBB0_6: # %bb4
; PIC-N64-NEXT:    addiu $2, $zero, 4
; PIC-N64-NEXT:    jr $ra
; PIC-N64-NEXT:    daddiu $sp, $sp, 16
;
; STATIC-N64-LABEL: main:
; STATIC-N64:       # %bb.0: # %entry
; STATIC-N64-NEXT:    daddiu $sp, $sp, -16
; STATIC-N64-NEXT:    addiu $1, $zero, 2
; STATIC-N64-NEXT:    sw $1, 12($sp)
; STATIC-N64-NEXT:    lw $1, 12($sp)
; STATIC-N64-NEXT:    sltiu $3, $1, 4
; STATIC-N64-NEXT:    dsll $2, $1, 32
; STATIC-N64-NEXT:    beqz $3, .LBB0_6
; STATIC-N64-NEXT:    nop
; STATIC-N64-NEXT:  # %bb.1: # %entry
; STATIC-N64-NEXT:    dsrl $1, $2, 32
; STATIC-N64-NEXT:    dsll $1, $1, 3
; STATIC-N64-NEXT:    lui $2, %highest(.LJTI0_0)
; STATIC-N64-NEXT:    daddiu $2, $2, %higher(.LJTI0_0)
; STATIC-N64-NEXT:    dsll $2, $2, 16
; STATIC-N64-NEXT:    daddiu $2, $2, %hi(.LJTI0_0)
; STATIC-N64-NEXT:    dsll $2, $2, 16
; STATIC-N64-NEXT:    daddu $1, $1, $2
; STATIC-N64-NEXT:    ld $1, %lo(.LJTI0_0)($1)
; STATIC-N64-NEXT:    jr $1
; STATIC-N64-NEXT:    nop
; STATIC-N64-NEXT:  .LBB0_2: # %bb5
; STATIC-N64-NEXT:    addiu $2, $zero, 1
; STATIC-N64-NEXT:    jr $ra
; STATIC-N64-NEXT:    daddiu $sp, $sp, 16
; STATIC-N64-NEXT:  .LBB0_3: # %bb2
; STATIC-N64-NEXT:    addiu $2, $zero, 0
; STATIC-N64-NEXT:    jr $ra
; STATIC-N64-NEXT:    daddiu $sp, $sp, 16
; STATIC-N64-NEXT:  .LBB0_4: # %bb3
; STATIC-N64-NEXT:    addiu $2, $zero, 3
; STATIC-N64-NEXT:    jr $ra
; STATIC-N64-NEXT:    daddiu $sp, $sp, 16
; STATIC-N64-NEXT:  .LBB0_5: # %bb1
; STATIC-N64-NEXT:    addiu $2, $zero, 2
; STATIC-N64-NEXT:    jr $ra
; STATIC-N64-NEXT:    daddiu $sp, $sp, 16
; STATIC-N64-NEXT:  .LBB0_6: # %bb4
; STATIC-N64-NEXT:    addiu $2, $zero, 4
; STATIC-N64-NEXT:    jr $ra
; STATIC-N64-NEXT:    daddiu $sp, $sp, 16
entry:
  %x = alloca i32, align 4                        ; <ptr> [#uses=2]
  store volatile i32 2, ptr %x, align 4
  %0 = load volatile i32, ptr %x, align 4             ; <i32> [#uses=1]



  switch i32 %0, label %bb4 [
    i32 0, label %bb5
    i32 1, label %bb1
    i32 2, label %bb2
    i32 3, label %bb3
  ]

bb1:                                              ; preds = %entry
  ret i32 2

bb2:                                              ; preds = %entry
  ret i32 0

bb3:                                              ; preds = %entry
  ret i32 3

bb4:                                              ; preds = %entry
  ret i32 4

bb5:                                              ; preds = %entry
  ret i32 1
}
; UTC_ARGS: --disable

; STATIC-O32: .p2align  2
; STATIC-O32: $JTI0_0:
; STATIC-O32: .4byte
; STATIC-O32: .4byte
; STATIC-O32: .4byte
; STATIC-O32: .4byte
; PIC-O32: .p2align  2
; PIC-O32: $JTI0_0:
; PIC-O32: .gpword
; PIC-O32: .gpword
; PIC-O32: .gpword
; PIC-O32: .gpword
; STATIC-N64: .p2align  3
; STATIC-N64: LJTI0_0:
; STATIC-N64: .8byte
; STATIC-N64: .8byte
; STATIC-N64: .8byte
; STATIC-N64: .8byte
; PIC-N64: .p2align  3
; PIC-N64: .LJTI0_0:
; PIC-N64: .gpdword
; PIC-N64: .gpdword
; PIC-N64: .gpdword
; PIC-N64: .gpdword

