; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-uknown-uknown -verify-machineinstrs -o - %s | FileCheck %s

declare void @call()

define i1 @cmp_i128_eq(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    ccmp x1, x3, #0, eq
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
    %cmp = icmp eq i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_ne(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_ne:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    ccmp x1, x3, #0, eq
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
    %cmp = icmp ne i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_ugt(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_ugt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x2, x0
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    cset w0, lo
; CHECK-NEXT:    ret
    %cmp = icmp ugt i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_uge(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_uge:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    sbcs xzr, x1, x3
; CHECK-NEXT:    cset w0, hs
; CHECK-NEXT:    ret
    %cmp = icmp uge i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_ult(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_ult:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    sbcs xzr, x1, x3
; CHECK-NEXT:    cset w0, lo
; CHECK-NEXT:    ret
    %cmp = icmp ult i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_ule(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_ule:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x2, x0
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    cset w0, hs
; CHECK-NEXT:    ret
    %cmp = icmp ule i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_sgt(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_sgt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x2, x0
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    cset w0, lt
; CHECK-NEXT:    ret
    %cmp = icmp sgt i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_sge(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_sge:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    sbcs xzr, x1, x3
; CHECK-NEXT:    cset w0, ge
; CHECK-NEXT:    ret
    %cmp = icmp sge i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_slt(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_slt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    sbcs xzr, x1, x3
; CHECK-NEXT:    cset w0, lt
; CHECK-NEXT:    ret
    %cmp = icmp slt i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_sle(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_sle:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x2, x0
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    cset w0, ge
; CHECK-NEXT:    ret
    %cmp = icmp sle i128 %a, %b
    ret i1 %cmp
}

define void @br_on_cmp_i128_eq(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    ccmp x0, x2, #0, eq
; CHECK-NEXT:    b.ne .LBB10_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB10_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp eq i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_ne(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_ne:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    ccmp x0, x2, #0, eq
; CHECK-NEXT:    b.eq .LBB11_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB11_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp ne i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_ugt(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_ugt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x2, x0
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    b.hs .LBB12_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB12_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp ugt i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_uge(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_uge:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    sbcs xzr, x1, x3
; CHECK-NEXT:    b.lo .LBB13_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB13_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp uge i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_ult(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_ult:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    sbcs xzr, x1, x3
; CHECK-NEXT:    b.hs .LBB14_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB14_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp ult i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_ule(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_ule:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x2, x0
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    b.lo .LBB15_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB15_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp ule i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_sgt(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_sgt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x2, x0
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    b.ge .LBB16_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB16_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp sgt i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_sge(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_sge:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    sbcs xzr, x1, x3
; CHECK-NEXT:    b.lt .LBB17_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB17_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp sge i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_slt(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_slt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    sbcs xzr, x1, x3
; CHECK-NEXT:    b.ge .LBB18_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB18_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp slt i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_sle(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_sle:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x2, x0
; CHECK-NEXT:    sbcs xzr, x3, x1
; CHECK-NEXT:    b.lt .LBB19_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB19_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp sle i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

