

# Operator CRD v2 Reference

Package v2 - This page provides a quick automatically generated
reference for the MinIO Operator `Operator CRD v2 Reference` CRD. For more
complete documentation on the MinIO Operator CRD, see [MinIO Kubernetes
Documentation](https://docs.min.io/community/minio-object-store/operations/deployments/kubernetes.html).  

The `Operator CRD v2 Reference` API was released with the v4.0.0 MinIO Operator.
The MinIO Operator automatically converts existing tenants using the
`/v1` API to `/v2`.  

-   [Tenant](#tenant)

## Bucket

Bucket describes the default created buckets

-   [TenantSpec](#tenantspec)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>name</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>region</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>objectLock</code></strong>
<em>boolean</em></p></td>
<td style="text-align: left;"></td>
</tr>
</tbody>
</table>

## CertificateConfig

CertificateConfig (`certConfig`) defines controlling attributes
associated to any TLS certificate automatically generated by the
Operator as part of tenant creation. These fields have no effect if
`spec.autoCert: false`.

-   [TenantSpec](#tenantspec)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>commonName</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>The <code>CommonName</code> or <code>CN</code> attribute to associate
to automatically generated TLS certificates.<br />
</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>organizationName</code></strong>
<em>string array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify one or more <code>OrganizationName</code> or <code>O</code>
attributes to associate to automatically generated TLS
certificates.<br />
</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>dnsNames</code></strong>
<em>string array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify one or more x.509 Subject Alternative Names (SAN) to
associate to automatically generated TLS certificates. MinIO Server pods
use SNI to determine which certificate to respond with based on the
requested hostname.</p></td>
</tr>
</tbody>
</table>

## CertificateStatus

CertificateStatus keeps track of all the certificates managed by the
operator

-   [TenantStatus](#tenantstatus)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>autoCertEnabled</code></strong>
<em>boolean</em></p></td>
<td style="text-align: left;"><p>AutoCertEnabled registers whether we
know if the tenant has autocert enabled</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>customCertificates</code></strong>
<em><a
href="#customcertificates">CustomCertificates</a></em></p></td>
<td style="text-align: left;"><p>Provides the output of the
<code>client</code>, <code>minio</code>, and`minioCAs` custom TLS
certificates manually added to the Operator.</p></td>
</tr>
</tbody>
</table>

## CustomCertificateConfig

CustomCertificateConfig (`customCertificateConfig`) provides attributes
associated of the TLS certificates manually added to the Operator as
part of tenant creation. These fields contain no data if there are no
custom TLS certificates.

-   [CustomCertificates](#customcertificates)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>certName</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Output one or more <code>CertName</code> attributes associated with
the manually provided TLS certificates.<br />
</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>domains</code></strong>
<em>string array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Output one or more <code>Domains</code> attributes associated with
the manually provided TLS certificates.<br />
</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>expiry</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Output one or more <code>Expiry</code> attributes associated with the
manually provided TLS certificates.<br />
</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>expiresIn</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Output one or more <code>ExpiresIn</code> attributes associated with
the manually provided TLS certificates.<br />
</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>serialNo</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Output one or more <code>SerialNo</code> attributes associated with
the manually provided TLS certificates.<br />
</p></td>
</tr>
</tbody>
</table>

## CustomCertificates

CustomCertificates (`customCertificates`) provides groupings of the TLS
certificates manually added to the Operator as part of tenant creation.
These fields contain no data if there are no custom TLS certificates.

-   [CertificateStatus](#certificatestatus)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>client</code></strong>
<em><a
href="#customcertificateconfig">CustomCertificateConfig</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Client</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>minio</code></strong>
<em><a
href="#customcertificateconfig">CustomCertificateConfig</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Minio</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>minioCAs</code></strong>
<em><a
href="#customcertificateconfig">CustomCertificateConfig</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Certificate Authorities</p></td>
</tr>
</tbody>
</table>

## ExposeServices

ExposeServices (`exposeServices`) defines the exposure of the MinIO
object storage and Console services.  

-   [TenantSpec](#tenantspec)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>minio</code></strong>
<em>boolean</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Directs the Operator to expose the MinIO service. Defaults to
<code>false</code>.<br />
</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>console</code></strong>
<em>boolean</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Directs the Operator to expose the MinIO Console service. Defaults to
<code>false</code>.<br />
</p></td>
</tr>
</tbody>
</table>

## Features

Features (`features`) - Object describing which MinIO features to
enable/disable in the MinIO Tenant.  

-   [TenantSpec](#tenantspec)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>bucketDNS</code></strong>
<em>boolean</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify <code>true</code> to allow clients to access buckets using
the DNS path
<code>&lt;bucket&gt;.minio.default.svc.cluster.local</code>. Defaults to
<code>false</code>.</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>domains</code></strong>
<em><a
href="#tenantdomains">TenantDomains</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify a list of domains used to access MinIO and Console.</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>enableSFTP</code></strong>
<em>boolean</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Starts minio server with SFTP support</p></td>
</tr>
</tbody>
</table>

## HealthStatus (string)

HealthStatus represents whether the tenant is healthy, with decreased
service or offline

-   [TenantStatus](#tenantstatus)

## KESConfig

KESConfig (`kes`) defines the configuration of the [MinIO Key Encryption
Service](https://github.com/minio/kes) (KES) StatefulSet deployed as
part of the MinIO Tenant. KES supports Server-Side Encryption of objects
using an external Key Management Service (KMS).  

-   [TenantSpec](#tenantspec)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>replicas</code></strong>
<em>integer</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify the number of replica KES pods to deploy in the tenant.
Defaults to <code>2</code>.</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>image</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>imagePullPolicy</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#pullpolicy-v1-core">PullPolicy</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>The pull policy for the MinIO Docker image. Specify one of the
following:<br />
</p>
<ul>
<li><p><code>Always</code><br />
</p></li>
<li><p><code>Never</code><br />
</p></li>
<li><p><code>IfNotPresent</code> (Default)<br />
</p></li>
</ul>
<p>Refer to the Kubernetes documentation for details <a
href="https://kubernetes.io/docs/concepts/containers/images#updating-images">https://kubernetes.io/docs/concepts/containers/images#updating-images</a></p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>serviceAccountName</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>The <a
href="https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/">Kubernetes
Service Account</a> to use for running MinIO KES pods created as part of
the Tenant.<br />
</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>kesSecret</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#localobjectreference-v1-core">LocalObjectReference</a></em></p></td>
<td style="text-align: left;"><p><strong>Required</strong><br />
</p>
<p>Specify a <a
href="https://kubernetes.io/docs/concepts/configuration/secret/">Kubernetes
opaque secret</a> which contains environment variables to use for
setting up the MinIO KES service.<br />
</p>
<p>See the <a
href="https://github.com/minio/operator/blob/master/examples/kes-secret.yaml">MinIO
Operator <code>console-secret.yaml</code></a> for an example.</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>externalCertSecret</code></strong>
<em><a
href="#localcertificatereference">LocalCertificateReference</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Enables TLS with SNI support on each MinIO KES pod in the tenant. If
<code>externalCertSecret</code> is omitted <strong>and</strong>
<code>spec.requestAutoCert</code> is set to <code>false</code>, MinIO
KES pods deploy <strong>without</strong> TLS enabled.<br />
</p>
<p>Specify a <a
href="https://kubernetes.io/docs/concepts/configuration/secret/">Kubernetes
TLS secret</a>. The MinIO Operator copies the specified certificate to
every MinIO pod in the tenant. When the MinIO pod/service responds to a
TLS connection request, it uses SNI to select the certificate with
matching <code>subjectAlternativeName</code>.<br />
</p>
<p>Specify an object containing the following fields:<br />
</p>
<ul>
<li><p>- <code>name</code> - The name of the Kubernetes secret
containing the TLS certificate.<br />
</p></li>
<li><p>- <code>type</code> - Specify
<code>kubernetes.io/tls</code><br />
</p></li>
</ul>
<p>See the <a
href="https://docs.min.io/community/minio-object-store/reference/operator-crd.html">MinIO
Operator CRD</a> reference for examples and more complete documentation
on configuring TLS for MinIO Tenants.</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>clientCertSecret</code></strong>
<em><a
href="#localcertificatereference">LocalCertificateReference</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify a a <a
href="https://kubernetes.io/docs/concepts/configuration/secret/">Kubernetes
TLS secret</a> containing a custom root Certificate Authority and x.509
certificate to use for performing mTLS authentication with an external
Key Management Service, such as Hashicorp Vault.<br />
</p>
<p>Specify an object containing the following fields:<br />
</p>
<ul>
<li><p>- <code>name</code> - The name of the Kubernetes secret
containing the Certificate Authority and x.509 Certificate.<br />
</p></li>
<li><p>- <code>type</code> - Specify
<code>kubernetes.io/tls</code><br />
</p></li>
</ul></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>gcpCredentialSecretName</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<pre><code>Specify the GCP default credentials to be used for KES to authenticate to GCP key store</code></pre></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>gcpWorkloadIdentityPool</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<pre><code>Specify the name of the workload identity pool (This is required for generating service account token)</code></pre></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>annotations</code></strong>
<em>object (keys:string, values:string)</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, use these annotations for KES Object Meta
annotations</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>labels</code></strong>
<em>object (keys:string, values:string)</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, use these labels for KES Object Meta labels</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>resources</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#resourcerequirements-v1-core">ResourceRequirements</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Object specification for specifying CPU and memory <a
href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">resource
allocations</a> or limits in the MinIO tenant.<br />
</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>nodeSelector</code></strong>
<em>object (keys:string, values:string)</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>The filter for the Operator to apply when selecting which nodes on
which to deploy MinIO KES pods. The Operator only selects those nodes
whose labels match the specified selector.<br />
</p>
<p>See the Kubernetes documentation on <a
href="https://kubernetes.io/docs/concepts/configuration/assign-pod-node/">Assigning
Pods to Nodes</a> for more information.</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>tolerations</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#toleration-v1-core">Toleration</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify one or more <a
href="https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/">Kubernetes
tolerations</a> to apply to MinIO KES pods.</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>affinity</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#affinity-v1-core">Affinity</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify node affinity, pod affinity, and pod anti-affinity for the
KES pods.<br />
</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>topologySpreadConstraints</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#topologyspreadconstraint-v1-core">TopologySpreadConstraint</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify one or more <a
href="https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/">Kubernetes
Topology Spread Constraints</a> to apply to pods deployed in the MinIO
pool.</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>keyName</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, use this as the name of the key that KES creates on the
KMS backend</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>securityContext</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#podsecuritycontext-v1-core">PodSecurityContext</a></em></p></td>
<td style="text-align: left;"><p>Specify the <a
href="https://kubernetes.io/docs/tasks/configure-pod-container/security-context/">Security
Context</a> of MinIO KES pods. The Operator supports only the following
pod security fields:<br />
</p>
<ul>
<li><p><code>fsGroup</code><br />
</p></li>
<li><p><code>fsGroupChangePolicy</code><br />
</p></li>
<li><p><code>runAsGroup</code><br />
</p></li>
<li><p><code>runAsNonRoot</code><br />
</p></li>
<li><p><code>runAsUser</code><br />
</p></li>
<li><p><code>seLinuxOptions</code><br />
</p></li>
</ul></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>containerSecurityContext</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#securitycontext-v1-core">SecurityContext</a></em></p></td>
<td style="text-align: left;"><p>Specify the <a
href="https://kubernetes.io/docs/tasks/configure-pod-container/security-context/">Security
Context</a> of MinIO KES pods.</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>env</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#envvar-v1-core">EnvVar</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, the MinIO Operator adds the specified environment
variables when deploying the KES resource.</p></td>
</tr>
</tbody>
</table>

## LocalCertificateReference

LocalCertificateReference (`externalCertSecret`,
`externalCaCertSecret`,`clientCertSecret`) contains a Kubernetes secret
containing TLS certificates or Certificate Authority files for use with
enabling TLS in the MinIO Tenant.  

-   [KESConfig](#kesconfig)

-   [TenantSpec](#tenantspec)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>name</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Required</strong><br />
</p>
<p>The name of the Kubernetes secret containing the TLS certificate or
Certificate Authority file.<br />
</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>type</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Required</strong><br />
</p>
<p>The type of Kubernetes secret. Specify
<code>kubernetes.io/tls</code><br />
</p></td>
</tr>
</tbody>
</table>

## Logging

Logging describes Logging for MinIO tenants.

-   [TenantSpec](#tenantspec)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>json</code></strong>
<em>boolean</em></p></td>
<td style="text-align: left;"></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>anonymous</code></strong>
<em>boolean</em></p></td>
<td style="text-align: left;"></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>quiet</code></strong>
<em>boolean</em></p></td>
<td style="text-align: left;"></td>
</tr>
</tbody>
</table>

## Pool

Pool (`pools`) defines a MinIO server pool on a Tenant. Each pool
consists of a set of MinIO server pods which "pool" their storage
resources for supporting object storage and retrieval requests. Each
server pool is independent of all others and supports horizontal scaling
of available storage resources in the MinIO Tenant.  

See the [MinIO Operator CRD](https://docs.min.io/community/minio-object-store/reference/operator-crd.html)
reference for the `pools` object for examples and more complete documentation.  

-   [TenantSpec](#tenantspec)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>name</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Required</strong> Specify the
name of the pool. The Operator automatically generates the pool name if
this field is omitted.</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>servers</code></strong>
<em>integer</em></p></td>
<td style="text-align: left;"><p><strong>Required</strong></p>
<p>The number of MinIO server pods to deploy in the pool. The minimum
value is <code>2</code>.</p>
<p>The MinIO Operator requires a minimum of <code>4</code> volumes per
pool. Specifically, the result of
<code>pools.servers X pools.volumesPerServer</code> must be greater than
<code>4</code>.<br />
</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>volumesPerServer</code></strong>
<em>integer</em></p></td>
<td style="text-align: left;"><p><strong>Required</strong><br />
</p>
<p>The number of Persistent Volume Claims to generate for each MinIO
server pod in the pool.<br />
</p>
<p>The MinIO Operator requires a minimum of <code>4</code> volumes per
pool. Specifically, the result of
<code>pools.servers X pools.volumesPerServer</code> must be greater than
<code>4</code>.<br />
</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>volumeClaimTemplate</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#persistentvolumeclaim-v1-core">PersistentVolumeClaim</a></em></p></td>
<td style="text-align: left;"><p><strong>Required</strong><br />
</p>
<p>Specify the configuration options for the MinIO Operator to use when
generating Persistent Volume Claims for the MinIO tenant.<br />
</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>resources</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#resourcerequirements-v1-core">ResourceRequirements</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Object specification for specifying CPU and memory <a
href="https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">resource
allocations</a> or limits in the MinIO tenant.<br />
</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>nodeSelector</code></strong>
<em>object (keys:string, values:string)</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>The filter for the Operator to apply when selecting which nodes on
which to deploy pods in the pool. The Operator only selects those nodes
whose labels match the specified selector.<br />
</p>
<p>See the Kubernetes documentation on <a
href="https://kubernetes.io/docs/concepts/configuration/assign-pod-node/">Assigning
Pods to Nodes</a> for more information.</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>affinity</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#affinity-v1-core">Affinity</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify node affinity, pod affinity, and pod anti-affinity for pods
in the MinIO pool.<br />
</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>tolerations</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#toleration-v1-core">Toleration</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify one or more <a
href="https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/">Kubernetes
tolerations</a> to apply to pods deployed in the MinIO pool.</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>topologySpreadConstraints</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#topologyspreadconstraint-v1-core">TopologySpreadConstraint</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify one or more <a
href="https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/">Kubernetes
Topology Spread Constraints</a> to apply to pods deployed in the MinIO
pool.</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>securityContext</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#podsecuritycontext-v1-core">PodSecurityContext</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify the <a
href="https://kubernetes.io/docs/tasks/configure-pod-container/security-context/">Security
Context</a> of pods in the pool. The Operator supports only the
following pod security fields:<br />
</p>
<ul>
<li><p><code>fsGroup</code><br />
</p></li>
<li><p><code>fsGroupChangePolicy</code><br />
</p></li>
<li><p><code>runAsGroup</code><br />
</p></li>
<li><p><code>runAsNonRoot</code><br />
</p></li>
<li><p><code>runAsUser</code><br />
</p></li>
</ul></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>containerSecurityContext</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#securitycontext-v1-core">SecurityContext</a></em></p></td>
<td style="text-align: left;"><p>Specify the <a
href="https://kubernetes.io/docs/tasks/configure-pod-container/security-context/">Security
Context</a> of containers in the pool. The Operator supports only the
following container security fields:<br />
</p>
<ul>
<li><p><code>runAsGroup</code><br />
</p></li>
<li><p><code>runAsNonRoot</code><br />
</p></li>
<li><p><code>runAsUser</code><br />
</p></li>
</ul></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>annotations</code></strong>
<em>object (keys:string, values:string)</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify custom labels and annotations to append to the Pool.
<strong>Optional</strong><br />
</p>
<p>If provided, use these annotations for the Pool Objects Meta
annotations (Statefulset and Pod template)</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>labels</code></strong>
<em>object (keys:string, values:string)</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, use these labels for the Pool Objects Meta annotations
(Statefulset and Pod template)</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>runtimeClassName</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, each pod on the Statefulset will run with the specified
RuntimeClassName, for more info <a
href="https://kubernetes.io/docs/concepts/containers/runtime-class/">https://kubernetes.io/docs/concepts/containers/runtime-class/</a></p></td>
</tr>
</tbody>
</table>

## PoolState (string)

PoolState represents the state of a pool

-   [PoolStatus](#poolstatus)

## PoolStatus

PoolStatus keeps track of all the pools and their current state

-   [TenantStatus](#tenantstatus)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>ssName</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>state</code></strong>
<em><a
href="#poolstate">PoolState</a></em></p></td>
<td style="text-align: left;"></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>legacySecurityContext</code></strong>
<em>boolean</em></p></td>
<td style="text-align: left;"><p>LegacySecurityContext stands for Legacy
SecurityContext. It represents that these pool was created before v4.2.3
when we introduced the default securityContext as non-root, thus we
should keep running this Pool without a Security Context</p></td>
</tr>
</tbody>
</table>

## PoolsMetadata

PoolsMetadata (`poolsMetadata`) defines custom labels and annotations
for the MinIO pool stateful sets / pods.  

-   [TenantSpec](#tenantspec)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>labels</code></strong>
<em>object (keys:string, values:string)</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, append these labels to the MinIO statefulset /
pods</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>annotations</code></strong>
<em>object (keys:string, values:string)</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, append these annotations to the MinIO statefulset /
pods</p></td>
</tr>
</tbody>
</table>

## ServiceMetadata

ServiceMetadata (`serviceMetadata`) defines custom labels and
annotations for the MinIO Object Storage service and/or MinIO Console
service.  

-   [TenantSpec](#tenantspec)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>minioServiceLabels</code></strong>
<em>object (keys:string, values:string)</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, append these labels to the MinIO service</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>minioServiceAnnotations</code></strong>
<em>object (keys:string, values:string)</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, append these annotations to the MinIO service</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>consoleServiceLabels</code></strong>
<em>object (keys:string, values:string)</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, append these labels to the Console service</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>consoleServiceAnnotations</code></strong>
<em>object (keys:string, values:string)</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, append these annotations to the Console service</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>kesServiceLabels</code></strong>
<em>object (keys:string, values:string)</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, append these labels to the KES service</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>kesServiceAnnotations</code></strong>
<em>object (keys:string, values:string)</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, append these annotations to the KES service</p></td>
</tr>
</tbody>
</table>

## SideCars

SideCars (`sidecars`) defines a list of containers that the Operator
attaches to each MinIO server pods in the `pool`.

-   [TenantSpec](#tenantspec)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>containers</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core">Container</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>List of containers to run inside the Pod</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>volumeClaimTemplates</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#persistentvolumeclaim-v1-core">PersistentVolumeClaim</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>volumeClaimTemplates is a list of claims that pods are allowed to
reference. The StatefulSet controller is responsible for mapping network
identities to claims in a way that maintains the identity of a pod.
Every claim in this list must have at least one matching (by name)
volumeMount in one container in the template. A claim in this list takes
precedence over any volumes in the template, with the same
name.</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>volumes</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#volume-v1-core">Volume</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>List of volumes that can be mounted by containers belonging to the
pod. More info: <a
href="https://kubernetes.io/docs/concepts/storage/volumes">https://kubernetes.io/docs/concepts/storage/volumes</a></p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>resources</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#resourcerequirements-v1-core">ResourceRequirements</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>sidecar’s Resource, initcontainer will use that if set.</p></td>
</tr>
</tbody>
</table>

## Tenant

Tenant is a [Kubernetes
object](https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/)
describing a MinIO Tenant.  

-   [TenantList](#tenantlist)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>apiVersion</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><code>Operator CRD v2 Reference</code></p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>kind</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><code>Tenant</code></p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>metadata</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#objectmeta-v1-meta">ObjectMeta</a></em></p></td>
<td style="text-align: left;"><p>Refer to Kubernetes API documentation
for fields of <code>metadata</code>.</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>scheduler</code></strong>
<em><a
href="#tenantscheduler">TenantScheduler</a></em></p></td>
<td style="text-align: left;"></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>spec</code></strong>
<em><a
href="#tenantspec">TenantSpec</a></em></p></td>
<td style="text-align: left;"><p><strong>Required</strong><br />
</p>
<p>The root field for the MinIO Tenant object.</p></td>
</tr>
</tbody>
</table>

## TenantDomains

TenantDomains (`domains`) - List of domains used to access the tenant
from outside the kubernetes clusters. this will only configure MinIO for
the domains listed, but external DNS configuration is still needed. The
listed domains should include schema and port if any is used, i.e.
<https://minio.domain.com:8123>

-   [Features](#features)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>minio</code></strong>
<em>string array</em></p></td>
<td style="text-align: left;"><p>List of Domains used by MinIO. This
will enable DNS style access to the object store where the bucket name
is inferred from a subdomain in the domain.</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>console</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p>Domain used to expose the MinIO
Console, this will configure the redirect on MinIO when visiting from
the browser If Console is exposed via a subpath, the domain should
include it, i.e. <a
href="https://console.domain.com:8123/subpath/">https://console.domain.com:8123/subpath/</a></p></td>
</tr>
</tbody>
</table>

## TenantScheduler

TenantScheduler (`scheduler`) - Object describing Kubernetes Scheduler
to use for deploying the MinIO Tenant.

-   [Tenant](#tenant)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>name</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify the name of the <a
href="https://kubernetes.io/docs/concepts/scheduling-eviction/kube-scheduler/">Kubernetes
scheduler</a> to be used to schedule Tenant pods</p></td>
</tr>
</tbody>
</table>

## TenantSpec

TenantSpec (`spec`) defines the configuration of a MinIO Tenant
object.  

The following parameters are specific to the `Operator CRD v2 Reference` MinIO CRD
API `spec` definition added as part of the MinIO Operator v4.0.0.  

For more complete documentation on this object, see the [MinIO
Kubernetes
Documentation](https://docs.min.io/community/minio-object-store/operations/deployments/kubernetes.html).  

-   [Tenant](#tenant)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>pools</code></strong>
<em><a
href="#pool">Pool</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Required</strong><br />
</p>
<p>An array of objects describing each MinIO server pool deployed in the
MinIO Tenant. Each pool consists of a set of MinIO server pods which
"pool" their storage resources for supporting object storage and
retrieval requests. Each server pool is independent of all others and
supports horizontal scaling of available storage resources in the MinIO
Tenant.<br />
</p>
<p>The MinIO Tenant <code>spec</code> <strong>must have</strong> at
least <strong>one</strong> element in the <code>pools</code>
array.<br />
</p>
<p>See the <a
href="https://docs.min.io/community/minio-object-store/reference/operator-crd.html#tenant">MinIO
Operator CRD</a> reference for the <code>pools</code> object for
examples and more complete documentation.</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>image</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>imagePullSecret</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#localobjectreference-v1-core">LocalObjectReference</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify the secret key to use for pulling images from a private
Docker repository.<br />
</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>podManagementPolicy</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#podmanagementpolicytype-v1-apps">PodManagementPolicyType</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Pod Management Policy for pod created by StatefulSet</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>env</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#envvar-v1-core">EnvVar</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, the MinIO Operator adds the specified environment
variables when deploying the Tenant resource.</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>externalCertSecret</code></strong>
<em><a
href="#localcertificatereference">LocalCertificateReference</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Enables TLS with SNI support on each MinIO pod in the tenant. If
<code>externalCertSecret</code> is omitted <strong>and</strong>
<code>requestAutoCert</code> is set to <code>false</code>, the MinIO
Tenant deploys <strong>without</strong> TLS enabled.<br />
</p>
<p>Specify an array of <a
href="https://kubernetes.io/docs/concepts/configuration/secret/">Kubernetes
TLS secrets</a>. The MinIO Operator copies the specified certificates to
every MinIO server pod in the tenant. When the MinIO pod/service
responds to a TLS connection request, it uses SNI to select the
certificate with matching <code>subjectAlternativeName</code>.<br />
</p>
<p>Each element in the <code>externalCertSecret</code> array is an
object containing the following fields:<br />
</p>
<ul>
<li><p>- <code>name</code> - The name of the Kubernetes secret
containing the TLS certificate.<br />
</p></li>
<li><p>- <code>type</code> - Specify
<code>kubernetes.io/tls</code><br />
</p></li>
</ul>
<p>See the <a
href="https://docs.min.io/community/minio-object-store/reference/operator-crd.html#tenantspec">MinIO
Operator CRD</a> reference for examples and more complete documentation
on configuring TLS for MinIO Tenants.</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>externalCaCertSecret</code></strong>
<em><a
href="#localcertificatereference">LocalCertificateReference</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Allows MinIO server pods to verify client TLS certificates signed by
a Certificate Authority not in the pod’s trust store.<br />
</p>
<p>Specify an array of <a
href="https://kubernetes.io/docs/concepts/configuration/secret/">Kubernetes
TLS secrets</a>. The MinIO Operator copies the specified certificates to
every MinIO server pod in the tenant.<br />
</p>
<p>Each element in the <code>externalCertSecret</code> array is an
object containing the following fields:<br />
</p>
<ul>
<li><p>- <code>name</code> - The name of the Kubernetes secret
containing the Certificate Authority.<br />
</p></li>
<li><p>- <code>type</code> - Specify
<code>kubernetes.io/tls</code>.<br />
</p></li>
</ul>
<p>See the <a
href="https://docs.min.io/community/minio-object-store/reference/operator-crd.html#tenantspec">MinIO
Operator CRD</a> reference for examples and more complete documentation
on configuring TLS for MinIO Tenants.</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>externalClientCertSecret</code></strong>
<em><a
href="#localcertificatereference">LocalCertificateReference</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Enables mTLS authentication between the MinIO Tenant pods and <a
href="https://github.com/minio/kes">MinIO KES</a>.
<strong>Required</strong> for enabling connectivity between the MinIO
Tenant and MinIO KES.<br />
</p>
<p>Specify a <a
href="https://kubernetes.io/docs/concepts/configuration/secret/">Kubernetes
TLS secrets</a>. The MinIO Operator copies the specified certificate to
every MinIO server pod in the tenant. The secret <strong>must</strong>
contain the following fields:<br />
</p>
<ul>
<li><p><code>name</code> - The name of the Kubernetes secret containing
the TLS certificate.<br />
</p></li>
<li><p><code>type</code> - Specify <code>kubernetes.io/tls</code><br />
</p></li>
</ul>
<p>The specified certificate <strong>must</strong> correspond to an
identity on the KES server. See the <a
href="https://github.com/minio/kes/wiki/Configuration#policy-configuration">KES
Wiki</a> for more information on KES identities.<br />
</p>
<p>If deploying KES with the MinIO Operator, include the hash of the
certificate as part of the <a
href="#kesconfig"><code>kes</code></a>
object specification.<br />
</p>
<p>See the <a
href="https://docs.min.io/community/minio-object-store/reference/operator-crd.html#tenantspec">MinIO
Operator CRD</a> reference for examples and more complete documentation
on configuring TLS for MinIO Tenants.</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>externalClientCertSecrets</code></strong>
<em><a
href="#localcertificatereference">LocalCertificateReference</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Provide support for mounting additional client certificate into MinIO
Tenant pods Multiple client certificates will be mounted using the
following folder structure:<br />
</p>
<ul>
<li><p>certs<br />
</p></li>
<li><p>* client-0<br />
</p></li>
<li><p>* * client.crt<br />
</p></li>
<li><p>* * client.key<br />
</p></li>
<li><p>* client-1<br />
</p></li>
<li><p>* * client.crt<br />
</p></li>
<li><p>* * client.key<br />
</p></li>
<li><p>* * client-2<br />
</p></li>
<li><p>* client.crt<br />
</p></li>
<li><p>* * client.key<br />
</p></li>
</ul>
<p>Specify a <a
href="https://kubernetes.io/docs/concepts/configuration/secret/">Kubernetes
TLS secrets</a>. The MinIO Operator copies the specified certificate to
every MinIO server pod in the tenant that later can be referenced using
environment variables. The secret <strong>must</strong> contain the
following fields:<br />
</p>
<ul>
<li><p><code>name</code> - The name of the Kubernetes secret containing
the TLS certificate.<br />
</p></li>
<li><p><code>type</code> - Specify <code>kubernetes.io/tls</code><br />
</p></li>
</ul></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>mountPath</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Mount path for MinIO volume (PV). Defaults to
<code>/export</code></p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>subPath</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Subpath inside mount path. This is the directory where MinIO stores
data. Default to <code>""`</code> (empty)</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>requestAutoCert</code></strong>
<em>boolean</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Enables using <a
href="https://kubernetes.io/docs/tasks/tls/managing-tls-in-a-cluster/">Kubernetes-based
TLS certificate generation</a> and signing for pods and services in the
MinIO Tenant.<br />
</p>
<ul>
<li><p>Specify <code>true</code> to explicitly enable automatic
certificate generate (Default).<br />
</p></li>
<li><p>Specify <code>false</code> to disable automatic certificate
generation.<br />
</p></li>
</ul>
<p>If <code>requestAutoCert</code> is set to <code>false</code>
<strong>and</strong> <code>externalCertSecret</code> is omitted, the
MinIO Tenant deploys <strong>without</strong> TLS enabled.</p>
<p>See the <a
href="https://docs.min.io/community/minio-object-store/reference/operator-crd.html#tenantspec">MinIO
Operator CRD</a> reference for examples and more complete documentation
on configuring TLS for MinIO Tenants.</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>certExpiryAlertThreshold</code></strong>
<em>integer</em></p></td>
<td style="text-align: left;"><p>CertExpiryAlertThreshold is the minimum
number of days to expiry before an alert for an expiring certificate is
fired.</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>liveness</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#probe-v1-core">Probe</a></em></p></td>
<td style="text-align: left;"><p>Liveness Probe for container liveness.
Container will be restarted if the probe fails.</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>readiness</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#probe-v1-core">Probe</a></em></p></td>
<td style="text-align: left;"><p>Readiness Probe for container
readiness. Container will be removed from service endpoints if the probe
fails.</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>startup</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#probe-v1-core">Probe</a></em></p></td>
<td style="text-align: left;"><p>Startup Probe allows to configure a max
grace period for a pod to start before getting traffic routed to
it.</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>lifecycle</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#lifecycle-v1-core">Lifecycle</a></em></p></td>
<td style="text-align: left;"><p>Lifecycle hooks for container.</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>features</code></strong>
<em><a
href="#features">Features</a></em></p></td>
<td style="text-align: left;"><p>S3 related features can be disabled or
enabled such as <code>bucketDNS</code> etc.</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>certConfig</code></strong>
<em><a
href="#certificateconfig">CertificateConfig</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Enables setting the <code>CommonName</code>,
<code>Organization</code>, and <code>dnsName</code> attributes for all
TLS certificates automatically generated by the Operator. Configuring
this object has no effect if <code>requestAutoCert</code> is
<code>false</code>.<br />
</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>kes</code></strong>
<em><a
href="#kesconfig">KESConfig</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Directs the MinIO Operator to deploy the <a
href="https://github.com/minio/kes">MinIO Key Encryption Service</a>
(KES) using the specified configuration. The MinIO KES supports
performing server-side encryption of objects on the MiNIO Tenant.<br />
</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>prometheusOperator</code></strong>
<em>boolean</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Directs the MinIO Operator to use prometheus operator.<br />
</p>
<p>Tenant scrape configuration will be added to prometheus managed by
the prometheus-operator.</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>serviceAccountName</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>The <a
href="https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/">Kubernetes
Service Account</a> to use for running MinIO pods created as part of the
Tenant.<br />
</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>priorityClassName</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Indicates the Pod priority and therefore importance of a Pod relative
to other Pods in the cluster. This is applied to MinIO pods only.<br />
</p>
<p>Refer Kubernetes <a
href="https://kubernetes.io/docs/concepts/configuration/pod-priority-preemption/#priorityclass">Priority
Class documentation</a> for more complete documentation.</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>imagePullPolicy</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#pullpolicy-v1-core">PullPolicy</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>The pull policy for the MinIO Docker image. Specify one of the
following:<br />
</p>
<ul>
<li><p><code>Always</code><br />
</p></li>
<li><p><code>Never</code><br />
</p></li>
<li><p><code>IfNotPresent</code> (Default)<br />
</p></li>
</ul>
<p>Refer Kubernetes documentation for details <a
href="https://kubernetes.io/docs/concepts/containers/images#updating-images">https://kubernetes.io/docs/concepts/containers/images#updating-images</a></p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>sideCars</code></strong>
<em><a
href="#sidecars">SideCars</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>A list of containers to run as sidecars along every MinIO Pod
deployed in the tenant.</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>exposeServices</code></strong>
<em><a
href="#exposeservices">ExposeServices</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Directs the Operator to expose the MinIO and/or Console
services.<br />
</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>serviceMetadata</code></strong>
<em><a
href="#servicemetadata">ServiceMetadata</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify custom labels and annotations to append to the MinIO service
and/or Console service.</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>poolsMetadata</code></strong>
<em><a
href="#poolsmetadata">PoolsMetadata</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify custom labels and annotations to append to all pool
statefulsets and pods.</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>users</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#localobjectreference-v1-core">LocalObjectReference</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>An array of <a
href="https://kubernetes.io/docs/concepts/configuration/secret/">Kubernetes
opaque secrets</a> to use for generating MinIO users during tenant
provisioning.<br />
</p>
<p>Each element in the array is an object consisting of a key-value pair
<code>name: &lt;string&gt;</code>, where the <code>&lt;string&gt;</code>
references an opaque Kubernetes secret.<br />
</p>
<p>Each referenced Kubernetes secret must include the following
fields:<br />
</p>
<ul>
<li><p><code>CONSOLE_ACCESS_KEY</code> - The "Username" for the MinIO
user<br />
</p></li>
<li><p><code>CONSOLE_SECRET_KEY</code> - The "Password" for the MinIO
user<br />
</p></li>
</ul>
<p>The Operator creates each user with the <code>consoleAdmin</code>
policy by default. You can change the assigned policy after the Tenant
starts.<br />
</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>buckets</code></strong>
<em><a
href="#bucket">Bucket</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Create buckets when creating a new tenant. Skip if bucket with given
name already exists</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>logging</code></strong>
<em><a
href="#logging">Logging</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Enable JSON, Anonymous logging for MinIO tenants.</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>configuration</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#localobjectreference-v1-core">LocalObjectReference</a></em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Specify a secret that contains additional environment variable
configurations to be used for the MinIO pools. The secret is expected to
have a key named config.env containing all exported environment
variables for MinIO+</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>initContainers</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core">Container</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>Add custom initContainers to StatefulSet</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>additionalVolumes</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#volume-v1-core">Volume</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, statefulset will add these volumes. You should set the
rules for the corresponding volumes and volume mounts. We will not test
this rule, k8s will show the result.</p></td>
</tr>
<tr class="odd">
<td
style="text-align: left;"><p><strong><code>additionalVolumeMounts</code></strong>
<em><a
href="https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#volumemount-v1-core">VolumeMount</a>
array</em></p></td>
<td style="text-align: left;"><p><strong>Optional</strong><br />
</p>
<p>If provided, statefulset will add these volumes. You should set the
rules for the corresponding volumes and volume mounts. We will not test
this rule, k8s will show the result.</p></td>
</tr>
</tbody>
</table>

## TenantUsage

TenantUsage are metrics regarding the usage and capacity of the tenant

-   [TenantStatus](#tenantstatus)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>capacity</code></strong>
<em>integer</em></p></td>
<td style="text-align: left;"><p>Capacity the usage capacity of this
tenant in bytes.</p></td>
</tr>
<tr class="even">
<td
style="text-align: left;"><p><strong><code>rawCapacity</code></strong>
<em>integer</em></p></td>
<td style="text-align: left;"><p>Capacity the raw capacity of this
tenant in bytes.</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>usage</code></strong>
<em>integer</em></p></td>
<td style="text-align: left;"><p>Usage is how much data is managed by
MinIO in bytes.</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>rawUsage</code></strong>
<em>integer</em></p></td>
<td style="text-align: left;"><p>Usage is the raw usage on disks in
bytes.</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>tiers</code></strong>
<em><a
href="#tierusage">TierUsage</a>
array</em></p></td>
<td style="text-align: left;"><p>Tiers includes the usage of individual
tiers in the tenant</p></td>
</tr>
</tbody>
</table>

## TierUsage

TierUsage represents the usage from a tier setup by the tenant

-   [TenantUsage](#tenantusage)

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 75%" />
</colgroup>
<thead>
<tr class="header">
<th style="text-align: left;">Field</th>
<th style="text-align: left;">Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>Name</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p>Name of the tier</p></td>
</tr>
<tr class="even">
<td style="text-align: left;"><p><strong><code>Type</code></strong>
<em>string</em></p></td>
<td style="text-align: left;"><p>type of the tier</p></td>
</tr>
<tr class="odd">
<td style="text-align: left;"><p><strong><code>totalSize</code></strong>
<em>integer</em></p></td>
<td style="text-align: left;"><p>TotalSize usage of the tier</p></td>
</tr>
</tbody>
</table>
