Minutes from 136-th OpenVDB TSC meeting, June 14th, 2022.

Attendees: *Jeff* L., *Nick* A, *Dan* B., *Ken* M., *Rich* J.

Additional Attendees: Sebastian Gaida, Peter Cheng (DW), Jamie
Portsmouth, Paul-Mark Difrancesco (SideFX), Karl Marett, JT Nelson
(Blender)

Regrets: *Andre* P.

Agenda:

1) Confirm quorum
2) Secretary
3) Forum
4) 9.1 release
5) GU_VDBPointTools
6) Stream vs File interface
7) NeuralVDB
8) Multires Grid and Anti-Aliasing
9) Cmake Object Library
10) Next Meeting

--------------------

1) Confirm quorum

Quorum is present.

2) Secretary

Secretary is Jeff Lait.

3) Forum

a) 9.1 forum post?

Should we have a forum post?  Github discussions is a bit redundant.  Since we are deprecating forum, we shouldn't post.  This is an ASWF press release issue, we should pass on to TAC.

4) 9.1 release

Release checklist was pretty straightforward. Some documentation steps have
changes that have been updated.   Ten minutes of work, but four hours
of building!  Weekly tests need to run on the Release candidate.
Potentially should have explicitly run the weekly CI earlier on the PR
branch.  We need more power for CI!  Likewise, we can no longer build
static debug Windows on master.  Tomorrow is TAC where this can be
brought up again.  We have a watered down build matrix that made the
release more complicated.

5) GU_VDBPointTools

Need to move some wrappers from PointUtils to GU_VDBPointUtils.
Wrappers are the HoudiniRead/WriteAttributes.  We also wish to add
UINT8 to matrix of conversion types.  

Adding UINT8 is fine.  

Purpose of these changes is to build the Point VDB during file load of
the Lidar SOP.  PointUtils is in a sister directory so can't be
included directly.

Important requirement is that local builds of OpenVDB can change these
files without tying to a Houdini version.  It is believed the include
path used for GU_VDBPointUtils allows this, but it should be double
checked.

Mostly is a direct port of attribute wrappers.

UINT8 will be done for 19.5, rest for later versions so is of lower
priority.  19.5 does not require this in VDB 9.1 as it can patch its
9.1 version.

6) Stream vs File interface

A VDB 5.0 file fails to load with io::Stream but loads with io::File.
File has delayed loading on by default, however.  So it might be the
blosc version.  

Editor: File interface also failed with the delayed loading disabled,
so this was a blosc issue.  Blosc stores the file format in the
header, not the blosc version, so can't verify which version of blosc
was used (it reports a valid version)

Dan reports hsc segfaults when write to read only location?

7) NeuralVDB

Use of neural networks to compress topology and values of VDBs.  

Compare with VDB Compress SOP, a method for discarding unneeded data
for rendering.

8) Multires Grid and Anti-Aliasing

Looking at an anti-aliasing tool.  Nothing uses multi-res grids now.
Are there examples for this?  Looking at a tool that gives a position
+ size and returns the data.

9) Cmake Object Library

Currently we have to build each libraries objects before next library.
Attempt to fix this with Cmake Object Libraries now that CMake 12 is
deployed.   Is non-PIC a concern?  Not known.  Merging static and dynamic
builds makes PIC mandatory.  We think this is okay.

10) Next meeting

Next meeting is on June 21st, 2022. 1pm-2pm EDT (GMT-4).

