Minutes from 167th OpenVDB TSC meeting, April 18th, 2023

Attendees: *Jeff* L., *Dan* B., *Ken* M., *Dan* B., *Rich* J,
*Andre* P.

Additional Attendees: Sebastian Gaida

Regrets: *Nick* A., *Greg* H.

Agenda:

1) Confirm quorum
2) Secretary
3) Forum
4) PR-1606: Boost UUID
5) VFX Reference Platform
6) Boost::any PR
7) Discussion on read-only data structure
8) VDB 11
9) Next Meeting

------------

1) Confirm quorum

Quorum is present.

2) Secretary

Secretary is Andre Pradhana.

3) Forum

Nothing to discuss.

4) PR-1606: Boost UUID

It compiles. We agree to review the PR.

5) VFX Reference Platform

VFX Reference Platform asks for a release draft for 2024. We
agree to release VDB 11.0 in November. Our plan will be communicated
to VFX Reference Platform to confirm that we are moving to VDB 11 later
in the year.

6) Boost::any PR

Once this PR is approved, OpenVDB will optionally depend on boost. It makes
sense to have a lite-CI for OpenVDB that does not support delayed loading
nor depends on blosc.

7) Discussion on read-only data structure

Ideas discussed are:
 - Having a read-only tree in OpenVDB, for example utilizing a ring
   buffer, which replaces pages instead of loading new pages. The
   argument against adding a ring-buffer based grid is that the OS
   can do it for us if we use delayed/partial loading. However, this
   approach makes the OS to do the swapping. This approach is similar
   to NanoVDB. The advantage of it is that a user can define the allocated
   memory footprint upfront.
 - A refinement of the idea above is to store the evicted data locally.
 - Another approach discussed is by reading/loading the data per-
   bouding-box.
 - Build a prefectching tools.

Other points raised includes:
 - The need to trim down the core code-base, so that it is easier
   to add a new grid. Currently, there are a lot of virtual methods
   and expected functions that are required to build a new grid type.
 - In terms of workflow, Houdini uses viewport to control which
   data should be loaded in memory.
 - People read-only tree for rendering.
 - Talked about strategy to parallelize an algorithm that delay-load
   leaf nodes using mutex locks.

8) VDB 11
What can go to VDB 11:
 - Updates to NanoVDB.
 - Offset to recenter root node.
 - Hollow VDB.
 - VDB Merge needs to work for packed primitives.
 - Example for fluids (due for SIGGRAPH).
 - VDB Fillet.

9) Next Meeting

Next meeting is on April 25th, 2023. 2pm-3pm EDT (GMT-4).
