/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/Spectral.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 94, 79, 162, 255, 50, 136, 189, 255, 102, 194, 165, 255, 171, 221, 164, 255, 230, 245, 152, 255, 241, 243, 167, 255, 254, 224, 144, 255, 253, 174, 97, 255, 244, 109, 67, 255, 213, 62, 79, 255, 158, 1, 66, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Spectral_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 94, 79, 162, 0, 93, 79, 162, 7, 92, 80, 163, 14, 92, 81, 163, 22, 91, 81, 164, 29, 91, 82, 164, 37, 90, 82, 165, 44, 89, 83, 165, 52, 89, 84, 166, 59, 88, 84, 166, 67, 88, 85, 167, 74, 87, 86, 167, 82, 86, 86, 167, 89, 86, 87, 168, 97, 85, 88, 168, 104, 85, 88, 169, 112, 84, 89, 169, 119, 83, 89, 170, 127, 83, 90, 170, 134, 82, 91, 171, 141, 82, 91, 171, 149, 81, 92, 171, 156, 80, 93, 172, 164, 80, 93, 172, 171, 79, 94, 173, 179, 79, 94, 173, 186, 78, 95, 173, 194, 77, 96, 174, 201, 77, 96, 174, 209, 76, 97, 174, 216, 76, 97, 175, 224, 75, 98, 175, 231, 74, 99, 176, 239, 74, 99, 176, 246, 73, 100, 176, 254, 72, 100, 177, 255, 72, 101, 177, 255, 71, 101, 177, 255, 71, 102, 178, 255, 70, 103, 178, 255, 70, 103, 178, 255, 69, 104, 178, 255, 68, 104, 179, 255, 68, 105, 179, 255, 67, 105, 179, 255, 67, 106, 180, 255, 66, 107, 180, 255, 65, 107, 180, 255, 65, 108, 180, 255, 64, 108, 181, 255, 64, 109, 181, 255, 63, 109, 181, 255, 63, 110, 181, 255, 62, 110, 182, 255, 62, 111, 182, 255, 61, 112, 182, 255, 61, 112, 182, 255, 60, 113, 183, 255, 60, 113, 183, 255, 59, 114, 183, 255, 59, 114, 183, 255, 58, 115, 183, 255, 58, 115, 184, 255, 57, 116, 184, 255, 57, 116, 184, 255, 56, 117, 184, 255, 56, 117, 184, 255, 55, 118, 185, 255, 55, 118, 185, 255, 55, 119, 185, 255, 54, 119, 185, 255, 54, 120, 185, 255, 53, 121, 185, 255, 53, 121, 186, 255, 53, 122, 186, 255, 52, 122, 186, 255, 52, 123, 186, 255, 52, 123, 186, 255, 51, 124, 186, 255, 51, 124, 186, 255, 51, 125, 187, 255, 51, 125, 187, 255, 50, 126, 187, 255, 50, 126, 187, 255, 50, 127, 187, 255, 50, 127, 187, 255, 50, 128, 187, 255, 50, 128, 187, 255, 49, 129, 187, 255, 49, 129, 188, 255, 49, 130, 188, 255, 49, 130, 188, 255, 49, 131, 188, 255, 49, 131, 188, 255, 49, 131, 188, 255, 49, 132, 188, 255, 49, 132, 188, 255, 49, 133, 188, 255, 49, 133, 188, 255, 49, 134, 188, 255, 49, 134, 188, 255, 49, 135, 188, 255, 49, 135, 188, 255, 49, 136, 189, 255, 47, 137, 189, 255, 45, 137, 189, 255, 44, 138, 189, 255, 42, 139, 190, 255, 40, 139, 190, 255, 38, 140, 190, 255, 37, 141, 190, 255, 35, 141, 190, 255, 33, 142, 190, 255, 31, 143, 191, 255, 29, 143, 191, 255, 27, 144, 191, 255, 25, 145, 191, 255, 23, 145, 191, 255, 20, 146, 191, 255, 18, 147, 191, 255, 15, 147, 191, 255, 13, 148, 191, 255, 9, 149, 191, 255, 6, 149, 191, 255, 3, 150, 191, 255, 0, 151, 191, 255, 0, 151, 191, 255, 0, 152, 191, 255, 0, 153, 191, 255, 0, 153, 191, 255, 0, 154, 191, 255, 0, 155, 191, 255, 0, 155, 191, 255, 0, 156, 191, 255, 0, 156, 191, 255, 0, 157, 190, 255, 0, 158, 190, 255, 0, 158, 190, 255, 0, 159, 190, 255, 0, 159, 190, 255, 0, 160, 190, 255, 0, 161, 189, 255, 0, 161, 189, 255, 0, 162, 189, 255, 0, 162, 189, 255, 0, 163, 189, 255, 0, 164, 188, 255, 0, 164, 188, 255, 0, 165, 188, 255, 0, 165, 188, 255, 0, 166, 187, 255, 0, 167, 187, 255, 0, 167, 187, 255, 0, 168, 186, 255, 0, 168, 186, 255, 3, 169, 186, 255, 6, 169, 185, 255, 9, 170, 185, 255, 13, 170, 185, 255, 16, 171, 184, 255, 18, 172, 184, 255, 21, 172, 184, 255, 23, 173, 183, 255, 26, 173, 183, 255, 28, 174, 183, 255, 30, 174, 182, 255, 33, 175, 182, 255, 35, 175, 181, 255, 37, 176, 181, 255, 39, 176, 181, 255, 41, 177, 180, 255, 43, 177, 180, 255, 45, 178, 179, 255, 47, 179, 179, 255, 48, 179, 179, 255, 50, 180, 178, 255, 52, 180, 178, 255, 54, 181, 177, 255, 56, 181, 177, 255, 58, 182, 176, 255, 59, 182, 176, 255, 61, 183, 176, 255, 63, 183, 175, 255, 65, 184, 175, 255, 67, 184, 174, 255, 68, 185, 174, 255, 70, 185, 173, 255, 72, 185, 173, 255, 73, 186, 172, 255, 75, 186, 172, 255, 77, 187, 171, 255, 79, 187, 171, 255, 80, 188, 170, 255, 82, 188, 170, 255, 84, 189, 170, 255, 85, 189, 169, 255, 87, 190, 169, 255, 89, 190, 168, 255, 90, 191, 168, 255, 92, 191, 167, 255, 94, 191, 167, 255, 95, 192, 166, 255, 97, 192, 166, 255, 99, 193, 165, 255, 100, 193, 165, 255, 102, 194, 164, 255, 102, 194, 164, 255, 103, 194, 164, 255, 104, 194, 164, 255, 104, 195, 164, 255, 105, 195, 164, 255, 106, 195, 164, 255, 106, 196, 164, 255, 107, 196, 164, 255, 108, 196, 164, 255, 108, 196, 164, 255, 109, 197, 164, 255, 110, 197, 164, 255, 110, 197, 164, 255, 111, 197, 164, 255, 112, 198, 164, 255, 112, 198, 164, 255, 113, 198, 164, 255, 114, 199, 164, 255, 114, 199, 164, 255, 115, 199, 164, 255, 116, 199, 164, 255, 116, 200, 164, 255, 117, 200, 164, 255, 118, 200, 164, 255, 118, 200, 164, 255, 119, 201, 164, 255, 120, 201, 164, 255, 120, 201, 164, 255, 121, 202, 164, 255, 122, 202, 164, 255, 123, 202, 164, 255, 123, 202, 164, 255, 124, 203, 164, 255, 125, 203, 164, 255, 125, 203, 163, 255, 126, 203, 163, 255, 127, 204, 163, 255, 127, 204, 163, 255, 128, 204, 163, 255, 129, 205, 163, 255, 129, 205, 163, 255, 130, 205, 163, 255, 131, 205, 163, 255, 131, 206, 163, 255, 132, 206, 163, 255, 133, 206, 163, 255, 133, 206, 163, 255, 134, 207, 163, 255, 135, 207, 163, 255, 135, 207, 163, 255, 136, 207, 163, 255, 137, 208, 163, 255, 137, 208, 163, 255, 138, 208, 163, 255, 139, 209, 163, 255, 139, 209, 163, 255, 140, 209, 163, 255, 141, 209, 163, 255, 141, 210, 163, 255, 142, 210, 163, 255, 143, 210, 163, 255, 143, 210, 163, 255, 144, 211, 163, 255, 145, 211, 163, 255, 145, 211, 163, 255, 146, 211, 163, 255, 147, 212, 163, 255, 147, 212, 163, 255, 148, 212, 163, 255, 149, 212, 163, 255, 149, 213, 163, 255, 150, 213, 163, 255, 151, 213, 163, 255, 151, 213, 163, 255, 152, 214, 163, 255, 153, 214, 163, 255, 153, 214, 163, 255, 154, 214, 163, 255, 155, 215, 163, 255, 155, 215, 163, 255, 156, 215, 163, 255, 157, 215, 163, 255, 157, 216, 163, 255, 158, 216, 163, 255, 159, 216, 163, 255, 160, 216, 163, 255, 160, 217, 163, 255, 161, 217, 163, 255, 162, 217, 163, 255, 162, 217, 163, 255, 163, 218, 163, 255, 164, 218, 163, 255, 164, 218, 163, 255, 165, 218, 163, 255, 166, 219, 163, 255, 166, 219, 163, 255, 167, 219, 163, 255, 168, 219, 163, 255, 168, 220, 163, 255, 169, 220, 163, 255, 170, 220, 163, 255, 170, 220, 163, 255, 171, 221, 163, 255, 171, 221, 163, 255, 172, 221, 163, 255, 172, 222, 163, 255, 173, 222, 163, 255, 173, 222, 163, 255, 174, 222, 163, 255, 174, 223, 163, 255, 175, 223, 163, 255, 175, 223, 162, 255, 176, 223, 162, 255, 176, 224, 162, 255, 177, 224, 162, 255, 177, 224, 162, 255, 178, 224, 162, 255, 178, 225, 162, 255, 179, 225, 162, 255, 179, 225, 162, 255, 180, 225, 161, 255, 180, 226, 161, 255, 181, 226, 161, 255, 181, 226, 161, 255, 182, 226, 161, 255, 182, 227, 161, 255, 183, 227, 161, 255, 183, 227, 161, 255, 184, 227, 161, 255, 184, 228, 160, 255, 185, 228, 160, 255, 185, 228, 160, 255, 186, 228, 160, 255, 186, 229, 160, 255, 187, 229, 160, 255, 188, 229, 160, 255, 188, 229, 160, 255, 189, 230, 159, 255, 189, 230, 159, 255, 190, 230, 159, 255, 190, 230, 159, 255, 191, 231, 159, 255, 191, 231, 159, 255, 192, 231, 159, 255, 193, 231, 159, 255, 193, 232, 158, 255, 194, 232, 158, 255, 194, 232, 158, 255, 195, 232, 158, 255, 195, 233, 158, 255, 196, 233, 158, 255, 197, 233, 158, 255, 197, 233, 158, 255, 198, 233, 158, 255, 198, 234, 157, 255, 199, 234, 157, 255, 199, 234, 157, 255, 200, 234, 157, 255, 201, 235, 157, 255, 201, 235, 157, 255, 202, 235, 157, 255, 202, 235, 157, 255, 203, 236, 156, 255, 204, 236, 156, 255, 204, 236, 156, 255, 205, 236, 156, 255, 205, 236, 156, 255, 206, 237, 156, 255, 207, 237, 156, 255, 207, 237, 156, 255, 208, 237, 155, 255, 208, 238, 155, 255, 209, 238, 155, 255, 210, 238, 155, 255, 210, 238, 155, 255, 211, 238, 155, 255, 212, 239, 155, 255, 212, 239, 155, 255, 213, 239, 154, 255, 213, 239, 154, 255, 214, 240, 154, 255, 215, 240, 154, 255, 215, 240, 154, 255, 216, 240, 154, 255, 217, 240, 154, 255, 217, 241, 154, 255, 218, 241, 153, 255, 219, 241, 153, 255, 219, 241, 153, 255, 220, 242, 153, 255, 220, 242, 153, 255, 221, 242, 153, 255, 222, 242, 153, 255, 222, 242, 153, 255, 223, 243, 153, 255, 224, 243, 152, 255, 224, 243, 152, 255, 225, 243, 152, 255, 226, 243, 152, 255, 226, 244, 152, 255, 227, 244, 152, 255, 228, 244, 152, 255, 228, 244, 152, 255, 229, 244, 152, 255, 230, 244, 152, 255, 230, 244, 152, 255, 230, 244, 152, 255, 230, 244, 152, 255, 230, 244, 152, 255, 230, 244, 152, 255, 230, 244, 152, 255, 230, 244, 153, 255, 231, 244, 153, 255, 231, 244, 153, 255, 231, 244, 153, 255, 231, 244, 153, 255, 231, 244, 153, 255, 231, 244, 153, 255, 231, 244, 154, 255, 231, 244, 154, 255, 232, 244, 154, 255, 232, 244, 154, 255, 232, 244, 154, 255, 232, 244, 154, 255, 232, 244, 154, 255, 232, 244, 155, 255, 232, 244, 155, 255, 232, 244, 155, 255, 232, 244, 155, 255, 233, 244, 155, 255, 233, 244, 155, 255, 233, 244, 155, 255, 233, 244, 156, 255, 233, 244, 156, 255, 233, 244, 156, 255, 233, 244, 156, 255, 233, 244, 156, 255, 233, 244, 156, 255, 234, 244, 156, 255, 234, 244, 157, 255, 234, 244, 157, 255, 234, 244, 157, 255, 234, 244, 157, 255, 234, 244, 157, 255, 234, 244, 157, 255, 234, 244, 157, 255, 234, 244, 158, 255, 235, 244, 158, 255, 235, 244, 158, 255, 235, 244, 158, 255, 235, 244, 158, 255, 235, 243, 158, 255, 235, 243, 158, 255, 235, 243, 159, 255, 235, 243, 159, 255, 235, 243, 159, 255, 236, 243, 159, 255, 236, 243, 159, 255, 236, 243, 159, 255, 236, 243, 159, 255, 236, 243, 160, 255, 236, 243, 160, 255, 236, 243, 160, 255, 236, 243, 160, 255, 236, 243, 160, 255, 237, 243, 160, 255, 237, 243, 160, 255, 237, 243, 161, 255, 237, 243, 161, 255, 237, 243, 161, 255, 237, 243, 161, 255, 237, 243, 161, 255, 237, 243, 161, 255, 237, 243, 162, 255, 237, 243, 162, 255, 238, 243, 162, 255, 238, 243, 162, 255, 238, 243, 162, 255, 238, 243, 162, 255, 238, 243, 162, 255, 238, 243, 163, 255, 238, 243, 163, 255, 238, 243, 163, 255, 238, 243, 163, 255, 238, 243, 163, 255, 239, 243, 163, 255, 239, 243, 163, 255, 239, 243, 164, 255, 239, 243, 164, 255, 239, 243, 164, 255, 239, 243, 164, 255, 239, 243, 164, 255, 239, 243, 164, 255, 239, 243, 165, 255, 239, 243, 165, 255, 239, 243, 165, 255, 240, 243, 165, 255, 240, 243, 165, 255, 240, 243, 165, 255, 240, 243, 165, 255, 240, 243, 166, 255, 240, 243, 166, 255, 240, 243, 166, 255, 240, 243, 166, 255, 240, 243, 166, 255, 240, 243, 166, 255, 240, 243, 166, 255, 241, 242, 166, 255, 241, 242, 166, 255, 241, 242, 166, 255, 241, 242, 165, 255, 241, 242, 165, 255, 241, 241, 165, 255, 241, 241, 165, 255, 241, 241, 164, 255, 242, 241, 164, 255, 242, 241, 164, 255, 242, 241, 164, 255, 242, 240, 163, 255, 242, 240, 163, 255, 242, 240, 163, 255, 242, 240, 163, 255, 242, 240, 162, 255, 243, 239, 162, 255, 243, 239, 162, 255, 243, 239, 162, 255, 243, 239, 161, 255, 243, 239, 161, 255, 243, 239, 161, 255, 243, 238, 161, 255, 243, 238, 160, 255, 244, 238, 160, 255, 244, 238, 160, 255, 244, 238, 160, 255, 244, 238, 159, 255, 244, 237, 159, 255, 244, 237, 159, 255, 244, 237, 159, 255, 244, 237, 159, 255, 245, 237, 158, 255, 245, 236, 158, 255, 245, 236, 158, 255, 245, 236, 158, 255, 245, 236, 157, 255, 245, 236, 157, 255, 245, 236, 157, 255, 245, 235, 157, 255, 246, 235, 156, 255, 246, 235, 156, 255, 246, 235, 156, 255, 246, 235, 156, 255, 246, 234, 155, 255, 246, 234, 155, 255, 246, 234, 155, 255, 246, 234, 155, 255, 247, 234, 155, 255, 247, 233, 154, 255, 247, 233, 154, 255, 247, 233, 154, 255, 247, 233, 154, 255, 247, 233, 153, 255, 247, 233, 153, 255, 247, 232, 153, 255, 248, 232, 153, 255, 248, 232, 153, 255, 248, 232, 152, 255, 248, 232, 152, 255, 248, 231, 152, 255, 248, 231, 152, 255, 248, 231, 151, 255, 248, 231, 151, 255, 249, 231, 151, 255, 249, 231, 151, 255, 249, 230, 151, 255, 249, 230, 150, 255, 249, 230, 150, 255, 249, 230, 150, 255, 249, 230, 150, 255, 250, 229, 150, 255, 250, 229, 149, 255, 250, 229, 149, 255, 250, 229, 149, 255, 250, 229, 149, 255, 250, 228, 148, 255, 250, 228, 148, 255, 250, 228, 148, 255, 251, 228, 148, 255, 251, 228, 148, 255, 251, 227, 147, 255, 251, 227, 147, 255, 251, 227, 147, 255, 251, 227, 147, 255, 251, 227, 147, 255, 251, 226, 146, 255, 252, 226, 146, 255, 252, 226, 146, 255, 252, 226, 146, 255, 252, 226, 146, 255, 252, 226, 145, 255, 252, 225, 145, 255, 252, 225, 145, 255, 253, 225, 145, 255, 253, 225, 145, 255, 253, 225, 145, 255, 253, 224, 144, 255, 253, 224, 144, 255, 253, 224, 144, 255, 253, 224, 144, 255, 253, 224, 144, 255, 253, 223, 143, 255, 253, 223, 143, 255, 253, 222, 142, 255, 253, 222, 142, 255, 253, 221, 141, 255, 253, 221, 140, 255, 253, 220, 140, 255, 253, 220, 139, 255, 253, 220, 139, 255, 253, 219, 138, 255, 253, 219, 138, 255, 253, 218, 137, 255, 253, 218, 137, 255, 253, 217, 136, 255, 253, 217, 136, 255, 253, 216, 135, 255, 253, 216, 134, 255, 253, 215, 134, 255, 253, 215, 133, 255, 253, 214, 133, 255, 253, 214, 132, 255, 253, 213, 132, 255, 253, 213, 131, 255, 253, 212, 131, 255, 253, 212, 130, 255, 253, 212, 130, 255, 253, 211, 129, 255, 253, 211, 129, 255, 253, 210, 128, 255, 253, 210, 128, 255, 253, 209, 127, 255, 253, 209, 127, 255, 253, 208, 126, 255, 253, 208, 126, 255, 253, 207, 125, 255, 253, 207, 125, 255, 253, 206, 124, 255, 253, 206, 124, 255, 253, 205, 123, 255, 253, 205, 123, 255, 253, 204, 122, 255, 253, 204, 122, 255, 253, 203, 121, 255, 253, 203, 121, 255, 253, 202, 120, 255, 253, 202, 120, 255, 253, 201, 119, 255, 253, 201, 119, 255, 253, 200, 118, 255, 253, 200, 118, 255, 253, 200, 118, 255, 253, 199, 117, 255, 253, 199, 117, 255, 253, 198, 116, 255, 253, 198, 116, 255, 253, 197, 115, 255, 253, 197, 115, 255, 253, 196, 114, 255, 253, 196, 114, 255, 253, 195, 113, 255, 253, 195, 113, 255, 253, 194, 113, 255, 253, 194, 112, 255, 253, 193, 112, 255, 253, 193, 111, 255, 253, 192, 111, 255, 253, 192, 110, 255, 253, 191, 110, 255, 253, 191, 110, 255, 253, 190, 109, 255, 253, 190, 109, 255, 253, 189, 108, 255, 253, 189, 108, 255, 253, 188, 107, 255, 253, 188, 107, 255, 253, 187, 107, 255, 253, 187, 106, 255, 253, 186, 106, 255, 253, 186, 105, 255, 253, 185, 105, 255, 253, 185, 105, 255, 253, 184, 104, 255, 253, 184, 104, 255, 253, 183, 103, 255, 253, 183, 103, 255, 253, 182, 103, 255, 253, 182, 102, 255, 253, 181, 102, 255, 253, 181, 101, 255, 253, 180, 101, 255, 253, 180, 101, 255, 253, 179, 100, 255, 253, 179, 100, 255, 253, 178, 100, 255, 253, 178, 99, 255, 253, 177, 99, 255, 253, 176, 99, 255, 253, 176, 98, 255, 253, 175, 98, 255, 253, 175, 97, 255, 253, 174, 97, 255, 253, 174, 97, 255, 252, 173, 96, 255, 252, 173, 96, 255, 252, 172, 96, 255, 252, 172, 95, 255, 252, 171, 95, 255, 252, 170, 94, 255, 252, 170, 94, 255, 252, 169, 93, 255, 252, 169, 93, 255, 252, 168, 93, 255, 252, 167, 92, 255, 252, 167, 92, 255, 252, 166, 91, 255, 252, 166, 91, 255, 251, 165, 90, 255, 251, 165, 90, 255, 251, 164, 90, 255, 251, 163, 89, 255, 251, 163, 89, 255, 251, 162, 89, 255, 251, 162, 88, 255, 251, 161, 88, 255, 251, 160, 87, 255, 251, 160, 87, 255, 251, 159, 87, 255, 251, 159, 86, 255, 251, 158, 86, 255, 251, 157, 85, 255, 250, 157, 85, 255, 250, 156, 85, 255, 250, 155, 84, 255, 250, 155, 84, 255, 250, 154, 84, 255, 250, 154, 83, 255, 250, 153, 83, 255, 250, 152, 83, 255, 250, 152, 82, 255, 250, 151, 82, 255, 250, 151, 82, 255, 250, 150, 81, 255, 250, 149, 81, 255, 249, 149, 81, 255, 249, 148, 80, 255, 249, 147, 80, 255, 249, 147, 80, 255, 249, 146, 79, 255, 249, 146, 79, 255, 249, 145, 79, 255, 249, 144, 78, 255, 249, 144, 78, 255, 249, 143, 78, 255, 249, 142, 78, 255, 249, 142, 77, 255, 248, 141, 77, 255, 248, 141, 77, 255, 248, 140, 76, 255, 248, 139, 76, 255, 248, 139, 76, 255, 248, 138, 76, 255, 248, 137, 75, 255, 248, 137, 75, 255, 248, 136, 75, 255, 248, 135, 74, 255, 248, 135, 74, 255, 247, 134, 74, 255, 247, 134, 74, 255, 247, 133, 73, 255, 247, 132, 73, 255, 247, 132, 73, 255, 247, 131, 73, 255, 247, 130, 72, 255, 247, 130, 72, 255, 247, 129, 72, 255, 247, 128, 72, 255, 247, 128, 72, 255, 246, 127, 71, 255, 246, 126, 71, 255, 246, 126, 71, 255, 246, 125, 71, 255, 246, 124, 70, 255, 246, 124, 70, 255, 246, 123, 70, 255, 246, 122, 70, 255, 246, 122, 70, 255, 246, 121, 69, 255, 245, 120, 69, 255, 245, 120, 69, 255, 245, 119, 69, 255, 245, 118, 69, 255, 245, 118, 69, 255, 245, 117, 68, 255, 245, 116, 68, 255, 245, 116, 68, 255, 245, 115, 68, 255, 244, 114, 68, 255, 244, 114, 68, 255, 244, 113, 67, 255, 244, 112, 67, 255, 244, 111, 67, 255, 244, 111, 67, 255, 244, 110, 67, 255, 244, 109, 67, 255, 244, 109, 67, 255, 243, 108, 67, 255, 243, 108, 67, 255, 243, 107, 67, 255, 243, 107, 67, 255, 242, 106, 67, 255, 242, 106, 67, 255, 242, 105, 67, 255, 242, 105, 67, 255, 241, 104, 68, 255, 241, 104, 68, 255, 241, 103, 68, 255, 241, 103, 68, 255, 240, 102, 68, 255, 240, 102, 68, 255, 240, 101, 68, 255, 240, 101, 68, 255, 239, 101, 69, 255, 239, 100, 69, 255, 239, 100, 69, 255, 239, 99, 69, 255, 238, 99, 69, 255, 238, 98, 69, 255, 238, 98, 69, 255, 237, 97, 69, 255, 237, 97, 70, 255, 237, 96, 70, 255, 237, 96, 70, 255, 236, 95, 70, 255, 236, 95, 70, 255, 236, 94, 70, 255, 236, 94, 70, 255, 235, 93, 70, 255, 235, 93, 71, 255, 235, 93, 71, 255, 234, 92, 71, 255, 234, 92, 71, 255, 234, 91, 71, 255, 234, 91, 71, 255, 233, 90, 71, 255, 233, 90, 71, 255, 233, 89, 72, 255, 232, 89, 72, 255, 232, 88, 72, 255, 232, 88, 72, 255, 232, 87, 72, 255, 231, 87, 72, 255, 231, 87, 72, 255, 231, 86, 72, 255, 230, 86, 73, 255, 230, 85, 73, 255, 230, 85, 73, 255, 229, 84, 73, 255, 229, 84, 73, 255, 229, 83, 73, 255, 229, 83, 73, 255, 228, 82, 73, 255, 228, 82, 73, 255, 228, 81, 74, 255, 227, 81, 74, 255, 227, 81, 74, 255, 227, 80, 74, 255, 226, 80, 74, 255, 226, 79, 74, 255, 226, 79, 74, 255, 225, 78, 74, 255, 225, 78, 75, 255, 225, 77, 75, 255, 224, 77, 75, 255, 224, 76, 75, 255, 224, 76, 75, 255, 223, 76, 75, 255, 223, 75, 75, 255, 223, 75, 75, 255, 222, 74, 75, 255, 222, 74, 76, 255, 222, 73, 76, 255, 221, 73, 76, 255, 221, 72, 76, 255, 221, 72, 76, 255, 220, 72, 76, 255, 220, 71, 76, 255, 220, 71, 76, 255, 219, 70, 76, 255, 219, 70, 77, 255, 219, 69, 77, 255, 218, 69, 77, 255, 218, 68, 77, 255, 218, 68, 77, 255, 217, 68, 77, 255, 217, 67, 77, 255, 217, 67, 77, 255, 216, 66, 77, 255, 216, 66, 78, 255, 216, 65, 78, 255, 215, 65, 78, 255, 215, 64, 78, 255, 215, 64, 78, 255, 214, 64, 78, 255, 214, 63, 78, 255, 213, 63, 78, 255, 213, 62, 78, 255, 213, 62, 78, 255, 212, 61, 78, 255, 212, 61, 78, 255, 211, 60, 78, 255, 211, 60, 78, 255, 210, 59, 78, 255, 210, 59, 78, 255, 209, 58, 78, 255, 209, 58, 78, 255, 208, 57, 78, 255, 208, 57, 77, 255, 207, 56, 77, 255, 207, 56, 77, 255, 206, 55, 77, 255, 205, 55, 77, 255, 205, 55, 77, 255, 204, 54, 77, 255, 204, 54, 77, 255, 203, 53, 77, 255, 203, 53, 76, 255, 202, 52, 76, 255, 202, 52, 76, 255, 201, 51, 76, 255, 201, 51, 76, 255, 200, 50, 76, 255, 200, 50, 76, 255, 199, 49, 76, 255, 199, 49, 76, 255, 198, 48, 75, 255, 197, 48, 75, 255, 197, 47, 75, 255, 196, 47, 75, 255, 196, 46, 75, 255, 195, 46, 75, 255, 195, 45, 75, 255, 194, 45, 75, 255, 194, 44, 74, 255, 193, 44, 74, 255, 193, 43, 74, 255, 192, 43, 74, 255, 192, 42, 74, 255, 191, 42, 74, 255, 191, 41, 74, 255, 190, 41, 74, 255, 189, 40, 73, 255, 189, 39, 73, 255, 188, 39, 73, 255, 188, 38, 73, 255, 187, 38, 73, 255, 187, 37, 73, 255, 186, 37, 73, 255, 186, 36, 73, 255, 185, 36, 72, 255, 185, 35, 72, 255, 184, 35, 72, 255, 184, 34, 72, 255, 183, 34, 72, 255, 182, 33, 72, 255, 182, 33, 72, 255, 181, 32, 72, 255, 181, 31, 71, 255, 180, 31, 71, 255, 180, 30, 71, 255, 179, 30, 71, 255, 179, 29, 71, 255, 178, 29, 71, 255, 178, 28, 71, 255, 177, 27, 71, 255, 177, 27, 70, 255, 176, 26, 70, 255, 175, 26, 70, 255, 175, 25, 70, 255, 174, 25, 70, 255, 174, 24, 70, 255, 173, 23, 70, 255, 173, 23, 69, 255, 172, 22, 69, 255, 172, 21, 69, 255, 171, 21, 69, 255, 171, 20, 69, 255, 170, 19, 69, 255, 169, 19, 69, 255, 169, 18, 68, 255, 168, 17, 68, 255, 168, 17, 68, 255, 167, 16, 68, 255, 167, 15, 68, 255, 166, 14, 68, 255, 166, 14, 68, 255, 165, 13, 68, 255, 165, 12, 67, 255, 164, 11, 67, 255, 164, 10, 67, 255, 163, 9, 67, 255, 162, 8, 67, 255, 162, 7, 67, 255, 161, 6, 67, 255, 161, 6, 66, 255, 160, 5, 66, 255, 160, 4, 66, 255, 159, 3, 66, 255, 159, 2, 66, 255, 158, 1, 66, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Spectral_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 94, 79, 162, 0, 93, 79, 162, 7, 93, 80, 162, 14, 92, 80, 163, 22, 92, 81, 163, 29, 91, 81, 164, 37, 91, 82, 164, 44, 90, 82, 164, 52, 90, 83, 165, 59, 89, 83, 165, 67, 89, 84, 166, 74, 88, 84, 166, 82, 88, 85, 166, 89, 87, 85, 167, 97, 87, 86, 167, 104, 86, 86, 167, 112, 86, 87, 168, 119, 85, 87, 168, 127, 85, 88, 168, 134, 84, 88, 169, 141, 84, 89, 169, 149, 83, 89, 169, 156, 83, 90, 170, 164, 83, 90, 170, 171, 82, 91, 170, 179, 82, 91, 171, 186, 81, 92, 171, 194, 81, 92, 171, 201, 80, 93, 172, 209, 80, 93, 172, 216, 79, 94, 172, 224, 79, 94, 172, 231, 78, 95, 173, 239, 78, 95, 173, 246, 77, 95, 173, 254, 77, 96, 174, 255, 76, 96, 174, 255, 76, 97, 174, 255, 75, 97, 174, 255, 75, 98, 175, 255, 74, 98, 175, 255, 74, 99, 175, 255, 73, 99, 175, 255, 73, 100, 176, 255, 72, 100, 176, 255, 72, 101, 176, 255, 72, 101, 176, 255, 71, 101, 176, 255, 71, 102, 177, 255, 70, 102, 177, 255, 70, 103, 177, 255, 69, 103, 177, 255, 60, 115, 183, 255, 60, 115, 183, 255, 59, 116, 183, 255, 59, 116, 183, 255, 58, 117, 184, 255, 58, 117, 184, 255, 58, 118, 184, 255, 57, 118, 184, 255, 57, 118, 184, 255, 56, 119, 184, 255, 56, 119, 185, 255, 56, 120, 185, 255, 55, 120, 185, 255, 55, 121, 185, 255, 55, 121, 185, 255, 54, 121, 185, 255, 54, 122, 186, 255, 54, 122, 186, 255, 53, 123, 186, 255, 53, 123, 186, 255, 53, 124, 186, 255, 52, 124, 186, 255, 52, 124, 186, 255, 52, 125, 186, 255, 52, 125, 187, 255, 51, 126, 187, 255, 51, 126, 187, 255, 51, 126, 187, 255, 51, 127, 187, 255, 50, 127, 187, 255, 50, 128, 187, 255, 50, 128, 187, 255, 50, 128, 187, 255, 50, 129, 187, 255, 50, 129, 188, 255, 50, 130, 188, 255, 49, 130, 188, 255, 49, 130, 188, 255, 49, 131, 188, 255, 49, 131, 188, 255, 49, 132, 188, 255, 49, 132, 188, 255, 49, 132, 188, 255, 49, 133, 188, 255, 49, 133, 188, 255, 49, 133, 188, 255, 49, 134, 188, 255, 49, 134, 188, 255, 49, 135, 188, 255, 49, 135, 188, 255, 49, 135, 188, 255, 49, 136, 189, 255, 47, 136, 189, 255, 46, 137, 189, 255, 45, 138, 189, 255, 43, 138, 189, 255, 42, 139, 190, 255, 41, 139, 190, 255, 39, 140, 190, 255, 38, 140, 190, 255, 36, 141, 190, 255, 35, 141, 190, 255, 33, 142, 190, 255, 31, 142, 190, 255, 30, 143, 190, 255, 28, 143, 190, 255, 26, 144, 191, 255, 24, 145, 191, 255, 22, 145, 191, 255, 20, 146, 191, 255, 17, 146, 191, 255, 15, 147, 191, 255, 12, 147, 191, 255, 10, 148, 191, 255, 10, 148, 191, 255, 10, 149, 191, 255, 10, 149, 191, 255, 10, 150, 191, 255, 10, 150, 190, 255, 10, 151, 190, 255, 10, 151, 190, 255, 10, 152, 190, 255, 10, 152, 190, 255, 10, 153, 190, 255, 10, 153, 190, 255, 10, 154, 190, 255, 10, 154, 190, 255, 10, 155, 190, 255, 10, 155, 189, 255, 10, 156, 189, 255, 10, 156, 189, 255, 10, 157, 189, 255, 10, 157, 189, 255, 10, 158, 189, 255, 10, 158, 188, 255, 10, 158, 188, 255, 10, 159, 188, 255, 10, 159, 188, 255, 10, 160, 188, 255, 10, 160, 187, 255, 10, 161, 187, 255, 10, 161, 187, 255, 20, 173, 182, 255, 22, 174, 182, 255, 25, 174, 181, 255, 28, 175, 181, 255, 30, 175, 181, 255, 33, 176, 180, 255, 35, 176, 180, 255, 37, 176, 180, 255, 39, 177, 180, 255, 41, 177, 179, 255, 43, 178, 179, 255, 45, 178, 179, 255, 46, 179, 178, 255, 48, 179, 178, 255, 50, 179, 178, 255, 51, 180, 177, 255, 53, 180, 177, 255, 54, 181, 177, 255, 56, 181, 176, 255, 58, 182, 176, 255, 59, 182, 176, 255, 61, 182, 175, 255, 62, 183, 175, 255, 64, 183, 175, 255, 65, 184, 174, 255, 66, 184, 174, 255, 68, 184, 174, 255, 69, 185, 173, 255, 71, 185, 173, 255, 72, 186, 173, 255, 74, 186, 172, 255, 75, 186, 172, 255, 76, 187, 171, 255, 78, 187, 171, 255, 79, 187, 171, 255, 80, 188, 170, 255, 82, 188, 170, 255, 83, 189, 170, 255, 85, 189, 169, 255, 86, 189, 169, 255, 87, 190, 169, 255, 89, 190, 168, 255, 90, 190, 168, 255, 91, 191, 167, 255, 93, 191, 167, 255, 94, 191, 167, 255, 95, 192, 166, 255, 97, 192, 166, 255, 98, 193, 166, 255, 99, 193, 165, 255, 100, 193, 165, 255, 102, 194, 164, 255, 102, 194, 164, 255, 103, 194, 164, 255, 103, 194, 164, 255, 104, 194, 164, 255, 104, 195, 164, 255, 105, 195, 164, 255, 105, 195, 164, 255, 106, 195, 164, 255, 106, 196, 164, 255, 107, 196, 164, 255, 108, 196, 164, 255, 108, 196, 164, 255, 109, 196, 164, 255, 109, 197, 164, 255, 110, 197, 164, 255, 110, 197, 164, 255, 111, 197, 164, 255, 111, 198, 164, 255, 112, 198, 164, 255, 112, 198, 164, 255, 113, 198, 164, 255, 113, 198, 164, 255, 114, 199, 164, 255, 115, 199, 164, 255, 115, 199, 164, 255, 116, 199, 164, 255, 116, 200, 164, 255, 117, 200, 164, 255, 117, 200, 164, 255, 118, 200, 164, 255, 118, 200, 164, 255, 119, 201, 164, 255, 119, 201, 164, 255, 120, 201, 164, 255, 120, 201, 164, 255, 121, 201, 164, 255, 122, 202, 164, 255, 122, 202, 164, 255, 123, 202, 164, 255, 123, 202, 164, 255, 124, 203, 164, 255, 124, 203, 164, 255, 125, 203, 164, 255, 125, 203, 164, 255, 126, 203, 164, 255, 126, 204, 164, 255, 127, 204, 164, 255, 127, 204, 163, 255, 128, 204, 163, 255, 129, 204, 163, 255, 143, 210, 163, 255, 143, 210, 163, 255, 144, 210, 163, 255, 144, 211, 163, 255, 145, 211, 163, 255, 146, 211, 163, 255, 146, 211, 163, 255, 147, 212, 163, 255, 147, 212, 163, 255, 148, 212, 163, 255, 148, 212, 163, 255, 149, 212, 163, 255, 149, 213, 163, 255, 150, 213, 163, 255, 150, 213, 163, 255, 151, 213, 163, 255, 151, 213, 163, 255, 152, 214, 163, 255, 153, 214, 163, 255, 153, 214, 163, 255, 154, 214, 163, 255, 154, 214, 163, 255, 155, 215, 163, 255, 155, 215, 163, 255, 156, 215, 163, 255, 156, 215, 163, 255, 157, 215, 163, 255, 157, 216, 163, 255, 158, 216, 163, 255, 158, 216, 163, 255, 159, 216, 163, 255, 160, 216, 163, 255, 160, 217, 163, 255, 161, 217, 163, 255, 161, 217, 163, 255, 162, 217, 163, 255, 162, 217, 163, 255, 163, 218, 163, 255, 163, 218, 163, 255, 164, 218, 163, 255, 164, 218, 163, 255, 165, 218, 163, 255, 166, 219, 163, 255, 166, 219, 163, 255, 167, 219, 163, 255, 167, 219, 163, 255, 168, 219, 163, 255, 168, 220, 163, 255, 169, 220, 163, 255, 169, 220, 163, 255, 170, 220, 163, 255, 170, 220, 163, 255, 171, 221, 163, 255, 171, 221, 163, 255, 172, 221, 163, 255, 172, 221, 163, 255, 172, 222, 163, 255, 173, 222, 163, 255, 173, 222, 163, 255, 173, 222, 163, 255, 174, 222, 163, 255, 174, 223, 163, 255, 175, 223, 163, 255, 175, 223, 163, 255, 175, 223, 162, 255, 176, 223, 162, 255, 176, 224, 162, 255, 177, 224, 162, 255, 177, 224, 162, 255, 177, 224, 162, 255, 178, 224, 162, 255, 178, 225, 162, 255, 179, 225, 162, 255, 179, 225, 162, 255, 179, 225, 162, 255, 180, 225, 161, 255, 180, 226, 161, 255, 181, 226, 161, 255, 181, 226, 161, 255, 182, 226, 161, 255, 182, 226, 161, 255, 182, 227, 161, 255, 183, 227, 161, 255, 183, 227, 161, 255, 184, 227, 161, 255, 184, 227, 160, 255, 185, 228, 160, 255, 185, 228, 160, 255, 185, 228, 160, 255, 186, 228, 160, 255, 186, 228, 160, 255, 187, 229, 160, 255, 187, 229, 160, 255, 188, 229, 160, 255, 188, 229, 160, 255, 189, 229, 159, 255, 189, 230, 159, 255, 189, 230, 159, 255, 190, 230, 159, 255, 190, 230, 159, 255, 191, 230, 159, 255, 191, 231, 159, 255, 192, 231, 159, 255, 204, 236, 156, 255, 205, 236, 156, 255, 205, 236, 156, 255, 205, 236, 156, 255, 206, 236, 156, 255, 206, 237, 156, 255, 207, 237, 156, 255, 207, 237, 156, 255, 208, 237, 156, 255, 208, 237, 155, 255, 209, 238, 155, 255, 209, 238, 155, 255, 210, 238, 155, 255, 210, 238, 155, 255, 211, 238, 155, 255, 211, 238, 155, 255, 212, 239, 155, 255, 212, 239, 155, 255, 213, 239, 155, 255, 213, 239, 154, 255, 214, 239, 154, 255, 214, 240, 154, 255, 215, 240, 154, 255, 215, 240, 154, 255, 216, 240, 154, 255, 216, 240, 154, 255, 217, 240, 154, 255, 217, 241, 154, 255, 218, 241, 154, 255, 218, 241, 153, 255, 219, 241, 153, 255, 219, 241, 153, 255, 220, 241, 153, 255, 220, 242, 153, 255, 221, 242, 153, 255, 221, 242, 153, 255, 222, 242, 153, 255, 222, 242, 153, 255, 223, 242, 153, 255, 223, 243, 153, 255, 224, 243, 152, 255, 224, 243, 152, 255, 225, 243, 152, 255, 225, 243, 152, 255, 226, 243, 152, 255, 227, 244, 152, 255, 227, 244, 152, 255, 228, 244, 152, 255, 228, 244, 152, 255, 229, 244, 152, 255, 229, 244, 152, 255, 230, 244, 152, 255, 230, 244, 152, 255, 230, 244, 152, 255, 230, 244, 152, 255, 230, 244, 152, 255, 230, 244, 152, 255, 230, 244, 152, 255, 230, 244, 152, 255, 230, 244, 152, 255, 230, 244, 153, 255, 231, 244, 153, 255, 231, 244, 153, 255, 231, 244, 153, 255, 231, 244, 153, 255, 231, 244, 153, 255, 231, 244, 153, 255, 231, 244, 153, 255, 231, 244, 153, 255, 231, 244, 154, 255, 231, 244, 154, 255, 231, 244, 154, 255, 232, 244, 154, 255, 232, 244, 154, 255, 232, 244, 154, 255, 232, 244, 154, 255, 232, 244, 154, 255, 232, 244, 154, 255, 232, 244, 155, 255, 232, 244, 155, 255, 232, 244, 155, 255, 232, 244, 155, 255, 233, 244, 155, 255, 233, 244, 155, 255, 233, 244, 155, 255, 233, 244, 155, 255, 233, 244, 156, 255, 233, 244, 156, 255, 233, 244, 156, 255, 233, 244, 156, 255, 233, 244, 156, 255, 233, 244, 156, 255, 233, 244, 156, 255, 233, 244, 156, 255, 234, 244, 156, 255, 234, 244, 157, 255, 234, 244, 157, 255, 234, 244, 157, 255, 234, 244, 157, 255, 234, 244, 157, 255, 234, 244, 157, 255, 234, 244, 157, 255, 236, 243, 160, 255, 237, 243, 160, 255, 237, 243, 161, 255, 237, 243, 161, 255, 237, 243, 161, 255, 237, 243, 161, 255, 237, 243, 161, 255, 237, 243, 161, 255, 237, 243, 161, 255, 237, 243, 161, 255, 237, 243, 162, 255, 237, 243, 162, 255, 237, 243, 162, 255, 238, 243, 162, 255, 238, 243, 162, 255, 238, 243, 162, 255, 238, 243, 162, 255, 238, 243, 162, 255, 238, 243, 163, 255, 238, 243, 163, 255, 238, 243, 163, 255, 238, 243, 163, 255, 238, 243, 163, 255, 238, 243, 163, 255, 238, 243, 163, 255, 239, 243, 163, 255, 239, 243, 163, 255, 239, 243, 164, 255, 239, 243, 164, 255, 239, 243, 164, 255, 239, 243, 164, 255, 239, 243, 164, 255, 239, 243, 164, 255, 239, 243, 164, 255, 239, 243, 164, 255, 239, 243, 165, 255, 239, 243, 165, 255, 239, 243, 165, 255, 240, 243, 165, 255, 240, 243, 165, 255, 240, 243, 165, 255, 240, 243, 165, 255, 240, 243, 165, 255, 240, 243, 166, 255, 240, 243, 166, 255, 240, 243, 166, 255, 240, 243, 166, 255, 240, 243, 166, 255, 240, 243, 166, 255, 240, 243, 166, 255, 240, 243, 166, 255, 240, 243, 166, 255, 241, 242, 166, 255, 241, 242, 166, 255, 241, 242, 166, 255, 241, 242, 166, 255, 241, 242, 165, 255, 241, 242, 165, 255, 241, 242, 165, 255, 241, 241, 165, 255, 241, 241, 165, 255, 241, 241, 164, 255, 242, 241, 164, 255, 242, 241, 164, 255, 242, 241, 164, 255, 242, 241, 164, 255, 242, 240, 163, 255, 242, 240, 163, 255, 242, 240, 163, 255, 242, 240, 163, 255, 242, 240, 163, 255, 242, 240, 162, 255, 243, 240, 162, 255, 243, 239, 162, 255, 243, 239, 162, 255, 243, 239, 162, 255, 243, 239, 161, 255, 243, 239, 161, 255, 243, 239, 161, 255, 243, 239, 161, 255, 243, 238, 161, 255, 243, 238, 161, 255, 244, 238, 160, 255, 244, 238, 160, 255, 244, 238, 160, 255, 244, 238, 160, 255, 244, 238, 160, 255, 244, 237, 159, 255, 244, 237, 159, 255, 244, 237, 159, 255, 244, 237, 159, 255, 244, 237, 159, 255, 245, 237, 158, 255, 245, 236, 158, 255, 245, 236, 158, 255, 245, 236, 158, 255, 245, 236, 158, 255, 245, 236, 157, 255, 245, 236, 157, 255, 245, 236, 157, 255, 245, 235, 157, 255, 245, 235, 157, 255, 246, 235, 157, 255, 248, 231, 152, 255, 248, 231, 152, 255, 248, 231, 151, 255, 249, 231, 151, 255, 249, 231, 151, 255, 249, 230, 151, 255, 249, 230, 151, 255, 249, 230, 151, 255, 249, 230, 150, 255, 249, 230, 150, 255, 249, 230, 150, 255, 249, 230, 150, 255, 249, 229, 150, 255, 250, 229, 150, 255, 250, 229, 149, 255, 250, 229, 149, 255, 250, 229, 149, 255, 250, 229, 149, 255, 250, 229, 149, 255, 250, 228, 148, 255, 250, 228, 148, 255, 250, 228, 148, 255, 251, 228, 148, 255, 251, 228, 148, 255, 251, 228, 148, 255, 251, 227, 147, 255, 251, 227, 147, 255, 251, 227, 147, 255, 251, 227, 147, 255, 251, 227, 147, 255, 251, 227, 147, 255, 251, 227, 147, 255, 252, 226, 146, 255, 252, 226, 146, 255, 252, 226, 146, 255, 252, 226, 146, 255, 252, 226, 146, 255, 252, 226, 146, 255, 252, 225, 145, 255, 252, 225, 145, 255, 252, 225, 145, 255, 253, 225, 145, 255, 253, 225, 145, 255, 253, 225, 145, 255, 253, 225, 144, 255, 253, 224, 144, 255, 253, 224, 144, 255, 253, 224, 144, 255, 253, 224, 144, 255, 253, 224, 144, 255, 253, 224, 144, 255, 253, 223, 143, 255, 253, 223, 143, 255, 253, 223, 142, 255, 253, 222, 142, 255, 253, 222, 141, 255, 253, 221, 141, 255, 253, 221, 141, 255, 253, 221, 140, 255, 253, 220, 140, 255, 253, 220, 139, 255, 253, 220, 139, 255, 253, 219, 138, 255, 253, 219, 138, 255, 253, 218, 138, 255, 253, 218, 137, 255, 253, 218, 137, 255, 253, 217, 136, 255, 253, 217, 136, 255, 253, 217, 135, 255, 253, 216, 135, 255, 253, 216, 135, 255, 253, 215, 134, 255, 253, 215, 134, 255, 253, 215, 133, 255, 253, 214, 133, 255, 253, 214, 133, 255, 253, 214, 132, 255, 253, 213, 132, 255, 253, 213, 131, 255, 253, 212, 131, 255, 253, 212, 131, 255, 253, 212, 130, 255, 253, 211, 130, 255, 253, 211, 129, 255, 253, 211, 129, 255, 253, 210, 129, 255, 253, 210, 128, 255, 253, 209, 128, 255, 253, 209, 127, 255, 253, 209, 127, 255, 253, 208, 127, 255, 253, 208, 126, 255, 253, 207, 126, 255, 253, 207, 125, 255, 253, 207, 125, 255, 253, 206, 125, 255, 253, 206, 124, 255, 253, 205, 124, 255, 253, 205, 123, 255, 253, 205, 123, 255, 253, 204, 123, 255, 253, 194, 113, 255, 253, 194, 113, 255, 253, 193, 112, 255, 253, 193, 112, 255, 253, 192, 112, 255, 253, 192, 111, 255, 253, 192, 111, 255, 253, 191, 110, 255, 253, 191, 110, 255, 253, 190, 110, 255, 253, 190, 109, 255, 253, 190, 109, 255, 253, 189, 109, 255, 253, 189, 108, 255, 253, 188, 108, 255, 253, 188, 108, 255, 253, 188, 107, 255, 253, 187, 107, 255, 253, 187, 107, 255, 253, 186, 106, 255, 253, 186, 106, 255, 253, 186, 106, 255, 253, 185, 105, 255, 253, 185, 105, 255, 253, 184, 105, 255, 253, 184, 104, 255, 253, 184, 104, 255, 253, 183, 104, 255, 253, 183, 103, 255, 253, 182, 103, 255, 253, 182, 103, 255, 253, 182, 102, 255, 253, 181, 102, 255, 253, 181, 102, 255, 253, 180, 101, 255, 253, 180, 101, 255, 253, 180, 101, 255, 253, 179, 100, 255, 253, 179, 100, 255, 253, 178, 100, 255, 253, 178, 100, 255, 253, 178, 99, 255, 253, 177, 99, 255, 253, 177, 99, 255, 253, 176, 98, 255, 253, 176, 98, 255, 253, 175, 98, 255, 253, 175, 98, 255, 253, 175, 97, 255, 253, 174, 97, 255, 253, 174, 97, 255, 252, 173, 96, 255, 252, 173, 96, 255, 252, 172, 96, 255, 252, 172, 95, 255, 252, 172, 95, 255, 252, 171, 95, 255, 252, 171, 94, 255, 252, 170, 94, 255, 252, 170, 94, 255, 252, 169, 93, 255, 252, 169, 93, 255, 252, 168, 93, 255, 252, 168, 92, 255, 252, 167, 92, 255, 252, 167, 92, 255, 252, 166, 91, 255, 252, 166, 91, 255, 252, 165, 91, 255, 251, 165, 90, 255, 251, 164, 90, 255, 251, 164, 90, 255, 251, 163, 89, 255, 251, 163, 89, 255, 251, 162, 89, 255, 251, 162, 89, 255, 251, 162, 88, 255, 251, 161, 88, 255, 251, 161, 88, 255, 251, 160, 87, 255, 251, 160, 87, 255, 251, 159, 87, 255, 251, 159, 87, 255, 251, 158, 86, 255, 251, 158, 86, 255, 251, 157, 86, 255, 250, 157, 85, 255, 250, 156, 85, 255, 250, 156, 85, 255, 250, 155, 85, 255, 250, 155, 84, 255, 250, 154, 84, 255, 250, 154, 84, 255, 250, 153, 84, 255, 250, 153, 83, 255, 250, 152, 83, 255, 250, 152, 83, 255, 250, 151, 83, 255, 250, 151, 82, 255, 250, 150, 82, 255, 250, 150, 82, 255, 249, 149, 82, 255, 248, 136, 75, 255, 248, 135, 75, 255, 247, 135, 75, 255, 247, 134, 75, 255, 247, 134, 74, 255, 247, 133, 74, 255, 247, 133, 74, 255, 247, 132, 74, 255, 247, 132, 74, 255, 247, 131, 73, 255, 247, 131, 73, 255, 247, 130, 73, 255, 247, 130, 73, 255, 247, 129, 72, 255, 247, 129, 72, 255, 247, 128, 72, 255, 246, 128, 72, 255, 246, 127, 72, 255, 246, 126, 71, 255, 246, 126, 71, 255, 246, 125, 71, 255, 246, 125, 71, 255, 246, 124, 71, 255, 246, 124, 71, 255, 246, 123, 70, 255, 246, 123, 70, 255, 246, 122, 70, 255, 246, 122, 70, 255, 246, 121, 70, 255, 245, 121, 70, 255, 245, 120, 69, 255, 245, 120, 69, 255, 245, 119, 69, 255, 245, 119, 69, 255, 245, 118, 69, 255, 245, 117, 69, 255, 245, 117, 68, 255, 245, 116, 68, 255, 245, 116, 68, 255, 245, 115, 68, 255, 245, 115, 68, 255, 244, 114, 68, 255, 244, 114, 68, 255, 244, 113, 67, 255, 244, 113, 67, 255, 244, 112, 67, 255, 244, 111, 67, 255, 244, 111, 67, 255, 244, 110, 67, 255, 244, 110, 67, 255, 244, 109, 67, 255, 244, 109, 67, 255, 243, 108, 67, 255, 243, 108, 67, 255, 243, 107, 67, 255, 243, 107, 67, 255, 243, 107, 67, 255, 242, 106, 67, 255, 242, 106, 67, 255, 242, 106, 67, 255, 242, 105, 67, 255, 242, 105, 67, 255, 241, 104, 68, 255, 241, 104, 68, 255, 241, 104, 68, 255, 241, 103, 68, 255, 241, 103, 68, 255, 240, 102, 68, 255, 240, 102, 68, 255, 240, 102, 68, 255, 240, 101, 68, 255, 240, 101, 68, 255, 239, 101, 69, 255, 239, 100, 69, 255, 239, 100, 69, 255, 239, 99, 69, 255, 238, 99, 69, 255, 238, 99, 69, 255, 238, 98, 69, 255, 238, 98, 69, 255, 238, 98, 69, 255, 237, 97, 69, 255, 237, 97, 70, 255, 237, 96, 70, 255, 237, 96, 70, 255, 236, 96, 70, 255, 236, 95, 70, 255, 236, 95, 70, 255, 236, 95, 70, 255, 236, 94, 70, 255, 235, 94, 70, 255, 235, 94, 70, 255, 235, 93, 71, 255, 235, 93, 71, 255, 234, 92, 71, 255, 234, 92, 71, 255, 234, 92, 71, 255, 234, 91, 71, 255, 233, 91, 71, 255, 233, 91, 71, 255, 233, 90, 71, 255, 233, 90, 71, 255, 233, 89, 72, 255, 226, 80, 74, 255, 226, 79, 74, 255, 226, 79, 74, 255, 225, 79, 74, 255, 225, 78, 74, 255, 225, 78, 74, 255, 225, 77, 75, 255, 224, 77, 75, 255, 224, 77, 75, 255, 224, 76, 75, 255, 224, 76, 75, 255, 223, 76, 75, 255, 223, 75, 75, 255, 223, 75, 75, 255, 223, 75, 75, 255, 222, 74, 75, 255, 222, 74, 75, 255, 222, 73, 76, 255, 222, 73, 76, 255, 221, 73, 76, 255, 221, 72, 76, 255, 221, 72, 76, 255, 220, 72, 76, 255, 220, 71, 76, 255, 220, 71, 76, 255, 220, 71, 76, 255, 219, 70, 76, 255, 219, 70, 76, 255, 219, 70, 77, 255, 219, 69, 77, 255, 218, 69, 77, 255, 218, 68, 77, 255, 218, 68, 77, 255, 217, 68, 77, 255, 217, 67, 77, 255, 217, 67, 77, 255, 217, 67, 77, 255, 216, 66, 77, 255, 216, 66, 77, 255, 216, 66, 78, 255, 216, 65, 78, 255, 215, 65, 78, 255, 215, 65, 78, 255, 215, 64, 78, 255, 214, 64, 78, 255, 214, 63, 78, 255, 214, 63, 78, 255, 214, 63, 78, 255, 213, 62, 78, 255, 213, 62, 78, 255, 213, 62, 78, 255, 212, 61, 78, 255, 212, 61, 78, 255, 211, 61, 78, 255, 211, 60, 78, 255, 211, 60, 78, 255, 210, 59, 78, 255, 210, 59, 78, 255, 209, 59, 78, 255, 209, 58, 78, 255, 209, 58, 78, 255, 208, 57, 78, 255, 208, 57, 77, 255, 207, 57, 77, 255, 207, 56, 77, 255, 206, 56, 77, 255, 206, 56, 77, 255, 206, 55, 77, 255, 205, 55, 77, 255, 205, 54, 77, 255, 204, 54, 77, 255, 204, 54, 77, 255, 203, 53, 77, 255, 203, 53, 76, 255, 203, 52, 76, 255, 202, 52, 76, 255, 202, 52, 76, 255, 201, 51, 76, 255, 201, 51, 76, 255, 200, 50, 76, 255, 200, 50, 76, 255, 200, 50, 76, 255, 199, 49, 76, 255, 199, 49, 76, 255, 198, 48, 75, 255, 198, 48, 75, 255, 198, 48, 75, 255, 197, 47, 75, 255, 197, 47, 75, 255, 196, 46, 75, 255, 196, 46, 75, 255, 195, 46, 75, 255, 195, 45, 75, 255, 195, 45, 75, 255, 194, 44, 74, 255, 194, 44, 74, 255, 193, 43, 74, 255, 193, 43, 74, 255, 192, 43, 74, 255, 192, 42, 74, 255, 192, 42, 74, 255, 191, 41, 74, 255, 180, 29, 71, 255, 179, 28, 71, 255, 179, 28, 71, 255, 178, 27, 71, 255, 178, 27, 71, 255, 177, 27, 71, 255, 177, 26, 70, 255, 177, 26, 70, 255, 176, 25, 70, 255, 176, 25, 70, 255, 175, 24, 70, 255, 175, 24, 70, 255, 174, 23, 70, 255, 174, 23, 70, 255, 174, 23, 70, 255, 173, 22, 70, 255, 173, 22, 69, 255, 172, 21, 69, 255, 172, 21, 69, 255, 171, 20, 69, 255, 171, 20, 69, 255, 171, 19, 69, 255, 170, 19, 69, 255, 170, 18, 69, 255, 169, 18, 69, 255, 169, 17, 68, 255, 168, 17, 68, 255, 168, 16, 68, 255, 168, 16, 68, 255, 167, 15, 68, 255, 167, 14, 68, 255, 166, 14, 68, 255, 166, 13, 68, 255, 165, 13, 68, 255, 165, 12, 67, 255, 164, 12, 67, 255, 164, 11, 67, 255, 164, 10, 67, 255, 163, 10, 67, 255, 163, 9, 67, 255, 162, 8, 67, 255, 162, 7, 67, 255, 161, 7, 67, 255, 161, 6, 66, 255, 161, 5, 66, 255, 160, 5, 66, 255, 160, 4, 66, 255, 159, 3, 66, 255, 159, 2, 66, 255, 158, 2, 66, 255, 158, 1, 66, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Spectral_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 94, 79, 162, 0, 89, 84, 165, 24, 84, 89, 169, 49, 79, 93, 172, 74, 75, 98, 175, 99, 70, 102, 177, 124, 57, 118, 184, 149, 54, 122, 186, 174, 51, 126, 187, 199, 50, 129, 188, 224, 49, 133, 188, 249, 46, 137, 189, 255, 33, 142, 190, 255, 15, 147, 191, 255, 10, 151, 190, 255, 10, 155, 189, 255, 10, 159, 188, 255, 30, 175, 181, 255, 47, 179, 178, 255, 60, 182, 175, 255, 73, 186, 172, 255, 84, 189, 169, 255, 95, 192, 166, 255, 103, 194, 164, 255, 108, 196, 164, 255, 112, 198, 164, 255, 116, 200, 164, 255, 121, 201, 164, 255, 125, 203, 164, 255, 129, 205, 163, 255, 147, 212, 163, 255, 151, 213, 163, 255, 155, 215, 163, 255, 159, 216, 163, 255, 163, 218, 163, 255, 167, 219, 163, 255, 171, 221, 163, 255, 174, 222, 163, 255, 176, 224, 162, 255, 179, 225, 162, 255, 182, 227, 161, 255, 185, 228, 160, 255, 188, 229, 160, 255, 191, 231, 159, 255, 206, 237, 156, 255, 210, 238, 155, 255, 213, 239, 154, 255, 216, 240, 154, 255, 219, 241, 153, 255, 223, 242, 153, 255, 226, 243, 152, 255, 230, 244, 152, 255, 230, 244, 152, 255, 231, 244, 153, 255, 231, 244, 154, 255, 232, 244, 154, 255, 232, 244, 155, 255, 233, 244, 156, 255, 234, 244, 156, 255, 234, 244, 157, 255, 237, 243, 161, 255, 237, 243, 161, 255, 238, 243, 162, 255, 238, 243, 163, 255, 239, 243, 163, 255, 239, 243, 164, 255, 239, 243, 165, 255, 240, 243, 165, 255, 240, 243, 166, 255, 241, 242, 166, 255, 241, 241, 165, 255, 242, 241, 164, 255, 242, 240, 163, 255, 243, 239, 162, 255, 243, 238, 161, 255, 244, 238, 160, 255, 244, 237, 159, 255, 245, 236, 158, 255, 245, 236, 157, 255, 248, 231, 152, 255, 249, 230, 151, 255, 249, 230, 150, 255, 250, 229, 149, 255, 250, 228, 148, 255, 251, 227, 147, 255, 251, 227, 147, 255, 252, 226, 146, 255, 252, 225, 145, 255, 253, 225, 145, 255, 253, 224, 144, 255, 253, 223, 143, 255, 253, 221, 141, 255, 253, 220, 139, 255, 253, 218, 137, 255, 253, 217, 135, 255, 253, 215, 134, 255, 253, 213, 132, 255, 253, 212, 130, 255, 253, 210, 129, 255, 253, 209, 127, 255, 253, 207, 126, 255, 253, 206, 124, 255, 253, 204, 123, 255, 253, 193, 112, 255, 253, 191, 110, 255, 253, 190, 109, 255, 253, 188, 108, 255, 253, 187, 106, 255, 253, 185, 105, 255, 253, 184, 104, 255, 253, 182, 103, 255, 253, 181, 102, 255, 253, 179, 101, 255, 253, 178, 100, 255, 253, 177, 99, 255, 253, 175, 98, 255, 253, 174, 97, 255, 252, 172, 95, 255, 252, 171, 94, 255, 252, 169, 93, 255, 252, 167, 92, 255, 252, 166, 91, 255, 251, 164, 90, 255, 251, 163, 89, 255, 251, 161, 88, 255, 251, 160, 87, 255, 251, 158, 86, 255, 250, 157, 86, 255, 250, 155, 85, 255, 250, 154, 84, 255, 250, 152, 83, 255, 250, 151, 82, 255, 250, 149, 82, 255, 248, 135, 75, 255, 247, 134, 74, 255, 247, 132, 74, 255, 247, 131, 73, 255, 247, 129, 73, 255, 247, 128, 72, 255, 246, 127, 72, 255, 246, 125, 71, 255, 246, 124, 71, 255, 246, 122, 70, 255, 245, 121, 70, 255, 245, 120, 69, 255, 245, 118, 69, 255, 245, 117, 68, 255, 245, 116, 68, 255, 244, 114, 68, 255, 244, 113, 67, 255, 244, 111, 67, 255, 244, 110, 67, 255, 244, 109, 67, 255, 243, 108, 67, 255, 243, 107, 67, 255, 242, 106, 67, 255, 242, 105, 67, 255, 241, 104, 68, 255, 241, 103, 68, 255, 240, 103, 68, 255, 240, 102, 68, 255, 240, 101, 68, 255, 239, 100, 69, 255, 239, 99, 69, 255, 238, 99, 69, 255, 238, 98, 69, 255, 237, 97, 70, 255, 237, 96, 70, 255, 236, 96, 70, 255, 236, 95, 70, 255, 236, 94, 70, 255, 235, 93, 70, 255, 235, 93, 71, 255, 234, 92, 71, 255, 234, 91, 71, 255, 233, 91, 71, 255, 233, 90, 71, 255, 226, 80, 74, 255, 226, 79, 74, 255, 225, 79, 74, 255, 225, 78, 74, 255, 224, 77, 75, 255, 224, 77, 75, 255, 224, 76, 75, 255, 223, 75, 75, 255, 223, 75, 75, 255, 222, 74, 75, 255, 222, 74, 76, 255, 221, 73, 76, 255, 221, 72, 76, 255, 221, 72, 76, 255, 220, 71, 76, 255, 220, 71, 76, 255, 219, 70, 76, 255, 219, 70, 77, 255, 219, 69, 77, 255, 218, 69, 77, 255, 218, 68, 77, 255, 217, 68, 77, 255, 217, 67, 77, 255, 217, 67, 77, 255, 216, 66, 77, 255, 216, 66, 78, 255, 215, 65, 78, 255, 215, 65, 78, 255, 215, 64, 78, 255, 214, 64, 78, 255, 214, 63, 78, 255, 213, 63, 78, 255, 213, 62, 78, 255, 213, 62, 78, 255, 212, 61, 78, 255, 212, 61, 78, 255, 211, 60, 78, 255, 211, 60, 78, 255, 210, 59, 78, 255, 210, 59, 78, 255, 209, 58, 78, 255, 209, 58, 78, 255, 208, 58, 78, 255, 208, 57, 78, 255, 207, 57, 77, 255, 207, 56, 77, 255, 206, 56, 77, 255, 206, 55, 77, 255, 205, 55, 77, 255, 205, 55, 77, 255, 205, 54, 77, 255, 204, 54, 77, 255, 204, 53, 77, 255, 203, 53, 77, 255, 203, 53, 76, 255, 202, 52, 76, 255, 202, 52, 76, 255, 202, 51, 76, 255, 201, 51, 76, 255, 201, 51, 76, 255, 200, 50, 76, 255, 200, 50, 76, 255, 200, 49, 76, 255, 199, 49, 76, 255, 199, 49, 76, 255, 198, 48, 75, 255, 198, 48, 75, 255, 198, 48, 75, 255, 197, 47, 75, 255, 197, 47, 75, 255, 197, 47, 75, 255, 196, 46, 75, 255, 196, 46, 75, 255, 196, 46, 75, 255, 195, 45, 75, 255, 195, 45, 75, 255, 194, 45, 75, 255, 194, 44, 74, 255, 194, 44, 74, 255, 194, 44, 74, 255, 193, 43, 74, 255, 193, 43, 74, 255, 193, 43, 74, 255, 192, 43, 74, 255, 192, 42, 74, 255, 192, 42, 74, 255, 191, 42, 74, 255, 191, 41, 74, 255, 191, 41, 74, 255, 179, 29, 71, 255, 179, 28, 71, 255, 179, 28, 71, 255, 179, 28, 71, 255, 178, 27, 71, 255, 178, 27, 71, 255, 178, 27, 71, 255, 178, 27, 71, 255, 177, 26, 70, 255, 177, 26, 70, 255, 177, 26, 70, 255, 176, 26, 70, 255, 176, 25, 70, 255, 176, 25, 70, 255, 176, 25, 70, 255, 176, 25, 70, 255, 175, 24, 70, 255, 175, 24, 70, 255, 175, 24, 70, 255, 175, 24, 70, 255, 174, 23, 70, 255, 174, 23, 70, 255, 174, 23, 70, 255, 174, 23, 70, 255, 173, 22, 70, 255, 173, 22, 70, 255, 173, 22, 69, 255, 173, 22, 69, 255, 173, 21, 69, 255, 172, 21, 69, 255, 172, 21, 69, 255, 172, 21, 69, 255, 172, 21, 69, 255, 172, 20, 69, 255, 171, 20, 69, 255, 171, 20, 69, 255, 171, 20, 69, 255, 171, 20, 69, 255, 171, 19, 69, 255, 170, 19, 69, 255, 170, 19, 69, 255, 170, 19, 69, 255, 170, 19, 69, 255, 170, 18, 69, 255, 170, 18, 69, 255, 169, 18, 69, 255, 169, 18, 69, 255, 169, 18, 69, 255, 169, 17, 68, 255, 169, 17, 68, 255, 169, 17, 68, 255, 168, 17, 68, 255, 168, 17, 68, 255, 168, 16, 68, 255, 168, 16, 68, 255, 168, 16, 68, 255, 168, 16, 68, 255, 168, 16, 68, 255, 167, 16, 68, 255, 167, 15, 68, 255, 167, 15, 68, 255, 167, 15, 68, 255, 167, 15, 68, 255, 167, 15, 68, 255, 167, 14, 68, 255, 166, 14, 68, 255, 166, 14, 68, 255, 166, 14, 68, 255, 166, 14, 68, 255, 166, 14, 68, 255, 166, 13, 68, 255, 166, 13, 68, 255, 166, 13, 68, 255, 166, 13, 68, 255, 165, 13, 68, 255, 165, 13, 68, 255, 165, 13, 68, 255, 165, 12, 67, 255, 165, 12, 67, 255, 165, 12, 67, 255, 165, 12, 67, 255, 165, 12, 67, 255, 165, 12, 67, 255, 164, 11, 67, 255, 164, 11, 67, 255, 164, 11, 67, 255, 164, 11, 67, 255, 164, 11, 67, 255, 164, 11, 67, 255, 164, 11, 67, 255, 164, 10, 67, 255, 164, 10, 67, 255, 164, 10, 67, 255, 163, 10, 67, 255, 163, 10, 67, 255, 163, 10, 67, 255, 163, 10, 67, 255, 163, 10, 67, 255, 163, 9, 67, 255, 163, 9, 67, 255, 163, 9, 67, 255, 163, 9, 67, 255, 163, 9, 67, 255, 163, 9, 67, 255, 163, 9, 67, 255, 162, 8, 67, 255, 162, 8, 67, 255, 162, 8, 67, 255, 162, 8, 67, 255, 162, 8, 67, 255, 162, 8, 67, 255, 162, 8, 67, 255, 162, 8, 67, 255, 162, 8, 67, 255, 162, 7, 67, 255, 162, 7, 67, 255, 162, 7, 67, 255, 162, 7, 67, 255, 162, 7, 67, 255, 162, 7, 67, 255, 161, 7, 67, 255, 161, 7, 67, 255, 161, 7, 67, 255, 161, 6, 66, 255, 161, 6, 66, 255, 161, 6, 66, 255, 161, 6, 66, 255, 161, 6, 66, 255, 161, 6, 66, 255, 161, 6, 66, 255, 161, 6, 66, 255, 161, 6, 66, 255, 161, 6, 66, 255, 161, 6, 66, 255, 161, 5, 66, 255, 161, 5, 66, 255, 161, 5, 66, 255, 161, 5, 66, 255, 160, 5, 66, 255, 160, 5, 66, 255, 160, 5, 66, 255, 160, 5, 66, 255, 160, 5, 66, 255, 160, 5, 66, 255, 160, 5, 66, 255, 160, 5, 66, 255, 160, 5, 66, 255, 160, 4, 66, 255, 160, 4, 66, 255, 160, 4, 66, 255, 160, 4, 66, 255, 160, 4, 66, 255, 160, 4, 66, 255, 160, 4, 66, 255, 160, 4, 66, 255, 160, 4, 66, 255, 160, 4, 66, 255, 160, 4, 66, 255, 160, 4, 66, 255, 160, 4, 66, 255, 160, 4, 66, 255, 160, 4, 66, 255, 159, 4, 66, 255, 159, 4, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 3, 66, 255, 159, 2, 66, 255, 159, 2, 66, 255, 159, 2, 66, 255, 159, 2, 66, 255, 159, 2, 66, 255, 159, 2, 66, 255, 159, 2, 66, 255, 159, 2, 66, 255, 159, 2, 66, 255, 159, 2, 66, 255, 159, 2, 66, 255, 159, 2, 66, 255, 159, 2, 66, 255, 159, 2, 66, 255, 159, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 2, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 158, 1, 66, 255, 157, 1, 66, 255, 157, 1, 66, 255, 157, 1, 66, 255, 157, 1, 66, 255, 157, 1, 66, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255, 157, 1, 65, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Spectral_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
