#pragma once

#include <Process/Drop/ProcessDropHandler.hpp>

#include <Library/LibraryInterface.hpp>
#include <Library/LibrarySettings.hpp>
#include <Library/ProcessesItemModel.hpp>

#include <QFileInfo>

#include <Airwindows/ProcessModel.hpp>

#include <AirwinRegistry.h>

namespace Airwindows
{

struct AirwindowsPlugin
{
  std::string name;
  std::string category;
};

inline void initializeRegistry()
{
  static bool initialized = false;
  if(!initialized)
  {
    // The registry should be populated by the autogenerated code
    AirwinRegistry::completeRegistry();
    initialized = true;
  }
}

inline std::vector<AirwindowsPlugin> getAirwindowsPlugins()
{
  std::vector<AirwindowsPlugin> plugins;
  for(const auto& reg : AirwinRegistry::registry)
  {
    plugins.push_back({reg.name, reg.category});
  }
  return plugins;
}
class LibraryHandler final
    : public QObject
    , public Library::LibraryInterface
{
  SCORE_CONCRETE("5aff3580-21d3-4069-bd08-823371245a5b")
public:
  Library::ProcessNode* node{};

  void setup(Library::ProcessesItemModel& model, const score::GUIApplicationContext& ctx)
      override
  {
    const auto& key = Metadata<ConcreteKey_k, Airwindows::ProcessModel>::get();
    QModelIndex node = model.find(key);
    if(node == QModelIndex{})
      return;
    auto& parent = *reinterpret_cast<Library::ProcessNode*>(node.internalPointer());
    parent.key = {};
    this->node = &parent;

    // Initialize the airwindows registry
    initializeRegistry();

    // Add all airwindows plugins from the registry
    for(const auto& plugin : getAirwindowsPlugins())
    {
      Library::ProcessData pdata{
          {key, QString::fromStdString(plugin.name),
           QString::fromStdString(plugin.name)},
          {}};
      Library::addToLibrary(parent, std::move(pdata));
    }
  }
};

}
