# Підзастосунки - монтування { #sub-applications-mounts }

Якщо вам потрібно мати два незалежні застосунки FastAPI з власними незалежними OpenAPI та власними інтерфейсами документації, ви можете мати головний застосунок і «змонтувати» один або кілька підзастосунків.

## Монтування застосунку **FastAPI** { #mounting-a-fastapi-application }

«Монтування» означає додавання повністю «незалежного» застосунку на конкретний шлях, який далі обробляє все під цим шляхом за допомогою _операцій шляху_, оголошених у цьому підзастосунку.

### Застосунок верхнього рівня { #top-level-application }

Спочатку створіть головний, верхньорівневий застосунок **FastAPI** та його _операції шляху_:

{* ../../docs_src/sub_applications/tutorial001_py310.py hl[3, 6:8] *}

### Підзастосунок { #sub-application }

Потім створіть свій підзастосунок та його _операції шляху_.

Цей підзастосунок - просто ще один стандартний застосунок FastAPI, але саме його буде «змонтовано»:

{* ../../docs_src/sub_applications/tutorial001_py310.py hl[11, 14:16] *}

### Змонтуйте підзастосунок { #mount-the-sub-application }

У вашому застосунку верхнього рівня, `app`, змонтуйте підзастосунок `subapi`.

У цьому випадку його буде змонтовано за шляхом `/subapi`:

{* ../../docs_src/sub_applications/tutorial001_py310.py hl[11, 19] *}

### Перевірте автоматичну документацію API { #check-the-automatic-api-docs }

Тепер запустіть команду `fastapi` з вашим файлом:

<div class="termy">

```console
$ fastapi dev main.py

<span style="color: green;">INFO</span>:     Uvicorn running on http://127.0.0.1:8000 (Press CTRL+C to quit)
```

</div>

І відкрийте документацію за адресою <a href="http://127.0.0.1:8000/docs" class="external-link" target="_blank">http://127.0.0.1:8000/docs</a>.

Ви побачите автоматичну документацію API для головного застосунку, що містить лише його власні _операції шляху_:

<img src="/img/tutorial/sub-applications/image01.png">

А потім відкрийте документацію для підзастосунку за адресою <a href="http://127.0.0.1:8000/subapi/docs" class="external-link" target="_blank">http://127.0.0.1:8000/subapi/docs</a>.

Ви побачите автоматичну документацію API для підзастосунку, що містить лише його власні _операції шляху_, усі з правильним префіксом підшляху `/subapi`:

<img src="/img/tutorial/sub-applications/image02.png">

Якщо ви спробуєте взаємодіяти з будь-яким із двох інтерфейсів користувача, вони працюватимуть коректно, адже браузер зможе спілкуватися з кожним конкретним застосунком або підзастосунком.

### Технічні деталі: `root_path` { #technical-details-root-path }

Коли ви монтуєте підзастосунок, як описано вище, FastAPI подбає про передачу шляху монтування для підзастосунку, використовуючи механізм зі специфікації ASGI під назвою `root_path`.

Таким чином підзастосунок знатиме, що слід використовувати цей префікс шляху для інтерфейсу документації.

Підзастосунок також може мати власні змонтовані підзастосунки, і все працюватиме коректно, оскільки FastAPI автоматично обробляє всі ці `root_path`.

Ви дізнаєтеся більше про `root_path` і як використовувати його явно в розділі [За представником](behind-a-proxy.md){.internal-link target=_blank}.
