# Моделі параметрів Cookie { #cookie-parameter-models }

Якщо у вас є група **cookies**, які пов'язані між собою, ви можете створити **Pydantic-модель**, щоб оголосити їх. 🍪

Це дозволить вам повторно **використовувати модель** у **різних місцях**, а також оголосити валідацію та метадані для всіх параметрів одночасно. 😎

/// note | Примітка

Це підтримується з версії FastAPI `0.115.0`. 🤓

///

/// tip | Порада

Ця ж техніка застосовується до `Query`, `Cookie` та `Header`. 😎

///

## Cookie з Pydantic-моделлю { #cookies-with-a-pydantic-model }

Оголосіть **cookie**-параметри, які вам потрібні, у **Pydantic-моделі**, а потім оголосіть параметр як `Cookie`:

{* ../../docs_src/cookie_param_models/tutorial001_an_py310.py hl[9:12,16] *}

**FastAPI** буде **витягувати** дані для **кожного поля** з **cookies**, отриманих у запиті, і передавати вам Pydantic-модель, яку ви визначили.

## Перевірка у документації { #check-the-docs }

Ви можете побачити визначені cookies в інтерфейсі документації за адресою `/docs`:

<div class="screenshot">
<img src="/img/tutorial/cookie-param-models/image01.png">
</div>

/// info | Інформація

Майте на увазі, що оскільки **браузери обробляють cookies** особливим чином і «за лаштунками», вони **не** дозволяють **JavaScript** легко з ними працювати.

Якщо ви зайдете до **інтерфейсу документації API** за адресою `/docs`, ви зможете побачити **документацію** для cookies у ваших *операціях шляху*.

Але навіть якщо ви заповните дані й натиснете "Execute", оскільки інтерфейс документації працює з **JavaScript**, cookies не будуть відправлені, і ви побачите **помилку**, ніби ви не ввели жодних значень.

///

## Заборона додаткових cookie { #forbid-extra-cookies }

У деяких спеціальних випадках (ймовірно, не дуже поширених) ви можете захотіти **обмежити** cookies, які хочете отримувати.

Ваш API тепер має можливість контролювати власну <dfn title="Це жарт, про всяк випадок. Це не має стосунку до згоди на cookies, просто кумедно, що навіть API тепер може відхиляти бідні cookies. Візьміть печиво. 🍪">згоду на cookies</dfn>. 🤪🍪

Ви можете використовувати налаштування моделі Pydantic, щоб `forbid` будь-які `extra` поля:

{* ../../docs_src/cookie_param_models/tutorial002_an_py310.py hl[10] *}

Якщо клієнт спробує надіслати якісь **додаткові cookies**, він отримає відповідь з **помилкою**.

Бідні банери cookie, які так старанно намагаються отримати вашу згоду, щоб <dfn title="Це ще один жарт. Не звертайте на мене уваги. Випийте трохи кави до свого печива. ☕">API її відхилила</dfn>. 🍪

Наприклад, якщо клієнт спробує надіслати cookie `santa_tracker` зі значенням `good-list-please`, він отримає відповідь з помилкою, яка повідомить, що `santa_tracker` <dfn title="Санта не схвалює нестачу cookies. 🎅 Гаразд, досить жартів про cookies.">cookie не дозволено</dfn>:

```json
{
    "detail": [
        {
            "type": "extra_forbidden",
            "loc": ["cookie", "santa_tracker"],
            "msg": "Extra inputs are not permitted",
            "input": "good-list-please",
        }
    ]
}
```

## Підсумок { #summary }

Ви можете використовувати **Pydantic-моделі** для оголошення <dfn title="Візьміть останнє печиво перед тим, як підете. 🍪">**cookies**</dfn> у **FastAPI**. 😎
