# FastAPIのバージョンについて { #about-fastapi-versions }

**FastAPI** はすでに多くのアプリケーションやシステムで本番環境にて使われています。また、テストカバレッジは 100% に維持されています。しかし、開発は依然として急速に進んでいます。

新機能が高頻度で追加され、定期的にバグが修正され、コードは継続的に改善されています。

これが現在のバージョンがいまだに `0.x.x` な理由であり、それぞれのバージョンは破壊的な変更がなされる可能性があります。これは、<a href="https://semver.org/" class="external-link" target="_blank">セマンティック バージョニング</a>の規則に則っています。

**FastAPI** を使用すると本番用アプリケーションを今すぐ作成できます（そして、おそらくあなたはしばらく前からそうしているはずです）。必要なのは、残りのコードと正しく動作するバージョンを使用していることを確認することだけです。

## `fastapi` のバージョンを固定 { #pin-your-fastapi-version }

最初にすべきことは、使用している **FastAPI** のバージョンを、アプリケーションで正しく動作することが分かっている特定の最新バージョンに「固定（pin）」することです。

例えば、アプリでバージョン `0.112.0` を使っているとしましょう。

`requirements.txt` ファイルを使う場合は、以下のようにバージョンを指定できます:

```txt
fastapi[standard]==0.112.0
```

これは、厳密にバージョン `0.112.0` だけを使うことを意味します。

または、以下のように固定することもできます:

```txt
fastapi[standard]>=0.112.0,<0.113.0
```

これは `0.112.0` 以上、`0.113.0` 未満のバージョンを使うことを意味します。例えば、バージョン `0.112.2` は使用可能です。

`uv`、Poetry、Pipenv など、他のインストール管理ツールを使用している場合でも、いずれもパッケージの特定バージョンを定義する方法があります。

## 利用可能なバージョン { #available-versions }

利用可能なバージョン（例: 現在の最新が何かを確認するため）は、[Release Notes](../release-notes.md){.internal-link target=_blank} で確認できます。

## バージョンについて { #about-versions }

セマンティック バージョニングの規約に従って、`1.0.0` 未満のバージョンは破壊的な変更が加わる可能性があります。

FastAPI では「PATCH」バージョンの変更はバグ修正と非破壊的な変更に使う、という規約にも従っています。

/// tip | 豆知識

「PATCH」は最後の数字です。例えば、`0.2.3` では PATCH バージョンは `3` です。

///

従って、以下のようなバージョンの固定ができるはずです:

```txt
fastapi>=0.45.0,<0.46.0
```

破壊的な変更と新機能は「MINOR」バージョンで追加されます。

/// tip | 豆知識

「MINOR」は真ん中の数字です。例えば、`0.2.3` では MINOR バージョンは `2` です。

///

## FastAPIのバージョンのアップグレード { #upgrading-the-fastapi-versions }

アプリケーションにテストを追加すべきです。

**FastAPI** では非常に簡単に実現できます（Starlette のおかげです）。ドキュメントを確認して下さい: [テスト](../tutorial/testing.md){.internal-link target=_blank}

テストを追加したら、**FastAPI** のバージョンをより新しいものにアップグレードし、テストを実行することで全てのコードが正しく動作するか確認できます。

全てが動作する、または必要な変更を行った後に全てのテストが通るなら、その新しいバージョンに `fastapi` を固定できます。

## Starletteについて { #about-starlette }

`starlette` のバージョンは固定すべきではありません。

**FastAPI** のバージョンが異なれば、Starlette の特定のより新しいバージョンが使われます。

そのため、正しい Starlette バージョンを **FastAPI** に任せればよいです。

## Pydanticについて { #about-pydantic }

Pydantic は自身のテストに **FastAPI** のテストも含んでいるため、Pydantic の新しいバージョン（`1.0.0` より上）は常に FastAPI と互換性があります。

Pydantic は、自分にとって動作する `1.0.0` より上の任意のバージョンに固定できます。

例えば:

```txt
pydantic>=2.7.0,<3.0.0
```
