# Відповідь - зміна коду статусу { #response-change-status-code }

Ймовірно, ви вже читали, що можна встановити типовий [код статусу відповіді](../tutorial/response-status-code.md){.internal-link target=_blank}.

Але інколи потрібно повернути інший код статусу, ніж типовий.

## Випадок використання { #use-case }

Наприклад, уявімо, що ви хочете за замовчуванням повертати код статусу HTTP «OK» `200`.

Але якщо даних не існувало, ви хочете створити їх і повернути код статусу HTTP «CREATED» `201`.

Водночас ви все одно хочете мати змогу фільтрувати та перетворювати повернені дані за допомогою `response_model`.

Для таких випадків ви можете використати параметр `Response`.

## Використовуйте параметр `Response` { #use-a-response-parameter }

Ви можете оголосити параметр типу `Response` у своїй функції операції шляху (так само, як для кукі та заголовків).

Потім ви можете встановити `status_code` у цьому *тимчасовому* об'єкті відповіді.

{* ../../docs_src/response_change_status_code/tutorial001_py310.py hl[1,9,12] *}

Після цього ви можете повернути будь-який потрібний об'єкт, як зазвичай (`dict`, модель бази даних тощо).

І якщо ви оголосили `response_model`, він усе одно буде використаний для фільтрації та перетворення поверненого об'єкта.

**FastAPI** використає цей *тимчасовий* об'єкт відповіді, щоб отримати код статусу (а також кукі та заголовки), і помістить їх у фінальну відповідь, що містить повернуте вами значення, відфільтроване за допомогою `response_model`.

Ви також можете оголосити параметр `Response` у залежностях і встановлювати там код статусу. Але майте на увазі: останнє встановлене значення матиме пріоритет.
