from typing import Any, ClassVar, Iterator, List, Set, Tuple

from typing import overload
import lief # type: ignore
import lief.MachO # type: ignore

class ARM64_RELOCATION:
    __members__: ClassVar[dict] = ...  # read-only
    ADDEND: ClassVar[ARM64_RELOCATION] = ...
    BRANCH26: ClassVar[ARM64_RELOCATION] = ...
    GOT_LOAD_PAGE21: ClassVar[ARM64_RELOCATION] = ...
    GOT_LOAD_PAGEOFF12: ClassVar[ARM64_RELOCATION] = ...
    PAGE21: ClassVar[ARM64_RELOCATION] = ...
    PAGEOFF12: ClassVar[ARM64_RELOCATION] = ...
    POINTER_TO_GOT: ClassVar[ARM64_RELOCATION] = ...
    SUBTRACTOR: ClassVar[ARM64_RELOCATION] = ...
    TLVP_LOAD_PAGE21: ClassVar[ARM64_RELOCATION] = ...
    TLVP_LOAD_PAGEOFF12: ClassVar[ARM64_RELOCATION] = ...
    UNSIGNED: ClassVar[ARM64_RELOCATION] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ARM_RELOCATION:
    __members__: ClassVar[dict] = ...  # read-only
    BR24: ClassVar[ARM_RELOCATION] = ...
    HALF: ClassVar[ARM_RELOCATION] = ...
    HALF_SECTDIFF: ClassVar[ARM_RELOCATION] = ...
    LOCAL_SECTDIFF: ClassVar[ARM_RELOCATION] = ...
    PAIR: ClassVar[ARM_RELOCATION] = ...
    PB_LA_PTR: ClassVar[ARM_RELOCATION] = ...
    SECTDIFF: ClassVar[ARM_RELOCATION] = ...
    THUMB_32BIT_BRANCH: ClassVar[ARM_RELOCATION] = ...
    THUMB_RELOC_BR22: ClassVar[ARM_RELOCATION] = ...
    VANILLA: ClassVar[ARM_RELOCATION] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class BINDING_CLASS:
    __members__: ClassVar[dict] = ...  # read-only
    LAZY: ClassVar[BINDING_CLASS] = ...
    STANDARD: ClassVar[BINDING_CLASS] = ...
    THREADED: ClassVar[BINDING_CLASS] = ...
    WEAK: ClassVar[BINDING_CLASS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class BIND_OPCODES:
    __members__: ClassVar[dict] = ...  # read-only
    ADD_ADDR_ULEB: ClassVar[BIND_OPCODES] = ...
    DONE: ClassVar[BIND_OPCODES] = ...
    DO_BIND: ClassVar[BIND_OPCODES] = ...
    DO_BIND_ADD_ADDR_IMM_SCALED: ClassVar[BIND_OPCODES] = ...
    DO_BIND_ADD_ADDR_ULEB: ClassVar[BIND_OPCODES] = ...
    DO_BIND_ULEB_TIMES_SKIPPING_ULEB: ClassVar[BIND_OPCODES] = ...
    SET_ADDEND_SLEB: ClassVar[BIND_OPCODES] = ...
    SET_DYLIB_ORDINAL_IMM: ClassVar[BIND_OPCODES] = ...
    SET_DYLIB_ORDINAL_ULEB: ClassVar[BIND_OPCODES] = ...
    SET_DYLIB_SPECIAL_IMM: ClassVar[BIND_OPCODES] = ...
    SET_SEGMENT_AND_OFFSET_ULEB: ClassVar[BIND_OPCODES] = ...
    SET_SYMBOL_TRAILING_FLAGS_IMM: ClassVar[BIND_OPCODES] = ...
    SET_TYPE_IMM: ClassVar[BIND_OPCODES] = ...
    THREADED: ClassVar[BIND_OPCODES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class BIND_SPECIAL_DYLIB:
    __members__: ClassVar[dict] = ...  # read-only
    FLAT_LOOKUP: ClassVar[BIND_SPECIAL_DYLIB] = ...
    MAIN_EXECUTABLE: ClassVar[BIND_SPECIAL_DYLIB] = ...
    SELF: ClassVar[BIND_SPECIAL_DYLIB] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class BIND_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    POINTER: ClassVar[BIND_TYPES] = ...
    TEXT_ABSOLUTE32: ClassVar[BIND_TYPES] = ...
    TEXT_PCREL32: ClassVar[BIND_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Binary(lief.Binary):
    class it_commands:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.MachO.LoadCommand: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.LoadCommand: ...

    class it_filter_symbols:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.MachO.Symbol: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.Symbol: ...

    class it_libraries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.MachO.DylibCommand: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.DylibCommand: ...

    class it_relocations:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.MachO.Relocation: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.Relocation: ...

    class it_rpaths:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.MachO.RPathCommand: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.RPathCommand: ...

    class it_sections:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.MachO.Section: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.Section: ...

    class it_segments:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.MachO.SegmentCommand: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.SegmentCommand: ...

    class it_symbols:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.MachO.Symbol: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.Symbol: ...

    class range_t:
        end: int
        start: int
        def __init__(self, *args, **kwargs) -> None: ...
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def add(self, dylib_command: lief.MachO.DylibCommand) -> lief.MachO.LoadCommand: ...
    @overload
    def add(self, segment: lief.MachO.SegmentCommand) -> lief.MachO.LoadCommand: ...
    @overload
    def add(self, load_command: lief.MachO.LoadCommand) -> lief.MachO.LoadCommand: ...
    @overload
    def add(self, load_command: lief.MachO.LoadCommand, index: int) -> lief.MachO.LoadCommand: ...
    def add_exported_function(self, address: int, name: str) -> lief.MachO.ExportInfo: ...
    def add_library(self, library_name: str) -> lief.MachO.LoadCommand: ...
    def add_local_symbol(self, address: int, name: str) -> lief.MachO.Symbol: ...
    @overload
    def add_section(self, segment: lief.MachO.SegmentCommand, section: lief.MachO.Section) -> lief.MachO.Section: ...
    @overload
    def add_section(self, section: lief.MachO.Section) -> lief.MachO.Section: ...
    def can_remove(self, symbol: lief.MachO.Symbol) -> bool: ...
    def can_remove_symbol(self, symbol_name: str) -> bool: ...
    def extend(self, load_command: lief.MachO.LoadCommand, size: int) -> bool: ...
    def extend_segment(self, segment_command: lief.MachO.SegmentCommand, size: int) -> bool: ...
    def get(self, type: lief.MachO.LOAD_COMMAND_TYPES) -> lief.MachO.LoadCommand: ...
    @overload
    def get_section(self, name: str) -> lief.MachO.Section: ...
    @overload
    def get_section(self, segname: str, secname: str) -> lief.MachO.Section: ...
    def get_segment(self, name: str) -> lief.MachO.SegmentCommand: ...
    def get_symbol(self, name: str) -> lief.MachO.Symbol: ...
    def has(self, type: lief.MachO.LOAD_COMMAND_TYPES) -> bool: ...
    def has_section(self, name: str) -> bool: ...
    def has_segment(self, name: str) -> bool: ...
    def has_symbol(self, name: str) -> bool: ...
    def is_valid_addr(self, address: int) -> bool: ...
    @overload
    def remove(self, load_command: lief.MachO.LoadCommand) -> bool: ...
    @overload
    def remove(self, type: lief.MachO.LOAD_COMMAND_TYPES) -> bool: ...
    @overload
    def remove(self, symbol: lief.MachO.Symbol) -> bool: ...
    def remove_command(self, index: int) -> bool: ...
    @overload
    def remove_section(self, name: str, clear: bool = ...) -> None: ...
    @overload
    def remove_section(self, segname: str, secname: str, clear: bool = ...) -> None: ...
    def remove_signature(self) -> bool: ...
    def remove_symbol(self, name: str) -> bool: ...
    def section_from_offset(self, arg0: int) -> lief.MachO.Section: ...
    def section_from_virtual_address(self, arg0: int) -> lief.MachO.Section: ...
    def segment_from_offset(self, arg0: int) -> lief.MachO.SegmentCommand: ...
    def segment_from_virtual_address(self, arg0: int) -> lief.MachO.SegmentCommand: ...
    def shift(self, value: int) -> object: ...
    def shift_linkedit(self, value: int) -> object: ...
    @overload
    def unexport(self, name: str) -> bool: ...
    @overload
    def unexport(self, symbol: lief.MachO.Symbol) -> bool: ...
    def virtual_address_to_offset(self, virtual_address: int) -> object: ...
    def write(self, output: str) -> None: ...
    def __contains__(self, arg0: lief.MachO.LOAD_COMMAND_TYPES) -> bool: ...
    def __getitem__(self, arg0: lief.MachO.LOAD_COMMAND_TYPES) -> lief.MachO.LoadCommand: ...
    @property
    def build_version(self) -> lief.MachO.BuildVersion: ...
    @property
    def code_signature(self) -> lief.MachO.CodeSignature: ...
    @property
    def code_signature_dir(self) -> lief.MachO.CodeSignatureDir: ...
    @property
    def commands(self) -> lief.MachO.Binary.it_commands: ...
    @property
    def data_in_code(self) -> lief.MachO.DataInCode: ...
    @property
    def dyld_chained_fixups(self) -> lief.MachO.DyldChainedFixups: ...
    @property
    def dyld_environment(self) -> lief.MachO.DyldEnvironment: ...
    @property
    def dyld_exports_trie(self) -> lief.MachO.DyldExportsTrie: ...
    @property
    def dyld_info(self) -> lief.MachO.DyldInfo: ...
    @property
    def dylinker(self) -> lief.MachO.DylinkerCommand: ...
    @property
    def dynamic_symbol_command(self) -> lief.MachO.DynamicSymbolCommand: ...
    @property
    def encryption_info(self) -> lief.MachO.EncryptionInfo: ...
    @property
    def exported_symbols(self) -> lief.MachO.Binary.it_filter_symbols: ...
    @property
    def fat_offset(self) -> int: ...
    @property
    def filesets(self) -> lief.MachO.FatBinary.it_binaries: ...
    @property
    def function_starts(self) -> lief.MachO.FunctionStarts: ...
    @property
    def functions(self) -> List[lief.Function]: ...
    @property
    def has_build_version(self) -> bool: ...
    @property
    def has_code_signature(self) -> bool: ...
    @property
    def has_code_signature_dir(self) -> bool: ...
    @property
    def has_data_in_code(self) -> bool: ...
    @property
    def has_dyld_chained_fixups(self) -> bool: ...
    @property
    def has_dyld_environment(self) -> bool: ...
    @property
    def has_dyld_exports_trie(self) -> bool: ...
    @property
    def has_dyld_info(self) -> bool: ...
    @property
    def has_dylinker(self) -> bool: ...
    @property
    def has_dynamic_symbol_command(self) -> bool: ...
    @property
    def has_encryption_info(self) -> bool: ...
    @property
    def has_entrypoint(self) -> bool: ...
    @property
    def has_filesets(self) -> bool: ...
    @property
    def has_function_starts(self) -> bool: ...
    @property
    def has_linker_opt_hint(self) -> bool: ...
    @property
    def has_main_command(self) -> bool: ...
    @property
    def has_rpath(self) -> bool: ...
    @property
    def has_segment_split_info(self) -> bool: ...
    @property
    def has_source_version(self) -> bool: ...
    @property
    def has_sub_framework(self) -> bool: ...
    @property
    def has_symbol_command(self) -> bool: ...
    @property
    def has_thread_command(self) -> bool: ...
    @property
    def has_two_level_hints(self) -> bool: ...
    @property
    def has_uuid(self) -> bool: ...
    @property
    def has_version_min(self) -> bool: ...
    @property
    def header(self) -> lief.MachO.Header: ...
    @property
    def imagebase(self) -> int: ...
    @property
    def imported_symbols(self) -> lief.MachO.Binary.it_filter_symbols: ...
    @property
    def libraries(self) -> lief.MachO.Binary.it_libraries: ...
    @property
    def linker_opt_hint(self) -> lief.MachO.LinkerOptHint: ...
    @property
    def main_command(self) -> lief.MachO.MainCommand: ...
    @property
    def off_ranges(self) -> lief.MachO.Binary.range_t: ...
    @property
    def page_size(self) -> int: ...
    @property
    def relocations(self) -> lief.MachO.Binary.it_relocations: ...
    @property
    def rpath(self) -> lief.MachO.RPathCommand: ...
    @property
    def rpaths(self) -> lief.MachO.Binary.it_rpaths: ...
    @property
    def sections(self) -> lief.MachO.Binary.it_sections: ...
    @property
    def segment_split_info(self) -> lief.MachO.SegmentSplitInfo: ...
    @property
    def segments(self) -> lief.MachO.Binary.it_segments: ...
    @property
    def source_version(self) -> lief.MachO.SourceVersion: ...
    @property
    def sub_framework(self) -> lief.MachO.SubFramework: ...
    @property
    def symbol_command(self) -> lief.MachO.SymbolCommand: ...
    @property
    def symbols(self) -> lief.MachO.Binary.it_symbols: ...
    @property
    def thread_command(self) -> lief.MachO.ThreadCommand: ...
    @property
    def two_level_hints(self) -> lief.MachO.TwoLevelHints: ...
    @property
    def unwind_functions(self) -> List[lief.Function]: ...
    @property
    def uuid(self) -> lief.MachO.UUIDCommand: ...
    @property
    def va_ranges(self) -> lief.MachO.Binary.range_t: ...
    @property
    def version_min(self) -> lief.MachO.VersionMin: ...
    @property
    def virtual_size(self) -> int: ...

class BindingInfo(lief.Object):
    addend: int
    address: int
    library_ordinal: int
    weak_import: bool
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def has_library(self) -> bool: ...
    @property
    def has_segment(self) -> bool: ...
    @property
    def has_symbol(self) -> bool: ...
    @property
    def library(self) -> lief.MachO.DylibCommand: ...
    @property
    def segment(self) -> lief.MachO.SegmentCommand: ...
    @property
    def symbol(self) -> lief.MachO.Symbol: ...

class BuildToolVersion(lief.Object):
    class TOOLS:
        __members__: ClassVar[dict] = ...  # read-only
        CLANG: ClassVar[BuildToolVersion.TOOLS] = ...
        LD: ClassVar[BuildToolVersion.TOOLS] = ...
        SWIFT: ClassVar[BuildToolVersion.TOOLS] = ...
        UNKNOWN: ClassVar[BuildToolVersion.TOOLS] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def tool(self) -> lief.MachO.BuildToolVersion.TOOLS: ...
    @property
    def version(self) -> List[int]: ...

class BuildVersion(LoadCommand):
    class PLATFORMS:
        __members__: ClassVar[dict] = ...  # read-only
        IOS: ClassVar[BuildVersion.PLATFORMS] = ...
        MACOS: ClassVar[BuildVersion.PLATFORMS] = ...
        TVOS: ClassVar[BuildVersion.PLATFORMS] = ...
        UNKNOWN: ClassVar[BuildVersion.PLATFORMS] = ...
        WATCHOS: ClassVar[BuildVersion.PLATFORMS] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    minos: List[int]
    platform: lief.MachO.BuildVersion.PLATFORMS
    sdk: List[int]
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def tools(self) -> List[lief.MachO.BuildToolVersion]: ...

class Builder:
    class config_t:
        linkedit: bool
        def __init__(self) -> None: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def write(self, *args, **kwargs) -> Any: ...

class CPU_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    ANY: ClassVar[CPU_TYPES] = ...
    ARM: ClassVar[CPU_TYPES] = ...
    ARM64: ClassVar[CPU_TYPES] = ...
    I386: ClassVar[CPU_TYPES] = ...
    MC98000: ClassVar[CPU_TYPES] = ...
    POWERPC: ClassVar[CPU_TYPES] = ...
    POWERPC64: ClassVar[CPU_TYPES] = ...
    SPARC: ClassVar[CPU_TYPES] = ...
    __entries: ClassVar[dict] = ...
    x86: ClassVar[CPU_TYPES] = ...
    x86_64: ClassVar[CPU_TYPES] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ChainedBindingInfo(BindingInfo):
    offset: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def format(self) -> lief.MachO.DYLD_CHAINED_FORMAT: ...
    @property
    def ptr_format(self) -> lief.MachO.DYLD_CHAINED_PTR_FORMAT: ...
    @property
    def sign_extended_addend(self) -> int: ...

class CodeSignature(LoadCommand):
    data_offset: int
    data_size: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def content(self) -> memoryview: ...

class CodeSignatureDir(LoadCommand):
    data_offset: int
    data_size: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def content(self) -> memoryview: ...

class DYLD_CHAINED_FORMAT:
    __members__: ClassVar[dict] = ...  # read-only
    IMPORT: ClassVar[DYLD_CHAINED_FORMAT] = ...
    IMPORT_ADDEND: ClassVar[DYLD_CHAINED_FORMAT] = ...
    IMPORT_ADDEND64: ClassVar[DYLD_CHAINED_FORMAT] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class DYLD_CHAINED_PTR_FORMAT:
    __members__: ClassVar[dict] = ...  # read-only
    PTR_32: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_32_CACHE: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_32_FIRMWARE: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_64: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_64_KERNEL_CACHE: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_64_OFFSET: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_ARM64E: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_ARM64E_FIRMWARE: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_ARM64E_KERNEL: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_ARM64E_USERLAND: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_ARM64E_USERLAND24: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    PTR_X86_64_KERNEL_CACHE: ClassVar[DYLD_CHAINED_PTR_FORMAT] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class DataCodeEntry(lief.Object):
    class TYPES:
        __members__: ClassVar[dict] = ...  # read-only
        ABS_JUMP_TABLE_32: ClassVar[DataCodeEntry.TYPES] = ...
        DATA: ClassVar[DataCodeEntry.TYPES] = ...
        JUMP_TABLE_16: ClassVar[DataCodeEntry.TYPES] = ...
        JUMP_TABLE_32: ClassVar[DataCodeEntry.TYPES] = ...
        JUMP_TABLE_8: ClassVar[DataCodeEntry.TYPES] = ...
        UNKNOWN: ClassVar[DataCodeEntry.TYPES] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    length: int
    offset: int
    type: lief.MachO.DataCodeEntry.TYPES
    def __init__(self, arg0: int, arg1: int, arg2: lief.MachO.DataCodeEntry.TYPES) -> None: ...

class DataInCode(LoadCommand):
    data_offset: int
    data_size: int
    def __init__(self, *args, **kwargs) -> None: ...
    def add(self, entry: lief.MachO.DataCodeEntry) -> lief.MachO.DataInCode: ...
    @property
    def content(self) -> memoryview: ...
    @property
    def entries(self) -> lief.MachO.it_data_in_code_entries: ...

class DyldBindingInfo(BindingInfo):
    binding_class: lief.MachO.BINDING_CLASS
    binding_type: lief.MachO.BIND_TYPES
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def original_offset(self) -> int: ...

class DyldChainedFixups(LoadCommand):
    class chained_starts_in_segment:
        def __init__(self, *args, **kwargs) -> None: ...
        @property
        def max_valid_pointer(self) -> int: ...
        @property
        def offset(self) -> int: ...
        @property
        def page_count(self) -> int: ...
        @property
        def page_size(self) -> int: ...
        @property
        def page_start(self) -> List[int]: ...
        @property
        def pointer_format(self) -> lief.MachO.DYLD_CHAINED_PTR_FORMAT: ...
        @property
        def segment(self) -> lief.MachO.SegmentCommand: ...
        @property
        def segment_offset(self) -> int: ...
        @property
        def size(self) -> int: ...

    class it_binding_info:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.MachO.ChainedBindingInfo: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.ChainedBindingInfo: ...

    class it_chained_starts_in_segments_t:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.MachO.DyldChainedFixups.chained_starts_in_segment: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.DyldChainedFixups.chained_starts_in_segment: ...
    data_offset: int
    data_size: int
    fixups_version: int
    imports_count: int
    imports_format: lief.MachO.DYLD_CHAINED_FORMAT
    imports_offset: int
    starts_offset: int
    symbols_format: int
    symbols_offset: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def bindings(self) -> lief.MachO.DyldChainedFixups.it_binding_info: ...
    @property
    def chained_starts_in_segments(self) -> lief.MachO.DyldChainedFixups.it_chained_starts_in_segments_t: ...

class DyldEnvironment(LoadCommand):
    value: str
    def __init__(self, *args, **kwargs) -> None: ...

class DyldExportsTrie(LoadCommand):
    data_offset: int
    data_size: int
    def __init__(self, *args, **kwargs) -> None: ...
    def show_export_trie(self) -> str: ...
    @property
    def content(self) -> memoryview: ...
    @property
    def exports(self) -> lief.MachO.DyldInfo.it_export_info: ...

class DyldInfo(LoadCommand):
    class it_binding_info:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.MachO.DyldBindingInfo: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.DyldBindingInfo: ...

    class it_export_info:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.MachO.ExportInfo: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.ExportInfo: ...
    bind: Tuple[int,int]
    bind_opcodes: memoryview
    export_info: Tuple[int,int]
    export_trie: memoryview
    lazy_bind: Tuple[int,int]
    lazy_bind_opcodes: memoryview
    rebase: Tuple[int,int]
    rebase_opcodes: memoryview
    weak_bind: Tuple[int,int]
    weak_bind_opcodes: memoryview
    def __init__(self, *args, **kwargs) -> None: ...
    def set_bind_offset(self, offset: int) -> None: ...
    def set_bind_size(self, size: int) -> None: ...
    def set_export_offset(self, offset: int) -> None: ...
    def set_export_size(self, size: int) -> None: ...
    def set_lazy_bind_offset(self, offset: int) -> None: ...
    def set_lazy_bind_size(self, size: int) -> None: ...
    def set_rebase_offset(self, offset: int) -> None: ...
    def set_rebase_size(self, size: int) -> None: ...
    def set_weak_bind_offset(self, offset: int) -> None: ...
    def set_weak_bind_size(self, size: int) -> None: ...
    @property
    def bindings(self) -> lief.MachO.DyldInfo.it_binding_info: ...
    @property
    def exports(self) -> lief.MachO.DyldInfo.it_export_info: ...
    @property
    def show_bind_opcodes(self) -> str: ...
    @property
    def show_export_trie(self) -> str: ...
    @property
    def show_lazy_bind_opcodes(self) -> str: ...
    @property
    def show_rebases_opcodes(self) -> str: ...
    @property
    def show_weak_bind_opcodes(self) -> str: ...

class DylibCommand(LoadCommand):
    compatibility_version: List[int]
    current_version: List[int]
    name: str
    timestamp: int
    def __init__(self, *args, **kwargs) -> None: ...
    def id_dylib(self, *args, **kwargs) -> Any: ...
    def lazy_load_dylib(self, *args, **kwargs) -> Any: ...
    def load_dylib(self, *args, **kwargs) -> Any: ...
    def load_upward_dylib(self, *args, **kwargs) -> Any: ...
    def reexport_dylib(self, *args, **kwargs) -> Any: ...
    def weak_lib(self, *args, **kwargs) -> Any: ...

class DylinkerCommand(LoadCommand):
    name: str
    def __init__(self, *args, **kwargs) -> None: ...

class DynamicSymbolCommand(LoadCommand):
    external_reference_symbol_offset: int
    external_relocation_offset: int
    idx_external_define_symbol: int
    idx_local_symbol: int
    idx_undefined_symbol: int
    indirect_symbol_offset: int
    local_relocation_offset: int
    module_table_offset: int
    nb_external_define_symbols: int
    nb_external_reference_symbols: int
    nb_external_relocations: int
    nb_indirect_symbols: int
    nb_local_relocations: int
    nb_local_symbols: int
    nb_module_table: int
    nb_toc: int
    nb_undefined_symbols: int
    toc_offset: int
    def __init__(self, *args, **kwargs) -> None: ...

class EXPORT_SYMBOL_FLAGS:
    __members__: ClassVar[dict] = ...  # read-only
    REEXPORT: ClassVar[EXPORT_SYMBOL_FLAGS] = ...
    STUB_AND_RESOLVER: ClassVar[EXPORT_SYMBOL_FLAGS] = ...
    WEAK_DEFINITION: ClassVar[EXPORT_SYMBOL_FLAGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class EXPORT_SYMBOL_KINDS:
    __members__: ClassVar[dict] = ...  # read-only
    ABSOLUTE: ClassVar[EXPORT_SYMBOL_KINDS] = ...
    REGULAR: ClassVar[EXPORT_SYMBOL_KINDS] = ...
    THREAD_LOCAL: ClassVar[EXPORT_SYMBOL_KINDS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class EncryptionInfo(LoadCommand):
    crypt_id: int
    crypt_offset: int
    crypt_size: int
    def __init__(self, *args, **kwargs) -> None: ...

class ExportInfo(lief.Object):
    address: int
    flags: int
    def __init__(self, *args, **kwargs) -> None: ...
    def has(self, Checkiftheflag) -> bool: ...
    @property
    def alias(self) -> lief.MachO.Symbol: ...
    @property
    def alias_library(self) -> lief.MachO.DylibCommand: ...
    @property
    def flags_list(self) -> List[lief.MachO.EXPORT_SYMBOL_FLAGS]: ...
    @property
    def has_symbol(self) -> bool: ...
    @property
    def kind(self) -> lief.MachO.EXPORT_SYMBOL_KINDS: ...
    @property
    def node_offset(self) -> int: ...
    @property
    def symbol(self) -> lief.MachO.Symbol: ...

class FILE_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    BUNDLE: ClassVar[FILE_TYPES] = ...
    CORE: ClassVar[FILE_TYPES] = ...
    DSYM: ClassVar[FILE_TYPES] = ...
    DYLIB: ClassVar[FILE_TYPES] = ...
    DYLIB_STUB: ClassVar[FILE_TYPES] = ...
    DYLINKER: ClassVar[FILE_TYPES] = ...
    EXECUTE: ClassVar[FILE_TYPES] = ...
    FVMLIB: ClassVar[FILE_TYPES] = ...
    KEXT_BUNDLE: ClassVar[FILE_TYPES] = ...
    OBJECT: ClassVar[FILE_TYPES] = ...
    PRELOAD: ClassVar[FILE_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class FatBinary:
    class it_binaries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.MachO.Binary: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.Binary: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def at(self, index: int) -> lief.MachO.Binary: ...
    def raw(self) -> List[int]: ...
    def take(self, cpu: lief.MachO.CPU_TYPES) -> lief.MachO.Binary: ...
    def write(self, filename: str) -> None: ...
    def __getitem__(self, arg0: int) -> lief.MachO.Binary: ...
    def __iter__(self) -> lief.MachO.FatBinary.it_binaries: ...
    def __len__(self) -> int: ...
    @property
    def size(self) -> int: ...

class FilesetCommand(LoadCommand):
    file_offset: int
    name: str
    virtual_address: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def binary(self) -> lief.MachO.Binary: ...

class FunctionStarts(LoadCommand):
    data_offset: int
    data_size: int
    functions: List[int]
    def __init__(self, *args, **kwargs) -> None: ...
    def add_function(self, address: int) -> None: ...
    @property
    def content(self) -> memoryview: ...

class HEADER_FLAGS:
    __members__: ClassVar[dict] = ...  # read-only
    ALLMODSBOUND: ClassVar[HEADER_FLAGS] = ...
    ALLOW_STACK_EXECUTION: ClassVar[HEADER_FLAGS] = ...
    APP_EXTENSION_SAFE: ClassVar[HEADER_FLAGS] = ...
    BINDATLOAD: ClassVar[HEADER_FLAGS] = ...
    BINDS_TO_WEAK: ClassVar[HEADER_FLAGS] = ...
    CANONICAL: ClassVar[HEADER_FLAGS] = ...
    DEAD_STRIPPABLE_DYLIB: ClassVar[HEADER_FLAGS] = ...
    DYLDLINK: ClassVar[HEADER_FLAGS] = ...
    FORCE_FLAT: ClassVar[HEADER_FLAGS] = ...
    HAS_TLV_DESCRIPTORS: ClassVar[HEADER_FLAGS] = ...
    INCRLINK: ClassVar[HEADER_FLAGS] = ...
    LAZY_INIT: ClassVar[HEADER_FLAGS] = ...
    NOFIXPREBINDING: ClassVar[HEADER_FLAGS] = ...
    NOMULTIDEFS: ClassVar[HEADER_FLAGS] = ...
    NOUNDEFS: ClassVar[HEADER_FLAGS] = ...
    NO_HEAP_EXECUTION: ClassVar[HEADER_FLAGS] = ...
    NO_REEXPORTED_DYLIBS: ClassVar[HEADER_FLAGS] = ...
    PIE: ClassVar[HEADER_FLAGS] = ...
    PREBINDABLE: ClassVar[HEADER_FLAGS] = ...
    PREBOUND: ClassVar[HEADER_FLAGS] = ...
    ROOT_SAFE: ClassVar[HEADER_FLAGS] = ...
    SETUID_SAFE: ClassVar[HEADER_FLAGS] = ...
    SPLIT_SEGS: ClassVar[HEADER_FLAGS] = ...
    SUBSECTIONS_VIA_SYMBOLS: ClassVar[HEADER_FLAGS] = ...
    TWOLEVEL: ClassVar[HEADER_FLAGS] = ...
    WEAK_DEFINES: ClassVar[HEADER_FLAGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Header(lief.Object):
    cpu_subtype: int
    cpu_type: lief.MachO.CPU_TYPES
    file_type: lief.MachO.FILE_TYPES
    flags: Any
    magic: lief.MachO.MACHO_TYPES
    nb_cmds: int
    reserved: int
    sizeof_cmds: int
    def __init__(self) -> None: ...
    def add(self, flag: lief.MachO.HEADER_FLAGS) -> None: ...
    def has(self, flag: lief.MachO.HEADER_FLAGS) -> bool: ...
    def remove(self, flag: lief.MachO.HEADER_FLAGS) -> None: ...
    def __contains__(self, arg0: lief.MachO.HEADER_FLAGS) -> bool: ...
    def __iadd__(self, arg0: lief.MachO.HEADER_FLAGS) -> lief.MachO.Header: ...
    def __isub__(self, arg0: lief.MachO.HEADER_FLAGS) -> lief.MachO.Header: ...
    @property
    def flags_list(self) -> Set[lief.MachO.HEADER_FLAGS]: ...

class LOAD_COMMAND_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    BUILD_VERSION: ClassVar[LOAD_COMMAND_TYPES] = ...
    CODE_SIGNATURE: ClassVar[LOAD_COMMAND_TYPES] = ...
    DATA_IN_CODE: ClassVar[LOAD_COMMAND_TYPES] = ...
    DYLD_CHAINED_FIXUPS: ClassVar[LOAD_COMMAND_TYPES] = ...
    DYLD_ENVIRONMENT: ClassVar[LOAD_COMMAND_TYPES] = ...
    DYLD_EXPORTS_TRIE: ClassVar[LOAD_COMMAND_TYPES] = ...
    DYLD_INFO: ClassVar[LOAD_COMMAND_TYPES] = ...
    DYLD_INFO_ONLY: ClassVar[LOAD_COMMAND_TYPES] = ...
    DYLIB_CODE_SIGN_DRS: ClassVar[LOAD_COMMAND_TYPES] = ...
    DYSYMTAB: ClassVar[LOAD_COMMAND_TYPES] = ...
    ENCRYPTION_INFO: ClassVar[LOAD_COMMAND_TYPES] = ...
    ENCRYPTION_INFO_64: ClassVar[LOAD_COMMAND_TYPES] = ...
    FILESET_ENTRY: ClassVar[LOAD_COMMAND_TYPES] = ...
    FUNCTION_STARTS: ClassVar[LOAD_COMMAND_TYPES] = ...
    FVMFILE: ClassVar[LOAD_COMMAND_TYPES] = ...
    IDENT: ClassVar[LOAD_COMMAND_TYPES] = ...
    IDFVMLIB: ClassVar[LOAD_COMMAND_TYPES] = ...
    ID_DYLIB: ClassVar[LOAD_COMMAND_TYPES] = ...
    ID_DYLINKER: ClassVar[LOAD_COMMAND_TYPES] = ...
    LAZY_LOAD_DYLIB: ClassVar[LOAD_COMMAND_TYPES] = ...
    LINKER_OPTIMIZATION_HINT: ClassVar[LOAD_COMMAND_TYPES] = ...
    LINKER_OPTION: ClassVar[LOAD_COMMAND_TYPES] = ...
    LOADFVMLIB: ClassVar[LOAD_COMMAND_TYPES] = ...
    LOAD_DYLIB: ClassVar[LOAD_COMMAND_TYPES] = ...
    LOAD_DYLINKER: ClassVar[LOAD_COMMAND_TYPES] = ...
    LOAD_UPWARD_DYLIB: ClassVar[LOAD_COMMAND_TYPES] = ...
    LOAD_WEAK_DYLIB: ClassVar[LOAD_COMMAND_TYPES] = ...
    MAIN: ClassVar[LOAD_COMMAND_TYPES] = ...
    NOTE: ClassVar[LOAD_COMMAND_TYPES] = ...
    PREBIND_CKSUM: ClassVar[LOAD_COMMAND_TYPES] = ...
    PREBOUND_DYLIB: ClassVar[LOAD_COMMAND_TYPES] = ...
    PREPAGE: ClassVar[LOAD_COMMAND_TYPES] = ...
    REEXPORT_DYLIB: ClassVar[LOAD_COMMAND_TYPES] = ...
    ROUTINES: ClassVar[LOAD_COMMAND_TYPES] = ...
    ROUTINES_64: ClassVar[LOAD_COMMAND_TYPES] = ...
    RPATH: ClassVar[LOAD_COMMAND_TYPES] = ...
    SEGMENT: ClassVar[LOAD_COMMAND_TYPES] = ...
    SEGMENT_64: ClassVar[LOAD_COMMAND_TYPES] = ...
    SEGMENT_SPLIT_INFO: ClassVar[LOAD_COMMAND_TYPES] = ...
    SOURCE_VERSION: ClassVar[LOAD_COMMAND_TYPES] = ...
    SUB_CLIENT: ClassVar[LOAD_COMMAND_TYPES] = ...
    SUB_FRAMEWORK: ClassVar[LOAD_COMMAND_TYPES] = ...
    SUB_LIBRARY: ClassVar[LOAD_COMMAND_TYPES] = ...
    SUB_UMBRELLA: ClassVar[LOAD_COMMAND_TYPES] = ...
    SYMSEG: ClassVar[LOAD_COMMAND_TYPES] = ...
    SYMTAB: ClassVar[LOAD_COMMAND_TYPES] = ...
    THREAD: ClassVar[LOAD_COMMAND_TYPES] = ...
    TWOLEVEL_HINTS: ClassVar[LOAD_COMMAND_TYPES] = ...
    UNIXTHREAD: ClassVar[LOAD_COMMAND_TYPES] = ...
    UUID: ClassVar[LOAD_COMMAND_TYPES] = ...
    VERSION_MIN_IPHONEOS: ClassVar[LOAD_COMMAND_TYPES] = ...
    VERSION_MIN_MACOSX: ClassVar[LOAD_COMMAND_TYPES] = ...
    VERSION_MIN_TVOS: ClassVar[LOAD_COMMAND_TYPES] = ...
    VERSION_MIN_WATCHOS: ClassVar[LOAD_COMMAND_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class LinkerOptHint(LoadCommand):
    data_offset: int
    data_size: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def content(self) -> memoryview: ...

class LoadCommand(lief.Object):
    command: lief.MachO.LOAD_COMMAND_TYPES
    command_offset: int
    data: List[int]
    size: int
    def __init__(self) -> None: ...

class MACHO_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    CIGAM: ClassVar[MACHO_TYPES] = ...
    CIGAM_64: ClassVar[MACHO_TYPES] = ...
    FAT_CIGAM: ClassVar[MACHO_TYPES] = ...
    FAT_MAGIC: ClassVar[MACHO_TYPES] = ...
    MAGIC: ClassVar[MACHO_TYPES] = ...
    MAGIC_64: ClassVar[MACHO_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class MainCommand(LoadCommand):
    entrypoint: int
    stack_size: int
    def __init__(self, *args, **kwargs) -> None: ...

class PPC_RELOCATION:
    __members__: ClassVar[dict] = ...  # read-only
    BR14: ClassVar[PPC_RELOCATION] = ...
    BR24: ClassVar[PPC_RELOCATION] = ...
    HA16: ClassVar[PPC_RELOCATION] = ...
    HA16_SECTDIFF: ClassVar[PPC_RELOCATION] = ...
    HI16: ClassVar[PPC_RELOCATION] = ...
    HI16_SECTDIFF: ClassVar[PPC_RELOCATION] = ...
    JBSR: ClassVar[PPC_RELOCATION] = ...
    LO14: ClassVar[PPC_RELOCATION] = ...
    LO14_SECTDIFF: ClassVar[PPC_RELOCATION] = ...
    LO16: ClassVar[PPC_RELOCATION] = ...
    LO16_SECTDIFF: ClassVar[PPC_RELOCATION] = ...
    LOCAL_SECTDIFF: ClassVar[PPC_RELOCATION] = ...
    PAIR: ClassVar[PPC_RELOCATION] = ...
    PB_LA_PTR: ClassVar[PPC_RELOCATION] = ...
    SECTDIFF: ClassVar[PPC_RELOCATION] = ...
    VANILLA: ClassVar[PPC_RELOCATION] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ParserConfig:
    deep: ClassVar[lief.MachO.ParserConfig] = ...  # read-only
    quick: ClassVar[lief.MachO.ParserConfig] = ...  # read-only
    fix_from_memory: bool
    parse_dyld_bindings: bool
    parse_dyld_exports: bool
    parse_dyld_rebases: bool
    def __init__(self) -> None: ...
    def full_dyldinfo(self, flag: bool) -> lief.MachO.ParserConfig: ...

class REBASE_OPCODES:
    __members__: ClassVar[dict] = ...  # read-only
    ADD_ADDR_IMM_SCALED: ClassVar[REBASE_OPCODES] = ...
    ADD_ADDR_ULEB: ClassVar[REBASE_OPCODES] = ...
    DONE: ClassVar[REBASE_OPCODES] = ...
    DO_REBASE_ADD_ADDR_ULEB: ClassVar[REBASE_OPCODES] = ...
    DO_REBASE_IMM_TIMES: ClassVar[REBASE_OPCODES] = ...
    DO_REBASE_ULEB_TIMES: ClassVar[REBASE_OPCODES] = ...
    DO_REBASE_ULEB_TIMES_SKIPPING_ULEB: ClassVar[REBASE_OPCODES] = ...
    SET_SEGMENT_AND_OFFSET_ULEB: ClassVar[REBASE_OPCODES] = ...
    SET_TYPE_IMM: ClassVar[REBASE_OPCODES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class REBASE_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    POINTER: ClassVar[REBASE_TYPES] = ...
    TEXT_ABSOLUTE32: ClassVar[REBASE_TYPES] = ...
    TEXT_PCREL32: ClassVar[REBASE_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RELOCATION_ORIGINS:
    __members__: ClassVar[dict] = ...  # read-only
    CHAINED_FIXUPS: ClassVar[RELOCATION_ORIGINS] = ...
    DYLDINFO: ClassVar[RELOCATION_ORIGINS] = ...
    RELOC_TABLE: ClassVar[RELOCATION_ORIGINS] = ...
    UNKNOWN: ClassVar[RELOCATION_ORIGINS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RPathCommand(LoadCommand):
    path: str
    def __init__(self, *args, **kwargs) -> None: ...

class Relocation(lief.Relocation):
    address: int
    pc_relative: bool
    type: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def architecture(self) -> lief.MachO.CPU_TYPES: ...
    @property
    def has_section(self) -> bool: ...
    @property
    def has_segment(self) -> bool: ...
    @property
    def has_symbol(self) -> bool: ...
    @property
    def origin(self) -> lief.MachO.RELOCATION_ORIGINS: ...
    @property
    def section(self) -> lief.MachO.Section: ...
    @property
    def segment(self) -> lief.MachO.SegmentCommand: ...
    @property
    def symbol(self) -> lief.MachO.Symbol: ...

class RelocationDyld(Relocation):
    def __init__(self, *args, **kwargs) -> None: ...

class RelocationFixup(Relocation):
    target: int
    def __init__(self, *args, **kwargs) -> None: ...

class RelocationObject(Relocation):
    value: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def is_scattered(self) -> bool: ...

class SECTION_FLAGS:
    __members__: ClassVar[dict] = ...  # read-only
    DEBUG: ClassVar[SECTION_FLAGS] = ...
    EXT_RELOC: ClassVar[SECTION_FLAGS] = ...
    LIVE_SUPPORT: ClassVar[SECTION_FLAGS] = ...
    LOC_RELOC: ClassVar[SECTION_FLAGS] = ...
    NO_DEAD_STRIP: ClassVar[SECTION_FLAGS] = ...
    NO_TOC: ClassVar[SECTION_FLAGS] = ...
    PURE_INSTRUCTIONS: ClassVar[SECTION_FLAGS] = ...
    SELF_MODIFYING_CODE: ClassVar[SECTION_FLAGS] = ...
    SOME_INSTRUCTIONS: ClassVar[SECTION_FLAGS] = ...
    STRIP_STATIC_SYMS: ClassVar[SECTION_FLAGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SECTION_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    COALESCED: ClassVar[SECTION_TYPES] = ...
    CSTRING_LITERALS: ClassVar[SECTION_TYPES] = ...
    DTRACE_DOF: ClassVar[SECTION_TYPES] = ...
    GB_ZEROFILL: ClassVar[SECTION_TYPES] = ...
    INTERPOSING: ClassVar[SECTION_TYPES] = ...
    LAZY_DYLIB_SYMBOL_POINTERS: ClassVar[SECTION_TYPES] = ...
    LAZY_SYMBOL_POINTERS: ClassVar[SECTION_TYPES] = ...
    LITERAL_POINTERS: ClassVar[SECTION_TYPES] = ...
    MOD_INIT_FUNC_POINTERS: ClassVar[SECTION_TYPES] = ...
    MOD_TERM_FUNC_POINTERS: ClassVar[SECTION_TYPES] = ...
    NON_LAZY_SYMBOL_POINTERS: ClassVar[SECTION_TYPES] = ...
    REGULAR: ClassVar[SECTION_TYPES] = ...
    SYMBOL_STUBS: ClassVar[SECTION_TYPES] = ...
    S_16BYTE_LITERALS: ClassVar[SECTION_TYPES] = ...
    S_4BYTE_LITERALS: ClassVar[SECTION_TYPES] = ...
    S_8BYTE_LITERALS: ClassVar[SECTION_TYPES] = ...
    THREAD_LOCAL_INIT_FUNCTION_POINTERS: ClassVar[SECTION_TYPES] = ...
    THREAD_LOCAL_REGULAR: ClassVar[SECTION_TYPES] = ...
    THREAD_LOCAL_VARIABLES: ClassVar[SECTION_TYPES] = ...
    THREAD_LOCAL_VARIABLE_POINTERS: ClassVar[SECTION_TYPES] = ...
    THREAD_LOCAL_ZEROFILL: ClassVar[SECTION_TYPES] = ...
    ZEROFILL: ClassVar[SECTION_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SYMBOL_ORIGINS:
    __members__: ClassVar[dict] = ...  # read-only
    DYLD_EXPORT: ClassVar[SYMBOL_ORIGINS] = ...
    LC_SYMTAB: ClassVar[SYMBOL_ORIGINS] = ...
    UNKNOWN: ClassVar[SYMBOL_ORIGINS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Section(lief.Section):
    alignment: int
    flags: int
    numberof_relocations: int
    relocation_offset: int
    reserved1: int
    reserved2: int
    reserved3: int
    segment_name: str
    type: lief.MachO.SECTION_TYPES
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, section_name: str) -> None: ...
    @overload
    def __init__(self, section_name: str, content: List[int]) -> None: ...
    def add(self, flag: lief.MachO.SECTION_FLAGS) -> None: ...
    def has(self, flag: lief.MachO.SECTION_FLAGS) -> bool: ...
    def remove(self, flag: lief.MachO.SECTION_FLAGS) -> None: ...
    def __contains__(self, arg0: lief.MachO.SECTION_FLAGS) -> bool: ...
    def __iadd__(self, arg0: lief.MachO.SECTION_FLAGS) -> lief.MachO.Section: ...
    def __isub__(self, arg0: lief.MachO.SECTION_FLAGS) -> lief.MachO.Section: ...
    @property
    def flags_list(self) -> Set[lief.MachO.SECTION_FLAGS]: ...
    @property
    def has_segment(self) -> bool: ...
    @property
    def relocations(self) -> lief.MachO.SegmentCommand.it_relocations: ...
    @property
    def segment(self) -> lief.MachO.SegmentCommand: ...

class SegmentCommand(LoadCommand):
    class it_relocations:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.MachO.Relocation: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.Relocation: ...

    class it_sections:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.MachO.Section: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.MachO.Section: ...
    content: memoryview
    file_offset: int
    file_size: int
    flags: int
    init_protection: int
    max_protection: int
    name: object
    numberof_sections: int
    virtual_address: int
    virtual_size: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: str) -> None: ...
    @overload
    def __init__(self, arg0: str, arg1: List[int]) -> None: ...
    def add_section(self, section: lief.MachO.Section) -> lief.MachO.Section: ...
    def get_section(self, name: str) -> lief.MachO.Section: ...
    def has(self, section: lief.MachO.Section) -> bool: ...
    def has_section(self, section_name: str) -> bool: ...
    @property
    def index(self) -> int: ...
    @property
    def relocations(self) -> lief.MachO.SegmentCommand.it_relocations: ...
    @property
    def sections(self) -> lief.MachO.SegmentCommand.it_sections: ...

class SegmentSplitInfo(LoadCommand):
    data_offset: int
    data_size: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def content(self) -> memoryview: ...

class SourceVersion(LoadCommand):
    version: List[int]
    def __init__(self, *args, **kwargs) -> None: ...

class SubFramework(LoadCommand):
    umbrella: str
    def __init__(self, *args, **kwargs) -> None: ...

class Symbol(lief.Symbol):
    class TOOLS:
        __members__: ClassVar[dict] = ...  # read-only
        EXTERNAL: ClassVar[Symbol.TOOLS] = ...
        INDIRECT_ABS: ClassVar[Symbol.TOOLS] = ...
        INDIRECT_LOCAL: ClassVar[Symbol.TOOLS] = ...
        LOCAL: ClassVar[Symbol.TOOLS] = ...
        NONE: ClassVar[Symbol.TOOLS] = ...
        UNDEFINED: ClassVar[Symbol.TOOLS] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    description: int
    numberof_sections: int
    type: int
    def __init__(self) -> None: ...
    @property
    def binding_info(self) -> lief.MachO.BindingInfo: ...
    @property
    def demangled_name(self) -> str: ...
    @property
    def export_info(self) -> lief.MachO.ExportInfo: ...
    @property
    def has_binding_info(self) -> bool: ...
    @property
    def has_export_info(self) -> bool: ...
    @property
    def origin(self) -> lief.MachO.SYMBOL_ORIGINS: ...

class SymbolCommand(LoadCommand):
    numberof_symbols: int
    strings_offset: int
    strings_size: int
    symbol_offset: int
    def __init__(self) -> None: ...

class ThreadCommand(LoadCommand):
    architecture: lief.MachO.CPU_TYPES
    count: int
    flavor: int
    state: List[int]
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def pc(self) -> int: ...

class TwoLevelHints(LoadCommand):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def content(self) -> memoryview: ...
    @property
    def hints(self) -> Any: ...

class UUIDCommand(LoadCommand):
    uuid: List[int]
    def __init__(self, *args, **kwargs) -> None: ...

class VM_PROTECTIONS:
    __members__: ClassVar[dict] = ...  # read-only
    EXECUTE: ClassVar[VM_PROTECTIONS] = ...
    READ: ClassVar[VM_PROTECTIONS] = ...
    WRITE: ClassVar[VM_PROTECTIONS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class VersionMin(LoadCommand):
    sdk: List[int]
    version: List[int]
    def __init__(self, *args, **kwargs) -> None: ...

class X86_64_RELOCATION:
    __members__: ClassVar[dict] = ...  # read-only
    BRANCH: ClassVar[X86_64_RELOCATION] = ...
    GOT: ClassVar[X86_64_RELOCATION] = ...
    GOT_LOAD: ClassVar[X86_64_RELOCATION] = ...
    SIGNED: ClassVar[X86_64_RELOCATION] = ...
    SIGNED_1: ClassVar[X86_64_RELOCATION] = ...
    SIGNED_2: ClassVar[X86_64_RELOCATION] = ...
    SIGNED_4: ClassVar[X86_64_RELOCATION] = ...
    SUBTRACTOR: ClassVar[X86_64_RELOCATION] = ...
    TLV: ClassVar[X86_64_RELOCATION] = ...
    UNSIGNED: ClassVar[X86_64_RELOCATION] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class X86_RELOCATION:
    __members__: ClassVar[dict] = ...  # read-only
    LOCAL_SECTDIFF: ClassVar[X86_RELOCATION] = ...
    PAIR: ClassVar[X86_RELOCATION] = ...
    PB_LA_PTR: ClassVar[X86_RELOCATION] = ...
    SECTDIFF: ClassVar[X86_RELOCATION] = ...
    TLV: ClassVar[X86_RELOCATION] = ...
    VANILLA: ClassVar[X86_RELOCATION] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class it_data_in_code_entries:
    def __init__(self, *args, **kwargs) -> None: ...
    def __getitem__(self, arg0: int) -> lief.MachO.DataCodeEntry: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __next__(self) -> lief.MachO.DataCodeEntry: ...

@overload
def check_layout(file: lief.MachO.Binary) -> Tuple[bool,str]: ...
@overload
def check_layout(file: lief.MachO.FatBinary) -> Tuple[bool,str]: ...
def is_64(file: str) -> bool: ...
def is_fat(file: str) -> bool: ...
@overload
def is_macho(filename: str) -> bool: ...
@overload
def is_macho(raw: List[int]) -> bool: ...
@overload
def parse(filename: str, config: lief.MachO.ParserConfig = ...) -> lief.MachO.Binary | None: ...
@overload
def parse(raw: List[int], name: str = ..., config: lief.MachO.ParserConfig = ...) -> lief.MachO.Binary | None: ...
@overload
def parse(io: object, name: str = ..., config: lief.MachO.ParserConfig = ...) -> lief.MachO.Binary | None: ...
def parse_from_memory(address: int, config: lief.MachO.ParserConfig = ...) -> lief.MachO.FatBinary: ...
