from typing import Any, ClassVar, Iterator, List, Set

from . import ART, Android, DEX, ELF, MachO, OAT, PE, VDEX, logging # type: ignore
from typing import overload
import lief # type: ignore

class ARCHITECTURES:
    __members__: ClassVar[dict] = ...  # read-only
    ARM: ClassVar[ARCHITECTURES] = ...
    ARM64: ClassVar[ARCHITECTURES] = ...
    INTEL: ClassVar[ARCHITECTURES] = ...
    MIPS: ClassVar[ARCHITECTURES] = ...
    NONE: ClassVar[ARCHITECTURES] = ...
    PPC: ClassVar[ARCHITECTURES] = ...
    RISCV: ClassVar[ARCHITECTURES] = ...
    SPARC: ClassVar[ARCHITECTURES] = ...
    SYSZ: ClassVar[ARCHITECTURES] = ...
    X86: ClassVar[ARCHITECTURES] = ...
    XCORE: ClassVar[ARCHITECTURES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Binary(Object):
    class VA_TYPES:
        __members__: ClassVar[dict] = ...  # read-only
        AUTO: ClassVar[Binary.VA_TYPES] = ...
        RVA: ClassVar[Binary.VA_TYPES] = ...
        VA: ClassVar[Binary.VA_TYPES] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class it_relocations:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.Relocation: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.Relocation: ...

    class it_sections:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.Section: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.Section: ...

    class it_symbols:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.Symbol: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.Symbol: ...
    name: str
    def __init__(self, *args, **kwargs) -> None: ...
    def get_content_from_virtual_address(self, virtual_address: int, size: int, va_type: lief.Binary.VA_TYPES = ...) -> memoryview: ...
    def get_function_address(self, function_name: str) -> object: ...
    def get_symbol(self, symbol_name: str) -> lief.Symbol: ...
    def has_symbol(self, symbol_name: str) -> bool: ...
    def offset_to_virtual_address(self, offset: int, slide: int = ...) -> object: ...
    @overload
    def patch_address(self, address: int, patch_value: List[int], va_type: lief.Binary.VA_TYPES = ...) -> None: ...
    @overload
    def patch_address(self, address: int, patch_value: int, size: int = ..., va_type: lief.Binary.VA_TYPES = ...) -> None: ...
    def remove_section(self, name: str, clear: bool = ...) -> None: ...
    def xref(self, virtual_address: int) -> List[int]: ...
    @property
    def abstract(self) -> lief.Binary: ...
    @property
    def concrete(self) -> lief.ELF.Binary | lief.PE.Binary | lief.MachO.Binary: ...
    @property
    def ctor_functions(self) -> List[lief.Function]: ...
    @property
    def entrypoint(self) -> int: ...
    @property
    def exported_functions(self) -> Any: ...
    @property
    def format(self) -> lief.EXE_FORMATS: ...
    @property
    def has_nx(self) -> bool: ...
    @property
    def header(self) -> Any: ...
    @property
    def imagebase(self) -> int: ...
    @property
    def imported_functions(self) -> Any: ...
    @property
    def is_pie(self) -> bool: ...
    @property
    def libraries(self) -> Any: ...
    @property
    def relocations(self) -> Any: ...
    @property
    def sections(self) -> Any: ...
    @property
    def symbols(self) -> Any: ...

class ENDIANNESS:
    __members__: ClassVar[dict] = ...  # read-only
    BIG: ClassVar[ENDIANNESS] = ...
    LITTLE: ClassVar[ENDIANNESS] = ...
    NONE: ClassVar[ENDIANNESS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class EXE_FORMATS:
    __members__: ClassVar[dict] = ...  # read-only
    ELF: ClassVar[EXE_FORMATS] = ...
    MACHO: ClassVar[EXE_FORMATS] = ...
    PE: ClassVar[EXE_FORMATS] = ...
    UNKNOWN: ClassVar[EXE_FORMATS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Function(Symbol):
    class FLAGS:
        __members__: ClassVar[dict] = ...  # read-only
        CONSTRUCTOR: ClassVar[Function.FLAGS] = ...
        DEBUG: ClassVar[Function.FLAGS] = ...
        DESTRUCTOR: ClassVar[Function.FLAGS] = ...
        EXPORTED: ClassVar[Function.FLAGS] = ...
        IMPORTED: ClassVar[Function.FLAGS] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    address: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: str) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    @overload
    def __init__(self, arg0: str, arg1: int) -> None: ...
    def add(self, flag: lief.Function.FLAGS) -> lief.Function: ...
    @property
    def flags(self) -> List[lief.Function.FLAGS]: ...

class Header(Object):
    architecture: Any
    endianness: lief.ENDIANNESS
    entrypoint: int
    modes: Set[lief.MODES]
    object_type: lief.OBJECT_TYPES
    def __init__(self) -> None: ...
    @property
    def is_32(self) -> bool: ...
    @property
    def is_64(self) -> bool: ...

class MODES:
    __members__: ClassVar[dict] = ...  # read-only
    ARM: ClassVar[MODES] = ...
    M16: ClassVar[MODES] = ...
    M32: ClassVar[MODES] = ...
    M64: ClassVar[MODES] = ...
    MCLASS: ClassVar[MODES] = ...
    MIPS3: ClassVar[MODES] = ...
    MIPS32: ClassVar[MODES] = ...
    MIPS32R6: ClassVar[MODES] = ...
    MIPS64: ClassVar[MODES] = ...
    MIPSGP64: ClassVar[MODES] = ...
    NONE: ClassVar[MODES] = ...
    THUMB: ClassVar[MODES] = ...
    UNDEFINED: ClassVar[MODES] = ...
    V7: ClassVar[MODES] = ...
    V8: ClassVar[MODES] = ...
    V9: ClassVar[MODES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class OBJECT_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    EXECUTABLE: ClassVar[OBJECT_TYPES] = ...
    LIBRARY: ClassVar[OBJECT_TYPES] = ...
    NONE: ClassVar[OBJECT_TYPES] = ...
    OBJECT: ClassVar[OBJECT_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Object:
    def __init__(self, *args, **kwargs) -> None: ...

class PLATFORMS:
    __members__: ClassVar[dict] = ...  # read-only
    ANDROID: ClassVar[PLATFORMS] = ...
    IOS: ClassVar[PLATFORMS] = ...
    LINUX: ClassVar[PLATFORMS] = ...
    OSX: ClassVar[PLATFORMS] = ...
    UNKNOWN: ClassVar[PLATFORMS] = ...
    WINDOWS: ClassVar[PLATFORMS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Relocation(Object):
    address: int
    size: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, address: int, size: int) -> None: ...

class Section(Object):
    content: memoryview
    name: object
    offset: int
    size: int
    virtual_address: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, name: str) -> None: ...
    @overload
    def search(self, number: int, pos: int = ..., size: int = ...) -> int | None: ...
    @overload
    def search(self, str: str, pos: int = ...) -> int | None: ...
    @overload
    def search(self, bytes: bytes, pos: int = ...) -> int | None: ...
    @overload
    def search_all(self, number: int, size: int = ...) -> List[int]: ...
    @overload
    def search_all(self, str: str) -> List[int]: ...
    @property
    def entropy(self) -> float: ...
    @property
    def fullname(self) -> str: ...

class Symbol(Object):
    name: object
    size: int
    value: int
    def __init__(self) -> None: ...

class lief_errors:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    asn1_bad_tag: ClassVar[lief_errors] = ...
    build_error: ClassVar[lief_errors] = ...
    conversion_error: ClassVar[lief_errors] = ...
    corrupted: ClassVar[lief_errors] = ...
    data_too_large: ClassVar[lief_errors] = ...
    file_error: ClassVar[lief_errors] = ...
    file_format_error: ClassVar[lief_errors] = ...
    not_found: ClassVar[lief_errors] = ...
    not_implemented: ClassVar[lief_errors] = ...
    not_supported: ClassVar[lief_errors] = ...
    parsing_error: ClassVar[lief_errors] = ...
    read_error: ClassVar[lief_errors] = ...
    read_out_of_bound: ClassVar[lief_errors] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ok_t:
    def __init__(self, *args, **kwargs) -> None: ...
    def __bool__(self) -> bool: ...

@overload
def art_version(filename: str) -> int: ...
@overload
def art_version(raw: List[int]) -> int: ...
def breakp() -> object: ...
def current_platform() -> lief.PLATFORMS: ...
def demangle(arg0: str) -> object: ...
@overload
def dex_version(filename: str) -> int: ...
@overload
def dex_version(raw: List[int]) -> int: ...
@overload
def hash(arg0: lief.Object) -> int: ...
@overload
def hash(arg0: List[int]) -> int: ...
@overload
def hash(arg0: bytes) -> int: ...
@overload
def hash(arg0: str) -> int: ...
@overload
def is_art(filename: str) -> bool: ...
@overload
def is_art(raw: List[int]) -> bool: ...
@overload
def is_dex(filename: str) -> bool: ...
@overload
def is_dex(raw: List[int]) -> bool: ...
@overload
def is_elf(filename: str) -> bool: ...
@overload
def is_elf(raw: List[int]) -> bool: ...
@overload
def is_macho(filename: str) -> bool: ...
@overload
def is_macho(raw: List[int]) -> bool: ...
@overload
def is_oat(filename: str) -> bool: ...
@overload
def is_oat(raw: List[int]) -> bool: ...
@overload
def is_oat(elf: lief.ELF.Binary) -> bool: ...
@overload
def is_pe(filename: str) -> bool: ...
@overload
def is_pe(raw: List[int]) -> bool: ...
@overload
def is_vdex(filename: str) -> bool: ...
@overload
def is_vdex(raw: List[int]) -> bool: ...
@overload
def oat_version(filename: str) -> int: ...
@overload
def oat_version(raw: List[int]) -> int: ...
@overload
def oat_version(elf: lief.ELF.Binary) -> int: ...
@overload
def parse(raw: bytes, name: str = ...) -> lief.Binary: ...
@overload
def parse(filepath: str) -> lief.Binary: ...
@overload
def parse(io: object, name: str = ...) -> object: ...
def shell() -> object: ...
def to_json(arg0: lief.Object) -> str: ...
def to_json_from_abstract(arg0: lief.Object) -> str: ...
@overload
def vdex_version(filename: str) -> int: ...
@overload
def vdex_version(raw: List[int]) -> int: ...
