/* Copyright 2022 - 2025 R. Thomas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_ASM_EBPF_OPCODE_H
#define LIEF_ASM_EBPF_OPCODE_H

/* Generated from LLVM: 21.1.0 */

namespace LIEF {
namespace assembly {
namespace ebpf {
enum class OPCODE {
  PHI = 0,
  INLINEASM = 1,
  INLINEASM_BR = 2,
  CFI_INSTRUCTION = 3,
  EH_LABEL = 4,
  GC_LABEL = 5,
  ANNOTATION_LABEL = 6,
  KILL = 7,
  EXTRACT_SUBREG = 8,
  INSERT_SUBREG = 9,
  IMPLICIT_DEF = 10,
  INIT_UNDEF = 11,
  SUBREG_TO_REG = 12,
  COPY_TO_REGCLASS = 13,
  DBG_VALUE = 14,
  DBG_VALUE_LIST = 15,
  DBG_INSTR_REF = 16,
  DBG_PHI = 17,
  DBG_LABEL = 18,
  REG_SEQUENCE = 19,
  COPY = 20,
  BUNDLE = 21,
  LIFETIME_START = 22,
  LIFETIME_END = 23,
  PSEUDO_PROBE = 24,
  ARITH_FENCE = 25,
  STACKMAP = 26,
  FENTRY_CALL = 27,
  PATCHPOINT = 28,
  LOAD_STACK_GUARD = 29,
  PREALLOCATED_SETUP = 30,
  PREALLOCATED_ARG = 31,
  STATEPOINT = 32,
  LOCAL_ESCAPE = 33,
  FAULTING_OP = 34,
  PATCHABLE_OP = 35,
  PATCHABLE_FUNCTION_ENTER = 36,
  PATCHABLE_RET = 37,
  PATCHABLE_FUNCTION_EXIT = 38,
  PATCHABLE_TAIL_CALL = 39,
  PATCHABLE_EVENT_CALL = 40,
  PATCHABLE_TYPED_EVENT_CALL = 41,
  ICALL_BRANCH_FUNNEL = 42,
  FAKE_USE = 43,
  MEMBARRIER = 44,
  JUMP_TABLE_DEBUG_INFO = 45,
  CONVERGENCECTRL_ENTRY = 46,
  CONVERGENCECTRL_ANCHOR = 47,
  CONVERGENCECTRL_LOOP = 48,
  CONVERGENCECTRL_GLUE = 49,
  G_ASSERT_SEXT = 50,
  G_ASSERT_ZEXT = 51,
  G_ASSERT_ALIGN = 52,
  G_ADD = 53,
  G_SUB = 54,
  G_MUL = 55,
  G_SDIV = 56,
  G_UDIV = 57,
  G_SREM = 58,
  G_UREM = 59,
  G_SDIVREM = 60,
  G_UDIVREM = 61,
  G_AND = 62,
  G_OR = 63,
  G_XOR = 64,
  G_ABDS = 65,
  G_ABDU = 66,
  G_IMPLICIT_DEF = 67,
  G_PHI = 68,
  G_FRAME_INDEX = 69,
  G_GLOBAL_VALUE = 70,
  G_PTRAUTH_GLOBAL_VALUE = 71,
  G_CONSTANT_POOL = 72,
  G_EXTRACT = 73,
  G_UNMERGE_VALUES = 74,
  G_INSERT = 75,
  G_MERGE_VALUES = 76,
  G_BUILD_VECTOR = 77,
  G_BUILD_VECTOR_TRUNC = 78,
  G_CONCAT_VECTORS = 79,
  G_PTRTOINT = 80,
  G_INTTOPTR = 81,
  G_BITCAST = 82,
  G_FREEZE = 83,
  G_CONSTANT_FOLD_BARRIER = 84,
  G_INTRINSIC_FPTRUNC_ROUND = 85,
  G_INTRINSIC_TRUNC = 86,
  G_INTRINSIC_ROUND = 87,
  G_INTRINSIC_LRINT = 88,
  G_INTRINSIC_LLRINT = 89,
  G_INTRINSIC_ROUNDEVEN = 90,
  G_READCYCLECOUNTER = 91,
  G_READSTEADYCOUNTER = 92,
  G_LOAD = 93,
  G_SEXTLOAD = 94,
  G_ZEXTLOAD = 95,
  G_INDEXED_LOAD = 96,
  G_INDEXED_SEXTLOAD = 97,
  G_INDEXED_ZEXTLOAD = 98,
  G_STORE = 99,
  G_INDEXED_STORE = 100,
  G_ATOMIC_CMPXCHG_WITH_SUCCESS = 101,
  G_ATOMIC_CMPXCHG = 102,
  G_ATOMICRMW_XCHG = 103,
  G_ATOMICRMW_ADD = 104,
  G_ATOMICRMW_SUB = 105,
  G_ATOMICRMW_AND = 106,
  G_ATOMICRMW_NAND = 107,
  G_ATOMICRMW_OR = 108,
  G_ATOMICRMW_XOR = 109,
  G_ATOMICRMW_MAX = 110,
  G_ATOMICRMW_MIN = 111,
  G_ATOMICRMW_UMAX = 112,
  G_ATOMICRMW_UMIN = 113,
  G_ATOMICRMW_FADD = 114,
  G_ATOMICRMW_FSUB = 115,
  G_ATOMICRMW_FMAX = 116,
  G_ATOMICRMW_FMIN = 117,
  G_ATOMICRMW_FMAXIMUM = 118,
  G_ATOMICRMW_FMINIMUM = 119,
  G_ATOMICRMW_UINC_WRAP = 120,
  G_ATOMICRMW_UDEC_WRAP = 121,
  G_ATOMICRMW_USUB_COND = 122,
  G_ATOMICRMW_USUB_SAT = 123,
  G_FENCE = 124,
  G_PREFETCH = 125,
  G_BRCOND = 126,
  G_BRINDIRECT = 127,
  G_INVOKE_REGION_START = 128,
  G_INTRINSIC = 129,
  G_INTRINSIC_W_SIDE_EFFECTS = 130,
  G_INTRINSIC_CONVERGENT = 131,
  G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS = 132,
  G_ANYEXT = 133,
  G_TRUNC = 134,
  G_TRUNC_SSAT_S = 135,
  G_TRUNC_SSAT_U = 136,
  G_TRUNC_USAT_U = 137,
  G_CONSTANT = 138,
  G_FCONSTANT = 139,
  G_VASTART = 140,
  G_VAARG = 141,
  G_SEXT = 142,
  G_SEXT_INREG = 143,
  G_ZEXT = 144,
  G_SHL = 145,
  G_LSHR = 146,
  G_ASHR = 147,
  G_FSHL = 148,
  G_FSHR = 149,
  G_ROTR = 150,
  G_ROTL = 151,
  G_ICMP = 152,
  G_FCMP = 153,
  G_SCMP = 154,
  G_UCMP = 155,
  G_SELECT = 156,
  G_UADDO = 157,
  G_UADDE = 158,
  G_USUBO = 159,
  G_USUBE = 160,
  G_SADDO = 161,
  G_SADDE = 162,
  G_SSUBO = 163,
  G_SSUBE = 164,
  G_UMULO = 165,
  G_SMULO = 166,
  G_UMULH = 167,
  G_SMULH = 168,
  G_UADDSAT = 169,
  G_SADDSAT = 170,
  G_USUBSAT = 171,
  G_SSUBSAT = 172,
  G_USHLSAT = 173,
  G_SSHLSAT = 174,
  G_SMULFIX = 175,
  G_UMULFIX = 176,
  G_SMULFIXSAT = 177,
  G_UMULFIXSAT = 178,
  G_SDIVFIX = 179,
  G_UDIVFIX = 180,
  G_SDIVFIXSAT = 181,
  G_UDIVFIXSAT = 182,
  G_FADD = 183,
  G_FSUB = 184,
  G_FMUL = 185,
  G_FMA = 186,
  G_FMAD = 187,
  G_FDIV = 188,
  G_FREM = 189,
  G_FPOW = 190,
  G_FPOWI = 191,
  G_FEXP = 192,
  G_FEXP2 = 193,
  G_FEXP10 = 194,
  G_FLOG = 195,
  G_FLOG2 = 196,
  G_FLOG10 = 197,
  G_FLDEXP = 198,
  G_FFREXP = 199,
  G_FNEG = 200,
  G_FPEXT = 201,
  G_FPTRUNC = 202,
  G_FPTOSI = 203,
  G_FPTOUI = 204,
  G_SITOFP = 205,
  G_UITOFP = 206,
  G_FPTOSI_SAT = 207,
  G_FPTOUI_SAT = 208,
  G_FABS = 209,
  G_FCOPYSIGN = 210,
  G_IS_FPCLASS = 211,
  G_FCANONICALIZE = 212,
  G_FMINNUM = 213,
  G_FMAXNUM = 214,
  G_FMINNUM_IEEE = 215,
  G_FMAXNUM_IEEE = 216,
  G_FMINIMUM = 217,
  G_FMAXIMUM = 218,
  G_FMINIMUMNUM = 219,
  G_FMAXIMUMNUM = 220,
  G_GET_FPENV = 221,
  G_SET_FPENV = 222,
  G_RESET_FPENV = 223,
  G_GET_FPMODE = 224,
  G_SET_FPMODE = 225,
  G_RESET_FPMODE = 226,
  G_GET_ROUNDING = 227,
  G_PTR_ADD = 228,
  G_PTRMASK = 229,
  G_SMIN = 230,
  G_SMAX = 231,
  G_UMIN = 232,
  G_UMAX = 233,
  G_ABS = 234,
  G_LROUND = 235,
  G_LLROUND = 236,
  G_BR = 237,
  G_BRJT = 238,
  G_VSCALE = 239,
  G_INSERT_SUBVECTOR = 240,
  G_EXTRACT_SUBVECTOR = 241,
  G_INSERT_VECTOR_ELT = 242,
  G_EXTRACT_VECTOR_ELT = 243,
  G_SHUFFLE_VECTOR = 244,
  G_SPLAT_VECTOR = 245,
  G_STEP_VECTOR = 246,
  G_VECTOR_COMPRESS = 247,
  G_CTTZ = 248,
  G_CTTZ_ZERO_UNDEF = 249,
  G_CTLZ = 250,
  G_CTLZ_ZERO_UNDEF = 251,
  G_CTPOP = 252,
  G_BSWAP = 253,
  G_BITREVERSE = 254,
  G_FCEIL = 255,
  G_FCOS = 256,
  G_FSIN = 257,
  G_FSINCOS = 258,
  G_FTAN = 259,
  G_FACOS = 260,
  G_FASIN = 261,
  G_FATAN = 262,
  G_FATAN2 = 263,
  G_FCOSH = 264,
  G_FSINH = 265,
  G_FTANH = 266,
  G_FSQRT = 267,
  G_FFLOOR = 268,
  G_FRINT = 269,
  G_FNEARBYINT = 270,
  G_ADDRSPACE_CAST = 271,
  G_BLOCK_ADDR = 272,
  G_JUMP_TABLE = 273,
  G_DYN_STACKALLOC = 274,
  G_STACKSAVE = 275,
  G_STACKRESTORE = 276,
  G_STRICT_FADD = 277,
  G_STRICT_FSUB = 278,
  G_STRICT_FMUL = 279,
  G_STRICT_FDIV = 280,
  G_STRICT_FREM = 281,
  G_STRICT_FMA = 282,
  G_STRICT_FSQRT = 283,
  G_STRICT_FLDEXP = 284,
  G_READ_REGISTER = 285,
  G_WRITE_REGISTER = 286,
  G_MEMCPY = 287,
  G_MEMCPY_INLINE = 288,
  G_MEMMOVE = 289,
  G_MEMSET = 290,
  G_BZERO = 291,
  G_TRAP = 292,
  G_DEBUGTRAP = 293,
  G_UBSANTRAP = 294,
  G_VECREDUCE_SEQ_FADD = 295,
  G_VECREDUCE_SEQ_FMUL = 296,
  G_VECREDUCE_FADD = 297,
  G_VECREDUCE_FMUL = 298,
  G_VECREDUCE_FMAX = 299,
  G_VECREDUCE_FMIN = 300,
  G_VECREDUCE_FMAXIMUM = 301,
  G_VECREDUCE_FMINIMUM = 302,
  G_VECREDUCE_ADD = 303,
  G_VECREDUCE_MUL = 304,
  G_VECREDUCE_AND = 305,
  G_VECREDUCE_OR = 306,
  G_VECREDUCE_XOR = 307,
  G_VECREDUCE_SMAX = 308,
  G_VECREDUCE_SMIN = 309,
  G_VECREDUCE_UMAX = 310,
  G_VECREDUCE_UMIN = 311,
  G_SBFX = 312,
  G_UBFX = 313,
  ADJCALLSTACKDOWN = 314,
  ADJCALLSTACKUP = 315,
  FI_ri = 316,
  MEMCPY = 317,
  Select = 318,
  Select_32 = 319,
  Select_32_64 = 320,
  Select_64_32 = 321,
  Select_Ri = 322,
  Select_Ri_32 = 323,
  Select_Ri_32_64 = 324,
  Select_Ri_64_32 = 325,
  ADDR_SPACE_CAST = 326,
  ADD_ri = 327,
  ADD_ri_32 = 328,
  ADD_rr = 329,
  ADD_rr_32 = 330,
  AND_ri = 331,
  AND_ri_32 = 332,
  AND_rr = 333,
  AND_rr_32 = 334,
  BE16 = 335,
  BE32 = 336,
  BE64 = 337,
  BSWAP16 = 338,
  BSWAP32 = 339,
  BSWAP64 = 340,
  CMPXCHGD = 341,
  CMPXCHGW32 = 342,
  CORE_LD32 = 343,
  CORE_LD64 = 344,
  CORE_SHIFT = 345,
  CORE_ST = 346,
  DIV_ri = 347,
  DIV_ri_32 = 348,
  DIV_rr = 349,
  DIV_rr_32 = 350,
  JAL = 351,
  JALX = 352,
  JCOND = 353,
  JEQ_ri = 354,
  JEQ_ri_32 = 355,
  JEQ_rr = 356,
  JEQ_rr_32 = 357,
  JMP = 358,
  JMPL = 359,
  JNE_ri = 360,
  JNE_ri_32 = 361,
  JNE_rr = 362,
  JNE_rr_32 = 363,
  JSET_ri = 364,
  JSET_ri_32 = 365,
  JSET_rr = 366,
  JSET_rr_32 = 367,
  JSGE_ri = 368,
  JSGE_ri_32 = 369,
  JSGE_rr = 370,
  JSGE_rr_32 = 371,
  JSGT_ri = 372,
  JSGT_ri_32 = 373,
  JSGT_rr = 374,
  JSGT_rr_32 = 375,
  JSLE_ri = 376,
  JSLE_ri_32 = 377,
  JSLE_rr = 378,
  JSLE_rr_32 = 379,
  JSLT_ri = 380,
  JSLT_ri_32 = 381,
  JSLT_rr = 382,
  JSLT_rr_32 = 383,
  JUGE_ri = 384,
  JUGE_ri_32 = 385,
  JUGE_rr = 386,
  JUGE_rr_32 = 387,
  JUGT_ri = 388,
  JUGT_ri_32 = 389,
  JUGT_rr = 390,
  JUGT_rr_32 = 391,
  JULE_ri = 392,
  JULE_ri_32 = 393,
  JULE_rr = 394,
  JULE_rr_32 = 395,
  JULT_ri = 396,
  JULT_ri_32 = 397,
  JULT_rr = 398,
  JULT_rr_32 = 399,
  LDB = 400,
  LDB32 = 401,
  LDBACQ32 = 402,
  LDBSX = 403,
  LDD = 404,
  LDDACQ = 405,
  LDH = 406,
  LDH32 = 407,
  LDHACQ32 = 408,
  LDHSX = 409,
  LDW = 410,
  LDW32 = 411,
  LDWACQ32 = 412,
  LDWSX = 413,
  LD_ABS_B = 414,
  LD_ABS_H = 415,
  LD_ABS_W = 416,
  LD_IND_B = 417,
  LD_IND_H = 418,
  LD_IND_W = 419,
  LD_imm64 = 420,
  LD_pseudo = 421,
  LE16 = 422,
  LE32 = 423,
  LE64 = 424,
  MOD_ri = 425,
  MOD_ri_32 = 426,
  MOD_rr = 427,
  MOD_rr_32 = 428,
  MOVSX_rr_16 = 429,
  MOVSX_rr_32 = 430,
  MOVSX_rr_32_16 = 431,
  MOVSX_rr_32_8 = 432,
  MOVSX_rr_8 = 433,
  MOV_32_64 = 434,
  MOV_ri = 435,
  MOV_ri_32 = 436,
  MOV_rr = 437,
  MOV_rr_32 = 438,
  MUL_ri = 439,
  MUL_ri_32 = 440,
  MUL_rr = 441,
  MUL_rr_32 = 442,
  NEG_32 = 443,
  NEG_64 = 444,
  NOP = 445,
  OR_ri = 446,
  OR_ri_32 = 447,
  OR_rr = 448,
  OR_rr_32 = 449,
  RET = 450,
  SDIV_ri = 451,
  SDIV_ri_32 = 452,
  SDIV_rr = 453,
  SDIV_rr_32 = 454,
  SLL_ri = 455,
  SLL_ri_32 = 456,
  SLL_rr = 457,
  SLL_rr_32 = 458,
  SMOD_ri = 459,
  SMOD_ri_32 = 460,
  SMOD_rr = 461,
  SMOD_rr_32 = 462,
  SRA_ri = 463,
  SRA_ri_32 = 464,
  SRA_rr = 465,
  SRA_rr_32 = 466,
  SRL_ri = 467,
  SRL_ri_32 = 468,
  SRL_rr = 469,
  SRL_rr_32 = 470,
  STB = 471,
  STB32 = 472,
  STBREL32 = 473,
  STB_imm = 474,
  STD = 475,
  STDREL = 476,
  STD_imm = 477,
  STH = 478,
  STH32 = 479,
  STHREL32 = 480,
  STH_imm = 481,
  STW = 482,
  STW32 = 483,
  STWREL32 = 484,
  STW_imm = 485,
  SUB_ri = 486,
  SUB_ri_32 = 487,
  SUB_rr = 488,
  SUB_rr_32 = 489,
  XADDD = 490,
  XADDW = 491,
  XADDW32 = 492,
  XANDD = 493,
  XANDW32 = 494,
  XCHGD = 495,
  XCHGW32 = 496,
  XFADDD = 497,
  XFADDW32 = 498,
  XFANDD = 499,
  XFANDW32 = 500,
  XFORD = 501,
  XFORW32 = 502,
  XFXORD = 503,
  XFXORW32 = 504,
  XORD = 505,
  XORW32 = 506,
  XOR_ri = 507,
  XOR_ri_32 = 508,
  XOR_rr = 509,
  XOR_rr_32 = 510,
  XXORD = 511,
  XXORW32 = 512,
  INSTRUCTION_LIST_END = 513,
};
}
}
}
#endif
