// This file implements the IOleInPlaceUIWindow Interface and Gateway for Python.
// Generated by makegw.py

#include "axcontrol_pch.h"
#include "PyIOleWindow.h"
#include "PyIOleInPlaceUIWindow.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIOleInPlaceUIWindow::PyIOleInPlaceUIWindow(IUnknown *pdisp) : PyIOleWindow(pdisp) { ob_type = &type; }

PyIOleInPlaceUIWindow::~PyIOleInPlaceUIWindow() {}

/* static */ IOleInPlaceUIWindow *PyIOleInPlaceUIWindow::GetI(PyObject *self)
{
    return (IOleInPlaceUIWindow *)PyIOleWindow::GetI(self);
}

// @pymethod |PyIOleInPlaceUIWindow|GetBorder|Description of GetBorder.
PyObject *PyIOleInPlaceUIWindow::GetBorder(PyObject *self, PyObject *args)
{
    IOleInPlaceUIWindow *pIOIPUIW = GetI(self);
    if (pIOIPUIW == NULL)
        return NULL;
    if (!PyArg_ParseTuple(args, ":GetBorder"))
        return NULL;
    HRESULT hr;
    RECT r;
    PY_INTERFACE_PRECALL;
    hr = pIOIPUIW->GetBorder(&r);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIOIPUIW, IID_IOleInPlaceUIWindow);
    return Py_BuildValue("(iiii)", r.left, r.top, r.right, r.bottom);
}

// @pymethod |PyIOleInPlaceUIWindow|RequestBorderSpace|Description of RequestBorderSpace.
PyObject *PyIOleInPlaceUIWindow::RequestBorderSpace(PyObject *self, PyObject *args)
{
    IOleInPlaceUIWindow *pIOIPUIW = GetI(self);
    if (pIOIPUIW == NULL)
        return NULL;
    BORDERWIDTHS bw;
    // @pyparm (int, int, int, int)|borderwidths||Description for pborderwidths
    if (!PyArg_ParseTuple(args, "(iiii):RequestBorderSpace", &bw.left, &bw.top, &bw.right, &bw.bottom))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIOIPUIW->RequestBorderSpace(&bw);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIOIPUIW, IID_IOleInPlaceUIWindow);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIOleInPlaceUIWindow|SetBorderSpace|Description of SetBorderSpace.
PyObject *PyIOleInPlaceUIWindow::SetBorderSpace(PyObject *self, PyObject *args)
{
    IOleInPlaceUIWindow *pIOIPUIW = GetI(self);
    if (pIOIPUIW == NULL)
        return NULL;
    BORDERWIDTHS bw;
    // @pyparm (int, int, int, int)|borderwidths||Description for pborderwidths
    if (!PyArg_ParseTuple(args, "(iiii):SetBorderSpace", &bw.left, &bw.top, &bw.right, &bw.bottom))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIOIPUIW->SetBorderSpace(&bw);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIOIPUIW, IID_IOleInPlaceUIWindow);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIOleInPlaceUIWindow|SetActiveObject|Description of SetActiveObject.
PyObject *PyIOleInPlaceUIWindow::SetActiveObject(PyObject *self, PyObject *args)
{
    IOleInPlaceUIWindow *pIOIPUIW = GetI(self);
    if (pIOIPUIW == NULL)
        return NULL;
    // @pyparm <o PyIOleInPlaceActiveObject>|pActiveObject||Description for pActiveObject
    // @pyparm <o unicode>|pszObjName||Description for pszObjName
    PyObject *obpActiveObject;
    PyObject *obpszObjName;
    IOleInPlaceActiveObject *pActiveObject;
    LPOLESTR pszObjName;
    if (!PyArg_ParseTuple(args, "OO:SetActiveObject", &obpActiveObject, &obpszObjName))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (bPythonIsHappy && !PyCom_InterfaceFromPyInstanceOrObject(obpActiveObject, IID_IOleInPlaceActiveObject,
                                                                 (void **)&pActiveObject, TRUE /* bNoneOK */))
        bPythonIsHappy = FALSE;
    if (bPythonIsHappy && !PyWinObject_AsBstr(obpszObjName, &pszObjName))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIOIPUIW->SetActiveObject(pActiveObject, pszObjName);
    if (pActiveObject)
        pActiveObject->Release();
    SysFreeString(pszObjName);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIOIPUIW, IID_IOleInPlaceUIWindow);
    Py_INCREF(Py_None);
    return Py_None;
}

// @object PyIOleInPlaceUIWindow|Description of the interface
static struct PyMethodDef PyIOleInPlaceUIWindow_methods[] = {
    {"GetBorder", PyIOleInPlaceUIWindow::GetBorder, 1},  // @pymeth GetBorder|Description of GetBorder
    {"RequestBorderSpace", PyIOleInPlaceUIWindow::RequestBorderSpace,
     1},  // @pymeth RequestBorderSpace|Description of RequestBorderSpace
    {"SetBorderSpace", PyIOleInPlaceUIWindow::SetBorderSpace,
     1},  // @pymeth SetBorderSpace|Description of SetBorderSpace
    {"SetActiveObject", PyIOleInPlaceUIWindow::SetActiveObject,
     1},  // @pymeth SetActiveObject|Description of SetActiveObject
    {NULL}};

PyComTypeObject PyIOleInPlaceUIWindow::type("PyIOleInPlaceUIWindow", &PyIOleWindow::type, sizeof(PyIOleInPlaceUIWindow),
                                            PyIOleInPlaceUIWindow_methods, GET_PYCOM_CTOR(PyIOleInPlaceUIWindow));
// ---------------------------------------------------
//
// Gateway Implementation

// IOleWindow
STDMETHODIMP PyGOleInPlaceUIWindow::GetWindow(HWND __RPC_FAR *phwnd) { return PyGOleWindow::GetWindow(phwnd); }
STDMETHODIMP PyGOleInPlaceUIWindow::ContextSensitiveHelp(BOOL fEnterMode)
{
    return PyGOleWindow::ContextSensitiveHelp(fEnterMode);
}

// IOleInPlaceUIWindow
STDMETHODIMP PyGOleInPlaceUIWindow::GetBorder(
    /* [out] */ LPRECT lpr)
{
    PY_GATEWAY_METHOD;
    PyObject *result;
    HRESULT hr = InvokeViaPolicy("GetBorder", &result);
    if (FAILED(hr))
        return hr;
    // Process the Python results, and convert back to the real params
    if (!PyArg_ParseTuple(result, "(iiii)", &lpr->left, &lpr->top, &lpr->bottom, &lpr->right))
        hr = MAKE_PYCOM_GATEWAY_FAILURE_CODE("GetBorder");
    Py_DECREF(result);
    return hr;
}

STDMETHODIMP PyGOleInPlaceUIWindow::RequestBorderSpace(
    /* [unique][in] */ LPCBORDERWIDTHS pbw)
{
    PY_GATEWAY_METHOD;
    return InvokeViaPolicy("RequestBorderSpace", NULL, "(iiii)", pbw->left, pbw->top, pbw->right, pbw->bottom);
}

STDMETHODIMP PyGOleInPlaceUIWindow::SetBorderSpace(
    /* [unique][in] */ LPCBORDERWIDTHS pbw)
{
    PY_GATEWAY_METHOD;
    return InvokeViaPolicy("SetBorderSpace", NULL, "(iiii)", pbw->left, pbw->top, pbw->right, pbw->bottom);
}

STDMETHODIMP PyGOleInPlaceUIWindow::SetActiveObject(
    /* [unique][in] */ IOleInPlaceActiveObject *pActiveObject,
    /* [unique][string][in] */ LPCOLESTR pszObjName)
{
    PY_GATEWAY_METHOD;
    return InvokeViaPolicy("SetActiveObject", NULL, "NN",
                           PyCom_PyObjectFromIUnknown(pActiveObject, IID_IOleInPlaceActiveObject, TRUE),
                           MakeOLECHARToObj(pszObjName));
}
