import importlib
from types import ModuleType

import pytest
from sqlmodel import create_engine

from ....conftest import PrintMock, needs_py310


@pytest.fixture(
    name="mod",
    params=[
        pytest.param("tutorial001_py310", marks=needs_py310),
    ],
)
def get_module(request: pytest.FixtureRequest) -> ModuleType:
    mod = importlib.import_module(
        f"docs_src.tutorial.relationship_attributes.cascade_delete_relationships.{request.param}"
    )
    mod.sqlite_url = "sqlite://"
    mod.engine = create_engine(mod.sqlite_url)
    return mod


def test_tutorial(print_mock: PrintMock, mod: ModuleType):
    mod.main()
    assert print_mock.calls == [
        [
            "Created hero:",
            {
                "name": "Deadpond",
                "secret_name": "Dive Wilson",
                "team_id": 1,
                "id": 1,
                "age": None,
            },
        ],
        [
            "Created hero:",
            {
                "name": "Rusty-Man",
                "secret_name": "Tommy Sharp",
                "team_id": 2,
                "id": 2,
                "age": 48,
            },
        ],
        [
            "Created hero:",
            {
                "name": "Spider-Boy",
                "secret_name": "Pedro Parqueador",
                "team_id": None,
                "id": 3,
                "age": None,
            },
        ],
        [
            "Updated hero:",
            {
                "name": "Spider-Boy",
                "secret_name": "Pedro Parqueador",
                "team_id": 2,
                "id": 3,
                "age": None,
            },
        ],
        [
            "Team Wakaland:",
            {"name": "Wakaland", "id": 3, "headquarters": "Wakaland Capital City"},
        ],
        [
            "Deleted team:",
            {"name": "Wakaland", "id": 3, "headquarters": "Wakaland Capital City"},
        ],
        ["Black Lion not found:", None],
        ["Princess Sure-E not found:", None],
    ]
