"""Internal classes used by the gzip, lzma and bz2 modules"""

# _compression is replaced by compression._common._streams on Python 3.14+ (PEP-784)

from _typeshed import ReadableBuffer, WriteableBuffer
from collections.abc import Callable
from io import DEFAULT_BUFFER_SIZE, BufferedIOBase, RawIOBase
from typing import Any, Protocol, type_check_only

BUFFER_SIZE = DEFAULT_BUFFER_SIZE

@type_check_only
class _Reader(Protocol):
    def read(self, n: int, /) -> bytes: ...
    def seekable(self) -> bool: ...
    def seek(self, n: int, /) -> Any: ...

@type_check_only
class _Decompressor(Protocol):
    def decompress(self, data: ReadableBuffer, /, max_length: int = ...) -> bytes: ...
    @property
    def unused_data(self) -> bytes: ...
    @property
    def eof(self) -> bool: ...
    # `zlib._Decompress` does not have next property, but `DecompressReader` calls it:
    # @property
    # def needs_input(self) -> bool: ...

class BaseStream(BufferedIOBase):
    """Mode-checking helper functions."""

class DecompressReader(RawIOBase):
    """Adapts the decompressor API to a RawIOBase reader API"""

    def __init__(
        self,
        fp: _Reader,
        decomp_factory: Callable[..., _Decompressor],
        trailing_error: type[Exception] | tuple[type[Exception], ...] = (),
        **decomp_args: Any,  # These are passed to decomp_factory.
    ) -> None: ...
    def readinto(self, b: WriteableBuffer) -> int: ...
    def read(self, size: int = -1) -> bytes: ...
    def seek(self, offset: int, whence: int = 0) -> int: ...
