/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * This is a utility for extracting needed resource data from different language
 * version of the Mortevielle executable files into a new file mort.dat - this
 * is required for the ScummVM Mortevielle module to work properly
 */

#ifndef MENUDATA_H
#define MENUDATA_H

const char *menuDataEn =
	"   @@@                  "
	"    @                   "
	"   @  @ @@   @@@ @@@    "
	"   @   @  @   @   @     "
	"  @   @  @    @  @      "
	"  @   @  @    @ @       "
	"@@@ @@@ @@    @@        "
	"                        "
	"   @@   @@              "
	"   @@  @ @              "
	"  @ @ @ @   @@@  @@@ @@@"
	"  @  @  @  @   @  @   @ "
	" @     @  @    @  @  @  "
	" @     @  @   @   @ @   "
	"@@@   @@@ @@@@    @@    "
	"                        "
	"      @           @     "
	"     @@           @     "
	"    @ @    @@@@ @@@@    "
	"   @  @   @   @  @      "
	"  @@@@@  @      @       "
	" @    @  @   @  @       "
	"@@@ @@@   @@@   @@      "
	"                        "
	"    @@@@@       @@@  @@@"
	"   @    @        @  @  @"
	"  @       @@@   @   @   "
	"   @@@@  @   @  @  @@@  "
	"      @ @@@@@  @   @    "
	" @    @ @      @  @     "
	"@@@@@@  @@@  @@@ @@@    "
	"                        "
	"@@@@@@@       @@@ @@@   "
	"@  @  @        @   @    "
	"  @    @@@@   @   @   @@"
	"  @   @   @   @   @@ @  "
	" @   @   @   @   @  @@  "
	" @   @   @   @   @   @  "
	"@@@   @@@@  @@@ @@@  @@@"
	"                        "
	"   @@@@@@@  @   @@@     "
	"    @    @       @      "
	"   @  @   @@    @   @@@ "
	"   @@@@    @    @  @   @"
	"  @  @    @    @  @@@@@ "
	"  @       @    @  @     "
	"@@@     @@@  @@@  @@@   "
	"                        ";

const char *menuDataFr =
	"   @@@                  "
	"    @                   "
	"   @  @ @@   @@@ @@@    "
	"   @   @  @   @   @     "
	"  @   @  @    @  @      "
	"  @   @  @    @ @       "
	"@@@ @@@ @@    @@        "
	"                        "
	"  @@@@@     @@          "
	"   @   @   @            "
	"  @    @  @@@  @ @@@    "
	"  @    @ @   @  @   @   "
	" @    @  @@@@  @   @    "
	" @   @  @      @@@@     "
	"@@@@@   @@@   @         "
	"             @@@        "
	"      @           @     "
	"     @@           @     "
	"    @ @    @@@@ @@@@    "
	"   @  @   @   @  @      "
	"  @@@@@  @      @       "
	" @    @  @   @  @       "
	"@@@ @@@   @@@   @@      "
	"                        "
	"    @@@@@       @@@  @@@"
	"   @    @        @  @  @"
	"  @       @@@   @   @   "
	"   @@@@  @   @  @  @@@  "
	"      @ @@@@@  @   @    "
	" @    @ @      @  @     "
	"@@@@@@  @@@  @@@ @@@    "
	"                        "
	"  @@@@@    @            "
	"   @   @                "
	"  @    @ @@   @@@@      "
	"  @    @  @  @          "
	" @    @  @   @@@        "
	" @   @   @      @       "
	"@@@@@  @@@ @@@@@        "
	"                        "
	"   @@@@@@@  @           "
	"    @    @              "
	"   @  @   @@   @@@@     "
	"   @@@@    @  @   @     "
	"  @  @    @  @          "
	"  @       @  @   @      "
	"@@@     @@@   @@@       "
	"                        ";

const char *menuDataDe =
	"   @@@       @@         "
	"    @         @         "
	"   @  @ @@   @      @@@@"
	"   @   @  @  @@@   @   @"
	"  @   @  @  @  @  @   @ "
	"  @   @  @  @  @  @   @ "
	"@@@ @@@ @@ @@  @@  @@@@ "
	"                        "
	"  @@@@@@   @        @@  "
	"   @   @             @  "
	"  @   @  @@   @@@@  @   "
	"  @@@@    @  @   @  @@@ "
	" @ @     @  @      @  @ "
	" @  @    @  @   @  @  @ "
	"@@  @@ @@@   @@@  @@  @@"
	"                        "
	"      @    @@      @    "
	"    @@@     @      @    "
	"    @ @    @  @@ @@@@   "
	"   @  @    @ @    @     "
	"  @@@@@   @@@    @      "
	" @    @   @  @   @      "
	"@@@ @@@ @@@ @@   @@     "
	"                        "
	"    @@@         @@      "
	"     @           @      "
	"    @    @@@@   @       "
	"    @   @   @   @@@     "
	"   @   @       @  @     "
	"   @   @   @   @  @     "
	" @@@    @@@   @@  @@    "
	"                        "
	"  @@@@@@                "
	"   @   @        @@      "
	"  @   @  @@@     @  @@@ "
	"  @@@@  @   @ @@@@ @   @"
	" @ @   @@@@@ @  @  @@@@ "
	" @  @  @     @  @ @     "
	"@@  @@ @@@   @@@  @@@   "
	"                        "
	"  @@@@@            @    "
	"   @   @           @    "
	"  @    @   @@@@  @@@@   "
	"  @    @  @   @   @     "
	" @    @  @   @   @      "
	" @   @   @   @   @      "
	"@@@@@     @@@@   @@     "
	"                        ";

const int verbsFr[26] = { 0x301, 0x302, 0x303, 0x304, 0x305, 0x306, 0x307, 0x308,
						  0x309, 0x30a, 0x30b, 0x30c, 0x30d, 0x30e, 0x30f, 0x310,
						  0x311, 0x312, 0x313, 0x314, 0x315, 0x401, 0x402, 0x403,
						  0x404, 0x405 };

const int verbsEn[26] = { 0x301, 0x315, 0x305, 0x310, 0x309, 0x304, 0x302, 0x30f,
						  0x306, 0x30d, 0x30e, 0x303, 0x30c, 0x30b, 0x313, 0x30a,
						  0x311, 0x312, 0x307, 0x308, 0x314, 0x401, 0x405, 0x404,
						  0x403, 0x402 };

const int verbsDe[26] = { 0x304, 0x314, 0x307, 0x310, 0x315, 0x308, 0x311, 0x306,
						  0x30c, 0x301, 0x30d, 0x309, 0x312, 0x30f, 0x30e, 0x302,
						  0x30a, 0x313, 0x303, 0x30b, 0x305, 0x405, 0x402, 0x404,
						  0x403, 0x401 };
#endif
