// Auto-generated.
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

#include <algorithm>
#include <array>
#include <iterator>
#include <skyr/v1/domain/idna.hpp>

namespace skyr {
inline namespace v1 {
namespace idna {
namespace {
struct code_point_range {
  char32_t first;
  char32_t last;
  idna_status status;
};

constexpr static auto statuses = std::array<code_point_range, 1594>{{
  { U'\x0000', U'\x002c', idna_status::disallowed_std3_valid },
  { U'\x002f', U'\x002f', idna_status::disallowed_std3_valid },
  { U'\x003a', U'\x0040', idna_status::disallowed_std3_valid },
  { U'\x0041', U'\x005a', idna_status::mapped },
  { U'\x005b', U'\x0060', idna_status::disallowed_std3_valid },
  { U'\x007b', U'\x007f', idna_status::disallowed_std3_valid },
  { U'\x0080', U'\x009f', idna_status::disallowed },
  { U'\x00a0', U'\x00a0', idna_status::disallowed_std3_mapped },
  { U'\x00a8', U'\x00a8', idna_status::disallowed_std3_mapped },
  { U'\x00aa', U'\x00aa', idna_status::mapped },
  { U'\x00ad', U'\x00ad', idna_status::ignored },
  { U'\x00af', U'\x00af', idna_status::disallowed_std3_mapped },
  { U'\x00b2', U'\x00b3', idna_status::mapped },
  { U'\x00b4', U'\x00b4', idna_status::disallowed_std3_mapped },
  { U'\x00b5', U'\x00b5', idna_status::mapped },
  { U'\x00b8', U'\x00b8', idna_status::disallowed_std3_mapped },
  { U'\x00b9', U'\x00ba', idna_status::mapped },
  { U'\x00bc', U'\x00be', idna_status::mapped },
  { U'\x00c0', U'\x00d6', idna_status::mapped },
  { U'\x00d8', U'\x00de', idna_status::mapped },
  { U'\x00df', U'\x00df', idna_status::deviation },
  { U'\x0100', U'\x0100', idna_status::mapped },
  { U'\x0102', U'\x0102', idna_status::mapped },
  { U'\x0104', U'\x0104', idna_status::mapped },
  { U'\x0106', U'\x0106', idna_status::mapped },
  { U'\x0108', U'\x0108', idna_status::mapped },
  { U'\x010a', U'\x010a', idna_status::mapped },
  { U'\x010c', U'\x010c', idna_status::mapped },
  { U'\x010e', U'\x010e', idna_status::mapped },
  { U'\x0110', U'\x0110', idna_status::mapped },
  { U'\x0112', U'\x0112', idna_status::mapped },
  { U'\x0114', U'\x0114', idna_status::mapped },
  { U'\x0116', U'\x0116', idna_status::mapped },
  { U'\x0118', U'\x0118', idna_status::mapped },
  { U'\x011a', U'\x011a', idna_status::mapped },
  { U'\x011c', U'\x011c', idna_status::mapped },
  { U'\x011e', U'\x011e', idna_status::mapped },
  { U'\x0120', U'\x0120', idna_status::mapped },
  { U'\x0122', U'\x0122', idna_status::mapped },
  { U'\x0124', U'\x0124', idna_status::mapped },
  { U'\x0126', U'\x0126', idna_status::mapped },
  { U'\x0128', U'\x0128', idna_status::mapped },
  { U'\x012a', U'\x012a', idna_status::mapped },
  { U'\x012c', U'\x012c', idna_status::mapped },
  { U'\x012e', U'\x012e', idna_status::mapped },
  { U'\x0130', U'\x0130', idna_status::mapped },
  { U'\x0132', U'\x0134', idna_status::mapped },
  { U'\x0136', U'\x0136', idna_status::mapped },
  { U'\x0139', U'\x0139', idna_status::mapped },
  { U'\x013b', U'\x013b', idna_status::mapped },
  { U'\x013d', U'\x013d', idna_status::mapped },
  { U'\x013f', U'\x0141', idna_status::mapped },
  { U'\x0143', U'\x0143', idna_status::mapped },
  { U'\x0145', U'\x0145', idna_status::mapped },
  { U'\x0147', U'\x0147', idna_status::mapped },
  { U'\x0149', U'\x014a', idna_status::mapped },
  { U'\x014c', U'\x014c', idna_status::mapped },
  { U'\x014e', U'\x014e', idna_status::mapped },
  { U'\x0150', U'\x0150', idna_status::mapped },
  { U'\x0152', U'\x0152', idna_status::mapped },
  { U'\x0154', U'\x0154', idna_status::mapped },
  { U'\x0156', U'\x0156', idna_status::mapped },
  { U'\x0158', U'\x0158', idna_status::mapped },
  { U'\x015a', U'\x015a', idna_status::mapped },
  { U'\x015c', U'\x015c', idna_status::mapped },
  { U'\x015e', U'\x015e', idna_status::mapped },
  { U'\x0160', U'\x0160', idna_status::mapped },
  { U'\x0162', U'\x0162', idna_status::mapped },
  { U'\x0164', U'\x0164', idna_status::mapped },
  { U'\x0166', U'\x0166', idna_status::mapped },
  { U'\x0168', U'\x0168', idna_status::mapped },
  { U'\x016a', U'\x016a', idna_status::mapped },
  { U'\x016c', U'\x016c', idna_status::mapped },
  { U'\x016e', U'\x016e', idna_status::mapped },
  { U'\x0170', U'\x0170', idna_status::mapped },
  { U'\x0172', U'\x0172', idna_status::mapped },
  { U'\x0174', U'\x0174', idna_status::mapped },
  { U'\x0176', U'\x0176', idna_status::mapped },
  { U'\x0178', U'\x0179', idna_status::mapped },
  { U'\x017b', U'\x017b', idna_status::mapped },
  { U'\x017d', U'\x017d', idna_status::mapped },
  { U'\x017f', U'\x017f', idna_status::mapped },
  { U'\x0181', U'\x0182', idna_status::mapped },
  { U'\x0184', U'\x0184', idna_status::mapped },
  { U'\x0186', U'\x0187', idna_status::mapped },
  { U'\x0189', U'\x018b', idna_status::mapped },
  { U'\x018e', U'\x0191', idna_status::mapped },
  { U'\x0193', U'\x0194', idna_status::mapped },
  { U'\x0196', U'\x0198', idna_status::mapped },
  { U'\x019c', U'\x019d', idna_status::mapped },
  { U'\x019f', U'\x01a0', idna_status::mapped },
  { U'\x01a2', U'\x01a2', idna_status::mapped },
  { U'\x01a4', U'\x01a4', idna_status::mapped },
  { U'\x01a6', U'\x01a7', idna_status::mapped },
  { U'\x01a9', U'\x01a9', idna_status::mapped },
  { U'\x01ac', U'\x01ac', idna_status::mapped },
  { U'\x01ae', U'\x01af', idna_status::mapped },
  { U'\x01b1', U'\x01b3', idna_status::mapped },
  { U'\x01b5', U'\x01b5', idna_status::mapped },
  { U'\x01b7', U'\x01b8', idna_status::mapped },
  { U'\x01bc', U'\x01bc', idna_status::mapped },
  { U'\x01c4', U'\x01cd', idna_status::mapped },
  { U'\x01cf', U'\x01cf', idna_status::mapped },
  { U'\x01d1', U'\x01d1', idna_status::mapped },
  { U'\x01d3', U'\x01d3', idna_status::mapped },
  { U'\x01d5', U'\x01d5', idna_status::mapped },
  { U'\x01d7', U'\x01d7', idna_status::mapped },
  { U'\x01d9', U'\x01d9', idna_status::mapped },
  { U'\x01db', U'\x01db', idna_status::mapped },
  { U'\x01de', U'\x01de', idna_status::mapped },
  { U'\x01e0', U'\x01e0', idna_status::mapped },
  { U'\x01e2', U'\x01e2', idna_status::mapped },
  { U'\x01e4', U'\x01e4', idna_status::mapped },
  { U'\x01e6', U'\x01e6', idna_status::mapped },
  { U'\x01e8', U'\x01e8', idna_status::mapped },
  { U'\x01ea', U'\x01ea', idna_status::mapped },
  { U'\x01ec', U'\x01ec', idna_status::mapped },
  { U'\x01ee', U'\x01ee', idna_status::mapped },
  { U'\x01f1', U'\x01f4', idna_status::mapped },
  { U'\x01f6', U'\x01f8', idna_status::mapped },
  { U'\x01fa', U'\x01fa', idna_status::mapped },
  { U'\x01fc', U'\x01fc', idna_status::mapped },
  { U'\x01fe', U'\x01fe', idna_status::mapped },
  { U'\x0200', U'\x0200', idna_status::mapped },
  { U'\x0202', U'\x0202', idna_status::mapped },
  { U'\x0204', U'\x0204', idna_status::mapped },
  { U'\x0206', U'\x0206', idna_status::mapped },
  { U'\x0208', U'\x0208', idna_status::mapped },
  { U'\x020a', U'\x020a', idna_status::mapped },
  { U'\x020c', U'\x020c', idna_status::mapped },
  { U'\x020e', U'\x020e', idna_status::mapped },
  { U'\x0210', U'\x0210', idna_status::mapped },
  { U'\x0212', U'\x0212', idna_status::mapped },
  { U'\x0214', U'\x0214', idna_status::mapped },
  { U'\x0216', U'\x0216', idna_status::mapped },
  { U'\x0218', U'\x0218', idna_status::mapped },
  { U'\x021a', U'\x021a', idna_status::mapped },
  { U'\x021c', U'\x021c', idna_status::mapped },
  { U'\x021e', U'\x021e', idna_status::mapped },
  { U'\x0220', U'\x0220', idna_status::mapped },
  { U'\x0222', U'\x0222', idna_status::mapped },
  { U'\x0224', U'\x0224', idna_status::mapped },
  { U'\x0226', U'\x0226', idna_status::mapped },
  { U'\x0228', U'\x0228', idna_status::mapped },
  { U'\x022a', U'\x022a', idna_status::mapped },
  { U'\x022c', U'\x022c', idna_status::mapped },
  { U'\x022e', U'\x022e', idna_status::mapped },
  { U'\x0230', U'\x0230', idna_status::mapped },
  { U'\x0232', U'\x0232', idna_status::mapped },
  { U'\x023a', U'\x023b', idna_status::mapped },
  { U'\x023d', U'\x023e', idna_status::mapped },
  { U'\x0241', U'\x0241', idna_status::mapped },
  { U'\x0243', U'\x0246', idna_status::mapped },
  { U'\x0248', U'\x0248', idna_status::mapped },
  { U'\x024a', U'\x024a', idna_status::mapped },
  { U'\x024c', U'\x024c', idna_status::mapped },
  { U'\x024e', U'\x024e', idna_status::mapped },
  { U'\x02b0', U'\x02b8', idna_status::mapped },
  { U'\x02d8', U'\x02dd', idna_status::disallowed_std3_mapped },
  { U'\x02e0', U'\x02e4', idna_status::mapped },
  { U'\x0340', U'\x0341', idna_status::mapped },
  { U'\x0343', U'\x0345', idna_status::mapped },
  { U'\x034f', U'\x034f', idna_status::ignored },
  { U'\x0370', U'\x0370', idna_status::mapped },
  { U'\x0372', U'\x0372', idna_status::mapped },
  { U'\x0374', U'\x0374', idna_status::mapped },
  { U'\x0376', U'\x0376', idna_status::mapped },
  { U'\x0378', U'\x0379', idna_status::disallowed },
  { U'\x037a', U'\x037a', idna_status::disallowed_std3_mapped },
  { U'\x037e', U'\x037e', idna_status::disallowed_std3_mapped },
  { U'\x037f', U'\x037f', idna_status::mapped },
  { U'\x0380', U'\x0383', idna_status::disallowed },
  { U'\x0384', U'\x0385', idna_status::disallowed_std3_mapped },
  { U'\x0386', U'\x038a', idna_status::mapped },
  { U'\x038b', U'\x038b', idna_status::disallowed },
  { U'\x038c', U'\x038c', idna_status::mapped },
  { U'\x038d', U'\x038d', idna_status::disallowed },
  { U'\x038e', U'\x038f', idna_status::mapped },
  { U'\x0391', U'\x03a1', idna_status::mapped },
  { U'\x03a2', U'\x03a2', idna_status::disallowed },
  { U'\x03a3', U'\x03ab', idna_status::mapped },
  { U'\x03c2', U'\x03c2', idna_status::deviation },
  { U'\x03cf', U'\x03d6', idna_status::mapped },
  { U'\x03d8', U'\x03d8', idna_status::mapped },
  { U'\x03da', U'\x03da', idna_status::mapped },
  { U'\x03dc', U'\x03dc', idna_status::mapped },
  { U'\x03de', U'\x03de', idna_status::mapped },
  { U'\x03e0', U'\x03e0', idna_status::mapped },
  { U'\x03e2', U'\x03e2', idna_status::mapped },
  { U'\x03e4', U'\x03e4', idna_status::mapped },
  { U'\x03e6', U'\x03e6', idna_status::mapped },
  { U'\x03e8', U'\x03e8', idna_status::mapped },
  { U'\x03ea', U'\x03ea', idna_status::mapped },
  { U'\x03ec', U'\x03ec', idna_status::mapped },
  { U'\x03ee', U'\x03ee', idna_status::mapped },
  { U'\x03f0', U'\x03f2', idna_status::mapped },
  { U'\x03f4', U'\x03f5', idna_status::mapped },
  { U'\x03f7', U'\x03f7', idna_status::mapped },
  { U'\x03f9', U'\x03fa', idna_status::mapped },
  { U'\x03fd', U'\x042f', idna_status::mapped },
  { U'\x0460', U'\x0460', idna_status::mapped },
  { U'\x0462', U'\x0462', idna_status::mapped },
  { U'\x0464', U'\x0464', idna_status::mapped },
  { U'\x0466', U'\x0466', idna_status::mapped },
  { U'\x0468', U'\x0468', idna_status::mapped },
  { U'\x046a', U'\x046a', idna_status::mapped },
  { U'\x046c', U'\x046c', idna_status::mapped },
  { U'\x046e', U'\x046e', idna_status::mapped },
  { U'\x0470', U'\x0470', idna_status::mapped },
  { U'\x0472', U'\x0472', idna_status::mapped },
  { U'\x0474', U'\x0474', idna_status::mapped },
  { U'\x0476', U'\x0476', idna_status::mapped },
  { U'\x0478', U'\x0478', idna_status::mapped },
  { U'\x047a', U'\x047a', idna_status::mapped },
  { U'\x047c', U'\x047c', idna_status::mapped },
  { U'\x047e', U'\x047e', idna_status::mapped },
  { U'\x0480', U'\x0480', idna_status::mapped },
  { U'\x048a', U'\x048a', idna_status::mapped },
  { U'\x048c', U'\x048c', idna_status::mapped },
  { U'\x048e', U'\x048e', idna_status::mapped },
  { U'\x0490', U'\x0490', idna_status::mapped },
  { U'\x0492', U'\x0492', idna_status::mapped },
  { U'\x0494', U'\x0494', idna_status::mapped },
  { U'\x0496', U'\x0496', idna_status::mapped },
  { U'\x0498', U'\x0498', idna_status::mapped },
  { U'\x049a', U'\x049a', idna_status::mapped },
  { U'\x049c', U'\x049c', idna_status::mapped },
  { U'\x049e', U'\x049e', idna_status::mapped },
  { U'\x04a0', U'\x04a0', idna_status::mapped },
  { U'\x04a2', U'\x04a2', idna_status::mapped },
  { U'\x04a4', U'\x04a4', idna_status::mapped },
  { U'\x04a6', U'\x04a6', idna_status::mapped },
  { U'\x04a8', U'\x04a8', idna_status::mapped },
  { U'\x04aa', U'\x04aa', idna_status::mapped },
  { U'\x04ac', U'\x04ac', idna_status::mapped },
  { U'\x04ae', U'\x04ae', idna_status::mapped },
  { U'\x04b0', U'\x04b0', idna_status::mapped },
  { U'\x04b2', U'\x04b2', idna_status::mapped },
  { U'\x04b4', U'\x04b4', idna_status::mapped },
  { U'\x04b6', U'\x04b6', idna_status::mapped },
  { U'\x04b8', U'\x04b8', idna_status::mapped },
  { U'\x04ba', U'\x04ba', idna_status::mapped },
  { U'\x04bc', U'\x04bc', idna_status::mapped },
  { U'\x04be', U'\x04be', idna_status::mapped },
  { U'\x04c0', U'\x04c0', idna_status::disallowed },
  { U'\x04c1', U'\x04c1', idna_status::mapped },
  { U'\x04c3', U'\x04c3', idna_status::mapped },
  { U'\x04c5', U'\x04c5', idna_status::mapped },
  { U'\x04c7', U'\x04c7', idna_status::mapped },
  { U'\x04c9', U'\x04c9', idna_status::mapped },
  { U'\x04cb', U'\x04cb', idna_status::mapped },
  { U'\x04cd', U'\x04cd', idna_status::mapped },
  { U'\x04d0', U'\x04d0', idna_status::mapped },
  { U'\x04d2', U'\x04d2', idna_status::mapped },
  { U'\x04d4', U'\x04d4', idna_status::mapped },
  { U'\x04d6', U'\x04d6', idna_status::mapped },
  { U'\x04d8', U'\x04d8', idna_status::mapped },
  { U'\x04da', U'\x04da', idna_status::mapped },
  { U'\x04dc', U'\x04dc', idna_status::mapped },
  { U'\x04de', U'\x04de', idna_status::mapped },
  { U'\x04e0', U'\x04e0', idna_status::mapped },
  { U'\x04e2', U'\x04e2', idna_status::mapped },
  { U'\x04e4', U'\x04e4', idna_status::mapped },
  { U'\x04e6', U'\x04e6', idna_status::mapped },
  { U'\x04e8', U'\x04e8', idna_status::mapped },
  { U'\x04ea', U'\x04ea', idna_status::mapped },
  { U'\x04ec', U'\x04ec', idna_status::mapped },
  { U'\x04ee', U'\x04ee', idna_status::mapped },
  { U'\x04f0', U'\x04f0', idna_status::mapped },
  { U'\x04f2', U'\x04f2', idna_status::mapped },
  { U'\x04f4', U'\x04f4', idna_status::mapped },
  { U'\x04f6', U'\x04f6', idna_status::mapped },
  { U'\x04f8', U'\x04f8', idna_status::mapped },
  { U'\x04fa', U'\x04fa', idna_status::mapped },
  { U'\x04fc', U'\x04fc', idna_status::mapped },
  { U'\x04fe', U'\x04fe', idna_status::mapped },
  { U'\x0500', U'\x0500', idna_status::mapped },
  { U'\x0502', U'\x0502', idna_status::mapped },
  { U'\x0504', U'\x0504', idna_status::mapped },
  { U'\x0506', U'\x0506', idna_status::mapped },
  { U'\x0508', U'\x0508', idna_status::mapped },
  { U'\x050a', U'\x050a', idna_status::mapped },
  { U'\x050c', U'\x050c', idna_status::mapped },
  { U'\x050e', U'\x050e', idna_status::mapped },
  { U'\x0510', U'\x0510', idna_status::mapped },
  { U'\x0512', U'\x0512', idna_status::mapped },
  { U'\x0514', U'\x0514', idna_status::mapped },
  { U'\x0516', U'\x0516', idna_status::mapped },
  { U'\x0518', U'\x0518', idna_status::mapped },
  { U'\x051a', U'\x051a', idna_status::mapped },
  { U'\x051c', U'\x051c', idna_status::mapped },
  { U'\x051e', U'\x051e', idna_status::mapped },
  { U'\x0520', U'\x0520', idna_status::mapped },
  { U'\x0522', U'\x0522', idna_status::mapped },
  { U'\x0524', U'\x0524', idna_status::mapped },
  { U'\x0526', U'\x0526', idna_status::mapped },
  { U'\x0528', U'\x0528', idna_status::mapped },
  { U'\x052a', U'\x052a', idna_status::mapped },
  { U'\x052c', U'\x052c', idna_status::mapped },
  { U'\x052e', U'\x052e', idna_status::mapped },
  { U'\x0530', U'\x0530', idna_status::disallowed },
  { U'\x0531', U'\x0556', idna_status::mapped },
  { U'\x0557', U'\x0558', idna_status::disallowed },
  { U'\x0587', U'\x0587', idna_status::mapped },
  { U'\x058b', U'\x058c', idna_status::disallowed },
  { U'\x0590', U'\x0590', idna_status::disallowed },
  { U'\x05c8', U'\x05cf', idna_status::disallowed },
  { U'\x05eb', U'\x05ee', idna_status::disallowed },
  { U'\x05f5', U'\x0605', idna_status::disallowed },
  { U'\x061c', U'\x061d', idna_status::disallowed },
  { U'\x0675', U'\x0678', idna_status::mapped },
  { U'\x06dd', U'\x06dd', idna_status::disallowed },
  { U'\x070e', U'\x070f', idna_status::disallowed },
  { U'\x074b', U'\x074c', idna_status::disallowed },
  { U'\x07b2', U'\x07bf', idna_status::disallowed },
  { U'\x07fb', U'\x07fc', idna_status::disallowed },
  { U'\x082e', U'\x082f', idna_status::disallowed },
  { U'\x083f', U'\x083f', idna_status::disallowed },
  { U'\x085c', U'\x085d', idna_status::disallowed },
  { U'\x085f', U'\x085f', idna_status::disallowed },
  { U'\x086b', U'\x089f', idna_status::disallowed },
  { U'\x08b5', U'\x08b5', idna_status::disallowed },
  { U'\x08be', U'\x08d2', idna_status::disallowed },
  { U'\x08e2', U'\x08e2', idna_status::disallowed },
  { U'\x0958', U'\x095f', idna_status::mapped },
  { U'\x0984', U'\x0984', idna_status::disallowed },
  { U'\x098d', U'\x098e', idna_status::disallowed },
  { U'\x0991', U'\x0992', idna_status::disallowed },
  { U'\x09a9', U'\x09a9', idna_status::disallowed },
  { U'\x09b1', U'\x09b1', idna_status::disallowed },
  { U'\x09b3', U'\x09b5', idna_status::disallowed },
  { U'\x09ba', U'\x09bb', idna_status::disallowed },
  { U'\x09c5', U'\x09c6', idna_status::disallowed },
  { U'\x09c9', U'\x09ca', idna_status::disallowed },
  { U'\x09cf', U'\x09d6', idna_status::disallowed },
  { U'\x09d8', U'\x09db', idna_status::disallowed },
  { U'\x09dc', U'\x09dd', idna_status::mapped },
  { U'\x09de', U'\x09de', idna_status::disallowed },
  { U'\x09df', U'\x09df', idna_status::mapped },
  { U'\x09e4', U'\x09e5', idna_status::disallowed },
  { U'\x09ff', U'\x0a00', idna_status::disallowed },
  { U'\x0a04', U'\x0a04', idna_status::disallowed },
  { U'\x0a0b', U'\x0a0e', idna_status::disallowed },
  { U'\x0a11', U'\x0a12', idna_status::disallowed },
  { U'\x0a29', U'\x0a29', idna_status::disallowed },
  { U'\x0a31', U'\x0a31', idna_status::disallowed },
  { U'\x0a33', U'\x0a33', idna_status::mapped },
  { U'\x0a34', U'\x0a34', idna_status::disallowed },
  { U'\x0a36', U'\x0a36', idna_status::mapped },
  { U'\x0a37', U'\x0a37', idna_status::disallowed },
  { U'\x0a3a', U'\x0a3b', idna_status::disallowed },
  { U'\x0a3d', U'\x0a3d', idna_status::disallowed },
  { U'\x0a43', U'\x0a46', idna_status::disallowed },
  { U'\x0a49', U'\x0a4a', idna_status::disallowed },
  { U'\x0a4e', U'\x0a50', idna_status::disallowed },
  { U'\x0a52', U'\x0a58', idna_status::disallowed },
  { U'\x0a59', U'\x0a5b', idna_status::mapped },
  { U'\x0a5d', U'\x0a5d', idna_status::disallowed },
  { U'\x0a5e', U'\x0a5e', idna_status::mapped },
  { U'\x0a5f', U'\x0a65', idna_status::disallowed },
  { U'\x0a77', U'\x0a80', idna_status::disallowed },
  { U'\x0a84', U'\x0a84', idna_status::disallowed },
  { U'\x0a8e', U'\x0a8e', idna_status::disallowed },
  { U'\x0a92', U'\x0a92', idna_status::disallowed },
  { U'\x0aa9', U'\x0aa9', idna_status::disallowed },
  { U'\x0ab1', U'\x0ab1', idna_status::disallowed },
  { U'\x0ab4', U'\x0ab4', idna_status::disallowed },
  { U'\x0aba', U'\x0abb', idna_status::disallowed },
  { U'\x0ac6', U'\x0ac6', idna_status::disallowed },
  { U'\x0aca', U'\x0aca', idna_status::disallowed },
  { U'\x0ace', U'\x0acf', idna_status::disallowed },
  { U'\x0ad1', U'\x0adf', idna_status::disallowed },
  { U'\x0ae4', U'\x0ae5', idna_status::disallowed },
  { U'\x0af2', U'\x0af8', idna_status::disallowed },
  { U'\x0b00', U'\x0b00', idna_status::disallowed },
  { U'\x0b04', U'\x0b04', idna_status::disallowed },
  { U'\x0b0d', U'\x0b0e', idna_status::disallowed },
  { U'\x0b11', U'\x0b12', idna_status::disallowed },
  { U'\x0b29', U'\x0b29', idna_status::disallowed },
  { U'\x0b31', U'\x0b31', idna_status::disallowed },
  { U'\x0b34', U'\x0b34', idna_status::disallowed },
  { U'\x0b3a', U'\x0b3b', idna_status::disallowed },
  { U'\x0b45', U'\x0b46', idna_status::disallowed },
  { U'\x0b49', U'\x0b4a', idna_status::disallowed },
  { U'\x0b4e', U'\x0b55', idna_status::disallowed },
  { U'\x0b58', U'\x0b5b', idna_status::disallowed },
  { U'\x0b5c', U'\x0b5d', idna_status::mapped },
  { U'\x0b5e', U'\x0b5e', idna_status::disallowed },
  { U'\x0b64', U'\x0b65', idna_status::disallowed },
  { U'\x0b78', U'\x0b81', idna_status::disallowed },
  { U'\x0b84', U'\x0b84', idna_status::disallowed },
  { U'\x0b8b', U'\x0b8d', idna_status::disallowed },
  { U'\x0b91', U'\x0b91', idna_status::disallowed },
  { U'\x0b96', U'\x0b98', idna_status::disallowed },
  { U'\x0b9b', U'\x0b9b', idna_status::disallowed },
  { U'\x0b9d', U'\x0b9d', idna_status::disallowed },
  { U'\x0ba0', U'\x0ba2', idna_status::disallowed },
  { U'\x0ba5', U'\x0ba7', idna_status::disallowed },
  { U'\x0bab', U'\x0bad', idna_status::disallowed },
  { U'\x0bba', U'\x0bbd', idna_status::disallowed },
  { U'\x0bc3', U'\x0bc5', idna_status::disallowed },
  { U'\x0bc9', U'\x0bc9', idna_status::disallowed },
  { U'\x0bce', U'\x0bcf', idna_status::disallowed },
  { U'\x0bd1', U'\x0bd6', idna_status::disallowed },
  { U'\x0bd8', U'\x0be5', idna_status::disallowed },
  { U'\x0bfb', U'\x0bff', idna_status::disallowed },
  { U'\x0c0d', U'\x0c0d', idna_status::disallowed },
  { U'\x0c11', U'\x0c11', idna_status::disallowed },
  { U'\x0c29', U'\x0c29', idna_status::disallowed },
  { U'\x0c3a', U'\x0c3c', idna_status::disallowed },
  { U'\x0c45', U'\x0c45', idna_status::disallowed },
  { U'\x0c49', U'\x0c49', idna_status::disallowed },
  { U'\x0c4e', U'\x0c54', idna_status::disallowed },
  { U'\x0c57', U'\x0c57', idna_status::disallowed },
  { U'\x0c5b', U'\x0c5f', idna_status::disallowed },
  { U'\x0c64', U'\x0c65', idna_status::disallowed },
  { U'\x0c70', U'\x0c76', idna_status::disallowed },
  { U'\x0c8d', U'\x0c8d', idna_status::disallowed },
  { U'\x0c91', U'\x0c91', idna_status::disallowed },
  { U'\x0ca9', U'\x0ca9', idna_status::disallowed },
  { U'\x0cb4', U'\x0cb4', idna_status::disallowed },
  { U'\x0cba', U'\x0cbb', idna_status::disallowed },
  { U'\x0cc5', U'\x0cc5', idna_status::disallowed },
  { U'\x0cc9', U'\x0cc9', idna_status::disallowed },
  { U'\x0cce', U'\x0cd4', idna_status::disallowed },
  { U'\x0cd7', U'\x0cdd', idna_status::disallowed },
  { U'\x0cdf', U'\x0cdf', idna_status::disallowed },
  { U'\x0ce4', U'\x0ce5', idna_status::disallowed },
  { U'\x0cf0', U'\x0cf0', idna_status::disallowed },
  { U'\x0cf3', U'\x0cff', idna_status::disallowed },
  { U'\x0d04', U'\x0d04', idna_status::disallowed },
  { U'\x0d0d', U'\x0d0d', idna_status::disallowed },
  { U'\x0d11', U'\x0d11', idna_status::disallowed },
  { U'\x0d45', U'\x0d45', idna_status::disallowed },
  { U'\x0d49', U'\x0d49', idna_status::disallowed },
  { U'\x0d50', U'\x0d53', idna_status::disallowed },
  { U'\x0d64', U'\x0d65', idna_status::disallowed },
  { U'\x0d80', U'\x0d81', idna_status::disallowed },
  { U'\x0d84', U'\x0d84', idna_status::disallowed },
  { U'\x0d97', U'\x0d99', idna_status::disallowed },
  { U'\x0db2', U'\x0db2', idna_status::disallowed },
  { U'\x0dbc', U'\x0dbc', idna_status::disallowed },
  { U'\x0dbe', U'\x0dbf', idna_status::disallowed },
  { U'\x0dc7', U'\x0dc9', idna_status::disallowed },
  { U'\x0dcb', U'\x0dce', idna_status::disallowed },
  { U'\x0dd5', U'\x0dd5', idna_status::disallowed },
  { U'\x0dd7', U'\x0dd7', idna_status::disallowed },
  { U'\x0de0', U'\x0de5', idna_status::disallowed },
  { U'\x0df0', U'\x0df1', idna_status::disallowed },
  { U'\x0df5', U'\x0e00', idna_status::disallowed },
  { U'\x0e33', U'\x0e33', idna_status::mapped },
  { U'\x0e3b', U'\x0e3e', idna_status::disallowed },
  { U'\x0e5c', U'\x0e80', idna_status::disallowed },
  { U'\x0e83', U'\x0e83', idna_status::disallowed },
  { U'\x0e85', U'\x0e85', idna_status::disallowed },
  { U'\x0e8b', U'\x0e8b', idna_status::disallowed },
  { U'\x0ea4', U'\x0ea4', idna_status::disallowed },
  { U'\x0ea6', U'\x0ea6', idna_status::disallowed },
  { U'\x0eb3', U'\x0eb3', idna_status::mapped },
  { U'\x0ebe', U'\x0ebf', idna_status::disallowed },
  { U'\x0ec5', U'\x0ec5', idna_status::disallowed },
  { U'\x0ec7', U'\x0ec7', idna_status::disallowed },
  { U'\x0ece', U'\x0ecf', idna_status::disallowed },
  { U'\x0eda', U'\x0edb', idna_status::disallowed },
  { U'\x0edc', U'\x0edd', idna_status::mapped },
  { U'\x0ee0', U'\x0eff', idna_status::disallowed },
  { U'\x0f0c', U'\x0f0c', idna_status::mapped },
  { U'\x0f43', U'\x0f43', idna_status::mapped },
  { U'\x0f48', U'\x0f48', idna_status::disallowed },
  { U'\x0f4d', U'\x0f4d', idna_status::mapped },
  { U'\x0f52', U'\x0f52', idna_status::mapped },
  { U'\x0f57', U'\x0f57', idna_status::mapped },
  { U'\x0f5c', U'\x0f5c', idna_status::mapped },
  { U'\x0f69', U'\x0f69', idna_status::mapped },
  { U'\x0f6d', U'\x0f70', idna_status::disallowed },
  { U'\x0f73', U'\x0f73', idna_status::mapped },
  { U'\x0f75', U'\x0f79', idna_status::mapped },
  { U'\x0f81', U'\x0f81', idna_status::mapped },
  { U'\x0f93', U'\x0f93', idna_status::mapped },
  { U'\x0f98', U'\x0f98', idna_status::disallowed },
  { U'\x0f9d', U'\x0f9d', idna_status::mapped },
  { U'\x0fa2', U'\x0fa2', idna_status::mapped },
  { U'\x0fa7', U'\x0fa7', idna_status::mapped },
  { U'\x0fac', U'\x0fac', idna_status::mapped },
  { U'\x0fb9', U'\x0fb9', idna_status::mapped },
  { U'\x0fbd', U'\x0fbd', idna_status::disallowed },
  { U'\x0fcd', U'\x0fcd', idna_status::disallowed },
  { U'\x0fdb', U'\x0fff', idna_status::disallowed },
  { U'\x10a0', U'\x10c6', idna_status::disallowed },
  { U'\x10c7', U'\x10c7', idna_status::mapped },
  { U'\x10c8', U'\x10cc', idna_status::disallowed },
  { U'\x10cd', U'\x10cd', idna_status::mapped },
  { U'\x10ce', U'\x10cf', idna_status::disallowed },
  { U'\x10fc', U'\x10fc', idna_status::mapped },
  { U'\x115f', U'\x1160', idna_status::disallowed },
  { U'\x1249', U'\x1249', idna_status::disallowed },
  { U'\x124e', U'\x124f', idna_status::disallowed },
  { U'\x1257', U'\x1257', idna_status::disallowed },
  { U'\x1259', U'\x1259', idna_status::disallowed },
  { U'\x125e', U'\x125f', idna_status::disallowed },
  { U'\x1289', U'\x1289', idna_status::disallowed },
  { U'\x128e', U'\x128f', idna_status::disallowed },
  { U'\x12b1', U'\x12b1', idna_status::disallowed },
  { U'\x12b6', U'\x12b7', idna_status::disallowed },
  { U'\x12bf', U'\x12bf', idna_status::disallowed },
  { U'\x12c1', U'\x12c1', idna_status::disallowed },
  { U'\x12c6', U'\x12c7', idna_status::disallowed },
  { U'\x12d7', U'\x12d7', idna_status::disallowed },
  { U'\x1311', U'\x1311', idna_status::disallowed },
  { U'\x1316', U'\x1317', idna_status::disallowed },
  { U'\x135b', U'\x135c', idna_status::disallowed },
  { U'\x137d', U'\x137f', idna_status::disallowed },
  { U'\x139a', U'\x139f', idna_status::disallowed },
  { U'\x13f6', U'\x13f7', idna_status::disallowed },
  { U'\x13f8', U'\x13fd', idna_status::mapped },
  { U'\x13fe', U'\x13ff', idna_status::disallowed },
  { U'\x1680', U'\x1680', idna_status::disallowed },
  { U'\x169d', U'\x169f', idna_status::disallowed },
  { U'\x16f9', U'\x16ff', idna_status::disallowed },
  { U'\x170d', U'\x170d', idna_status::disallowed },
  { U'\x1715', U'\x171f', idna_status::disallowed },
  { U'\x1737', U'\x173f', idna_status::disallowed },
  { U'\x1754', U'\x175f', idna_status::disallowed },
  { U'\x176d', U'\x176d', idna_status::disallowed },
  { U'\x1771', U'\x1771', idna_status::disallowed },
  { U'\x1774', U'\x177f', idna_status::disallowed },
  { U'\x17b4', U'\x17b5', idna_status::disallowed },
  { U'\x17de', U'\x17df', idna_status::disallowed },
  { U'\x17ea', U'\x17ef', idna_status::disallowed },
  { U'\x17fa', U'\x17ff', idna_status::disallowed },
  { U'\x1806', U'\x1806', idna_status::disallowed },
  { U'\x180b', U'\x180d', idna_status::ignored },
  { U'\x180e', U'\x180f', idna_status::disallowed },
  { U'\x181a', U'\x181f', idna_status::disallowed },
  { U'\x1879', U'\x187f', idna_status::disallowed },
  { U'\x18ab', U'\x18af', idna_status::disallowed },
  { U'\x18f6', U'\x18ff', idna_status::disallowed },
  { U'\x191f', U'\x191f', idna_status::disallowed },
  { U'\x192c', U'\x192f', idna_status::disallowed },
  { U'\x193c', U'\x193f', idna_status::disallowed },
  { U'\x1941', U'\x1943', idna_status::disallowed },
  { U'\x196e', U'\x196f', idna_status::disallowed },
  { U'\x1975', U'\x197f', idna_status::disallowed },
  { U'\x19ac', U'\x19af', idna_status::disallowed },
  { U'\x19ca', U'\x19cf', idna_status::disallowed },
  { U'\x19db', U'\x19dd', idna_status::disallowed },
  { U'\x1a1c', U'\x1a1d', idna_status::disallowed },
  { U'\x1a5f', U'\x1a5f', idna_status::disallowed },
  { U'\x1a7d', U'\x1a7e', idna_status::disallowed },
  { U'\x1a8a', U'\x1a8f', idna_status::disallowed },
  { U'\x1a9a', U'\x1a9f', idna_status::disallowed },
  { U'\x1aae', U'\x1aaf', idna_status::disallowed },
  { U'\x1abf', U'\x1aff', idna_status::disallowed },
  { U'\x1b4c', U'\x1b4f', idna_status::disallowed },
  { U'\x1b7d', U'\x1b7f', idna_status::disallowed },
  { U'\x1bf4', U'\x1bfb', idna_status::disallowed },
  { U'\x1c38', U'\x1c3a', idna_status::disallowed },
  { U'\x1c4a', U'\x1c4c', idna_status::disallowed },
  { U'\x1c80', U'\x1c88', idna_status::mapped },
  { U'\x1c89', U'\x1c8f', idna_status::disallowed },
  { U'\x1c90', U'\x1cba', idna_status::mapped },
  { U'\x1cbb', U'\x1cbc', idna_status::disallowed },
  { U'\x1cbd', U'\x1cbf', idna_status::mapped },
  { U'\x1cc8', U'\x1ccf', idna_status::disallowed },
  { U'\x1cfb', U'\x1cff', idna_status::disallowed },
  { U'\x1d2c', U'\x1d2e', idna_status::mapped },
  { U'\x1d30', U'\x1d3a', idna_status::mapped },
  { U'\x1d3c', U'\x1d4d', idna_status::mapped },
  { U'\x1d4f', U'\x1d6a', idna_status::mapped },
  { U'\x1d78', U'\x1d78', idna_status::mapped },
  { U'\x1d9b', U'\x1dbf', idna_status::mapped },
  { U'\x1dfa', U'\x1dfa', idna_status::disallowed },
  { U'\x1e00', U'\x1e00', idna_status::mapped },
  { U'\x1e02', U'\x1e02', idna_status::mapped },
  { U'\x1e04', U'\x1e04', idna_status::mapped },
  { U'\x1e06', U'\x1e06', idna_status::mapped },
  { U'\x1e08', U'\x1e08', idna_status::mapped },
  { U'\x1e0a', U'\x1e0a', idna_status::mapped },
  { U'\x1e0c', U'\x1e0c', idna_status::mapped },
  { U'\x1e0e', U'\x1e0e', idna_status::mapped },
  { U'\x1e10', U'\x1e10', idna_status::mapped },
  { U'\x1e12', U'\x1e12', idna_status::mapped },
  { U'\x1e14', U'\x1e14', idna_status::mapped },
  { U'\x1e16', U'\x1e16', idna_status::mapped },
  { U'\x1e18', U'\x1e18', idna_status::mapped },
  { U'\x1e1a', U'\x1e1a', idna_status::mapped },
  { U'\x1e1c', U'\x1e1c', idna_status::mapped },
  { U'\x1e1e', U'\x1e1e', idna_status::mapped },
  { U'\x1e20', U'\x1e20', idna_status::mapped },
  { U'\x1e22', U'\x1e22', idna_status::mapped },
  { U'\x1e24', U'\x1e24', idna_status::mapped },
  { U'\x1e26', U'\x1e26', idna_status::mapped },
  { U'\x1e28', U'\x1e28', idna_status::mapped },
  { U'\x1e2a', U'\x1e2a', idna_status::mapped },
  { U'\x1e2c', U'\x1e2c', idna_status::mapped },
  { U'\x1e2e', U'\x1e2e', idna_status::mapped },
  { U'\x1e30', U'\x1e30', idna_status::mapped },
  { U'\x1e32', U'\x1e32', idna_status::mapped },
  { U'\x1e34', U'\x1e34', idna_status::mapped },
  { U'\x1e36', U'\x1e36', idna_status::mapped },
  { U'\x1e38', U'\x1e38', idna_status::mapped },
  { U'\x1e3a', U'\x1e3a', idna_status::mapped },
  { U'\x1e3c', U'\x1e3c', idna_status::mapped },
  { U'\x1e3e', U'\x1e3e', idna_status::mapped },
  { U'\x1e40', U'\x1e40', idna_status::mapped },
  { U'\x1e42', U'\x1e42', idna_status::mapped },
  { U'\x1e44', U'\x1e44', idna_status::mapped },
  { U'\x1e46', U'\x1e46', idna_status::mapped },
  { U'\x1e48', U'\x1e48', idna_status::mapped },
  { U'\x1e4a', U'\x1e4a', idna_status::mapped },
  { U'\x1e4c', U'\x1e4c', idna_status::mapped },
  { U'\x1e4e', U'\x1e4e', idna_status::mapped },
  { U'\x1e50', U'\x1e50', idna_status::mapped },
  { U'\x1e52', U'\x1e52', idna_status::mapped },
  { U'\x1e54', U'\x1e54', idna_status::mapped },
  { U'\x1e56', U'\x1e56', idna_status::mapped },
  { U'\x1e58', U'\x1e58', idna_status::mapped },
  { U'\x1e5a', U'\x1e5a', idna_status::mapped },
  { U'\x1e5c', U'\x1e5c', idna_status::mapped },
  { U'\x1e5e', U'\x1e5e', idna_status::mapped },
  { U'\x1e60', U'\x1e60', idna_status::mapped },
  { U'\x1e62', U'\x1e62', idna_status::mapped },
  { U'\x1e64', U'\x1e64', idna_status::mapped },
  { U'\x1e66', U'\x1e66', idna_status::mapped },
  { U'\x1e68', U'\x1e68', idna_status::mapped },
  { U'\x1e6a', U'\x1e6a', idna_status::mapped },
  { U'\x1e6c', U'\x1e6c', idna_status::mapped },
  { U'\x1e6e', U'\x1e6e', idna_status::mapped },
  { U'\x1e70', U'\x1e70', idna_status::mapped },
  { U'\x1e72', U'\x1e72', idna_status::mapped },
  { U'\x1e74', U'\x1e74', idna_status::mapped },
  { U'\x1e76', U'\x1e76', idna_status::mapped },
  { U'\x1e78', U'\x1e78', idna_status::mapped },
  { U'\x1e7a', U'\x1e7a', idna_status::mapped },
  { U'\x1e7c', U'\x1e7c', idna_status::mapped },
  { U'\x1e7e', U'\x1e7e', idna_status::mapped },
  { U'\x1e80', U'\x1e80', idna_status::mapped },
  { U'\x1e82', U'\x1e82', idna_status::mapped },
  { U'\x1e84', U'\x1e84', idna_status::mapped },
  { U'\x1e86', U'\x1e86', idna_status::mapped },
  { U'\x1e88', U'\x1e88', idna_status::mapped },
  { U'\x1e8a', U'\x1e8a', idna_status::mapped },
  { U'\x1e8c', U'\x1e8c', idna_status::mapped },
  { U'\x1e8e', U'\x1e8e', idna_status::mapped },
  { U'\x1e90', U'\x1e90', idna_status::mapped },
  { U'\x1e92', U'\x1e92', idna_status::mapped },
  { U'\x1e94', U'\x1e94', idna_status::mapped },
  { U'\x1e9a', U'\x1e9b', idna_status::mapped },
  { U'\x1e9e', U'\x1e9e', idna_status::mapped },
  { U'\x1ea0', U'\x1ea0', idna_status::mapped },
  { U'\x1ea2', U'\x1ea2', idna_status::mapped },
  { U'\x1ea4', U'\x1ea4', idna_status::mapped },
  { U'\x1ea6', U'\x1ea6', idna_status::mapped },
  { U'\x1ea8', U'\x1ea8', idna_status::mapped },
  { U'\x1eaa', U'\x1eaa', idna_status::mapped },
  { U'\x1eac', U'\x1eac', idna_status::mapped },
  { U'\x1eae', U'\x1eae', idna_status::mapped },
  { U'\x1eb0', U'\x1eb0', idna_status::mapped },
  { U'\x1eb2', U'\x1eb2', idna_status::mapped },
  { U'\x1eb4', U'\x1eb4', idna_status::mapped },
  { U'\x1eb6', U'\x1eb6', idna_status::mapped },
  { U'\x1eb8', U'\x1eb8', idna_status::mapped },
  { U'\x1eba', U'\x1eba', idna_status::mapped },
  { U'\x1ebc', U'\x1ebc', idna_status::mapped },
  { U'\x1ebe', U'\x1ebe', idna_status::mapped },
  { U'\x1ec0', U'\x1ec0', idna_status::mapped },
  { U'\x1ec2', U'\x1ec2', idna_status::mapped },
  { U'\x1ec4', U'\x1ec4', idna_status::mapped },
  { U'\x1ec6', U'\x1ec6', idna_status::mapped },
  { U'\x1ec8', U'\x1ec8', idna_status::mapped },
  { U'\x1eca', U'\x1eca', idna_status::mapped },
  { U'\x1ecc', U'\x1ecc', idna_status::mapped },
  { U'\x1ece', U'\x1ece', idna_status::mapped },
  { U'\x1ed0', U'\x1ed0', idna_status::mapped },
  { U'\x1ed2', U'\x1ed2', idna_status::mapped },
  { U'\x1ed4', U'\x1ed4', idna_status::mapped },
  { U'\x1ed6', U'\x1ed6', idna_status::mapped },
  { U'\x1ed8', U'\x1ed8', idna_status::mapped },
  { U'\x1eda', U'\x1eda', idna_status::mapped },
  { U'\x1edc', U'\x1edc', idna_status::mapped },
  { U'\x1ede', U'\x1ede', idna_status::mapped },
  { U'\x1ee0', U'\x1ee0', idna_status::mapped },
  { U'\x1ee2', U'\x1ee2', idna_status::mapped },
  { U'\x1ee4', U'\x1ee4', idna_status::mapped },
  { U'\x1ee6', U'\x1ee6', idna_status::mapped },
  { U'\x1ee8', U'\x1ee8', idna_status::mapped },
  { U'\x1eea', U'\x1eea', idna_status::mapped },
  { U'\x1eec', U'\x1eec', idna_status::mapped },
  { U'\x1eee', U'\x1eee', idna_status::mapped },
  { U'\x1ef0', U'\x1ef0', idna_status::mapped },
  { U'\x1ef2', U'\x1ef2', idna_status::mapped },
  { U'\x1ef4', U'\x1ef4', idna_status::mapped },
  { U'\x1ef6', U'\x1ef6', idna_status::mapped },
  { U'\x1ef8', U'\x1ef8', idna_status::mapped },
  { U'\x1efa', U'\x1efa', idna_status::mapped },
  { U'\x1efc', U'\x1efc', idna_status::mapped },
  { U'\x1efe', U'\x1efe', idna_status::mapped },
  { U'\x1f08', U'\x1f0f', idna_status::mapped },
  { U'\x1f16', U'\x1f17', idna_status::disallowed },
  { U'\x1f18', U'\x1f1d', idna_status::mapped },
  { U'\x1f1e', U'\x1f1f', idna_status::disallowed },
  { U'\x1f28', U'\x1f2f', idna_status::mapped },
  { U'\x1f38', U'\x1f3f', idna_status::mapped },
  { U'\x1f46', U'\x1f47', idna_status::disallowed },
  { U'\x1f48', U'\x1f4d', idna_status::mapped },
  { U'\x1f4e', U'\x1f4f', idna_status::disallowed },
  { U'\x1f58', U'\x1f58', idna_status::disallowed },
  { U'\x1f59', U'\x1f59', idna_status::mapped },
  { U'\x1f5a', U'\x1f5a', idna_status::disallowed },
  { U'\x1f5b', U'\x1f5b', idna_status::mapped },
  { U'\x1f5c', U'\x1f5c', idna_status::disallowed },
  { U'\x1f5d', U'\x1f5d', idna_status::mapped },
  { U'\x1f5e', U'\x1f5e', idna_status::disallowed },
  { U'\x1f5f', U'\x1f5f', idna_status::mapped },
  { U'\x1f68', U'\x1f6f', idna_status::mapped },
  { U'\x1f71', U'\x1f71', idna_status::mapped },
  { U'\x1f73', U'\x1f73', idna_status::mapped },
  { U'\x1f75', U'\x1f75', idna_status::mapped },
  { U'\x1f77', U'\x1f77', idna_status::mapped },
  { U'\x1f79', U'\x1f79', idna_status::mapped },
  { U'\x1f7b', U'\x1f7b', idna_status::mapped },
  { U'\x1f7d', U'\x1f7d', idna_status::mapped },
  { U'\x1f7e', U'\x1f7f', idna_status::disallowed },
  { U'\x1f80', U'\x1faf', idna_status::mapped },
  { U'\x1fb2', U'\x1fb4', idna_status::mapped },
  { U'\x1fb5', U'\x1fb5', idna_status::disallowed },
  { U'\x1fb7', U'\x1fbc', idna_status::mapped },
  { U'\x1fbd', U'\x1fbd', idna_status::disallowed_std3_mapped },
  { U'\x1fbe', U'\x1fbe', idna_status::mapped },
  { U'\x1fbf', U'\x1fc1', idna_status::disallowed_std3_mapped },
  { U'\x1fc2', U'\x1fc4', idna_status::mapped },
  { U'\x1fc5', U'\x1fc5', idna_status::disallowed },
  { U'\x1fc7', U'\x1fcc', idna_status::mapped },
  { U'\x1fcd', U'\x1fcf', idna_status::disallowed_std3_mapped },
  { U'\x1fd3', U'\x1fd3', idna_status::mapped },
  { U'\x1fd4', U'\x1fd5', idna_status::disallowed },
  { U'\x1fd8', U'\x1fdb', idna_status::mapped },
  { U'\x1fdc', U'\x1fdc', idna_status::disallowed },
  { U'\x1fdd', U'\x1fdf', idna_status::disallowed_std3_mapped },
  { U'\x1fe3', U'\x1fe3', idna_status::mapped },
  { U'\x1fe8', U'\x1fec', idna_status::mapped },
  { U'\x1fed', U'\x1fef', idna_status::disallowed_std3_mapped },
  { U'\x1ff0', U'\x1ff1', idna_status::disallowed },
  { U'\x1ff2', U'\x1ff4', idna_status::mapped },
  { U'\x1ff5', U'\x1ff5', idna_status::disallowed },
  { U'\x1ff7', U'\x1ffc', idna_status::mapped },
  { U'\x1ffd', U'\x1ffe', idna_status::disallowed_std3_mapped },
  { U'\x1fff', U'\x1fff', idna_status::disallowed },
  { U'\x2000', U'\x200a', idna_status::disallowed_std3_mapped },
  { U'\x200b', U'\x200b', idna_status::ignored },
  { U'\x200c', U'\x200d', idna_status::deviation },
  { U'\x200e', U'\x200f', idna_status::disallowed },
  { U'\x2011', U'\x2011', idna_status::mapped },
  { U'\x2017', U'\x2017', idna_status::disallowed_std3_mapped },
  { U'\x2024', U'\x2026', idna_status::disallowed },
  { U'\x2028', U'\x202e', idna_status::disallowed },
  { U'\x202f', U'\x202f', idna_status::disallowed_std3_mapped },
  { U'\x2033', U'\x2034', idna_status::mapped },
  { U'\x2036', U'\x2037', idna_status::mapped },
  { U'\x203c', U'\x203c', idna_status::disallowed_std3_mapped },
  { U'\x203e', U'\x203e', idna_status::disallowed_std3_mapped },
  { U'\x2047', U'\x2049', idna_status::disallowed_std3_mapped },
  { U'\x2057', U'\x2057', idna_status::mapped },
  { U'\x205f', U'\x205f', idna_status::disallowed_std3_mapped },
  { U'\x2060', U'\x2060', idna_status::ignored },
  { U'\x2061', U'\x2063', idna_status::disallowed },
  { U'\x2064', U'\x2064', idna_status::ignored },
  { U'\x2065', U'\x206f', idna_status::disallowed },
  { U'\x2070', U'\x2071', idna_status::mapped },
  { U'\x2072', U'\x2073', idna_status::disallowed },
  { U'\x2074', U'\x2079', idna_status::mapped },
  { U'\x207a', U'\x207a', idna_status::disallowed_std3_mapped },
  { U'\x207b', U'\x207b', idna_status::mapped },
  { U'\x207c', U'\x207e', idna_status::disallowed_std3_mapped },
  { U'\x207f', U'\x2089', idna_status::mapped },
  { U'\x208a', U'\x208a', idna_status::disallowed_std3_mapped },
  { U'\x208b', U'\x208b', idna_status::mapped },
  { U'\x208c', U'\x208e', idna_status::disallowed_std3_mapped },
  { U'\x208f', U'\x208f', idna_status::disallowed },
  { U'\x2090', U'\x209c', idna_status::mapped },
  { U'\x209d', U'\x209f', idna_status::disallowed },
  { U'\x20a8', U'\x20a8', idna_status::mapped },
  { U'\x20c0', U'\x20cf', idna_status::disallowed },
  { U'\x20f1', U'\x20ff', idna_status::disallowed },
  { U'\x2100', U'\x2101', idna_status::disallowed_std3_mapped },
  { U'\x2102', U'\x2103', idna_status::mapped },
  { U'\x2105', U'\x2106', idna_status::disallowed_std3_mapped },
  { U'\x2107', U'\x2107', idna_status::mapped },
  { U'\x2109', U'\x2113', idna_status::mapped },
  { U'\x2115', U'\x2116', idna_status::mapped },
  { U'\x2119', U'\x211d', idna_status::mapped },
  { U'\x2120', U'\x2122', idna_status::mapped },
  { U'\x2124', U'\x2124', idna_status::mapped },
  { U'\x2126', U'\x2126', idna_status::mapped },
  { U'\x2128', U'\x2128', idna_status::mapped },
  { U'\x212a', U'\x212d', idna_status::mapped },
  { U'\x212f', U'\x2131', idna_status::mapped },
  { U'\x2132', U'\x2132', idna_status::disallowed },
  { U'\x2133', U'\x2139', idna_status::mapped },
  { U'\x213b', U'\x2140', idna_status::mapped },
  { U'\x2145', U'\x2149', idna_status::mapped },
  { U'\x2150', U'\x217f', idna_status::mapped },
  { U'\x2183', U'\x2183', idna_status::disallowed },
  { U'\x2189', U'\x2189', idna_status::mapped },
  { U'\x218c', U'\x218f', idna_status::disallowed },
  { U'\x222c', U'\x222d', idna_status::mapped },
  { U'\x222f', U'\x2230', idna_status::mapped },
  { U'\x2260', U'\x2260', idna_status::disallowed_std3_valid },
  { U'\x226e', U'\x226f', idna_status::disallowed_std3_valid },
  { U'\x2329', U'\x232a', idna_status::mapped },
  { U'\x2427', U'\x243f', idna_status::disallowed },
  { U'\x244b', U'\x245f', idna_status::disallowed },
  { U'\x2460', U'\x2473', idna_status::mapped },
  { U'\x2474', U'\x2487', idna_status::disallowed_std3_mapped },
  { U'\x2488', U'\x249b', idna_status::disallowed },
  { U'\x249c', U'\x24b5', idna_status::disallowed_std3_mapped },
  { U'\x24b6', U'\x24ea', idna_status::mapped },
  { U'\x2a0c', U'\x2a0c', idna_status::mapped },
  { U'\x2a74', U'\x2a76', idna_status::disallowed_std3_mapped },
  { U'\x2adc', U'\x2adc', idna_status::mapped },
  { U'\x2b74', U'\x2b75', idna_status::disallowed },
  { U'\x2b96', U'\x2b97', idna_status::disallowed },
  { U'\x2c00', U'\x2c2e', idna_status::mapped },
  { U'\x2c2f', U'\x2c2f', idna_status::disallowed },
  { U'\x2c5f', U'\x2c5f', idna_status::disallowed },
  { U'\x2c60', U'\x2c60', idna_status::mapped },
  { U'\x2c62', U'\x2c64', idna_status::mapped },
  { U'\x2c67', U'\x2c67', idna_status::mapped },
  { U'\x2c69', U'\x2c69', idna_status::mapped },
  { U'\x2c6b', U'\x2c6b', idna_status::mapped },
  { U'\x2c6d', U'\x2c70', idna_status::mapped },
  { U'\x2c72', U'\x2c72', idna_status::mapped },
  { U'\x2c75', U'\x2c75', idna_status::mapped },
  { U'\x2c7c', U'\x2c80', idna_status::mapped },
  { U'\x2c82', U'\x2c82', idna_status::mapped },
  { U'\x2c84', U'\x2c84', idna_status::mapped },
  { U'\x2c86', U'\x2c86', idna_status::mapped },
  { U'\x2c88', U'\x2c88', idna_status::mapped },
  { U'\x2c8a', U'\x2c8a', idna_status::mapped },
  { U'\x2c8c', U'\x2c8c', idna_status::mapped },
  { U'\x2c8e', U'\x2c8e', idna_status::mapped },
  { U'\x2c90', U'\x2c90', idna_status::mapped },
  { U'\x2c92', U'\x2c92', idna_status::mapped },
  { U'\x2c94', U'\x2c94', idna_status::mapped },
  { U'\x2c96', U'\x2c96', idna_status::mapped },
  { U'\x2c98', U'\x2c98', idna_status::mapped },
  { U'\x2c9a', U'\x2c9a', idna_status::mapped },
  { U'\x2c9c', U'\x2c9c', idna_status::mapped },
  { U'\x2c9e', U'\x2c9e', idna_status::mapped },
  { U'\x2ca0', U'\x2ca0', idna_status::mapped },
  { U'\x2ca2', U'\x2ca2', idna_status::mapped },
  { U'\x2ca4', U'\x2ca4', idna_status::mapped },
  { U'\x2ca6', U'\x2ca6', idna_status::mapped },
  { U'\x2ca8', U'\x2ca8', idna_status::mapped },
  { U'\x2caa', U'\x2caa', idna_status::mapped },
  { U'\x2cac', U'\x2cac', idna_status::mapped },
  { U'\x2cae', U'\x2cae', idna_status::mapped },
  { U'\x2cb0', U'\x2cb0', idna_status::mapped },
  { U'\x2cb2', U'\x2cb2', idna_status::mapped },
  { U'\x2cb4', U'\x2cb4', idna_status::mapped },
  { U'\x2cb6', U'\x2cb6', idna_status::mapped },
  { U'\x2cb8', U'\x2cb8', idna_status::mapped },
  { U'\x2cba', U'\x2cba', idna_status::mapped },
  { U'\x2cbc', U'\x2cbc', idna_status::mapped },
  { U'\x2cbe', U'\x2cbe', idna_status::mapped },
  { U'\x2cc0', U'\x2cc0', idna_status::mapped },
  { U'\x2cc2', U'\x2cc2', idna_status::mapped },
  { U'\x2cc4', U'\x2cc4', idna_status::mapped },
  { U'\x2cc6', U'\x2cc6', idna_status::mapped },
  { U'\x2cc8', U'\x2cc8', idna_status::mapped },
  { U'\x2cca', U'\x2cca', idna_status::mapped },
  { U'\x2ccc', U'\x2ccc', idna_status::mapped },
  { U'\x2cce', U'\x2cce', idna_status::mapped },
  { U'\x2cd0', U'\x2cd0', idna_status::mapped },
  { U'\x2cd2', U'\x2cd2', idna_status::mapped },
  { U'\x2cd4', U'\x2cd4', idna_status::mapped },
  { U'\x2cd6', U'\x2cd6', idna_status::mapped },
  { U'\x2cd8', U'\x2cd8', idna_status::mapped },
  { U'\x2cda', U'\x2cda', idna_status::mapped },
  { U'\x2cdc', U'\x2cdc', idna_status::mapped },
  { U'\x2cde', U'\x2cde', idna_status::mapped },
  { U'\x2ce0', U'\x2ce0', idna_status::mapped },
  { U'\x2ce2', U'\x2ce2', idna_status::mapped },
  { U'\x2ceb', U'\x2ceb', idna_status::mapped },
  { U'\x2ced', U'\x2ced', idna_status::mapped },
  { U'\x2cf2', U'\x2cf2', idna_status::mapped },
  { U'\x2cf4', U'\x2cf8', idna_status::disallowed },
  { U'\x2d26', U'\x2d26', idna_status::disallowed },
  { U'\x2d28', U'\x2d2c', idna_status::disallowed },
  { U'\x2d2e', U'\x2d2f', idna_status::disallowed },
  { U'\x2d68', U'\x2d6e', idna_status::disallowed },
  { U'\x2d6f', U'\x2d6f', idna_status::mapped },
  { U'\x2d71', U'\x2d7e', idna_status::disallowed },
  { U'\x2d97', U'\x2d9f', idna_status::disallowed },
  { U'\x2da7', U'\x2da7', idna_status::disallowed },
  { U'\x2daf', U'\x2daf', idna_status::disallowed },
  { U'\x2db7', U'\x2db7', idna_status::disallowed },
  { U'\x2dbf', U'\x2dbf', idna_status::disallowed },
  { U'\x2dc7', U'\x2dc7', idna_status::disallowed },
  { U'\x2dcf', U'\x2dcf', idna_status::disallowed },
  { U'\x2dd7', U'\x2dd7', idna_status::disallowed },
  { U'\x2ddf', U'\x2ddf', idna_status::disallowed },
  { U'\x2e50', U'\x2e7f', idna_status::disallowed },
  { U'\x2e9a', U'\x2e9a', idna_status::disallowed },
  { U'\x2e9f', U'\x2e9f', idna_status::mapped },
  { U'\x2ef3', U'\x2ef3', idna_status::mapped },
  { U'\x2ef4', U'\x2eff', idna_status::disallowed },
  { U'\x2f00', U'\x2fd5', idna_status::mapped },
  { U'\x2fd6', U'\x2fff', idna_status::disallowed },
  { U'\x3000', U'\x3000', idna_status::disallowed_std3_mapped },
  { U'\x3002', U'\x3002', idna_status::mapped },
  { U'\x3036', U'\x3036', idna_status::mapped },
  { U'\x3038', U'\x303a', idna_status::mapped },
  { U'\x3040', U'\x3040', idna_status::disallowed },
  { U'\x3097', U'\x3098', idna_status::disallowed },
  { U'\x309b', U'\x309c', idna_status::disallowed_std3_mapped },
  { U'\x309f', U'\x309f', idna_status::mapped },
  { U'\x30ff', U'\x30ff', idna_status::mapped },
  { U'\x3100', U'\x3104', idna_status::disallowed },
  { U'\x3130', U'\x3130', idna_status::disallowed },
  { U'\x3131', U'\x3163', idna_status::mapped },
  { U'\x3164', U'\x3164', idna_status::disallowed },
  { U'\x3165', U'\x318e', idna_status::mapped },
  { U'\x318f', U'\x318f', idna_status::disallowed },
  { U'\x3192', U'\x319f', idna_status::mapped },
  { U'\x31bb', U'\x31bf', idna_status::disallowed },
  { U'\x31e4', U'\x31ef', idna_status::disallowed },
  { U'\x3200', U'\x321e', idna_status::disallowed_std3_mapped },
  { U'\x321f', U'\x321f', idna_status::disallowed },
  { U'\x3220', U'\x3243', idna_status::disallowed_std3_mapped },
  { U'\x3244', U'\x3247', idna_status::mapped },
  { U'\x3250', U'\x327e', idna_status::mapped },
  { U'\x3280', U'\x33c1', idna_status::mapped },
  { U'\x33c2', U'\x33c2', idna_status::disallowed },
  { U'\x33c3', U'\x33c6', idna_status::mapped },
  { U'\x33c7', U'\x33c7', idna_status::disallowed },
  { U'\x33c8', U'\x33d7', idna_status::mapped },
  { U'\x33d8', U'\x33d8', idna_status::disallowed },
  { U'\x33d9', U'\x33ff', idna_status::mapped },
  { U'\x4db6', U'\x4dbf', idna_status::disallowed },
  { U'\x9ff0', U'\x9fff', idna_status::disallowed },
  { U'\xa48d', U'\xa48f', idna_status::disallowed },
  { U'\xa4c7', U'\xa4cf', idna_status::disallowed },
  { U'\xa62c', U'\xa63f', idna_status::disallowed },
  { U'\xa640', U'\xa640', idna_status::mapped },
  { U'\xa642', U'\xa642', idna_status::mapped },
  { U'\xa644', U'\xa644', idna_status::mapped },
  { U'\xa646', U'\xa646', idna_status::mapped },
  { U'\xa648', U'\xa648', idna_status::mapped },
  { U'\xa64a', U'\xa64a', idna_status::mapped },
  { U'\xa64c', U'\xa64c', idna_status::mapped },
  { U'\xa64e', U'\xa64e', idna_status::mapped },
  { U'\xa650', U'\xa650', idna_status::mapped },
  { U'\xa652', U'\xa652', idna_status::mapped },
  { U'\xa654', U'\xa654', idna_status::mapped },
  { U'\xa656', U'\xa656', idna_status::mapped },
  { U'\xa658', U'\xa658', idna_status::mapped },
  { U'\xa65a', U'\xa65a', idna_status::mapped },
  { U'\xa65c', U'\xa65c', idna_status::mapped },
  { U'\xa65e', U'\xa65e', idna_status::mapped },
  { U'\xa660', U'\xa660', idna_status::mapped },
  { U'\xa662', U'\xa662', idna_status::mapped },
  { U'\xa664', U'\xa664', idna_status::mapped },
  { U'\xa666', U'\xa666', idna_status::mapped },
  { U'\xa668', U'\xa668', idna_status::mapped },
  { U'\xa66a', U'\xa66a', idna_status::mapped },
  { U'\xa66c', U'\xa66c', idna_status::mapped },
  { U'\xa680', U'\xa680', idna_status::mapped },
  { U'\xa682', U'\xa682', idna_status::mapped },
  { U'\xa684', U'\xa684', idna_status::mapped },
  { U'\xa686', U'\xa686', idna_status::mapped },
  { U'\xa688', U'\xa688', idna_status::mapped },
  { U'\xa68a', U'\xa68a', idna_status::mapped },
  { U'\xa68c', U'\xa68c', idna_status::mapped },
  { U'\xa68e', U'\xa68e', idna_status::mapped },
  { U'\xa690', U'\xa690', idna_status::mapped },
  { U'\xa692', U'\xa692', idna_status::mapped },
  { U'\xa694', U'\xa694', idna_status::mapped },
  { U'\xa696', U'\xa696', idna_status::mapped },
  { U'\xa698', U'\xa698', idna_status::mapped },
  { U'\xa69a', U'\xa69a', idna_status::mapped },
  { U'\xa69c', U'\xa69d', idna_status::mapped },
  { U'\xa6f8', U'\xa6ff', idna_status::disallowed },
  { U'\xa722', U'\xa722', idna_status::mapped },
  { U'\xa724', U'\xa724', idna_status::mapped },
  { U'\xa726', U'\xa726', idna_status::mapped },
  { U'\xa728', U'\xa728', idna_status::mapped },
  { U'\xa72a', U'\xa72a', idna_status::mapped },
  { U'\xa72c', U'\xa72c', idna_status::mapped },
  { U'\xa72e', U'\xa72e', idna_status::mapped },
  { U'\xa732', U'\xa732', idna_status::mapped },
  { U'\xa734', U'\xa734', idna_status::mapped },
  { U'\xa736', U'\xa736', idna_status::mapped },
  { U'\xa738', U'\xa738', idna_status::mapped },
  { U'\xa73a', U'\xa73a', idna_status::mapped },
  { U'\xa73c', U'\xa73c', idna_status::mapped },
  { U'\xa73e', U'\xa73e', idna_status::mapped },
  { U'\xa740', U'\xa740', idna_status::mapped },
  { U'\xa742', U'\xa742', idna_status::mapped },
  { U'\xa744', U'\xa744', idna_status::mapped },
  { U'\xa746', U'\xa746', idna_status::mapped },
  { U'\xa748', U'\xa748', idna_status::mapped },
  { U'\xa74a', U'\xa74a', idna_status::mapped },
  { U'\xa74c', U'\xa74c', idna_status::mapped },
  { U'\xa74e', U'\xa74e', idna_status::mapped },
  { U'\xa750', U'\xa750', idna_status::mapped },
  { U'\xa752', U'\xa752', idna_status::mapped },
  { U'\xa754', U'\xa754', idna_status::mapped },
  { U'\xa756', U'\xa756', idna_status::mapped },
  { U'\xa758', U'\xa758', idna_status::mapped },
  { U'\xa75a', U'\xa75a', idna_status::mapped },
  { U'\xa75c', U'\xa75c', idna_status::mapped },
  { U'\xa75e', U'\xa75e', idna_status::mapped },
  { U'\xa760', U'\xa760', idna_status::mapped },
  { U'\xa762', U'\xa762', idna_status::mapped },
  { U'\xa764', U'\xa764', idna_status::mapped },
  { U'\xa766', U'\xa766', idna_status::mapped },
  { U'\xa768', U'\xa768', idna_status::mapped },
  { U'\xa76a', U'\xa76a', idna_status::mapped },
  { U'\xa76c', U'\xa76c', idna_status::mapped },
  { U'\xa76e', U'\xa76e', idna_status::mapped },
  { U'\xa770', U'\xa770', idna_status::mapped },
  { U'\xa779', U'\xa779', idna_status::mapped },
  { U'\xa77b', U'\xa77b', idna_status::mapped },
  { U'\xa77d', U'\xa77e', idna_status::mapped },
  { U'\xa780', U'\xa780', idna_status::mapped },
  { U'\xa782', U'\xa782', idna_status::mapped },
  { U'\xa784', U'\xa784', idna_status::mapped },
  { U'\xa786', U'\xa786', idna_status::mapped },
  { U'\xa78b', U'\xa78b', idna_status::mapped },
  { U'\xa78d', U'\xa78d', idna_status::mapped },
  { U'\xa790', U'\xa790', idna_status::mapped },
  { U'\xa792', U'\xa792', idna_status::mapped },
  { U'\xa796', U'\xa796', idna_status::mapped },
  { U'\xa798', U'\xa798', idna_status::mapped },
  { U'\xa79a', U'\xa79a', idna_status::mapped },
  { U'\xa79c', U'\xa79c', idna_status::mapped },
  { U'\xa79e', U'\xa79e', idna_status::mapped },
  { U'\xa7a0', U'\xa7a0', idna_status::mapped },
  { U'\xa7a2', U'\xa7a2', idna_status::mapped },
  { U'\xa7a4', U'\xa7a4', idna_status::mapped },
  { U'\xa7a6', U'\xa7a6', idna_status::mapped },
  { U'\xa7a8', U'\xa7a8', idna_status::mapped },
  { U'\xa7aa', U'\xa7ae', idna_status::mapped },
  { U'\xa7b0', U'\xa7b4', idna_status::mapped },
  { U'\xa7b6', U'\xa7b6', idna_status::mapped },
  { U'\xa7b8', U'\xa7b8', idna_status::mapped },
  { U'\xa7ba', U'\xa7ba', idna_status::mapped },
  { U'\xa7bc', U'\xa7bc', idna_status::mapped },
  { U'\xa7be', U'\xa7be', idna_status::mapped },
  { U'\xa7c0', U'\xa7c1', idna_status::disallowed },
  { U'\xa7c2', U'\xa7c2', idna_status::mapped },
  { U'\xa7c4', U'\xa7c6', idna_status::mapped },
  { U'\xa7c7', U'\xa7f6', idna_status::disallowed },
  { U'\xa7f8', U'\xa7f9', idna_status::mapped },
  { U'\xa82c', U'\xa82f', idna_status::disallowed },
  { U'\xa83a', U'\xa83f', idna_status::disallowed },
  { U'\xa878', U'\xa87f', idna_status::disallowed },
  { U'\xa8c6', U'\xa8cd', idna_status::disallowed },
  { U'\xa8da', U'\xa8df', idna_status::disallowed },
  { U'\xa954', U'\xa95e', idna_status::disallowed },
  { U'\xa97d', U'\xa97f', idna_status::disallowed },
  { U'\xa9ce', U'\xa9ce', idna_status::disallowed },
  { U'\xa9da', U'\xa9dd', idna_status::disallowed },
  { U'\xa9ff', U'\xa9ff', idna_status::disallowed },
  { U'\xaa37', U'\xaa3f', idna_status::disallowed },
  { U'\xaa4e', U'\xaa4f', idna_status::disallowed },
  { U'\xaa5a', U'\xaa5b', idna_status::disallowed },
  { U'\xaac3', U'\xaada', idna_status::disallowed },
  { U'\xaaf7', U'\xab00', idna_status::disallowed },
  { U'\xab07', U'\xab08', idna_status::disallowed },
  { U'\xab0f', U'\xab10', idna_status::disallowed },
  { U'\xab17', U'\xab1f', idna_status::disallowed },
  { U'\xab27', U'\xab27', idna_status::disallowed },
  { U'\xab2f', U'\xab2f', idna_status::disallowed },
  { U'\xab5c', U'\xab5f', idna_status::mapped },
  { U'\xab68', U'\xab6f', idna_status::disallowed },
  { U'\xab70', U'\xabbf', idna_status::mapped },
  { U'\xabee', U'\xabef', idna_status::disallowed },
  { U'\xabfa', U'\xabff', idna_status::disallowed },
  { U'\xd7a4', U'\xd7af', idna_status::disallowed },
  { U'\xd7c7', U'\xd7ca', idna_status::disallowed },
  { U'\xd7fc', U'\xf8ff', idna_status::disallowed },
  { U'\xf900', U'\xfa0d', idna_status::mapped },
  { U'\xfa10', U'\xfa10', idna_status::mapped },
  { U'\xfa12', U'\xfa12', idna_status::mapped },
  { U'\xfa15', U'\xfa1e', idna_status::mapped },
  { U'\xfa20', U'\xfa20', idna_status::mapped },
  { U'\xfa22', U'\xfa22', idna_status::mapped },
  { U'\xfa25', U'\xfa26', idna_status::mapped },
  { U'\xfa2a', U'\xfa6d', idna_status::mapped },
  { U'\xfa6e', U'\xfa6f', idna_status::disallowed },
  { U'\xfa70', U'\xfad9', idna_status::mapped },
  { U'\xfada', U'\xfaff', idna_status::disallowed },
  { U'\xfb00', U'\xfb06', idna_status::mapped },
  { U'\xfb07', U'\xfb12', idna_status::disallowed },
  { U'\xfb13', U'\xfb17', idna_status::mapped },
  { U'\xfb18', U'\xfb1c', idna_status::disallowed },
  { U'\xfb1d', U'\xfb1d', idna_status::mapped },
  { U'\xfb1f', U'\xfb28', idna_status::mapped },
  { U'\xfb29', U'\xfb29', idna_status::disallowed_std3_mapped },
  { U'\xfb2a', U'\xfb36', idna_status::mapped },
  { U'\xfb37', U'\xfb37', idna_status::disallowed },
  { U'\xfb38', U'\xfb3c', idna_status::mapped },
  { U'\xfb3d', U'\xfb3d', idna_status::disallowed },
  { U'\xfb3e', U'\xfb3e', idna_status::mapped },
  { U'\xfb3f', U'\xfb3f', idna_status::disallowed },
  { U'\xfb40', U'\xfb41', idna_status::mapped },
  { U'\xfb42', U'\xfb42', idna_status::disallowed },
  { U'\xfb43', U'\xfb44', idna_status::mapped },
  { U'\xfb45', U'\xfb45', idna_status::disallowed },
  { U'\xfb46', U'\xfbb1', idna_status::mapped },
  { U'\xfbc2', U'\xfbd2', idna_status::disallowed },
  { U'\xfbd3', U'\xfc5d', idna_status::mapped },
  { U'\xfc5e', U'\xfc63', idna_status::disallowed_std3_mapped },
  { U'\xfc64', U'\xfd3d', idna_status::mapped },
  { U'\xfd40', U'\xfd4f', idna_status::disallowed },
  { U'\xfd50', U'\xfd8f', idna_status::mapped },
  { U'\xfd90', U'\xfd91', idna_status::disallowed },
  { U'\xfd92', U'\xfdc7', idna_status::mapped },
  { U'\xfdc8', U'\xfdef', idna_status::disallowed },
  { U'\xfdf0', U'\xfdf9', idna_status::mapped },
  { U'\xfdfa', U'\xfdfb', idna_status::disallowed_std3_mapped },
  { U'\xfdfc', U'\xfdfc', idna_status::mapped },
  { U'\xfdfe', U'\xfdff', idna_status::disallowed },
  { U'\xfe00', U'\xfe0f', idna_status::ignored },
  { U'\xfe10', U'\xfe10', idna_status::disallowed_std3_mapped },
  { U'\xfe11', U'\xfe11', idna_status::mapped },
  { U'\xfe12', U'\xfe12', idna_status::disallowed },
  { U'\xfe13', U'\xfe16', idna_status::disallowed_std3_mapped },
  { U'\xfe17', U'\xfe18', idna_status::mapped },
  { U'\xfe19', U'\xfe1f', idna_status::disallowed },
  { U'\xfe30', U'\xfe30', idna_status::disallowed },
  { U'\xfe31', U'\xfe32', idna_status::mapped },
  { U'\xfe33', U'\xfe38', idna_status::disallowed_std3_mapped },
  { U'\xfe39', U'\xfe44', idna_status::mapped },
  { U'\xfe47', U'\xfe50', idna_status::disallowed_std3_mapped },
  { U'\xfe51', U'\xfe51', idna_status::mapped },
  { U'\xfe52', U'\xfe53', idna_status::disallowed },
  { U'\xfe54', U'\xfe57', idna_status::disallowed_std3_mapped },
  { U'\xfe58', U'\xfe58', idna_status::mapped },
  { U'\xfe59', U'\xfe5c', idna_status::disallowed_std3_mapped },
  { U'\xfe5d', U'\xfe5e', idna_status::mapped },
  { U'\xfe5f', U'\xfe62', idna_status::disallowed_std3_mapped },
  { U'\xfe63', U'\xfe63', idna_status::mapped },
  { U'\xfe64', U'\xfe66', idna_status::disallowed_std3_mapped },
  { U'\xfe67', U'\xfe67', idna_status::disallowed },
  { U'\xfe68', U'\xfe6b', idna_status::disallowed_std3_mapped },
  { U'\xfe6c', U'\xfe6f', idna_status::disallowed },
  { U'\xfe70', U'\xfe70', idna_status::disallowed_std3_mapped },
  { U'\xfe71', U'\xfe71', idna_status::mapped },
  { U'\xfe72', U'\xfe72', idna_status::disallowed_std3_mapped },
  { U'\xfe74', U'\xfe74', idna_status::disallowed_std3_mapped },
  { U'\xfe75', U'\xfe75', idna_status::disallowed },
  { U'\xfe76', U'\xfe76', idna_status::disallowed_std3_mapped },
  { U'\xfe77', U'\xfe77', idna_status::mapped },
  { U'\xfe78', U'\xfe78', idna_status::disallowed_std3_mapped },
  { U'\xfe79', U'\xfe79', idna_status::mapped },
  { U'\xfe7a', U'\xfe7a', idna_status::disallowed_std3_mapped },
  { U'\xfe7b', U'\xfe7b', idna_status::mapped },
  { U'\xfe7c', U'\xfe7c', idna_status::disallowed_std3_mapped },
  { U'\xfe7d', U'\xfe7d', idna_status::mapped },
  { U'\xfe7e', U'\xfe7e', idna_status::disallowed_std3_mapped },
  { U'\xfe7f', U'\xfefc', idna_status::mapped },
  { U'\xfefd', U'\xfefe', idna_status::disallowed },
  { U'\xfeff', U'\xfeff', idna_status::ignored },
  { U'\xff00', U'\xff00', idna_status::disallowed },
  { U'\xff01', U'\xff0c', idna_status::disallowed_std3_mapped },
  { U'\xff0d', U'\xff0e', idna_status::mapped },
  { U'\xff0f', U'\xff0f', idna_status::disallowed_std3_mapped },
  { U'\xff10', U'\xff19', idna_status::mapped },
  { U'\xff1a', U'\xff20', idna_status::disallowed_std3_mapped },
  { U'\xff21', U'\xff3a', idna_status::mapped },
  { U'\xff3b', U'\xff40', idna_status::disallowed_std3_mapped },
  { U'\xff41', U'\xff5a', idna_status::mapped },
  { U'\xff5b', U'\xff5e', idna_status::disallowed_std3_mapped },
  { U'\xff5f', U'\xff9f', idna_status::mapped },
  { U'\xffa0', U'\xffa0', idna_status::disallowed },
  { U'\xffa1', U'\xffbe', idna_status::mapped },
  { U'\xffbf', U'\xffc1', idna_status::disallowed },
  { U'\xffc2', U'\xffc7', idna_status::mapped },
  { U'\xffc8', U'\xffc9', idna_status::disallowed },
  { U'\xffca', U'\xffcf', idna_status::mapped },
  { U'\xffd0', U'\xffd1', idna_status::disallowed },
  { U'\xffd2', U'\xffd7', idna_status::mapped },
  { U'\xffd8', U'\xffd9', idna_status::disallowed },
  { U'\xffda', U'\xffdc', idna_status::mapped },
  { U'\xffdd', U'\xffdf', idna_status::disallowed },
  { U'\xffe0', U'\xffe2', idna_status::mapped },
  { U'\xffe3', U'\xffe3', idna_status::disallowed_std3_mapped },
  { U'\xffe4', U'\xffe6', idna_status::mapped },
  { U'\xffe7', U'\xffe7', idna_status::disallowed },
  { U'\xffe8', U'\xffee', idna_status::mapped },
  { U'\xffef', U'\xffff', idna_status::disallowed },
  { U'\x1000c', U'\x1000c', idna_status::disallowed },
  { U'\x10027', U'\x10027', idna_status::disallowed },
  { U'\x1003b', U'\x1003b', idna_status::disallowed },
  { U'\x1003e', U'\x1003e', idna_status::disallowed },
  { U'\x1004e', U'\x1004f', idna_status::disallowed },
  { U'\x1005e', U'\x1007f', idna_status::disallowed },
  { U'\x100fb', U'\x100ff', idna_status::disallowed },
  { U'\x10103', U'\x10106', idna_status::disallowed },
  { U'\x10134', U'\x10136', idna_status::disallowed },
  { U'\x1018f', U'\x1018f', idna_status::disallowed },
  { U'\x1019c', U'\x1019f', idna_status::disallowed },
  { U'\x101a1', U'\x101cf', idna_status::disallowed },
  { U'\x101fe', U'\x1027f', idna_status::disallowed },
  { U'\x1029d', U'\x1029f', idna_status::disallowed },
  { U'\x102d1', U'\x102df', idna_status::disallowed },
  { U'\x102fc', U'\x102ff', idna_status::disallowed },
  { U'\x10324', U'\x1032c', idna_status::disallowed },
  { U'\x1034b', U'\x1034f', idna_status::disallowed },
  { U'\x1037b', U'\x1037f', idna_status::disallowed },
  { U'\x1039e', U'\x1039e', idna_status::disallowed },
  { U'\x103c4', U'\x103c7', idna_status::disallowed },
  { U'\x103d6', U'\x103ff', idna_status::disallowed },
  { U'\x10400', U'\x10427', idna_status::mapped },
  { U'\x1049e', U'\x1049f', idna_status::disallowed },
  { U'\x104aa', U'\x104af', idna_status::disallowed },
  { U'\x104b0', U'\x104d3', idna_status::mapped },
  { U'\x104d4', U'\x104d7', idna_status::disallowed },
  { U'\x104fc', U'\x104ff', idna_status::disallowed },
  { U'\x10528', U'\x1052f', idna_status::disallowed },
  { U'\x10564', U'\x1056e', idna_status::disallowed },
  { U'\x10570', U'\x105ff', idna_status::disallowed },
  { U'\x10737', U'\x1073f', idna_status::disallowed },
  { U'\x10756', U'\x1075f', idna_status::disallowed },
  { U'\x10768', U'\x107ff', idna_status::disallowed },
  { U'\x10806', U'\x10807', idna_status::disallowed },
  { U'\x10809', U'\x10809', idna_status::disallowed },
  { U'\x10836', U'\x10836', idna_status::disallowed },
  { U'\x10839', U'\x1083b', idna_status::disallowed },
  { U'\x1083d', U'\x1083e', idna_status::disallowed },
  { U'\x10856', U'\x10856', idna_status::disallowed },
  { U'\x1089f', U'\x108a6', idna_status::disallowed },
  { U'\x108b0', U'\x108df', idna_status::disallowed },
  { U'\x108f3', U'\x108f3', idna_status::disallowed },
  { U'\x108f6', U'\x108fa', idna_status::disallowed },
  { U'\x1091c', U'\x1091e', idna_status::disallowed },
  { U'\x1093a', U'\x1093e', idna_status::disallowed },
  { U'\x10940', U'\x1097f', idna_status::disallowed },
  { U'\x109b8', U'\x109bb', idna_status::disallowed },
  { U'\x109d0', U'\x109d1', idna_status::disallowed },
  { U'\x10a04', U'\x10a04', idna_status::disallowed },
  { U'\x10a07', U'\x10a0b', idna_status::disallowed },
  { U'\x10a14', U'\x10a14', idna_status::disallowed },
  { U'\x10a18', U'\x10a18', idna_status::disallowed },
  { U'\x10a36', U'\x10a37', idna_status::disallowed },
  { U'\x10a3b', U'\x10a3e', idna_status::disallowed },
  { U'\x10a49', U'\x10a4f', idna_status::disallowed },
  { U'\x10a59', U'\x10a5f', idna_status::disallowed },
  { U'\x10aa0', U'\x10abf', idna_status::disallowed },
  { U'\x10ae7', U'\x10aea', idna_status::disallowed },
  { U'\x10af7', U'\x10aff', idna_status::disallowed },
  { U'\x10b36', U'\x10b38', idna_status::disallowed },
  { U'\x10b56', U'\x10b57', idna_status::disallowed },
  { U'\x10b73', U'\x10b77', idna_status::disallowed },
  { U'\x10b92', U'\x10b98', idna_status::disallowed },
  { U'\x10b9d', U'\x10ba8', idna_status::disallowed },
  { U'\x10bb0', U'\x10bff', idna_status::disallowed },
  { U'\x10c49', U'\x10c7f', idna_status::disallowed },
  { U'\x10c80', U'\x10cb2', idna_status::mapped },
  { U'\x10cb3', U'\x10cbf', idna_status::disallowed },
  { U'\x10cf3', U'\x10cf9', idna_status::disallowed },
  { U'\x10d28', U'\x10d2f', idna_status::disallowed },
  { U'\x10d3a', U'\x10e5f', idna_status::disallowed },
  { U'\x10e7f', U'\x10eff', idna_status::disallowed },
  { U'\x10f28', U'\x10f2f', idna_status::disallowed },
  { U'\x10f5a', U'\x10fdf', idna_status::disallowed },
  { U'\x10ff7', U'\x10fff', idna_status::disallowed },
  { U'\x1104e', U'\x11051', idna_status::disallowed },
  { U'\x11070', U'\x1107e', idna_status::disallowed },
  { U'\x110bd', U'\x110bd', idna_status::disallowed },
  { U'\x110c2', U'\x110cf', idna_status::disallowed },
  { U'\x110e9', U'\x110ef', idna_status::disallowed },
  { U'\x110fa', U'\x110ff', idna_status::disallowed },
  { U'\x11135', U'\x11135', idna_status::disallowed },
  { U'\x11147', U'\x1114f', idna_status::disallowed },
  { U'\x11177', U'\x1117f', idna_status::disallowed },
  { U'\x111ce', U'\x111cf', idna_status::disallowed },
  { U'\x111e0', U'\x111e0', idna_status::disallowed },
  { U'\x111f5', U'\x111ff', idna_status::disallowed },
  { U'\x11212', U'\x11212', idna_status::disallowed },
  { U'\x1123f', U'\x1127f', idna_status::disallowed },
  { U'\x11287', U'\x11287', idna_status::disallowed },
  { U'\x11289', U'\x11289', idna_status::disallowed },
  { U'\x1128e', U'\x1128e', idna_status::disallowed },
  { U'\x1129e', U'\x1129e', idna_status::disallowed },
  { U'\x112aa', U'\x112af', idna_status::disallowed },
  { U'\x112eb', U'\x112ef', idna_status::disallowed },
  { U'\x112fa', U'\x112ff', idna_status::disallowed },
  { U'\x11304', U'\x11304', idna_status::disallowed },
  { U'\x1130d', U'\x1130e', idna_status::disallowed },
  { U'\x11311', U'\x11312', idna_status::disallowed },
  { U'\x11329', U'\x11329', idna_status::disallowed },
  { U'\x11331', U'\x11331', idna_status::disallowed },
  { U'\x11334', U'\x11334', idna_status::disallowed },
  { U'\x1133a', U'\x1133a', idna_status::disallowed },
  { U'\x11345', U'\x11346', idna_status::disallowed },
  { U'\x11349', U'\x1134a', idna_status::disallowed },
  { U'\x1134e', U'\x1134f', idna_status::disallowed },
  { U'\x11351', U'\x11356', idna_status::disallowed },
  { U'\x11358', U'\x1135c', idna_status::disallowed },
  { U'\x11364', U'\x11365', idna_status::disallowed },
  { U'\x1136d', U'\x1136f', idna_status::disallowed },
  { U'\x11375', U'\x113ff', idna_status::disallowed },
  { U'\x1145a', U'\x1145a', idna_status::disallowed },
  { U'\x1145c', U'\x1145c', idna_status::disallowed },
  { U'\x11460', U'\x1147f', idna_status::disallowed },
  { U'\x114c8', U'\x114cf', idna_status::disallowed },
  { U'\x114da', U'\x1157f', idna_status::disallowed },
  { U'\x115b6', U'\x115b7', idna_status::disallowed },
  { U'\x115de', U'\x115ff', idna_status::disallowed },
  { U'\x11645', U'\x1164f', idna_status::disallowed },
  { U'\x1165a', U'\x1165f', idna_status::disallowed },
  { U'\x1166d', U'\x1167f', idna_status::disallowed },
  { U'\x116b9', U'\x116bf', idna_status::disallowed },
  { U'\x116ca', U'\x116ff', idna_status::disallowed },
  { U'\x1171b', U'\x1171c', idna_status::disallowed },
  { U'\x1172c', U'\x1172f', idna_status::disallowed },
  { U'\x11740', U'\x117ff', idna_status::disallowed },
  { U'\x1183c', U'\x1189f', idna_status::disallowed },
  { U'\x118a0', U'\x118bf', idna_status::mapped },
  { U'\x118f3', U'\x118fe', idna_status::disallowed },
  { U'\x11900', U'\x1199f', idna_status::disallowed },
  { U'\x119a8', U'\x119a9', idna_status::disallowed },
  { U'\x119d8', U'\x119d9', idna_status::disallowed },
  { U'\x119e5', U'\x119ff', idna_status::disallowed },
  { U'\x11a48', U'\x11a4f', idna_status::disallowed },
  { U'\x11aa3', U'\x11abf', idna_status::disallowed },
  { U'\x11af9', U'\x11bff', idna_status::disallowed },
  { U'\x11c09', U'\x11c09', idna_status::disallowed },
  { U'\x11c37', U'\x11c37', idna_status::disallowed },
  { U'\x11c46', U'\x11c4f', idna_status::disallowed },
  { U'\x11c6d', U'\x11c6f', idna_status::disallowed },
  { U'\x11c90', U'\x11c91', idna_status::disallowed },
  { U'\x11ca8', U'\x11ca8', idna_status::disallowed },
  { U'\x11cb7', U'\x11cff', idna_status::disallowed },
  { U'\x11d07', U'\x11d07', idna_status::disallowed },
  { U'\x11d0a', U'\x11d0a', idna_status::disallowed },
  { U'\x11d37', U'\x11d39', idna_status::disallowed },
  { U'\x11d3b', U'\x11d3b', idna_status::disallowed },
  { U'\x11d3e', U'\x11d3e', idna_status::disallowed },
  { U'\x11d48', U'\x11d4f', idna_status::disallowed },
  { U'\x11d5a', U'\x11d5f', idna_status::disallowed },
  { U'\x11d66', U'\x11d66', idna_status::disallowed },
  { U'\x11d69', U'\x11d69', idna_status::disallowed },
  { U'\x11d8f', U'\x11d8f', idna_status::disallowed },
  { U'\x11d92', U'\x11d92', idna_status::disallowed },
  { U'\x11d99', U'\x11d9f', idna_status::disallowed },
  { U'\x11daa', U'\x11edf', idna_status::disallowed },
  { U'\x11ef9', U'\x11fbf', idna_status::disallowed },
  { U'\x11ff2', U'\x11ffe', idna_status::disallowed },
  { U'\x1239a', U'\x123ff', idna_status::disallowed },
  { U'\x1246f', U'\x1246f', idna_status::disallowed },
  { U'\x12475', U'\x1247f', idna_status::disallowed },
  { U'\x12544', U'\x12fff', idna_status::disallowed },
  { U'\x1342f', U'\x143ff', idna_status::disallowed },
  { U'\x14647', U'\x167ff', idna_status::disallowed },
  { U'\x16a39', U'\x16a3f', idna_status::disallowed },
  { U'\x16a5f', U'\x16a5f', idna_status::disallowed },
  { U'\x16a6a', U'\x16a6d', idna_status::disallowed },
  { U'\x16a70', U'\x16acf', idna_status::disallowed },
  { U'\x16aee', U'\x16aef', idna_status::disallowed },
  { U'\x16af6', U'\x16aff', idna_status::disallowed },
  { U'\x16b46', U'\x16b4f', idna_status::disallowed },
  { U'\x16b5a', U'\x16b5a', idna_status::disallowed },
  { U'\x16b62', U'\x16b62', idna_status::disallowed },
  { U'\x16b78', U'\x16b7c', idna_status::disallowed },
  { U'\x16b90', U'\x16e3f', idna_status::disallowed },
  { U'\x16e40', U'\x16e5f', idna_status::mapped },
  { U'\x16e9b', U'\x16eff', idna_status::disallowed },
  { U'\x16f4b', U'\x16f4e', idna_status::disallowed },
  { U'\x16f88', U'\x16f8e', idna_status::disallowed },
  { U'\x16fa0', U'\x16fdf', idna_status::disallowed },
  { U'\x16fe4', U'\x16fff', idna_status::disallowed },
  { U'\x187f8', U'\x187ff', idna_status::disallowed },
  { U'\x18af3', U'\x1afff', idna_status::disallowed },
  { U'\x1b11f', U'\x1b14f', idna_status::disallowed },
  { U'\x1b153', U'\x1b163', idna_status::disallowed },
  { U'\x1b168', U'\x1b16f', idna_status::disallowed },
  { U'\x1b2fc', U'\x1bbff', idna_status::disallowed },
  { U'\x1bc6b', U'\x1bc6f', idna_status::disallowed },
  { U'\x1bc7d', U'\x1bc7f', idna_status::disallowed },
  { U'\x1bc89', U'\x1bc8f', idna_status::disallowed },
  { U'\x1bc9a', U'\x1bc9b', idna_status::disallowed },
  { U'\x1bca0', U'\x1bca3', idna_status::ignored },
  { U'\x1bca4', U'\x1cfff', idna_status::disallowed },
  { U'\x1d0f6', U'\x1d0ff', idna_status::disallowed },
  { U'\x1d127', U'\x1d128', idna_status::disallowed },
  { U'\x1d15e', U'\x1d164', idna_status::mapped },
  { U'\x1d173', U'\x1d17a', idna_status::disallowed },
  { U'\x1d1bb', U'\x1d1c0', idna_status::mapped },
  { U'\x1d1e9', U'\x1d1ff', idna_status::disallowed },
  { U'\x1d246', U'\x1d2df', idna_status::disallowed },
  { U'\x1d2f4', U'\x1d2ff', idna_status::disallowed },
  { U'\x1d357', U'\x1d35f', idna_status::disallowed },
  { U'\x1d379', U'\x1d3ff', idna_status::disallowed },
  { U'\x1d400', U'\x1d454', idna_status::mapped },
  { U'\x1d455', U'\x1d455', idna_status::disallowed },
  { U'\x1d456', U'\x1d49c', idna_status::mapped },
  { U'\x1d49d', U'\x1d49d', idna_status::disallowed },
  { U'\x1d49e', U'\x1d49f', idna_status::mapped },
  { U'\x1d4a0', U'\x1d4a1', idna_status::disallowed },
  { U'\x1d4a2', U'\x1d4a2', idna_status::mapped },
  { U'\x1d4a3', U'\x1d4a4', idna_status::disallowed },
  { U'\x1d4a5', U'\x1d4a6', idna_status::mapped },
  { U'\x1d4a7', U'\x1d4a8', idna_status::disallowed },
  { U'\x1d4a9', U'\x1d4ac', idna_status::mapped },
  { U'\x1d4ad', U'\x1d4ad', idna_status::disallowed },
  { U'\x1d4ae', U'\x1d4b9', idna_status::mapped },
  { U'\x1d4ba', U'\x1d4ba', idna_status::disallowed },
  { U'\x1d4bb', U'\x1d4bb', idna_status::mapped },
  { U'\x1d4bc', U'\x1d4bc', idna_status::disallowed },
  { U'\x1d4bd', U'\x1d4c3', idna_status::mapped },
  { U'\x1d4c4', U'\x1d4c4', idna_status::disallowed },
  { U'\x1d4c5', U'\x1d505', idna_status::mapped },
  { U'\x1d506', U'\x1d506', idna_status::disallowed },
  { U'\x1d507', U'\x1d50a', idna_status::mapped },
  { U'\x1d50b', U'\x1d50c', idna_status::disallowed },
  { U'\x1d50d', U'\x1d514', idna_status::mapped },
  { U'\x1d515', U'\x1d515', idna_status::disallowed },
  { U'\x1d516', U'\x1d51c', idna_status::mapped },
  { U'\x1d51d', U'\x1d51d', idna_status::disallowed },
  { U'\x1d51e', U'\x1d539', idna_status::mapped },
  { U'\x1d53a', U'\x1d53a', idna_status::disallowed },
  { U'\x1d53b', U'\x1d53e', idna_status::mapped },
  { U'\x1d53f', U'\x1d53f', idna_status::disallowed },
  { U'\x1d540', U'\x1d544', idna_status::mapped },
  { U'\x1d545', U'\x1d545', idna_status::disallowed },
  { U'\x1d546', U'\x1d546', idna_status::mapped },
  { U'\x1d547', U'\x1d549', idna_status::disallowed },
  { U'\x1d54a', U'\x1d550', idna_status::mapped },
  { U'\x1d551', U'\x1d551', idna_status::disallowed },
  { U'\x1d552', U'\x1d6a5', idna_status::mapped },
  { U'\x1d6a6', U'\x1d6a7', idna_status::disallowed },
  { U'\x1d6a8', U'\x1d7cb', idna_status::mapped },
  { U'\x1d7cc', U'\x1d7cd', idna_status::disallowed },
  { U'\x1d7ce', U'\x1d7ff', idna_status::mapped },
  { U'\x1da8c', U'\x1da9a', idna_status::disallowed },
  { U'\x1daa0', U'\x1daa0', idna_status::disallowed },
  { U'\x1dab0', U'\x1dfff', idna_status::disallowed },
  { U'\x1e007', U'\x1e007', idna_status::disallowed },
  { U'\x1e019', U'\x1e01a', idna_status::disallowed },
  { U'\x1e022', U'\x1e022', idna_status::disallowed },
  { U'\x1e025', U'\x1e025', idna_status::disallowed },
  { U'\x1e02b', U'\x1e0ff', idna_status::disallowed },
  { U'\x1e12d', U'\x1e12f', idna_status::disallowed },
  { U'\x1e13e', U'\x1e13f', idna_status::disallowed },
  { U'\x1e14a', U'\x1e14d', idna_status::disallowed },
  { U'\x1e150', U'\x1e2bf', idna_status::disallowed },
  { U'\x1e2fa', U'\x1e2fe', idna_status::disallowed },
  { U'\x1e300', U'\x1e7ff', idna_status::disallowed },
  { U'\x1e8c5', U'\x1e8c6', idna_status::disallowed },
  { U'\x1e8d7', U'\x1e8ff', idna_status::disallowed },
  { U'\x1e900', U'\x1e921', idna_status::mapped },
  { U'\x1e94c', U'\x1e94f', idna_status::disallowed },
  { U'\x1e95a', U'\x1e95d', idna_status::disallowed },
  { U'\x1e960', U'\x1ec70', idna_status::disallowed },
  { U'\x1ecb5', U'\x1ed00', idna_status::disallowed },
  { U'\x1ed3e', U'\x1edff', idna_status::disallowed },
  { U'\x1ee00', U'\x1ee03', idna_status::mapped },
  { U'\x1ee04', U'\x1ee04', idna_status::disallowed },
  { U'\x1ee05', U'\x1ee1f', idna_status::mapped },
  { U'\x1ee20', U'\x1ee20', idna_status::disallowed },
  { U'\x1ee21', U'\x1ee22', idna_status::mapped },
  { U'\x1ee23', U'\x1ee23', idna_status::disallowed },
  { U'\x1ee24', U'\x1ee24', idna_status::mapped },
  { U'\x1ee25', U'\x1ee26', idna_status::disallowed },
  { U'\x1ee27', U'\x1ee27', idna_status::mapped },
  { U'\x1ee28', U'\x1ee28', idna_status::disallowed },
  { U'\x1ee29', U'\x1ee32', idna_status::mapped },
  { U'\x1ee33', U'\x1ee33', idna_status::disallowed },
  { U'\x1ee34', U'\x1ee37', idna_status::mapped },
  { U'\x1ee38', U'\x1ee38', idna_status::disallowed },
  { U'\x1ee39', U'\x1ee39', idna_status::mapped },
  { U'\x1ee3a', U'\x1ee3a', idna_status::disallowed },
  { U'\x1ee3b', U'\x1ee3b', idna_status::mapped },
  { U'\x1ee3c', U'\x1ee41', idna_status::disallowed },
  { U'\x1ee42', U'\x1ee42', idna_status::mapped },
  { U'\x1ee43', U'\x1ee46', idna_status::disallowed },
  { U'\x1ee47', U'\x1ee47', idna_status::mapped },
  { U'\x1ee48', U'\x1ee48', idna_status::disallowed },
  { U'\x1ee49', U'\x1ee49', idna_status::mapped },
  { U'\x1ee4a', U'\x1ee4a', idna_status::disallowed },
  { U'\x1ee4b', U'\x1ee4b', idna_status::mapped },
  { U'\x1ee4c', U'\x1ee4c', idna_status::disallowed },
  { U'\x1ee4d', U'\x1ee4f', idna_status::mapped },
  { U'\x1ee50', U'\x1ee50', idna_status::disallowed },
  { U'\x1ee51', U'\x1ee52', idna_status::mapped },
  { U'\x1ee53', U'\x1ee53', idna_status::disallowed },
  { U'\x1ee54', U'\x1ee54', idna_status::mapped },
  { U'\x1ee55', U'\x1ee56', idna_status::disallowed },
  { U'\x1ee57', U'\x1ee57', idna_status::mapped },
  { U'\x1ee58', U'\x1ee58', idna_status::disallowed },
  { U'\x1ee59', U'\x1ee59', idna_status::mapped },
  { U'\x1ee5a', U'\x1ee5a', idna_status::disallowed },
  { U'\x1ee5b', U'\x1ee5b', idna_status::mapped },
  { U'\x1ee5c', U'\x1ee5c', idna_status::disallowed },
  { U'\x1ee5d', U'\x1ee5d', idna_status::mapped },
  { U'\x1ee5e', U'\x1ee5e', idna_status::disallowed },
  { U'\x1ee5f', U'\x1ee5f', idna_status::mapped },
  { U'\x1ee60', U'\x1ee60', idna_status::disallowed },
  { U'\x1ee61', U'\x1ee62', idna_status::mapped },
  { U'\x1ee63', U'\x1ee63', idna_status::disallowed },
  { U'\x1ee64', U'\x1ee64', idna_status::mapped },
  { U'\x1ee65', U'\x1ee66', idna_status::disallowed },
  { U'\x1ee67', U'\x1ee6a', idna_status::mapped },
  { U'\x1ee6b', U'\x1ee6b', idna_status::disallowed },
  { U'\x1ee6c', U'\x1ee72', idna_status::mapped },
  { U'\x1ee73', U'\x1ee73', idna_status::disallowed },
  { U'\x1ee74', U'\x1ee77', idna_status::mapped },
  { U'\x1ee78', U'\x1ee78', idna_status::disallowed },
  { U'\x1ee79', U'\x1ee7c', idna_status::mapped },
  { U'\x1ee7d', U'\x1ee7d', idna_status::disallowed },
  { U'\x1ee7e', U'\x1ee7e', idna_status::mapped },
  { U'\x1ee7f', U'\x1ee7f', idna_status::disallowed },
  { U'\x1ee80', U'\x1ee89', idna_status::mapped },
  { U'\x1ee8a', U'\x1ee8a', idna_status::disallowed },
  { U'\x1ee8b', U'\x1ee9b', idna_status::mapped },
  { U'\x1ee9c', U'\x1eea0', idna_status::disallowed },
  { U'\x1eea1', U'\x1eea3', idna_status::mapped },
  { U'\x1eea4', U'\x1eea4', idna_status::disallowed },
  { U'\x1eea5', U'\x1eea9', idna_status::mapped },
  { U'\x1eeaa', U'\x1eeaa', idna_status::disallowed },
  { U'\x1eeab', U'\x1eebb', idna_status::mapped },
  { U'\x1eebc', U'\x1eeef', idna_status::disallowed },
  { U'\x1eef2', U'\x1efff', idna_status::disallowed },
  { U'\x1f02c', U'\x1f02f', idna_status::disallowed },
  { U'\x1f094', U'\x1f09f', idna_status::disallowed },
  { U'\x1f0af', U'\x1f0b0', idna_status::disallowed },
  { U'\x1f0c0', U'\x1f0c0', idna_status::disallowed },
  { U'\x1f0d0', U'\x1f0d0', idna_status::disallowed },
  { U'\x1f0f6', U'\x1f100', idna_status::disallowed },
  { U'\x1f101', U'\x1f10a', idna_status::disallowed_std3_mapped },
  { U'\x1f10d', U'\x1f10f', idna_status::disallowed },
  { U'\x1f110', U'\x1f129', idna_status::disallowed_std3_mapped },
  { U'\x1f12a', U'\x1f12e', idna_status::mapped },
  { U'\x1f130', U'\x1f14f', idna_status::mapped },
  { U'\x1f16a', U'\x1f16c', idna_status::mapped },
  { U'\x1f16d', U'\x1f16f', idna_status::disallowed },
  { U'\x1f190', U'\x1f190', idna_status::mapped },
  { U'\x1f1ad', U'\x1f1e5', idna_status::disallowed },
  { U'\x1f200', U'\x1f202', idna_status::mapped },
  { U'\x1f203', U'\x1f20f', idna_status::disallowed },
  { U'\x1f210', U'\x1f23b', idna_status::mapped },
  { U'\x1f23c', U'\x1f23f', idna_status::disallowed },
  { U'\x1f240', U'\x1f248', idna_status::mapped },
  { U'\x1f249', U'\x1f24f', idna_status::disallowed },
  { U'\x1f250', U'\x1f251', idna_status::mapped },
  { U'\x1f252', U'\x1f25f', idna_status::disallowed },
  { U'\x1f266', U'\x1f2ff', idna_status::disallowed },
  { U'\x1f6d6', U'\x1f6df', idna_status::disallowed },
  { U'\x1f6ed', U'\x1f6ef', idna_status::disallowed },
  { U'\x1f6fb', U'\x1f6ff', idna_status::disallowed },
  { U'\x1f774', U'\x1f77f', idna_status::disallowed },
  { U'\x1f7d9', U'\x1f7df', idna_status::disallowed },
  { U'\x1f7ec', U'\x1f7ff', idna_status::disallowed },
  { U'\x1f80c', U'\x1f80f', idna_status::disallowed },
  { U'\x1f848', U'\x1f84f', idna_status::disallowed },
  { U'\x1f85a', U'\x1f85f', idna_status::disallowed },
  { U'\x1f888', U'\x1f88f', idna_status::disallowed },
  { U'\x1f8ae', U'\x1f8ff', idna_status::disallowed },
  { U'\x1f90c', U'\x1f90c', idna_status::disallowed },
  { U'\x1f972', U'\x1f972', idna_status::disallowed },
  { U'\x1f977', U'\x1f979', idna_status::disallowed },
  { U'\x1f9a3', U'\x1f9a4', idna_status::disallowed },
  { U'\x1f9ab', U'\x1f9ad', idna_status::disallowed },
  { U'\x1f9cb', U'\x1f9cc', idna_status::disallowed },
  { U'\x1fa54', U'\x1fa5f', idna_status::disallowed },
  { U'\x1fa6e', U'\x1fa6f', idna_status::disallowed },
  { U'\x1fa74', U'\x1fa77', idna_status::disallowed },
  { U'\x1fa7b', U'\x1fa7f', idna_status::disallowed },
  { U'\x1fa83', U'\x1fa8f', idna_status::disallowed },
  { U'\x1fa96', U'\x1ffff', idna_status::disallowed },
  { U'\x2a6d7', U'\x2a6ff', idna_status::disallowed },
  { U'\x2b735', U'\x2b73f', idna_status::disallowed },
  { U'\x2b81e', U'\x2b81f', idna_status::disallowed },
  { U'\x2cea2', U'\x2ceaf', idna_status::disallowed },
  { U'\x2ebe1', U'\x2f7ff', idna_status::disallowed },
  { U'\x2f800', U'\x2f867', idna_status::mapped },
  { U'\x2f868', U'\x2f868', idna_status::disallowed },
  { U'\x2f869', U'\x2f873', idna_status::mapped },
  { U'\x2f874', U'\x2f874', idna_status::disallowed },
  { U'\x2f875', U'\x2f91e', idna_status::mapped },
  { U'\x2f91f', U'\x2f91f', idna_status::disallowed },
  { U'\x2f920', U'\x2f95e', idna_status::mapped },
  { U'\x2f95f', U'\x2f95f', idna_status::disallowed },
  { U'\x2f960', U'\x2f9be', idna_status::mapped },
  { U'\x2f9bf', U'\x2f9bf', idna_status::disallowed },
  { U'\x2f9c0', U'\x2fa1d', idna_status::mapped },
  { U'\x2fa1e', U'\xe00ff', idna_status::disallowed },
  { U'\xe0100', U'\xe01ef', idna_status::ignored },
  { U'\xe01f0', U'\x10ffff', idna_status::disallowed },
}};
}  // namespace

auto code_point_status(char32_t code_point) -> idna_status {
  constexpr static auto less = [] (const auto &range, auto code_point) {
    return range.last < code_point;
  };

  auto first = std::begin(statuses), last = std::end(statuses);
  auto it = std::lower_bound(first, last, code_point, less);
  return (it == last) || !((code_point >= (*it).first) && (code_point <= (*it).last)) ? idna_status::valid : it->status;
}

namespace {
struct mapped_16_code_point {
  char16_t code_point;
  char16_t mapped;
};

constexpr static auto mapped_16 = std::array<mapped_16_code_point, 3773>{{
  { U'\x0041', U'\x0061' },
  { U'\x0042', U'\x0062' },
  { U'\x0043', U'\x0063' },
  { U'\x0044', U'\x0064' },
  { U'\x0045', U'\x0065' },
  { U'\x0046', U'\x0066' },
  { U'\x0047', U'\x0067' },
  { U'\x0048', U'\x0068' },
  { U'\x0049', U'\x0069' },
  { U'\x004a', U'\x006a' },
  { U'\x004b', U'\x006b' },
  { U'\x004c', U'\x006c' },
  { U'\x004d', U'\x006d' },
  { U'\x004e', U'\x006e' },
  { U'\x004f', U'\x006f' },
  { U'\x0050', U'\x0070' },
  { U'\x0051', U'\x0071' },
  { U'\x0052', U'\x0072' },
  { U'\x0053', U'\x0073' },
  { U'\x0054', U'\x0074' },
  { U'\x0055', U'\x0075' },
  { U'\x0056', U'\x0076' },
  { U'\x0057', U'\x0077' },
  { U'\x0058', U'\x0078' },
  { U'\x0059', U'\x0079' },
  { U'\x005a', U'\x007a' },
  { U'\x00a0', U'\x0020' },
  { U'\x00a8', U'\x0020' },
  { U'\x00aa', U'\x0061' },
  { U'\x00af', U'\x0020' },
  { U'\x00b2', U'\x0032' },
  { U'\x00b3', U'\x0033' },
  { U'\x00b4', U'\x0020' },
  { U'\x00b5', U'\x03bc' },
  { U'\x00b8', U'\x0020' },
  { U'\x00b9', U'\x0031' },
  { U'\x00ba', U'\x006f' },
  { U'\x00bc', U'\x0031' },
  { U'\x00bd', U'\x0031' },
  { U'\x00be', U'\x0033' },
  { U'\x00c0', U'\x00e0' },
  { U'\x00c1', U'\x00e1' },
  { U'\x00c2', U'\x00e2' },
  { U'\x00c3', U'\x00e3' },
  { U'\x00c4', U'\x00e4' },
  { U'\x00c5', U'\x00e5' },
  { U'\x00c6', U'\x00e6' },
  { U'\x00c7', U'\x00e7' },
  { U'\x00c8', U'\x00e8' },
  { U'\x00c9', U'\x00e9' },
  { U'\x00ca', U'\x00ea' },
  { U'\x00cb', U'\x00eb' },
  { U'\x00cc', U'\x00ec' },
  { U'\x00cd', U'\x00ed' },
  { U'\x00ce', U'\x00ee' },
  { U'\x00cf', U'\x00ef' },
  { U'\x00d0', U'\x00f0' },
  { U'\x00d1', U'\x00f1' },
  { U'\x00d2', U'\x00f2' },
  { U'\x00d3', U'\x00f3' },
  { U'\x00d4', U'\x00f4' },
  { U'\x00d5', U'\x00f5' },
  { U'\x00d6', U'\x00f6' },
  { U'\x00d8', U'\x00f8' },
  { U'\x00d9', U'\x00f9' },
  { U'\x00da', U'\x00fa' },
  { U'\x00db', U'\x00fb' },
  { U'\x00dc', U'\x00fc' },
  { U'\x00dd', U'\x00fd' },
  { U'\x00de', U'\x00fe' },
  { U'\x0100', U'\x0101' },
  { U'\x0102', U'\x0103' },
  { U'\x0104', U'\x0105' },
  { U'\x0106', U'\x0107' },
  { U'\x0108', U'\x0109' },
  { U'\x010a', U'\x010b' },
  { U'\x010c', U'\x010d' },
  { U'\x010e', U'\x010f' },
  { U'\x0110', U'\x0111' },
  { U'\x0112', U'\x0113' },
  { U'\x0114', U'\x0115' },
  { U'\x0116', U'\x0117' },
  { U'\x0118', U'\x0119' },
  { U'\x011a', U'\x011b' },
  { U'\x011c', U'\x011d' },
  { U'\x011e', U'\x011f' },
  { U'\x0120', U'\x0121' },
  { U'\x0122', U'\x0123' },
  { U'\x0124', U'\x0125' },
  { U'\x0126', U'\x0127' },
  { U'\x0128', U'\x0129' },
  { U'\x012a', U'\x012b' },
  { U'\x012c', U'\x012d' },
  { U'\x012e', U'\x012f' },
  { U'\x0130', U'\x0069' },
  { U'\x0132', U'\x0069' },
  { U'\x0134', U'\x0135' },
  { U'\x0136', U'\x0137' },
  { U'\x0139', U'\x013a' },
  { U'\x013b', U'\x013c' },
  { U'\x013d', U'\x013e' },
  { U'\x013f', U'\x006c' },
  { U'\x0141', U'\x0142' },
  { U'\x0143', U'\x0144' },
  { U'\x0145', U'\x0146' },
  { U'\x0147', U'\x0148' },
  { U'\x0149', U'\x02bc' },
  { U'\x014a', U'\x014b' },
  { U'\x014c', U'\x014d' },
  { U'\x014e', U'\x014f' },
  { U'\x0150', U'\x0151' },
  { U'\x0152', U'\x0153' },
  { U'\x0154', U'\x0155' },
  { U'\x0156', U'\x0157' },
  { U'\x0158', U'\x0159' },
  { U'\x015a', U'\x015b' },
  { U'\x015c', U'\x015d' },
  { U'\x015e', U'\x015f' },
  { U'\x0160', U'\x0161' },
  { U'\x0162', U'\x0163' },
  { U'\x0164', U'\x0165' },
  { U'\x0166', U'\x0167' },
  { U'\x0168', U'\x0169' },
  { U'\x016a', U'\x016b' },
  { U'\x016c', U'\x016d' },
  { U'\x016e', U'\x016f' },
  { U'\x0170', U'\x0171' },
  { U'\x0172', U'\x0173' },
  { U'\x0174', U'\x0175' },
  { U'\x0176', U'\x0177' },
  { U'\x0178', U'\x00ff' },
  { U'\x0179', U'\x017a' },
  { U'\x017b', U'\x017c' },
  { U'\x017d', U'\x017e' },
  { U'\x017f', U'\x0073' },
  { U'\x0181', U'\x0253' },
  { U'\x0182', U'\x0183' },
  { U'\x0184', U'\x0185' },
  { U'\x0186', U'\x0254' },
  { U'\x0187', U'\x0188' },
  { U'\x0189', U'\x0256' },
  { U'\x018a', U'\x0257' },
  { U'\x018b', U'\x018c' },
  { U'\x018e', U'\x01dd' },
  { U'\x018f', U'\x0259' },
  { U'\x0190', U'\x025b' },
  { U'\x0191', U'\x0192' },
  { U'\x0193', U'\x0260' },
  { U'\x0194', U'\x0263' },
  { U'\x0196', U'\x0269' },
  { U'\x0197', U'\x0268' },
  { U'\x0198', U'\x0199' },
  { U'\x019c', U'\x026f' },
  { U'\x019d', U'\x0272' },
  { U'\x019f', U'\x0275' },
  { U'\x01a0', U'\x01a1' },
  { U'\x01a2', U'\x01a3' },
  { U'\x01a4', U'\x01a5' },
  { U'\x01a6', U'\x0280' },
  { U'\x01a7', U'\x01a8' },
  { U'\x01a9', U'\x0283' },
  { U'\x01ac', U'\x01ad' },
  { U'\x01ae', U'\x0288' },
  { U'\x01af', U'\x01b0' },
  { U'\x01b1', U'\x028a' },
  { U'\x01b2', U'\x028b' },
  { U'\x01b3', U'\x01b4' },
  { U'\x01b5', U'\x01b6' },
  { U'\x01b7', U'\x0292' },
  { U'\x01b8', U'\x01b9' },
  { U'\x01bc', U'\x01bd' },
  { U'\x01c4', U'\x0064' },
  { U'\x01c7', U'\x006c' },
  { U'\x01ca', U'\x006e' },
  { U'\x01cd', U'\x01ce' },
  { U'\x01cf', U'\x01d0' },
  { U'\x01d1', U'\x01d2' },
  { U'\x01d3', U'\x01d4' },
  { U'\x01d5', U'\x01d6' },
  { U'\x01d7', U'\x01d8' },
  { U'\x01d9', U'\x01da' },
  { U'\x01db', U'\x01dc' },
  { U'\x01de', U'\x01df' },
  { U'\x01e0', U'\x01e1' },
  { U'\x01e2', U'\x01e3' },
  { U'\x01e4', U'\x01e5' },
  { U'\x01e6', U'\x01e7' },
  { U'\x01e8', U'\x01e9' },
  { U'\x01ea', U'\x01eb' },
  { U'\x01ec', U'\x01ed' },
  { U'\x01ee', U'\x01ef' },
  { U'\x01f1', U'\x0064' },
  { U'\x01f4', U'\x01f5' },
  { U'\x01f6', U'\x0195' },
  { U'\x01f7', U'\x01bf' },
  { U'\x01f8', U'\x01f9' },
  { U'\x01fa', U'\x01fb' },
  { U'\x01fc', U'\x01fd' },
  { U'\x01fe', U'\x01ff' },
  { U'\x0200', U'\x0201' },
  { U'\x0202', U'\x0203' },
  { U'\x0204', U'\x0205' },
  { U'\x0206', U'\x0207' },
  { U'\x0208', U'\x0209' },
  { U'\x020a', U'\x020b' },
  { U'\x020c', U'\x020d' },
  { U'\x020e', U'\x020f' },
  { U'\x0210', U'\x0211' },
  { U'\x0212', U'\x0213' },
  { U'\x0214', U'\x0215' },
  { U'\x0216', U'\x0217' },
  { U'\x0218', U'\x0219' },
  { U'\x021a', U'\x021b' },
  { U'\x021c', U'\x021d' },
  { U'\x021e', U'\x021f' },
  { U'\x0220', U'\x019e' },
  { U'\x0222', U'\x0223' },
  { U'\x0224', U'\x0225' },
  { U'\x0226', U'\x0227' },
  { U'\x0228', U'\x0229' },
  { U'\x022a', U'\x022b' },
  { U'\x022c', U'\x022d' },
  { U'\x022e', U'\x022f' },
  { U'\x0230', U'\x0231' },
  { U'\x0232', U'\x0233' },
  { U'\x023a', U'\x2c65' },
  { U'\x023b', U'\x023c' },
  { U'\x023d', U'\x019a' },
  { U'\x023e', U'\x2c66' },
  { U'\x0241', U'\x0242' },
  { U'\x0243', U'\x0180' },
  { U'\x0244', U'\x0289' },
  { U'\x0245', U'\x028c' },
  { U'\x0246', U'\x0247' },
  { U'\x0248', U'\x0249' },
  { U'\x024a', U'\x024b' },
  { U'\x024c', U'\x024d' },
  { U'\x024e', U'\x024f' },
  { U'\x02b0', U'\x0068' },
  { U'\x02b1', U'\x0266' },
  { U'\x02b2', U'\x006a' },
  { U'\x02b3', U'\x0072' },
  { U'\x02b4', U'\x0279' },
  { U'\x02b5', U'\x027b' },
  { U'\x02b6', U'\x0281' },
  { U'\x02b7', U'\x0077' },
  { U'\x02b8', U'\x0079' },
  { U'\x02d8', U'\x0020' },
  { U'\x02d9', U'\x0020' },
  { U'\x02da', U'\x0020' },
  { U'\x02db', U'\x0020' },
  { U'\x02dc', U'\x0020' },
  { U'\x02dd', U'\x0020' },
  { U'\x02e0', U'\x0263' },
  { U'\x02e1', U'\x006c' },
  { U'\x02e2', U'\x0073' },
  { U'\x02e3', U'\x0078' },
  { U'\x02e4', U'\x0295' },
  { U'\x0340', U'\x0300' },
  { U'\x0341', U'\x0301' },
  { U'\x0343', U'\x0313' },
  { U'\x0344', U'\x0308' },
  { U'\x0345', U'\x03b9' },
  { U'\x0370', U'\x0371' },
  { U'\x0372', U'\x0373' },
  { U'\x0374', U'\x02b9' },
  { U'\x0376', U'\x0377' },
  { U'\x037a', U'\x0020' },
  { U'\x037e', U'\x003b' },
  { U'\x037f', U'\x03f3' },
  { U'\x0384', U'\x0020' },
  { U'\x0385', U'\x0020' },
  { U'\x0386', U'\x03ac' },
  { U'\x0387', U'\x00b7' },
  { U'\x0388', U'\x03ad' },
  { U'\x0389', U'\x03ae' },
  { U'\x038a', U'\x03af' },
  { U'\x038c', U'\x03cc' },
  { U'\x038e', U'\x03cd' },
  { U'\x038f', U'\x03ce' },
  { U'\x0391', U'\x03b1' },
  { U'\x0392', U'\x03b2' },
  { U'\x0393', U'\x03b3' },
  { U'\x0394', U'\x03b4' },
  { U'\x0395', U'\x03b5' },
  { U'\x0396', U'\x03b6' },
  { U'\x0397', U'\x03b7' },
  { U'\x0398', U'\x03b8' },
  { U'\x0399', U'\x03b9' },
  { U'\x039a', U'\x03ba' },
  { U'\x039b', U'\x03bb' },
  { U'\x039c', U'\x03bc' },
  { U'\x039d', U'\x03bd' },
  { U'\x039e', U'\x03be' },
  { U'\x039f', U'\x03bf' },
  { U'\x03a0', U'\x03c0' },
  { U'\x03a1', U'\x03c1' },
  { U'\x03a3', U'\x03c3' },
  { U'\x03a4', U'\x03c4' },
  { U'\x03a5', U'\x03c5' },
  { U'\x03a6', U'\x03c6' },
  { U'\x03a7', U'\x03c7' },
  { U'\x03a8', U'\x03c8' },
  { U'\x03a9', U'\x03c9' },
  { U'\x03aa', U'\x03ca' },
  { U'\x03ab', U'\x03cb' },
  { U'\x03cf', U'\x03d7' },
  { U'\x03d0', U'\x03b2' },
  { U'\x03d1', U'\x03b8' },
  { U'\x03d2', U'\x03c5' },
  { U'\x03d3', U'\x03cd' },
  { U'\x03d4', U'\x03cb' },
  { U'\x03d5', U'\x03c6' },
  { U'\x03d6', U'\x03c0' },
  { U'\x03d8', U'\x03d9' },
  { U'\x03da', U'\x03db' },
  { U'\x03dc', U'\x03dd' },
  { U'\x03de', U'\x03df' },
  { U'\x03e0', U'\x03e1' },
  { U'\x03e2', U'\x03e3' },
  { U'\x03e4', U'\x03e5' },
  { U'\x03e6', U'\x03e7' },
  { U'\x03e8', U'\x03e9' },
  { U'\x03ea', U'\x03eb' },
  { U'\x03ec', U'\x03ed' },
  { U'\x03ee', U'\x03ef' },
  { U'\x03f0', U'\x03ba' },
  { U'\x03f1', U'\x03c1' },
  { U'\x03f2', U'\x03c3' },
  { U'\x03f4', U'\x03b8' },
  { U'\x03f5', U'\x03b5' },
  { U'\x03f7', U'\x03f8' },
  { U'\x03f9', U'\x03c3' },
  { U'\x03fa', U'\x03fb' },
  { U'\x03fd', U'\x037b' },
  { U'\x03fe', U'\x037c' },
  { U'\x03ff', U'\x037d' },
  { U'\x0400', U'\x0450' },
  { U'\x0401', U'\x0451' },
  { U'\x0402', U'\x0452' },
  { U'\x0403', U'\x0453' },
  { U'\x0404', U'\x0454' },
  { U'\x0405', U'\x0455' },
  { U'\x0406', U'\x0456' },
  { U'\x0407', U'\x0457' },
  { U'\x0408', U'\x0458' },
  { U'\x0409', U'\x0459' },
  { U'\x040a', U'\x045a' },
  { U'\x040b', U'\x045b' },
  { U'\x040c', U'\x045c' },
  { U'\x040d', U'\x045d' },
  { U'\x040e', U'\x045e' },
  { U'\x040f', U'\x045f' },
  { U'\x0410', U'\x0430' },
  { U'\x0411', U'\x0431' },
  { U'\x0412', U'\x0432' },
  { U'\x0413', U'\x0433' },
  { U'\x0414', U'\x0434' },
  { U'\x0415', U'\x0435' },
  { U'\x0416', U'\x0436' },
  { U'\x0417', U'\x0437' },
  { U'\x0418', U'\x0438' },
  { U'\x0419', U'\x0439' },
  { U'\x041a', U'\x043a' },
  { U'\x041b', U'\x043b' },
  { U'\x041c', U'\x043c' },
  { U'\x041d', U'\x043d' },
  { U'\x041e', U'\x043e' },
  { U'\x041f', U'\x043f' },
  { U'\x0420', U'\x0440' },
  { U'\x0421', U'\x0441' },
  { U'\x0422', U'\x0442' },
  { U'\x0423', U'\x0443' },
  { U'\x0424', U'\x0444' },
  { U'\x0425', U'\x0445' },
  { U'\x0426', U'\x0446' },
  { U'\x0427', U'\x0447' },
  { U'\x0428', U'\x0448' },
  { U'\x0429', U'\x0449' },
  { U'\x042a', U'\x044a' },
  { U'\x042b', U'\x044b' },
  { U'\x042c', U'\x044c' },
  { U'\x042d', U'\x044d' },
  { U'\x042e', U'\x044e' },
  { U'\x042f', U'\x044f' },
  { U'\x0460', U'\x0461' },
  { U'\x0462', U'\x0463' },
  { U'\x0464', U'\x0465' },
  { U'\x0466', U'\x0467' },
  { U'\x0468', U'\x0469' },
  { U'\x046a', U'\x046b' },
  { U'\x046c', U'\x046d' },
  { U'\x046e', U'\x046f' },
  { U'\x0470', U'\x0471' },
  { U'\x0472', U'\x0473' },
  { U'\x0474', U'\x0475' },
  { U'\x0476', U'\x0477' },
  { U'\x0478', U'\x0479' },
  { U'\x047a', U'\x047b' },
  { U'\x047c', U'\x047d' },
  { U'\x047e', U'\x047f' },
  { U'\x0480', U'\x0481' },
  { U'\x048a', U'\x048b' },
  { U'\x048c', U'\x048d' },
  { U'\x048e', U'\x048f' },
  { U'\x0490', U'\x0491' },
  { U'\x0492', U'\x0493' },
  { U'\x0494', U'\x0495' },
  { U'\x0496', U'\x0497' },
  { U'\x0498', U'\x0499' },
  { U'\x049a', U'\x049b' },
  { U'\x049c', U'\x049d' },
  { U'\x049e', U'\x049f' },
  { U'\x04a0', U'\x04a1' },
  { U'\x04a2', U'\x04a3' },
  { U'\x04a4', U'\x04a5' },
  { U'\x04a6', U'\x04a7' },
  { U'\x04a8', U'\x04a9' },
  { U'\x04aa', U'\x04ab' },
  { U'\x04ac', U'\x04ad' },
  { U'\x04ae', U'\x04af' },
  { U'\x04b0', U'\x04b1' },
  { U'\x04b2', U'\x04b3' },
  { U'\x04b4', U'\x04b5' },
  { U'\x04b6', U'\x04b7' },
  { U'\x04b8', U'\x04b9' },
  { U'\x04ba', U'\x04bb' },
  { U'\x04bc', U'\x04bd' },
  { U'\x04be', U'\x04bf' },
  { U'\x04c1', U'\x04c2' },
  { U'\x04c3', U'\x04c4' },
  { U'\x04c5', U'\x04c6' },
  { U'\x04c7', U'\x04c8' },
  { U'\x04c9', U'\x04ca' },
  { U'\x04cb', U'\x04cc' },
  { U'\x04cd', U'\x04ce' },
  { U'\x04d0', U'\x04d1' },
  { U'\x04d2', U'\x04d3' },
  { U'\x04d4', U'\x04d5' },
  { U'\x04d6', U'\x04d7' },
  { U'\x04d8', U'\x04d9' },
  { U'\x04da', U'\x04db' },
  { U'\x04dc', U'\x04dd' },
  { U'\x04de', U'\x04df' },
  { U'\x04e0', U'\x04e1' },
  { U'\x04e2', U'\x04e3' },
  { U'\x04e4', U'\x04e5' },
  { U'\x04e6', U'\x04e7' },
  { U'\x04e8', U'\x04e9' },
  { U'\x04ea', U'\x04eb' },
  { U'\x04ec', U'\x04ed' },
  { U'\x04ee', U'\x04ef' },
  { U'\x04f0', U'\x04f1' },
  { U'\x04f2', U'\x04f3' },
  { U'\x04f4', U'\x04f5' },
  { U'\x04f6', U'\x04f7' },
  { U'\x04f8', U'\x04f9' },
  { U'\x04fa', U'\x04fb' },
  { U'\x04fc', U'\x04fd' },
  { U'\x04fe', U'\x04ff' },
  { U'\x0500', U'\x0501' },
  { U'\x0502', U'\x0503' },
  { U'\x0504', U'\x0505' },
  { U'\x0506', U'\x0507' },
  { U'\x0508', U'\x0509' },
  { U'\x050a', U'\x050b' },
  { U'\x050c', U'\x050d' },
  { U'\x050e', U'\x050f' },
  { U'\x0510', U'\x0511' },
  { U'\x0512', U'\x0513' },
  { U'\x0514', U'\x0515' },
  { U'\x0516', U'\x0517' },
  { U'\x0518', U'\x0519' },
  { U'\x051a', U'\x051b' },
  { U'\x051c', U'\x051d' },
  { U'\x051e', U'\x051f' },
  { U'\x0520', U'\x0521' },
  { U'\x0522', U'\x0523' },
  { U'\x0524', U'\x0525' },
  { U'\x0526', U'\x0527' },
  { U'\x0528', U'\x0529' },
  { U'\x052a', U'\x052b' },
  { U'\x052c', U'\x052d' },
  { U'\x052e', U'\x052f' },
  { U'\x0531', U'\x0561' },
  { U'\x0532', U'\x0562' },
  { U'\x0533', U'\x0563' },
  { U'\x0534', U'\x0564' },
  { U'\x0535', U'\x0565' },
  { U'\x0536', U'\x0566' },
  { U'\x0537', U'\x0567' },
  { U'\x0538', U'\x0568' },
  { U'\x0539', U'\x0569' },
  { U'\x053a', U'\x056a' },
  { U'\x053b', U'\x056b' },
  { U'\x053c', U'\x056c' },
  { U'\x053d', U'\x056d' },
  { U'\x053e', U'\x056e' },
  { U'\x053f', U'\x056f' },
  { U'\x0540', U'\x0570' },
  { U'\x0541', U'\x0571' },
  { U'\x0542', U'\x0572' },
  { U'\x0543', U'\x0573' },
  { U'\x0544', U'\x0574' },
  { U'\x0545', U'\x0575' },
  { U'\x0546', U'\x0576' },
  { U'\x0547', U'\x0577' },
  { U'\x0548', U'\x0578' },
  { U'\x0549', U'\x0579' },
  { U'\x054a', U'\x057a' },
  { U'\x054b', U'\x057b' },
  { U'\x054c', U'\x057c' },
  { U'\x054d', U'\x057d' },
  { U'\x054e', U'\x057e' },
  { U'\x054f', U'\x057f' },
  { U'\x0550', U'\x0580' },
  { U'\x0551', U'\x0581' },
  { U'\x0552', U'\x0582' },
  { U'\x0553', U'\x0583' },
  { U'\x0554', U'\x0584' },
  { U'\x0555', U'\x0585' },
  { U'\x0556', U'\x0586' },
  { U'\x0587', U'\x0565' },
  { U'\x0675', U'\x0627' },
  { U'\x0676', U'\x0648' },
  { U'\x0677', U'\x06c7' },
  { U'\x0678', U'\x064a' },
  { U'\x0958', U'\x0915' },
  { U'\x0959', U'\x0916' },
  { U'\x095a', U'\x0917' },
  { U'\x095b', U'\x091c' },
  { U'\x095c', U'\x0921' },
  { U'\x095d', U'\x0922' },
  { U'\x095e', U'\x092b' },
  { U'\x095f', U'\x092f' },
  { U'\x09dc', U'\x09a1' },
  { U'\x09dd', U'\x09a2' },
  { U'\x09df', U'\x09af' },
  { U'\x0a33', U'\x0a32' },
  { U'\x0a36', U'\x0a38' },
  { U'\x0a59', U'\x0a16' },
  { U'\x0a5a', U'\x0a17' },
  { U'\x0a5b', U'\x0a1c' },
  { U'\x0a5e', U'\x0a2b' },
  { U'\x0b5c', U'\x0b21' },
  { U'\x0b5d', U'\x0b22' },
  { U'\x0e33', U'\x0e4d' },
  { U'\x0eb3', U'\x0ecd' },
  { U'\x0edc', U'\x0eab' },
  { U'\x0edd', U'\x0eab' },
  { U'\x0f0c', U'\x0f0b' },
  { U'\x0f43', U'\x0f42' },
  { U'\x0f4d', U'\x0f4c' },
  { U'\x0f52', U'\x0f51' },
  { U'\x0f57', U'\x0f56' },
  { U'\x0f5c', U'\x0f5b' },
  { U'\x0f69', U'\x0f40' },
  { U'\x0f73', U'\x0f71' },
  { U'\x0f75', U'\x0f71' },
  { U'\x0f76', U'\x0fb2' },
  { U'\x0f77', U'\x0fb2' },
  { U'\x0f78', U'\x0fb3' },
  { U'\x0f79', U'\x0fb3' },
  { U'\x0f81', U'\x0f71' },
  { U'\x0f93', U'\x0f92' },
  { U'\x0f9d', U'\x0f9c' },
  { U'\x0fa2', U'\x0fa1' },
  { U'\x0fa7', U'\x0fa6' },
  { U'\x0fac', U'\x0fab' },
  { U'\x0fb9', U'\x0f90' },
  { U'\x10c7', U'\x2d27' },
  { U'\x10cd', U'\x2d2d' },
  { U'\x10fc', U'\x10dc' },
  { U'\x13f8', U'\x13f0' },
  { U'\x13f9', U'\x13f1' },
  { U'\x13fa', U'\x13f2' },
  { U'\x13fb', U'\x13f3' },
  { U'\x13fc', U'\x13f4' },
  { U'\x13fd', U'\x13f5' },
  { U'\x1c80', U'\x0432' },
  { U'\x1c81', U'\x0434' },
  { U'\x1c82', U'\x043e' },
  { U'\x1c83', U'\x0441' },
  { U'\x1c84', U'\x0442' },
  { U'\x1c86', U'\x044a' },
  { U'\x1c87', U'\x0463' },
  { U'\x1c88', U'\xa64b' },
  { U'\x1c90', U'\x10d0' },
  { U'\x1c91', U'\x10d1' },
  { U'\x1c92', U'\x10d2' },
  { U'\x1c93', U'\x10d3' },
  { U'\x1c94', U'\x10d4' },
  { U'\x1c95', U'\x10d5' },
  { U'\x1c96', U'\x10d6' },
  { U'\x1c97', U'\x10d7' },
  { U'\x1c98', U'\x10d8' },
  { U'\x1c99', U'\x10d9' },
  { U'\x1c9a', U'\x10da' },
  { U'\x1c9b', U'\x10db' },
  { U'\x1c9c', U'\x10dc' },
  { U'\x1c9d', U'\x10dd' },
  { U'\x1c9e', U'\x10de' },
  { U'\x1c9f', U'\x10df' },
  { U'\x1ca0', U'\x10e0' },
  { U'\x1ca1', U'\x10e1' },
  { U'\x1ca2', U'\x10e2' },
  { U'\x1ca3', U'\x10e3' },
  { U'\x1ca4', U'\x10e4' },
  { U'\x1ca5', U'\x10e5' },
  { U'\x1ca6', U'\x10e6' },
  { U'\x1ca7', U'\x10e7' },
  { U'\x1ca8', U'\x10e8' },
  { U'\x1ca9', U'\x10e9' },
  { U'\x1caa', U'\x10ea' },
  { U'\x1cab', U'\x10eb' },
  { U'\x1cac', U'\x10ec' },
  { U'\x1cad', U'\x10ed' },
  { U'\x1cae', U'\x10ee' },
  { U'\x1caf', U'\x10ef' },
  { U'\x1cb0', U'\x10f0' },
  { U'\x1cb1', U'\x10f1' },
  { U'\x1cb2', U'\x10f2' },
  { U'\x1cb3', U'\x10f3' },
  { U'\x1cb4', U'\x10f4' },
  { U'\x1cb5', U'\x10f5' },
  { U'\x1cb6', U'\x10f6' },
  { U'\x1cb7', U'\x10f7' },
  { U'\x1cb8', U'\x10f8' },
  { U'\x1cb9', U'\x10f9' },
  { U'\x1cba', U'\x10fa' },
  { U'\x1cbd', U'\x10fd' },
  { U'\x1cbe', U'\x10fe' },
  { U'\x1cbf', U'\x10ff' },
  { U'\x1d2c', U'\x0061' },
  { U'\x1d2d', U'\x00e6' },
  { U'\x1d2e', U'\x0062' },
  { U'\x1d30', U'\x0064' },
  { U'\x1d31', U'\x0065' },
  { U'\x1d32', U'\x01dd' },
  { U'\x1d33', U'\x0067' },
  { U'\x1d34', U'\x0068' },
  { U'\x1d35', U'\x0069' },
  { U'\x1d36', U'\x006a' },
  { U'\x1d37', U'\x006b' },
  { U'\x1d38', U'\x006c' },
  { U'\x1d39', U'\x006d' },
  { U'\x1d3a', U'\x006e' },
  { U'\x1d3c', U'\x006f' },
  { U'\x1d3d', U'\x0223' },
  { U'\x1d3e', U'\x0070' },
  { U'\x1d3f', U'\x0072' },
  { U'\x1d40', U'\x0074' },
  { U'\x1d41', U'\x0075' },
  { U'\x1d42', U'\x0077' },
  { U'\x1d43', U'\x0061' },
  { U'\x1d44', U'\x0250' },
  { U'\x1d45', U'\x0251' },
  { U'\x1d46', U'\x1d02' },
  { U'\x1d47', U'\x0062' },
  { U'\x1d48', U'\x0064' },
  { U'\x1d49', U'\x0065' },
  { U'\x1d4a', U'\x0259' },
  { U'\x1d4b', U'\x025b' },
  { U'\x1d4c', U'\x025c' },
  { U'\x1d4d', U'\x0067' },
  { U'\x1d4f', U'\x006b' },
  { U'\x1d50', U'\x006d' },
  { U'\x1d51', U'\x014b' },
  { U'\x1d52', U'\x006f' },
  { U'\x1d53', U'\x0254' },
  { U'\x1d54', U'\x1d16' },
  { U'\x1d55', U'\x1d17' },
  { U'\x1d56', U'\x0070' },
  { U'\x1d57', U'\x0074' },
  { U'\x1d58', U'\x0075' },
  { U'\x1d59', U'\x1d1d' },
  { U'\x1d5a', U'\x026f' },
  { U'\x1d5b', U'\x0076' },
  { U'\x1d5c', U'\x1d25' },
  { U'\x1d5d', U'\x03b2' },
  { U'\x1d5e', U'\x03b3' },
  { U'\x1d5f', U'\x03b4' },
  { U'\x1d60', U'\x03c6' },
  { U'\x1d61', U'\x03c7' },
  { U'\x1d62', U'\x0069' },
  { U'\x1d63', U'\x0072' },
  { U'\x1d64', U'\x0075' },
  { U'\x1d65', U'\x0076' },
  { U'\x1d66', U'\x03b2' },
  { U'\x1d67', U'\x03b3' },
  { U'\x1d68', U'\x03c1' },
  { U'\x1d69', U'\x03c6' },
  { U'\x1d6a', U'\x03c7' },
  { U'\x1d78', U'\x043d' },
  { U'\x1d9b', U'\x0252' },
  { U'\x1d9c', U'\x0063' },
  { U'\x1d9d', U'\x0255' },
  { U'\x1d9e', U'\x00f0' },
  { U'\x1d9f', U'\x025c' },
  { U'\x1da0', U'\x0066' },
  { U'\x1da1', U'\x025f' },
  { U'\x1da2', U'\x0261' },
  { U'\x1da3', U'\x0265' },
  { U'\x1da4', U'\x0268' },
  { U'\x1da5', U'\x0269' },
  { U'\x1da6', U'\x026a' },
  { U'\x1da7', U'\x1d7b' },
  { U'\x1da8', U'\x029d' },
  { U'\x1da9', U'\x026d' },
  { U'\x1daa', U'\x1d85' },
  { U'\x1dab', U'\x029f' },
  { U'\x1dac', U'\x0271' },
  { U'\x1dad', U'\x0270' },
  { U'\x1dae', U'\x0272' },
  { U'\x1daf', U'\x0273' },
  { U'\x1db0', U'\x0274' },
  { U'\x1db1', U'\x0275' },
  { U'\x1db2', U'\x0278' },
  { U'\x1db3', U'\x0282' },
  { U'\x1db4', U'\x0283' },
  { U'\x1db5', U'\x01ab' },
  { U'\x1db6', U'\x0289' },
  { U'\x1db7', U'\x028a' },
  { U'\x1db8', U'\x1d1c' },
  { U'\x1db9', U'\x028b' },
  { U'\x1dba', U'\x028c' },
  { U'\x1dbb', U'\x007a' },
  { U'\x1dbc', U'\x0290' },
  { U'\x1dbd', U'\x0291' },
  { U'\x1dbe', U'\x0292' },
  { U'\x1dbf', U'\x03b8' },
  { U'\x1e00', U'\x1e01' },
  { U'\x1e02', U'\x1e03' },
  { U'\x1e04', U'\x1e05' },
  { U'\x1e06', U'\x1e07' },
  { U'\x1e08', U'\x1e09' },
  { U'\x1e0a', U'\x1e0b' },
  { U'\x1e0c', U'\x1e0d' },
  { U'\x1e0e', U'\x1e0f' },
  { U'\x1e10', U'\x1e11' },
  { U'\x1e12', U'\x1e13' },
  { U'\x1e14', U'\x1e15' },
  { U'\x1e16', U'\x1e17' },
  { U'\x1e18', U'\x1e19' },
  { U'\x1e1a', U'\x1e1b' },
  { U'\x1e1c', U'\x1e1d' },
  { U'\x1e1e', U'\x1e1f' },
  { U'\x1e20', U'\x1e21' },
  { U'\x1e22', U'\x1e23' },
  { U'\x1e24', U'\x1e25' },
  { U'\x1e26', U'\x1e27' },
  { U'\x1e28', U'\x1e29' },
  { U'\x1e2a', U'\x1e2b' },
  { U'\x1e2c', U'\x1e2d' },
  { U'\x1e2e', U'\x1e2f' },
  { U'\x1e30', U'\x1e31' },
  { U'\x1e32', U'\x1e33' },
  { U'\x1e34', U'\x1e35' },
  { U'\x1e36', U'\x1e37' },
  { U'\x1e38', U'\x1e39' },
  { U'\x1e3a', U'\x1e3b' },
  { U'\x1e3c', U'\x1e3d' },
  { U'\x1e3e', U'\x1e3f' },
  { U'\x1e40', U'\x1e41' },
  { U'\x1e42', U'\x1e43' },
  { U'\x1e44', U'\x1e45' },
  { U'\x1e46', U'\x1e47' },
  { U'\x1e48', U'\x1e49' },
  { U'\x1e4a', U'\x1e4b' },
  { U'\x1e4c', U'\x1e4d' },
  { U'\x1e4e', U'\x1e4f' },
  { U'\x1e50', U'\x1e51' },
  { U'\x1e52', U'\x1e53' },
  { U'\x1e54', U'\x1e55' },
  { U'\x1e56', U'\x1e57' },
  { U'\x1e58', U'\x1e59' },
  { U'\x1e5a', U'\x1e5b' },
  { U'\x1e5c', U'\x1e5d' },
  { U'\x1e5e', U'\x1e5f' },
  { U'\x1e60', U'\x1e61' },
  { U'\x1e62', U'\x1e63' },
  { U'\x1e64', U'\x1e65' },
  { U'\x1e66', U'\x1e67' },
  { U'\x1e68', U'\x1e69' },
  { U'\x1e6a', U'\x1e6b' },
  { U'\x1e6c', U'\x1e6d' },
  { U'\x1e6e', U'\x1e6f' },
  { U'\x1e70', U'\x1e71' },
  { U'\x1e72', U'\x1e73' },
  { U'\x1e74', U'\x1e75' },
  { U'\x1e76', U'\x1e77' },
  { U'\x1e78', U'\x1e79' },
  { U'\x1e7a', U'\x1e7b' },
  { U'\x1e7c', U'\x1e7d' },
  { U'\x1e7e', U'\x1e7f' },
  { U'\x1e80', U'\x1e81' },
  { U'\x1e82', U'\x1e83' },
  { U'\x1e84', U'\x1e85' },
  { U'\x1e86', U'\x1e87' },
  { U'\x1e88', U'\x1e89' },
  { U'\x1e8a', U'\x1e8b' },
  { U'\x1e8c', U'\x1e8d' },
  { U'\x1e8e', U'\x1e8f' },
  { U'\x1e90', U'\x1e91' },
  { U'\x1e92', U'\x1e93' },
  { U'\x1e94', U'\x1e95' },
  { U'\x1e9a', U'\x0061' },
  { U'\x1e9b', U'\x1e61' },
  { U'\x1e9e', U'\x0073' },
  { U'\x1ea0', U'\x1ea1' },
  { U'\x1ea2', U'\x1ea3' },
  { U'\x1ea4', U'\x1ea5' },
  { U'\x1ea6', U'\x1ea7' },
  { U'\x1ea8', U'\x1ea9' },
  { U'\x1eaa', U'\x1eab' },
  { U'\x1eac', U'\x1ead' },
  { U'\x1eae', U'\x1eaf' },
  { U'\x1eb0', U'\x1eb1' },
  { U'\x1eb2', U'\x1eb3' },
  { U'\x1eb4', U'\x1eb5' },
  { U'\x1eb6', U'\x1eb7' },
  { U'\x1eb8', U'\x1eb9' },
  { U'\x1eba', U'\x1ebb' },
  { U'\x1ebc', U'\x1ebd' },
  { U'\x1ebe', U'\x1ebf' },
  { U'\x1ec0', U'\x1ec1' },
  { U'\x1ec2', U'\x1ec3' },
  { U'\x1ec4', U'\x1ec5' },
  { U'\x1ec6', U'\x1ec7' },
  { U'\x1ec8', U'\x1ec9' },
  { U'\x1eca', U'\x1ecb' },
  { U'\x1ecc', U'\x1ecd' },
  { U'\x1ece', U'\x1ecf' },
  { U'\x1ed0', U'\x1ed1' },
  { U'\x1ed2', U'\x1ed3' },
  { U'\x1ed4', U'\x1ed5' },
  { U'\x1ed6', U'\x1ed7' },
  { U'\x1ed8', U'\x1ed9' },
  { U'\x1eda', U'\x1edb' },
  { U'\x1edc', U'\x1edd' },
  { U'\x1ede', U'\x1edf' },
  { U'\x1ee0', U'\x1ee1' },
  { U'\x1ee2', U'\x1ee3' },
  { U'\x1ee4', U'\x1ee5' },
  { U'\x1ee6', U'\x1ee7' },
  { U'\x1ee8', U'\x1ee9' },
  { U'\x1eea', U'\x1eeb' },
  { U'\x1eec', U'\x1eed' },
  { U'\x1eee', U'\x1eef' },
  { U'\x1ef0', U'\x1ef1' },
  { U'\x1ef2', U'\x1ef3' },
  { U'\x1ef4', U'\x1ef5' },
  { U'\x1ef6', U'\x1ef7' },
  { U'\x1ef8', U'\x1ef9' },
  { U'\x1efa', U'\x1efb' },
  { U'\x1efc', U'\x1efd' },
  { U'\x1efe', U'\x1eff' },
  { U'\x1f08', U'\x1f00' },
  { U'\x1f09', U'\x1f01' },
  { U'\x1f0a', U'\x1f02' },
  { U'\x1f0b', U'\x1f03' },
  { U'\x1f0c', U'\x1f04' },
  { U'\x1f0d', U'\x1f05' },
  { U'\x1f0e', U'\x1f06' },
  { U'\x1f0f', U'\x1f07' },
  { U'\x1f18', U'\x1f10' },
  { U'\x1f19', U'\x1f11' },
  { U'\x1f1a', U'\x1f12' },
  { U'\x1f1b', U'\x1f13' },
  { U'\x1f1c', U'\x1f14' },
  { U'\x1f1d', U'\x1f15' },
  { U'\x1f28', U'\x1f20' },
  { U'\x1f29', U'\x1f21' },
  { U'\x1f2a', U'\x1f22' },
  { U'\x1f2b', U'\x1f23' },
  { U'\x1f2c', U'\x1f24' },
  { U'\x1f2d', U'\x1f25' },
  { U'\x1f2e', U'\x1f26' },
  { U'\x1f2f', U'\x1f27' },
  { U'\x1f38', U'\x1f30' },
  { U'\x1f39', U'\x1f31' },
  { U'\x1f3a', U'\x1f32' },
  { U'\x1f3b', U'\x1f33' },
  { U'\x1f3c', U'\x1f34' },
  { U'\x1f3d', U'\x1f35' },
  { U'\x1f3e', U'\x1f36' },
  { U'\x1f3f', U'\x1f37' },
  { U'\x1f48', U'\x1f40' },
  { U'\x1f49', U'\x1f41' },
  { U'\x1f4a', U'\x1f42' },
  { U'\x1f4b', U'\x1f43' },
  { U'\x1f4c', U'\x1f44' },
  { U'\x1f4d', U'\x1f45' },
  { U'\x1f59', U'\x1f51' },
  { U'\x1f5b', U'\x1f53' },
  { U'\x1f5d', U'\x1f55' },
  { U'\x1f5f', U'\x1f57' },
  { U'\x1f68', U'\x1f60' },
  { U'\x1f69', U'\x1f61' },
  { U'\x1f6a', U'\x1f62' },
  { U'\x1f6b', U'\x1f63' },
  { U'\x1f6c', U'\x1f64' },
  { U'\x1f6d', U'\x1f65' },
  { U'\x1f6e', U'\x1f66' },
  { U'\x1f6f', U'\x1f67' },
  { U'\x1f71', U'\x03ac' },
  { U'\x1f73', U'\x03ad' },
  { U'\x1f75', U'\x03ae' },
  { U'\x1f77', U'\x03af' },
  { U'\x1f79', U'\x03cc' },
  { U'\x1f7b', U'\x03cd' },
  { U'\x1f7d', U'\x03ce' },
  { U'\x1f80', U'\x1f00' },
  { U'\x1f81', U'\x1f01' },
  { U'\x1f82', U'\x1f02' },
  { U'\x1f83', U'\x1f03' },
  { U'\x1f84', U'\x1f04' },
  { U'\x1f85', U'\x1f05' },
  { U'\x1f86', U'\x1f06' },
  { U'\x1f87', U'\x1f07' },
  { U'\x1f88', U'\x1f00' },
  { U'\x1f89', U'\x1f01' },
  { U'\x1f8a', U'\x1f02' },
  { U'\x1f8b', U'\x1f03' },
  { U'\x1f8c', U'\x1f04' },
  { U'\x1f8d', U'\x1f05' },
  { U'\x1f8e', U'\x1f06' },
  { U'\x1f8f', U'\x1f07' },
  { U'\x1f90', U'\x1f20' },
  { U'\x1f91', U'\x1f21' },
  { U'\x1f92', U'\x1f22' },
  { U'\x1f93', U'\x1f23' },
  { U'\x1f94', U'\x1f24' },
  { U'\x1f95', U'\x1f25' },
  { U'\x1f96', U'\x1f26' },
  { U'\x1f97', U'\x1f27' },
  { U'\x1f98', U'\x1f20' },
  { U'\x1f99', U'\x1f21' },
  { U'\x1f9a', U'\x1f22' },
  { U'\x1f9b', U'\x1f23' },
  { U'\x1f9c', U'\x1f24' },
  { U'\x1f9d', U'\x1f25' },
  { U'\x1f9e', U'\x1f26' },
  { U'\x1f9f', U'\x1f27' },
  { U'\x1fa0', U'\x1f60' },
  { U'\x1fa1', U'\x1f61' },
  { U'\x1fa2', U'\x1f62' },
  { U'\x1fa3', U'\x1f63' },
  { U'\x1fa4', U'\x1f64' },
  { U'\x1fa5', U'\x1f65' },
  { U'\x1fa6', U'\x1f66' },
  { U'\x1fa7', U'\x1f67' },
  { U'\x1fa8', U'\x1f60' },
  { U'\x1fa9', U'\x1f61' },
  { U'\x1faa', U'\x1f62' },
  { U'\x1fab', U'\x1f63' },
  { U'\x1fac', U'\x1f64' },
  { U'\x1fad', U'\x1f65' },
  { U'\x1fae', U'\x1f66' },
  { U'\x1faf', U'\x1f67' },
  { U'\x1fb2', U'\x1f70' },
  { U'\x1fb3', U'\x03b1' },
  { U'\x1fb4', U'\x03ac' },
  { U'\x1fb7', U'\x1fb6' },
  { U'\x1fb8', U'\x1fb0' },
  { U'\x1fb9', U'\x1fb1' },
  { U'\x1fba', U'\x1f70' },
  { U'\x1fbb', U'\x03ac' },
  { U'\x1fbc', U'\x03b1' },
  { U'\x1fbd', U'\x0020' },
  { U'\x1fbe', U'\x03b9' },
  { U'\x1fbf', U'\x0020' },
  { U'\x1fc0', U'\x0020' },
  { U'\x1fc1', U'\x0020' },
  { U'\x1fc2', U'\x1f74' },
  { U'\x1fc3', U'\x03b7' },
  { U'\x1fc4', U'\x03ae' },
  { U'\x1fc7', U'\x1fc6' },
  { U'\x1fc8', U'\x1f72' },
  { U'\x1fc9', U'\x03ad' },
  { U'\x1fca', U'\x1f74' },
  { U'\x1fcb', U'\x03ae' },
  { U'\x1fcc', U'\x03b7' },
  { U'\x1fcd', U'\x0020' },
  { U'\x1fce', U'\x0020' },
  { U'\x1fcf', U'\x0020' },
  { U'\x1fd3', U'\x0390' },
  { U'\x1fd8', U'\x1fd0' },
  { U'\x1fd9', U'\x1fd1' },
  { U'\x1fda', U'\x1f76' },
  { U'\x1fdb', U'\x03af' },
  { U'\x1fdd', U'\x0020' },
  { U'\x1fde', U'\x0020' },
  { U'\x1fdf', U'\x0020' },
  { U'\x1fe3', U'\x03b0' },
  { U'\x1fe8', U'\x1fe0' },
  { U'\x1fe9', U'\x1fe1' },
  { U'\x1fea', U'\x1f7a' },
  { U'\x1feb', U'\x03cd' },
  { U'\x1fec', U'\x1fe5' },
  { U'\x1fed', U'\x0020' },
  { U'\x1fee', U'\x0020' },
  { U'\x1fef', U'\x0060' },
  { U'\x1ff2', U'\x1f7c' },
  { U'\x1ff3', U'\x03c9' },
  { U'\x1ff4', U'\x03ce' },
  { U'\x1ff7', U'\x1ff6' },
  { U'\x1ff8', U'\x1f78' },
  { U'\x1ff9', U'\x03cc' },
  { U'\x1ffa', U'\x1f7c' },
  { U'\x1ffb', U'\x03ce' },
  { U'\x1ffc', U'\x03c9' },
  { U'\x1ffd', U'\x0020' },
  { U'\x1ffe', U'\x0020' },
  { U'\x2000', U'\x0020' },
  { U'\x2011', U'\x2010' },
  { U'\x2017', U'\x0020' },
  { U'\x202f', U'\x0020' },
  { U'\x2033', U'\x2032' },
  { U'\x2034', U'\x2032' },
  { U'\x2036', U'\x2035' },
  { U'\x2037', U'\x2035' },
  { U'\x203c', U'\x0021' },
  { U'\x203e', U'\x0020' },
  { U'\x2047', U'\x003f' },
  { U'\x2048', U'\x003f' },
  { U'\x2049', U'\x0021' },
  { U'\x2057', U'\x2032' },
  { U'\x205f', U'\x0020' },
  { U'\x2070', U'\x0030' },
  { U'\x2071', U'\x0069' },
  { U'\x2074', U'\x0034' },
  { U'\x2075', U'\x0035' },
  { U'\x2076', U'\x0036' },
  { U'\x2077', U'\x0037' },
  { U'\x2078', U'\x0038' },
  { U'\x2079', U'\x0039' },
  { U'\x207a', U'\x002b' },
  { U'\x207b', U'\x2212' },
  { U'\x207c', U'\x003d' },
  { U'\x207d', U'\x0028' },
  { U'\x207e', U'\x0029' },
  { U'\x207f', U'\x006e' },
  { U'\x2080', U'\x0030' },
  { U'\x2081', U'\x0031' },
  { U'\x2082', U'\x0032' },
  { U'\x2083', U'\x0033' },
  { U'\x2084', U'\x0034' },
  { U'\x2085', U'\x0035' },
  { U'\x2086', U'\x0036' },
  { U'\x2087', U'\x0037' },
  { U'\x2088', U'\x0038' },
  { U'\x2089', U'\x0039' },
  { U'\x208a', U'\x002b' },
  { U'\x208b', U'\x2212' },
  { U'\x208c', U'\x003d' },
  { U'\x208d', U'\x0028' },
  { U'\x208e', U'\x0029' },
  { U'\x2090', U'\x0061' },
  { U'\x2091', U'\x0065' },
  { U'\x2092', U'\x006f' },
  { U'\x2093', U'\x0078' },
  { U'\x2094', U'\x0259' },
  { U'\x2095', U'\x0068' },
  { U'\x2096', U'\x006b' },
  { U'\x2097', U'\x006c' },
  { U'\x2098', U'\x006d' },
  { U'\x2099', U'\x006e' },
  { U'\x209a', U'\x0070' },
  { U'\x209b', U'\x0073' },
  { U'\x209c', U'\x0074' },
  { U'\x20a8', U'\x0072' },
  { U'\x2100', U'\x0061' },
  { U'\x2101', U'\x0061' },
  { U'\x2102', U'\x0063' },
  { U'\x2103', U'\x00b0' },
  { U'\x2105', U'\x0063' },
  { U'\x2106', U'\x0063' },
  { U'\x2107', U'\x025b' },
  { U'\x2109', U'\x00b0' },
  { U'\x210a', U'\x0067' },
  { U'\x210b', U'\x0068' },
  { U'\x210f', U'\x0127' },
  { U'\x2110', U'\x0069' },
  { U'\x2112', U'\x006c' },
  { U'\x2115', U'\x006e' },
  { U'\x2116', U'\x006e' },
  { U'\x2119', U'\x0070' },
  { U'\x211a', U'\x0071' },
  { U'\x211b', U'\x0072' },
  { U'\x2120', U'\x0073' },
  { U'\x2121', U'\x0074' },
  { U'\x2122', U'\x0074' },
  { U'\x2124', U'\x007a' },
  { U'\x2126', U'\x03c9' },
  { U'\x2128', U'\x007a' },
  { U'\x212a', U'\x006b' },
  { U'\x212b', U'\x00e5' },
  { U'\x212c', U'\x0062' },
  { U'\x212d', U'\x0063' },
  { U'\x212f', U'\x0065' },
  { U'\x2131', U'\x0066' },
  { U'\x2133', U'\x006d' },
  { U'\x2134', U'\x006f' },
  { U'\x2135', U'\x05d0' },
  { U'\x2136', U'\x05d1' },
  { U'\x2137', U'\x05d2' },
  { U'\x2138', U'\x05d3' },
  { U'\x2139', U'\x0069' },
  { U'\x213b', U'\x0066' },
  { U'\x213c', U'\x03c0' },
  { U'\x213d', U'\x03b3' },
  { U'\x213f', U'\x03c0' },
  { U'\x2140', U'\x2211' },
  { U'\x2145', U'\x0064' },
  { U'\x2147', U'\x0065' },
  { U'\x2148', U'\x0069' },
  { U'\x2149', U'\x006a' },
  { U'\x2150', U'\x0031' },
  { U'\x2151', U'\x0031' },
  { U'\x2152', U'\x0031' },
  { U'\x2153', U'\x0031' },
  { U'\x2154', U'\x0032' },
  { U'\x2155', U'\x0031' },
  { U'\x2156', U'\x0032' },
  { U'\x2157', U'\x0033' },
  { U'\x2158', U'\x0034' },
  { U'\x2159', U'\x0031' },
  { U'\x215a', U'\x0035' },
  { U'\x215b', U'\x0031' },
  { U'\x215c', U'\x0033' },
  { U'\x215d', U'\x0035' },
  { U'\x215e', U'\x0037' },
  { U'\x215f', U'\x0031' },
  { U'\x2160', U'\x0069' },
  { U'\x2161', U'\x0069' },
  { U'\x2162', U'\x0069' },
  { U'\x2163', U'\x0069' },
  { U'\x2164', U'\x0076' },
  { U'\x2165', U'\x0076' },
  { U'\x2166', U'\x0076' },
  { U'\x2167', U'\x0076' },
  { U'\x2168', U'\x0069' },
  { U'\x2169', U'\x0078' },
  { U'\x216a', U'\x0078' },
  { U'\x216b', U'\x0078' },
  { U'\x216c', U'\x006c' },
  { U'\x216d', U'\x0063' },
  { U'\x216e', U'\x0064' },
  { U'\x216f', U'\x006d' },
  { U'\x2170', U'\x0069' },
  { U'\x2171', U'\x0069' },
  { U'\x2172', U'\x0069' },
  { U'\x2173', U'\x0069' },
  { U'\x2174', U'\x0076' },
  { U'\x2175', U'\x0076' },
  { U'\x2176', U'\x0076' },
  { U'\x2177', U'\x0076' },
  { U'\x2178', U'\x0069' },
  { U'\x2179', U'\x0078' },
  { U'\x217a', U'\x0078' },
  { U'\x217b', U'\x0078' },
  { U'\x217c', U'\x006c' },
  { U'\x217d', U'\x0063' },
  { U'\x217e', U'\x0064' },
  { U'\x217f', U'\x006d' },
  { U'\x2189', U'\x0030' },
  { U'\x222c', U'\x222b' },
  { U'\x222d', U'\x222b' },
  { U'\x222f', U'\x222e' },
  { U'\x2230', U'\x222e' },
  { U'\x2329', U'\x3008' },
  { U'\x232a', U'\x3009' },
  { U'\x2460', U'\x0031' },
  { U'\x2461', U'\x0032' },
  { U'\x2462', U'\x0033' },
  { U'\x2463', U'\x0034' },
  { U'\x2464', U'\x0035' },
  { U'\x2465', U'\x0036' },
  { U'\x2466', U'\x0037' },
  { U'\x2467', U'\x0038' },
  { U'\x2468', U'\x0039' },
  { U'\x2469', U'\x0031' },
  { U'\x246a', U'\x0031' },
  { U'\x246b', U'\x0031' },
  { U'\x246c', U'\x0031' },
  { U'\x246d', U'\x0031' },
  { U'\x246e', U'\x0031' },
  { U'\x246f', U'\x0031' },
  { U'\x2470', U'\x0031' },
  { U'\x2471', U'\x0031' },
  { U'\x2472', U'\x0031' },
  { U'\x2473', U'\x0032' },
  { U'\x2474', U'\x0028' },
  { U'\x2475', U'\x0028' },
  { U'\x2476', U'\x0028' },
  { U'\x2477', U'\x0028' },
  { U'\x2478', U'\x0028' },
  { U'\x2479', U'\x0028' },
  { U'\x247a', U'\x0028' },
  { U'\x247b', U'\x0028' },
  { U'\x247c', U'\x0028' },
  { U'\x247d', U'\x0028' },
  { U'\x247e', U'\x0028' },
  { U'\x247f', U'\x0028' },
  { U'\x2480', U'\x0028' },
  { U'\x2481', U'\x0028' },
  { U'\x2482', U'\x0028' },
  { U'\x2483', U'\x0028' },
  { U'\x2484', U'\x0028' },
  { U'\x2485', U'\x0028' },
  { U'\x2486', U'\x0028' },
  { U'\x2487', U'\x0028' },
  { U'\x249c', U'\x0028' },
  { U'\x249d', U'\x0028' },
  { U'\x249e', U'\x0028' },
  { U'\x249f', U'\x0028' },
  { U'\x24a0', U'\x0028' },
  { U'\x24a1', U'\x0028' },
  { U'\x24a2', U'\x0028' },
  { U'\x24a3', U'\x0028' },
  { U'\x24a4', U'\x0028' },
  { U'\x24a5', U'\x0028' },
  { U'\x24a6', U'\x0028' },
  { U'\x24a7', U'\x0028' },
  { U'\x24a8', U'\x0028' },
  { U'\x24a9', U'\x0028' },
  { U'\x24aa', U'\x0028' },
  { U'\x24ab', U'\x0028' },
  { U'\x24ac', U'\x0028' },
  { U'\x24ad', U'\x0028' },
  { U'\x24ae', U'\x0028' },
  { U'\x24af', U'\x0028' },
  { U'\x24b0', U'\x0028' },
  { U'\x24b1', U'\x0028' },
  { U'\x24b2', U'\x0028' },
  { U'\x24b3', U'\x0028' },
  { U'\x24b4', U'\x0028' },
  { U'\x24b5', U'\x0028' },
  { U'\x24b6', U'\x0061' },
  { U'\x24b7', U'\x0062' },
  { U'\x24b8', U'\x0063' },
  { U'\x24b9', U'\x0064' },
  { U'\x24ba', U'\x0065' },
  { U'\x24bb', U'\x0066' },
  { U'\x24bc', U'\x0067' },
  { U'\x24bd', U'\x0068' },
  { U'\x24be', U'\x0069' },
  { U'\x24bf', U'\x006a' },
  { U'\x24c0', U'\x006b' },
  { U'\x24c1', U'\x006c' },
  { U'\x24c2', U'\x006d' },
  { U'\x24c3', U'\x006e' },
  { U'\x24c4', U'\x006f' },
  { U'\x24c5', U'\x0070' },
  { U'\x24c6', U'\x0071' },
  { U'\x24c7', U'\x0072' },
  { U'\x24c8', U'\x0073' },
  { U'\x24c9', U'\x0074' },
  { U'\x24ca', U'\x0075' },
  { U'\x24cb', U'\x0076' },
  { U'\x24cc', U'\x0077' },
  { U'\x24cd', U'\x0078' },
  { U'\x24ce', U'\x0079' },
  { U'\x24cf', U'\x007a' },
  { U'\x24d0', U'\x0061' },
  { U'\x24d1', U'\x0062' },
  { U'\x24d2', U'\x0063' },
  { U'\x24d3', U'\x0064' },
  { U'\x24d4', U'\x0065' },
  { U'\x24d5', U'\x0066' },
  { U'\x24d6', U'\x0067' },
  { U'\x24d7', U'\x0068' },
  { U'\x24d8', U'\x0069' },
  { U'\x24d9', U'\x006a' },
  { U'\x24da', U'\x006b' },
  { U'\x24db', U'\x006c' },
  { U'\x24dc', U'\x006d' },
  { U'\x24dd', U'\x006e' },
  { U'\x24de', U'\x006f' },
  { U'\x24df', U'\x0070' },
  { U'\x24e0', U'\x0071' },
  { U'\x24e1', U'\x0072' },
  { U'\x24e2', U'\x0073' },
  { U'\x24e3', U'\x0074' },
  { U'\x24e4', U'\x0075' },
  { U'\x24e5', U'\x0076' },
  { U'\x24e6', U'\x0077' },
  { U'\x24e7', U'\x0078' },
  { U'\x24e8', U'\x0079' },
  { U'\x24e9', U'\x007a' },
  { U'\x24ea', U'\x0030' },
  { U'\x2a0c', U'\x222b' },
  { U'\x2a74', U'\x003a' },
  { U'\x2a75', U'\x003d' },
  { U'\x2a76', U'\x003d' },
  { U'\x2adc', U'\x2add' },
  { U'\x2c00', U'\x2c30' },
  { U'\x2c01', U'\x2c31' },
  { U'\x2c02', U'\x2c32' },
  { U'\x2c03', U'\x2c33' },
  { U'\x2c04', U'\x2c34' },
  { U'\x2c05', U'\x2c35' },
  { U'\x2c06', U'\x2c36' },
  { U'\x2c07', U'\x2c37' },
  { U'\x2c08', U'\x2c38' },
  { U'\x2c09', U'\x2c39' },
  { U'\x2c0a', U'\x2c3a' },
  { U'\x2c0b', U'\x2c3b' },
  { U'\x2c0c', U'\x2c3c' },
  { U'\x2c0d', U'\x2c3d' },
  { U'\x2c0e', U'\x2c3e' },
  { U'\x2c0f', U'\x2c3f' },
  { U'\x2c10', U'\x2c40' },
  { U'\x2c11', U'\x2c41' },
  { U'\x2c12', U'\x2c42' },
  { U'\x2c13', U'\x2c43' },
  { U'\x2c14', U'\x2c44' },
  { U'\x2c15', U'\x2c45' },
  { U'\x2c16', U'\x2c46' },
  { U'\x2c17', U'\x2c47' },
  { U'\x2c18', U'\x2c48' },
  { U'\x2c19', U'\x2c49' },
  { U'\x2c1a', U'\x2c4a' },
  { U'\x2c1b', U'\x2c4b' },
  { U'\x2c1c', U'\x2c4c' },
  { U'\x2c1d', U'\x2c4d' },
  { U'\x2c1e', U'\x2c4e' },
  { U'\x2c1f', U'\x2c4f' },
  { U'\x2c20', U'\x2c50' },
  { U'\x2c21', U'\x2c51' },
  { U'\x2c22', U'\x2c52' },
  { U'\x2c23', U'\x2c53' },
  { U'\x2c24', U'\x2c54' },
  { U'\x2c25', U'\x2c55' },
  { U'\x2c26', U'\x2c56' },
  { U'\x2c27', U'\x2c57' },
  { U'\x2c28', U'\x2c58' },
  { U'\x2c29', U'\x2c59' },
  { U'\x2c2a', U'\x2c5a' },
  { U'\x2c2b', U'\x2c5b' },
  { U'\x2c2c', U'\x2c5c' },
  { U'\x2c2d', U'\x2c5d' },
  { U'\x2c2e', U'\x2c5e' },
  { U'\x2c60', U'\x2c61' },
  { U'\x2c62', U'\x026b' },
  { U'\x2c63', U'\x1d7d' },
  { U'\x2c64', U'\x027d' },
  { U'\x2c67', U'\x2c68' },
  { U'\x2c69', U'\x2c6a' },
  { U'\x2c6b', U'\x2c6c' },
  { U'\x2c6d', U'\x0251' },
  { U'\x2c6e', U'\x0271' },
  { U'\x2c6f', U'\x0250' },
  { U'\x2c70', U'\x0252' },
  { U'\x2c72', U'\x2c73' },
  { U'\x2c75', U'\x2c76' },
  { U'\x2c7c', U'\x006a' },
  { U'\x2c7d', U'\x0076' },
  { U'\x2c7e', U'\x023f' },
  { U'\x2c7f', U'\x0240' },
  { U'\x2c80', U'\x2c81' },
  { U'\x2c82', U'\x2c83' },
  { U'\x2c84', U'\x2c85' },
  { U'\x2c86', U'\x2c87' },
  { U'\x2c88', U'\x2c89' },
  { U'\x2c8a', U'\x2c8b' },
  { U'\x2c8c', U'\x2c8d' },
  { U'\x2c8e', U'\x2c8f' },
  { U'\x2c90', U'\x2c91' },
  { U'\x2c92', U'\x2c93' },
  { U'\x2c94', U'\x2c95' },
  { U'\x2c96', U'\x2c97' },
  { U'\x2c98', U'\x2c99' },
  { U'\x2c9a', U'\x2c9b' },
  { U'\x2c9c', U'\x2c9d' },
  { U'\x2c9e', U'\x2c9f' },
  { U'\x2ca0', U'\x2ca1' },
  { U'\x2ca2', U'\x2ca3' },
  { U'\x2ca4', U'\x2ca5' },
  { U'\x2ca6', U'\x2ca7' },
  { U'\x2ca8', U'\x2ca9' },
  { U'\x2caa', U'\x2cab' },
  { U'\x2cac', U'\x2cad' },
  { U'\x2cae', U'\x2caf' },
  { U'\x2cb0', U'\x2cb1' },
  { U'\x2cb2', U'\x2cb3' },
  { U'\x2cb4', U'\x2cb5' },
  { U'\x2cb6', U'\x2cb7' },
  { U'\x2cb8', U'\x2cb9' },
  { U'\x2cba', U'\x2cbb' },
  { U'\x2cbc', U'\x2cbd' },
  { U'\x2cbe', U'\x2cbf' },
  { U'\x2cc0', U'\x2cc1' },
  { U'\x2cc2', U'\x2cc3' },
  { U'\x2cc4', U'\x2cc5' },
  { U'\x2cc6', U'\x2cc7' },
  { U'\x2cc8', U'\x2cc9' },
  { U'\x2cca', U'\x2ccb' },
  { U'\x2ccc', U'\x2ccd' },
  { U'\x2cce', U'\x2ccf' },
  { U'\x2cd0', U'\x2cd1' },
  { U'\x2cd2', U'\x2cd3' },
  { U'\x2cd4', U'\x2cd5' },
  { U'\x2cd6', U'\x2cd7' },
  { U'\x2cd8', U'\x2cd9' },
  { U'\x2cda', U'\x2cdb' },
  { U'\x2cdc', U'\x2cdd' },
  { U'\x2cde', U'\x2cdf' },
  { U'\x2ce0', U'\x2ce1' },
  { U'\x2ce2', U'\x2ce3' },
  { U'\x2ceb', U'\x2cec' },
  { U'\x2ced', U'\x2cee' },
  { U'\x2cf2', U'\x2cf3' },
  { U'\x2d6f', U'\x2d61' },
  { U'\x2e9f', U'\x6bcd' },
  { U'\x2ef3', U'\x9f9f' },
  { U'\x2f00', U'\x4e00' },
  { U'\x2f01', U'\x4e28' },
  { U'\x2f02', U'\x4e36' },
  { U'\x2f03', U'\x4e3f' },
  { U'\x2f04', U'\x4e59' },
  { U'\x2f05', U'\x4e85' },
  { U'\x2f06', U'\x4e8c' },
  { U'\x2f07', U'\x4ea0' },
  { U'\x2f08', U'\x4eba' },
  { U'\x2f09', U'\x513f' },
  { U'\x2f0a', U'\x5165' },
  { U'\x2f0b', U'\x516b' },
  { U'\x2f0c', U'\x5182' },
  { U'\x2f0d', U'\x5196' },
  { U'\x2f0e', U'\x51ab' },
  { U'\x2f0f', U'\x51e0' },
  { U'\x2f10', U'\x51f5' },
  { U'\x2f11', U'\x5200' },
  { U'\x2f12', U'\x529b' },
  { U'\x2f13', U'\x52f9' },
  { U'\x2f14', U'\x5315' },
  { U'\x2f15', U'\x531a' },
  { U'\x2f16', U'\x5338' },
  { U'\x2f17', U'\x5341' },
  { U'\x2f18', U'\x535c' },
  { U'\x2f19', U'\x5369' },
  { U'\x2f1a', U'\x5382' },
  { U'\x2f1b', U'\x53b6' },
  { U'\x2f1c', U'\x53c8' },
  { U'\x2f1d', U'\x53e3' },
  { U'\x2f1e', U'\x56d7' },
  { U'\x2f1f', U'\x571f' },
  { U'\x2f20', U'\x58eb' },
  { U'\x2f21', U'\x5902' },
  { U'\x2f22', U'\x590a' },
  { U'\x2f23', U'\x5915' },
  { U'\x2f24', U'\x5927' },
  { U'\x2f25', U'\x5973' },
  { U'\x2f26', U'\x5b50' },
  { U'\x2f27', U'\x5b80' },
  { U'\x2f28', U'\x5bf8' },
  { U'\x2f29', U'\x5c0f' },
  { U'\x2f2a', U'\x5c22' },
  { U'\x2f2b', U'\x5c38' },
  { U'\x2f2c', U'\x5c6e' },
  { U'\x2f2d', U'\x5c71' },
  { U'\x2f2e', U'\x5ddb' },
  { U'\x2f2f', U'\x5de5' },
  { U'\x2f30', U'\x5df1' },
  { U'\x2f31', U'\x5dfe' },
  { U'\x2f32', U'\x5e72' },
  { U'\x2f33', U'\x5e7a' },
  { U'\x2f34', U'\x5e7f' },
  { U'\x2f35', U'\x5ef4' },
  { U'\x2f36', U'\x5efe' },
  { U'\x2f37', U'\x5f0b' },
  { U'\x2f38', U'\x5f13' },
  { U'\x2f39', U'\x5f50' },
  { U'\x2f3a', U'\x5f61' },
  { U'\x2f3b', U'\x5f73' },
  { U'\x2f3c', U'\x5fc3' },
  { U'\x2f3d', U'\x6208' },
  { U'\x2f3e', U'\x6236' },
  { U'\x2f3f', U'\x624b' },
  { U'\x2f40', U'\x652f' },
  { U'\x2f41', U'\x6534' },
  { U'\x2f42', U'\x6587' },
  { U'\x2f43', U'\x6597' },
  { U'\x2f44', U'\x65a4' },
  { U'\x2f45', U'\x65b9' },
  { U'\x2f46', U'\x65e0' },
  { U'\x2f47', U'\x65e5' },
  { U'\x2f48', U'\x66f0' },
  { U'\x2f49', U'\x6708' },
  { U'\x2f4a', U'\x6728' },
  { U'\x2f4b', U'\x6b20' },
  { U'\x2f4c', U'\x6b62' },
  { U'\x2f4d', U'\x6b79' },
  { U'\x2f4e', U'\x6bb3' },
  { U'\x2f4f', U'\x6bcb' },
  { U'\x2f50', U'\x6bd4' },
  { U'\x2f51', U'\x6bdb' },
  { U'\x2f52', U'\x6c0f' },
  { U'\x2f53', U'\x6c14' },
  { U'\x2f54', U'\x6c34' },
  { U'\x2f55', U'\x706b' },
  { U'\x2f56', U'\x722a' },
  { U'\x2f57', U'\x7236' },
  { U'\x2f58', U'\x723b' },
  { U'\x2f59', U'\x723f' },
  { U'\x2f5a', U'\x7247' },
  { U'\x2f5b', U'\x7259' },
  { U'\x2f5c', U'\x725b' },
  { U'\x2f5d', U'\x72ac' },
  { U'\x2f5e', U'\x7384' },
  { U'\x2f5f', U'\x7389' },
  { U'\x2f60', U'\x74dc' },
  { U'\x2f61', U'\x74e6' },
  { U'\x2f62', U'\x7518' },
  { U'\x2f63', U'\x751f' },
  { U'\x2f64', U'\x7528' },
  { U'\x2f65', U'\x7530' },
  { U'\x2f66', U'\x758b' },
  { U'\x2f67', U'\x7592' },
  { U'\x2f68', U'\x7676' },
  { U'\x2f69', U'\x767d' },
  { U'\x2f6a', U'\x76ae' },
  { U'\x2f6b', U'\x76bf' },
  { U'\x2f6c', U'\x76ee' },
  { U'\x2f6d', U'\x77db' },
  { U'\x2f6e', U'\x77e2' },
  { U'\x2f6f', U'\x77f3' },
  { U'\x2f70', U'\x793a' },
  { U'\x2f71', U'\x79b8' },
  { U'\x2f72', U'\x79be' },
  { U'\x2f73', U'\x7a74' },
  { U'\x2f74', U'\x7acb' },
  { U'\x2f75', U'\x7af9' },
  { U'\x2f76', U'\x7c73' },
  { U'\x2f77', U'\x7cf8' },
  { U'\x2f78', U'\x7f36' },
  { U'\x2f79', U'\x7f51' },
  { U'\x2f7a', U'\x7f8a' },
  { U'\x2f7b', U'\x7fbd' },
  { U'\x2f7c', U'\x8001' },
  { U'\x2f7d', U'\x800c' },
  { U'\x2f7e', U'\x8012' },
  { U'\x2f7f', U'\x8033' },
  { U'\x2f80', U'\x807f' },
  { U'\x2f81', U'\x8089' },
  { U'\x2f82', U'\x81e3' },
  { U'\x2f83', U'\x81ea' },
  { U'\x2f84', U'\x81f3' },
  { U'\x2f85', U'\x81fc' },
  { U'\x2f86', U'\x820c' },
  { U'\x2f87', U'\x821b' },
  { U'\x2f88', U'\x821f' },
  { U'\x2f89', U'\x826e' },
  { U'\x2f8a', U'\x8272' },
  { U'\x2f8b', U'\x8278' },
  { U'\x2f8c', U'\x864d' },
  { U'\x2f8d', U'\x866b' },
  { U'\x2f8e', U'\x8840' },
  { U'\x2f8f', U'\x884c' },
  { U'\x2f90', U'\x8863' },
  { U'\x2f91', U'\x897e' },
  { U'\x2f92', U'\x898b' },
  { U'\x2f93', U'\x89d2' },
  { U'\x2f94', U'\x8a00' },
  { U'\x2f95', U'\x8c37' },
  { U'\x2f96', U'\x8c46' },
  { U'\x2f97', U'\x8c55' },
  { U'\x2f98', U'\x8c78' },
  { U'\x2f99', U'\x8c9d' },
  { U'\x2f9a', U'\x8d64' },
  { U'\x2f9b', U'\x8d70' },
  { U'\x2f9c', U'\x8db3' },
  { U'\x2f9d', U'\x8eab' },
  { U'\x2f9e', U'\x8eca' },
  { U'\x2f9f', U'\x8f9b' },
  { U'\x2fa0', U'\x8fb0' },
  { U'\x2fa1', U'\x8fb5' },
  { U'\x2fa2', U'\x9091' },
  { U'\x2fa3', U'\x9149' },
  { U'\x2fa4', U'\x91c6' },
  { U'\x2fa5', U'\x91cc' },
  { U'\x2fa6', U'\x91d1' },
  { U'\x2fa7', U'\x9577' },
  { U'\x2fa8', U'\x9580' },
  { U'\x2fa9', U'\x961c' },
  { U'\x2faa', U'\x96b6' },
  { U'\x2fab', U'\x96b9' },
  { U'\x2fac', U'\x96e8' },
  { U'\x2fad', U'\x9751' },
  { U'\x2fae', U'\x975e' },
  { U'\x2faf', U'\x9762' },
  { U'\x2fb0', U'\x9769' },
  { U'\x2fb1', U'\x97cb' },
  { U'\x2fb2', U'\x97ed' },
  { U'\x2fb3', U'\x97f3' },
  { U'\x2fb4', U'\x9801' },
  { U'\x2fb5', U'\x98a8' },
  { U'\x2fb6', U'\x98db' },
  { U'\x2fb7', U'\x98df' },
  { U'\x2fb8', U'\x9996' },
  { U'\x2fb9', U'\x9999' },
  { U'\x2fba', U'\x99ac' },
  { U'\x2fbb', U'\x9aa8' },
  { U'\x2fbc', U'\x9ad8' },
  { U'\x2fbd', U'\x9adf' },
  { U'\x2fbe', U'\x9b25' },
  { U'\x2fbf', U'\x9b2f' },
  { U'\x2fc0', U'\x9b32' },
  { U'\x2fc1', U'\x9b3c' },
  { U'\x2fc2', U'\x9b5a' },
  { U'\x2fc3', U'\x9ce5' },
  { U'\x2fc4', U'\x9e75' },
  { U'\x2fc5', U'\x9e7f' },
  { U'\x2fc6', U'\x9ea5' },
  { U'\x2fc7', U'\x9ebb' },
  { U'\x2fc8', U'\x9ec3' },
  { U'\x2fc9', U'\x9ecd' },
  { U'\x2fca', U'\x9ed1' },
  { U'\x2fcb', U'\x9ef9' },
  { U'\x2fcc', U'\x9efd' },
  { U'\x2fcd', U'\x9f0e' },
  { U'\x2fce', U'\x9f13' },
  { U'\x2fcf', U'\x9f20' },
  { U'\x2fd0', U'\x9f3b' },
  { U'\x2fd1', U'\x9f4a' },
  { U'\x2fd2', U'\x9f52' },
  { U'\x2fd3', U'\x9f8d' },
  { U'\x2fd4', U'\x9f9c' },
  { U'\x2fd5', U'\x9fa0' },
  { U'\x3000', U'\x0020' },
  { U'\x3002', U'\x002e' },
  { U'\x3036', U'\x3012' },
  { U'\x3038', U'\x5341' },
  { U'\x3039', U'\x5344' },
  { U'\x303a', U'\x5345' },
  { U'\x309b', U'\x0020' },
  { U'\x309c', U'\x0020' },
  { U'\x309f', U'\x3088' },
  { U'\x30ff', U'\x30b3' },
  { U'\x3131', U'\x1100' },
  { U'\x3132', U'\x1101' },
  { U'\x3133', U'\x11aa' },
  { U'\x3134', U'\x1102' },
  { U'\x3135', U'\x11ac' },
  { U'\x3136', U'\x11ad' },
  { U'\x3137', U'\x1103' },
  { U'\x3138', U'\x1104' },
  { U'\x3139', U'\x1105' },
  { U'\x313a', U'\x11b0' },
  { U'\x313b', U'\x11b1' },
  { U'\x313c', U'\x11b2' },
  { U'\x313d', U'\x11b3' },
  { U'\x313e', U'\x11b4' },
  { U'\x313f', U'\x11b5' },
  { U'\x3140', U'\x111a' },
  { U'\x3141', U'\x1106' },
  { U'\x3142', U'\x1107' },
  { U'\x3143', U'\x1108' },
  { U'\x3144', U'\x1121' },
  { U'\x3145', U'\x1109' },
  { U'\x3146', U'\x110a' },
  { U'\x3147', U'\x110b' },
  { U'\x3148', U'\x110c' },
  { U'\x3149', U'\x110d' },
  { U'\x314a', U'\x110e' },
  { U'\x314b', U'\x110f' },
  { U'\x314c', U'\x1110' },
  { U'\x314d', U'\x1111' },
  { U'\x314e', U'\x1112' },
  { U'\x314f', U'\x1161' },
  { U'\x3150', U'\x1162' },
  { U'\x3151', U'\x1163' },
  { U'\x3152', U'\x1164' },
  { U'\x3153', U'\x1165' },
  { U'\x3154', U'\x1166' },
  { U'\x3155', U'\x1167' },
  { U'\x3156', U'\x1168' },
  { U'\x3157', U'\x1169' },
  { U'\x3158', U'\x116a' },
  { U'\x3159', U'\x116b' },
  { U'\x315a', U'\x116c' },
  { U'\x315b', U'\x116d' },
  { U'\x315c', U'\x116e' },
  { U'\x315d', U'\x116f' },
  { U'\x315e', U'\x1170' },
  { U'\x315f', U'\x1171' },
  { U'\x3160', U'\x1172' },
  { U'\x3161', U'\x1173' },
  { U'\x3162', U'\x1174' },
  { U'\x3163', U'\x1175' },
  { U'\x3165', U'\x1114' },
  { U'\x3166', U'\x1115' },
  { U'\x3167', U'\x11c7' },
  { U'\x3168', U'\x11c8' },
  { U'\x3169', U'\x11cc' },
  { U'\x316a', U'\x11ce' },
  { U'\x316b', U'\x11d3' },
  { U'\x316c', U'\x11d7' },
  { U'\x316d', U'\x11d9' },
  { U'\x316e', U'\x111c' },
  { U'\x316f', U'\x11dd' },
  { U'\x3170', U'\x11df' },
  { U'\x3171', U'\x111d' },
  { U'\x3172', U'\x111e' },
  { U'\x3173', U'\x1120' },
  { U'\x3174', U'\x1122' },
  { U'\x3175', U'\x1123' },
  { U'\x3176', U'\x1127' },
  { U'\x3177', U'\x1129' },
  { U'\x3178', U'\x112b' },
  { U'\x3179', U'\x112c' },
  { U'\x317a', U'\x112d' },
  { U'\x317b', U'\x112e' },
  { U'\x317c', U'\x112f' },
  { U'\x317d', U'\x1132' },
  { U'\x317e', U'\x1136' },
  { U'\x317f', U'\x1140' },
  { U'\x3180', U'\x1147' },
  { U'\x3181', U'\x114c' },
  { U'\x3182', U'\x11f1' },
  { U'\x3183', U'\x11f2' },
  { U'\x3184', U'\x1157' },
  { U'\x3185', U'\x1158' },
  { U'\x3186', U'\x1159' },
  { U'\x3187', U'\x1184' },
  { U'\x3188', U'\x1185' },
  { U'\x3189', U'\x1188' },
  { U'\x318a', U'\x1191' },
  { U'\x318b', U'\x1192' },
  { U'\x318c', U'\x1194' },
  { U'\x318d', U'\x119e' },
  { U'\x318e', U'\x11a1' },
  { U'\x3192', U'\x4e00' },
  { U'\x3193', U'\x4e8c' },
  { U'\x3194', U'\x4e09' },
  { U'\x3195', U'\x56db' },
  { U'\x3196', U'\x4e0a' },
  { U'\x3197', U'\x4e2d' },
  { U'\x3198', U'\x4e0b' },
  { U'\x3199', U'\x7532' },
  { U'\x319a', U'\x4e59' },
  { U'\x319b', U'\x4e19' },
  { U'\x319c', U'\x4e01' },
  { U'\x319d', U'\x5929' },
  { U'\x319e', U'\x5730' },
  { U'\x319f', U'\x4eba' },
  { U'\x3200', U'\x0028' },
  { U'\x3201', U'\x0028' },
  { U'\x3202', U'\x0028' },
  { U'\x3203', U'\x0028' },
  { U'\x3204', U'\x0028' },
  { U'\x3205', U'\x0028' },
  { U'\x3206', U'\x0028' },
  { U'\x3207', U'\x0028' },
  { U'\x3208', U'\x0028' },
  { U'\x3209', U'\x0028' },
  { U'\x320a', U'\x0028' },
  { U'\x320b', U'\x0028' },
  { U'\x320c', U'\x0028' },
  { U'\x320d', U'\x0028' },
  { U'\x320e', U'\x0028' },
  { U'\x320f', U'\x0028' },
  { U'\x3210', U'\x0028' },
  { U'\x3211', U'\x0028' },
  { U'\x3212', U'\x0028' },
  { U'\x3213', U'\x0028' },
  { U'\x3214', U'\x0028' },
  { U'\x3215', U'\x0028' },
  { U'\x3216', U'\x0028' },
  { U'\x3217', U'\x0028' },
  { U'\x3218', U'\x0028' },
  { U'\x3219', U'\x0028' },
  { U'\x321a', U'\x0028' },
  { U'\x321b', U'\x0028' },
  { U'\x321c', U'\x0028' },
  { U'\x321d', U'\x0028' },
  { U'\x321e', U'\x0028' },
  { U'\x3220', U'\x0028' },
  { U'\x3221', U'\x0028' },
  { U'\x3222', U'\x0028' },
  { U'\x3223', U'\x0028' },
  { U'\x3224', U'\x0028' },
  { U'\x3225', U'\x0028' },
  { U'\x3226', U'\x0028' },
  { U'\x3227', U'\x0028' },
  { U'\x3228', U'\x0028' },
  { U'\x3229', U'\x0028' },
  { U'\x322a', U'\x0028' },
  { U'\x322b', U'\x0028' },
  { U'\x322c', U'\x0028' },
  { U'\x322d', U'\x0028' },
  { U'\x322e', U'\x0028' },
  { U'\x322f', U'\x0028' },
  { U'\x3230', U'\x0028' },
  { U'\x3231', U'\x0028' },
  { U'\x3232', U'\x0028' },
  { U'\x3233', U'\x0028' },
  { U'\x3234', U'\x0028' },
  { U'\x3235', U'\x0028' },
  { U'\x3236', U'\x0028' },
  { U'\x3237', U'\x0028' },
  { U'\x3238', U'\x0028' },
  { U'\x3239', U'\x0028' },
  { U'\x323a', U'\x0028' },
  { U'\x323b', U'\x0028' },
  { U'\x323c', U'\x0028' },
  { U'\x323d', U'\x0028' },
  { U'\x323e', U'\x0028' },
  { U'\x323f', U'\x0028' },
  { U'\x3240', U'\x0028' },
  { U'\x3241', U'\x0028' },
  { U'\x3242', U'\x0028' },
  { U'\x3243', U'\x0028' },
  { U'\x3244', U'\x554f' },
  { U'\x3245', U'\x5e7c' },
  { U'\x3246', U'\x6587' },
  { U'\x3247', U'\x7b8f' },
  { U'\x3250', U'\x0070' },
  { U'\x3251', U'\x0032' },
  { U'\x3252', U'\x0032' },
  { U'\x3253', U'\x0032' },
  { U'\x3254', U'\x0032' },
  { U'\x3255', U'\x0032' },
  { U'\x3256', U'\x0032' },
  { U'\x3257', U'\x0032' },
  { U'\x3258', U'\x0032' },
  { U'\x3259', U'\x0032' },
  { U'\x325a', U'\x0033' },
  { U'\x325b', U'\x0033' },
  { U'\x325c', U'\x0033' },
  { U'\x325d', U'\x0033' },
  { U'\x325e', U'\x0033' },
  { U'\x325f', U'\x0033' },
  { U'\x3260', U'\x1100' },
  { U'\x3261', U'\x1102' },
  { U'\x3262', U'\x1103' },
  { U'\x3263', U'\x1105' },
  { U'\x3264', U'\x1106' },
  { U'\x3265', U'\x1107' },
  { U'\x3266', U'\x1109' },
  { U'\x3267', U'\x110b' },
  { U'\x3268', U'\x110c' },
  { U'\x3269', U'\x110e' },
  { U'\x326a', U'\x110f' },
  { U'\x326b', U'\x1110' },
  { U'\x326c', U'\x1111' },
  { U'\x326d', U'\x1112' },
  { U'\x326e', U'\xac00' },
  { U'\x326f', U'\xb098' },
  { U'\x3270', U'\xb2e4' },
  { U'\x3271', U'\xb77c' },
  { U'\x3272', U'\xb9c8' },
  { U'\x3273', U'\xbc14' },
  { U'\x3274', U'\xc0ac' },
  { U'\x3275', U'\xc544' },
  { U'\x3276', U'\xc790' },
  { U'\x3277', U'\xcc28' },
  { U'\x3278', U'\xce74' },
  { U'\x3279', U'\xd0c0' },
  { U'\x327a', U'\xd30c' },
  { U'\x327b', U'\xd558' },
  { U'\x327c', U'\xcc38' },
  { U'\x327d', U'\xc8fc' },
  { U'\x327e', U'\xc6b0' },
  { U'\x3280', U'\x4e00' },
  { U'\x3281', U'\x4e8c' },
  { U'\x3282', U'\x4e09' },
  { U'\x3283', U'\x56db' },
  { U'\x3284', U'\x4e94' },
  { U'\x3285', U'\x516d' },
  { U'\x3286', U'\x4e03' },
  { U'\x3287', U'\x516b' },
  { U'\x3288', U'\x4e5d' },
  { U'\x3289', U'\x5341' },
  { U'\x328a', U'\x6708' },
  { U'\x328b', U'\x706b' },
  { U'\x328c', U'\x6c34' },
  { U'\x328d', U'\x6728' },
  { U'\x328e', U'\x91d1' },
  { U'\x328f', U'\x571f' },
  { U'\x3290', U'\x65e5' },
  { U'\x3291', U'\x682a' },
  { U'\x3292', U'\x6709' },
  { U'\x3293', U'\x793e' },
  { U'\x3294', U'\x540d' },
  { U'\x3295', U'\x7279' },
  { U'\x3296', U'\x8ca1' },
  { U'\x3297', U'\x795d' },
  { U'\x3298', U'\x52b4' },
  { U'\x3299', U'\x79d8' },
  { U'\x329a', U'\x7537' },
  { U'\x329b', U'\x5973' },
  { U'\x329c', U'\x9069' },
  { U'\x329d', U'\x512a' },
  { U'\x329e', U'\x5370' },
  { U'\x329f', U'\x6ce8' },
  { U'\x32a0', U'\x9805' },
  { U'\x32a1', U'\x4f11' },
  { U'\x32a2', U'\x5199' },
  { U'\x32a3', U'\x6b63' },
  { U'\x32a4', U'\x4e0a' },
  { U'\x32a5', U'\x4e2d' },
  { U'\x32a6', U'\x4e0b' },
  { U'\x32a7', U'\x5de6' },
  { U'\x32a8', U'\x53f3' },
  { U'\x32a9', U'\x533b' },
  { U'\x32aa', U'\x5b97' },
  { U'\x32ab', U'\x5b66' },
  { U'\x32ac', U'\x76e3' },
  { U'\x32ad', U'\x4f01' },
  { U'\x32ae', U'\x8cc7' },
  { U'\x32af', U'\x5354' },
  { U'\x32b0', U'\x591c' },
  { U'\x32b1', U'\x0033' },
  { U'\x32b2', U'\x0033' },
  { U'\x32b3', U'\x0033' },
  { U'\x32b4', U'\x0033' },
  { U'\x32b5', U'\x0034' },
  { U'\x32b6', U'\x0034' },
  { U'\x32b7', U'\x0034' },
  { U'\x32b8', U'\x0034' },
  { U'\x32b9', U'\x0034' },
  { U'\x32ba', U'\x0034' },
  { U'\x32bb', U'\x0034' },
  { U'\x32bc', U'\x0034' },
  { U'\x32bd', U'\x0034' },
  { U'\x32be', U'\x0034' },
  { U'\x32bf', U'\x0035' },
  { U'\x32c0', U'\x0031' },
  { U'\x32c1', U'\x0032' },
  { U'\x32c2', U'\x0033' },
  { U'\x32c3', U'\x0034' },
  { U'\x32c4', U'\x0035' },
  { U'\x32c5', U'\x0036' },
  { U'\x32c6', U'\x0037' },
  { U'\x32c7', U'\x0038' },
  { U'\x32c8', U'\x0039' },
  { U'\x32c9', U'\x0031' },
  { U'\x32ca', U'\x0031' },
  { U'\x32cb', U'\x0031' },
  { U'\x32cc', U'\x0068' },
  { U'\x32cd', U'\x0065' },
  { U'\x32ce', U'\x0065' },
  { U'\x32cf', U'\x006c' },
  { U'\x32d0', U'\x30a2' },
  { U'\x32d1', U'\x30a4' },
  { U'\x32d2', U'\x30a6' },
  { U'\x32d3', U'\x30a8' },
  { U'\x32d4', U'\x30aa' },
  { U'\x32d5', U'\x30ab' },
  { U'\x32d6', U'\x30ad' },
  { U'\x32d7', U'\x30af' },
  { U'\x32d8', U'\x30b1' },
  { U'\x32d9', U'\x30b3' },
  { U'\x32da', U'\x30b5' },
  { U'\x32db', U'\x30b7' },
  { U'\x32dc', U'\x30b9' },
  { U'\x32dd', U'\x30bb' },
  { U'\x32de', U'\x30bd' },
  { U'\x32df', U'\x30bf' },
  { U'\x32e0', U'\x30c1' },
  { U'\x32e1', U'\x30c4' },
  { U'\x32e2', U'\x30c6' },
  { U'\x32e3', U'\x30c8' },
  { U'\x32e4', U'\x30ca' },
  { U'\x32e5', U'\x30cb' },
  { U'\x32e6', U'\x30cc' },
  { U'\x32e7', U'\x30cd' },
  { U'\x32e8', U'\x30ce' },
  { U'\x32e9', U'\x30cf' },
  { U'\x32ea', U'\x30d2' },
  { U'\x32eb', U'\x30d5' },
  { U'\x32ec', U'\x30d8' },
  { U'\x32ed', U'\x30db' },
  { U'\x32ee', U'\x30de' },
  { U'\x32ef', U'\x30df' },
  { U'\x32f0', U'\x30e0' },
  { U'\x32f1', U'\x30e1' },
  { U'\x32f2', U'\x30e2' },
  { U'\x32f3', U'\x30e4' },
  { U'\x32f4', U'\x30e6' },
  { U'\x32f5', U'\x30e8' },
  { U'\x32f6', U'\x30e9' },
  { U'\x32f7', U'\x30ea' },
  { U'\x32f8', U'\x30eb' },
  { U'\x32f9', U'\x30ec' },
  { U'\x32fa', U'\x30ed' },
  { U'\x32fb', U'\x30ef' },
  { U'\x32fc', U'\x30f0' },
  { U'\x32fd', U'\x30f1' },
  { U'\x32fe', U'\x30f2' },
  { U'\x32ff', U'\x4ee4' },
  { U'\x3300', U'\x30a2' },
  { U'\x3301', U'\x30a2' },
  { U'\x3302', U'\x30a2' },
  { U'\x3303', U'\x30a2' },
  { U'\x3304', U'\x30a4' },
  { U'\x3305', U'\x30a4' },
  { U'\x3306', U'\x30a6' },
  { U'\x3307', U'\x30a8' },
  { U'\x3308', U'\x30a8' },
  { U'\x3309', U'\x30aa' },
  { U'\x330a', U'\x30aa' },
  { U'\x330b', U'\x30ab' },
  { U'\x330c', U'\x30ab' },
  { U'\x330d', U'\x30ab' },
  { U'\x330e', U'\x30ac' },
  { U'\x330f', U'\x30ac' },
  { U'\x3310', U'\x30ae' },
  { U'\x3311', U'\x30ae' },
  { U'\x3312', U'\x30ad' },
  { U'\x3313', U'\x30ae' },
  { U'\x3314', U'\x30ad' },
  { U'\x3315', U'\x30ad' },
  { U'\x3316', U'\x30ad' },
  { U'\x3317', U'\x30ad' },
  { U'\x3318', U'\x30b0' },
  { U'\x3319', U'\x30b0' },
  { U'\x331a', U'\x30af' },
  { U'\x331b', U'\x30af' },
  { U'\x331c', U'\x30b1' },
  { U'\x331d', U'\x30b3' },
  { U'\x331e', U'\x30b3' },
  { U'\x331f', U'\x30b5' },
  { U'\x3320', U'\x30b5' },
  { U'\x3321', U'\x30b7' },
  { U'\x3322', U'\x30bb' },
  { U'\x3323', U'\x30bb' },
  { U'\x3324', U'\x30c0' },
  { U'\x3325', U'\x30c7' },
  { U'\x3326', U'\x30c9' },
  { U'\x3327', U'\x30c8' },
  { U'\x3328', U'\x30ca' },
  { U'\x3329', U'\x30ce' },
  { U'\x332a', U'\x30cf' },
  { U'\x332b', U'\x30d1' },
  { U'\x332c', U'\x30d1' },
  { U'\x332d', U'\x30d0' },
  { U'\x332e', U'\x30d4' },
  { U'\x332f', U'\x30d4' },
  { U'\x3330', U'\x30d4' },
  { U'\x3331', U'\x30d3' },
  { U'\x3332', U'\x30d5' },
  { U'\x3333', U'\x30d5' },
  { U'\x3334', U'\x30d6' },
  { U'\x3335', U'\x30d5' },
  { U'\x3336', U'\x30d8' },
  { U'\x3337', U'\x30da' },
  { U'\x3338', U'\x30da' },
  { U'\x3339', U'\x30d8' },
  { U'\x333a', U'\x30da' },
  { U'\x333b', U'\x30da' },
  { U'\x333c', U'\x30d9' },
  { U'\x333d', U'\x30dd' },
  { U'\x333e', U'\x30dc' },
  { U'\x333f', U'\x30db' },
  { U'\x3340', U'\x30dd' },
  { U'\x3341', U'\x30db' },
  { U'\x3342', U'\x30db' },
  { U'\x3343', U'\x30de' },
  { U'\x3344', U'\x30de' },
  { U'\x3345', U'\x30de' },
  { U'\x3346', U'\x30de' },
  { U'\x3347', U'\x30de' },
  { U'\x3348', U'\x30df' },
  { U'\x3349', U'\x30df' },
  { U'\x334a', U'\x30df' },
  { U'\x334b', U'\x30e1' },
  { U'\x334c', U'\x30e1' },
  { U'\x334d', U'\x30e1' },
  { U'\x334e', U'\x30e4' },
  { U'\x334f', U'\x30e4' },
  { U'\x3350', U'\x30e6' },
  { U'\x3351', U'\x30ea' },
  { U'\x3352', U'\x30ea' },
  { U'\x3353', U'\x30eb' },
  { U'\x3354', U'\x30eb' },
  { U'\x3355', U'\x30ec' },
  { U'\x3356', U'\x30ec' },
  { U'\x3357', U'\x30ef' },
  { U'\x3358', U'\x0030' },
  { U'\x3359', U'\x0031' },
  { U'\x335a', U'\x0032' },
  { U'\x335b', U'\x0033' },
  { U'\x335c', U'\x0034' },
  { U'\x335d', U'\x0035' },
  { U'\x335e', U'\x0036' },
  { U'\x335f', U'\x0037' },
  { U'\x3360', U'\x0038' },
  { U'\x3361', U'\x0039' },
  { U'\x3362', U'\x0031' },
  { U'\x3363', U'\x0031' },
  { U'\x3364', U'\x0031' },
  { U'\x3365', U'\x0031' },
  { U'\x3366', U'\x0031' },
  { U'\x3367', U'\x0031' },
  { U'\x3368', U'\x0031' },
  { U'\x3369', U'\x0031' },
  { U'\x336a', U'\x0031' },
  { U'\x336b', U'\x0031' },
  { U'\x336c', U'\x0032' },
  { U'\x336d', U'\x0032' },
  { U'\x336e', U'\x0032' },
  { U'\x336f', U'\x0032' },
  { U'\x3370', U'\x0032' },
  { U'\x3371', U'\x0068' },
  { U'\x3372', U'\x0064' },
  { U'\x3373', U'\x0061' },
  { U'\x3374', U'\x0062' },
  { U'\x3375', U'\x006f' },
  { U'\x3376', U'\x0070' },
  { U'\x3377', U'\x0064' },
  { U'\x3378', U'\x0064' },
  { U'\x3379', U'\x0064' },
  { U'\x337a', U'\x0069' },
  { U'\x337b', U'\x5e73' },
  { U'\x337c', U'\x662d' },
  { U'\x337d', U'\x5927' },
  { U'\x337e', U'\x660e' },
  { U'\x337f', U'\x682a' },
  { U'\x3380', U'\x0070' },
  { U'\x3381', U'\x006e' },
  { U'\x3382', U'\x03bc' },
  { U'\x3383', U'\x006d' },
  { U'\x3384', U'\x006b' },
  { U'\x3385', U'\x006b' },
  { U'\x3386', U'\x006d' },
  { U'\x3387', U'\x0067' },
  { U'\x3388', U'\x0063' },
  { U'\x3389', U'\x006b' },
  { U'\x338a', U'\x0070' },
  { U'\x338b', U'\x006e' },
  { U'\x338c', U'\x03bc' },
  { U'\x338d', U'\x03bc' },
  { U'\x338e', U'\x006d' },
  { U'\x338f', U'\x006b' },
  { U'\x3390', U'\x0068' },
  { U'\x3391', U'\x006b' },
  { U'\x3392', U'\x006d' },
  { U'\x3393', U'\x0067' },
  { U'\x3394', U'\x0074' },
  { U'\x3395', U'\x03bc' },
  { U'\x3396', U'\x006d' },
  { U'\x3397', U'\x0064' },
  { U'\x3398', U'\x006b' },
  { U'\x3399', U'\x0066' },
  { U'\x339a', U'\x006e' },
  { U'\x339b', U'\x03bc' },
  { U'\x339c', U'\x006d' },
  { U'\x339d', U'\x0063' },
  { U'\x339e', U'\x006b' },
  { U'\x339f', U'\x006d' },
  { U'\x33a0', U'\x0063' },
  { U'\x33a1', U'\x006d' },
  { U'\x33a2', U'\x006b' },
  { U'\x33a3', U'\x006d' },
  { U'\x33a4', U'\x0063' },
  { U'\x33a5', U'\x006d' },
  { U'\x33a6', U'\x006b' },
  { U'\x33a7', U'\x006d' },
  { U'\x33a8', U'\x006d' },
  { U'\x33a9', U'\x0070' },
  { U'\x33aa', U'\x006b' },
  { U'\x33ab', U'\x006d' },
  { U'\x33ac', U'\x0067' },
  { U'\x33ad', U'\x0072' },
  { U'\x33ae', U'\x0072' },
  { U'\x33af', U'\x0072' },
  { U'\x33b0', U'\x0070' },
  { U'\x33b1', U'\x006e' },
  { U'\x33b2', U'\x03bc' },
  { U'\x33b3', U'\x006d' },
  { U'\x33b4', U'\x0070' },
  { U'\x33b5', U'\x006e' },
  { U'\x33b6', U'\x03bc' },
  { U'\x33b7', U'\x006d' },
  { U'\x33b8', U'\x006b' },
  { U'\x33b9', U'\x006d' },
  { U'\x33ba', U'\x0070' },
  { U'\x33bb', U'\x006e' },
  { U'\x33bc', U'\x03bc' },
  { U'\x33bd', U'\x006d' },
  { U'\x33be', U'\x006b' },
  { U'\x33bf', U'\x006d' },
  { U'\x33c0', U'\x006b' },
  { U'\x33c1', U'\x006d' },
  { U'\x33c3', U'\x0062' },
  { U'\x33c4', U'\x0063' },
  { U'\x33c5', U'\x0063' },
  { U'\x33c6', U'\x0063' },
  { U'\x33c8', U'\x0064' },
  { U'\x33c9', U'\x0067' },
  { U'\x33ca', U'\x0068' },
  { U'\x33cb', U'\x0068' },
  { U'\x33cc', U'\x0069' },
  { U'\x33cd', U'\x006b' },
  { U'\x33ce', U'\x006b' },
  { U'\x33cf', U'\x006b' },
  { U'\x33d0', U'\x006c' },
  { U'\x33d1', U'\x006c' },
  { U'\x33d2', U'\x006c' },
  { U'\x33d3', U'\x006c' },
  { U'\x33d4', U'\x006d' },
  { U'\x33d5', U'\x006d' },
  { U'\x33d6', U'\x006d' },
  { U'\x33d7', U'\x0070' },
  { U'\x33d9', U'\x0070' },
  { U'\x33da', U'\x0070' },
  { U'\x33db', U'\x0073' },
  { U'\x33dc', U'\x0073' },
  { U'\x33dd', U'\x0077' },
  { U'\x33de', U'\x0076' },
  { U'\x33df', U'\x0061' },
  { U'\x33e0', U'\x0031' },
  { U'\x33e1', U'\x0032' },
  { U'\x33e2', U'\x0033' },
  { U'\x33e3', U'\x0034' },
  { U'\x33e4', U'\x0035' },
  { U'\x33e5', U'\x0036' },
  { U'\x33e6', U'\x0037' },
  { U'\x33e7', U'\x0038' },
  { U'\x33e8', U'\x0039' },
  { U'\x33e9', U'\x0031' },
  { U'\x33ea', U'\x0031' },
  { U'\x33eb', U'\x0031' },
  { U'\x33ec', U'\x0031' },
  { U'\x33ed', U'\x0031' },
  { U'\x33ee', U'\x0031' },
  { U'\x33ef', U'\x0031' },
  { U'\x33f0', U'\x0031' },
  { U'\x33f1', U'\x0031' },
  { U'\x33f2', U'\x0031' },
  { U'\x33f3', U'\x0032' },
  { U'\x33f4', U'\x0032' },
  { U'\x33f5', U'\x0032' },
  { U'\x33f6', U'\x0032' },
  { U'\x33f7', U'\x0032' },
  { U'\x33f8', U'\x0032' },
  { U'\x33f9', U'\x0032' },
  { U'\x33fa', U'\x0032' },
  { U'\x33fb', U'\x0032' },
  { U'\x33fc', U'\x0032' },
  { U'\x33fd', U'\x0033' },
  { U'\x33fe', U'\x0033' },
  { U'\x33ff', U'\x0067' },
  { U'\xa640', U'\xa641' },
  { U'\xa642', U'\xa643' },
  { U'\xa644', U'\xa645' },
  { U'\xa646', U'\xa647' },
  { U'\xa648', U'\xa649' },
  { U'\xa64a', U'\xa64b' },
  { U'\xa64c', U'\xa64d' },
  { U'\xa64e', U'\xa64f' },
  { U'\xa650', U'\xa651' },
  { U'\xa652', U'\xa653' },
  { U'\xa654', U'\xa655' },
  { U'\xa656', U'\xa657' },
  { U'\xa658', U'\xa659' },
  { U'\xa65a', U'\xa65b' },
  { U'\xa65c', U'\xa65d' },
  { U'\xa65e', U'\xa65f' },
  { U'\xa660', U'\xa661' },
  { U'\xa662', U'\xa663' },
  { U'\xa664', U'\xa665' },
  { U'\xa666', U'\xa667' },
  { U'\xa668', U'\xa669' },
  { U'\xa66a', U'\xa66b' },
  { U'\xa66c', U'\xa66d' },
  { U'\xa680', U'\xa681' },
  { U'\xa682', U'\xa683' },
  { U'\xa684', U'\xa685' },
  { U'\xa686', U'\xa687' },
  { U'\xa688', U'\xa689' },
  { U'\xa68a', U'\xa68b' },
  { U'\xa68c', U'\xa68d' },
  { U'\xa68e', U'\xa68f' },
  { U'\xa690', U'\xa691' },
  { U'\xa692', U'\xa693' },
  { U'\xa694', U'\xa695' },
  { U'\xa696', U'\xa697' },
  { U'\xa698', U'\xa699' },
  { U'\xa69a', U'\xa69b' },
  { U'\xa69c', U'\x044a' },
  { U'\xa69d', U'\x044c' },
  { U'\xa722', U'\xa723' },
  { U'\xa724', U'\xa725' },
  { U'\xa726', U'\xa727' },
  { U'\xa728', U'\xa729' },
  { U'\xa72a', U'\xa72b' },
  { U'\xa72c', U'\xa72d' },
  { U'\xa72e', U'\xa72f' },
  { U'\xa732', U'\xa733' },
  { U'\xa734', U'\xa735' },
  { U'\xa736', U'\xa737' },
  { U'\xa738', U'\xa739' },
  { U'\xa73a', U'\xa73b' },
  { U'\xa73c', U'\xa73d' },
  { U'\xa73e', U'\xa73f' },
  { U'\xa740', U'\xa741' },
  { U'\xa742', U'\xa743' },
  { U'\xa744', U'\xa745' },
  { U'\xa746', U'\xa747' },
  { U'\xa748', U'\xa749' },
  { U'\xa74a', U'\xa74b' },
  { U'\xa74c', U'\xa74d' },
  { U'\xa74e', U'\xa74f' },
  { U'\xa750', U'\xa751' },
  { U'\xa752', U'\xa753' },
  { U'\xa754', U'\xa755' },
  { U'\xa756', U'\xa757' },
  { U'\xa758', U'\xa759' },
  { U'\xa75a', U'\xa75b' },
  { U'\xa75c', U'\xa75d' },
  { U'\xa75e', U'\xa75f' },
  { U'\xa760', U'\xa761' },
  { U'\xa762', U'\xa763' },
  { U'\xa764', U'\xa765' },
  { U'\xa766', U'\xa767' },
  { U'\xa768', U'\xa769' },
  { U'\xa76a', U'\xa76b' },
  { U'\xa76c', U'\xa76d' },
  { U'\xa76e', U'\xa76f' },
  { U'\xa770', U'\xa76f' },
  { U'\xa779', U'\xa77a' },
  { U'\xa77b', U'\xa77c' },
  { U'\xa77d', U'\x1d79' },
  { U'\xa77e', U'\xa77f' },
  { U'\xa780', U'\xa781' },
  { U'\xa782', U'\xa783' },
  { U'\xa784', U'\xa785' },
  { U'\xa786', U'\xa787' },
  { U'\xa78b', U'\xa78c' },
  { U'\xa78d', U'\x0265' },
  { U'\xa790', U'\xa791' },
  { U'\xa792', U'\xa793' },
  { U'\xa796', U'\xa797' },
  { U'\xa798', U'\xa799' },
  { U'\xa79a', U'\xa79b' },
  { U'\xa79c', U'\xa79d' },
  { U'\xa79e', U'\xa79f' },
  { U'\xa7a0', U'\xa7a1' },
  { U'\xa7a2', U'\xa7a3' },
  { U'\xa7a4', U'\xa7a5' },
  { U'\xa7a6', U'\xa7a7' },
  { U'\xa7a8', U'\xa7a9' },
  { U'\xa7aa', U'\x0266' },
  { U'\xa7ab', U'\x025c' },
  { U'\xa7ac', U'\x0261' },
  { U'\xa7ad', U'\x026c' },
  { U'\xa7ae', U'\x026a' },
  { U'\xa7b0', U'\x029e' },
  { U'\xa7b1', U'\x0287' },
  { U'\xa7b2', U'\x029d' },
  { U'\xa7b3', U'\xab53' },
  { U'\xa7b4', U'\xa7b5' },
  { U'\xa7b6', U'\xa7b7' },
  { U'\xa7b8', U'\xa7b9' },
  { U'\xa7ba', U'\xa7bb' },
  { U'\xa7bc', U'\xa7bd' },
  { U'\xa7be', U'\xa7bf' },
  { U'\xa7c2', U'\xa7c3' },
  { U'\xa7c4', U'\xa794' },
  { U'\xa7c5', U'\x0282' },
  { U'\xa7c6', U'\x1d8e' },
  { U'\xa7f8', U'\x0127' },
  { U'\xa7f9', U'\x0153' },
  { U'\xab5c', U'\xa727' },
  { U'\xab5d', U'\xab37' },
  { U'\xab5e', U'\x026b' },
  { U'\xab5f', U'\xab52' },
  { U'\xab70', U'\x13a0' },
  { U'\xab71', U'\x13a1' },
  { U'\xab72', U'\x13a2' },
  { U'\xab73', U'\x13a3' },
  { U'\xab74', U'\x13a4' },
  { U'\xab75', U'\x13a5' },
  { U'\xab76', U'\x13a6' },
  { U'\xab77', U'\x13a7' },
  { U'\xab78', U'\x13a8' },
  { U'\xab79', U'\x13a9' },
  { U'\xab7a', U'\x13aa' },
  { U'\xab7b', U'\x13ab' },
  { U'\xab7c', U'\x13ac' },
  { U'\xab7d', U'\x13ad' },
  { U'\xab7e', U'\x13ae' },
  { U'\xab7f', U'\x13af' },
  { U'\xab80', U'\x13b0' },
  { U'\xab81', U'\x13b1' },
  { U'\xab82', U'\x13b2' },
  { U'\xab83', U'\x13b3' },
  { U'\xab84', U'\x13b4' },
  { U'\xab85', U'\x13b5' },
  { U'\xab86', U'\x13b6' },
  { U'\xab87', U'\x13b7' },
  { U'\xab88', U'\x13b8' },
  { U'\xab89', U'\x13b9' },
  { U'\xab8a', U'\x13ba' },
  { U'\xab8b', U'\x13bb' },
  { U'\xab8c', U'\x13bc' },
  { U'\xab8d', U'\x13bd' },
  { U'\xab8e', U'\x13be' },
  { U'\xab8f', U'\x13bf' },
  { U'\xab90', U'\x13c0' },
  { U'\xab91', U'\x13c1' },
  { U'\xab92', U'\x13c2' },
  { U'\xab93', U'\x13c3' },
  { U'\xab94', U'\x13c4' },
  { U'\xab95', U'\x13c5' },
  { U'\xab96', U'\x13c6' },
  { U'\xab97', U'\x13c7' },
  { U'\xab98', U'\x13c8' },
  { U'\xab99', U'\x13c9' },
  { U'\xab9a', U'\x13ca' },
  { U'\xab9b', U'\x13cb' },
  { U'\xab9c', U'\x13cc' },
  { U'\xab9d', U'\x13cd' },
  { U'\xab9e', U'\x13ce' },
  { U'\xab9f', U'\x13cf' },
  { U'\xaba0', U'\x13d0' },
  { U'\xaba1', U'\x13d1' },
  { U'\xaba2', U'\x13d2' },
  { U'\xaba3', U'\x13d3' },
  { U'\xaba4', U'\x13d4' },
  { U'\xaba5', U'\x13d5' },
  { U'\xaba6', U'\x13d6' },
  { U'\xaba7', U'\x13d7' },
  { U'\xaba8', U'\x13d8' },
  { U'\xaba9', U'\x13d9' },
  { U'\xabaa', U'\x13da' },
  { U'\xabab', U'\x13db' },
  { U'\xabac', U'\x13dc' },
  { U'\xabad', U'\x13dd' },
  { U'\xabae', U'\x13de' },
  { U'\xabaf', U'\x13df' },
  { U'\xabb0', U'\x13e0' },
  { U'\xabb1', U'\x13e1' },
  { U'\xabb2', U'\x13e2' },
  { U'\xabb3', U'\x13e3' },
  { U'\xabb4', U'\x13e4' },
  { U'\xabb5', U'\x13e5' },
  { U'\xabb6', U'\x13e6' },
  { U'\xabb7', U'\x13e7' },
  { U'\xabb8', U'\x13e8' },
  { U'\xabb9', U'\x13e9' },
  { U'\xabba', U'\x13ea' },
  { U'\xabbb', U'\x13eb' },
  { U'\xabbc', U'\x13ec' },
  { U'\xabbd', U'\x13ed' },
  { U'\xabbe', U'\x13ee' },
  { U'\xabbf', U'\x13ef' },
  { U'\xf900', U'\x8c48' },
  { U'\xf901', U'\x66f4' },
  { U'\xf902', U'\x8eca' },
  { U'\xf903', U'\x8cc8' },
  { U'\xf904', U'\x6ed1' },
  { U'\xf905', U'\x4e32' },
  { U'\xf906', U'\x53e5' },
  { U'\xf907', U'\x9f9c' },
  { U'\xf909', U'\x5951' },
  { U'\xf90a', U'\x91d1' },
  { U'\xf90b', U'\x5587' },
  { U'\xf90c', U'\x5948' },
  { U'\xf90d', U'\x61f6' },
  { U'\xf90e', U'\x7669' },
  { U'\xf90f', U'\x7f85' },
  { U'\xf910', U'\x863f' },
  { U'\xf911', U'\x87ba' },
  { U'\xf912', U'\x88f8' },
  { U'\xf913', U'\x908f' },
  { U'\xf914', U'\x6a02' },
  { U'\xf915', U'\x6d1b' },
  { U'\xf916', U'\x70d9' },
  { U'\xf917', U'\x73de' },
  { U'\xf918', U'\x843d' },
  { U'\xf919', U'\x916a' },
  { U'\xf91a', U'\x99f1' },
  { U'\xf91b', U'\x4e82' },
  { U'\xf91c', U'\x5375' },
  { U'\xf91d', U'\x6b04' },
  { U'\xf91e', U'\x721b' },
  { U'\xf91f', U'\x862d' },
  { U'\xf920', U'\x9e1e' },
  { U'\xf921', U'\x5d50' },
  { U'\xf922', U'\x6feb' },
  { U'\xf923', U'\x85cd' },
  { U'\xf924', U'\x8964' },
  { U'\xf925', U'\x62c9' },
  { U'\xf926', U'\x81d8' },
  { U'\xf927', U'\x881f' },
  { U'\xf928', U'\x5eca' },
  { U'\xf929', U'\x6717' },
  { U'\xf92a', U'\x6d6a' },
  { U'\xf92b', U'\x72fc' },
  { U'\xf92c', U'\x90ce' },
  { U'\xf92d', U'\x4f86' },
  { U'\xf92e', U'\x51b7' },
  { U'\xf92f', U'\x52de' },
  { U'\xf930', U'\x64c4' },
  { U'\xf931', U'\x6ad3' },
  { U'\xf932', U'\x7210' },
  { U'\xf933', U'\x76e7' },
  { U'\xf934', U'\x8001' },
  { U'\xf935', U'\x8606' },
  { U'\xf936', U'\x865c' },
  { U'\xf937', U'\x8def' },
  { U'\xf938', U'\x9732' },
  { U'\xf939', U'\x9b6f' },
  { U'\xf93a', U'\x9dfa' },
  { U'\xf93b', U'\x788c' },
  { U'\xf93c', U'\x797f' },
  { U'\xf93d', U'\x7da0' },
  { U'\xf93e', U'\x83c9' },
  { U'\xf93f', U'\x9304' },
  { U'\xf940', U'\x9e7f' },
  { U'\xf941', U'\x8ad6' },
  { U'\xf942', U'\x58df' },
  { U'\xf943', U'\x5f04' },
  { U'\xf944', U'\x7c60' },
  { U'\xf945', U'\x807e' },
  { U'\xf946', U'\x7262' },
  { U'\xf947', U'\x78ca' },
  { U'\xf948', U'\x8cc2' },
  { U'\xf949', U'\x96f7' },
  { U'\xf94a', U'\x58d8' },
  { U'\xf94b', U'\x5c62' },
  { U'\xf94c', U'\x6a13' },
  { U'\xf94d', U'\x6dda' },
  { U'\xf94e', U'\x6f0f' },
  { U'\xf94f', U'\x7d2f' },
  { U'\xf950', U'\x7e37' },
  { U'\xf951', U'\x964b' },
  { U'\xf952', U'\x52d2' },
  { U'\xf953', U'\x808b' },
  { U'\xf954', U'\x51dc' },
  { U'\xf955', U'\x51cc' },
  { U'\xf956', U'\x7a1c' },
  { U'\xf957', U'\x7dbe' },
  { U'\xf958', U'\x83f1' },
  { U'\xf959', U'\x9675' },
  { U'\xf95a', U'\x8b80' },
  { U'\xf95b', U'\x62cf' },
  { U'\xf95c', U'\x6a02' },
  { U'\xf95d', U'\x8afe' },
  { U'\xf95e', U'\x4e39' },
  { U'\xf95f', U'\x5be7' },
  { U'\xf960', U'\x6012' },
  { U'\xf961', U'\x7387' },
  { U'\xf962', U'\x7570' },
  { U'\xf963', U'\x5317' },
  { U'\xf964', U'\x78fb' },
  { U'\xf965', U'\x4fbf' },
  { U'\xf966', U'\x5fa9' },
  { U'\xf967', U'\x4e0d' },
  { U'\xf968', U'\x6ccc' },
  { U'\xf969', U'\x6578' },
  { U'\xf96a', U'\x7d22' },
  { U'\xf96b', U'\x53c3' },
  { U'\xf96c', U'\x585e' },
  { U'\xf96d', U'\x7701' },
  { U'\xf96e', U'\x8449' },
  { U'\xf96f', U'\x8aaa' },
  { U'\xf970', U'\x6bba' },
  { U'\xf971', U'\x8fb0' },
  { U'\xf972', U'\x6c88' },
  { U'\xf973', U'\x62fe' },
  { U'\xf974', U'\x82e5' },
  { U'\xf975', U'\x63a0' },
  { U'\xf976', U'\x7565' },
  { U'\xf977', U'\x4eae' },
  { U'\xf978', U'\x5169' },
  { U'\xf979', U'\x51c9' },
  { U'\xf97a', U'\x6881' },
  { U'\xf97b', U'\x7ce7' },
  { U'\xf97c', U'\x826f' },
  { U'\xf97d', U'\x8ad2' },
  { U'\xf97e', U'\x91cf' },
  { U'\xf97f', U'\x52f5' },
  { U'\xf980', U'\x5442' },
  { U'\xf981', U'\x5973' },
  { U'\xf982', U'\x5eec' },
  { U'\xf983', U'\x65c5' },
  { U'\xf984', U'\x6ffe' },
  { U'\xf985', U'\x792a' },
  { U'\xf986', U'\x95ad' },
  { U'\xf987', U'\x9a6a' },
  { U'\xf988', U'\x9e97' },
  { U'\xf989', U'\x9ece' },
  { U'\xf98a', U'\x529b' },
  { U'\xf98b', U'\x66c6' },
  { U'\xf98c', U'\x6b77' },
  { U'\xf98d', U'\x8f62' },
  { U'\xf98e', U'\x5e74' },
  { U'\xf98f', U'\x6190' },
  { U'\xf990', U'\x6200' },
  { U'\xf991', U'\x649a' },
  { U'\xf992', U'\x6f23' },
  { U'\xf993', U'\x7149' },
  { U'\xf994', U'\x7489' },
  { U'\xf995', U'\x79ca' },
  { U'\xf996', U'\x7df4' },
  { U'\xf997', U'\x806f' },
  { U'\xf998', U'\x8f26' },
  { U'\xf999', U'\x84ee' },
  { U'\xf99a', U'\x9023' },
  { U'\xf99b', U'\x934a' },
  { U'\xf99c', U'\x5217' },
  { U'\xf99d', U'\x52a3' },
  { U'\xf99e', U'\x54bd' },
  { U'\xf99f', U'\x70c8' },
  { U'\xf9a0', U'\x88c2' },
  { U'\xf9a1', U'\x8aaa' },
  { U'\xf9a2', U'\x5ec9' },
  { U'\xf9a3', U'\x5ff5' },
  { U'\xf9a4', U'\x637b' },
  { U'\xf9a5', U'\x6bae' },
  { U'\xf9a6', U'\x7c3e' },
  { U'\xf9a7', U'\x7375' },
  { U'\xf9a8', U'\x4ee4' },
  { U'\xf9a9', U'\x56f9' },
  { U'\xf9aa', U'\x5be7' },
  { U'\xf9ab', U'\x5dba' },
  { U'\xf9ac', U'\x601c' },
  { U'\xf9ad', U'\x73b2' },
  { U'\xf9ae', U'\x7469' },
  { U'\xf9af', U'\x7f9a' },
  { U'\xf9b0', U'\x8046' },
  { U'\xf9b1', U'\x9234' },
  { U'\xf9b2', U'\x96f6' },
  { U'\xf9b3', U'\x9748' },
  { U'\xf9b4', U'\x9818' },
  { U'\xf9b5', U'\x4f8b' },
  { U'\xf9b6', U'\x79ae' },
  { U'\xf9b7', U'\x91b4' },
  { U'\xf9b8', U'\x96b8' },
  { U'\xf9b9', U'\x60e1' },
  { U'\xf9ba', U'\x4e86' },
  { U'\xf9bb', U'\x50da' },
  { U'\xf9bc', U'\x5bee' },
  { U'\xf9bd', U'\x5c3f' },
  { U'\xf9be', U'\x6599' },
  { U'\xf9bf', U'\x6a02' },
  { U'\xf9c0', U'\x71ce' },
  { U'\xf9c1', U'\x7642' },
  { U'\xf9c2', U'\x84fc' },
  { U'\xf9c3', U'\x907c' },
  { U'\xf9c4', U'\x9f8d' },
  { U'\xf9c5', U'\x6688' },
  { U'\xf9c6', U'\x962e' },
  { U'\xf9c7', U'\x5289' },
  { U'\xf9c8', U'\x677b' },
  { U'\xf9c9', U'\x67f3' },
  { U'\xf9ca', U'\x6d41' },
  { U'\xf9cb', U'\x6e9c' },
  { U'\xf9cc', U'\x7409' },
  { U'\xf9cd', U'\x7559' },
  { U'\xf9ce', U'\x786b' },
  { U'\xf9cf', U'\x7d10' },
  { U'\xf9d0', U'\x985e' },
  { U'\xf9d1', U'\x516d' },
  { U'\xf9d2', U'\x622e' },
  { U'\xf9d3', U'\x9678' },
  { U'\xf9d4', U'\x502b' },
  { U'\xf9d5', U'\x5d19' },
  { U'\xf9d6', U'\x6dea' },
  { U'\xf9d7', U'\x8f2a' },
  { U'\xf9d8', U'\x5f8b' },
  { U'\xf9d9', U'\x6144' },
  { U'\xf9da', U'\x6817' },
  { U'\xf9db', U'\x7387' },
  { U'\xf9dc', U'\x9686' },
  { U'\xf9dd', U'\x5229' },
  { U'\xf9de', U'\x540f' },
  { U'\xf9df', U'\x5c65' },
  { U'\xf9e0', U'\x6613' },
  { U'\xf9e1', U'\x674e' },
  { U'\xf9e2', U'\x68a8' },
  { U'\xf9e3', U'\x6ce5' },
  { U'\xf9e4', U'\x7406' },
  { U'\xf9e5', U'\x75e2' },
  { U'\xf9e6', U'\x7f79' },
  { U'\xf9e7', U'\x88cf' },
  { U'\xf9e8', U'\x88e1' },
  { U'\xf9e9', U'\x91cc' },
  { U'\xf9ea', U'\x96e2' },
  { U'\xf9eb', U'\x533f' },
  { U'\xf9ec', U'\x6eba' },
  { U'\xf9ed', U'\x541d' },
  { U'\xf9ee', U'\x71d0' },
  { U'\xf9ef', U'\x7498' },
  { U'\xf9f0', U'\x85fa' },
  { U'\xf9f1', U'\x96a3' },
  { U'\xf9f2', U'\x9c57' },
  { U'\xf9f3', U'\x9e9f' },
  { U'\xf9f4', U'\x6797' },
  { U'\xf9f5', U'\x6dcb' },
  { U'\xf9f6', U'\x81e8' },
  { U'\xf9f7', U'\x7acb' },
  { U'\xf9f8', U'\x7b20' },
  { U'\xf9f9', U'\x7c92' },
  { U'\xf9fa', U'\x72c0' },
  { U'\xf9fb', U'\x7099' },
  { U'\xf9fc', U'\x8b58' },
  { U'\xf9fd', U'\x4ec0' },
  { U'\xf9fe', U'\x8336' },
  { U'\xf9ff', U'\x523a' },
  { U'\xfa00', U'\x5207' },
  { U'\xfa01', U'\x5ea6' },
  { U'\xfa02', U'\x62d3' },
  { U'\xfa03', U'\x7cd6' },
  { U'\xfa04', U'\x5b85' },
  { U'\xfa05', U'\x6d1e' },
  { U'\xfa06', U'\x66b4' },
  { U'\xfa07', U'\x8f3b' },
  { U'\xfa08', U'\x884c' },
  { U'\xfa09', U'\x964d' },
  { U'\xfa0a', U'\x898b' },
  { U'\xfa0b', U'\x5ed3' },
  { U'\xfa0c', U'\x5140' },
  { U'\xfa0d', U'\x55c0' },
  { U'\xfa10', U'\x585a' },
  { U'\xfa12', U'\x6674' },
  { U'\xfa15', U'\x51de' },
  { U'\xfa16', U'\x732a' },
  { U'\xfa17', U'\x76ca' },
  { U'\xfa18', U'\x793c' },
  { U'\xfa19', U'\x795e' },
  { U'\xfa1a', U'\x7965' },
  { U'\xfa1b', U'\x798f' },
  { U'\xfa1c', U'\x9756' },
  { U'\xfa1d', U'\x7cbe' },
  { U'\xfa1e', U'\x7fbd' },
  { U'\xfa20', U'\x8612' },
  { U'\xfa22', U'\x8af8' },
  { U'\xfa25', U'\x9038' },
  { U'\xfa26', U'\x90fd' },
  { U'\xfa2a', U'\x98ef' },
  { U'\xfa2b', U'\x98fc' },
  { U'\xfa2c', U'\x9928' },
  { U'\xfa2d', U'\x9db4' },
  { U'\xfa2e', U'\x90de' },
  { U'\xfa2f', U'\x96b7' },
  { U'\xfa30', U'\x4fae' },
  { U'\xfa31', U'\x50e7' },
  { U'\xfa32', U'\x514d' },
  { U'\xfa33', U'\x52c9' },
  { U'\xfa34', U'\x52e4' },
  { U'\xfa35', U'\x5351' },
  { U'\xfa36', U'\x559d' },
  { U'\xfa37', U'\x5606' },
  { U'\xfa38', U'\x5668' },
  { U'\xfa39', U'\x5840' },
  { U'\xfa3a', U'\x58a8' },
  { U'\xfa3b', U'\x5c64' },
  { U'\xfa3c', U'\x5c6e' },
  { U'\xfa3d', U'\x6094' },
  { U'\xfa3e', U'\x6168' },
  { U'\xfa3f', U'\x618e' },
  { U'\xfa40', U'\x61f2' },
  { U'\xfa41', U'\x654f' },
  { U'\xfa42', U'\x65e2' },
  { U'\xfa43', U'\x6691' },
  { U'\xfa44', U'\x6885' },
  { U'\xfa45', U'\x6d77' },
  { U'\xfa46', U'\x6e1a' },
  { U'\xfa47', U'\x6f22' },
  { U'\xfa48', U'\x716e' },
  { U'\xfa49', U'\x722b' },
  { U'\xfa4a', U'\x7422' },
  { U'\xfa4b', U'\x7891' },
  { U'\xfa4c', U'\x793e' },
  { U'\xfa4d', U'\x7949' },
  { U'\xfa4e', U'\x7948' },
  { U'\xfa4f', U'\x7950' },
  { U'\xfa50', U'\x7956' },
  { U'\xfa51', U'\x795d' },
  { U'\xfa52', U'\x798d' },
  { U'\xfa53', U'\x798e' },
  { U'\xfa54', U'\x7a40' },
  { U'\xfa55', U'\x7a81' },
  { U'\xfa56', U'\x7bc0' },
  { U'\xfa57', U'\x7df4' },
  { U'\xfa58', U'\x7e09' },
  { U'\xfa59', U'\x7e41' },
  { U'\xfa5a', U'\x7f72' },
  { U'\xfa5b', U'\x8005' },
  { U'\xfa5c', U'\x81ed' },
  { U'\xfa5d', U'\x8279' },
  { U'\xfa5f', U'\x8457' },
  { U'\xfa60', U'\x8910' },
  { U'\xfa61', U'\x8996' },
  { U'\xfa62', U'\x8b01' },
  { U'\xfa63', U'\x8b39' },
  { U'\xfa64', U'\x8cd3' },
  { U'\xfa65', U'\x8d08' },
  { U'\xfa66', U'\x8fb6' },
  { U'\xfa67', U'\x9038' },
  { U'\xfa68', U'\x96e3' },
  { U'\xfa69', U'\x97ff' },
  { U'\xfa6a', U'\x983b' },
  { U'\xfa6b', U'\x6075' },
  { U'\xfa6d', U'\x8218' },
  { U'\xfa70', U'\x4e26' },
  { U'\xfa71', U'\x51b5' },
  { U'\xfa72', U'\x5168' },
  { U'\xfa73', U'\x4f80' },
  { U'\xfa74', U'\x5145' },
  { U'\xfa75', U'\x5180' },
  { U'\xfa76', U'\x52c7' },
  { U'\xfa77', U'\x52fa' },
  { U'\xfa78', U'\x559d' },
  { U'\xfa79', U'\x5555' },
  { U'\xfa7a', U'\x5599' },
  { U'\xfa7b', U'\x55e2' },
  { U'\xfa7c', U'\x585a' },
  { U'\xfa7d', U'\x58b3' },
  { U'\xfa7e', U'\x5944' },
  { U'\xfa7f', U'\x5954' },
  { U'\xfa80', U'\x5a62' },
  { U'\xfa81', U'\x5b28' },
  { U'\xfa82', U'\x5ed2' },
  { U'\xfa83', U'\x5ed9' },
  { U'\xfa84', U'\x5f69' },
  { U'\xfa85', U'\x5fad' },
  { U'\xfa86', U'\x60d8' },
  { U'\xfa87', U'\x614e' },
  { U'\xfa88', U'\x6108' },
  { U'\xfa89', U'\x618e' },
  { U'\xfa8a', U'\x6160' },
  { U'\xfa8b', U'\x61f2' },
  { U'\xfa8c', U'\x6234' },
  { U'\xfa8d', U'\x63c4' },
  { U'\xfa8e', U'\x641c' },
  { U'\xfa8f', U'\x6452' },
  { U'\xfa90', U'\x6556' },
  { U'\xfa91', U'\x6674' },
  { U'\xfa92', U'\x6717' },
  { U'\xfa93', U'\x671b' },
  { U'\xfa94', U'\x6756' },
  { U'\xfa95', U'\x6b79' },
  { U'\xfa96', U'\x6bba' },
  { U'\xfa97', U'\x6d41' },
  { U'\xfa98', U'\x6edb' },
  { U'\xfa99', U'\x6ecb' },
  { U'\xfa9a', U'\x6f22' },
  { U'\xfa9b', U'\x701e' },
  { U'\xfa9c', U'\x716e' },
  { U'\xfa9d', U'\x77a7' },
  { U'\xfa9e', U'\x7235' },
  { U'\xfa9f', U'\x72af' },
  { U'\xfaa0', U'\x732a' },
  { U'\xfaa1', U'\x7471' },
  { U'\xfaa2', U'\x7506' },
  { U'\xfaa3', U'\x753b' },
  { U'\xfaa4', U'\x761d' },
  { U'\xfaa5', U'\x761f' },
  { U'\xfaa6', U'\x76ca' },
  { U'\xfaa7', U'\x76db' },
  { U'\xfaa8', U'\x76f4' },
  { U'\xfaa9', U'\x774a' },
  { U'\xfaaa', U'\x7740' },
  { U'\xfaab', U'\x78cc' },
  { U'\xfaac', U'\x7ab1' },
  { U'\xfaad', U'\x7bc0' },
  { U'\xfaae', U'\x7c7b' },
  { U'\xfaaf', U'\x7d5b' },
  { U'\xfab0', U'\x7df4' },
  { U'\xfab1', U'\x7f3e' },
  { U'\xfab2', U'\x8005' },
  { U'\xfab3', U'\x8352' },
  { U'\xfab4', U'\x83ef' },
  { U'\xfab5', U'\x8779' },
  { U'\xfab6', U'\x8941' },
  { U'\xfab7', U'\x8986' },
  { U'\xfab8', U'\x8996' },
  { U'\xfab9', U'\x8abf' },
  { U'\xfaba', U'\x8af8' },
  { U'\xfabb', U'\x8acb' },
  { U'\xfabc', U'\x8b01' },
  { U'\xfabd', U'\x8afe' },
  { U'\xfabe', U'\x8aed' },
  { U'\xfabf', U'\x8b39' },
  { U'\xfac0', U'\x8b8a' },
  { U'\xfac1', U'\x8d08' },
  { U'\xfac2', U'\x8f38' },
  { U'\xfac3', U'\x9072' },
  { U'\xfac4', U'\x9199' },
  { U'\xfac5', U'\x9276' },
  { U'\xfac6', U'\x967c' },
  { U'\xfac7', U'\x96e3' },
  { U'\xfac8', U'\x9756' },
  { U'\xfac9', U'\x97db' },
  { U'\xfaca', U'\x97ff' },
  { U'\xfacb', U'\x980b' },
  { U'\xfacc', U'\x983b' },
  { U'\xfacd', U'\x9b12' },
  { U'\xface', U'\x9f9c' },
  { U'\xfad2', U'\x3b9d' },
  { U'\xfad3', U'\x4018' },
  { U'\xfad4', U'\x4039' },
  { U'\xfad8', U'\x9f43' },
  { U'\xfad9', U'\x9f8e' },
  { U'\xfb00', U'\x0066' },
  { U'\xfb01', U'\x0066' },
  { U'\xfb02', U'\x0066' },
  { U'\xfb03', U'\x0066' },
  { U'\xfb04', U'\x0066' },
  { U'\xfb05', U'\x0073' },
  { U'\xfb13', U'\x0574' },
  { U'\xfb14', U'\x0574' },
  { U'\xfb15', U'\x0574' },
  { U'\xfb16', U'\x057e' },
  { U'\xfb17', U'\x0574' },
  { U'\xfb1d', U'\x05d9' },
  { U'\xfb1f', U'\x05f2' },
  { U'\xfb20', U'\x05e2' },
  { U'\xfb21', U'\x05d0' },
  { U'\xfb22', U'\x05d3' },
  { U'\xfb23', U'\x05d4' },
  { U'\xfb24', U'\x05db' },
  { U'\xfb25', U'\x05dc' },
  { U'\xfb26', U'\x05dd' },
  { U'\xfb27', U'\x05e8' },
  { U'\xfb28', U'\x05ea' },
  { U'\xfb29', U'\x002b' },
  { U'\xfb2a', U'\x05e9' },
  { U'\xfb2b', U'\x05e9' },
  { U'\xfb2c', U'\x05e9' },
  { U'\xfb2d', U'\x05e9' },
  { U'\xfb2e', U'\x05d0' },
  { U'\xfb2f', U'\x05d0' },
  { U'\xfb30', U'\x05d0' },
  { U'\xfb31', U'\x05d1' },
  { U'\xfb32', U'\x05d2' },
  { U'\xfb33', U'\x05d3' },
  { U'\xfb34', U'\x05d4' },
  { U'\xfb35', U'\x05d5' },
  { U'\xfb36', U'\x05d6' },
  { U'\xfb38', U'\x05d8' },
  { U'\xfb39', U'\x05d9' },
  { U'\xfb3a', U'\x05da' },
  { U'\xfb3b', U'\x05db' },
  { U'\xfb3c', U'\x05dc' },
  { U'\xfb3e', U'\x05de' },
  { U'\xfb40', U'\x05e0' },
  { U'\xfb41', U'\x05e1' },
  { U'\xfb43', U'\x05e3' },
  { U'\xfb44', U'\x05e4' },
  { U'\xfb46', U'\x05e6' },
  { U'\xfb47', U'\x05e7' },
  { U'\xfb48', U'\x05e8' },
  { U'\xfb49', U'\x05e9' },
  { U'\xfb4a', U'\x05ea' },
  { U'\xfb4b', U'\x05d5' },
  { U'\xfb4c', U'\x05d1' },
  { U'\xfb4d', U'\x05db' },
  { U'\xfb4e', U'\x05e4' },
  { U'\xfb4f', U'\x05d0' },
  { U'\xfb50', U'\x0671' },
  { U'\xfb52', U'\x067b' },
  { U'\xfb56', U'\x067e' },
  { U'\xfb5a', U'\x0680' },
  { U'\xfb5e', U'\x067a' },
  { U'\xfb62', U'\x067f' },
  { U'\xfb66', U'\x0679' },
  { U'\xfb6a', U'\x06a4' },
  { U'\xfb6e', U'\x06a6' },
  { U'\xfb72', U'\x0684' },
  { U'\xfb76', U'\x0683' },
  { U'\xfb7a', U'\x0686' },
  { U'\xfb7e', U'\x0687' },
  { U'\xfb82', U'\x068d' },
  { U'\xfb84', U'\x068c' },
  { U'\xfb86', U'\x068e' },
  { U'\xfb88', U'\x0688' },
  { U'\xfb8a', U'\x0698' },
  { U'\xfb8c', U'\x0691' },
  { U'\xfb8e', U'\x06a9' },
  { U'\xfb92', U'\x06af' },
  { U'\xfb96', U'\x06b3' },
  { U'\xfb9a', U'\x06b1' },
  { U'\xfb9e', U'\x06ba' },
  { U'\xfba0', U'\x06bb' },
  { U'\xfba4', U'\x06c0' },
  { U'\xfba6', U'\x06c1' },
  { U'\xfbaa', U'\x06be' },
  { U'\xfbae', U'\x06d2' },
  { U'\xfbb0', U'\x06d3' },
  { U'\xfbd3', U'\x06ad' },
  { U'\xfbd7', U'\x06c7' },
  { U'\xfbd9', U'\x06c6' },
  { U'\xfbdb', U'\x06c8' },
  { U'\xfbdd', U'\x06c7' },
  { U'\xfbde', U'\x06cb' },
  { U'\xfbe0', U'\x06c5' },
  { U'\xfbe2', U'\x06c9' },
  { U'\xfbe4', U'\x06d0' },
  { U'\xfbe8', U'\x0649' },
  { U'\xfbea', U'\x0626' },
  { U'\xfbec', U'\x0626' },
  { U'\xfbee', U'\x0626' },
  { U'\xfbf0', U'\x0626' },
  { U'\xfbf2', U'\x0626' },
  { U'\xfbf4', U'\x0626' },
  { U'\xfbf6', U'\x0626' },
  { U'\xfbf9', U'\x0626' },
  { U'\xfbfc', U'\x06cc' },
  { U'\xfc00', U'\x0626' },
  { U'\xfc01', U'\x0626' },
  { U'\xfc02', U'\x0626' },
  { U'\xfc03', U'\x0626' },
  { U'\xfc04', U'\x0626' },
  { U'\xfc05', U'\x0628' },
  { U'\xfc06', U'\x0628' },
  { U'\xfc07', U'\x0628' },
  { U'\xfc08', U'\x0628' },
  { U'\xfc09', U'\x0628' },
  { U'\xfc0a', U'\x0628' },
  { U'\xfc0b', U'\x062a' },
  { U'\xfc0c', U'\x062a' },
  { U'\xfc0d', U'\x062a' },
  { U'\xfc0e', U'\x062a' },
  { U'\xfc0f', U'\x062a' },
  { U'\xfc10', U'\x062a' },
  { U'\xfc11', U'\x062b' },
  { U'\xfc12', U'\x062b' },
  { U'\xfc13', U'\x062b' },
  { U'\xfc14', U'\x062b' },
  { U'\xfc15', U'\x062c' },
  { U'\xfc16', U'\x062c' },
  { U'\xfc17', U'\x062d' },
  { U'\xfc18', U'\x062d' },
  { U'\xfc19', U'\x062e' },
  { U'\xfc1a', U'\x062e' },
  { U'\xfc1b', U'\x062e' },
  { U'\xfc1c', U'\x0633' },
  { U'\xfc1d', U'\x0633' },
  { U'\xfc1e', U'\x0633' },
  { U'\xfc1f', U'\x0633' },
  { U'\xfc20', U'\x0635' },
  { U'\xfc21', U'\x0635' },
  { U'\xfc22', U'\x0636' },
  { U'\xfc23', U'\x0636' },
  { U'\xfc24', U'\x0636' },
  { U'\xfc25', U'\x0636' },
  { U'\xfc26', U'\x0637' },
  { U'\xfc27', U'\x0637' },
  { U'\xfc28', U'\x0638' },
  { U'\xfc29', U'\x0639' },
  { U'\xfc2a', U'\x0639' },
  { U'\xfc2b', U'\x063a' },
  { U'\xfc2c', U'\x063a' },
  { U'\xfc2d', U'\x0641' },
  { U'\xfc2e', U'\x0641' },
  { U'\xfc2f', U'\x0641' },
  { U'\xfc30', U'\x0641' },
  { U'\xfc31', U'\x0641' },
  { U'\xfc32', U'\x0641' },
  { U'\xfc33', U'\x0642' },
  { U'\xfc34', U'\x0642' },
  { U'\xfc35', U'\x0642' },
  { U'\xfc36', U'\x0642' },
  { U'\xfc37', U'\x0643' },
  { U'\xfc38', U'\x0643' },
  { U'\xfc39', U'\x0643' },
  { U'\xfc3a', U'\x0643' },
  { U'\xfc3b', U'\x0643' },
  { U'\xfc3c', U'\x0643' },
  { U'\xfc3d', U'\x0643' },
  { U'\xfc3e', U'\x0643' },
  { U'\xfc3f', U'\x0644' },
  { U'\xfc40', U'\x0644' },
  { U'\xfc41', U'\x0644' },
  { U'\xfc42', U'\x0644' },
  { U'\xfc43', U'\x0644' },
  { U'\xfc44', U'\x0644' },
  { U'\xfc45', U'\x0645' },
  { U'\xfc46', U'\x0645' },
  { U'\xfc47', U'\x0645' },
  { U'\xfc48', U'\x0645' },
  { U'\xfc49', U'\x0645' },
  { U'\xfc4a', U'\x0645' },
  { U'\xfc4b', U'\x0646' },
  { U'\xfc4c', U'\x0646' },
  { U'\xfc4d', U'\x0646' },
  { U'\xfc4e', U'\x0646' },
  { U'\xfc4f', U'\x0646' },
  { U'\xfc50', U'\x0646' },
  { U'\xfc51', U'\x0647' },
  { U'\xfc52', U'\x0647' },
  { U'\xfc53', U'\x0647' },
  { U'\xfc54', U'\x0647' },
  { U'\xfc55', U'\x064a' },
  { U'\xfc56', U'\x064a' },
  { U'\xfc57', U'\x064a' },
  { U'\xfc58', U'\x064a' },
  { U'\xfc59', U'\x064a' },
  { U'\xfc5a', U'\x064a' },
  { U'\xfc5b', U'\x0630' },
  { U'\xfc5c', U'\x0631' },
  { U'\xfc5d', U'\x0649' },
  { U'\xfc5e', U'\x0020' },
  { U'\xfc5f', U'\x0020' },
  { U'\xfc60', U'\x0020' },
  { U'\xfc61', U'\x0020' },
  { U'\xfc62', U'\x0020' },
  { U'\xfc63', U'\x0020' },
  { U'\xfc64', U'\x0626' },
  { U'\xfc65', U'\x0626' },
  { U'\xfc66', U'\x0626' },
  { U'\xfc67', U'\x0626' },
  { U'\xfc68', U'\x0626' },
  { U'\xfc69', U'\x0626' },
  { U'\xfc6a', U'\x0628' },
  { U'\xfc6b', U'\x0628' },
  { U'\xfc6c', U'\x0628' },
  { U'\xfc6d', U'\x0628' },
  { U'\xfc6e', U'\x0628' },
  { U'\xfc6f', U'\x0628' },
  { U'\xfc70', U'\x062a' },
  { U'\xfc71', U'\x062a' },
  { U'\xfc72', U'\x062a' },
  { U'\xfc73', U'\x062a' },
  { U'\xfc74', U'\x062a' },
  { U'\xfc75', U'\x062a' },
  { U'\xfc76', U'\x062b' },
  { U'\xfc77', U'\x062b' },
  { U'\xfc78', U'\x062b' },
  { U'\xfc79', U'\x062b' },
  { U'\xfc7a', U'\x062b' },
  { U'\xfc7b', U'\x062b' },
  { U'\xfc7c', U'\x0641' },
  { U'\xfc7d', U'\x0641' },
  { U'\xfc7e', U'\x0642' },
  { U'\xfc7f', U'\x0642' },
  { U'\xfc80', U'\x0643' },
  { U'\xfc81', U'\x0643' },
  { U'\xfc82', U'\x0643' },
  { U'\xfc83', U'\x0643' },
  { U'\xfc84', U'\x0643' },
  { U'\xfc85', U'\x0644' },
  { U'\xfc86', U'\x0644' },
  { U'\xfc87', U'\x0644' },
  { U'\xfc88', U'\x0645' },
  { U'\xfc89', U'\x0645' },
  { U'\xfc8a', U'\x0646' },
  { U'\xfc8b', U'\x0646' },
  { U'\xfc8c', U'\x0646' },
  { U'\xfc8d', U'\x0646' },
  { U'\xfc8e', U'\x0646' },
  { U'\xfc8f', U'\x0646' },
  { U'\xfc90', U'\x0649' },
  { U'\xfc91', U'\x064a' },
  { U'\xfc92', U'\x064a' },
  { U'\xfc93', U'\x064a' },
  { U'\xfc94', U'\x064a' },
  { U'\xfc95', U'\x064a' },
  { U'\xfc96', U'\x064a' },
  { U'\xfc97', U'\x0626' },
  { U'\xfc98', U'\x0626' },
  { U'\xfc99', U'\x0626' },
  { U'\xfc9a', U'\x0626' },
  { U'\xfc9b', U'\x0626' },
  { U'\xfc9c', U'\x0628' },
  { U'\xfc9d', U'\x0628' },
  { U'\xfc9e', U'\x0628' },
  { U'\xfc9f', U'\x0628' },
  { U'\xfca0', U'\x0628' },
  { U'\xfca1', U'\x062a' },
  { U'\xfca2', U'\x062a' },
  { U'\xfca3', U'\x062a' },
  { U'\xfca4', U'\x062a' },
  { U'\xfca5', U'\x062a' },
  { U'\xfca6', U'\x062b' },
  { U'\xfca7', U'\x062c' },
  { U'\xfca8', U'\x062c' },
  { U'\xfca9', U'\x062d' },
  { U'\xfcaa', U'\x062d' },
  { U'\xfcab', U'\x062e' },
  { U'\xfcac', U'\x062e' },
  { U'\xfcad', U'\x0633' },
  { U'\xfcae', U'\x0633' },
  { U'\xfcaf', U'\x0633' },
  { U'\xfcb0', U'\x0633' },
  { U'\xfcb1', U'\x0635' },
  { U'\xfcb2', U'\x0635' },
  { U'\xfcb3', U'\x0635' },
  { U'\xfcb4', U'\x0636' },
  { U'\xfcb5', U'\x0636' },
  { U'\xfcb6', U'\x0636' },
  { U'\xfcb7', U'\x0636' },
  { U'\xfcb8', U'\x0637' },
  { U'\xfcb9', U'\x0638' },
  { U'\xfcba', U'\x0639' },
  { U'\xfcbb', U'\x0639' },
  { U'\xfcbc', U'\x063a' },
  { U'\xfcbd', U'\x063a' },
  { U'\xfcbe', U'\x0641' },
  { U'\xfcbf', U'\x0641' },
  { U'\xfcc0', U'\x0641' },
  { U'\xfcc1', U'\x0641' },
  { U'\xfcc2', U'\x0642' },
  { U'\xfcc3', U'\x0642' },
  { U'\xfcc4', U'\x0643' },
  { U'\xfcc5', U'\x0643' },
  { U'\xfcc6', U'\x0643' },
  { U'\xfcc7', U'\x0643' },
  { U'\xfcc8', U'\x0643' },
  { U'\xfcc9', U'\x0644' },
  { U'\xfcca', U'\x0644' },
  { U'\xfccb', U'\x0644' },
  { U'\xfccc', U'\x0644' },
  { U'\xfccd', U'\x0644' },
  { U'\xfcce', U'\x0645' },
  { U'\xfccf', U'\x0645' },
  { U'\xfcd0', U'\x0645' },
  { U'\xfcd1', U'\x0645' },
  { U'\xfcd2', U'\x0646' },
  { U'\xfcd3', U'\x0646' },
  { U'\xfcd4', U'\x0646' },
  { U'\xfcd5', U'\x0646' },
  { U'\xfcd6', U'\x0646' },
  { U'\xfcd7', U'\x0647' },
  { U'\xfcd8', U'\x0647' },
  { U'\xfcd9', U'\x0647' },
  { U'\xfcda', U'\x064a' },
  { U'\xfcdb', U'\x064a' },
  { U'\xfcdc', U'\x064a' },
  { U'\xfcdd', U'\x064a' },
  { U'\xfcde', U'\x064a' },
  { U'\xfcdf', U'\x0626' },
  { U'\xfce0', U'\x0626' },
  { U'\xfce1', U'\x0628' },
  { U'\xfce2', U'\x0628' },
  { U'\xfce3', U'\x062a' },
  { U'\xfce4', U'\x062a' },
  { U'\xfce5', U'\x062b' },
  { U'\xfce6', U'\x062b' },
  { U'\xfce7', U'\x0633' },
  { U'\xfce8', U'\x0633' },
  { U'\xfce9', U'\x0634' },
  { U'\xfcea', U'\x0634' },
  { U'\xfceb', U'\x0643' },
  { U'\xfcec', U'\x0643' },
  { U'\xfced', U'\x0644' },
  { U'\xfcee', U'\x0646' },
  { U'\xfcef', U'\x0646' },
  { U'\xfcf0', U'\x064a' },
  { U'\xfcf1', U'\x064a' },
  { U'\xfcf2', U'\x0640' },
  { U'\xfcf3', U'\x0640' },
  { U'\xfcf4', U'\x0640' },
  { U'\xfcf5', U'\x0637' },
  { U'\xfcf6', U'\x0637' },
  { U'\xfcf7', U'\x0639' },
  { U'\xfcf8', U'\x0639' },
  { U'\xfcf9', U'\x063a' },
  { U'\xfcfa', U'\x063a' },
  { U'\xfcfb', U'\x0633' },
  { U'\xfcfc', U'\x0633' },
  { U'\xfcfd', U'\x0634' },
  { U'\xfcfe', U'\x0634' },
  { U'\xfcff', U'\x062d' },
  { U'\xfd00', U'\x062d' },
  { U'\xfd01', U'\x062c' },
  { U'\xfd02', U'\x062c' },
  { U'\xfd03', U'\x062e' },
  { U'\xfd04', U'\x062e' },
  { U'\xfd05', U'\x0635' },
  { U'\xfd06', U'\x0635' },
  { U'\xfd07', U'\x0636' },
  { U'\xfd08', U'\x0636' },
  { U'\xfd09', U'\x0634' },
  { U'\xfd0a', U'\x0634' },
  { U'\xfd0b', U'\x0634' },
  { U'\xfd0c', U'\x0634' },
  { U'\xfd0d', U'\x0634' },
  { U'\xfd0e', U'\x0633' },
  { U'\xfd0f', U'\x0635' },
  { U'\xfd10', U'\x0636' },
  { U'\xfd11', U'\x0637' },
  { U'\xfd12', U'\x0637' },
  { U'\xfd13', U'\x0639' },
  { U'\xfd14', U'\x0639' },
  { U'\xfd15', U'\x063a' },
  { U'\xfd16', U'\x063a' },
  { U'\xfd17', U'\x0633' },
  { U'\xfd18', U'\x0633' },
  { U'\xfd19', U'\x0634' },
  { U'\xfd1a', U'\x0634' },
  { U'\xfd1b', U'\x062d' },
  { U'\xfd1c', U'\x062d' },
  { U'\xfd1d', U'\x062c' },
  { U'\xfd1e', U'\x062c' },
  { U'\xfd1f', U'\x062e' },
  { U'\xfd20', U'\x062e' },
  { U'\xfd21', U'\x0635' },
  { U'\xfd22', U'\x0635' },
  { U'\xfd23', U'\x0636' },
  { U'\xfd24', U'\x0636' },
  { U'\xfd25', U'\x0634' },
  { U'\xfd26', U'\x0634' },
  { U'\xfd27', U'\x0634' },
  { U'\xfd28', U'\x0634' },
  { U'\xfd29', U'\x0634' },
  { U'\xfd2a', U'\x0633' },
  { U'\xfd2b', U'\x0635' },
  { U'\xfd2c', U'\x0636' },
  { U'\xfd2d', U'\x0634' },
  { U'\xfd2e', U'\x0634' },
  { U'\xfd2f', U'\x0634' },
  { U'\xfd30', U'\x0634' },
  { U'\xfd31', U'\x0633' },
  { U'\xfd32', U'\x0634' },
  { U'\xfd33', U'\x0637' },
  { U'\xfd34', U'\x0633' },
  { U'\xfd35', U'\x0633' },
  { U'\xfd36', U'\x0633' },
  { U'\xfd37', U'\x0634' },
  { U'\xfd38', U'\x0634' },
  { U'\xfd39', U'\x0634' },
  { U'\xfd3a', U'\x0637' },
  { U'\xfd3b', U'\x0638' },
  { U'\xfd3c', U'\x0627' },
  { U'\xfd50', U'\x062a' },
  { U'\xfd51', U'\x062a' },
  { U'\xfd53', U'\x062a' },
  { U'\xfd54', U'\x062a' },
  { U'\xfd55', U'\x062a' },
  { U'\xfd56', U'\x062a' },
  { U'\xfd57', U'\x062a' },
  { U'\xfd58', U'\x062c' },
  { U'\xfd5a', U'\x062d' },
  { U'\xfd5b', U'\x062d' },
  { U'\xfd5c', U'\x0633' },
  { U'\xfd5d', U'\x0633' },
  { U'\xfd5e', U'\x0633' },
  { U'\xfd5f', U'\x0633' },
  { U'\xfd61', U'\x0633' },
  { U'\xfd62', U'\x0633' },
  { U'\xfd64', U'\x0635' },
  { U'\xfd66', U'\x0635' },
  { U'\xfd67', U'\x0634' },
  { U'\xfd69', U'\x0634' },
  { U'\xfd6a', U'\x0634' },
  { U'\xfd6c', U'\x0634' },
  { U'\xfd6e', U'\x0636' },
  { U'\xfd6f', U'\x0636' },
  { U'\xfd71', U'\x0637' },
  { U'\xfd73', U'\x0637' },
  { U'\xfd74', U'\x0637' },
  { U'\xfd75', U'\x0639' },
  { U'\xfd76', U'\x0639' },
  { U'\xfd78', U'\x0639' },
  { U'\xfd79', U'\x063a' },
  { U'\xfd7a', U'\x063a' },
  { U'\xfd7b', U'\x063a' },
  { U'\xfd7c', U'\x0641' },
  { U'\xfd7e', U'\x0642' },
  { U'\xfd7f', U'\x0642' },
  { U'\xfd80', U'\x0644' },
  { U'\xfd81', U'\x0644' },
  { U'\xfd82', U'\x0644' },
  { U'\xfd83', U'\x0644' },
  { U'\xfd85', U'\x0644' },
  { U'\xfd87', U'\x0644' },
  { U'\xfd89', U'\x0645' },
  { U'\xfd8a', U'\x0645' },
  { U'\xfd8b', U'\x0645' },
  { U'\xfd8c', U'\x0645' },
  { U'\xfd8d', U'\x0645' },
  { U'\xfd8e', U'\x0645' },
  { U'\xfd8f', U'\x0645' },
  { U'\xfd92', U'\x0645' },
  { U'\xfd93', U'\x0647' },
  { U'\xfd94', U'\x0647' },
  { U'\xfd95', U'\x0646' },
  { U'\xfd96', U'\x0646' },
  { U'\xfd97', U'\x0646' },
  { U'\xfd99', U'\x0646' },
  { U'\xfd9a', U'\x0646' },
  { U'\xfd9b', U'\x0646' },
  { U'\xfd9c', U'\x064a' },
  { U'\xfd9e', U'\x0628' },
  { U'\xfd9f', U'\x062a' },
  { U'\xfda0', U'\x062a' },
  { U'\xfda1', U'\x062a' },
  { U'\xfda2', U'\x062a' },
  { U'\xfda3', U'\x062a' },
  { U'\xfda4', U'\x062a' },
  { U'\xfda5', U'\x062c' },
  { U'\xfda6', U'\x062c' },
  { U'\xfda7', U'\x062c' },
  { U'\xfda8', U'\x0633' },
  { U'\xfda9', U'\x0635' },
  { U'\xfdaa', U'\x0634' },
  { U'\xfdab', U'\x0636' },
  { U'\xfdac', U'\x0644' },
  { U'\xfdad', U'\x0644' },
  { U'\xfdae', U'\x064a' },
  { U'\xfdaf', U'\x064a' },
  { U'\xfdb0', U'\x064a' },
  { U'\xfdb1', U'\x0645' },
  { U'\xfdb2', U'\x0642' },
  { U'\xfdb3', U'\x0646' },
  { U'\xfdb4', U'\x0642' },
  { U'\xfdb5', U'\x0644' },
  { U'\xfdb6', U'\x0639' },
  { U'\xfdb7', U'\x0643' },
  { U'\xfdb8', U'\x0646' },
  { U'\xfdb9', U'\x0645' },
  { U'\xfdba', U'\x0644' },
  { U'\xfdbb', U'\x0643' },
  { U'\xfdbc', U'\x0644' },
  { U'\xfdbd', U'\x0646' },
  { U'\xfdbe', U'\x062c' },
  { U'\xfdbf', U'\x062d' },
  { U'\xfdc0', U'\x0645' },
  { U'\xfdc1', U'\x0641' },
  { U'\xfdc2', U'\x0628' },
  { U'\xfdc3', U'\x0643' },
  { U'\xfdc4', U'\x0639' },
  { U'\xfdc5', U'\x0635' },
  { U'\xfdc6', U'\x0633' },
  { U'\xfdc7', U'\x0646' },
  { U'\xfdf0', U'\x0635' },
  { U'\xfdf1', U'\x0642' },
  { U'\xfdf2', U'\x0627' },
  { U'\xfdf3', U'\x0627' },
  { U'\xfdf4', U'\x0645' },
  { U'\xfdf5', U'\x0635' },
  { U'\xfdf6', U'\x0631' },
  { U'\xfdf7', U'\x0639' },
  { U'\xfdf8', U'\x0648' },
  { U'\xfdf9', U'\x0635' },
  { U'\xfdfa', U'\x0635' },
  { U'\xfdfb', U'\x062c' },
  { U'\xfdfc', U'\x0631' },
  { U'\xfe10', U'\x002c' },
  { U'\xfe11', U'\x3001' },
  { U'\xfe13', U'\x003a' },
  { U'\xfe14', U'\x003b' },
  { U'\xfe15', U'\x0021' },
  { U'\xfe16', U'\x003f' },
  { U'\xfe17', U'\x3016' },
  { U'\xfe18', U'\x3017' },
  { U'\xfe31', U'\x2014' },
  { U'\xfe32', U'\x2013' },
  { U'\xfe33', U'\x005f' },
  { U'\xfe35', U'\x0028' },
  { U'\xfe36', U'\x0029' },
  { U'\xfe37', U'\x007b' },
  { U'\xfe38', U'\x007d' },
  { U'\xfe39', U'\x3014' },
  { U'\xfe3a', U'\x3015' },
  { U'\xfe3b', U'\x3010' },
  { U'\xfe3c', U'\x3011' },
  { U'\xfe3d', U'\x300a' },
  { U'\xfe3e', U'\x300b' },
  { U'\xfe3f', U'\x3008' },
  { U'\xfe40', U'\x3009' },
  { U'\xfe41', U'\x300c' },
  { U'\xfe42', U'\x300d' },
  { U'\xfe43', U'\x300e' },
  { U'\xfe44', U'\x300f' },
  { U'\xfe47', U'\x005b' },
  { U'\xfe48', U'\x005d' },
  { U'\xfe49', U'\x0020' },
  { U'\xfe4d', U'\x005f' },
  { U'\xfe50', U'\x002c' },
  { U'\xfe51', U'\x3001' },
  { U'\xfe54', U'\x003b' },
  { U'\xfe55', U'\x003a' },
  { U'\xfe56', U'\x003f' },
  { U'\xfe57', U'\x0021' },
  { U'\xfe58', U'\x2014' },
  { U'\xfe59', U'\x0028' },
  { U'\xfe5a', U'\x0029' },
  { U'\xfe5b', U'\x007b' },
  { U'\xfe5c', U'\x007d' },
  { U'\xfe5d', U'\x3014' },
  { U'\xfe5e', U'\x3015' },
  { U'\xfe5f', U'\x0023' },
  { U'\xfe60', U'\x0026' },
  { U'\xfe61', U'\x002a' },
  { U'\xfe62', U'\x002b' },
  { U'\xfe63', U'\x002d' },
  { U'\xfe64', U'\x003c' },
  { U'\xfe65', U'\x003e' },
  { U'\xfe66', U'\x003d' },
  { U'\xfe68', U'\x005c' },
  { U'\xfe69', U'\x0024' },
  { U'\xfe6a', U'\x0025' },
  { U'\xfe6b', U'\x0040' },
  { U'\xfe70', U'\x0020' },
  { U'\xfe71', U'\x0640' },
  { U'\xfe72', U'\x0020' },
  { U'\xfe74', U'\x0020' },
  { U'\xfe76', U'\x0020' },
  { U'\xfe77', U'\x0640' },
  { U'\xfe78', U'\x0020' },
  { U'\xfe79', U'\x0640' },
  { U'\xfe7a', U'\x0020' },
  { U'\xfe7b', U'\x0640' },
  { U'\xfe7c', U'\x0020' },
  { U'\xfe7d', U'\x0640' },
  { U'\xfe7e', U'\x0020' },
  { U'\xfe7f', U'\x0640' },
  { U'\xfe80', U'\x0621' },
  { U'\xfe81', U'\x0622' },
  { U'\xfe83', U'\x0623' },
  { U'\xfe85', U'\x0624' },
  { U'\xfe87', U'\x0625' },
  { U'\xfe89', U'\x0626' },
  { U'\xfe8d', U'\x0627' },
  { U'\xfe8f', U'\x0628' },
  { U'\xfe93', U'\x0629' },
  { U'\xfe95', U'\x062a' },
  { U'\xfe99', U'\x062b' },
  { U'\xfe9d', U'\x062c' },
  { U'\xfea1', U'\x062d' },
  { U'\xfea5', U'\x062e' },
  { U'\xfea9', U'\x062f' },
  { U'\xfeab', U'\x0630' },
  { U'\xfead', U'\x0631' },
  { U'\xfeaf', U'\x0632' },
  { U'\xfeb1', U'\x0633' },
  { U'\xfeb5', U'\x0634' },
  { U'\xfeb9', U'\x0635' },
  { U'\xfebd', U'\x0636' },
  { U'\xfec1', U'\x0637' },
  { U'\xfec5', U'\x0638' },
  { U'\xfec9', U'\x0639' },
  { U'\xfecd', U'\x063a' },
  { U'\xfed1', U'\x0641' },
  { U'\xfed5', U'\x0642' },
  { U'\xfed9', U'\x0643' },
  { U'\xfedd', U'\x0644' },
  { U'\xfee1', U'\x0645' },
  { U'\xfee5', U'\x0646' },
  { U'\xfee9', U'\x0647' },
  { U'\xfeed', U'\x0648' },
  { U'\xfeef', U'\x0649' },
  { U'\xfef1', U'\x064a' },
  { U'\xfef5', U'\x0644' },
  { U'\xfef7', U'\x0644' },
  { U'\xfef9', U'\x0644' },
  { U'\xfefb', U'\x0644' },
  { U'\xff01', U'\x0021' },
  { U'\xff02', U'\x0022' },
  { U'\xff03', U'\x0023' },
  { U'\xff04', U'\x0024' },
  { U'\xff05', U'\x0025' },
  { U'\xff06', U'\x0026' },
  { U'\xff07', U'\x0027' },
  { U'\xff08', U'\x0028' },
  { U'\xff09', U'\x0029' },
  { U'\xff0a', U'\x002a' },
  { U'\xff0b', U'\x002b' },
  { U'\xff0c', U'\x002c' },
  { U'\xff0d', U'\x002d' },
  { U'\xff0e', U'\x002e' },
  { U'\xff0f', U'\x002f' },
  { U'\xff10', U'\x0030' },
  { U'\xff11', U'\x0031' },
  { U'\xff12', U'\x0032' },
  { U'\xff13', U'\x0033' },
  { U'\xff14', U'\x0034' },
  { U'\xff15', U'\x0035' },
  { U'\xff16', U'\x0036' },
  { U'\xff17', U'\x0037' },
  { U'\xff18', U'\x0038' },
  { U'\xff19', U'\x0039' },
  { U'\xff1a', U'\x003a' },
  { U'\xff1b', U'\x003b' },
  { U'\xff1c', U'\x003c' },
  { U'\xff1d', U'\x003d' },
  { U'\xff1e', U'\x003e' },
  { U'\xff1f', U'\x003f' },
  { U'\xff20', U'\x0040' },
  { U'\xff21', U'\x0061' },
  { U'\xff22', U'\x0062' },
  { U'\xff23', U'\x0063' },
  { U'\xff24', U'\x0064' },
  { U'\xff25', U'\x0065' },
  { U'\xff26', U'\x0066' },
  { U'\xff27', U'\x0067' },
  { U'\xff28', U'\x0068' },
  { U'\xff29', U'\x0069' },
  { U'\xff2a', U'\x006a' },
  { U'\xff2b', U'\x006b' },
  { U'\xff2c', U'\x006c' },
  { U'\xff2d', U'\x006d' },
  { U'\xff2e', U'\x006e' },
  { U'\xff2f', U'\x006f' },
  { U'\xff30', U'\x0070' },
  { U'\xff31', U'\x0071' },
  { U'\xff32', U'\x0072' },
  { U'\xff33', U'\x0073' },
  { U'\xff34', U'\x0074' },
  { U'\xff35', U'\x0075' },
  { U'\xff36', U'\x0076' },
  { U'\xff37', U'\x0077' },
  { U'\xff38', U'\x0078' },
  { U'\xff39', U'\x0079' },
  { U'\xff3a', U'\x007a' },
  { U'\xff3b', U'\x005b' },
  { U'\xff3c', U'\x005c' },
  { U'\xff3d', U'\x005d' },
  { U'\xff3e', U'\x005e' },
  { U'\xff3f', U'\x005f' },
  { U'\xff40', U'\x0060' },
  { U'\xff41', U'\x0061' },
  { U'\xff42', U'\x0062' },
  { U'\xff43', U'\x0063' },
  { U'\xff44', U'\x0064' },
  { U'\xff45', U'\x0065' },
  { U'\xff46', U'\x0066' },
  { U'\xff47', U'\x0067' },
  { U'\xff48', U'\x0068' },
  { U'\xff49', U'\x0069' },
  { U'\xff4a', U'\x006a' },
  { U'\xff4b', U'\x006b' },
  { U'\xff4c', U'\x006c' },
  { U'\xff4d', U'\x006d' },
  { U'\xff4e', U'\x006e' },
  { U'\xff4f', U'\x006f' },
  { U'\xff50', U'\x0070' },
  { U'\xff51', U'\x0071' },
  { U'\xff52', U'\x0072' },
  { U'\xff53', U'\x0073' },
  { U'\xff54', U'\x0074' },
  { U'\xff55', U'\x0075' },
  { U'\xff56', U'\x0076' },
  { U'\xff57', U'\x0077' },
  { U'\xff58', U'\x0078' },
  { U'\xff59', U'\x0079' },
  { U'\xff5a', U'\x007a' },
  { U'\xff5b', U'\x007b' },
  { U'\xff5c', U'\x007c' },
  { U'\xff5d', U'\x007d' },
  { U'\xff5e', U'\x007e' },
  { U'\xff5f', U'\x2985' },
  { U'\xff60', U'\x2986' },
  { U'\xff61', U'\x002e' },
  { U'\xff62', U'\x300c' },
  { U'\xff63', U'\x300d' },
  { U'\xff64', U'\x3001' },
  { U'\xff65', U'\x30fb' },
  { U'\xff66', U'\x30f2' },
  { U'\xff67', U'\x30a1' },
  { U'\xff68', U'\x30a3' },
  { U'\xff69', U'\x30a5' },
  { U'\xff6a', U'\x30a7' },
  { U'\xff6b', U'\x30a9' },
  { U'\xff6c', U'\x30e3' },
  { U'\xff6d', U'\x30e5' },
  { U'\xff6e', U'\x30e7' },
  { U'\xff6f', U'\x30c3' },
  { U'\xff70', U'\x30fc' },
  { U'\xff71', U'\x30a2' },
  { U'\xff72', U'\x30a4' },
  { U'\xff73', U'\x30a6' },
  { U'\xff74', U'\x30a8' },
  { U'\xff75', U'\x30aa' },
  { U'\xff76', U'\x30ab' },
  { U'\xff77', U'\x30ad' },
  { U'\xff78', U'\x30af' },
  { U'\xff79', U'\x30b1' },
  { U'\xff7a', U'\x30b3' },
  { U'\xff7b', U'\x30b5' },
  { U'\xff7c', U'\x30b7' },
  { U'\xff7d', U'\x30b9' },
  { U'\xff7e', U'\x30bb' },
  { U'\xff7f', U'\x30bd' },
  { U'\xff80', U'\x30bf' },
  { U'\xff81', U'\x30c1' },
  { U'\xff82', U'\x30c4' },
  { U'\xff83', U'\x30c6' },
  { U'\xff84', U'\x30c8' },
  { U'\xff85', U'\x30ca' },
  { U'\xff86', U'\x30cb' },
  { U'\xff87', U'\x30cc' },
  { U'\xff88', U'\x30cd' },
  { U'\xff89', U'\x30ce' },
  { U'\xff8a', U'\x30cf' },
  { U'\xff8b', U'\x30d2' },
  { U'\xff8c', U'\x30d5' },
  { U'\xff8d', U'\x30d8' },
  { U'\xff8e', U'\x30db' },
  { U'\xff8f', U'\x30de' },
  { U'\xff90', U'\x30df' },
  { U'\xff91', U'\x30e0' },
  { U'\xff92', U'\x30e1' },
  { U'\xff93', U'\x30e2' },
  { U'\xff94', U'\x30e4' },
  { U'\xff95', U'\x30e6' },
  { U'\xff96', U'\x30e8' },
  { U'\xff97', U'\x30e9' },
  { U'\xff98', U'\x30ea' },
  { U'\xff99', U'\x30eb' },
  { U'\xff9a', U'\x30ec' },
  { U'\xff9b', U'\x30ed' },
  { U'\xff9c', U'\x30ef' },
  { U'\xff9d', U'\x30f3' },
  { U'\xff9e', U'\x3099' },
  { U'\xff9f', U'\x309a' },
  { U'\xffa1', U'\x1100' },
  { U'\xffa2', U'\x1101' },
  { U'\xffa3', U'\x11aa' },
  { U'\xffa4', U'\x1102' },
  { U'\xffa5', U'\x11ac' },
  { U'\xffa6', U'\x11ad' },
  { U'\xffa7', U'\x1103' },
  { U'\xffa8', U'\x1104' },
  { U'\xffa9', U'\x1105' },
  { U'\xffaa', U'\x11b0' },
  { U'\xffab', U'\x11b1' },
  { U'\xffac', U'\x11b2' },
  { U'\xffad', U'\x11b3' },
  { U'\xffae', U'\x11b4' },
  { U'\xffaf', U'\x11b5' },
  { U'\xffb0', U'\x111a' },
  { U'\xffb1', U'\x1106' },
  { U'\xffb2', U'\x1107' },
  { U'\xffb3', U'\x1108' },
  { U'\xffb4', U'\x1121' },
  { U'\xffb5', U'\x1109' },
  { U'\xffb6', U'\x110a' },
  { U'\xffb7', U'\x110b' },
  { U'\xffb8', U'\x110c' },
  { U'\xffb9', U'\x110d' },
  { U'\xffba', U'\x110e' },
  { U'\xffbb', U'\x110f' },
  { U'\xffbc', U'\x1110' },
  { U'\xffbd', U'\x1111' },
  { U'\xffbe', U'\x1112' },
  { U'\xffc2', U'\x1161' },
  { U'\xffc3', U'\x1162' },
  { U'\xffc4', U'\x1163' },
  { U'\xffc5', U'\x1164' },
  { U'\xffc6', U'\x1165' },
  { U'\xffc7', U'\x1166' },
  { U'\xffca', U'\x1167' },
  { U'\xffcb', U'\x1168' },
  { U'\xffcc', U'\x1169' },
  { U'\xffcd', U'\x116a' },
  { U'\xffce', U'\x116b' },
  { U'\xffcf', U'\x116c' },
  { U'\xffd2', U'\x116d' },
  { U'\xffd3', U'\x116e' },
  { U'\xffd4', U'\x116f' },
  { U'\xffd5', U'\x1170' },
  { U'\xffd6', U'\x1171' },
  { U'\xffd7', U'\x1172' },
  { U'\xffda', U'\x1173' },
  { U'\xffdb', U'\x1174' },
  { U'\xffdc', U'\x1175' },
  { U'\xffe0', U'\x00a2' },
  { U'\xffe1', U'\x00a3' },
  { U'\xffe2', U'\x00ac' },
  { U'\xffe3', U'\x0020' },
  { U'\xffe4', U'\x00a6' },
  { U'\xffe5', U'\x00a5' },
  { U'\xffe6', U'\x20a9' },
  { U'\xffe8', U'\x2502' },
  { U'\xffe9', U'\x2190' },
  { U'\xffea', U'\x2191' },
  { U'\xffeb', U'\x2192' },
  { U'\xffec', U'\x2193' },
  { U'\xffed', U'\x25a0' },
  { U'\xffee', U'\x25cb' },
}};

auto map_code_point_16(char16_t code_point) -> char16_t {
  constexpr static auto less = [](const auto &lhs, auto rhs) {
    return lhs.code_point < rhs;
  };

  auto first = std::begin(mapped_16), last = std::end(mapped_16);
  auto it = std::lower_bound(first, last, code_point, less);
  return (it != last) ? it->mapped : code_point;
}

struct mapped_32_code_point {
  char32_t code_point;
  char32_t mapped;
};

constexpr static auto mapped_32 = std::array<mapped_32_code_point, 2038>{{
  { U'\xfa6c', U'\x242ee' },
  { U'\xfacf', U'\x2284a' },
  { U'\xfad0', U'\x22844' },
  { U'\xfad1', U'\x233d5' },
  { U'\xfad5', U'\x25249' },
  { U'\xfad6', U'\x25cd0' },
  { U'\xfad7', U'\x27ed3' },
  { U'\x10400', U'\x10428' },
  { U'\x10401', U'\x10429' },
  { U'\x10402', U'\x1042a' },
  { U'\x10403', U'\x1042b' },
  { U'\x10404', U'\x1042c' },
  { U'\x10405', U'\x1042d' },
  { U'\x10406', U'\x1042e' },
  { U'\x10407', U'\x1042f' },
  { U'\x10408', U'\x10430' },
  { U'\x10409', U'\x10431' },
  { U'\x1040a', U'\x10432' },
  { U'\x1040b', U'\x10433' },
  { U'\x1040c', U'\x10434' },
  { U'\x1040d', U'\x10435' },
  { U'\x1040e', U'\x10436' },
  { U'\x1040f', U'\x10437' },
  { U'\x10410', U'\x10438' },
  { U'\x10411', U'\x10439' },
  { U'\x10412', U'\x1043a' },
  { U'\x10413', U'\x1043b' },
  { U'\x10414', U'\x1043c' },
  { U'\x10415', U'\x1043d' },
  { U'\x10416', U'\x1043e' },
  { U'\x10417', U'\x1043f' },
  { U'\x10418', U'\x10440' },
  { U'\x10419', U'\x10441' },
  { U'\x1041a', U'\x10442' },
  { U'\x1041b', U'\x10443' },
  { U'\x1041c', U'\x10444' },
  { U'\x1041d', U'\x10445' },
  { U'\x1041e', U'\x10446' },
  { U'\x1041f', U'\x10447' },
  { U'\x10420', U'\x10448' },
  { U'\x10421', U'\x10449' },
  { U'\x10422', U'\x1044a' },
  { U'\x10423', U'\x1044b' },
  { U'\x10424', U'\x1044c' },
  { U'\x10425', U'\x1044d' },
  { U'\x10426', U'\x1044e' },
  { U'\x10427', U'\x1044f' },
  { U'\x104b0', U'\x104d8' },
  { U'\x104b1', U'\x104d9' },
  { U'\x104b2', U'\x104da' },
  { U'\x104b3', U'\x104db' },
  { U'\x104b4', U'\x104dc' },
  { U'\x104b5', U'\x104dd' },
  { U'\x104b6', U'\x104de' },
  { U'\x104b7', U'\x104df' },
  { U'\x104b8', U'\x104e0' },
  { U'\x104b9', U'\x104e1' },
  { U'\x104ba', U'\x104e2' },
  { U'\x104bb', U'\x104e3' },
  { U'\x104bc', U'\x104e4' },
  { U'\x104bd', U'\x104e5' },
  { U'\x104be', U'\x104e6' },
  { U'\x104bf', U'\x104e7' },
  { U'\x104c0', U'\x104e8' },
  { U'\x104c1', U'\x104e9' },
  { U'\x104c2', U'\x104ea' },
  { U'\x104c3', U'\x104eb' },
  { U'\x104c4', U'\x104ec' },
  { U'\x104c5', U'\x104ed' },
  { U'\x104c6', U'\x104ee' },
  { U'\x104c7', U'\x104ef' },
  { U'\x104c8', U'\x104f0' },
  { U'\x104c9', U'\x104f1' },
  { U'\x104ca', U'\x104f2' },
  { U'\x104cb', U'\x104f3' },
  { U'\x104cc', U'\x104f4' },
  { U'\x104cd', U'\x104f5' },
  { U'\x104ce', U'\x104f6' },
  { U'\x104cf', U'\x104f7' },
  { U'\x104d0', U'\x104f8' },
  { U'\x104d1', U'\x104f9' },
  { U'\x104d2', U'\x104fa' },
  { U'\x104d3', U'\x104fb' },
  { U'\x10c80', U'\x10cc0' },
  { U'\x10c81', U'\x10cc1' },
  { U'\x10c82', U'\x10cc2' },
  { U'\x10c83', U'\x10cc3' },
  { U'\x10c84', U'\x10cc4' },
  { U'\x10c85', U'\x10cc5' },
  { U'\x10c86', U'\x10cc6' },
  { U'\x10c87', U'\x10cc7' },
  { U'\x10c88', U'\x10cc8' },
  { U'\x10c89', U'\x10cc9' },
  { U'\x10c8a', U'\x10cca' },
  { U'\x10c8b', U'\x10ccb' },
  { U'\x10c8c', U'\x10ccc' },
  { U'\x10c8d', U'\x10ccd' },
  { U'\x10c8e', U'\x10cce' },
  { U'\x10c8f', U'\x10ccf' },
  { U'\x10c90', U'\x10cd0' },
  { U'\x10c91', U'\x10cd1' },
  { U'\x10c92', U'\x10cd2' },
  { U'\x10c93', U'\x10cd3' },
  { U'\x10c94', U'\x10cd4' },
  { U'\x10c95', U'\x10cd5' },
  { U'\x10c96', U'\x10cd6' },
  { U'\x10c97', U'\x10cd7' },
  { U'\x10c98', U'\x10cd8' },
  { U'\x10c99', U'\x10cd9' },
  { U'\x10c9a', U'\x10cda' },
  { U'\x10c9b', U'\x10cdb' },
  { U'\x10c9c', U'\x10cdc' },
  { U'\x10c9d', U'\x10cdd' },
  { U'\x10c9e', U'\x10cde' },
  { U'\x10c9f', U'\x10cdf' },
  { U'\x10ca0', U'\x10ce0' },
  { U'\x10ca1', U'\x10ce1' },
  { U'\x10ca2', U'\x10ce2' },
  { U'\x10ca3', U'\x10ce3' },
  { U'\x10ca4', U'\x10ce4' },
  { U'\x10ca5', U'\x10ce5' },
  { U'\x10ca6', U'\x10ce6' },
  { U'\x10ca7', U'\x10ce7' },
  { U'\x10ca8', U'\x10ce8' },
  { U'\x10ca9', U'\x10ce9' },
  { U'\x10caa', U'\x10cea' },
  { U'\x10cab', U'\x10ceb' },
  { U'\x10cac', U'\x10cec' },
  { U'\x10cad', U'\x10ced' },
  { U'\x10cae', U'\x10cee' },
  { U'\x10caf', U'\x10cef' },
  { U'\x10cb0', U'\x10cf0' },
  { U'\x10cb1', U'\x10cf1' },
  { U'\x10cb2', U'\x10cf2' },
  { U'\x118a0', U'\x118c0' },
  { U'\x118a1', U'\x118c1' },
  { U'\x118a2', U'\x118c2' },
  { U'\x118a3', U'\x118c3' },
  { U'\x118a4', U'\x118c4' },
  { U'\x118a5', U'\x118c5' },
  { U'\x118a6', U'\x118c6' },
  { U'\x118a7', U'\x118c7' },
  { U'\x118a8', U'\x118c8' },
  { U'\x118a9', U'\x118c9' },
  { U'\x118aa', U'\x118ca' },
  { U'\x118ab', U'\x118cb' },
  { U'\x118ac', U'\x118cc' },
  { U'\x118ad', U'\x118cd' },
  { U'\x118ae', U'\x118ce' },
  { U'\x118af', U'\x118cf' },
  { U'\x118b0', U'\x118d0' },
  { U'\x118b1', U'\x118d1' },
  { U'\x118b2', U'\x118d2' },
  { U'\x118b3', U'\x118d3' },
  { U'\x118b4', U'\x118d4' },
  { U'\x118b5', U'\x118d5' },
  { U'\x118b6', U'\x118d6' },
  { U'\x118b7', U'\x118d7' },
  { U'\x118b8', U'\x118d8' },
  { U'\x118b9', U'\x118d9' },
  { U'\x118ba', U'\x118da' },
  { U'\x118bb', U'\x118db' },
  { U'\x118bc', U'\x118dc' },
  { U'\x118bd', U'\x118dd' },
  { U'\x118be', U'\x118de' },
  { U'\x118bf', U'\x118df' },
  { U'\x16e40', U'\x16e60' },
  { U'\x16e41', U'\x16e61' },
  { U'\x16e42', U'\x16e62' },
  { U'\x16e43', U'\x16e63' },
  { U'\x16e44', U'\x16e64' },
  { U'\x16e45', U'\x16e65' },
  { U'\x16e46', U'\x16e66' },
  { U'\x16e47', U'\x16e67' },
  { U'\x16e48', U'\x16e68' },
  { U'\x16e49', U'\x16e69' },
  { U'\x16e4a', U'\x16e6a' },
  { U'\x16e4b', U'\x16e6b' },
  { U'\x16e4c', U'\x16e6c' },
  { U'\x16e4d', U'\x16e6d' },
  { U'\x16e4e', U'\x16e6e' },
  { U'\x16e4f', U'\x16e6f' },
  { U'\x16e50', U'\x16e70' },
  { U'\x16e51', U'\x16e71' },
  { U'\x16e52', U'\x16e72' },
  { U'\x16e53', U'\x16e73' },
  { U'\x16e54', U'\x16e74' },
  { U'\x16e55', U'\x16e75' },
  { U'\x16e56', U'\x16e76' },
  { U'\x16e57', U'\x16e77' },
  { U'\x16e58', U'\x16e78' },
  { U'\x16e59', U'\x16e79' },
  { U'\x16e5a', U'\x16e7a' },
  { U'\x16e5b', U'\x16e7b' },
  { U'\x16e5c', U'\x16e7c' },
  { U'\x16e5d', U'\x16e7d' },
  { U'\x16e5e', U'\x16e7e' },
  { U'\x16e5f', U'\x16e7f' },
  { U'\x1d15e', U'\x1d157' },
  { U'\x1d15f', U'\x1d158' },
  { U'\x1d160', U'\x1d158' },
  { U'\x1d161', U'\x1d158' },
  { U'\x1d162', U'\x1d158' },
  { U'\x1d163', U'\x1d158' },
  { U'\x1d164', U'\x1d158' },
  { U'\x1d1bb', U'\x1d1b9' },
  { U'\x1d1bc', U'\x1d1ba' },
  { U'\x1d1bd', U'\x1d1b9' },
  { U'\x1d1be', U'\x1d1ba' },
  { U'\x1d1bf', U'\x1d1b9' },
  { U'\x1d1c0', U'\x1d1ba' },
  { U'\x1d400', U'\x0061' },
  { U'\x1d401', U'\x0062' },
  { U'\x1d402', U'\x0063' },
  { U'\x1d403', U'\x0064' },
  { U'\x1d404', U'\x0065' },
  { U'\x1d405', U'\x0066' },
  { U'\x1d406', U'\x0067' },
  { U'\x1d407', U'\x0068' },
  { U'\x1d408', U'\x0069' },
  { U'\x1d409', U'\x006a' },
  { U'\x1d40a', U'\x006b' },
  { U'\x1d40b', U'\x006c' },
  { U'\x1d40c', U'\x006d' },
  { U'\x1d40d', U'\x006e' },
  { U'\x1d40e', U'\x006f' },
  { U'\x1d40f', U'\x0070' },
  { U'\x1d410', U'\x0071' },
  { U'\x1d411', U'\x0072' },
  { U'\x1d412', U'\x0073' },
  { U'\x1d413', U'\x0074' },
  { U'\x1d414', U'\x0075' },
  { U'\x1d415', U'\x0076' },
  { U'\x1d416', U'\x0077' },
  { U'\x1d417', U'\x0078' },
  { U'\x1d418', U'\x0079' },
  { U'\x1d419', U'\x007a' },
  { U'\x1d41a', U'\x0061' },
  { U'\x1d41b', U'\x0062' },
  { U'\x1d41c', U'\x0063' },
  { U'\x1d41d', U'\x0064' },
  { U'\x1d41e', U'\x0065' },
  { U'\x1d41f', U'\x0066' },
  { U'\x1d420', U'\x0067' },
  { U'\x1d421', U'\x0068' },
  { U'\x1d422', U'\x0069' },
  { U'\x1d423', U'\x006a' },
  { U'\x1d424', U'\x006b' },
  { U'\x1d425', U'\x006c' },
  { U'\x1d426', U'\x006d' },
  { U'\x1d427', U'\x006e' },
  { U'\x1d428', U'\x006f' },
  { U'\x1d429', U'\x0070' },
  { U'\x1d42a', U'\x0071' },
  { U'\x1d42b', U'\x0072' },
  { U'\x1d42c', U'\x0073' },
  { U'\x1d42d', U'\x0074' },
  { U'\x1d42e', U'\x0075' },
  { U'\x1d42f', U'\x0076' },
  { U'\x1d430', U'\x0077' },
  { U'\x1d431', U'\x0078' },
  { U'\x1d432', U'\x0079' },
  { U'\x1d433', U'\x007a' },
  { U'\x1d434', U'\x0061' },
  { U'\x1d435', U'\x0062' },
  { U'\x1d436', U'\x0063' },
  { U'\x1d437', U'\x0064' },
  { U'\x1d438', U'\x0065' },
  { U'\x1d439', U'\x0066' },
  { U'\x1d43a', U'\x0067' },
  { U'\x1d43b', U'\x0068' },
  { U'\x1d43c', U'\x0069' },
  { U'\x1d43d', U'\x006a' },
  { U'\x1d43e', U'\x006b' },
  { U'\x1d43f', U'\x006c' },
  { U'\x1d440', U'\x006d' },
  { U'\x1d441', U'\x006e' },
  { U'\x1d442', U'\x006f' },
  { U'\x1d443', U'\x0070' },
  { U'\x1d444', U'\x0071' },
  { U'\x1d445', U'\x0072' },
  { U'\x1d446', U'\x0073' },
  { U'\x1d447', U'\x0074' },
  { U'\x1d448', U'\x0075' },
  { U'\x1d449', U'\x0076' },
  { U'\x1d44a', U'\x0077' },
  { U'\x1d44b', U'\x0078' },
  { U'\x1d44c', U'\x0079' },
  { U'\x1d44d', U'\x007a' },
  { U'\x1d44e', U'\x0061' },
  { U'\x1d44f', U'\x0062' },
  { U'\x1d450', U'\x0063' },
  { U'\x1d451', U'\x0064' },
  { U'\x1d452', U'\x0065' },
  { U'\x1d453', U'\x0066' },
  { U'\x1d454', U'\x0067' },
  { U'\x1d456', U'\x0069' },
  { U'\x1d457', U'\x006a' },
  { U'\x1d458', U'\x006b' },
  { U'\x1d459', U'\x006c' },
  { U'\x1d45a', U'\x006d' },
  { U'\x1d45b', U'\x006e' },
  { U'\x1d45c', U'\x006f' },
  { U'\x1d45d', U'\x0070' },
  { U'\x1d45e', U'\x0071' },
  { U'\x1d45f', U'\x0072' },
  { U'\x1d460', U'\x0073' },
  { U'\x1d461', U'\x0074' },
  { U'\x1d462', U'\x0075' },
  { U'\x1d463', U'\x0076' },
  { U'\x1d464', U'\x0077' },
  { U'\x1d465', U'\x0078' },
  { U'\x1d466', U'\x0079' },
  { U'\x1d467', U'\x007a' },
  { U'\x1d468', U'\x0061' },
  { U'\x1d469', U'\x0062' },
  { U'\x1d46a', U'\x0063' },
  { U'\x1d46b', U'\x0064' },
  { U'\x1d46c', U'\x0065' },
  { U'\x1d46d', U'\x0066' },
  { U'\x1d46e', U'\x0067' },
  { U'\x1d46f', U'\x0068' },
  { U'\x1d470', U'\x0069' },
  { U'\x1d471', U'\x006a' },
  { U'\x1d472', U'\x006b' },
  { U'\x1d473', U'\x006c' },
  { U'\x1d474', U'\x006d' },
  { U'\x1d475', U'\x006e' },
  { U'\x1d476', U'\x006f' },
  { U'\x1d477', U'\x0070' },
  { U'\x1d478', U'\x0071' },
  { U'\x1d479', U'\x0072' },
  { U'\x1d47a', U'\x0073' },
  { U'\x1d47b', U'\x0074' },
  { U'\x1d47c', U'\x0075' },
  { U'\x1d47d', U'\x0076' },
  { U'\x1d47e', U'\x0077' },
  { U'\x1d47f', U'\x0078' },
  { U'\x1d480', U'\x0079' },
  { U'\x1d481', U'\x007a' },
  { U'\x1d482', U'\x0061' },
  { U'\x1d483', U'\x0062' },
  { U'\x1d484', U'\x0063' },
  { U'\x1d485', U'\x0064' },
  { U'\x1d486', U'\x0065' },
  { U'\x1d487', U'\x0066' },
  { U'\x1d488', U'\x0067' },
  { U'\x1d489', U'\x0068' },
  { U'\x1d48a', U'\x0069' },
  { U'\x1d48b', U'\x006a' },
  { U'\x1d48c', U'\x006b' },
  { U'\x1d48d', U'\x006c' },
  { U'\x1d48e', U'\x006d' },
  { U'\x1d48f', U'\x006e' },
  { U'\x1d490', U'\x006f' },
  { U'\x1d491', U'\x0070' },
  { U'\x1d492', U'\x0071' },
  { U'\x1d493', U'\x0072' },
  { U'\x1d494', U'\x0073' },
  { U'\x1d495', U'\x0074' },
  { U'\x1d496', U'\x0075' },
  { U'\x1d497', U'\x0076' },
  { U'\x1d498', U'\x0077' },
  { U'\x1d499', U'\x0078' },
  { U'\x1d49a', U'\x0079' },
  { U'\x1d49b', U'\x007a' },
  { U'\x1d49c', U'\x0061' },
  { U'\x1d49e', U'\x0063' },
  { U'\x1d49f', U'\x0064' },
  { U'\x1d4a2', U'\x0067' },
  { U'\x1d4a5', U'\x006a' },
  { U'\x1d4a6', U'\x006b' },
  { U'\x1d4a9', U'\x006e' },
  { U'\x1d4aa', U'\x006f' },
  { U'\x1d4ab', U'\x0070' },
  { U'\x1d4ac', U'\x0071' },
  { U'\x1d4ae', U'\x0073' },
  { U'\x1d4af', U'\x0074' },
  { U'\x1d4b0', U'\x0075' },
  { U'\x1d4b1', U'\x0076' },
  { U'\x1d4b2', U'\x0077' },
  { U'\x1d4b3', U'\x0078' },
  { U'\x1d4b4', U'\x0079' },
  { U'\x1d4b5', U'\x007a' },
  { U'\x1d4b6', U'\x0061' },
  { U'\x1d4b7', U'\x0062' },
  { U'\x1d4b8', U'\x0063' },
  { U'\x1d4b9', U'\x0064' },
  { U'\x1d4bb', U'\x0066' },
  { U'\x1d4bd', U'\x0068' },
  { U'\x1d4be', U'\x0069' },
  { U'\x1d4bf', U'\x006a' },
  { U'\x1d4c0', U'\x006b' },
  { U'\x1d4c1', U'\x006c' },
  { U'\x1d4c2', U'\x006d' },
  { U'\x1d4c3', U'\x006e' },
  { U'\x1d4c5', U'\x0070' },
  { U'\x1d4c6', U'\x0071' },
  { U'\x1d4c7', U'\x0072' },
  { U'\x1d4c8', U'\x0073' },
  { U'\x1d4c9', U'\x0074' },
  { U'\x1d4ca', U'\x0075' },
  { U'\x1d4cb', U'\x0076' },
  { U'\x1d4cc', U'\x0077' },
  { U'\x1d4cd', U'\x0078' },
  { U'\x1d4ce', U'\x0079' },
  { U'\x1d4cf', U'\x007a' },
  { U'\x1d4d0', U'\x0061' },
  { U'\x1d4d1', U'\x0062' },
  { U'\x1d4d2', U'\x0063' },
  { U'\x1d4d3', U'\x0064' },
  { U'\x1d4d4', U'\x0065' },
  { U'\x1d4d5', U'\x0066' },
  { U'\x1d4d6', U'\x0067' },
  { U'\x1d4d7', U'\x0068' },
  { U'\x1d4d8', U'\x0069' },
  { U'\x1d4d9', U'\x006a' },
  { U'\x1d4da', U'\x006b' },
  { U'\x1d4db', U'\x006c' },
  { U'\x1d4dc', U'\x006d' },
  { U'\x1d4dd', U'\x006e' },
  { U'\x1d4de', U'\x006f' },
  { U'\x1d4df', U'\x0070' },
  { U'\x1d4e0', U'\x0071' },
  { U'\x1d4e1', U'\x0072' },
  { U'\x1d4e2', U'\x0073' },
  { U'\x1d4e3', U'\x0074' },
  { U'\x1d4e4', U'\x0075' },
  { U'\x1d4e5', U'\x0076' },
  { U'\x1d4e6', U'\x0077' },
  { U'\x1d4e7', U'\x0078' },
  { U'\x1d4e8', U'\x0079' },
  { U'\x1d4e9', U'\x007a' },
  { U'\x1d4ea', U'\x0061' },
  { U'\x1d4eb', U'\x0062' },
  { U'\x1d4ec', U'\x0063' },
  { U'\x1d4ed', U'\x0064' },
  { U'\x1d4ee', U'\x0065' },
  { U'\x1d4ef', U'\x0066' },
  { U'\x1d4f0', U'\x0067' },
  { U'\x1d4f1', U'\x0068' },
  { U'\x1d4f2', U'\x0069' },
  { U'\x1d4f3', U'\x006a' },
  { U'\x1d4f4', U'\x006b' },
  { U'\x1d4f5', U'\x006c' },
  { U'\x1d4f6', U'\x006d' },
  { U'\x1d4f7', U'\x006e' },
  { U'\x1d4f8', U'\x006f' },
  { U'\x1d4f9', U'\x0070' },
  { U'\x1d4fa', U'\x0071' },
  { U'\x1d4fb', U'\x0072' },
  { U'\x1d4fc', U'\x0073' },
  { U'\x1d4fd', U'\x0074' },
  { U'\x1d4fe', U'\x0075' },
  { U'\x1d4ff', U'\x0076' },
  { U'\x1d500', U'\x0077' },
  { U'\x1d501', U'\x0078' },
  { U'\x1d502', U'\x0079' },
  { U'\x1d503', U'\x007a' },
  { U'\x1d504', U'\x0061' },
  { U'\x1d505', U'\x0062' },
  { U'\x1d507', U'\x0064' },
  { U'\x1d508', U'\x0065' },
  { U'\x1d509', U'\x0066' },
  { U'\x1d50a', U'\x0067' },
  { U'\x1d50d', U'\x006a' },
  { U'\x1d50e', U'\x006b' },
  { U'\x1d50f', U'\x006c' },
  { U'\x1d510', U'\x006d' },
  { U'\x1d511', U'\x006e' },
  { U'\x1d512', U'\x006f' },
  { U'\x1d513', U'\x0070' },
  { U'\x1d514', U'\x0071' },
  { U'\x1d516', U'\x0073' },
  { U'\x1d517', U'\x0074' },
  { U'\x1d518', U'\x0075' },
  { U'\x1d519', U'\x0076' },
  { U'\x1d51a', U'\x0077' },
  { U'\x1d51b', U'\x0078' },
  { U'\x1d51c', U'\x0079' },
  { U'\x1d51e', U'\x0061' },
  { U'\x1d51f', U'\x0062' },
  { U'\x1d520', U'\x0063' },
  { U'\x1d521', U'\x0064' },
  { U'\x1d522', U'\x0065' },
  { U'\x1d523', U'\x0066' },
  { U'\x1d524', U'\x0067' },
  { U'\x1d525', U'\x0068' },
  { U'\x1d526', U'\x0069' },
  { U'\x1d527', U'\x006a' },
  { U'\x1d528', U'\x006b' },
  { U'\x1d529', U'\x006c' },
  { U'\x1d52a', U'\x006d' },
  { U'\x1d52b', U'\x006e' },
  { U'\x1d52c', U'\x006f' },
  { U'\x1d52d', U'\x0070' },
  { U'\x1d52e', U'\x0071' },
  { U'\x1d52f', U'\x0072' },
  { U'\x1d530', U'\x0073' },
  { U'\x1d531', U'\x0074' },
  { U'\x1d532', U'\x0075' },
  { U'\x1d533', U'\x0076' },
  { U'\x1d534', U'\x0077' },
  { U'\x1d535', U'\x0078' },
  { U'\x1d536', U'\x0079' },
  { U'\x1d537', U'\x007a' },
  { U'\x1d538', U'\x0061' },
  { U'\x1d539', U'\x0062' },
  { U'\x1d53b', U'\x0064' },
  { U'\x1d53c', U'\x0065' },
  { U'\x1d53d', U'\x0066' },
  { U'\x1d53e', U'\x0067' },
  { U'\x1d540', U'\x0069' },
  { U'\x1d541', U'\x006a' },
  { U'\x1d542', U'\x006b' },
  { U'\x1d543', U'\x006c' },
  { U'\x1d544', U'\x006d' },
  { U'\x1d546', U'\x006f' },
  { U'\x1d54a', U'\x0073' },
  { U'\x1d54b', U'\x0074' },
  { U'\x1d54c', U'\x0075' },
  { U'\x1d54d', U'\x0076' },
  { U'\x1d54e', U'\x0077' },
  { U'\x1d54f', U'\x0078' },
  { U'\x1d550', U'\x0079' },
  { U'\x1d552', U'\x0061' },
  { U'\x1d553', U'\x0062' },
  { U'\x1d554', U'\x0063' },
  { U'\x1d555', U'\x0064' },
  { U'\x1d556', U'\x0065' },
  { U'\x1d557', U'\x0066' },
  { U'\x1d558', U'\x0067' },
  { U'\x1d559', U'\x0068' },
  { U'\x1d55a', U'\x0069' },
  { U'\x1d55b', U'\x006a' },
  { U'\x1d55c', U'\x006b' },
  { U'\x1d55d', U'\x006c' },
  { U'\x1d55e', U'\x006d' },
  { U'\x1d55f', U'\x006e' },
  { U'\x1d560', U'\x006f' },
  { U'\x1d561', U'\x0070' },
  { U'\x1d562', U'\x0071' },
  { U'\x1d563', U'\x0072' },
  { U'\x1d564', U'\x0073' },
  { U'\x1d565', U'\x0074' },
  { U'\x1d566', U'\x0075' },
  { U'\x1d567', U'\x0076' },
  { U'\x1d568', U'\x0077' },
  { U'\x1d569', U'\x0078' },
  { U'\x1d56a', U'\x0079' },
  { U'\x1d56b', U'\x007a' },
  { U'\x1d56c', U'\x0061' },
  { U'\x1d56d', U'\x0062' },
  { U'\x1d56e', U'\x0063' },
  { U'\x1d56f', U'\x0064' },
  { U'\x1d570', U'\x0065' },
  { U'\x1d571', U'\x0066' },
  { U'\x1d572', U'\x0067' },
  { U'\x1d573', U'\x0068' },
  { U'\x1d574', U'\x0069' },
  { U'\x1d575', U'\x006a' },
  { U'\x1d576', U'\x006b' },
  { U'\x1d577', U'\x006c' },
  { U'\x1d578', U'\x006d' },
  { U'\x1d579', U'\x006e' },
  { U'\x1d57a', U'\x006f' },
  { U'\x1d57b', U'\x0070' },
  { U'\x1d57c', U'\x0071' },
  { U'\x1d57d', U'\x0072' },
  { U'\x1d57e', U'\x0073' },
  { U'\x1d57f', U'\x0074' },
  { U'\x1d580', U'\x0075' },
  { U'\x1d581', U'\x0076' },
  { U'\x1d582', U'\x0077' },
  { U'\x1d583', U'\x0078' },
  { U'\x1d584', U'\x0079' },
  { U'\x1d585', U'\x007a' },
  { U'\x1d586', U'\x0061' },
  { U'\x1d587', U'\x0062' },
  { U'\x1d588', U'\x0063' },
  { U'\x1d589', U'\x0064' },
  { U'\x1d58a', U'\x0065' },
  { U'\x1d58b', U'\x0066' },
  { U'\x1d58c', U'\x0067' },
  { U'\x1d58d', U'\x0068' },
  { U'\x1d58e', U'\x0069' },
  { U'\x1d58f', U'\x006a' },
  { U'\x1d590', U'\x006b' },
  { U'\x1d591', U'\x006c' },
  { U'\x1d592', U'\x006d' },
  { U'\x1d593', U'\x006e' },
  { U'\x1d594', U'\x006f' },
  { U'\x1d595', U'\x0070' },
  { U'\x1d596', U'\x0071' },
  { U'\x1d597', U'\x0072' },
  { U'\x1d598', U'\x0073' },
  { U'\x1d599', U'\x0074' },
  { U'\x1d59a', U'\x0075' },
  { U'\x1d59b', U'\x0076' },
  { U'\x1d59c', U'\x0077' },
  { U'\x1d59d', U'\x0078' },
  { U'\x1d59e', U'\x0079' },
  { U'\x1d59f', U'\x007a' },
  { U'\x1d5a0', U'\x0061' },
  { U'\x1d5a1', U'\x0062' },
  { U'\x1d5a2', U'\x0063' },
  { U'\x1d5a3', U'\x0064' },
  { U'\x1d5a4', U'\x0065' },
  { U'\x1d5a5', U'\x0066' },
  { U'\x1d5a6', U'\x0067' },
  { U'\x1d5a7', U'\x0068' },
  { U'\x1d5a8', U'\x0069' },
  { U'\x1d5a9', U'\x006a' },
  { U'\x1d5aa', U'\x006b' },
  { U'\x1d5ab', U'\x006c' },
  { U'\x1d5ac', U'\x006d' },
  { U'\x1d5ad', U'\x006e' },
  { U'\x1d5ae', U'\x006f' },
  { U'\x1d5af', U'\x0070' },
  { U'\x1d5b0', U'\x0071' },
  { U'\x1d5b1', U'\x0072' },
  { U'\x1d5b2', U'\x0073' },
  { U'\x1d5b3', U'\x0074' },
  { U'\x1d5b4', U'\x0075' },
  { U'\x1d5b5', U'\x0076' },
  { U'\x1d5b6', U'\x0077' },
  { U'\x1d5b7', U'\x0078' },
  { U'\x1d5b8', U'\x0079' },
  { U'\x1d5b9', U'\x007a' },
  { U'\x1d5ba', U'\x0061' },
  { U'\x1d5bb', U'\x0062' },
  { U'\x1d5bc', U'\x0063' },
  { U'\x1d5bd', U'\x0064' },
  { U'\x1d5be', U'\x0065' },
  { U'\x1d5bf', U'\x0066' },
  { U'\x1d5c0', U'\x0067' },
  { U'\x1d5c1', U'\x0068' },
  { U'\x1d5c2', U'\x0069' },
  { U'\x1d5c3', U'\x006a' },
  { U'\x1d5c4', U'\x006b' },
  { U'\x1d5c5', U'\x006c' },
  { U'\x1d5c6', U'\x006d' },
  { U'\x1d5c7', U'\x006e' },
  { U'\x1d5c8', U'\x006f' },
  { U'\x1d5c9', U'\x0070' },
  { U'\x1d5ca', U'\x0071' },
  { U'\x1d5cb', U'\x0072' },
  { U'\x1d5cc', U'\x0073' },
  { U'\x1d5cd', U'\x0074' },
  { U'\x1d5ce', U'\x0075' },
  { U'\x1d5cf', U'\x0076' },
  { U'\x1d5d0', U'\x0077' },
  { U'\x1d5d1', U'\x0078' },
  { U'\x1d5d2', U'\x0079' },
  { U'\x1d5d3', U'\x007a' },
  { U'\x1d5d4', U'\x0061' },
  { U'\x1d5d5', U'\x0062' },
  { U'\x1d5d6', U'\x0063' },
  { U'\x1d5d7', U'\x0064' },
  { U'\x1d5d8', U'\x0065' },
  { U'\x1d5d9', U'\x0066' },
  { U'\x1d5da', U'\x0067' },
  { U'\x1d5db', U'\x0068' },
  { U'\x1d5dc', U'\x0069' },
  { U'\x1d5dd', U'\x006a' },
  { U'\x1d5de', U'\x006b' },
  { U'\x1d5df', U'\x006c' },
  { U'\x1d5e0', U'\x006d' },
  { U'\x1d5e1', U'\x006e' },
  { U'\x1d5e2', U'\x006f' },
  { U'\x1d5e3', U'\x0070' },
  { U'\x1d5e4', U'\x0071' },
  { U'\x1d5e5', U'\x0072' },
  { U'\x1d5e6', U'\x0073' },
  { U'\x1d5e7', U'\x0074' },
  { U'\x1d5e8', U'\x0075' },
  { U'\x1d5e9', U'\x0076' },
  { U'\x1d5ea', U'\x0077' },
  { U'\x1d5eb', U'\x0078' },
  { U'\x1d5ec', U'\x0079' },
  { U'\x1d5ed', U'\x007a' },
  { U'\x1d5ee', U'\x0061' },
  { U'\x1d5ef', U'\x0062' },
  { U'\x1d5f0', U'\x0063' },
  { U'\x1d5f1', U'\x0064' },
  { U'\x1d5f2', U'\x0065' },
  { U'\x1d5f3', U'\x0066' },
  { U'\x1d5f4', U'\x0067' },
  { U'\x1d5f5', U'\x0068' },
  { U'\x1d5f6', U'\x0069' },
  { U'\x1d5f7', U'\x006a' },
  { U'\x1d5f8', U'\x006b' },
  { U'\x1d5f9', U'\x006c' },
  { U'\x1d5fa', U'\x006d' },
  { U'\x1d5fb', U'\x006e' },
  { U'\x1d5fc', U'\x006f' },
  { U'\x1d5fd', U'\x0070' },
  { U'\x1d5fe', U'\x0071' },
  { U'\x1d5ff', U'\x0072' },
  { U'\x1d600', U'\x0073' },
  { U'\x1d601', U'\x0074' },
  { U'\x1d602', U'\x0075' },
  { U'\x1d603', U'\x0076' },
  { U'\x1d604', U'\x0077' },
  { U'\x1d605', U'\x0078' },
  { U'\x1d606', U'\x0079' },
  { U'\x1d607', U'\x007a' },
  { U'\x1d608', U'\x0061' },
  { U'\x1d609', U'\x0062' },
  { U'\x1d60a', U'\x0063' },
  { U'\x1d60b', U'\x0064' },
  { U'\x1d60c', U'\x0065' },
  { U'\x1d60d', U'\x0066' },
  { U'\x1d60e', U'\x0067' },
  { U'\x1d60f', U'\x0068' },
  { U'\x1d610', U'\x0069' },
  { U'\x1d611', U'\x006a' },
  { U'\x1d612', U'\x006b' },
  { U'\x1d613', U'\x006c' },
  { U'\x1d614', U'\x006d' },
  { U'\x1d615', U'\x006e' },
  { U'\x1d616', U'\x006f' },
  { U'\x1d617', U'\x0070' },
  { U'\x1d618', U'\x0071' },
  { U'\x1d619', U'\x0072' },
  { U'\x1d61a', U'\x0073' },
  { U'\x1d61b', U'\x0074' },
  { U'\x1d61c', U'\x0075' },
  { U'\x1d61d', U'\x0076' },
  { U'\x1d61e', U'\x0077' },
  { U'\x1d61f', U'\x0078' },
  { U'\x1d620', U'\x0079' },
  { U'\x1d621', U'\x007a' },
  { U'\x1d622', U'\x0061' },
  { U'\x1d623', U'\x0062' },
  { U'\x1d624', U'\x0063' },
  { U'\x1d625', U'\x0064' },
  { U'\x1d626', U'\x0065' },
  { U'\x1d627', U'\x0066' },
  { U'\x1d628', U'\x0067' },
  { U'\x1d629', U'\x0068' },
  { U'\x1d62a', U'\x0069' },
  { U'\x1d62b', U'\x006a' },
  { U'\x1d62c', U'\x006b' },
  { U'\x1d62d', U'\x006c' },
  { U'\x1d62e', U'\x006d' },
  { U'\x1d62f', U'\x006e' },
  { U'\x1d630', U'\x006f' },
  { U'\x1d631', U'\x0070' },
  { U'\x1d632', U'\x0071' },
  { U'\x1d633', U'\x0072' },
  { U'\x1d634', U'\x0073' },
  { U'\x1d635', U'\x0074' },
  { U'\x1d636', U'\x0075' },
  { U'\x1d637', U'\x0076' },
  { U'\x1d638', U'\x0077' },
  { U'\x1d639', U'\x0078' },
  { U'\x1d63a', U'\x0079' },
  { U'\x1d63b', U'\x007a' },
  { U'\x1d63c', U'\x0061' },
  { U'\x1d63d', U'\x0062' },
  { U'\x1d63e', U'\x0063' },
  { U'\x1d63f', U'\x0064' },
  { U'\x1d640', U'\x0065' },
  { U'\x1d641', U'\x0066' },
  { U'\x1d642', U'\x0067' },
  { U'\x1d643', U'\x0068' },
  { U'\x1d644', U'\x0069' },
  { U'\x1d645', U'\x006a' },
  { U'\x1d646', U'\x006b' },
  { U'\x1d647', U'\x006c' },
  { U'\x1d648', U'\x006d' },
  { U'\x1d649', U'\x006e' },
  { U'\x1d64a', U'\x006f' },
  { U'\x1d64b', U'\x0070' },
  { U'\x1d64c', U'\x0071' },
  { U'\x1d64d', U'\x0072' },
  { U'\x1d64e', U'\x0073' },
  { U'\x1d64f', U'\x0074' },
  { U'\x1d650', U'\x0075' },
  { U'\x1d651', U'\x0076' },
  { U'\x1d652', U'\x0077' },
  { U'\x1d653', U'\x0078' },
  { U'\x1d654', U'\x0079' },
  { U'\x1d655', U'\x007a' },
  { U'\x1d656', U'\x0061' },
  { U'\x1d657', U'\x0062' },
  { U'\x1d658', U'\x0063' },
  { U'\x1d659', U'\x0064' },
  { U'\x1d65a', U'\x0065' },
  { U'\x1d65b', U'\x0066' },
  { U'\x1d65c', U'\x0067' },
  { U'\x1d65d', U'\x0068' },
  { U'\x1d65e', U'\x0069' },
  { U'\x1d65f', U'\x006a' },
  { U'\x1d660', U'\x006b' },
  { U'\x1d661', U'\x006c' },
  { U'\x1d662', U'\x006d' },
  { U'\x1d663', U'\x006e' },
  { U'\x1d664', U'\x006f' },
  { U'\x1d665', U'\x0070' },
  { U'\x1d666', U'\x0071' },
  { U'\x1d667', U'\x0072' },
  { U'\x1d668', U'\x0073' },
  { U'\x1d669', U'\x0074' },
  { U'\x1d66a', U'\x0075' },
  { U'\x1d66b', U'\x0076' },
  { U'\x1d66c', U'\x0077' },
  { U'\x1d66d', U'\x0078' },
  { U'\x1d66e', U'\x0079' },
  { U'\x1d66f', U'\x007a' },
  { U'\x1d670', U'\x0061' },
  { U'\x1d671', U'\x0062' },
  { U'\x1d672', U'\x0063' },
  { U'\x1d673', U'\x0064' },
  { U'\x1d674', U'\x0065' },
  { U'\x1d675', U'\x0066' },
  { U'\x1d676', U'\x0067' },
  { U'\x1d677', U'\x0068' },
  { U'\x1d678', U'\x0069' },
  { U'\x1d679', U'\x006a' },
  { U'\x1d67a', U'\x006b' },
  { U'\x1d67b', U'\x006c' },
  { U'\x1d67c', U'\x006d' },
  { U'\x1d67d', U'\x006e' },
  { U'\x1d67e', U'\x006f' },
  { U'\x1d67f', U'\x0070' },
  { U'\x1d680', U'\x0071' },
  { U'\x1d681', U'\x0072' },
  { U'\x1d682', U'\x0073' },
  { U'\x1d683', U'\x0074' },
  { U'\x1d684', U'\x0075' },
  { U'\x1d685', U'\x0076' },
  { U'\x1d686', U'\x0077' },
  { U'\x1d687', U'\x0078' },
  { U'\x1d688', U'\x0079' },
  { U'\x1d689', U'\x007a' },
  { U'\x1d68a', U'\x0061' },
  { U'\x1d68b', U'\x0062' },
  { U'\x1d68c', U'\x0063' },
  { U'\x1d68d', U'\x0064' },
  { U'\x1d68e', U'\x0065' },
  { U'\x1d68f', U'\x0066' },
  { U'\x1d690', U'\x0067' },
  { U'\x1d691', U'\x0068' },
  { U'\x1d692', U'\x0069' },
  { U'\x1d693', U'\x006a' },
  { U'\x1d694', U'\x006b' },
  { U'\x1d695', U'\x006c' },
  { U'\x1d696', U'\x006d' },
  { U'\x1d697', U'\x006e' },
  { U'\x1d698', U'\x006f' },
  { U'\x1d699', U'\x0070' },
  { U'\x1d69a', U'\x0071' },
  { U'\x1d69b', U'\x0072' },
  { U'\x1d69c', U'\x0073' },
  { U'\x1d69d', U'\x0074' },
  { U'\x1d69e', U'\x0075' },
  { U'\x1d69f', U'\x0076' },
  { U'\x1d6a0', U'\x0077' },
  { U'\x1d6a1', U'\x0078' },
  { U'\x1d6a2', U'\x0079' },
  { U'\x1d6a3', U'\x007a' },
  { U'\x1d6a4', U'\x0131' },
  { U'\x1d6a5', U'\x0237' },
  { U'\x1d6a8', U'\x03b1' },
  { U'\x1d6a9', U'\x03b2' },
  { U'\x1d6aa', U'\x03b3' },
  { U'\x1d6ab', U'\x03b4' },
  { U'\x1d6ac', U'\x03b5' },
  { U'\x1d6ad', U'\x03b6' },
  { U'\x1d6ae', U'\x03b7' },
  { U'\x1d6af', U'\x03b8' },
  { U'\x1d6b0', U'\x03b9' },
  { U'\x1d6b1', U'\x03ba' },
  { U'\x1d6b2', U'\x03bb' },
  { U'\x1d6b3', U'\x03bc' },
  { U'\x1d6b4', U'\x03bd' },
  { U'\x1d6b5', U'\x03be' },
  { U'\x1d6b6', U'\x03bf' },
  { U'\x1d6b7', U'\x03c0' },
  { U'\x1d6b8', U'\x03c1' },
  { U'\x1d6b9', U'\x03b8' },
  { U'\x1d6ba', U'\x03c3' },
  { U'\x1d6bb', U'\x03c4' },
  { U'\x1d6bc', U'\x03c5' },
  { U'\x1d6bd', U'\x03c6' },
  { U'\x1d6be', U'\x03c7' },
  { U'\x1d6bf', U'\x03c8' },
  { U'\x1d6c0', U'\x03c9' },
  { U'\x1d6c1', U'\x2207' },
  { U'\x1d6c2', U'\x03b1' },
  { U'\x1d6c3', U'\x03b2' },
  { U'\x1d6c4', U'\x03b3' },
  { U'\x1d6c5', U'\x03b4' },
  { U'\x1d6c6', U'\x03b5' },
  { U'\x1d6c7', U'\x03b6' },
  { U'\x1d6c8', U'\x03b7' },
  { U'\x1d6c9', U'\x03b8' },
  { U'\x1d6ca', U'\x03b9' },
  { U'\x1d6cb', U'\x03ba' },
  { U'\x1d6cc', U'\x03bb' },
  { U'\x1d6cd', U'\x03bc' },
  { U'\x1d6ce', U'\x03bd' },
  { U'\x1d6cf', U'\x03be' },
  { U'\x1d6d0', U'\x03bf' },
  { U'\x1d6d1', U'\x03c0' },
  { U'\x1d6d2', U'\x03c1' },
  { U'\x1d6d3', U'\x03c3' },
  { U'\x1d6d5', U'\x03c4' },
  { U'\x1d6d6', U'\x03c5' },
  { U'\x1d6d7', U'\x03c6' },
  { U'\x1d6d8', U'\x03c7' },
  { U'\x1d6d9', U'\x03c8' },
  { U'\x1d6da', U'\x03c9' },
  { U'\x1d6db', U'\x2202' },
  { U'\x1d6dc', U'\x03b5' },
  { U'\x1d6dd', U'\x03b8' },
  { U'\x1d6de', U'\x03ba' },
  { U'\x1d6df', U'\x03c6' },
  { U'\x1d6e0', U'\x03c1' },
  { U'\x1d6e1', U'\x03c0' },
  { U'\x1d6e2', U'\x03b1' },
  { U'\x1d6e3', U'\x03b2' },
  { U'\x1d6e4', U'\x03b3' },
  { U'\x1d6e5', U'\x03b4' },
  { U'\x1d6e6', U'\x03b5' },
  { U'\x1d6e7', U'\x03b6' },
  { U'\x1d6e8', U'\x03b7' },
  { U'\x1d6e9', U'\x03b8' },
  { U'\x1d6ea', U'\x03b9' },
  { U'\x1d6eb', U'\x03ba' },
  { U'\x1d6ec', U'\x03bb' },
  { U'\x1d6ed', U'\x03bc' },
  { U'\x1d6ee', U'\x03bd' },
  { U'\x1d6ef', U'\x03be' },
  { U'\x1d6f0', U'\x03bf' },
  { U'\x1d6f1', U'\x03c0' },
  { U'\x1d6f2', U'\x03c1' },
  { U'\x1d6f3', U'\x03b8' },
  { U'\x1d6f4', U'\x03c3' },
  { U'\x1d6f5', U'\x03c4' },
  { U'\x1d6f6', U'\x03c5' },
  { U'\x1d6f7', U'\x03c6' },
  { U'\x1d6f8', U'\x03c7' },
  { U'\x1d6f9', U'\x03c8' },
  { U'\x1d6fa', U'\x03c9' },
  { U'\x1d6fb', U'\x2207' },
  { U'\x1d6fc', U'\x03b1' },
  { U'\x1d6fd', U'\x03b2' },
  { U'\x1d6fe', U'\x03b3' },
  { U'\x1d6ff', U'\x03b4' },
  { U'\x1d700', U'\x03b5' },
  { U'\x1d701', U'\x03b6' },
  { U'\x1d702', U'\x03b7' },
  { U'\x1d703', U'\x03b8' },
  { U'\x1d704', U'\x03b9' },
  { U'\x1d705', U'\x03ba' },
  { U'\x1d706', U'\x03bb' },
  { U'\x1d707', U'\x03bc' },
  { U'\x1d708', U'\x03bd' },
  { U'\x1d709', U'\x03be' },
  { U'\x1d70a', U'\x03bf' },
  { U'\x1d70b', U'\x03c0' },
  { U'\x1d70c', U'\x03c1' },
  { U'\x1d70d', U'\x03c3' },
  { U'\x1d70f', U'\x03c4' },
  { U'\x1d710', U'\x03c5' },
  { U'\x1d711', U'\x03c6' },
  { U'\x1d712', U'\x03c7' },
  { U'\x1d713', U'\x03c8' },
  { U'\x1d714', U'\x03c9' },
  { U'\x1d715', U'\x2202' },
  { U'\x1d716', U'\x03b5' },
  { U'\x1d717', U'\x03b8' },
  { U'\x1d718', U'\x03ba' },
  { U'\x1d719', U'\x03c6' },
  { U'\x1d71a', U'\x03c1' },
  { U'\x1d71b', U'\x03c0' },
  { U'\x1d71c', U'\x03b1' },
  { U'\x1d71d', U'\x03b2' },
  { U'\x1d71e', U'\x03b3' },
  { U'\x1d71f', U'\x03b4' },
  { U'\x1d720', U'\x03b5' },
  { U'\x1d721', U'\x03b6' },
  { U'\x1d722', U'\x03b7' },
  { U'\x1d723', U'\x03b8' },
  { U'\x1d724', U'\x03b9' },
  { U'\x1d725', U'\x03ba' },
  { U'\x1d726', U'\x03bb' },
  { U'\x1d727', U'\x03bc' },
  { U'\x1d728', U'\x03bd' },
  { U'\x1d729', U'\x03be' },
  { U'\x1d72a', U'\x03bf' },
  { U'\x1d72b', U'\x03c0' },
  { U'\x1d72c', U'\x03c1' },
  { U'\x1d72d', U'\x03b8' },
  { U'\x1d72e', U'\x03c3' },
  { U'\x1d72f', U'\x03c4' },
  { U'\x1d730', U'\x03c5' },
  { U'\x1d731', U'\x03c6' },
  { U'\x1d732', U'\x03c7' },
  { U'\x1d733', U'\x03c8' },
  { U'\x1d734', U'\x03c9' },
  { U'\x1d735', U'\x2207' },
  { U'\x1d736', U'\x03b1' },
  { U'\x1d737', U'\x03b2' },
  { U'\x1d738', U'\x03b3' },
  { U'\x1d739', U'\x03b4' },
  { U'\x1d73a', U'\x03b5' },
  { U'\x1d73b', U'\x03b6' },
  { U'\x1d73c', U'\x03b7' },
  { U'\x1d73d', U'\x03b8' },
  { U'\x1d73e', U'\x03b9' },
  { U'\x1d73f', U'\x03ba' },
  { U'\x1d740', U'\x03bb' },
  { U'\x1d741', U'\x03bc' },
  { U'\x1d742', U'\x03bd' },
  { U'\x1d743', U'\x03be' },
  { U'\x1d744', U'\x03bf' },
  { U'\x1d745', U'\x03c0' },
  { U'\x1d746', U'\x03c1' },
  { U'\x1d747', U'\x03c3' },
  { U'\x1d749', U'\x03c4' },
  { U'\x1d74a', U'\x03c5' },
  { U'\x1d74b', U'\x03c6' },
  { U'\x1d74c', U'\x03c7' },
  { U'\x1d74d', U'\x03c8' },
  { U'\x1d74e', U'\x03c9' },
  { U'\x1d74f', U'\x2202' },
  { U'\x1d750', U'\x03b5' },
  { U'\x1d751', U'\x03b8' },
  { U'\x1d752', U'\x03ba' },
  { U'\x1d753', U'\x03c6' },
  { U'\x1d754', U'\x03c1' },
  { U'\x1d755', U'\x03c0' },
  { U'\x1d756', U'\x03b1' },
  { U'\x1d757', U'\x03b2' },
  { U'\x1d758', U'\x03b3' },
  { U'\x1d759', U'\x03b4' },
  { U'\x1d75a', U'\x03b5' },
  { U'\x1d75b', U'\x03b6' },
  { U'\x1d75c', U'\x03b7' },
  { U'\x1d75d', U'\x03b8' },
  { U'\x1d75e', U'\x03b9' },
  { U'\x1d75f', U'\x03ba' },
  { U'\x1d760', U'\x03bb' },
  { U'\x1d761', U'\x03bc' },
  { U'\x1d762', U'\x03bd' },
  { U'\x1d763', U'\x03be' },
  { U'\x1d764', U'\x03bf' },
  { U'\x1d765', U'\x03c0' },
  { U'\x1d766', U'\x03c1' },
  { U'\x1d767', U'\x03b8' },
  { U'\x1d768', U'\x03c3' },
  { U'\x1d769', U'\x03c4' },
  { U'\x1d76a', U'\x03c5' },
  { U'\x1d76b', U'\x03c6' },
  { U'\x1d76c', U'\x03c7' },
  { U'\x1d76d', U'\x03c8' },
  { U'\x1d76e', U'\x03c9' },
  { U'\x1d76f', U'\x2207' },
  { U'\x1d770', U'\x03b1' },
  { U'\x1d771', U'\x03b2' },
  { U'\x1d772', U'\x03b3' },
  { U'\x1d773', U'\x03b4' },
  { U'\x1d774', U'\x03b5' },
  { U'\x1d775', U'\x03b6' },
  { U'\x1d776', U'\x03b7' },
  { U'\x1d777', U'\x03b8' },
  { U'\x1d778', U'\x03b9' },
  { U'\x1d779', U'\x03ba' },
  { U'\x1d77a', U'\x03bb' },
  { U'\x1d77b', U'\x03bc' },
  { U'\x1d77c', U'\x03bd' },
  { U'\x1d77d', U'\x03be' },
  { U'\x1d77e', U'\x03bf' },
  { U'\x1d77f', U'\x03c0' },
  { U'\x1d780', U'\x03c1' },
  { U'\x1d781', U'\x03c3' },
  { U'\x1d783', U'\x03c4' },
  { U'\x1d784', U'\x03c5' },
  { U'\x1d785', U'\x03c6' },
  { U'\x1d786', U'\x03c7' },
  { U'\x1d787', U'\x03c8' },
  { U'\x1d788', U'\x03c9' },
  { U'\x1d789', U'\x2202' },
  { U'\x1d78a', U'\x03b5' },
  { U'\x1d78b', U'\x03b8' },
  { U'\x1d78c', U'\x03ba' },
  { U'\x1d78d', U'\x03c6' },
  { U'\x1d78e', U'\x03c1' },
  { U'\x1d78f', U'\x03c0' },
  { U'\x1d790', U'\x03b1' },
  { U'\x1d791', U'\x03b2' },
  { U'\x1d792', U'\x03b3' },
  { U'\x1d793', U'\x03b4' },
  { U'\x1d794', U'\x03b5' },
  { U'\x1d795', U'\x03b6' },
  { U'\x1d796', U'\x03b7' },
  { U'\x1d797', U'\x03b8' },
  { U'\x1d798', U'\x03b9' },
  { U'\x1d799', U'\x03ba' },
  { U'\x1d79a', U'\x03bb' },
  { U'\x1d79b', U'\x03bc' },
  { U'\x1d79c', U'\x03bd' },
  { U'\x1d79d', U'\x03be' },
  { U'\x1d79e', U'\x03bf' },
  { U'\x1d79f', U'\x03c0' },
  { U'\x1d7a0', U'\x03c1' },
  { U'\x1d7a1', U'\x03b8' },
  { U'\x1d7a2', U'\x03c3' },
  { U'\x1d7a3', U'\x03c4' },
  { U'\x1d7a4', U'\x03c5' },
  { U'\x1d7a5', U'\x03c6' },
  { U'\x1d7a6', U'\x03c7' },
  { U'\x1d7a7', U'\x03c8' },
  { U'\x1d7a8', U'\x03c9' },
  { U'\x1d7a9', U'\x2207' },
  { U'\x1d7aa', U'\x03b1' },
  { U'\x1d7ab', U'\x03b2' },
  { U'\x1d7ac', U'\x03b3' },
  { U'\x1d7ad', U'\x03b4' },
  { U'\x1d7ae', U'\x03b5' },
  { U'\x1d7af', U'\x03b6' },
  { U'\x1d7b0', U'\x03b7' },
  { U'\x1d7b1', U'\x03b8' },
  { U'\x1d7b2', U'\x03b9' },
  { U'\x1d7b3', U'\x03ba' },
  { U'\x1d7b4', U'\x03bb' },
  { U'\x1d7b5', U'\x03bc' },
  { U'\x1d7b6', U'\x03bd' },
  { U'\x1d7b7', U'\x03be' },
  { U'\x1d7b8', U'\x03bf' },
  { U'\x1d7b9', U'\x03c0' },
  { U'\x1d7ba', U'\x03c1' },
  { U'\x1d7bb', U'\x03c3' },
  { U'\x1d7bd', U'\x03c4' },
  { U'\x1d7be', U'\x03c5' },
  { U'\x1d7bf', U'\x03c6' },
  { U'\x1d7c0', U'\x03c7' },
  { U'\x1d7c1', U'\x03c8' },
  { U'\x1d7c2', U'\x03c9' },
  { U'\x1d7c3', U'\x2202' },
  { U'\x1d7c4', U'\x03b5' },
  { U'\x1d7c5', U'\x03b8' },
  { U'\x1d7c6', U'\x03ba' },
  { U'\x1d7c7', U'\x03c6' },
  { U'\x1d7c8', U'\x03c1' },
  { U'\x1d7c9', U'\x03c0' },
  { U'\x1d7ca', U'\x03dd' },
  { U'\x1d7ce', U'\x0030' },
  { U'\x1d7cf', U'\x0031' },
  { U'\x1d7d0', U'\x0032' },
  { U'\x1d7d1', U'\x0033' },
  { U'\x1d7d2', U'\x0034' },
  { U'\x1d7d3', U'\x0035' },
  { U'\x1d7d4', U'\x0036' },
  { U'\x1d7d5', U'\x0037' },
  { U'\x1d7d6', U'\x0038' },
  { U'\x1d7d7', U'\x0039' },
  { U'\x1d7d8', U'\x0030' },
  { U'\x1d7d9', U'\x0031' },
  { U'\x1d7da', U'\x0032' },
  { U'\x1d7db', U'\x0033' },
  { U'\x1d7dc', U'\x0034' },
  { U'\x1d7dd', U'\x0035' },
  { U'\x1d7de', U'\x0036' },
  { U'\x1d7df', U'\x0037' },
  { U'\x1d7e0', U'\x0038' },
  { U'\x1d7e1', U'\x0039' },
  { U'\x1d7e2', U'\x0030' },
  { U'\x1d7e3', U'\x0031' },
  { U'\x1d7e4', U'\x0032' },
  { U'\x1d7e5', U'\x0033' },
  { U'\x1d7e6', U'\x0034' },
  { U'\x1d7e7', U'\x0035' },
  { U'\x1d7e8', U'\x0036' },
  { U'\x1d7e9', U'\x0037' },
  { U'\x1d7ea', U'\x0038' },
  { U'\x1d7eb', U'\x0039' },
  { U'\x1d7ec', U'\x0030' },
  { U'\x1d7ed', U'\x0031' },
  { U'\x1d7ee', U'\x0032' },
  { U'\x1d7ef', U'\x0033' },
  { U'\x1d7f0', U'\x0034' },
  { U'\x1d7f1', U'\x0035' },
  { U'\x1d7f2', U'\x0036' },
  { U'\x1d7f3', U'\x0037' },
  { U'\x1d7f4', U'\x0038' },
  { U'\x1d7f5', U'\x0039' },
  { U'\x1d7f6', U'\x0030' },
  { U'\x1d7f7', U'\x0031' },
  { U'\x1d7f8', U'\x0032' },
  { U'\x1d7f9', U'\x0033' },
  { U'\x1d7fa', U'\x0034' },
  { U'\x1d7fb', U'\x0035' },
  { U'\x1d7fc', U'\x0036' },
  { U'\x1d7fd', U'\x0037' },
  { U'\x1d7fe', U'\x0038' },
  { U'\x1d7ff', U'\x0039' },
  { U'\x1e900', U'\x1e922' },
  { U'\x1e901', U'\x1e923' },
  { U'\x1e902', U'\x1e924' },
  { U'\x1e903', U'\x1e925' },
  { U'\x1e904', U'\x1e926' },
  { U'\x1e905', U'\x1e927' },
  { U'\x1e906', U'\x1e928' },
  { U'\x1e907', U'\x1e929' },
  { U'\x1e908', U'\x1e92a' },
  { U'\x1e909', U'\x1e92b' },
  { U'\x1e90a', U'\x1e92c' },
  { U'\x1e90b', U'\x1e92d' },
  { U'\x1e90c', U'\x1e92e' },
  { U'\x1e90d', U'\x1e92f' },
  { U'\x1e90e', U'\x1e930' },
  { U'\x1e90f', U'\x1e931' },
  { U'\x1e910', U'\x1e932' },
  { U'\x1e911', U'\x1e933' },
  { U'\x1e912', U'\x1e934' },
  { U'\x1e913', U'\x1e935' },
  { U'\x1e914', U'\x1e936' },
  { U'\x1e915', U'\x1e937' },
  { U'\x1e916', U'\x1e938' },
  { U'\x1e917', U'\x1e939' },
  { U'\x1e918', U'\x1e93a' },
  { U'\x1e919', U'\x1e93b' },
  { U'\x1e91a', U'\x1e93c' },
  { U'\x1e91b', U'\x1e93d' },
  { U'\x1e91c', U'\x1e93e' },
  { U'\x1e91d', U'\x1e93f' },
  { U'\x1e91e', U'\x1e940' },
  { U'\x1e91f', U'\x1e941' },
  { U'\x1e920', U'\x1e942' },
  { U'\x1e921', U'\x1e943' },
  { U'\x1ee00', U'\x0627' },
  { U'\x1ee01', U'\x0628' },
  { U'\x1ee02', U'\x062c' },
  { U'\x1ee03', U'\x062f' },
  { U'\x1ee05', U'\x0648' },
  { U'\x1ee06', U'\x0632' },
  { U'\x1ee07', U'\x062d' },
  { U'\x1ee08', U'\x0637' },
  { U'\x1ee09', U'\x064a' },
  { U'\x1ee0a', U'\x0643' },
  { U'\x1ee0b', U'\x0644' },
  { U'\x1ee0c', U'\x0645' },
  { U'\x1ee0d', U'\x0646' },
  { U'\x1ee0e', U'\x0633' },
  { U'\x1ee0f', U'\x0639' },
  { U'\x1ee10', U'\x0641' },
  { U'\x1ee11', U'\x0635' },
  { U'\x1ee12', U'\x0642' },
  { U'\x1ee13', U'\x0631' },
  { U'\x1ee14', U'\x0634' },
  { U'\x1ee15', U'\x062a' },
  { U'\x1ee16', U'\x062b' },
  { U'\x1ee17', U'\x062e' },
  { U'\x1ee18', U'\x0630' },
  { U'\x1ee19', U'\x0636' },
  { U'\x1ee1a', U'\x0638' },
  { U'\x1ee1b', U'\x063a' },
  { U'\x1ee1c', U'\x066e' },
  { U'\x1ee1d', U'\x06ba' },
  { U'\x1ee1e', U'\x06a1' },
  { U'\x1ee1f', U'\x066f' },
  { U'\x1ee21', U'\x0628' },
  { U'\x1ee22', U'\x062c' },
  { U'\x1ee24', U'\x0647' },
  { U'\x1ee27', U'\x062d' },
  { U'\x1ee29', U'\x064a' },
  { U'\x1ee2a', U'\x0643' },
  { U'\x1ee2b', U'\x0644' },
  { U'\x1ee2c', U'\x0645' },
  { U'\x1ee2d', U'\x0646' },
  { U'\x1ee2e', U'\x0633' },
  { U'\x1ee2f', U'\x0639' },
  { U'\x1ee30', U'\x0641' },
  { U'\x1ee31', U'\x0635' },
  { U'\x1ee32', U'\x0642' },
  { U'\x1ee34', U'\x0634' },
  { U'\x1ee35', U'\x062a' },
  { U'\x1ee36', U'\x062b' },
  { U'\x1ee37', U'\x062e' },
  { U'\x1ee39', U'\x0636' },
  { U'\x1ee3b', U'\x063a' },
  { U'\x1ee42', U'\x062c' },
  { U'\x1ee47', U'\x062d' },
  { U'\x1ee49', U'\x064a' },
  { U'\x1ee4b', U'\x0644' },
  { U'\x1ee4d', U'\x0646' },
  { U'\x1ee4e', U'\x0633' },
  { U'\x1ee4f', U'\x0639' },
  { U'\x1ee51', U'\x0635' },
  { U'\x1ee52', U'\x0642' },
  { U'\x1ee54', U'\x0634' },
  { U'\x1ee57', U'\x062e' },
  { U'\x1ee59', U'\x0636' },
  { U'\x1ee5b', U'\x063a' },
  { U'\x1ee5d', U'\x06ba' },
  { U'\x1ee5f', U'\x066f' },
  { U'\x1ee61', U'\x0628' },
  { U'\x1ee62', U'\x062c' },
  { U'\x1ee64', U'\x0647' },
  { U'\x1ee67', U'\x062d' },
  { U'\x1ee68', U'\x0637' },
  { U'\x1ee69', U'\x064a' },
  { U'\x1ee6a', U'\x0643' },
  { U'\x1ee6c', U'\x0645' },
  { U'\x1ee6d', U'\x0646' },
  { U'\x1ee6e', U'\x0633' },
  { U'\x1ee6f', U'\x0639' },
  { U'\x1ee70', U'\x0641' },
  { U'\x1ee71', U'\x0635' },
  { U'\x1ee72', U'\x0642' },
  { U'\x1ee74', U'\x0634' },
  { U'\x1ee75', U'\x062a' },
  { U'\x1ee76', U'\x062b' },
  { U'\x1ee77', U'\x062e' },
  { U'\x1ee79', U'\x0636' },
  { U'\x1ee7a', U'\x0638' },
  { U'\x1ee7b', U'\x063a' },
  { U'\x1ee7c', U'\x066e' },
  { U'\x1ee7e', U'\x06a1' },
  { U'\x1ee80', U'\x0627' },
  { U'\x1ee81', U'\x0628' },
  { U'\x1ee82', U'\x062c' },
  { U'\x1ee83', U'\x062f' },
  { U'\x1ee84', U'\x0647' },
  { U'\x1ee85', U'\x0648' },
  { U'\x1ee86', U'\x0632' },
  { U'\x1ee87', U'\x062d' },
  { U'\x1ee88', U'\x0637' },
  { U'\x1ee89', U'\x064a' },
  { U'\x1ee8b', U'\x0644' },
  { U'\x1ee8c', U'\x0645' },
  { U'\x1ee8d', U'\x0646' },
  { U'\x1ee8e', U'\x0633' },
  { U'\x1ee8f', U'\x0639' },
  { U'\x1ee90', U'\x0641' },
  { U'\x1ee91', U'\x0635' },
  { U'\x1ee92', U'\x0642' },
  { U'\x1ee93', U'\x0631' },
  { U'\x1ee94', U'\x0634' },
  { U'\x1ee95', U'\x062a' },
  { U'\x1ee96', U'\x062b' },
  { U'\x1ee97', U'\x062e' },
  { U'\x1ee98', U'\x0630' },
  { U'\x1ee99', U'\x0636' },
  { U'\x1ee9a', U'\x0638' },
  { U'\x1ee9b', U'\x063a' },
  { U'\x1eea1', U'\x0628' },
  { U'\x1eea2', U'\x062c' },
  { U'\x1eea3', U'\x062f' },
  { U'\x1eea5', U'\x0648' },
  { U'\x1eea6', U'\x0632' },
  { U'\x1eea7', U'\x062d' },
  { U'\x1eea8', U'\x0637' },
  { U'\x1eea9', U'\x064a' },
  { U'\x1eeab', U'\x0644' },
  { U'\x1eeac', U'\x0645' },
  { U'\x1eead', U'\x0646' },
  { U'\x1eeae', U'\x0633' },
  { U'\x1eeaf', U'\x0639' },
  { U'\x1eeb0', U'\x0641' },
  { U'\x1eeb1', U'\x0635' },
  { U'\x1eeb2', U'\x0642' },
  { U'\x1eeb3', U'\x0631' },
  { U'\x1eeb4', U'\x0634' },
  { U'\x1eeb5', U'\x062a' },
  { U'\x1eeb6', U'\x062b' },
  { U'\x1eeb7', U'\x062e' },
  { U'\x1eeb8', U'\x0630' },
  { U'\x1eeb9', U'\x0636' },
  { U'\x1eeba', U'\x0638' },
  { U'\x1eebb', U'\x063a' },
  { U'\x1f101', U'\x0030' },
  { U'\x1f102', U'\x0031' },
  { U'\x1f103', U'\x0032' },
  { U'\x1f104', U'\x0033' },
  { U'\x1f105', U'\x0034' },
  { U'\x1f106', U'\x0035' },
  { U'\x1f107', U'\x0036' },
  { U'\x1f108', U'\x0037' },
  { U'\x1f109', U'\x0038' },
  { U'\x1f10a', U'\x0039' },
  { U'\x1f110', U'\x0028' },
  { U'\x1f111', U'\x0028' },
  { U'\x1f112', U'\x0028' },
  { U'\x1f113', U'\x0028' },
  { U'\x1f114', U'\x0028' },
  { U'\x1f115', U'\x0028' },
  { U'\x1f116', U'\x0028' },
  { U'\x1f117', U'\x0028' },
  { U'\x1f118', U'\x0028' },
  { U'\x1f119', U'\x0028' },
  { U'\x1f11a', U'\x0028' },
  { U'\x1f11b', U'\x0028' },
  { U'\x1f11c', U'\x0028' },
  { U'\x1f11d', U'\x0028' },
  { U'\x1f11e', U'\x0028' },
  { U'\x1f11f', U'\x0028' },
  { U'\x1f120', U'\x0028' },
  { U'\x1f121', U'\x0028' },
  { U'\x1f122', U'\x0028' },
  { U'\x1f123', U'\x0028' },
  { U'\x1f124', U'\x0028' },
  { U'\x1f125', U'\x0028' },
  { U'\x1f126', U'\x0028' },
  { U'\x1f127', U'\x0028' },
  { U'\x1f128', U'\x0028' },
  { U'\x1f129', U'\x0028' },
  { U'\x1f12a', U'\x3014' },
  { U'\x1f12b', U'\x0063' },
  { U'\x1f12c', U'\x0072' },
  { U'\x1f12d', U'\x0063' },
  { U'\x1f12e', U'\x0077' },
  { U'\x1f130', U'\x0061' },
  { U'\x1f131', U'\x0062' },
  { U'\x1f132', U'\x0063' },
  { U'\x1f133', U'\x0064' },
  { U'\x1f134', U'\x0065' },
  { U'\x1f135', U'\x0066' },
  { U'\x1f136', U'\x0067' },
  { U'\x1f137', U'\x0068' },
  { U'\x1f138', U'\x0069' },
  { U'\x1f139', U'\x006a' },
  { U'\x1f13a', U'\x006b' },
  { U'\x1f13b', U'\x006c' },
  { U'\x1f13c', U'\x006d' },
  { U'\x1f13d', U'\x006e' },
  { U'\x1f13e', U'\x006f' },
  { U'\x1f13f', U'\x0070' },
  { U'\x1f140', U'\x0071' },
  { U'\x1f141', U'\x0072' },
  { U'\x1f142', U'\x0073' },
  { U'\x1f143', U'\x0074' },
  { U'\x1f144', U'\x0075' },
  { U'\x1f145', U'\x0076' },
  { U'\x1f146', U'\x0077' },
  { U'\x1f147', U'\x0078' },
  { U'\x1f148', U'\x0079' },
  { U'\x1f149', U'\x007a' },
  { U'\x1f14a', U'\x0068' },
  { U'\x1f14b', U'\x006d' },
  { U'\x1f14c', U'\x0073' },
  { U'\x1f14d', U'\x0073' },
  { U'\x1f14e', U'\x0070' },
  { U'\x1f14f', U'\x0077' },
  { U'\x1f16a', U'\x006d' },
  { U'\x1f16b', U'\x006d' },
  { U'\x1f16c', U'\x006d' },
  { U'\x1f190', U'\x0064' },
  { U'\x1f200', U'\x307b' },
  { U'\x1f201', U'\x30b3' },
  { U'\x1f202', U'\x30b5' },
  { U'\x1f210', U'\x624b' },
  { U'\x1f211', U'\x5b57' },
  { U'\x1f212', U'\x53cc' },
  { U'\x1f213', U'\x30c7' },
  { U'\x1f214', U'\x4e8c' },
  { U'\x1f215', U'\x591a' },
  { U'\x1f216', U'\x89e3' },
  { U'\x1f217', U'\x5929' },
  { U'\x1f218', U'\x4ea4' },
  { U'\x1f219', U'\x6620' },
  { U'\x1f21a', U'\x7121' },
  { U'\x1f21b', U'\x6599' },
  { U'\x1f21c', U'\x524d' },
  { U'\x1f21d', U'\x5f8c' },
  { U'\x1f21e', U'\x518d' },
  { U'\x1f21f', U'\x65b0' },
  { U'\x1f220', U'\x521d' },
  { U'\x1f221', U'\x7d42' },
  { U'\x1f222', U'\x751f' },
  { U'\x1f223', U'\x8ca9' },
  { U'\x1f224', U'\x58f0' },
  { U'\x1f225', U'\x5439' },
  { U'\x1f226', U'\x6f14' },
  { U'\x1f227', U'\x6295' },
  { U'\x1f228', U'\x6355' },
  { U'\x1f229', U'\x4e00' },
  { U'\x1f22a', U'\x4e09' },
  { U'\x1f22b', U'\x904a' },
  { U'\x1f22c', U'\x5de6' },
  { U'\x1f22d', U'\x4e2d' },
  { U'\x1f22e', U'\x53f3' },
  { U'\x1f22f', U'\x6307' },
  { U'\x1f230', U'\x8d70' },
  { U'\x1f231', U'\x6253' },
  { U'\x1f232', U'\x7981' },
  { U'\x1f233', U'\x7a7a' },
  { U'\x1f234', U'\x5408' },
  { U'\x1f235', U'\x6e80' },
  { U'\x1f236', U'\x6709' },
  { U'\x1f237', U'\x6708' },
  { U'\x1f238', U'\x7533' },
  { U'\x1f239', U'\x5272' },
  { U'\x1f23a', U'\x55b6' },
  { U'\x1f23b', U'\x914d' },
  { U'\x1f240', U'\x3014' },
  { U'\x1f241', U'\x3014' },
  { U'\x1f242', U'\x3014' },
  { U'\x1f243', U'\x3014' },
  { U'\x1f244', U'\x3014' },
  { U'\x1f245', U'\x3014' },
  { U'\x1f246', U'\x3014' },
  { U'\x1f247', U'\x3014' },
  { U'\x1f248', U'\x3014' },
  { U'\x1f250', U'\x5f97' },
  { U'\x1f251', U'\x53ef' },
  { U'\x2f800', U'\x4e3d' },
  { U'\x2f801', U'\x4e38' },
  { U'\x2f802', U'\x4e41' },
  { U'\x2f803', U'\x20122' },
  { U'\x2f804', U'\x4f60' },
  { U'\x2f805', U'\x4fae' },
  { U'\x2f806', U'\x4fbb' },
  { U'\x2f807', U'\x5002' },
  { U'\x2f808', U'\x507a' },
  { U'\x2f809', U'\x5099' },
  { U'\x2f80a', U'\x50e7' },
  { U'\x2f80b', U'\x50cf' },
  { U'\x2f80c', U'\x349e' },
  { U'\x2f80d', U'\x2063a' },
  { U'\x2f80e', U'\x514d' },
  { U'\x2f80f', U'\x5154' },
  { U'\x2f810', U'\x5164' },
  { U'\x2f811', U'\x5177' },
  { U'\x2f812', U'\x2051c' },
  { U'\x2f813', U'\x34b9' },
  { U'\x2f814', U'\x5167' },
  { U'\x2f815', U'\x518d' },
  { U'\x2f816', U'\x2054b' },
  { U'\x2f817', U'\x5197' },
  { U'\x2f818', U'\x51a4' },
  { U'\x2f819', U'\x4ecc' },
  { U'\x2f81a', U'\x51ac' },
  { U'\x2f81b', U'\x51b5' },
  { U'\x2f81c', U'\x291df' },
  { U'\x2f81d', U'\x51f5' },
  { U'\x2f81e', U'\x5203' },
  { U'\x2f81f', U'\x34df' },
  { U'\x2f820', U'\x523b' },
  { U'\x2f821', U'\x5246' },
  { U'\x2f822', U'\x5272' },
  { U'\x2f823', U'\x5277' },
  { U'\x2f824', U'\x3515' },
  { U'\x2f825', U'\x52c7' },
  { U'\x2f826', U'\x52c9' },
  { U'\x2f827', U'\x52e4' },
  { U'\x2f828', U'\x52fa' },
  { U'\x2f829', U'\x5305' },
  { U'\x2f82a', U'\x5306' },
  { U'\x2f82b', U'\x5317' },
  { U'\x2f82c', U'\x5349' },
  { U'\x2f82d', U'\x5351' },
  { U'\x2f82e', U'\x535a' },
  { U'\x2f82f', U'\x5373' },
  { U'\x2f830', U'\x537d' },
  { U'\x2f831', U'\x537f' },
  { U'\x2f834', U'\x20a2c' },
  { U'\x2f835', U'\x7070' },
  { U'\x2f836', U'\x53ca' },
  { U'\x2f837', U'\x53df' },
  { U'\x2f838', U'\x20b63' },
  { U'\x2f839', U'\x53eb' },
  { U'\x2f83a', U'\x53f1' },
  { U'\x2f83b', U'\x5406' },
  { U'\x2f83c', U'\x549e' },
  { U'\x2f83d', U'\x5438' },
  { U'\x2f83e', U'\x5448' },
  { U'\x2f83f', U'\x5468' },
  { U'\x2f840', U'\x54a2' },
  { U'\x2f841', U'\x54f6' },
  { U'\x2f842', U'\x5510' },
  { U'\x2f843', U'\x5553' },
  { U'\x2f844', U'\x5563' },
  { U'\x2f845', U'\x5584' },
  { U'\x2f847', U'\x5599' },
  { U'\x2f848', U'\x55ab' },
  { U'\x2f849', U'\x55b3' },
  { U'\x2f84a', U'\x55c2' },
  { U'\x2f84b', U'\x5716' },
  { U'\x2f84c', U'\x5606' },
  { U'\x2f84d', U'\x5717' },
  { U'\x2f84e', U'\x5651' },
  { U'\x2f84f', U'\x5674' },
  { U'\x2f850', U'\x5207' },
  { U'\x2f851', U'\x58ee' },
  { U'\x2f852', U'\x57ce' },
  { U'\x2f853', U'\x57f4' },
  { U'\x2f854', U'\x580d' },
  { U'\x2f855', U'\x578b' },
  { U'\x2f856', U'\x5832' },
  { U'\x2f857', U'\x5831' },
  { U'\x2f858', U'\x58ac' },
  { U'\x2f859', U'\x214e4' },
  { U'\x2f85a', U'\x58f2' },
  { U'\x2f85b', U'\x58f7' },
  { U'\x2f85c', U'\x5906' },
  { U'\x2f85d', U'\x591a' },
  { U'\x2f85e', U'\x5922' },
  { U'\x2f85f', U'\x5962' },
  { U'\x2f860', U'\x216a8' },
  { U'\x2f861', U'\x216ea' },
  { U'\x2f862', U'\x59ec' },
  { U'\x2f863', U'\x5a1b' },
  { U'\x2f864', U'\x5a27' },
  { U'\x2f865', U'\x59d8' },
  { U'\x2f866', U'\x5a66' },
  { U'\x2f867', U'\x36ee' },
  { U'\x2f869', U'\x5b08' },
  { U'\x2f86a', U'\x5b3e' },
  { U'\x2f86c', U'\x219c8' },
  { U'\x2f86d', U'\x5bc3' },
  { U'\x2f86e', U'\x5bd8' },
  { U'\x2f86f', U'\x5be7' },
  { U'\x2f870', U'\x5bf3' },
  { U'\x2f871', U'\x21b18' },
  { U'\x2f872', U'\x5bff' },
  { U'\x2f873', U'\x5c06' },
  { U'\x2f875', U'\x5c22' },
  { U'\x2f876', U'\x3781' },
  { U'\x2f877', U'\x5c60' },
  { U'\x2f878', U'\x5c6e' },
  { U'\x2f879', U'\x5cc0' },
  { U'\x2f87a', U'\x5c8d' },
  { U'\x2f87b', U'\x21de4' },
  { U'\x2f87c', U'\x5d43' },
  { U'\x2f87d', U'\x21de6' },
  { U'\x2f87e', U'\x5d6e' },
  { U'\x2f87f', U'\x5d6b' },
  { U'\x2f880', U'\x5d7c' },
  { U'\x2f881', U'\x5de1' },
  { U'\x2f882', U'\x5de2' },
  { U'\x2f883', U'\x382f' },
  { U'\x2f884', U'\x5dfd' },
  { U'\x2f885', U'\x5e28' },
  { U'\x2f886', U'\x5e3d' },
  { U'\x2f887', U'\x5e69' },
  { U'\x2f888', U'\x3862' },
  { U'\x2f889', U'\x22183' },
  { U'\x2f88a', U'\x387c' },
  { U'\x2f88b', U'\x5eb0' },
  { U'\x2f88c', U'\x5eb3' },
  { U'\x2f88d', U'\x5eb6' },
  { U'\x2f88e', U'\x5eca' },
  { U'\x2f88f', U'\x2a392' },
  { U'\x2f890', U'\x5efe' },
  { U'\x2f891', U'\x22331' },
  { U'\x2f893', U'\x8201' },
  { U'\x2f894', U'\x5f22' },
  { U'\x2f896', U'\x38c7' },
  { U'\x2f897', U'\x232b8' },
  { U'\x2f898', U'\x261da' },
  { U'\x2f899', U'\x5f62' },
  { U'\x2f89a', U'\x5f6b' },
  { U'\x2f89b', U'\x38e3' },
  { U'\x2f89c', U'\x5f9a' },
  { U'\x2f89d', U'\x5fcd' },
  { U'\x2f89e', U'\x5fd7' },
  { U'\x2f89f', U'\x5ff9' },
  { U'\x2f8a0', U'\x6081' },
  { U'\x2f8a1', U'\x393a' },
  { U'\x2f8a2', U'\x391c' },
  { U'\x2f8a3', U'\x6094' },
  { U'\x2f8a4', U'\x226d4' },
  { U'\x2f8a5', U'\x60c7' },
  { U'\x2f8a6', U'\x6148' },
  { U'\x2f8a7', U'\x614c' },
  { U'\x2f8a8', U'\x614e' },
  { U'\x2f8a9', U'\x614c' },
  { U'\x2f8aa', U'\x617a' },
  { U'\x2f8ab', U'\x618e' },
  { U'\x2f8ac', U'\x61b2' },
  { U'\x2f8ad', U'\x61a4' },
  { U'\x2f8ae', U'\x61af' },
  { U'\x2f8af', U'\x61de' },
  { U'\x2f8b0', U'\x61f2' },
  { U'\x2f8b1', U'\x61f6' },
  { U'\x2f8b2', U'\x6210' },
  { U'\x2f8b3', U'\x621b' },
  { U'\x2f8b4', U'\x625d' },
  { U'\x2f8b5', U'\x62b1' },
  { U'\x2f8b6', U'\x62d4' },
  { U'\x2f8b7', U'\x6350' },
  { U'\x2f8b8', U'\x22b0c' },
  { U'\x2f8b9', U'\x633d' },
  { U'\x2f8ba', U'\x62fc' },
  { U'\x2f8bb', U'\x6368' },
  { U'\x2f8bc', U'\x6383' },
  { U'\x2f8bd', U'\x63e4' },
  { U'\x2f8be', U'\x22bf1' },
  { U'\x2f8bf', U'\x6422' },
  { U'\x2f8c0', U'\x63c5' },
  { U'\x2f8c1', U'\x63a9' },
  { U'\x2f8c2', U'\x3a2e' },
  { U'\x2f8c3', U'\x6469' },
  { U'\x2f8c4', U'\x647e' },
  { U'\x2f8c5', U'\x649d' },
  { U'\x2f8c6', U'\x6477' },
  { U'\x2f8c7', U'\x3a6c' },
  { U'\x2f8c8', U'\x654f' },
  { U'\x2f8c9', U'\x656c' },
  { U'\x2f8ca', U'\x2300a' },
  { U'\x2f8cb', U'\x65e3' },
  { U'\x2f8cc', U'\x66f8' },
  { U'\x2f8cd', U'\x6649' },
  { U'\x2f8ce', U'\x3b19' },
  { U'\x2f8cf', U'\x6691' },
  { U'\x2f8d0', U'\x3b08' },
  { U'\x2f8d1', U'\x3ae4' },
  { U'\x2f8d2', U'\x5192' },
  { U'\x2f8d3', U'\x5195' },
  { U'\x2f8d4', U'\x6700' },
  { U'\x2f8d5', U'\x669c' },
  { U'\x2f8d6', U'\x80ad' },
  { U'\x2f8d7', U'\x43d9' },
  { U'\x2f8d8', U'\x6717' },
  { U'\x2f8d9', U'\x671b' },
  { U'\x2f8da', U'\x6721' },
  { U'\x2f8db', U'\x675e' },
  { U'\x2f8dc', U'\x6753' },
  { U'\x2f8dd', U'\x233c3' },
  { U'\x2f8de', U'\x3b49' },
  { U'\x2f8df', U'\x67fa' },
  { U'\x2f8e0', U'\x6785' },
  { U'\x2f8e1', U'\x6852' },
  { U'\x2f8e2', U'\x6885' },
  { U'\x2f8e3', U'\x2346d' },
  { U'\x2f8e4', U'\x688e' },
  { U'\x2f8e5', U'\x681f' },
  { U'\x2f8e6', U'\x6914' },
  { U'\x2f8e7', U'\x3b9d' },
  { U'\x2f8e8', U'\x6942' },
  { U'\x2f8e9', U'\x69a3' },
  { U'\x2f8ea', U'\x69ea' },
  { U'\x2f8eb', U'\x6aa8' },
  { U'\x2f8ec', U'\x236a3' },
  { U'\x2f8ed', U'\x6adb' },
  { U'\x2f8ee', U'\x3c18' },
  { U'\x2f8ef', U'\x6b21' },
  { U'\x2f8f0', U'\x238a7' },
  { U'\x2f8f1', U'\x6b54' },
  { U'\x2f8f2', U'\x3c4e' },
  { U'\x2f8f3', U'\x6b72' },
  { U'\x2f8f4', U'\x6b9f' },
  { U'\x2f8f5', U'\x6bba' },
  { U'\x2f8f6', U'\x6bbb' },
  { U'\x2f8f7', U'\x23a8d' },
  { U'\x2f8f8', U'\x21d0b' },
  { U'\x2f8f9', U'\x23afa' },
  { U'\x2f8fa', U'\x6c4e' },
  { U'\x2f8fb', U'\x23cbc' },
  { U'\x2f8fc', U'\x6cbf' },
  { U'\x2f8fd', U'\x6ccd' },
  { U'\x2f8fe', U'\x6c67' },
  { U'\x2f8ff', U'\x6d16' },
  { U'\x2f900', U'\x6d3e' },
  { U'\x2f901', U'\x6d77' },
  { U'\x2f902', U'\x6d41' },
  { U'\x2f903', U'\x6d69' },
  { U'\x2f904', U'\x6d78' },
  { U'\x2f905', U'\x6d85' },
  { U'\x2f906', U'\x23d1e' },
  { U'\x2f907', U'\x6d34' },
  { U'\x2f908', U'\x6e2f' },
  { U'\x2f909', U'\x6e6e' },
  { U'\x2f90a', U'\x3d33' },
  { U'\x2f90b', U'\x6ecb' },
  { U'\x2f90c', U'\x6ec7' },
  { U'\x2f90d', U'\x23ed1' },
  { U'\x2f90e', U'\x6df9' },
  { U'\x2f90f', U'\x6f6e' },
  { U'\x2f910', U'\x23f5e' },
  { U'\x2f911', U'\x23f8e' },
  { U'\x2f912', U'\x6fc6' },
  { U'\x2f913', U'\x7039' },
  { U'\x2f914', U'\x701e' },
  { U'\x2f915', U'\x701b' },
  { U'\x2f916', U'\x3d96' },
  { U'\x2f917', U'\x704a' },
  { U'\x2f918', U'\x707d' },
  { U'\x2f919', U'\x7077' },
  { U'\x2f91a', U'\x70ad' },
  { U'\x2f91b', U'\x20525' },
  { U'\x2f91c', U'\x7145' },
  { U'\x2f91d', U'\x24263' },
  { U'\x2f91e', U'\x719c' },
  { U'\x2f920', U'\x7228' },
  { U'\x2f921', U'\x7235' },
  { U'\x2f922', U'\x7250' },
  { U'\x2f923', U'\x24608' },
  { U'\x2f924', U'\x7280' },
  { U'\x2f925', U'\x7295' },
  { U'\x2f926', U'\x24735' },
  { U'\x2f927', U'\x24814' },
  { U'\x2f928', U'\x737a' },
  { U'\x2f929', U'\x738b' },
  { U'\x2f92a', U'\x3eac' },
  { U'\x2f92b', U'\x73a5' },
  { U'\x2f92c', U'\x3eb8' },
  { U'\x2f92e', U'\x7447' },
  { U'\x2f92f', U'\x745c' },
  { U'\x2f930', U'\x7471' },
  { U'\x2f931', U'\x7485' },
  { U'\x2f932', U'\x74ca' },
  { U'\x2f933', U'\x3f1b' },
  { U'\x2f934', U'\x7524' },
  { U'\x2f935', U'\x24c36' },
  { U'\x2f936', U'\x753e' },
  { U'\x2f937', U'\x24c92' },
  { U'\x2f938', U'\x7570' },
  { U'\x2f939', U'\x2219f' },
  { U'\x2f93a', U'\x7610' },
  { U'\x2f93b', U'\x24fa1' },
  { U'\x2f93c', U'\x24fb8' },
  { U'\x2f93d', U'\x25044' },
  { U'\x2f93e', U'\x3ffc' },
  { U'\x2f93f', U'\x4008' },
  { U'\x2f940', U'\x76f4' },
  { U'\x2f941', U'\x250f3' },
  { U'\x2f942', U'\x250f2' },
  { U'\x2f943', U'\x25119' },
  { U'\x2f944', U'\x25133' },
  { U'\x2f945', U'\x771e' },
  { U'\x2f946', U'\x771f' },
  { U'\x2f948', U'\x774a' },
  { U'\x2f949', U'\x4039' },
  { U'\x2f94a', U'\x778b' },
  { U'\x2f94b', U'\x4046' },
  { U'\x2f94c', U'\x4096' },
  { U'\x2f94d', U'\x2541d' },
  { U'\x2f94e', U'\x784e' },
  { U'\x2f94f', U'\x788c' },
  { U'\x2f950', U'\x78cc' },
  { U'\x2f951', U'\x40e3' },
  { U'\x2f952', U'\x25626' },
  { U'\x2f953', U'\x7956' },
  { U'\x2f954', U'\x2569a' },
  { U'\x2f955', U'\x256c5' },
  { U'\x2f956', U'\x798f' },
  { U'\x2f957', U'\x79eb' },
  { U'\x2f958', U'\x412f' },
  { U'\x2f959', U'\x7a40' },
  { U'\x2f95a', U'\x7a4a' },
  { U'\x2f95b', U'\x7a4f' },
  { U'\x2f95c', U'\x2597c' },
  { U'\x2f95d', U'\x25aa7' },
  { U'\x2f960', U'\x4202' },
  { U'\x2f961', U'\x25bab' },
  { U'\x2f962', U'\x7bc6' },
  { U'\x2f963', U'\x7bc9' },
  { U'\x2f964', U'\x4227' },
  { U'\x2f965', U'\x25c80' },
  { U'\x2f966', U'\x7cd2' },
  { U'\x2f967', U'\x42a0' },
  { U'\x2f968', U'\x7ce8' },
  { U'\x2f969', U'\x7ce3' },
  { U'\x2f96a', U'\x7d00' },
  { U'\x2f96b', U'\x25f86' },
  { U'\x2f96c', U'\x7d63' },
  { U'\x2f96d', U'\x4301' },
  { U'\x2f96e', U'\x7dc7' },
  { U'\x2f96f', U'\x7e02' },
  { U'\x2f970', U'\x7e45' },
  { U'\x2f971', U'\x4334' },
  { U'\x2f972', U'\x26228' },
  { U'\x2f973', U'\x26247' },
  { U'\x2f974', U'\x4359' },
  { U'\x2f975', U'\x262d9' },
  { U'\x2f976', U'\x7f7a' },
  { U'\x2f977', U'\x2633e' },
  { U'\x2f978', U'\x7f95' },
  { U'\x2f979', U'\x7ffa' },
  { U'\x2f97a', U'\x8005' },
  { U'\x2f97b', U'\x264da' },
  { U'\x2f97c', U'\x26523' },
  { U'\x2f97d', U'\x8060' },
  { U'\x2f97e', U'\x265a8' },
  { U'\x2f97f', U'\x8070' },
  { U'\x2f980', U'\x2335f' },
  { U'\x2f981', U'\x43d5' },
  { U'\x2f982', U'\x80b2' },
  { U'\x2f983', U'\x8103' },
  { U'\x2f984', U'\x440b' },
  { U'\x2f985', U'\x813e' },
  { U'\x2f986', U'\x5ab5' },
  { U'\x2f987', U'\x267a7' },
  { U'\x2f988', U'\x267b5' },
  { U'\x2f989', U'\x23393' },
  { U'\x2f98a', U'\x2339c' },
  { U'\x2f98b', U'\x8201' },
  { U'\x2f98c', U'\x8204' },
  { U'\x2f98d', U'\x8f9e' },
  { U'\x2f98e', U'\x446b' },
  { U'\x2f98f', U'\x8291' },
  { U'\x2f990', U'\x828b' },
  { U'\x2f991', U'\x829d' },
  { U'\x2f992', U'\x52b3' },
  { U'\x2f993', U'\x82b1' },
  { U'\x2f994', U'\x82b3' },
  { U'\x2f995', U'\x82bd' },
  { U'\x2f996', U'\x82e6' },
  { U'\x2f997', U'\x26b3c' },
  { U'\x2f998', U'\x82e5' },
  { U'\x2f999', U'\x831d' },
  { U'\x2f99a', U'\x8363' },
  { U'\x2f99b', U'\x83ad' },
  { U'\x2f99c', U'\x8323' },
  { U'\x2f99d', U'\x83bd' },
  { U'\x2f99e', U'\x83e7' },
  { U'\x2f99f', U'\x8457' },
  { U'\x2f9a0', U'\x8353' },
  { U'\x2f9a1', U'\x83ca' },
  { U'\x2f9a2', U'\x83cc' },
  { U'\x2f9a3', U'\x83dc' },
  { U'\x2f9a4', U'\x26c36' },
  { U'\x2f9a5', U'\x26d6b' },
  { U'\x2f9a6', U'\x26cd5' },
  { U'\x2f9a7', U'\x452b' },
  { U'\x2f9a8', U'\x84f1' },
  { U'\x2f9a9', U'\x84f3' },
  { U'\x2f9aa', U'\x8516' },
  { U'\x2f9ab', U'\x273ca' },
  { U'\x2f9ac', U'\x8564' },
  { U'\x2f9ad', U'\x26f2c' },
  { U'\x2f9ae', U'\x455d' },
  { U'\x2f9af', U'\x4561' },
  { U'\x2f9b0', U'\x26fb1' },
  { U'\x2f9b1', U'\x270d2' },
  { U'\x2f9b2', U'\x456b' },
  { U'\x2f9b3', U'\x8650' },
  { U'\x2f9b4', U'\x865c' },
  { U'\x2f9b5', U'\x8667' },
  { U'\x2f9b6', U'\x8669' },
  { U'\x2f9b7', U'\x86a9' },
  { U'\x2f9b8', U'\x8688' },
  { U'\x2f9b9', U'\x870e' },
  { U'\x2f9ba', U'\x86e2' },
  { U'\x2f9bb', U'\x8779' },
  { U'\x2f9bc', U'\x8728' },
  { U'\x2f9bd', U'\x876b' },
  { U'\x2f9be', U'\x8786' },
  { U'\x2f9c0', U'\x87e1' },
  { U'\x2f9c1', U'\x8801' },
  { U'\x2f9c2', U'\x45f9' },
  { U'\x2f9c3', U'\x8860' },
  { U'\x2f9c4', U'\x8863' },
  { U'\x2f9c5', U'\x27667' },
  { U'\x2f9c6', U'\x88d7' },
  { U'\x2f9c7', U'\x88de' },
  { U'\x2f9c8', U'\x4635' },
  { U'\x2f9c9', U'\x88fa' },
  { U'\x2f9ca', U'\x34bb' },
  { U'\x2f9cb', U'\x278ae' },
  { U'\x2f9cc', U'\x27966' },
  { U'\x2f9cd', U'\x46be' },
  { U'\x2f9ce', U'\x46c7' },
  { U'\x2f9cf', U'\x8aa0' },
  { U'\x2f9d0', U'\x8aed' },
  { U'\x2f9d1', U'\x8b8a' },
  { U'\x2f9d2', U'\x8c55' },
  { U'\x2f9d3', U'\x27ca8' },
  { U'\x2f9d4', U'\x8cab' },
  { U'\x2f9d5', U'\x8cc1' },
  { U'\x2f9d6', U'\x8d1b' },
  { U'\x2f9d7', U'\x8d77' },
  { U'\x2f9d8', U'\x27f2f' },
  { U'\x2f9d9', U'\x20804' },
  { U'\x2f9da', U'\x8dcb' },
  { U'\x2f9db', U'\x8dbc' },
  { U'\x2f9dc', U'\x8df0' },
  { U'\x2f9dd', U'\x208de' },
  { U'\x2f9de', U'\x8ed4' },
  { U'\x2f9df', U'\x8f38' },
  { U'\x2f9e0', U'\x285d2' },
  { U'\x2f9e1', U'\x285ed' },
  { U'\x2f9e2', U'\x9094' },
  { U'\x2f9e3', U'\x90f1' },
  { U'\x2f9e4', U'\x9111' },
  { U'\x2f9e5', U'\x2872e' },
  { U'\x2f9e6', U'\x911b' },
  { U'\x2f9e7', U'\x9238' },
  { U'\x2f9e8', U'\x92d7' },
  { U'\x2f9e9', U'\x92d8' },
  { U'\x2f9ea', U'\x927c' },
  { U'\x2f9eb', U'\x93f9' },
  { U'\x2f9ec', U'\x9415' },
  { U'\x2f9ed', U'\x28bfa' },
  { U'\x2f9ee', U'\x958b' },
  { U'\x2f9ef', U'\x4995' },
  { U'\x2f9f0', U'\x95b7' },
  { U'\x2f9f1', U'\x28d77' },
  { U'\x2f9f2', U'\x49e6' },
  { U'\x2f9f3', U'\x96c3' },
  { U'\x2f9f4', U'\x5db2' },
  { U'\x2f9f5', U'\x9723' },
  { U'\x2f9f6', U'\x29145' },
  { U'\x2f9f7', U'\x2921a' },
  { U'\x2f9f8', U'\x4a6e' },
  { U'\x2f9f9', U'\x4a76' },
  { U'\x2f9fa', U'\x97e0' },
  { U'\x2f9fb', U'\x2940a' },
  { U'\x2f9fc', U'\x4ab2' },
  { U'\x2f9fd', U'\x29496' },
  { U'\x2f9fe', U'\x980b' },
  { U'\x2fa00', U'\x9829' },
  { U'\x2fa01', U'\x295b6' },
  { U'\x2fa02', U'\x98e2' },
  { U'\x2fa03', U'\x4b33' },
  { U'\x2fa04', U'\x9929' },
  { U'\x2fa05', U'\x99a7' },
  { U'\x2fa06', U'\x99c2' },
  { U'\x2fa07', U'\x99fe' },
  { U'\x2fa08', U'\x4bce' },
  { U'\x2fa09', U'\x29b30' },
  { U'\x2fa0a', U'\x9b12' },
  { U'\x2fa0b', U'\x9c40' },
  { U'\x2fa0c', U'\x9cfd' },
  { U'\x2fa0d', U'\x4cce' },
  { U'\x2fa0e', U'\x4ced' },
  { U'\x2fa0f', U'\x9d67' },
  { U'\x2fa10', U'\x2a0ce' },
  { U'\x2fa11', U'\x4cf8' },
  { U'\x2fa12', U'\x2a105' },
  { U'\x2fa13', U'\x2a20e' },
  { U'\x2fa14', U'\x2a291' },
  { U'\x2fa15', U'\x9ebb' },
  { U'\x2fa16', U'\x4d56' },
  { U'\x2fa17', U'\x9ef9' },
  { U'\x2fa18', U'\x9efe' },
  { U'\x2fa19', U'\x9f05' },
  { U'\x2fa1a', U'\x9f0f' },
  { U'\x2fa1b', U'\x9f16' },
  { U'\x2fa1c', U'\x9f3b' },
  { U'\x2fa1d', U'\x2a600' },
}};
}  // namespace

auto map_code_point(char32_t code_point) -> char32_t {
  constexpr static auto less = [](const auto &lhs, auto rhs) {
    return lhs.code_point < rhs;
  };
  
  if (code_point <= U'\xffff') {
    return static_cast<char32_t>(map_code_point_16(static_cast<char16_t>(code_point)));
  }

  auto first = std::begin(mapped_32), last = std::end(mapped_32);
  auto it = std::lower_bound(first, last, code_point, less);
  return (it != last) ? it->mapped : code_point;
}
}  // namespace idna
}  // namespace v1
}  // namespace skyr
