One issue stemming from the ongoing bulk importation of bugs, patches,
pull requests and feature requests from sox.sf.net has gained particular
interest, in the area of convolution.

Someone suggested being able to convolve one audio signal with another.
The classic application of convolution is recording a spark gap discharge
in an audotorium, then "multiplying" that with a dry audio signal and
obtaining what the dry sound would have sounded like if it had been
played at the position of the spark gap, from the point of view of the
microphone(s).

The closest SoX come to this is that you can dump one signal in a text
file as values between -1 and +1, filter that to remove the first
column of timestamps and feed that to the `fir` effect,

sox INPUT_1 -t dat - | awk 'NR>2 { print $2 }' | sox INPUT_2 OUTPUT fir

which works but.

The issue is https://codeberg.org/sox_ng/sox_ng/issues/702
and the question is how to provide direct audio convolution,
as an alternative input file to "fir" or as a way of --combining
two audio inputs.

Another are that has attracted several feature requests and a patch
is the ability to apply filters, particularly the compands and equalizer,
to one channel or some channels but not others, either to rebalance the
channels differently (and being able to convolve with the recordings
made by the left and right microphones in a binaural dummy hear's ears
to make something that, listened to on headphones, really sounds like
you're there but I suppose a stereo convolve-each-channel-separately
could achieve that in combination with the first issue mentioned.
https://codeberg.org/sox_ng/sox_ng/issues/512

And spectrogram, everyone's favourite. Suggestions are:

* #517 being able to dump the phase information separately
* #703 having a longer automatic comment bottom left giving the parameters
  supplied to obtain that particular spectrogram
* #707 UTF-8 support in titles and comments, which implies real font support
* #713 waveform display instead of spectrographic
* #716 Adding an alpha channel to the PNG so that only peaks are visible
  so you can overlay the spectrogram's interesting parts over aomething
  else. In the issue on SourcForge, when I poked the image attachment,
  it overlaid the spectrogram peaks over the sourceforge page as a
  background (!) which really renders the idea!

I've dumped this message in a wiki page so it puts links on the above issue #s
in case anyone wants to read or comment further on the above at
https://codeberg.org/sox_ng/sox_ng/wiki/MSG-2025-11-28

Input is welcome as to how the user interface to these things should be

Onward!

    M
