# cut

> Вырезать поля из стандартного ввода или файлов.
> Больше информации: <https://www.gnu.org/software/coreutils/manual/html_node/cut-invocation.html>.

- Вывести пятый символ каждой строки:

`{{команда}} | cut {{[-c|--characters]}} 5`

- Вывести с 5-го по 10-й символ каждой строки указанного файла:

`cut {{[-c|--characters]}} 5-10 {{путь/к/файлу}}`

- Разбить каждую строку в файле по разделителю на поля и вывести 2-е и 6-е поле (разделитель по умолчанию — `TAB`):

`cut {{[-f|--fields]}} 2,6 {{путь/к/файлу}}`

- Разбить каждую строку по указанному разделителю и вывести всё, начиная со 2-го поля:

`{{команда}} | cut {{[-d|--delimiter]}} "{{разделитель}}" {{[-f|--fields]}} 2-`

- Использовать пробел в качестве разделителя и вывести только первые 3 поля:

`{{команда}} | cut {{[-d|--delimiter]}} " " {{[-f|--fields]}} -3`

- Не выводить строки, не содержащие разделитель:

`{{команда}} | cut {{[-d|--delimiter]}} "{{:}}" {{[-f|--fields]}} {{1}} {{[-s|--only-delimited]}}`

- Вывести определённые поля строк, оканчивающихся на `NUL` вместо символа новой строки:

`{{find . -print0}} | cut {{[-z|--zero-terminated]}} {{[-d|--delimiter]}} "{{/}}" {{[-f|--fields]}} {{2}}`
