# docker image save

> Export Docker images to archive.
> More information: <https://docs.docker.com/reference/cli/docker/image/save/>.

- Save an image by redirecting `stdout` to a `.tar` archive:

`docker {{[save|image save]}} {{image}}:{{tag}} > {{path/to/file.tar}}`

- Save an image to a `.tar` archive:

`docker {{[save|image save]}} {{[-o|--output]}} {{path/to/file.tar}} {{image}}:{{tag}}`

- Save all tags of the image:

`docker {{[save|image save]}} {{[-o|--output]}} {{path/to/file.tar}} {{image_name}}`

- Cherry-pick particular tags of an image to save:

`docker {{[save|image save]}} {{[-o|--output]}} {{path/to/file.tar}} {{image_name:tag1 image_name:tag2 ...}}`
