/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * A type-safe enum for tool-related errors.
 */
export var ToolErrorType;
(function (ToolErrorType) {
    // General Errors
    ToolErrorType["INVALID_TOOL_PARAMS"] = "invalid_tool_params";
    ToolErrorType["UNKNOWN"] = "unknown";
    ToolErrorType["UNHANDLED_EXCEPTION"] = "unhandled_exception";
    ToolErrorType["TOOL_NOT_REGISTERED"] = "tool_not_registered";
    ToolErrorType["EXECUTION_FAILED"] = "execution_failed";
    // File System Errors
    ToolErrorType["FILE_NOT_FOUND"] = "file_not_found";
    ToolErrorType["FILE_WRITE_FAILURE"] = "file_write_failure";
    ToolErrorType["READ_CONTENT_FAILURE"] = "read_content_failure";
    ToolErrorType["ATTEMPT_TO_CREATE_EXISTING_FILE"] = "attempt_to_create_existing_file";
    ToolErrorType["FILE_TOO_LARGE"] = "file_too_large";
    ToolErrorType["PERMISSION_DENIED"] = "permission_denied";
    ToolErrorType["NO_SPACE_LEFT"] = "no_space_left";
    ToolErrorType["TARGET_IS_DIRECTORY"] = "target_is_directory";
    // Edit-specific Errors
    ToolErrorType["EDIT_PREPARATION_FAILURE"] = "edit_preparation_failure";
    ToolErrorType["EDIT_NO_OCCURRENCE_FOUND"] = "edit_no_occurrence_found";
    ToolErrorType["EDIT_EXPECTED_OCCURRENCE_MISMATCH"] = "edit_expected_occurrence_mismatch";
    ToolErrorType["EDIT_NO_CHANGE"] = "edit_no_change";
})(ToolErrorType || (ToolErrorType = {}));
//# sourceMappingURL=tool-error.js.map