/*--------------------------------------------------------------------------*/
/* Copyright 2020-2021, 2023 NXP                                            */
/*                                                                          */
/* NXP Proprietary. This software is owned or controlled by NXP and may     */
/* only be used strictly in accordance with the applicable license terms.   */
/* By expressly accepting such terms or by downloading, installing,         */
/* activating and/or otherwise using the software, you are agreeing that    */
/* you have read, and that you agree to comply with and are bound by, such  */
/* license terms.  If you do not agree to be bound by the applicable        */
/* license terms, then you may not retain, install, activate or otherwise   */
/* use the software.                                                        */
/*--------------------------------------------------------------------------*/

/**
 * @file  mcuxClMemory.h
 * @brief Top-level include file for the memory operations.
 *
 * @defgroup mcuxClMemory mcuxClMemory
 * @brief Basic memory operations
 *
 * This component provides memory functions similar to the ones found in the C standard library.
 *
 * @{
 */

#ifndef MCUXCLMEMORY_H
#define MCUXCLMEMORY_H

#include <mcuxClConfig.h> // Exported features flags header
#include <mcuxCsslFlowProtection.h>
#include <mcuxClCore_FunctionIdentifiers.h>
#include <mcuxClMemory_Constants.h>
#include <mcuxClMemory_Types.h>
#include <mcuxClMemory_Endianness.h>
#include <mcuxClMemory_Clear.h>
#include <mcuxClMemory_Copy.h>
#include <mcuxClMemory_Copy_Reversed.h>
#include <mcuxClMemory_Set.h>
#include <mcuxClMemory_Xor.h>

/**
 * @}
 */
#endif
