#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawgetboundingbox_ PETSCDRAWGETBOUNDINGBOX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawgetboundingbox_ petscdrawgetboundingbox
#endif
PETSC_EXTERN void petscdrawgetboundingbox_(PetscDraw *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = PetscDrawGetBoundingBox(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawgetcurrentpoint_ PETSCDRAWGETCURRENTPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawgetcurrentpoint_ petscdrawgetcurrentpoint
#endif
PETSC_EXTERN void petscdrawgetcurrentpoint_(PetscDraw *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscDrawGetCurrentPoint(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawsetcurrentpoint_ PETSCDRAWSETCURRENTPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawsetcurrentpoint_ petscdrawsetcurrentpoint
#endif
PETSC_EXTERN void petscdrawsetcurrentpoint_(PetscDraw *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = PetscDrawSetCurrentPoint(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawpushcurrentpoint_ PETSCDRAWPUSHCURRENTPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawpushcurrentpoint_ petscdrawpushcurrentpoint
#endif
PETSC_EXTERN void petscdrawpushcurrentpoint_(PetscDraw *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = PetscDrawPushCurrentPoint(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawpopcurrentpoint_ PETSCDRAWPOPCURRENTPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawpopcurrentpoint_ petscdrawpopcurrentpoint
#endif
PETSC_EXTERN void petscdrawpopcurrentpoint_(PetscDraw *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawPopCurrentPoint(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawline_ PETSCDRAWLINE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawline_ petscdrawline
#endif
PETSC_EXTERN void petscdrawline_(PetscDraw *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, int *f, PetscErrorCode *ierr)
{
  *ierr = PetscDrawLine(*a, *b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawarrow_ PETSCDRAWARROW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawarrow_ petscdrawarrow
#endif
PETSC_EXTERN void petscdrawarrow_(PetscDraw *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, int *f, PetscErrorCode *ierr)
{
  *ierr = PetscDrawArrow(*a, *b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlinesetwidth_ PETSCDRAWLINESETWIDTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlinesetwidth_ petscdrawlinesetwidth
#endif
PETSC_EXTERN void petscdrawlinesetwidth_(PetscDraw *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawLineSetWidth(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawlinegetwidth_ PETSCDRAWLINEGETWIDTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawlinegetwidth_ petscdrawlinegetwidth
#endif
PETSC_EXTERN void petscdrawlinegetwidth_(PetscDraw *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = PetscDrawLineGetWidth(*a, b);
  if (*ierr) return;
}
