#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgethomedirectory_ PETSCGETHOMEDIRECTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgethomedirectory_ petscgethomedirectory
#endif
PETSC_EXTERN void petscgethomedirectory_(char a[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  *ierr = PetscGetHomeDirectory(a, l_a);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, a, l_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfixfilename_ PETSCFIXFILENAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfixfilename_ petscfixfilename
#endif
PETSC_EXTERN void petscfixfilename_(char a[], char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscFixFilename(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
