#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionscreate_ PETSCOPTIONSCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionscreate_ petscoptionscreate
#endif
PETSC_EXTERN void petscoptionscreate_(PetscOptions *a, PetscErrorCode *ierr)
{
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(a);
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscOptionsCreate(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsdestroy_ PETSCOPTIONSDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsdestroy_ petscoptionsdestroy
#endif
PETSC_EXTERN void petscoptionsdestroy_(PetscOptions *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscOptionsDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionscreatedefault_ PETSCOPTIONSCREATEDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionscreatedefault_ petscoptionscreatedefault
#endif
PETSC_EXTERN void petscoptionscreatedefault_(PetscErrorCode *ierr)
{
  *ierr = PetscOptionsCreateDefault();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionspush_ PETSCOPTIONSPUSH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionspush_ petscoptionspush
#endif
PETSC_EXTERN void petscoptionspush_(PetscOptions *a, PetscErrorCode *ierr)
{
  *ierr = PetscOptionsPush(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionspop_ PETSCOPTIONSPOP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionspop_ petscoptionspop
#endif
PETSC_EXTERN void petscoptionspop_(PetscErrorCode *ierr)
{
  *ierr = PetscOptionsPop();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsdestroydefault_ PETSCOPTIONSDESTROYDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsdestroydefault_ petscoptionsdestroydefault
#endif
PETSC_EXTERN void petscoptionsdestroydefault_(PetscErrorCode *ierr)
{
  *ierr = PetscOptionsDestroyDefault();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsvalidkey_ PETSCOPTIONSVALIDKEY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsvalidkey_ petscoptionsvalidkey
#endif
PETSC_EXTERN void petscoptionsvalidkey_(char a[], PetscBool *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscOptionsValidKey(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsinsertstring_ PETSCOPTIONSINSERTSTRING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsinsertstring_ petscoptionsinsertstring
#endif
PETSC_EXTERN void petscoptionsinsertstring_(PetscOptions *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscOptionsInsertString(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsinsertfile_ PETSCOPTIONSINSERTFILE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsinsertfile_ petscoptionsinsertfile
#endif
PETSC_EXTERN void petscoptionsinsertfile_(MPI_Fint *a, PetscOptions *b, char c[], PetscBool *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscOptionsInsertFile(MPI_Comm_f2c(*(a)), *b, c_c, *d ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsview_ PETSCOPTIONSVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsview_ petscoptionsview
#endif
PETSC_EXTERN void petscoptionsview_(PetscOptions *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscOptionsView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionslefterror_ PETSCOPTIONSLEFTERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionslefterror_ petscoptionslefterror
#endif
PETSC_EXTERN void petscoptionslefterror_(PetscErrorCode *ierr)
{
  *ierr = PetscOptionsLeftError();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsprefixpush_ PETSCOPTIONSPREFIXPUSH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsprefixpush_ petscoptionsprefixpush
#endif
PETSC_EXTERN void petscoptionsprefixpush_(PetscOptions *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscOptionsPrefixPush(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsprefixpop_ PETSCOPTIONSPREFIXPOP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsprefixpop_ petscoptionsprefixpop
#endif
PETSC_EXTERN void petscoptionsprefixpop_(PetscOptions *a, PetscErrorCode *ierr)
{
  *ierr = PetscOptionsPrefixPop(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsclear_ PETSCOPTIONSCLEAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsclear_ petscoptionsclear
#endif
PETSC_EXTERN void petscoptionsclear_(PetscOptions *a, PetscErrorCode *ierr)
{
  *ierr = PetscOptionsClear(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionssetalias_ PETSCOPTIONSSETALIAS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionssetalias_ petscoptionssetalias
#endif
PETSC_EXTERN void petscoptionssetalias_(PetscOptions *a, char b[], char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscOptionsSetAlias(*a, c_b, c_c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionssetvalue_ PETSCOPTIONSSETVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionssetvalue_ petscoptionssetvalue
#endif
PETSC_EXTERN void petscoptionssetvalue_(PetscOptions *a, char b[], char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscOptionsSetValue(*a, c_b, c_c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsclearvalue_ PETSCOPTIONSCLEARVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsclearvalue_ petscoptionsclearvalue
#endif
PETSC_EXTERN void petscoptionsclearvalue_(PetscOptions *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscOptionsClearValue(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsfindpair_ PETSCOPTIONSFINDPAIR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsfindpair_ petscoptionsfindpair
#endif
PETSC_EXTERN void petscoptionsfindpair_(PetscOptions *a, char b[], char c[], char d[], PetscBool *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c, PETSC_FORTRAN_CHARLEN_T l_d)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  char* c_d = PETSC_NULLPTR;
  CHKFORTRANNULLBOOL(e);
  *ierr = PetscOptionsFindPair(*a, c_b, c_c, (const char **)&c_d, e);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
  *ierr = PetscStrncpy((char *)d, c_d, l_d);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, d, l_d);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsreject_ PETSCOPTIONSREJECT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsreject_ petscoptionsreject
#endif
PETSC_EXTERN void petscoptionsreject_(PetscOptions *a, char b[], char c[], char d[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c, PETSC_FORTRAN_CHARLEN_T l_d)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  *ierr = PetscOptionsReject(*a, c_b, c_c, c_d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
  FREECHAR(d, c_d);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionshashelp_ PETSCOPTIONSHASHELP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionshashelp_ petscoptionshashelp
#endif
PETSC_EXTERN void petscoptionshashelp_(PetscOptions *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscOptionsHasHelp(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionshasname_ PETSCOPTIONSHASNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionshasname_ petscoptionshasname
#endif
PETSC_EXTERN void petscoptionshasname_(PetscOptions *a, char b[], char c[], PetscBool *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscOptionsHasName(*a, c_b, c_c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsused_ PETSCOPTIONSUSED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsused_ petscoptionsused
#endif
PETSC_EXTERN void petscoptionsused_(PetscOptions *a, char b[], PetscBool *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscOptionsUsed(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsallused_ PETSCOPTIONSALLUSED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsallused_ petscoptionsallused
#endif
PETSC_EXTERN void petscoptionsallused_(PetscOptions *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscOptionsAllUsed(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsleft_ PETSCOPTIONSLEFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsleft_ petscoptionsleft
#endif
PETSC_EXTERN void petscoptionsleft_(PetscOptions *a, PetscErrorCode *ierr)
{
  *ierr = PetscOptionsLeft(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsmonitordefault_ PETSCOPTIONSMONITORDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsmonitordefault_ petscoptionsmonitordefault
#endif
PETSC_EXTERN void petscoptionsmonitordefault_(char a[], char b[], PetscOptionSource *c, void *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscOptionsMonitorDefault(c_a, c_b, *c, d);
  if (*ierr) return;
  FREECHAR(a, c_a);
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsstringtobool_ PETSCOPTIONSSTRINGTOBOOL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsstringtobool_ petscoptionsstringtobool
#endif
PETSC_EXTERN void petscoptionsstringtobool_(char a[], PetscBool *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscOptionsStringToBool(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsstringtoint_ PETSCOPTIONSSTRINGTOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsstringtoint_ petscoptionsstringtoint
#endif
PETSC_EXTERN void petscoptionsstringtoint_(char a[], PetscInt *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscOptionsStringToInt(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsstringtoreal_ PETSCOPTIONSSTRINGTOREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsstringtoreal_ petscoptionsstringtoreal
#endif
PETSC_EXTERN void petscoptionsstringtoreal_(char a[], PetscReal *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLREAL(b);
  *ierr = PetscOptionsStringToReal(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsstringtoscalar_ PETSCOPTIONSSTRINGTOSCALAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsstringtoscalar_ petscoptionsstringtoscalar
#endif
PETSC_EXTERN void petscoptionsstringtoscalar_(char a[], PetscScalar *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLSCALAR(b);
  *ierr = PetscOptionsStringToScalar(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsgetbool_ PETSCOPTIONSGETBOOL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsgetbool_ petscoptionsgetbool
#endif
PETSC_EXTERN void petscoptionsgetbool_(PetscOptions *a, char b[], char c[], PetscBool *d, PetscBool *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLBOOL(d);
  CHKFORTRANNULLBOOL(e);
  *ierr = PetscOptionsGetBool(*a, c_b, c_c, d, e);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsgetbool3_ PETSCOPTIONSGETBOOL3
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsgetbool3_ petscoptionsgetbool3
#endif
PETSC_EXTERN void petscoptionsgetbool3_(PetscOptions *a, char b[], char c[], PetscBool3 *d, PetscBool *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLBOOL(e);
  *ierr = PetscOptionsGetBool3(*a, c_b, c_c, d, e);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsgetint_ PETSCOPTIONSGETINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsgetint_ petscoptionsgetint
#endif
PETSC_EXTERN void petscoptionsgetint_(PetscOptions *a, char b[], char c[], PetscInt *d, PetscBool *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLBOOL(e);
  *ierr = PetscOptionsGetInt(*a, c_b, c_c, d, e);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsgetmpiint_ PETSCOPTIONSGETMPIINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsgetmpiint_ petscoptionsgetmpiint
#endif
PETSC_EXTERN void petscoptionsgetmpiint_(PetscOptions *a, char b[], char c[], PetscMPIInt *d, PetscBool *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLBOOL(e);
  *ierr = PetscOptionsGetMPIInt(*a, c_b, c_c, d, e);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsgetreal_ PETSCOPTIONSGETREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsgetreal_ petscoptionsgetreal
#endif
PETSC_EXTERN void petscoptionsgetreal_(PetscOptions *a, char b[], char c[], PetscReal *d, PetscBool *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLBOOL(e);
  *ierr = PetscOptionsGetReal(*a, c_b, c_c, d, e);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsgetscalar_ PETSCOPTIONSGETSCALAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsgetscalar_ petscoptionsgetscalar
#endif
PETSC_EXTERN void petscoptionsgetscalar_(PetscOptions *a, char b[], char c[], PetscScalar *d, PetscBool *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLSCALAR(d);
  CHKFORTRANNULLBOOL(e);
  *ierr = PetscOptionsGetScalar(*a, c_b, c_c, d, e);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsgetboolarray_ PETSCOPTIONSGETBOOLARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsgetboolarray_ petscoptionsgetboolarray
#endif
PETSC_EXTERN void petscoptionsgetboolarray_(PetscOptions *a, char b[], char c[], PetscBool d[], PetscInt *e, PetscBool *f, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLBOOL(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLBOOL(f);
  *ierr = PetscOptionsGetBoolArray(*a, c_b, c_c, d, e, f);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsgetintarray_ PETSCOPTIONSGETINTARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsgetintarray_ petscoptionsgetintarray
#endif
PETSC_EXTERN void petscoptionsgetintarray_(PetscOptions *a, char b[], char c[], PetscInt d[], PetscInt *e, PetscBool *f, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLBOOL(f);
  *ierr = PetscOptionsGetIntArray(*a, c_b, c_c, d, e, f);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsgetrealarray_ PETSCOPTIONSGETREALARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsgetrealarray_ petscoptionsgetrealarray
#endif
PETSC_EXTERN void petscoptionsgetrealarray_(PetscOptions *a, char b[], char c[], PetscReal d[], PetscInt *e, PetscBool *f, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLBOOL(f);
  *ierr = PetscOptionsGetRealArray(*a, c_b, c_c, d, e, f);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscoptions.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscoptionsgetscalararray_ PETSCOPTIONSGETSCALARARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscoptionsgetscalararray_ petscoptionsgetscalararray
#endif
PETSC_EXTERN void petscoptionsgetscalararray_(PetscOptions *a, char b[], char c[], PetscScalar d[], PetscInt *e, PetscBool *f, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLSCALAR(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLBOOL(f);
  *ierr = PetscOptionsGetScalarArray(*a, c_b, c_c, d, e, f);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
