#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawaxiscreate_ PETSCDRAWAXISCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawaxiscreate_ petscdrawaxiscreate
#endif
PETSC_EXTERN void petscdrawaxiscreate_(PetscDraw *a, PetscDrawAxis *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDrawAxisCreate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawaxisdestroy_ PETSCDRAWAXISDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawaxisdestroy_ petscdrawaxisdestroy
#endif
PETSC_EXTERN void petscdrawaxisdestroy_(PetscDrawAxis *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscDrawAxisDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawaxissetcolors_ PETSCDRAWAXISSETCOLORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawaxissetcolors_ petscdrawaxissetcolors
#endif
PETSC_EXTERN void petscdrawaxissetcolors_(PetscDrawAxis *a, int *b, int *c, int *d, PetscErrorCode *ierr)
{
  *ierr = PetscDrawAxisSetColors(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawaxissetlabels_ PETSCDRAWAXISSETLABELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawaxissetlabels_ petscdrawaxissetlabels
#endif
PETSC_EXTERN void petscdrawaxissetlabels_(PetscDrawAxis *a, char b[], char c[], char d[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c, PETSC_FORTRAN_CHARLEN_T l_d)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  *ierr = PetscDrawAxisSetLabels(*a, c_b, c_c, c_d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
  FREECHAR(d, c_d);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawaxissetlimits_ PETSCDRAWAXISSETLIMITS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawaxissetlimits_ petscdrawaxissetlimits
#endif
PETSC_EXTERN void petscdrawaxissetlimits_(PetscDrawAxis *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  *ierr = PetscDrawAxisSetLimits(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawaxisgetlimits_ PETSCDRAWAXISGETLIMITS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawaxisgetlimits_ petscdrawaxisgetlimits
#endif
PETSC_EXTERN void petscdrawaxisgetlimits_(PetscDrawAxis *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = PetscDrawAxisGetLimits(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawaxissetholdlimits_ PETSCDRAWAXISSETHOLDLIMITS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawaxissetholdlimits_ petscdrawaxissetholdlimits
#endif
PETSC_EXTERN void petscdrawaxissetholdlimits_(PetscDrawAxis *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscDrawAxisSetHoldLimits(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawaxisdraw_ PETSCDRAWAXISDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawaxisdraw_ petscdrawaxisdraw
#endif
PETSC_EXTERN void petscdrawaxisdraw_(PetscDrawAxis *a, PetscErrorCode *ierr)
{
  *ierr = PetscDrawAxisDraw(*a);
  if (*ierr) return;
}
