#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdacreate1d_ DMDACREATE1D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdacreate1d_ dmdacreate1d
#endif
PETSC_EXTERN void dmdacreate1d_(MPI_Fint *a, DMBoundaryType *b, PetscInt *c, PetscInt *d, PetscInt *e, const PetscInt f[], DM *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = DMDACreate1d(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
